<?php

namespace App\Controllers;

use App\Models\Auto_model;
use App\Models\Delete_model;
use App\Models\Model_git;
use App\Models\Save_model;
use App\Models\Master_model;

class Accounting extends BaseController
{
  public function __construct()
  {
    $session = session();
    date_default_timezone_set('Asia/Jakarta');
  }
  public function index()
  {
    $_SESSION['com_menu'] = '';
    $_SESSION['com_men1'] = '';
    $_SESSION['com_men2'] = '';
  }
  public function Jurnalumum()
  {
    $model = new Model_git();
    $_SESSION['com_menu'] = '06';
    $_SESSION['com_men1'] = '0601';
    $_SESSION['com_men2'] = '';
    $tanggal = date('Y/m/d');
    $cabang  = session()->get('kode_cabang');
    $data['v_jurnalumum']  = $model->_get_jurnal($tanggal, $cabang)->getResult();
    return view('accounting/jurnal/jurnal_list', $data);
  }


  public function adjurnalumum()
  {
    // $model = new Model_git();
    // $data['v_kas']  = $model->_get_adcashout()->getResult();
    $_SESSION['com_menu'] = '06';
    $_SESSION['com_men1'] = '0601';
    $_SESSION['com_men2'] = '';
    $tanggal = date('Y-m-d');
    $data['hariini'] = $tanggal;
    return view('accounting/jurnal/jurnal_add', $data);
  }

  public function editjurnalumum($id)
  {
    $model = new Model_git();
    $_SESSION['com_menu'] = '06';
    $_SESSION['com_men1'] = '0601';
    $_SESSION['com_men2'] = '';
    $data['v_jurnalumum']  = $model->_get_edjurnalumum($id)->getResult();
    $data['account'] = $model->_get_account()->getResult();
    $data['costcenter'] = $model->_get_costcenter()->getResult();
    return view('accounting/jurnal/jurnal_edit', $data);
  }

  public function cetakjurnal()
  {
    $model = new Model_git();
    $id = $this->request->getPost('trx_code');
    $data['v_jurnalumum']  = $model->_get_edjurnalumum($id)->getResult();
    return view('accounting/jurnal/printjurnal', $data);
  }

  public function deletejurnal($id)
  {
    $model = new Delete_model();

    // $id = $this->request->getPost('code');

    $model->m_deletejurnalhdr($id);
    $model->_deletejurnaldtl($id);
    $model->_deletejurnal($id);
    return redirect()->to('accounting/Jurnalumum')->with('success', 'Hapus Data Berhasil');
  }
  public function deletehurnalulang()
  {
    $model = new Delete_model();

    $id = $this->request->getPost('code');

    $model->m_deletejrnulanghdr($id);
    $model->m_deletejrnulangdl($id);
    return redirect()->to('accounting/Jurnalulang')->with('success', 'Hapus Data Berhasil');
  }
  public function coa()
  {
    $model = new Model_git();
    $_SESSION['com_menu'] = '06';
    $_SESSION['com_men1'] = '0601';
    $_SESSION['com_men2'] = '060103';

    $data['v_coa']  = $model->_get_coa()->getResult();
    return view('accounting/coa/coa_list', $data);
  }

  public function addcoa($id)
  {
    $model = new Model_git();
    $_SESSION['com_menu'] = '06';
    $_SESSION['com_men1'] = '0601';
    $_SESSION['com_men2'] = '060103';

    $data['v_coa']  = $model->_get_coa1($id)->getResult();
    $data['v_coa1']  = $model->_get_coa2($id)->getResult();
    $data['acccode'] = $id;

    return view('accounting/coa/coa_add', $data);
  }

  public function editcoa($id)
  {
    $model = new Model_git();
    $_SESSION['com_menu'] = '06';
    $_SESSION['com_men1'] = '0601';
    $_SESSION['com_men2'] = '060103';
    $data['v_coa']  = $model->_get_coaedit($id)->getResult();
    return view('accounting/coa/coa_edit', $data);
  }

  public function saldoawal()
  {
    $model = new Model_git();
    $data['v_saldoawal']  = $model->_get_saldoawal()->getResult();
    return view('accounting/saldoawal/saldoawal_list', $data);
  }

  public function addsaldoawal()
  {
    $model = new Master_model();
    $tanggal = date('Y-m-d');
    $data['hariini'] = $tanggal;
    $data['v_account']  = $model->_get_account()->getResult();
    return view('accounting/saldoawal/saldoawal_add', $data);
  }
  public function editsaldoawal($id)
  {
    $model = new Master_model();
    $model1 = new Model_git();
    $data['v_account']  = $model->_get_account()->getResult();
    $data['v_saldoawal']  = $model1->_get_editsaldoawal($id)->getResult();
    return view('accounting/saldoawal/saldoawal_edit', $data);
  }

  public function savesaldoawal()
  {
    $model = new Save_model();
    $modcek = new Auto_model();
    $datagl = $modcek->get_datagl();
    $tanggal = $datagl['cut_date'];
    $bulan = date('m', strtotime($tanggal));
    $tahun = date('Y', strtotime($tanggal));
    $jumlah = str_replace(',', '', $this->request->getPost('acc_akhc'));
    $data = array(

      'acc_code'       => $this->request->getPost('acc_code'),
      'acc_date'       => $tanggal,
      'acc_buln'       => $bulan,
      'acc_tahn'       => $tahun,
      'acc_awhc'       => $jumlah,
      'acc_dbhc'       => 0,
      'acc_crhc'       => 0,
      'acc_akhc'       => $jumlah,
      'acc_type'       => 'AWL',
    );

    $model->_savesaldoawal($data);
    return redirect()->to('accounting/saldoawal')->with('success', 'Tambah Data Berhasil');
  }

  public function updatesaldoawal()
  {
    $model = new Save_model();

    $id = $this->request->getPost('acc_code');

    $jumlah = str_replace(',', '', $this->request->getPost('acc_akhc'));
    $data = array(

      'acc_akhc'       => $jumlah,
      'acc_type'       => 'AWL',
    );

    $model->_updatesaldoawal($data, $id);
    return redirect()->to('accounting/saldoawal')->with('success', 'Merubah Data Berhasil');
  }

  public function deletesaldoawal($id)
  {
    $model = new Delete_model();
    $model->_deletesaldoawal($id);
    return redirect()->to('accounting/saldoawal')->with('success', 'Hapus Data Berhasil');
  }
  public function Savejurnal()
  {

    $model = new Save_model();
    $modecek = new Auto_model();
    $tanggal = $this->request->getPost('trx_date');
    $bulan = date('m', strtotime($tanggal));
    $tahun = date('Y', strtotime($tanggal));
    $cek = $modecek->get_nojurnal($bulan, $tahun);
    if ($bulan < 10) {
      $bulan1 = '0' . $bulan;
    } else {
      $bulan1 = $bulan;
    }

    $nourut = $cek['trx_srno'];
    if ($nourut == '') {
      $nourut = 1;
      $v_trx_code = '08.' . $tahun . $bulan . '00001';
    } else {
      $nourut = $nourut + 1;
      if ($nourut < 10) {
        $v_trx_code = '08.' . $tahun . $bulan . '0000' . $nourut;
      } else if ($nourut >= 10 and $nourut < 100) {
        $v_trx_code = '08.' . $tahun . $bulan . '000' . $nourut;
      } else if ($nourut >= 100 and $nourut < 1000) {
        $v_trx_code = '08.' . $tahun . $bulan . '00' . $nourut;
      } else if ($nourut >= 1000 and $nourut < 10000) {
        $v_trx_code = '08.' . $tahun . $bulan . '0' . $nourut;
      } else {
        $v_trx_code = '08.' . $tahun . $bulan . $nourut;
      }
    }

    $trx_debt = str_replace(',', '', $this->request->getPost('trx_debt'));
    $trx_crdt = str_replace(',', '', $this->request->getPost('trx_crdt'));
    $trx_blan = str_replace(',', '', $this->request->getPost('trx_blan'));

    $data = array(
      'trx_code'       => $v_trx_code, // $this->request->getPost('trx_code'),
      'trx_date'       => $this->request->getPost('trx_date'),
      'rec_code'       => $this->request->getPost('rec_code'),
      'trx_desc'       => $this->request->getPost('trx_desc'),
      'trx_debt'       => $trx_debt,
      'trx_crdt'       => $trx_debt,
      'trx_blan'       => $trx_blan,
      'trx_buln'       => $bulan,
      'trx_tahn'       => $tahun,
      'trx_srno'       => $nourut,
      'kode_cabang'    => session()->get('kode_cabang'),
    );

    $model->_savejurnalhdr($data);

    $id = 1;
    $kode = $_POST['acc_code'];
    $jumlah = count($kode);


    for ($x = 0; $x < $jumlah; $x++) {

      //  $kode=$this->request->getPost('knt_code['.$x.']');
      if ($kode != '') {
        $vdbt_amnt = str_replace(',', '', $this->request->getPost('dbttotl[' . $x . ']'));
        $vcrd_amnt = str_replace(',', '', $this->request->getPost('crdtotl[' . $x . ']'));
        $data = array(
          'trx_code' => $v_trx_code, //$this->request->getPost('trx_code'),
          'acc_code' => $this->request->getPost('acc_code[' . $x . ']'),
          'acc_idno' => $this->request->getPost('acc_code[' . $x . ']'),
          'trx_idno' => $x,
          'ref_code'  => $this->request->getPost('ref_code[' . $x . ']'),
          'psb_code'  => $this->request->getPost('psb_code[' . $x . ']'),
          'dbt_amnt'  => $vdbt_amnt,
          'crd_amnt'  => $vcrd_amnt,


        );
        $model->_savejurnaldtl($data);

        // Jurnal Detil

        $trx_amnt = 0;
        if ($vdbt_amnt > $vcrd_amnt) {
          $trx_dbcr = "D";
          $trx_amnt = $vdbt_amnt;
        } else {
          $trx_dbcr = "K";
          $trx_amnt = $vcrd_amnt;
        }
        $data = array(
          'trx_code' => $v_trx_code, // $this->request->getPost('trx_code'),
          'trx_date' => $this->request->getPost('trx_date'),
          'trx_urut' => $x,
          'acc_code'  => $this->request->getPost('acc_code[' . $x . ']'),
          'trx_dbcr'  => $trx_dbcr,
          'trx_amnt'  => $trx_amnt,
          'dbt_amnt'  => $vdbt_amnt,
          'crd_amnt'  => $vcrd_amnt,
          'trx_des1'  => $this->request->getPost('trx_desc'),
          'trx_des2'  => $this->request->getPost('trx_desc'),
          'kode_cabang'    => session()->get('kode_cabang'),
        );
        $model->_savejurnal($data);
      }
    }

    return redirect()->to('accounting/Jurnalumum')->with('success', 'Tambah Data Berhasil');
  }


  public function updatejurnal()
  {
    $id = $this->request->getPost('trx_code');
    $model = new Save_model();
    $model1 = new Delete_model();
    $tanggal = $this->request->getPost('trx_date');
    $bulan = date('m', strtotime($tanggal));
    $tahun = date('Y', strtotime($tanggal));
    $trx_debt = str_replace(',', '', $this->request->getPost('trx_debt'));
    $trx_crdt = str_replace(',', '', $this->request->getPost('trx_crdt'));
    $trx_blan = str_replace(',', '', $this->request->getPost('trx_blan'));
    $data = array(

      'trx_date'       => $this->request->getPost('trx_date'),
      'rec_code'       => $this->request->getPost('rec_code'),
      'trx_desc'       => $this->request->getPost('trx_desc'),
      'trx_debt'       => $trx_debt,
      'trx_crdt'       => $trx_debt,
      'trx_blan'       => $trx_blan,
      'trx_buln'       => $bulan,
      'trx_tahn'       => $tahun,
      'kode_cabang'    => session()->get('kode_cabang'),
    );

    $model->_updatejurnalhdr($data, $id);
    $model1->_deletejurnaldtl($id);
    $model1->_deletejurnal($id);

    $id = 1;
    $kode = $_POST['acc_code'];
    $jumlah = count($kode);


    for ($x = 0; $x < $jumlah; $x++) {

      //  $kode=$this->request->getPost('knt_code['.$x.']');
      if ($kode != '') {
        $vdbt_amnt = str_replace(',', '', $this->request->getPost('dbttotl[' . $x . ']'));
        $vcrd_amnt = str_replace(',', '', $this->request->getPost('crdtotl[' . $x . ']'));
        $data = array(
          'trx_code' => $this->request->getPost('trx_code'),
          'acc_code' => $this->request->getPost('acc_code[' . $x . ']'),
          'acc_idno' => $this->request->getPost('acc_code[' . $x . ']'),
          'trx_idno' => $x,
          'ref_code'  => $this->request->getPost('ref_code[' . $x . ']'),
          'psb_code'  => $this->request->getPost('psb_code[' . $x . ']'),
          'dbt_amnt'  => $vdbt_amnt,
          'crd_amnt'  => $vcrd_amnt,


        );
        $model->_savejurnaldtl($data);

        // Jurnal Detil

        $trx_amnt = 0;
        if ($vdbt_amnt > $vcrd_amnt) {
          $trx_dbcr = "D";
          $trx_amnt = $vdbt_amnt;
        } else {
          $trx_dbcr = "K";
          $trx_amnt = $vcrd_amnt;
        }
        $data = array(
          'trx_code' => $this->request->getPost('trx_code'),
          'trx_date' => $this->request->getPost('trx_date'),
          'trx_urut' => $x,
          'acc_code'  => $this->request->getPost('acc_code[' . $x . ']'),
          'trx_dbcr'  => $trx_dbcr,
          'trx_amnt'  => $trx_amnt,
          'dbt_amnt'  => $vdbt_amnt,
          'crd_amnt'  => $vcrd_amnt,
          'trx_des1'  => $this->request->getPost('trx_desc'),
          'trx_des2'  => $this->request->getPost('trx_desc'),

        );
        $model->_savejurnal($data);
      }
    }

    return redirect()->to('accounting/Jurnalumum')->with('success', 'Merubah Data Berhasil');
  }

  public function savecoa()
  {
    $model = new Save_model();
    $v_acc_cod2 = 'A' . $this->request->getPost('acc_code');
    $data = array(
      'id'       => $this->request->getPost('acc_code'),
      'acc_code'       => $this->request->getPost('acc_code'),
      'acc_cod1'       => $this->request->getPost('acc_code'),
      'acc_cod2'       => $v_acc_cod2,
      'acc_name'       => $this->request->getPost('acc_name'),
      'acc_levl'       => $this->request->getPost('acc_levl'),
      'acc_klas'       => $this->request->getPost('acc_klas'),
      'acc_dtum'       => $this->request->getPost('acc_dtum'),
      'acc_nblc'       => $this->request->getPost('acc_nblc'),
      'acc_umum'       => $this->request->getPost('acc_umum'),
      'companyid'       => session()->get('kode_cabang'),
    );

    $model->_savecoa($data);
    return redirect()->to('accounting/coa')->with('success', 'Tambah Data Berhasil');
  }

  public function Updatecoa()
  {
    $model = new Save_model();
    $id = $this->request->getPost('acc_code');
    $data = array(

      'acc_name'       => $this->request->getPost('acc_name'),
      'acc_klas'       => $this->request->getPost('acc_klas'),
      'acc_dtum'       => $this->request->getPost('acc_dtum'),
      'acc_nblc'       => $this->request->getPost('acc_nblc'),
      'companyid'       => session()->get('kode_cabang'),
    );

    $model->_Updatecoa($data, $id);
    return redirect()->to('accounting/coa')->with('success', 'Merubah Data Berhasil');
  }


  public function deletecoa($id)
  {
    $model = new Delete_model();
    $model->m_deletecoa($id);
    return redirect()->to('accounting/coa')->with('success', 'Hapus Data Berhasil');
  }


  public function Jurnalulang()
  {
    $model = new Model_git();
    $data['v_jurnalulang']  = $model->_get_jurnalulang()->getResult();
    return view('accounting/recuring/recuring_list', $data);
  }


  public function adjurnalulang()
  {
    // $model = new Model_git();
    // $data['v_kas']  = $model->_get_adcashout()->getResult();
    return view('accounting/recuring/recuring_add');
  }

  public function edJurnalulang($id)
  {
    $model = new Model_git();
    $data['v_jurnalumum']  = $model->_get_edjurnalulang($id)->getResult();
    $data['account'] = $model->_get_account()->getResult();
    $data['costcenter'] = $model->_get_costcenter()->getResult();
    return view('accounting/recuring/recuring_edit', $data);
  }

  public function Savejurnalulang()
  {

    $model = new Save_model();
    $model1 = new delete_model();
    $trx_debt = str_replace(',', '', $this->request->getPost('jrc_debt'));
    $trx_crdt = str_replace(',', '', $this->request->getPost('jrc_crdt'));
    $trx_blan = str_replace(',', '', $this->request->getPost('jrc_blan'));
    $data = array(
      'jrc_code'       => $this->request->getPost('jrc_code'),
      'jrc_date'       => $this->request->getPost('jrc_date'),
      'jrc_desc'       => $this->request->getPost('jrc_desc'),
      'jrc_debt'       => $trx_debt,
      'jrc_crdt'       => $trx_debt,
      'jrc_blan'       => $trx_blan,
    );

    $model->_savejurnalulanghdr($data);

    $id = 1;
    $kode = $_POST['acc_code'];
    $jumlah = count($kode);


    for ($x = 0; $x < $jumlah; $x++) {

      //  $kode=$this->request->getPost('knt_code['.$x.']');
      if ($kode != '') {
        $vdbt_amnt = str_replace(',', '', $this->request->getPost('dbttotl[' . $x . ']'));
        $vcrd_amnt = str_replace(',', '', $this->request->getPost('crdtotl[' . $x . ']'));
        $data = array(
          'jrc_code' => $this->request->getPost('jrc_code'),
          'acc_code' => $this->request->getPost('acc_code[' . $x . ']'),
          'acc_idno' => $this->request->getPost('acc_code[' . $x . ']'),
          'jrc_idno' => $x,
          'psb_code'  => $this->request->getPost('psb_code[' . $x . ']'),
          'dbt_amnt'  => $vdbt_amnt,
          'crd_amnt'  => $vcrd_amnt,


        );
        $model->_savejurnalulangdtl($data);

        // Jurnal Detil
        // $vdbt_amnt = $this->request->getPost('dbt_totl[' . $x . ']');
        // $vcrd_amnt = $this->request->getPost('crd_totl[' . $x . ']');
        // $trx_amnt = 0;
        // if ($vdbt_amnt > $vcrd_amnt) {
        //   $trx_dbcr = "D";
        //   $trx_amnt = $vdbt_amnt;
        // } else {
        //   $trx_dbcr = "K";
        //   $trx_amnt = $vcrd_amnt;
        // }
        // $data = array(
        //   'trx_code' => $this->request->getPost('jrc_code'),
        //   'trx_date' => $this->request->getPost('jrc_date'),
        //   'trx_urut' => $x,
        //   'acc_code'  => $this->request->getPost('acc_code[' . $x . ']'),
        //   'trx_dbcr'  => $trx_dbcr,
        //   'trx_amnt'  => $trx_amnt,
        //   'dbt_amnt'  => $vdbt_amnt,
        //   'crd_amnt'  => $vcrd_amnt,
        //   'trx_des1'  => $this->request->getPost('trx_desc'),
        //   'trx_des2'  => $this->request->getPost('trx_desc'),

        // );
        // $model->_savejurnal($data);
      }
    }

    return redirect()->to('accounting/Jurnalulang')->with('success', 'Tambah Data Berhasil');
  }


  public function updatejurnalulang()
  {

    $model = new Save_model();
    $id = $this->request->getPost('jrc_code');
    $trx_debt = str_replace(',', '', $this->request->getPost('jrc_debt'));
    $trx_crdt = str_replace(',', '', $this->request->getPost('jrc_crdt'));
    $trx_blan = str_replace(',', '', $this->request->getPost('jrc_blan'));

    $data = array(
      'jrc_date'       => $this->request->getPost('jrc_date'),
      'jrc_desc'       => $this->request->getPost('jrc_desc'),
      'jrc_debt'       => $trx_debt,
      'jrc_crdt'       => $trx_debt,
      'jrc_blan'       => $trx_blan,

    );

    $model->_Updajurnalulanghdr($data, $id);


    $model1 = new Delete_model();
    $model1->m_deletejrnulangdl($id);
    $kode = $_POST['acc_code'];
    $jumlah = count($kode);


    for ($x = 0; $x < $jumlah; $x++) {

      //  $kode=$this->request->getPost('knt_code['.$x.']');
      if ($kode != '') {
        $vdbt_amnt = str_replace(',', '', $this->request->getPost('dbttotl[' . $x . ']'));
        $vcrd_amnt = str_replace(',', '', $this->request->getPost('crdtotl[' . $x . ']'));
        $data = array(
          'jrc_code' => $this->request->getPost('jrc_code'),
          'acc_code' => $this->request->getPost('acc_code[' . $x . ']'),
          'acc_idno' => $this->request->getPost('acc_code[' . $x . ']'),
          'jrc_idno' => $x,
          'psb_code'  => $this->request->getPost('psb_code[' . $x . ']'),
          'dbt_amnt'  => $vdbt_amnt,
          'crd_amnt'  => $vcrd_amnt,


        );
        $model->_savejurnalulangdtl($data);
      }
    }

    return redirect()->to('accounting/Jurnalulang')->with('success', 'Merubah Data Berhasil');
  }

  public function deletejurnalulang($id)
  {
    $model = new Delete_model();
    // $id = $this->request->getPost('code');
    $model->m_deletejrnulanghdr($id);
    $model->m_deletejrnulangdl($id);

    return redirect()->to('accounting/Jurnalulang')->with('success', 'Menghapus Data Berhasil');
  }

  //end
}
