<?php

namespace App\Controllers;

use App\Models\Auto_model;
use App\Models\Delete_model;
use App\Models\Asset_Model;
use App\Models\Save_model;
use App\Models\Master_model;

class Asset extends BaseController
{
    public function __construct()
    {
        $session = session();
    }
    public function index()
    {
        $_SESSION['com_menu'] = '';
        $_SESSION['com_men1'] = '';
        $_SESSION['com_men2'] = '';
    }
    public function pencatatan()
    {
        $model = new Asset_Model();
        $_SESSION['com_menu'] = '05';
        $_SESSION['com_men1'] = '';
        $_SESSION['com_men2'] = '';
        $data['v_jurnalumum']  = $model->_get_asset()->getResult();
        return view('asset/regristrasi/regristrasi_list', $data);
    }

    public function addasset()
    {
        $model = new Master_model();
        $_SESSION['com_menu'] = '05';
        $_SESSION['com_men1'] = '';
        $_SESSION['com_men2'] = '';
        $data['v_kelompok']  = $model->_get_kelompokasset()->getResult();
        $data['v_katagori']  = $model->_get_katagori()->getResult();
        $data['v_lokasi']  = $model->_get_lokasi()->getResult();
        $data['v_account']  = $model->_get_account()->getResult();
        return view('asset/regristrasi/regristrasi_add', $data);
    }

    public function editasset($id)
    {
        $mmaster = new Master_model();
        $model = new Asset_Model();
        $_SESSION['com_menu'] = '05';
        $_SESSION['com_men1'] = '';
        $_SESSION['com_men2'] = '';
        $data['v_kelompok']  = $mmaster->_get_kelompokasset()->getResult();
        $data['v_katagori']  = $mmaster->_get_katagori()->getResult();
        $data['v_lokasi']  = $mmaster->_get_lokasi()->getResult();
        $data['v_account']  = $mmaster->_get_account()->getResult();
        $data['v_data']  = $model->_get_editasset($id)->getResult();
        return view('asset/regristrasi/regristrasi_edit', $data);
    }

    public function saveasset()
    {
        $msave = new Save_model();
        $mauto = new Auto_model();
        $tanggal = $this->request->getPost('ast_date');


        $hargabeli = str_replace(',', '', $this->request->getPost('ast_nila'));
        $umur = str_replace(',', '', $this->request->getPost('ast_lvyr'));
        $bulan = date('m', strtotime($tanggal));
        $tahun = date('Y', strtotime($tanggal));
        $totbulan = $umur * 12;
        $tgljt1 = date('Y-m-d', strtotime('+' . $totbulan . 'month', strtotime($tanggal)));
        $cek = $mauto->get_noasset($bulan, $tahun);

        $nourut = $cek['ast_srno'];
        if ($nourut == '') {
            $nourut = 1;
            $v_trx_code = 'AST.' . $tahun . $bulan . '00001';
        } else {
            $nourut = $nourut + 1;
            if ($nourut < 10) {
                $v_trx_code = 'AST.' . $tahun . $bulan . '0000' . $nourut;
            } else if ($nourut >= 10 and $nourut < 100) {
                $v_trx_code = 'AST.' . $tahun . $bulan . '000' . $nourut;
            } else if ($nourut >= 100 and $nourut < 1000) {
                $v_trx_code = 'AST.' . $tahun . $bulan . '00' . $nourut;
            } else if ($nourut >= 1000 and $nourut < 10000) {
                $v_trx_code = 'AST.' . $tahun . $bulan . '0' . $nourut;
            } else {
                $v_trx_code = 'AST.' . $tahun . $bulan . $nourut;
            }
        }

        $data = array(
            'com_code' => 1,
            'ast_code' => $v_trx_code,
            'ast_date' => $this->request->getPost('ast_date'),
            'ast_tahn' => $tahun,
            'ast_buln' => $bulan,
            'ast_srno' => $nourut,
            'ast_name' => $this->request->getPost('ast_name'),
            'ast_meth' => $this->request->getPost('ast_metd'),
            'ast_grup' => $this->request->getPost('ast_grup'),
            'ast_type' => $this->request->getPost('ast_type'),
            'loc_code' => $this->request->getPost('loc_code'),
            'ast_nila' => $hargabeli,
            'ast_lvyr' => $umur,
            'acc_cod1' => $this->request->getPost('acc_cod1'),
            'acc_cod2' => $this->request->getPost('acc_cod2'),
            'acc_cod3' => $this->request->getPost('acc_cod3'),
            'ast_desc' => $this->request->getPost('ast_desc'),
            'ast_endt' => $tgljt1,
            // 'ast_desc' => $this->request->getPost('ast_desc'),

        );
        $msave->_saveasset($data);
        return redirect()->to('asset/pencatatan')->with('Sukses', 'Tambah Data Berhasil');
    }

    public function updateasset()
    {
        $msave = new Save_model();

        $id = $this->request->getPost('ast_code');
        $tanggal = $this->request->getPost('ast_date');
        $hargabeli = str_replace(',', '', $this->request->getPost('ast_nila'));
        $umur = str_replace(',', '', $this->request->getPost('ast_lvyr'));
        $totbulan = $umur * 12;
        $tgljt1 = date('Y-m-d', strtotime('+' . $totbulan . 'month', strtotime($tanggal)));


        $data = array(
            'com_code' => 1,
            'ast_date' => $this->request->getPost('ast_date'),
            'ast_name' => $this->request->getPost('ast_name'),
            'ast_meth' => $this->request->getPost('ast_metd'),
            'ast_grup' => $this->request->getPost('ast_grup'),
            'ast_type' => $this->request->getPost('ast_type'),
            'loc_code' => $this->request->getPost('loc_code'),
            'ast_nila' => $hargabeli,
            'ast_lvyr' => $umur,
            'acc_cod1' => $this->request->getPost('acc_cod1'),
            'acc_cod2' => $this->request->getPost('acc_cod2'),
            'acc_cod3' => $this->request->getPost('acc_cod3'),
            'ast_desc' => $this->request->getPost('ast_desc'),
            'ast_endt' => $tgljt1,

        );
        $msave->_updateasset($data, $id);
        return redirect()->to('asset/pencatatan')->with('Sukses', 'Tambah Data Berhasil');
    }
    public function deleteasset($id)
    {
        $model = new Delete_model();
        $model->m_deleteasset($id);

        return redirect()->to('asset/pencatatan')->with('success', 'Hapus Data Berhasil');
    }

    public function nilaibuku()
    {
        $model = new Asset_Model();
        $_SESSION['com_menu'] = '05';
        $_SESSION['com_men1'] = '';
        $_SESSION['com_men2'] = '';
        $data['v_jurnalumum']  = $model->_get_asset()->getResult();
        return view('asset/nilaibuku', $data);
    }

    public function kelompok()
    {
        $model = new Asset_Model();
        $_SESSION['com_menu'] = '05';
        $_SESSION['com_men1'] = '';
        $_SESSION['com_men2'] = '';
        $data['v_data']  = $model->_get_kelompokasset()->getResult();
        return view('asset/grup/grup_list', $data);
    }
    public function katagori()
    {
        $model = new Asset_Model();
        $_SESSION['com_menu'] = '05';
        $_SESSION['com_men1'] = '';
        $_SESSION['com_men2'] = '';
        $data['v_data']  = $model->_get_katagoriasset()->getResult();
        return view('asset/type/type_list', $data);
    }
    public function userasset()
    {
        $model = new Asset_Model();
        $_SESSION['com_menu'] = '05';
        $_SESSION['com_men1'] = '';
        $_SESSION['com_men2'] = '';
        $data['v_data']  = $model->_get_lokasiasset()->getResult();
        return view('asset/lokasi/lokasi_list', $data);
    }

    public function addkelompok()
    {

        $_SESSION['com_menu'] = '05';
        $_SESSION['com_men1'] = '';
        $_SESSION['com_men2'] = '';

        return view('asset/grup/grup_add');
    }
    public function editkelompok($id)
    {
        $model = new Asset_Model();
        $_SESSION['com_menu'] = '05';
        $_SESSION['com_men1'] = '';
        $_SESSION['com_men2'] = '';
        $data['v_data']  = $model->_get_edkelompokasset($id)->getResult();
        return view('asset/grup/grup_edit', $data);
    }

    public function savekelompok()
    {
        $model = new Save_model();
        $data = array(
            'ast_grup' => $this->request->getPost('ast_grup'),
            'ast_gnam' => $this->request->getPost('ast_gnam'),
            'ast_gumr' => $this->request->getPost('ast_gumr'),
        );
        $model->_savekelaset($data);
        return redirect()->to('asset/kelompok')->with('Sukses', 'Tambah Data Berhasil');
    }

    public function updatekelompok()
    {
        $model = new Save_model();
        $id = $this->request->getPost('ast_grup');
        $data = array(
            // 'ast_grup' => $this->request->getPost('ast_grup'),
            'ast_gnam' => $this->request->getPost('ast_gnam'),
            'ast_gumr' => $this->request->getPost('ast_gumr'),
        );
        $model->_updatekelasset($data, $id);
        return redirect()->to('asset/kelompok')->with('Sukses', 'Edit Data Berhasil');
    }

    public function deletekelompok($id)
    {
        $model = new Delete_model();
        $model->m_deletekelasset($id);
        return redirect()->to('asset/kelompok')->with('Sukses', 'Hapus Data Berhasil');
    }

    public function addkatagori()
    {
        $_SESSION['com_menu'] = '05';
        $_SESSION['com_men1'] = '';
        $_SESSION['com_men2'] = '';

        return view('asset/type/type_add');
    }
    public function editkatagori($id)
    {
        $model = new Asset_Model();
        $_SESSION['com_menu'] = '05';
        $_SESSION['com_men1'] = '';
        $_SESSION['com_men2'] = '';
        $data['v_data']  = $model->_get_edkatagoriasset($id)->getResult();
        return view('asset/type/type_edit', $data);
    }

    public function savekatagori()
    {
        $model = new Save_model();
        $data = array(
            'ast_type' => $this->request->getPost('ast_type'),
            'ast_tnam' => $this->request->getPost('ast_tnam'),
            'ast_tsts' => 'Y',
        );
        $model->_savekatagoriasset($data);
        return redirect()->to('asset/katagori')->with('Sukses', 'Tambah Data Berhasil');
    }

    public function updatekatagori()
    {
        $model = new Save_model();
        $id = $this->request->getPost('ast_type');
        $data = array(
            // 'ast_type' => $this->request->getPost('ast_grup'),
            'ast_tnam' => $this->request->getPost('ast_tnam'),
            'ast_tsts' => $this->request->getPost('ast_tsts'),
        );
        $model->_updatekatagoriasset($data, $id);
        return redirect()->to('asset/katagori')->with('Sukses', 'Edit Data Berhasil');
    }

    public function deletekatagori($id)
    {
        $model = new Delete_model();
        $model->m_deletekatasset($id);
        return redirect()->to('asset/katagori')->with('Sukses', 'Edit Data Berhasil');
    }

    public function adduserasset()
    {
        $_SESSION['com_menu'] = '05';
        $_SESSION['com_men1'] = '';
        $_SESSION['com_men2'] = '';

        return view('asset/lokasi/lokasi_add');
    }
    public function edituserasset($id)
    {
        $model = new Asset_Model();
        $_SESSION['com_menu'] = '05';
        $_SESSION['com_men1'] = '';
        $_SESSION['com_men2'] = '';
        $data['v_data']  = $model->_get_edlokasiasset($id)->getResult();
        return view('asset/lokasi/lokasi_edit', $data);
    }

    public function savelokasi()
    {
        $model = new Save_model();
        $data = array(
            'loc_code' => $this->request->getPost('loc_code'),
            'loc_name' => $this->request->getPost('loc_name'),
            'loc_stat' => 'Y',
        );
        $model->_savelokasiasset($data);
        return redirect()->to('asset/userasset')->with('Sukses', 'Tambah Data Berhasil');
    }

    public function updatelokasi()
    {
        $model = new Save_model();
        $id = $this->request->getPost('loc_code');
        $data = array(

            'loc_name' => $this->request->getPost('loc_name'),
            'loc_stat' => $this->request->getPost('loc_stat'),
        );
        $model->_updatelokasiasset($data, $id);
        return redirect()->to('asset/userasset')->with('Sukses', 'Edit Data Berhasil');
    }
    public function deleteuserasset($id)
    {
        $model = new Delete_model();
        $model->m_deletelokasiasset($id);
        return redirect()->to('asset/userasset')->with('Sukses', 'Edit Data Berhasil');
    }
}
