<?php

namespace App\Controllers;

use App\Models\Auto_model;
use App\Models\Delete_model;
use App\Models\Master_model;
use App\Models\Model_git;
use App\Models\Save_model;


class Cash extends BaseController
{
  public function __construct()
  {
    $session = session();
    date_default_timezone_set('Asia/Jakarta');
  }
  public function index()
  {
    $_SESSION['com_menu'] = '';
    $_SESSION['com_men1'] = '';
    $_SESSION['com_men2'] = '';
  }

  public function hapuskasumumcash()
  {
    $_SESSION['com_menu'] = '03';
    $_SESSION['com_men1'] = '030101';
  }
  public function cashout()
  {
    $model = new Model_git();
    $_SESSION['com_menu'] = '03';
    $_SESSION['com_men1'] = '0301';
    $tanggal = date('Y-m-d');
    $cabang  = session()->get('kode_cabang');
    if ($_SESSION['usr_jabt'] == 'Administrator') {
      $data['v_kas']  = $model->_get_cashoutn($tanggal)->getResult();
    } else {
      $data['v_kas']  = $model->_get_cashout($tanggal, $cabang)->getResult();
    }

    return view('kas/out/out_list', $data);
  }


  public function adcashout()
  {
    $model = new Model_git();
    $masmodel = new Master_model();
    $tanggal = date('Y-m-d');
    $data['tgl2'] = $tanggal;
    $cabang = session()->get('kode_cabang');
    $data['v_bank']  = $model->_getbank_cab($cabang)->getResult();
    $data['hariini'] = $tanggal;
    $data['v_trans'] = $masmodel->_transaksi()->getResult();

    return view('kas/out/out_add', $data);
  }



  public function edcashout($id)
  {
    $model = new Model_git();
    $masmodel = new Master_model();
    $data['v_kas']  = $model->_get_edcashout($id)->getResult();
    $cabang = session()->get('kode_cabang');
    $data['v_bank']  = $model->_getbank_cab($cabang)->getResult();
    $data['v_trans'] = $masmodel->_transaksi()->getResult();

    $data['v_detil']  = $model->_get_edcashout($id)->getResult();
    return view('kas/out/out_edit', $data);
  }

  public function hapuskasumum()
  {
    $model = new Model_git();
    $_SESSION['com_menu'] = '03';
    $_SESSION['com_men1'] = '0301';
    $_SESSION['com_men2'] = '030102';
    $tanggal1 = '01/01/0001';
    $tanggal2 = '01/01/0001';

    $data['v_kas']  = $model->_delkasumum($tanggal1, $tanggal2)->getResult();

    // $data['v_kas']  = $model->_get_cashout()->getResult();
    return view('kas/out/out_delete', $data);
  }
  public function delcashout($id)
  {
    $model = new Model_git();
    $model->_delcashout($id);
    return redirect()->to('cash/cashout')->with('success', 'Menghapus Data Berhasil');
  }

  public function savekasumum()
  {
    $model = new Save_model();
    $modecek = new Auto_model();
    $tanggal = $this->request->getPost('kot_date');
    $bulan = date('m', strtotime($tanggal));
    $tahun = date('Y', strtotime($tanggal));
    $waktu = date('Y-m-d H:i:s');
    $cek = $modecek->get_nopencairan($bulan, $tahun);
    $jenistype = $this->request->getPost('kot_type');
    if ($jenistype <= '2') {
      $vdbcrh = 'D';
      $vdbcrd = 'K';
    } else {
      $vdbcrh = 'K';
      $vdbcrd = 'D';
    }
    $nourut = $cek['kot_srno'];
    $kodecabang = session()->get('kode_cabang');
    if ($nourut == '') {
      $nourut = 1;
      $v_trx_code = $kodecabang . '.05.' . $tahun . $bulan . '00001';
    } else {
      $nourut = $nourut + 1;
      if ($nourut < 10) {
        $v_trx_code = $kodecabang . '.05.' . $tahun . $bulan . '0000' . $nourut;
      } else if ($nourut >= 10 and $nourut < 100) {
        $v_trx_code = $kodecabang . '.05.' . $tahun . $bulan . '000' . $nourut;
      } else if ($nourut >= 100 and $nourut < 1000) {
        $v_trx_code = $kodecabang . '.05.' . $tahun . $bulan . '00' . $nourut;
      } else if ($nourut >= 1000 and $nourut < 10000) {
        $v_trx_code = $kodecabang . '.05.' . $tahun . $bulan . '0' . $nourut;
      } else {
        $v_trx_code = $kodecabang . '.05.' . $tahun . $bulan . $nourut;
      }
    }



    $kot_totl = str_replace(',', '', $this->request->getPost('grn_stot'));
    if ($jenistype <= '2') {
      $debet = $kot_totl;
      $credit = 0;
    } else {
      $debet = 0;
      $credit = $kot_totl;
    }
    $acc_cash = '';
    $accbank = $modecek->get_bank($this->request->getPost('bnk_code'));
    $acc_cash = $accbank['acc_code'];

    $data = array(
      'kot_code'       => $v_trx_code, //$this->request->getPost('kot_code'),
      'kot_date'       => $this->request->getPost('kot_date'),

      'bnk_code'       => $this->request->getPost('bnk_code'),
      'kot_type'       => $this->request->getPost('kot_type'),
      'kot_desc'       => $this->request->getPost('kot_desc'),
      'kot_totl'       => $kot_totl,
      'acc_code'       => $acc_cash,

      'kot_mont'       => $bulan,
      'kot_year'       => $tahun,
      'kot_srno'       => $nourut,
      'kot_stat' => 0,
      'com_code'  => 1,
      'kode_cabang' => $kodecabang,
    );

    $model->_savekasumum($data);
    //Jurnal Header (K)

    // $acc_code = $this->request->getPost('acc_cash');

    if ($jenistype == '1') {
      $description = 'Penerimaan Saldo Awal ';
    } else if ($jenistype == '4') {
      $description = 'Pengeluaran Modal Untuk  Saldo Awal ';
    } else {
      $description = $this->request->getPost('kot_desc');
    }
    $data = array(
      'trx_code' => $v_trx_code, //$this->request->getPost('kot_code'),
      'trx_date' => $this->request->getPost('kot_date'),
      'acc_code'  => $acc_cash,
      'trx_urut' => 1,
      'trx_dbcr'  => $vdbcrh,
      'trx_amnt'  => $kot_totl,
      'dbt_amnt'  => $debet,
      'crd_amnt'  => $credit,
      'trx_des1'  => $description, //$this->request->getPost('kot_desc'),
      'trx_des2'  => $description, //$this->request->getPost('kot_desc'),
      'com_code'  => 1,
      'kode_cabang' => session()->get('kode_cabang'),
      'ent_time' => $waktu,
      'usercreated' => session()->get('username'),
    );
    $model->_savejurnal($data);
    //-----end save header-----
    //----- Kartu Debitur-----
    $id = 1;
    $kode = $_POST['kode'];
    $jumlah = count($kode);
    $jenistran = $this->request->getPost('kot_type');

    for ($x = 0; $x < $jumlah; $x++) {

      $kode1 = $this->request->getPost('kode[' . $x . ']');
      if ($kode1 != '') {
        $kot_stot = str_replace(',', '', $this->request->getPost('dbttotl[' . $x . ']'));
        $debet = 0;
        $credit = 0;
        if ($jenistype <= '2') {

          $credit = $kot_stot;
          $debet = 0;
        } else {
          $debet = 0;
          $credit = $kot_stot;
        }
        $data = array(
          'kot_code' => $v_trx_code, //$this->request->getPost('kot_code'),
          'kot_cod1' => $v_trx_code . '-' . $x, //$this->request->getPost('kot_code'),
          'kode_trans' => $this->request->getPost('kode[' . $x . ']'),
          'kot_idno' => $x,
          'prd_desc'  => $this->request->getPost('ket[' . $x . ']'),
          'kot_stot'  => $kot_stot,


          'acc_code'  => $this->request->getPost('acccode[' . $x . ']'),
          'ref_code'  => $this->request->getPost('refcode[' . $x . ']'),
          // 'com_code'  => 1,

        );
        $model->_savekasumumdetil($data);

        // Jurnal Detil
        $data = array(
          'trx_code' => $v_trx_code, //$this->request->getPost('kot_code'),
          'trx_date' => $this->request->getPost('kot_date'),
          'trx_urut' => $x,
          'acc_code'  => $this->request->getPost('acccode[' . $x . ']'),
          'trx_dbcr'  => $vdbcrd,
          'trx_amnt'  => $kot_stot,
          'dbt_amnt'  => $debet,
          'crd_amnt'  => $credit,
          'trx_des1'  => $this->request->getPost('ket[' . $x . ']'),

          'trx_des2'  =>
          $this->request->getPost('reffcode[' . $x . ']'),
          'com_code'  => 1,
          'kode_cabang' => session()->get('kode_cabang'),
          'ent_time' => $waktu,
          'usercreated' => session()->get('username'),
        );
        $model->_savejurnal($data);
      }
    }


    return redirect()->to('cash/cashout')->with('success', 'Menambah Data Berhasil');
  }

  public function updatepencairan()
  {
    $model = new Save_model();
    $modelete = new Delete_model();
    $tanggal = $this->request->getPost('kot_date');
    $bulan = date('m', strtotime($tanggal));
    $tahun = date('Y', strtotime($tanggal));
    $id = $this->request->getPost('kot_date');
    $jenistype = $this->request->getPost('kot_type');
    if ($jenistype <= '2') {
      $vdbcrh = 'D';
      $vdbcrd = 'K';
    } else {
      $vdbcrh = 'K';
      $vdbcrd = 'D';
    }


    $kot_totl = str_replace(',', '', $this->request->getPost('grn_stot'));
    $data = array(
      // 'kot_code'       => $v_trx_code, //$this->request->getPost('kot_code'),
      'kot_date'       => $this->request->getPost('kot_date'),

      'bnk_code'       => $this->request->getPost('bnk_code'),
      'kot_type'       => $this->request->getPost('kot_type'),
      'kot_desc'       => $this->request->getPost('kot_desc'),
      'kot_totl'       => $kot_totl,
      'acc_code'       => $this->request->getPost('acc_cash'),

      'kot_mont'       => $bulan,
      'kot_year'       => $tahun,


    );

    $model->_updatepencairan($data, $id);
    //Jurnal Header (K)

    $acc_code = $this->request->getPost('acc_cash');
    $modelete->_deletepencairandtl($id);
    $modelete->_deletejurnal($id);

    $data = array(
      'trx_code' => $this->request->getPost('kot_code'),
      'trx_date' => $this->request->getPost('kot_date'),
      'acc_code'  => $acc_code,
      'trx_urut' => 1,
      'trx_dbcr'  => $vdbcrh,
      'trx_amnt'  => $kot_totl,
      'dbt_amnt'  => 0,
      'crd_amnt'  => $kot_totl,
      'trx_des1'  => $this->request->getPost('kot_desc'),
      'trx_des2'  => $this->request->getPost('kot_desc'),
      'com_code'  => 1,
      'kode_cabang' => session()->get('kode_cabang'),
    );
    $model->_savejurnal($data);
    //-----end save header-----
    //----- Kartu Debitur-----
    $id = 1;
    $kode = $_POST['kode'];
    $jumlah = count($kode);
    $jenistran = $this->request->getPost('kot_type');

    for ($x = 0; $x < $jumlah; $x++) {

      $kode1 = $this->request->getPost('kode[' . $x . ']');
      if ($kode1 != '') {
        $kot_stot = str_replace(',', '', $this->request->getPost('dbttotl[' . $x . ']'));

        $data = array(
          'kot_code' => $this->request->getPost('kot_code'),
          'kot_cod1' => $this->request->getPost('kot_code') . '-' . $x,
          'kode_trans' => $this->request->getPost('kode[' . $x . ']'),
          'kot_idno' => $x,
          'prd_desc'  => $this->request->getPost('ket[' . $x . ']'),
          'kot_stot'  => $kot_stot,


          'acc_code'  => $this->request->getPost('acccode[' . $x . ']'),
          'ref_code'  => $this->request->getPost('refcode[' . $x . ']'),
          // 'com_code'  => 1,

        );
        $model->_savepencairandetil($data);

        // Jurnal Detil
        $data = array(
          'trx_code' => $this->request->getPost('kot_code'),
          'trx_date' => $this->request->getPost('kot_date'),
          'trx_urut' => $x,
          'acc_code'  => $this->request->getPost('acccode[' . $x . ']'),
          'trx_dbcr'  => $vdbcrd,
          'trx_amnt'  => $kot_stot,
          'dbt_amnt'  => $kot_stot,
          'trx_des1'  => $this->request->getPost('ket[' . $x . ']'),
          'crd_amnt'  => 0,
          'trx_des2'  =>
          $this->request->getPost('reffcode[' . $x . ']'),
          'com_code'  => 1,
          'kode_cabang' => session()->get('kode_cabang'),
        );
        $model->_savejurnal($data);
      }
    }


    return redirect()->to('cash/cashout')->with('success', 'Update Data Berhasil');
  }

  public function updatekasumum()
  {
    $model = new Save_model();
    $mdelete = new Delete_model();
    $tanggal = $this->request->getPost('kot_date');
    $bulan = date('m', strtotime($tanggal));
    $tahun = date('Y', strtotime($tanggal));
    $v_trx_code =
      $this->request->getPost('kot_code');
    $jenistype = $this->request->getPost('kot_type');
    if ($jenistype <= '2') {
      $vdbcrh = 'D';
      $vdbcrd = 'K';
    } else {
      $vdbcrh = 'K';
      $vdbcrd = 'D';
    }


    $kot_totl = str_replace(',', '', $this->request->getPost('grn_stot'));
    $data = array(
      // 'kot_code'       => $v_trx_code, //$this->request->getPost('kot_code'),
      'kot_date'       => $this->request->getPost('kot_date'),

      'bnk_code'       => $this->request->getPost('bnk_code'),
      'kot_type'       => $this->request->getPost('kot_type'),
      'kot_desc'       => $this->request->getPost('kot_desc'),
      'kot_totl'       => $kot_totl,
      'acc_code'       => $this->request->getPost('acc_cash'),

      'kot_mont'       => $bulan,
      'kot_year'       => $tahun,
      // 'kot_srno'       => $nourut,
      // 'kot_stat' => 0,
      'com_code'  => 1,
    );

    $model->_updatekasumum($data, $v_trx_code);
    //Jurnal Header (K)
    $mdelete->deletekasumumdtl($v_trx_code);
    $mdelete->_deletejurnal($v_trx_code);

    $acc_code = $this->request->getPost('acc_cash');


    $data = array(
      'trx_code' => $v_trx_code, //$this->request->getPost('kot_code'),
      'trx_date' => $this->request->getPost('kot_date'),
      'acc_code'  => $acc_code,
      'trx_urut' => 1,
      'trx_dbcr'  => $vdbcrh,
      'trx_amnt'  => $kot_totl,
      'dbt_amnt'  => 0,
      'crd_amnt'  => $kot_totl,
      'trx_des1'  => $this->request->getPost('kot_desc'),
      'trx_des2'  => $this->request->getPost('kot_desc'),
      'com_code'  => 1,
      'kode_cabang' => session()->get('kode_cabang'),
    );
    $model->_savejurnal($data);
    //-----end save header-----
    //----- Kartu Debitur-----
    $id = 1;
    $kode = $_POST['kode'];
    $jumlah = count($kode);
    $jenistran = $this->request->getPost('kot_type');

    for ($x = 0; $x < $jumlah; $x++) {

      $kode1 = $this->request->getPost('kode[' . $x . ']');
      if ($kode1 != '') {
        $kot_stot = str_replace(',', '', $this->request->getPost('dbttotl[' . $x . ']'));

        $data = array(
          'kot_code' => $v_trx_code, //$this->request->getPost('kot_code'),
          'kot_cod1' => $v_trx_code . '-' . $x, //$this->request->getPost('kot_code'),
          'kode_trans' => $this->request->getPost('kode[' . $x . ']'),
          'kot_idno' => $x,
          'prd_desc'  => $this->request->getPost('ket[' . $x . ']'),
          'kot_stot'  => $kot_stot,


          'acc_code'  => $this->request->getPost('acccode[' . $x . ']'),
          'ref_code'  => $this->request->getPost('refcode[' . $x . ']'),
          // 'com_code'  => 1,

        );
        $model->_savekasumumdetil($data);

        // Jurnal Detil
        $data = array(
          'trx_code' => $v_trx_code, //$this->request->getPost('kot_code'),
          'trx_date' => $this->request->getPost('kot_date'),
          'trx_urut' => $x,
          'acc_code'  => $this->request->getPost('acccode[' . $x . ']'),
          'trx_dbcr'  => $vdbcrd,
          'trx_amnt'  => $kot_stot,
          'dbt_amnt'  => $kot_stot,
          'trx_des1'  => $this->request->getPost('ket[' . $x . ']'),
          'crd_amnt'  => 0,
          'trx_des2'  =>
          $this->request->getPost('reffcode[' . $x . ']'),
          'com_code'  => 1,
          'kode_cabang' => session()->get('kode_cabang'),

        );
        $model->_savejurnal($data);
      }
    }


    return redirect()->to('cash/cashout')->with('success', 'Menambah Data Berhasil');
  }

  public function updatepencairan1()
  {
    $model = new Save_model();
    $modelete = new Delete_model();
    $tanggal = $this->request->getPost('kot_date');
    $bulan = date('m', strtotime($tanggal));
    $tahun = date('Y', strtotime($tanggal));
    $id = $this->request->getPost('kot_date');
    $jenistype = $this->request->getPost('kot_type');
    if ($jenistype <= '2') {
      $vdbcrh = 'D';
      $vdbcrd = 'K';
    } else {
      $vdbcrh = 'K';
      $vdbcrd = 'D';
    }


    $kot_totl = str_replace(',', '', $this->request->getPost('grn_stot'));
    $data = array(
      // 'kot_code'       => $v_trx_code, //$this->request->getPost('kot_code'),
      'kot_date'       => $this->request->getPost('kot_date'),

      'bnk_code'       => $this->request->getPost('bnk_code'),
      'kot_type'       => $this->request->getPost('kot_type'),
      'kot_desc'       => $this->request->getPost('kot_desc'),
      'kot_totl'       => $kot_totl,
      'acc_code'       => $this->request->getPost('acc_cash'),

      'kot_mont'       => $bulan,
      'kot_year'       => $tahun,


    );

    $model->_updatepencairan($data, $id);
    //Jurnal Header (K)

    $acc_code = $this->request->getPost('acc_cash');
    $modelete->_deletepencairandtl($id);
    $modelete->_deletejurnal($id);

    $data = array(
      'trx_code' => $this->request->getPost('kot_code'),
      'trx_date' => $this->request->getPost('kot_date'),
      'acc_code'  => $acc_code,
      'trx_urut' => 1,
      'trx_dbcr'  => $vdbcrh,
      'trx_amnt'  => $kot_totl,
      'dbt_amnt'  => 0,
      'crd_amnt'  => $kot_totl,
      'trx_des1'  => $this->request->getPost('kot_desc'),
      'trx_des2'  => $this->request->getPost('kot_desc'),
      'com_code'  => 1,
      'kode_cabang' => session()->get('kode_cabang'),
    );
    $model->_savejurnal($data);
    //-----end save header-----
    //----- Kartu Debitur-----
    $id = 1;
    $kode = $_POST['kode'];
    $jumlah = count($kode);
    $jenistran = $this->request->getPost('kot_type');

    for ($x = 0; $x < $jumlah; $x++) {

      $kode1 = $this->request->getPost('kode[' . $x . ']');
      if ($kode1 != '') {
        $kot_stot = str_replace(',', '', $this->request->getPost('dbttotl[' . $x . ']'));

        $data = array(
          'kot_code' => $this->request->getPost('kot_code'),
          'kot_cod1' => $this->request->getPost('kot_code') . '-' . $x,
          'kode_trans' => $this->request->getPost('kode[' . $x . ']'),
          'kot_idno' => $x,
          'prd_desc'  => $this->request->getPost('ket[' . $x . ']'),
          'kot_stot'  => $kot_stot,


          'acc_code'  => $this->request->getPost('acccode[' . $x . ']'),
          'ref_code'  => $this->request->getPost('refcode[' . $x . ']'),
          // 'com_code'  => 1,

        );
        $model->_savepencairandetil($data);

        // Jurnal Detil
        $data = array(
          'trx_code' => $this->request->getPost('kot_code'),
          'trx_date' => $this->request->getPost('kot_date'),
          'trx_urut' => $x,
          'acc_code'  => $this->request->getPost('acccode[' . $x . ']'),
          'trx_dbcr'  => $vdbcrd,
          'trx_amnt'  => $kot_stot,
          'dbt_amnt'  => $kot_stot,
          'trx_des1'  => $this->request->getPost('ket[' . $x . ']'),
          'crd_amnt'  => 0,
          'trx_des2'  =>
          $this->request->getPost('reffcode[' . $x . ']'),
          'com_code'  => 1,

        );
        $model->_savejurnal($data);
      }
    }


    return redirect()->to('cash/cashout')->with('success', 'Update Data Berhasil');
  }
  public function setoran()
  {
    $model = new Model_git();
    $_SESSION['com_menu'] = '03';
    $_SESSION['com_men1'] = '0304';
    $_SESSION['com_men2'] = '';
    $tanggal = date('Y-m-d');

    $kodecabang = session()->get('kode_cabang');
    if ($_SESSION['usr_jabt'] == 'Administrator') {
      $data['v_kas']  = $model->_get_cashin($tanggal)->getResult();
    } else {
      $data['v_kas']  = $model->_get_cashincab($tanggal, $kodecabang)->getResult();
    }

    return view('kas/pembiayaan/pembiayaan_list', $data);
  }


  public function setoranumum()
  {
    $model = new Model_git();
    $_SESSION['com_menu'] = '03';
    $_SESSION['com_men1'] = '';
    $_SESSION['com_men2'] = '';
    $tanggal = date('Y-m-d');
    $kodecabang = session()->get('kode_cabang');
    if ($_SESSION['usr_jabt'] == 'Administrator') {
      $data['v_kas']  = $model->_get_cashinumum($tanggal)->getResult();
    } else {
      $data['v_kas']  = $model->_get_cashinumumcab($tanggal, $kodecabang)->getResult();
    }

    return view('kas/pembiayaan/in_list1', $data);
  }

  public function adcashin()
  {
    $model = new Model_git();
    $id = "01";
    $id1 = "02";
    $cabang = session()->get('kode_cabang');

    $data['tgl2'] = date('Y-m-d');
    $data['v_bank']  = $model->_getbank_cab($cabang)->getResult();
    // $data['v_kontrak']  = $model->_get_lkontrak()->getResult();
    $data['v_khusus']  = $model->_acckhusus($id)->getResult();
    $data['v_khususd']  = $model->_acckhusus($id1)->getResult();
    return view('kas/pembiayaan/pembiayaan_add', $data);
  }

  public function addsetoranumum()
  {
    $model = new Model_git();
    $model1 = new Master_model();

    $id = "01";
    $id1 = "S";
    $cabang = session()->get('kode_cabang');
    $tanggal = date('Y-m-d');
    $data['tgl2'] = $tanggal;
    $data['v_bank']  = $model->_getbank_cab($cabang)->getResult();
    $data['v_kontrak']  = $model->_get_lkontrak()->getResult();
    $data['v_khusus']  = $model->_acckhusus($id)->getResult();
    $data['v_product']  = $model1->_get_productb($id1)->getResult();
    $data['v_anggota']  = $model1->_get_langgota()->getResult();
    return view('kas/pembiayaan/in_add1', $data);
  }
  public function edcashin($id)
  {
    $model = new Model_git();
    $data['v_kas']  = $model->_get_edcashout($id)->getResult();

    return view('kas/out/out_add', $data);
  }

  public function editsetoranumum($id)
  {
    $model = new Model_git();
    $model1 = new Master_model();
    $id1 = "S";
    $cabang = session()->get('kode_cabang');
    $data['v_bank']  = $model->_getbank_cab($cabang)->getResult();
    $data['v_kontrak']  = $model->_get_lkontrak()->getResult();
    $data['v_product']  = $model1->_get_productb($id1)->getResult();
    $data['v_anggota']  = $model1->_get_langgota()->getResult();
    $data['v_kas']  = $model->_editsetoranumum($id)->getResult();

    return view('kas/pembiayaan/in_edit1', $data);
  }

  public function delcashin($id)
  {
    $model = new Model_git();
    $data['v_kas']  = $model->_get_edcashout($id)->getResult();
    return view('kas/out/out_add', $data);
  }

  public function savesetoran()
  {
    if (
      !$this->validate([
        'reg_date' => [
          'rules' => 'required',
          'errors' => [
            'required' => 'Tanggal Pendaftaran Harus diisi  '
            // 'required' => '{field} Harus diisi'
          ]
        ],
        'pat_code' => [
          'rules' => 'required',
          'errors' => [
            'required' => 'Nama Pasien Harus diisi  '
            // 'required' => '{field} Harus diisi'
          ]
        ],
        'cus_code' => [
          'rules' => 'required',
          'errors' => [
            'required' => 'Jenis Pasien harus diisi  '
            // 'required' => '{field} Harus diisi'
          ]
        ],
        'dok_code' => [
          'rules' => 'required',
          'errors' => [
            'required' => 'Nama Dokter Harus diisi  '
            // 'required' => '{field} Harus diisi'
          ]
        ]
      ])
    ) {
      session()->setFlashdata('error', $this->validator->listErrors());
      return redirect()->back()->withInput();
    } else {
      $model = new Save_model();
      $modecek = new Auto_model();
      $mgit = new Model_git();
      $note = "";
      $tanggal = $this->request->getPost('kin_date');
      $bulan = date('m', strtotime($tanggal));
      $tahun = date('Y', strtotime($tanggal));
      $waktu = date('Y-m-d H:i:s');
      $type = '06';
      $cek = $modecek->get_nosetoran($bulan, $tahun);
      if ($bulan < 10) {
        $bulan1 = '0' . $bulan;
      } else {
        $bulan1 = $bulan;
      }

      $nourut = $cek['kin_srno'];

      $kodecabang = session()->get('kode_cabang');
      if ($nourut == '') {
        $nourut = 1;
        $v_trx_code = $kodecabang . '.06.' . $tahun . $bulan . '.00001';
      } else {
        $nourut = $nourut + 1;
        if ($nourut < 10) {
          $v_trx_code = $kodecabang . '.06.' . $tahun . $bulan . '.0000' . $nourut;
        } else if ($nourut >= 10 and $nourut < 100) {
          $v_trx_code = $kodecabang . '.06.' . $tahun . $bulan . '.000' . $nourut;
        } else if ($nourut >= 100 and $nourut < 1000) {
          $v_trx_code = $kodecabang . '.06.' . $tahun . $bulan . '.00' . $nourut;
        } else if ($nourut >= 1000 and $nourut < 10000) {
          $v_trx_code = $kodecabang . '.06.' . $tahun . $bulan . '.0' . $nourut;
        } else {
          $v_trx_code = $kodecabang . '.06.' . $tahun . $bulan . '.' . $nourut;
        }
      }
      $kin_stot = str_replace(',', '', $this->request->getPost('kin_stot'));
      $kin_admn = str_replace(',', '', $this->request->getPost('kin_admn'));
      $kin_totl = str_replace(',', '', $this->request->getPost('kin_totl'));
      $kin_spok = str_replace(',', '', $this->request->getPost('kin_spok'));
      $kin_swaj = str_replace(',', '', $this->request->getPost('kin_swaj'));
      $kin_suka = str_replace(',', '', $this->request->getPost('kin_suka'));

      $acc_cash = '';
      $accbank = $modecek->get_bank($this->request->getPost('bnk_code'));
      $acc_cash = $accbank['acc_code'];
      $data = array(
        'kin_code' => $v_trx_code,
        //$this->request->getPost('kin_code'),
        'kin_date' => $this->request->getPost('kin_date'),
        'agt_numb' => $this->request->getPost('agt_numb'),
        'bnk_code' => $this->request->getPost('bnk_code'),
        'acc_cash' => $acc_cash,
        'knt_code' => $this->request->getPost('knt_code'),
        'kin_type' => $this->request->getPost('kin_type'),
        'kin_desc' => $this->request->getPost('kin_desc'),
        'kin_note' => $note,
        'kin_stot' => $kin_stot,
        'kin_admn' => $kin_admn,
        'kin_spok' => $kin_spok,
        'kin_swaj' => $kin_swaj,
        'kin_suka' => $kin_suka,
        'acc_admn' => $this->request->getPost('acc_admn'),
        'acc_prod' => $this->request->getPost('acc_prod'),
        // 'prd_code'       => $this->request->getPost('prd_code'),
        'kin_dend' => 0,
        'kin_angs' => 0,
        'kin_bung' => 0,
        'kin_pokk' => 0,
        'kin_mont' => $bulan,
        'kin_year' => $tahun,
        'kin_totl' => $kin_totl,
        'kin_srno' => $nourut,
        'kin_jens' => $this->request->getPost('kin_jens'),
        'kin_stat' => 0,
        'com_code' => 1,
        'kode_cabang' => $kodecabang,
      );

      $model->_savesetorpembiayaan($data);

      // Jurnal

      $data = array(
        'trx_code' => $v_trx_code,
        //$this->request->getPost('kin_code'),
        'trx_date' => $this->request->getPost('kin_date'),
        'acc_code' => $acc_cash,
        'trx_jens' => $this->request->getPost('kin_jens'),
        'psb_code' => $this->request->getPost('kin_type'),

        'trx_urut' => 1,
        'trx_dbcr' => 'D',
        'trx_amnt' => $kin_totl,
        'dbt_amnt' => $kin_totl,
        'crd_amnt' => 0,
        'trx_des1' => $this->request->getPost('kin_desc'),
        'trx_des2' => $this->request->getPost('kin_desc') . ' Atas nama : ' . $this->request->getPost('agt_name'),
        'com_code' => 1,
        'kode_cabang' => session()->get('kode_cabang'),
        'ent_time' => $waktu,
        'usercreated' => session()->get('username'),
      );
      $model->_savejurnal($data);


      // Jurnal

      $data = array(
        'trx_code' => $v_trx_code,
        //$this->request->getPost('kin_code'),
        'trx_date' => $this->request->getPost('kin_date'),
        'acc_code' => $this->request->getPost('acc_prod'),
        'trx_jens' => $this->request->getPost('kin_jens'),
        'psb_code' => $this->request->getPost('kin_type'),
        'trx_urut' => 1,
        'trx_dbcr' => 'K',
        'trx_amnt' => $kin_stot,
        'dbt_amnt' => 0,
        'crd_amnt' => $kin_stot,
        'trx_des1' => $this->request->getPost('kin_desc'),
        'trx_des2' => '',
        'com_code' => session()->get('com_code'),
        'kode_cabang' => session()->get('kode_cabang'),
        'ent_time' => $waktu,
        'usercreated' => session()->get('username'),
      );
      $model->_savejurnal($data);

      //admin
      // Jurnal Admin

      if ($kin_admn > 0) {
        $data = array(
          'trx_code' => $v_trx_code,
          //$this->request->getPost('kin_code'),
          'trx_date' => $this->request->getPost('kin_date'),
          'acc_code' => $this->request->getPost('acc_admn'),
          'trx_jens' => $this->request->getPost('kin_type'),
          'trx_urut' => 1,
          'trx_dbcr' => 'K',
          'trx_amnt' => $kin_admn,
          'dbt_amnt' => 0,
          'crd_amnt' => $kin_admn,
          'trx_des1' => $this->request->getPost('kin_desc'),
          'trx_des2' => '',
          'com_code' => session()->get('com_code'),
          'kode_cabang' => session()->get('kode_cabang'),
          'ent_time' => $waktu,
          'usercreated' => session()->get('username'),
        );
        $model->_savejurnal($data);
      }
      $cabang = session()->get('kode_cabang');
      if ($cabang = !'100') {
        $dbakuncabang = $mgit->get_dtakuncabang('100');
        foreach ($dbakuncabang->getResult() as $row) {
          $acc_cab1 = $row->acc_arcd;
        }
        $data = array(
          'trx_code' => $v_trx_code,
          //$this->request->getPost('kin_code'),
          'trx_date' => $this->request->getPost('kin_date'),
          'acc_code' => $acc_cab1,
          'trx_jens' => $this->request->getPost('kin_type'),
          'trx_urut' => 1,
          'trx_dbcr' => 'D',
          'trx_amnt' => $kin_totl,
          'dbt_amnt' => 0,
          'crd_amnt' => $kin_totl,
          'trx_des1' => 'Piutang cabang :' . $this->request->getPost('kin_desc'),
          'trx_des2' => 'Piutang cabang :' . $this->request->getPost('kin_desc'),
          'com_code' => session()->get('com_code'),
          'kode_cabang' => session()->get('kode_cabang'),
          'ent_time' => $waktu,
          'usercreated' => session()->get('username'),
        );
        $model->_savejurnal($data);
        // Piutang
        $dbakuncabang = $mgit->get_dtakuncabang($cabang);
        foreach ($dbakuncabang->getResult() as $row1) {
          $acc_cab2 = $row->acc_apcd;
        }
        $data = array(
          'trx_code' => $v_trx_code,
          //$this->request->getPost('kin_code'),
          'trx_date' => $this->request->getPost('kin_date'),
          'acc_code' => $acc_cab2,
          'trx_jens' => $this->request->getPost('kin_type'),
          'trx_urut' => 1,
          'trx_dbcr' => 'K',
          'trx_amnt' => $kin_totl,
          'dbt_amnt' => 0,
          'crd_amnt' => $kin_totl,
          'trx_des1' => 'Piutang cabang :' . $this->request->getPost('kin_desc'),
          'trx_des2' => 'Piutang cabang :' . $this->request->getPost('kin_desc'),
          'com_code' => session()->get('com_code'),
          'kode_cabang' => session()->get('kode_cabang'),
          'ent_time' => $waktu,
          'usercreated' => session()->get('username'),
        );
        $model->_savejurnal($data);
      }

      $id = $this->request->getPost('agt_numb');
      if ($this->request->getPost('kin_type') == '301') {
        $data = array(
          'agt_stat' => 1,
        );

        $model->_updateanggota($data, $id);
      }

      if ($this->request->getPost('kin_jens') == '02') {
        $data = array(
          'agt_stat' => 5,
        );

        $model->_updateanggota($data, $id);
      }
      return redirect()->to('cash/setoranumum')->with('success', 'Menambah Data Berhasil');
    }
  }
  // Update setoran Umum

  public function updatesetoranumum()
  {
    $model = new Save_model();
    $note = "";
    $tanggal = $this->request->getPost('kin_date');
    $bulan = date('m', strtotime($tanggal));
    $tahun = date('Y', strtotime($tanggal));
    $type = '06';
    $kin_stot = str_replace(',', '', $this->request->getPost('kin_stot'));
    $kin_admn = str_replace(',', '', $this->request->getPost('kin_admn'));
    $kin_totl = str_replace(',', '', $this->request->getPost('kin_totl'));
    $kin_spok = str_replace(',', '', $this->request->getPost('kin_spok'));
    $kin_swaj = str_replace(',', '', $this->request->getPost('kin_swaj'));
    $kin_suka = str_replace(',', '', $this->request->getPost('kin_suka'));
    $id = $this->request->getPost('kin_code');

    $data = array(

      'kin_date'       => $this->request->getPost('kin_date'),
      'agt_numb'       => $this->request->getPost('agt_numb'),
      'bnk_code'       => $this->request->getPost('bnk_code'),
      'acc_cash'       => $this->request->getPost('acc_cash'),
      'knt_code'       => $this->request->getPost('knt_code'),
      'kin_type'       => $this->request->getPost('kin_type'),
      'kin_desc'       => $this->request->getPost('kin_desc'),
      'kin_note'       => $note,
      'kin_stot'       => $kin_stot,
      'kin_admn'       => $kin_admn,
      'kin_spok'       => $kin_spok,
      'kin_swaj'       => $kin_swaj,
      'kin_suka'       => $kin_suka,
      'acc_admn'       => $this->request->getPost('acc_admn'),
      'acc_prod'       => $this->request->getPost('acc_prod'),
      'kin_dend'       => 0,
      'kin_angs'       => 0,
      'kin_bung'       => 0,
      'kin_pokk'       => 0,
      'kin_mont'       => $bulan,
      'kin_year'       => $tahun,
      'kin_totl'       => $kin_totl,

      'kin_jens'       => $this->request->getPost('kin_jens'),
      'kin_stat' => 0,
      'com_code'  => 1,
    );

    $model->_updatepembiayaan($data, $id);

    // Jurnal
    $model1 = new Delete_model();

    $model->_deletejurnal($id);
    $data = array(
      'trx_code' => $this->request->getPost('kin_code'),
      'trx_date' => $this->request->getPost('kin_date'),
      'acc_code'  => $this->request->getPost('acc_cash'),
      'trx_jens'  => $this->request->getPost('kin_type'),
      'trx_urut' => 1,
      'trx_dbcr'  => 'D',
      'trx_amnt'  => $kin_totl,
      'dbt_amnt'  => $kin_totl,
      'crd_amnt'  => 0,
      'trx_des1'  => $this->request->getPost('kin_desc'),
      'trx_des2'  => '',
      'com_code'  => 1,
      'kode_cabang' => session()->get('kode_cabang'),
    );
    $model->_savejurnal($data);


    // Jurnal

    $data = array(
      'trx_code' => $this->request->getPost('kin_code'),
      'trx_date' => $this->request->getPost('kin_date'),
      'acc_code'  => $this->request->getPost('acc_prod'),
      'trx_jens'  => $this->request->getPost('kin_type'),
      'trx_urut' => 1,
      'trx_dbcr'  => 'K',
      'trx_amnt'  => $kin_stot,
      'dbt_amnt'  => 0,
      'crd_amnt'  => $kin_stot,
      'trx_des1'  => $this->request->getPost('kin_desc'),
      'trx_des2'  => '',
      'com_code'  => 1,
      'kode_cabang' => session()->get('kode_cabang'),
    );
    $model->_savejurnal($data);

    //admin
    // Jurnal Admin

    if ($kin_admn > 0) {
      $data = array(
        'trx_code' => $this->request->getPost('kin_code'),
        'trx_date' => $this->request->getPost('kin_date'),
        'acc_code'  => $this->request->getPost('acc_admn'),
        'trx_jens'  => $this->request->getPost('kin_type'),
        'trx_urut' => 1,
        'trx_dbcr'  => 'K',
        'trx_amnt'  => $kin_admn,
        'dbt_amnt'  => 0,
        'crd_amnt'  => $kin_admn,
        'trx_des1'  => $this->request->getPost('kin_desc'),
        'trx_des2'  => '',
        'com_code'  => 1,
        'kode_cabang' => session()->get('kode_cabang'),
      );
      $model->_savejurnal($data);
    }

    return redirect()->to('cash/setoranumum')->with('success', 'Menambah Data Berhasil');
  }


  // Hapus Setoran Umum
  public function deletesetoranumum($id)
  {
    $model = new Delete_model();

    $model->_deletesetorumum($id);
    return redirect()->to('cash/setoranumum')->with('success', 'Menghapus Data Berhasil');
  }

  public function savesetorpembiayaan()
  {
    $note = "";
    $tanggal = $this->request->getPost('kin_date');
    $bulan = date('m', strtotime($tanggal));
    $tahun = date('Y', strtotime($tanggal));
    $waktu = date('Y-m-d H:i:s');
    $model = new Save_model();
    $modecek = new Auto_model();
    $mgit = new Model_git();
    $jenis = $this->request->getPost('kin_type');
    $type = '07';
    $cek = $modecek->get_nopembiayaan($bulan, $tahun);
    if ($jenis == '01') {

      $description = 'Setoran ' . $this->request->getPost('prd_name') . ' - ' . $this->request->getPost('agt_name');
      $description1 = 'Setoran ' . $this->request->getPost('prd_name');
    } else if ($jenis == '02') {
      $description = 'Pelunasan ' . $this->request->getPost('prd_name') . ' - ' . $this->request->getPost('agt_name');
      $description1 = 'Pelunasan ' . $this->request->getPost('prd_name');
    } else if ($jenis == '03') {
      $description = 'Realisasi ' . $this->request->getPost('prd_name') . ' - ' . $this->request->getPost('agt_name');
      $description1 = 'Realisasi ' . $this->request->getPost('prd_name');
    } else if ($jenis == '04') {
      $description = 'Biaya Transaksi ' . $this->request->getPost('prd_name') . ' - ' .  $this->request->getPost('agt_name');
      $description1 = 'Biaya Transaksi ' . $this->request->getPost('prd_name');
    } else {
      $description = $this->request->getPost('prd_name') . ' - ' .  $this->request->getPost('agt_name');
    }

    $nourut = $cek['kin_srno'];
    $kodecabang = session()->get('kode_cabang');
    if ($nourut == '') {
      $nourut = 1;
      $v_trx_code = $kodecabang . '.07.' . $tahun . $bulan . '00001';
    } else {
      $nourut = $nourut + 1;
      if ($nourut < 10) {
        $v_trx_code = $kodecabang . '.07.' . $tahun . $bulan . '0000' . $nourut;
      } else if ($nourut >= 10 and $nourut < 100) {
        $v_trx_code = $kodecabang . '.07.' . $tahun . $bulan . '000' . $nourut;
      } else if ($nourut >= 100 and $nourut < 1000) {
        $v_trx_code = $kodecabang . '.07.' . $tahun . $bulan . '00' . $nourut;
      } else if ($nourut >= 1000 and $nourut < 10000) {
        $v_trx_code = $kodecabang . '.07.' . $tahun . $bulan . '0' . $nourut;
      } else {
        $v_trx_code = $kodecabang . '.07.' . $tahun . $bulan . $nourut;
      }
    }



    $kin_stot = str_replace(',', '', $this->request->getPost('kin_stot'));
    if ($this->request->getPost('kin_type') == '03') {
      $kin_tadmn = str_replace(',', '', $this->request->getPost('kin_radmn'));
    } else {
      $kin_tadmn = str_replace(',', '', $this->request->getPost('kin_tadmn'));
    }
    $kin_admn = str_replace(',', '', $this->request->getPost('kin_admn'));
    $kin_dendh = str_replace(',', '', $this->request->getPost('kin_dendh'));
    $kin_angsh = str_replace(',', '', $this->request->getPost('kin_angsh'));
    $kin_bungh = str_replace(',', '', $this->request->getPost('kin_bungh'));
    $kin_pokkh = str_replace(',', '', $this->request->getPost('kin_pokkh'));
    $kin_gtot = str_replace(',', '', $this->request->getPost('kin_gtot'));
    $kin_bungh = str_replace(',', '', $this->request->getPost('kin_bungh'));
    $kin_tcos = str_replace(',', '', $this->request->getPost('kin_tcos'));

    $kin_tprov = str_replace(',', '', $this->request->getPost('kin_tprov'));
    $kin_notr = str_replace(',', '', $this->request->getPost('kin_notr'));
    $kin_jiwa = str_replace(',', '', $this->request->getPost('kin_jiwa'));
    $kin_kend = str_replace(',', '', $this->request->getPost('kin_kend'));
    $kin_kebk = str_replace(',', '', $this->request->getPost('kin_kebk'));
    $kin_krdt = str_replace(',', '', $this->request->getPost('kin_krdt'));
    $kin_dana = str_replace(',', '', $this->request->getPost('kin_dana'));
    $kin_lain = str_replace(',', '', $this->request->getPost('kin_lain'));
    $kin_matr = str_replace(',', '', $this->request->getPost('kin_matr'));
    $kin_pmat = str_replace(',', '', $this->request->getPost('kin_pmat'));
    $kin_infq = str_replace(',', '', $this->request->getPost('kin_infq'));
    $kin_simw = str_replace(',', '', $this->request->getPost('kin_simw'));
    $kin_pinl = str_replace(',', '', $this->request->getPost('kin_pinl'));
    $kin_tdendh = str_replace(',', '', $this->request->getPost('kin_tdendh'));
    $kin_ddendh = str_replace(',', '', $this->request->getPost('kin_ddendh'));

    $kin_dadmn = str_replace(',', '', $this->request->getPost('kin_dadmn'));
    $kin_tbungh = str_replace(',', '', $this->request->getPost('kin_tbungh'));
    $kin_dbungh = str_replace(',', '', $this->request->getPost('kin_dbungh'));
    $kin_tpokkh = str_replace(',', '', $this->request->getPost('kin_tpokkh'));
    $kin_dpokkh = str_replace(',', '', $this->request->getPost('kin_dpokkh'));
    $kin_rtgs = str_replace(',', '', $this->request->getPost('kin_rtgs'));
    $kin_tran = str_replace(',', '', $this->request->getPost('kin_tran'));
    $kin_tabg = str_replace(',', '', $this->request->getPost('kin_tabg'));
    $acc_cash = '';
    $accbank = $modecek->get_bank($this->request->getPost('bnk_code'));
    $acc_cash = $accbank['acc_code'];
    $data = array(
      'kin_code'       => $v_trx_code, //$this->request->getPost('kin_code'),
      'kin_date'       => $this->request->getPost('kin_date'),
      'agt_numb'       => $this->request->getPost('agt_numb'),
      'bnk_code'       => $this->request->getPost('bnk_code'),
      'knt_code'       => $this->request->getPost('knt_code'),
      'kin_type'       => $this->request->getPost('kin_type'),
      'kin_desc'       => $this->request->getPost('kin_desc'),
      'prd_code'       => $this->request->getPost('prd_code'),
      'kin_stot'       => $kin_stot,
      'kin_admn'       => $kin_admn,
      'kin_jtdt'       => $this->request->getPost('kin_jtdth'),
      'kin_dend'       => $kin_dendh,
      'kin_angs'       => $kin_angsh,
      'kin_bung'       => $kin_bungh,
      'kin_pokk'       => $kin_pokkh,
      'kin_angk'       => $this->request->getPost('kin_angkh'),
      'kin_note'       => $note,
      'kin_totl'       => $kin_gtot,
      // 'kin_gtot'       => $kin_gtot,
      'acc_cash'       => $acc_cash,
      'acc_prod'       => $this->request->getPost('acc_prod'),
      'acc_dend'       => $this->request->getPost('acc_dend'),
      'acc_admn'       => $this->request->getPost('acc_admn'),
      'acc_bung'       => $this->request->getPost('acc_bung'),
      'kin_tcos'       => $kin_tcos,
      'kin_tprov'      => $kin_tprov,
      'kin_notr'       => $kin_notr,
      'kin_jiwa'       => $kin_jiwa,
      'kin_kend'       => $kin_kend,
      'kin_kebk'       => $kin_kebk,
      'kin_krdt'       => $kin_krdt,
      'kin_dana'       => $kin_dana,
      'kin_lain'       => $kin_lain,
      'kin_matr'       => $kin_matr,
      'kin_pmat'       => $kin_pmat,
      'kin_infq'       => $kin_infq,
      'kin_simw'       => $kin_simw,
      'kin_pinl'       => $kin_pinl,
      'kin_tdendh'       => $kin_tdendh,
      'kin_ddendh'       => $kin_ddendh,
      'kin_tadmn'       => $kin_tadmn,
      'kin_dadmn'       => $kin_dadmn,
      'kin_tbungh'       => $kin_tbungh,
      'kin_dbungh'       => $kin_dbungh,
      'kin_tpokkh'       => $kin_tpokkh,
      'kin_dpokkh'       => $kin_dpokkh,
      'kin_tabg'       => $kin_tabg,
      'kin_rtgs'       => $kin_rtgs,
      'kin_tran'       => 0,
      'kin_mont'       => $bulan,
      'kin_year'       => $tahun,
      'kin_srno'  => $nourut,
      'kin_jens'  => 'K',
      'kin_stat' => '0',
      'kode_cabang' => $kodecabang,
      'com_code'  => 1,
    );

    $model->_savepembiayaan($data);


    if ($jenis == '01') {
      $id1 = $this->request->getPost('kin_angkh');
      $id = $this->request->getPost('knt_code');
      $data = array(

        'trx_lnsh'  => $kin_angsh,
        'lns_pokk'  => $kin_pokkh,
        'lns_bung'  => $kin_bungh,
        'lns_date'  => $this->request->getPost('kin_date'),
        'bkt_date'  => $this->request->getPost('kin_date'),
        'lns_code'  => $v_trx_code, //$this->request->getPost('kin_code'),
      );

      $model->_Updatekartu($data, $id, $id1);
    }
    if ($jenis == '02') {

      $id = $this->request->getPost('knt_code');
      $v_angsuran = 0;
      $dtangsuran = $modecek->_get_angsuran($id);
      $v_angpokok = $dtangsuran['trx_pokk'];
      $v_anglunas = $dtangsuran['trx_lnsh'];
      $v_angbunga = $dtangsuran['trx_bung'];

      $data = array(

        'trx_lnsh'  => $v_anglunas,
        'lns_pokk'  => $v_angpokok,
        'lns_bung'  => $v_angbunga,
        'lns_date'  => $this->request->getPost('kin_date'),
        'lns_code'  => $v_trx_code, //$this->request->getPost('kin_code'),
      );

      $model->_Updatekartuclose($data, $id);
    }

    if ($jenis == '01') {
      $id = $this->request->getPost('knt_code');
      $data = array(
        'knt_stat'  => 1,
        // 'knt_cair'  => 1,

      );

      $model->_updatekontrak($data, $id);
    }

    if ($jenis == '02') {
      $id = $this->request->getPost('knt_code');
      $data = array(
        'knt_stat'  => 2,
        // 'knt_cair'  => 1,

      );

      $model->_updatekontrak($data, $id);
    }

    if ($jenis == '03') {
      $id = $this->request->getPost('knt_code');
      $data = array(
        'knt_cair'  => 1,
        'knt_stat'  => 1,
        'knt_dcar'  => $this->request->getPost('kin_date'),
      );

      $model->_updatekontrak($data, $id);
    }


    // Jurnal
    if ($jenis == '03') {
      $v_trx_dbcr = 'K';
      $v_dbt_amnt = 0;
      $v_crd_amnt = $kin_gtot;
    } else {
      $v_trx_dbcr = 'D';
      $v_dbt_amnt = $kin_gtot;
      $v_crd_amnt = 0;
    }

    $data = array(
      'trx_code' => $v_trx_code, //$this->request->getPost('kin_code'),
      'trx_date' => $this->request->getPost('kin_date'),
      'acc_code'  => $acc_cash,
      'trx_jens'  => $this->request->getPost('kin_type'),
      'psb_code'  => $this->request->getPost('prd_code'),
      'trx_urut' => 1,
      'trx_dbcr'  => $v_trx_dbcr,
      'trx_amnt'  => $kin_gtot,
      'dbt_amnt'  => $v_dbt_amnt,
      'crd_amnt'  => $v_crd_amnt,
      'trx_des1'  => $description,
      'trx_des2'  => $description1,
      'com_code'  => 1,
      'kode_cabang' => session()->get('kode_cabang'),
      'ent_time' => $waktu,
      'usercreated' => session()->get('username'),
    );
    $model->_savejurnal($data);


    // Jurnal 
    //Piutang
    if ($jenis == '03') {
      $v_trx_dbcr = 'D';
      $v_dbt_amnt = $kin_tcos;
      $v_crd_amnt = 0;
      $v_trx_amnt = $kin_tcos;
    } else {
      $v_trx_dbcr = 'K';
      $v_dbt_amnt = 0;
      $v_crd_amnt = $kin_pokkh;
      $v_trx_amnt = $kin_pokkh;
    }

    $data = array(
      'trx_code' => $v_trx_code, //$this->request->getPost('kin_code'),
      'trx_date' => $this->request->getPost('kin_date'),
      'acc_code'  => $this->request->getPost('acc_prod'),
      'trx_jens'  => $this->request->getPost('kin_type'),
      'trx_urut' => 1,
      'trx_dbcr'  => 'K',
      'trx_amnt'  => $v_trx_amnt,
      'dbt_amnt'  => $v_dbt_amnt,
      'crd_amnt'  => $v_crd_amnt,
      'trx_des1'  => $description,
      'trx_des2'  => $description1,
      'com_code'  => 1,
      'kode_cabang' => session()->get('kode_cabang'),
      'ent_time' => $waktu,
      'usercreated' => session()->get('username'),
    );
    $model->_savejurnal($data);


    // Pendapatan Bunga
    $data = array(
      'trx_code' => $v_trx_code, //$this->request->getPost('kin_code'),
      'trx_date' => $this->request->getPost('kin_date'),
      'acc_code'  => $this->request->getPost('acc_bung'),
      'trx_jens'  => $this->request->getPost('kin_type'),
      'trx_urut' => 1,
      'trx_dbcr'  => 'K',
      'trx_amnt'  => $kin_bungh,
      'dbt_amnt'  => 0,
      'crd_amnt'  => $kin_bungh,
      'trx_des1'  => $this->request->getPost('prd_name') . ' - ' . $this->request->getPost('agt_name'),
      'trx_des2'  => 'Pendapatan Bunga',
      'com_code'  => 1,
      'kode_cabang' => session()->get('kode_cabang'),
      'ent_time' => $waktu,
      'usercreated' => session()->get('username'),
    );
    $model->_savejurnal($data);
    //Tabungan
    if ($kin_tabg > 0) {
      $numrekening = $this->request->getPost('knt_code');
      $dtaccount = $mgit->_get_acchutang($numrekening);
      foreach ($dtaccount->getResult() as $row) {
        $v_acc_code = $row->acc_code;
        $prd_cod1 = $row->prd_cdde;
        $prd_name = $row->prd_name;
        $tbg_cod1 = $row->tbg_code;
      }

      $data = array(
        'trx_code' => $v_trx_code, //$this->request->getPost('kin_code'),
        'trx_date' => $this->request->getPost('kin_date'),
        'acc_code'  => $v_acc_code,
        'trx_jens'  => $this->request->getPost('kin_type'),
        'trx_urut' => 1,
        'trx_dbcr'  => 'K',
        'trx_amnt'  => $kin_tabg,
        'dbt_amnt'  => 0,
        'crd_amnt'  => $kin_tabg,
        'trx_des1'  => 'Hutang ' . $prd_name,
        'trx_des2'  => 'Hutang' . $prd_name,
        'com_code'  => 1,
        'kode_cabang' => session()->get('kode_cabang'),
        'ent_time' => $waktu,
        'usercreated' => session()->get('username'),
      );
      $model->_savejurnal($data);



      // $kin_awal = 0;
      $v_dbt_amnt = 0;
      $v_crd_amnt = 0;
      $cektanggal = $modecek->_get_tgltabungan1($numrekening, $tanggal);

      $kin_code = $cektanggal['kin_code'];
      $kin_dat1 = $cektanggal['kin_dat1'];
      $kin_dat2 = $cektanggal['kin_date'];


      // if ($kin_code == '') {
      //   $kin_gtot = $kin_totl;
      //   $jmlhari = 0;
      // } else {
      //   $kin_gtot = $cektanggal['kin_gtot'];
      //   $kin_gtot = $kin_gtot + $kin_totl;
      //   $jmlhari = (($tanggal - $kin_dat1) / 60 / 60 / 24) + 1;
      // }
      $jenis = '01';
      if ($jenis == '01') {
        $debcrt = 'K';
        $v_crd_amnt = $kin_tabg;
        $v_dbt_amnt = 0;
      } else {
        $debcrt = 'D';
        $v_dbt_amnt = $kin_tabg;
        $v_crd_amnt = 0;
      }
      $kin_awal = 0;
      if ($kin_code == '') {
        $kin_gtot = $kin_tabg;
        // $kin_awal = 0;
        $kin_dat1 = $cektanggal['kin_date'];
        $jmlhari = (($tanggal - $kin_dat1) / 60 / 60 / 24);
      } else {
        $kin_dat1 = $cektanggal['kin_date'];
        // $kin_awal = $cektanggal['kin_akhr'];
        $kin_gtot = $kin_awal + $v_crd_amnt - $v_dbt_amnt;
        // $kin_dat1 = date('Y-m-d', strtotime($kin_dat1));
        $tanggl2 = strtotime($tanggal);
        $tanggl1 = strtotime($kin_dat1);
        $jmlhari = (($tanggl2 - $tanggl1) / 60 / 60 / 24);
      }
      $kin_akhr = floatval($kin_awal) - floatval($v_dbt_amnt) +  floatval($v_crd_amnt);
      $cek = $modecek->get_nosetoran($bulan, $tahun);
      if ($bulan < 10) {
        $bulan1 = '0' . $bulan;
      } else {
        $bulan1 = $bulan;
      }

      $nourut = $cek['kin_srno'];
      $kode_cabang = session()->get('kode_cabang');
      if ($nourut == '') {
        $nourut = 1;
        $v_trx_cod1 = $kode_cabang . '20.' . $tahun . $bulan . '00001';
      } else {
        $nourut = $nourut + 1;
        if ($nourut < 10) {
          $v_trx_cod1 = $kode_cabang . '20.' . $tahun . $bulan . '0000' . $nourut;
        } else if ($nourut >= 10 and $nourut < 100) {
          $v_trx_cod1 = $kode_cabang . '20.' . $tahun . $bulan . '000' . $nourut;
        } else if ($nourut >= 100 and $nourut < 1000) {
          $v_trx_cod1 = $kode_cabang . '20.' . $tahun . $bulan . '00' . $nourut;
        } else if ($nourut >= 1000 and $nourut < 10000) {
          $v_trx_cod1 = $kode_cabang . '20.' . $tahun . $bulan . '0' . $nourut;
        } else {
          $v_trx_cod1 = $kode_cabang . '20.' . $tahun . $bulan . $nourut;
        }
      }

      $data = array(
        'kin_code' => $v_trx_cod1,
        //$this->request->getvar('norek'),
        'kin_date' => $this->request->getvar('kin_date'),
        'agt_numb' =>  $this->request->getPost('agt_numb'),
        'bnk_code' =>  $this->request->getPost('bnk_code'),
        'acc_cash' => $v_acc_code,
        'kin_type' => $this->request->getPost('kin_type'),
        'kin_desc' => 'Titpan Setoran',
        'kin_note' => 'Titpan Setoran',
        'kin_stot' => $kin_tabg,

        //'acc_admn' => '',
        'acc_prod' => $v_acc_code,
        'tbg_code' => $numrekening,
        'kin_mont' => $bulan,
        'kin_year' => $tahun,
        'kin_totl' => $kin_tabg,
        'kin_srno' => $nourut,
        'kin_pstr' => $v_trx_code,
        'kin_jens' => '01',
        'kin_nstr' => 0,
        'kin_astr' => 0,
        'kin_prem' => 0,
        'kin_pajk' => 0,
        'kin_marg' => 0,
        'acc_prem' => '',
        'acc_pajk' => '',
        'acc_marg' => '',
        'kin_mstr' => 0,
        'kin_debt' => 0,
        'kin_crdt' => $kin_tabg,
        'kin_dbcr' => 'K',
        'kin_stat' => 0,
        'com_code' => 1,

        'trx_jens' => '01',
        'kode_cabang' => $kodecabang,
        'kin_gtot' => $kin_gtot,
        'kin_awal' => $kin_awal,
        'kin_akhr' => $kin_akhr,
        'kin_time' => $waktu,
        'kin_user' => 'Mobile',

      );

      $model->_savesetortabungan($data);
    }
    // Denda
    $denda = $kin_dendh;
    if ($denda > 0) {
      $code = '02';
      $caccount = $modecek->get_acckhusus($code);
      $v_acc_code = $caccount['acc_code'];
      $data = array(
        'trx_code' => $v_trx_code, //$this->request->getPost('kin_code'),
        'trx_date' => $this->request->getPost('kin_date'),
        'acc_code'  => $v_acc_code,
        'trx_jens'  => $this->request->getPost('kin_type'),
        'trx_urut' => 1,
        'trx_dbcr'  => 'K',
        'trx_amnt'  => $kin_dendh,
        'dbt_amnt'  => 0,
        'crd_amnt'  => $kin_dendh,
        'trx_des1'  => 'Denda ' . $this->request->getPost('prd_name') . ' - ' . $this->request->getPost('agt_name'),
        'trx_des2'  => 'Pendapatan Denda',
        'com_code'  => 1,
        'kode_cabang' => session()->get('kode_cabang'),
        'ent_time' => $waktu,
        'usercreated' => session()->get('username'),
      );
      $model->_savejurnal($data);
    }
    //admin
    // Jurnal Admin
    $admin = $kin_tadmn;
    if ($admin > 0) {
      $code = '01';
      // $caccount =  $modecek->get_acckhusus($code);
      $v_acc_code = $this->request->getPost('acc_admn');
      $data = array(
        'trx_code' => $v_trx_code, //$this->request->getPost('kin_code'),
        'trx_date' => $this->request->getPost('kin_date'),
        'acc_code'  => $v_acc_code,
        'trx_jens'  => $this->request->getPost('kin_type'),
        'trx_urut' => 1,
        'trx_dbcr'  => 'K',
        'trx_amnt'  => $kin_tadmn,
        'dbt_amnt'  => 0,
        'crd_amnt'  => $kin_tadmn,
        'trx_des1'  => 'Admin ' . $this->request->getPost('prd_name') . ' - ' . $this->request->getPost('agt_name'),
        'trx_des2'  => 'Pendapatan Admin',
        'com_code'  => 1,
        'kode_cabang' => session()->get('kode_cabang'),
        'ent_time' => $waktu,
        'usercreated' => session()->get('username'),
      );
      $model->_savejurnal($data);
    }
    // Jurnal Provisi

    if ($kin_tprov > 0) {
      $code = '06';
      $caccount = $modecek->get_acckhusus($code);
      $v_acc_code = $caccount['acc_code'];
      $data = array(
        'trx_code' => $v_trx_code, //$this->request->getPost('kin_code'),
        'trx_date' => $this->request->getPost('kin_date'),
        'acc_code'  => $v_acc_code,
        'trx_jens'  => $this->request->getPost('kin_type'),
        'trx_urut' => 1,
        'trx_dbcr'  => 'K',
        'trx_amnt'  => $kin_tprov,
        'dbt_amnt'  => 0,
        'crd_amnt'  => $kin_tprov,
        'trx_des1'  => 'Provisi ' . $this->request->getPost('prd_name') . ' - ' . $this->request->getPost('agt_name'),
        'trx_des2'  => 'Pendapatan Provisi',
        'com_code'  => 1,
        'kode_cabang' => session()->get('kode_cabang'),
        'ent_time' => $waktu,
        'usercreated' => session()->get('username'),
      );
      $model->_savejurnal($data);
    }

    if ($kin_notr > 0) {
      $code = '13';
      $caccount = $modecek->get_acckhusus($code);
      $v_acc_code = $caccount['acc_code'];
      $data = array(
        'trx_code' => $v_trx_code, //$this->request->getPost('kin_code'),
        'trx_date' => $this->request->getPost('kin_date'),
        'acc_code'  => $v_acc_code,
        'trx_jens'  => $this->request->getPost('kin_type'),
        'trx_urut' => 1,
        'trx_dbcr'  => 'K',
        'trx_amnt'  => $kin_notr,
        'dbt_amnt'  => 0,
        'crd_amnt'  => $kin_notr,
        'trx_des1'  => 'Notariel ' . $this->request->getPost('prd_name') . ' - ' . $this->request->getPost('agt_name'),
        'trx_des2'  => 'Notariel',
        'com_code'  => 1,
        'kode_cabang' => session()->get('kode_cabang'),
        'ent_time' => $waktu,
        'usercreated' => session()->get('username'),
      );
      $model->_savejurnal($data);
    }
    if ($kin_jiwa > 0) {
      $code = '12';
      $caccount = $modecek->get_acckhusus($code);
      $v_acc_code = $caccount['acc_code'];
      $data = array(
        'trx_code' => $v_trx_code, //$this->request->getPost('kin_code'),
        'trx_date' => $this->request->getPost('kin_date'),
        'acc_code'  => $v_acc_code,
        'trx_jens'  => $this->request->getPost('kin_type'),
        'trx_urut' => 1,
        'trx_dbcr'  => 'K',
        'trx_amnt'  => $kin_jiwa,
        'dbt_amnt'  => 0,
        'crd_amnt'  => $kin_simw,
        'trx_des2'  => 'Asuransi Jiwa ' . $this->request->getPost('prd_name') . ' - ' . $this->request->getPost('agt_name'),
        'trx_des1'  => 'Asuransi Jiwa ' . $this->request->getPost('agt_name'),
        'com_code'  => 1,
        'kode_cabang' => session()->get('kode_cabang'),
        'ent_time' => $waktu,
        'usercreated' => session()->get('username'),
      );
      $model->_savejurnal($data);
    }
    if ($kin_kend > 0) {
      $code = '10';
      $caccount = $modecek->get_acckhusus($code);
      $v_acc_code = $caccount['acc_code'];
      $data = array(
        'trx_code' => $v_trx_code, //$this->request->getPost('kin_code'),
        'trx_date' => $this->request->getPost('kin_date'),
        'acc_code'  => $v_acc_code,
        'trx_jens'  => $this->request->getPost('kin_type'),
        'trx_urut' => 1,
        'trx_dbcr'  => 'K',
        'trx_amnt'  => $kin_simw,
        'dbt_amnt'  => 0,
        'crd_amnt'  => $kin_simw,
        'trx_des2'  =>  'Asuransi Kendaraan ' . $this->request->getPost('prd_name') . ' - ' . $this->request->getPost('agt_name'),
        'trx_des1'  => 'Asuransi Kendaraan',
        'com_code'  => 1,
        'kode_cabang' => session()->get('kode_cabang'),
        'ent_time' => $waktu,
        'usercreated' => session()->get('username'),
      );
      $model->_savejurnal($data);
    }
    if ($kin_kebk > 0) {
      $code = '08';
      $caccount = $modecek->get_acckhusus($code);
      $v_acc_code = $caccount['acc_code'];
      $data = array(
        'trx_code' => $v_trx_code, //$this->request->getPost('kin_code'),
        'trx_date' => $this->request->getPost('kin_date'),
        'acc_code'  => $v_acc_code,
        'trx_jens'  => $this->request->getPost('kin_type'),
        'trx_urut' => 1,
        'trx_dbcr'  => 'K',
        'trx_amnt'  => $kin_kebk,
        'dbt_amnt'  => 0,
        'crd_amnt'  => $kin_kebk,
        'trx_des2'  => 'Premi Asuransi Kebakaran ' . $this->request->getPost('prd_name') . ' - ' . $this->request->getPost('agt_name'),
        'trx_des1'  => 'Premi Asuransi Kebakaran',
        'com_code'  => 1,
        'kode_cabang' => session()->get('kode_cabang'),
        'ent_time' => $waktu,
        'usercreated' => session()->get('username'),
      );
      $model->_savejurnal($data);
    }
    if ($kin_krdt > 0) {
      $code = '07';
      $caccount = $modecek->get_acckhusus($code);
      $v_acc_code = $caccount['acc_code'];
      $data = array(
        'trx_code' => $v_trx_code, //$this->request->getPost('kin_code'),
        'trx_date' => $this->request->getPost('kin_date'),
        'acc_code'  => $v_acc_code,
        'trx_jens'  => $this->request->getPost('kin_type'),
        'trx_urut' => 1,
        'trx_dbcr'  => 'K',
        'trx_amnt'  => $kin_krdt,
        'dbt_amnt'  => 0,
        'crd_amnt'  => $kin_krdt,
        'trx_des2'  => $this->request->getPost('prd_name') . ' - ' . $this->request->getPost('agt_name'),
        'trx_des1'  => 'Premi Asuransi Kredit',
        'com_code'  => 1,
        'kode_cabang' => session()->get('kode_cabang'),
        'ent_time' => $waktu,
        'usercreated' => session()->get('username'),
      );
      $model->_savejurnal($data);
    }
    if ($kin_dana > 0) {
      $code = '03';
      $caccount = $modecek->get_acckhusus($code);
      $v_acc_code = $caccount['acc_code'];
      $data = array(
        'trx_code' => $v_trx_code, //$this->request->getPost('kin_code'),
        'trx_date' => $this->request->getPost('kin_date'),
        'acc_code'  => $v_acc_code,
        'trx_jens'  => $this->request->getPost('kin_type'),
        'trx_urut' => 1,
        'trx_dbcr'  => 'K',
        'trx_amnt'  => $kin_dana,
        'dbt_amnt'  => 0,
        'crd_amnt'  => $kin_dana,
        'trx_des2'  => 'Dana Ditahan ' . $this->request->getPost('prd_name') . ' - ' . $this->request->getPost('agt_name'),
        'trx_des1'  => 'Tahan Dana Anggota '
          . $this->request->getPost('agt_name'),
        'com_code'  => 1,
        'kode_cabang' => session()->get('kode_cabang'),
        'ent_time' => $waktu,
        'usercreated' => session()->get('username'),
      );
      $model->_savejurnal($data);
    }
    if ($kin_lain > 0) {
      $code = '16';
      $caccount = $modecek->get_acckhusus($code);
      $v_acc_code = $caccount['acc_code'];
      $data = array(
        'trx_code' => $v_trx_code, //$this->request->getPost('kin_code'),
        'trx_date' => $this->request->getPost('kin_date'),
        'acc_code'  => $v_acc_code,
        'trx_jens'  => $this->request->getPost('kin_type'),
        'trx_urut' => 1,
        'trx_dbcr'  => 'K',
        'trx_amnt'  => $kin_lain,
        'dbt_amnt'  => 0,
        'crd_amnt'  => $kin_lain,
        'trx_des2'  => 'Pendapatan Admin ' . $this->request->getPost('prd_name') . ' - ' . $this->request->getPost('agt_name'),
        'trx_des1'  => 'Pendapatan Admin',
        'com_code'  => 1,
        'kode_cabang' => session()->get('kode_cabang'),
        'ent_time' => $waktu,
        'usercreated' => session()->get('username'),
      );
      $model->_savejurnal($data);
    }
    if ($kin_matr > 0) {
      $code = '14';
      $caccount = $modecek->get_acckhusus($code);
      $v_acc_code = $caccount['acc_code'];
      $data = array(
        'trx_code' => $v_trx_code, //$this->request->getPost('kin_code'),
        'trx_date' => $this->request->getPost('kin_date'),
        'acc_code'  => $v_acc_code,
        'trx_jens'  => $this->request->getPost('kin_type'),
        'trx_urut' => 1,
        'trx_dbcr'  => 'K',
        'trx_amnt'  => $kin_matr,
        'dbt_amnt'  => 0,
        'crd_amnt'  => $kin_matr,
        'trx_des1'  => 'Pendapatan materai ' . $this->request->getPost('prd_name') . ' - ' . $this->request->getPost('agt_name'), //$this->request->getPost('kin_desc'),
        'trx_des2'  => $this->request->getPost('prd_name') . ' - ' . $this->request->getPost('agt_name'),
        'com_code'  => 1,
        'kode_cabang' => session()->get('kode_cabang'),
        'ent_time' => $waktu,
        'usercreated' => session()->get('username'),
      );
      $model->_savejurnal($data);
    }

    if ($kin_pmat > 0) {
      $code = '14';
      $caccount = $modecek->get_acckhusus($code);
      $v_acc_code = $caccount['acc_code'];
      $data = array(
        'trx_code' => $v_trx_code, //$this->request->getPost('kin_code'),
        'trx_date' => $this->request->getPost('kin_date'),
        'acc_code'  => $v_acc_code,
        'trx_jens'  => $this->request->getPost('kin_type'),
        'trx_urut' => 1,
        'trx_dbcr'  => 'K',
        'trx_amnt'  => $kin_pmat,
        'dbt_amnt'  => 0,
        'crd_amnt'  => $kin_pmat,

        'trx_des1'  => 'Pokok Materai ' . $this->request->getPost('prd_name') . ' - ' . $this->request->getPost('agt_name'),
        'trx_des2'  => $this->request->getPost('prd_name') . ' - ' . $this->request->getPost('agt_name'),
        'com_code'  => 1,
        'kode_cabang' => session()->get('kode_cabang'),
        'ent_time' => $waktu,
        'usercreated' => session()->get('username'),
      );
      $model->_savejurnal($data);
    }
    if ($kin_rtgs > 0) {
      $code = '15';
      $caccount = $modecek->get_acckhusus($code);
      $v_acc_code = $caccount['acc_code'];
      $data = array(
        'trx_code' => $v_trx_code, //$this->request->getPost('kin_code'),
        'trx_date' => $this->request->getPost('kin_date'),
        'acc_code'  => $v_acc_code,
        'trx_jens'  => $this->request->getPost('kin_type'),
        'trx_urut' => 1,
        'trx_dbcr'  => 'K',
        'trx_amnt'  => $kin_rtgs,
        'dbt_amnt'  => 0,
        'crd_amnt'  => $kin_rtgs,

        'trx_des1'  => 'RTGS ' . $this->request->getPost('prd_name') . ' - ' . $this->request->getPost('agt_name'),
        'trx_des2'  => $this->request->getPost('prd_name') . ' - ' . $this->request->getPost('agt_name'),
        'com_code'  => 1,
        'kode_cabang' => session()->get('kode_cabang'),
        'ent_time' => $waktu,
        'usercreated' => session()->get('username'),
      );
      $model->_savejurnal($data);
    }

    if ($kin_pinl > 0) {
      $code = '04';
      $caccount = $modecek->get_acckhusus($code);
      $v_acc_code = $caccount['acc_code'];
      $data = array(
        'trx_code' => $v_trx_code, //$this->request->getPost('kin_code'),
        'trx_date' => $this->request->getPost('kin_date'),
        'acc_code'  => $v_acc_code,
        'trx_jens'  => $this->request->getPost('kin_type'),
        'trx_urut' => 1,
        'trx_dbcr'  => 'D',
        'trx_amnt'  => $kin_pinl,
        'dbt_amnt'  => 0,
        'crd_amnt'  => $kin_pinl,

        'trx_des1'  => 'Pinalti ' . $this->request->getPost('prd_name') . ' - ' . $this->request->getPost('agt_name'),
        'trx_des2'  => $this->request->getPost('prd_name') . ' - ' . $this->request->getPost('agt_name'),
        'com_code'  => 1,
        'kode_cabang' => session()->get('kode_cabang'),
        'ent_time' => $waktu,
        'usercreated' => session()->get('username'),
      );
      $model->_savejurnal($data);
    }

    if ($kin_simw > 0) {
      $code = '19';
      $caccount = $modecek->get_acckhusus($code);
      $v_acc_code = $caccount['acc_code'];
      $data = array(
        'trx_code' => $v_trx_code, //$this->request->getPost('kin_code'),
        'trx_date' => $this->request->getPost('kin_date'),
        'acc_code'  => $v_acc_code,
        'trx_jens'  => $this->request->getPost('kin_type'),
        'trx_urut' => 1,
        'trx_dbcr'  => 'D',
        'trx_amnt'  => $kin_simw,
        'dbt_amnt'  => 0,
        'crd_amnt'  => $kin_simw,

        'trx_des1'  => 'Simpanan Wajib ' . $this->request->getPost('prd_name') . ' - ' . $this->request->getPost('agt_name'),
        'trx_des2'  => $this->request->getPost('prd_name') . ' - ' . $this->request->getPost('agt_name'),
        'com_code'  => 1,
        'kode_cabang' => session()->get('kode_cabang'),
        'ent_time' => $waktu,
        'usercreated' => session()->get('username'),
      );
      $model->_savejurnal($data);
    }
    if ($kin_infq > 0) {
      $code = '11';
      $caccount = $modecek->get_acckhusus($code);
      $v_acc_code = $caccount['acc_code'];
      $data = array(
        'trx_code' => $v_trx_code, //$this->request->getPost('kin_code'),
        'trx_date' => $this->request->getPost('kin_date'),
        'acc_code'  => $v_acc_code,
        'trx_jens'  => $this->request->getPost('kin_type'),
        'trx_urut' => 1,
        'trx_dbcr'  => 'D',
        'trx_amnt'  => $kin_infq,
        'dbt_amnt'  => 0,
        'crd_amnt'  => $kin_infq,

        'trx_des1'  => 'Infaq ' . $this->request->getPost('prd_name') . ' - ' . $this->request->getPost('agt_name'),
        'trx_des2'  => $this->request->getPost('prd_name') . ' - ' . $this->request->getPost('agt_name'),
        'com_code'  => 1,
        'kode_cabang' => session()->get('kode_cabang'),
        'ent_time' => $waktu,
        'usercreated' => session()->get('username'),
      );
      $model->_savejurnal($data);
    }
    return redirect()->to('cash/setoran')->with('success', 'Menambah Data Berhasil');
  }
  //Update Pembiayaan
  public function updatesetorpembiayaan()

  {
    $note = "";
    $tanggal = $this->request->getPost('kin_date');
    $bulan = date(
      'm',
      strtotime($tanggal)
    );
    $tahun = date(
      'Y',
      strtotime($tanggal)
    );
    $model = new Save_model();
    $modecek = new Auto_model();
    $moddelete = new Delete_model();
    $jenis = $this->request->getPost('kin_type');
    $type = '07';
    $id = $this->request->getPost('kin_code');
    $kin_stot = str_replace(',', '', $this->request->getPost('kin_stot'));
    if ($this->request->getPost('kin_type') == '03') {
      $kin_tadmn = str_replace(',', '', $this->request->getPost('kin_radmn'));
    } else {
      $kin_tadmn = str_replace(',', '', $this->request->getPost('kin_tadmn'));
    }
    $kin_admn = str_replace(',', '', $this->request->getPost('kin_admn'));
    $kin_dendh = str_replace(',', '', $this->request->getPost('kin_dendh'));
    $kin_angsh = str_replace(',', '', $this->request->getPost('kin_angsh'));
    $kin_bungh = str_replace(',', '', $this->request->getPost('kin_bungh'));
    $kin_pokkh = str_replace(',', '', $this->request->getPost('kin_pokkh'));
    $kin_gtot = str_replace(',', '', $this->request->getPost('kin_gtot'));
    $kin_bungh = str_replace(',', '', $this->request->getPost('kin_bungh'));
    $kin_tcos = str_replace(',', '', $this->request->getPost('kin_tcos'));

    $kin_tprov = str_replace(',', '', $this->request->getPost('kin_tprov'));
    $kin_notr = str_replace(',', '', $this->request->getPost('kin_notr'));
    $kin_jiwa = str_replace(',', '', $this->request->getPost('kin_jiwa'));
    $kin_kend = str_replace(',', '', $this->request->getPost('kin_kend'));
    $kin_kebk = str_replace(',', '', $this->request->getPost('kin_kebk'));
    $kin_krdt = str_replace(',', '', $this->request->getPost('kin_krdt'));
    $kin_dana = str_replace(',', '', $this->request->getPost('kin_dana'));
    $kin_lain = str_replace(',', '', $this->request->getPost('kin_lain'));
    $kin_matr = str_replace(',', '', $this->request->getPost('kin_matr'));
    $kin_pmat = str_replace(',', '', $this->request->getPost('kin_pmat'));
    $kin_infq = str_replace(',', '', $this->request->getPost('kin_infq'));
    $kin_simw = str_replace(',', '', $this->request->getPost('kin_simw'));
    $kin_pinl = str_replace(',', '', $this->request->getPost('kin_pinl'));
    $kin_tdendh = str_replace(',', '', $this->request->getPost('kin_tdendh'));
    $kin_ddendh = str_replace(',', '', $this->request->getPost('kin_ddendh'));

    $kin_dadmn = str_replace(',', '', $this->request->getPost('kin_dadmn'));
    $kin_tbungh = str_replace(',', '', $this->request->getPost('kin_tbungh'));
    $kin_dbungh = str_replace(',', '', $this->request->getPost('kin_dbungh'));
    $kin_tpokkh = str_replace(',', '', $this->request->getPost('kin_tpokkh'));
    $kin_dpokkh = str_replace(',', '', $this->request->getPost('kin_dpokkh'));
    $kin_rtgs = str_replace(',', '', $this->request->getPost('kin_rtgs'));
    $kin_tran = str_replace(',', '', $this->request->getPost('kin_tran'));
    $data = array(

      'kin_date'       => $this->request->getPost('kin_date'),
      'agt_numb'       => $this->request->getPost('agt_numb'),
      'bnk_code'       => $this->request->getPost('bnk_code'),
      'knt_code'       => $this->request->getPost('knt_code'),
      'kin_type'       => $this->request->getPost('kin_type'),
      'kin_desc'       => $this->request->getPost('kin_desc'),
      'kin_stot'       => $kin_stot,
      'kin_admn'       => $kin_admn,
      'kin_jtdt'       => $this->request->getPost('kin_jtdth'),
      'kin_dend'       => $kin_dendh,
      'kin_angs'       => $kin_angsh,
      'kin_bung'       => $kin_bungh,
      'kin_pokk'       => $kin_pokkh,
      'kin_angk'       => $this->request->getPost('kin_angkh'),
      'kin_note'       => $note,
      'kin_totl'       => $kin_gtot,
      // 'kin_gtot'       => $kin_gtot,
      'acc_cash'       => $this->request->getPost('acc_cash'),
      'acc_prod'       => $this->request->getPost('acc_prod'),
      'acc_dend'       => $this->request->getPost('acc_dend'),
      'acc_admn'       => $this->request->getPost('acc_admn'),
      'acc_bung'       => $this->request->getPost('acc_bung'),
      'kin_tcos'       => $kin_tcos,
      'kin_tprov'      => $kin_tprov,
      'kin_notr'       => $kin_notr,
      'kin_jiwa'       => $kin_jiwa,
      'kin_kend'       => $kin_kend,
      'kin_kebk'       => $kin_kebk,
      'kin_krdt'       => $kin_krdt,
      'kin_dana'       => $kin_dana,
      'kin_lain'       => $kin_lain,
      'kin_matr'       => $kin_matr,
      'kin_pmat'       => $kin_pmat,
      'kin_infq'       => $kin_infq,
      'kin_simw'       => $kin_simw,
      'kin_pinl'       => $kin_pinl,
      'kin_tdendh'       => $kin_tdendh,
      'kin_ddendh'       => $kin_ddendh,
      'kin_tadmn'       => $kin_tadmn,
      'kin_dadmn'       => $kin_dadmn,
      'kin_tbungh'       => $kin_tbungh,
      'kin_dbungh'       => $kin_dbungh,
      'kin_tpokkh'       => $kin_tpokkh,
      'kin_dpokkh'       => $kin_dpokkh,
      'kin_rtgs'       => $kin_rtgs,
      'kin_tran'       => $kin_tran,
      'kin_mont'       => $bulan,
      'kin_year'       => $tahun,
      'kin_jens'  => 'K',
      'kin_stat' => '0',
      'com_code'  => 1,
    );

    $model->_updatecostpembiayaan($data, $id);



    if (
      $jenis == '01'
    ) {
      $id1 = $this->request->getPost('kin_angkh');
      $id = $this->request->getPost('knt_code');
      $data = array(

        'trx_lnsh'  => $kin_angsh,
        'lns_pokk'  => $kin_pokkh,
        'lns_bung'  => $kin_bungh,
        'lns_date'  => $this->request->getPost('kin_date'),
        'lns_code'  => $this->request->getPost('kin_code'),
      );

      $model->_Updatekartu($data, $id, $id1);
    }
    if (
      $jenis == '02'
    ) {

      $id = $this->request->getPost('knt_code');
      $v_angsuran = 0;
      $dtangsuran = $modecek->_get_angsuran($id);
      $v_angpokok = $dtangsuran['trx_pokk'];
      $v_anglunas = $dtangsuran['trx_lnsh'];
      $v_angbunga = $dtangsuran['trx_bung'];

      $data = array(

        'trx_lnsh'  => $v_anglunas,
        'lns_pokk'  => $v_angpokok,
        'lns_bung'  => $v_angbunga,
        'lns_date'  => $this->request->getPost('kin_date'),
        'lns_code'  => $this->request->getPost('kin_code'),
      );

      $model->_Updatekartuclose($data, $id);
    }

    // if ($jenis == '01') {

    //   $data = array(
    //     'knt_stat'  => 1,
    //     // 'knt_cair'  => 1,

    //   );

    //   $model->_updatekontrak($data, $id, $id1);
    // }

    if ($jenis == '02') {

      $data = array(
        'knt_stat'  => 2,
        // 'knt_cair'  => 1,

      );

      $model->_updatekontrak($data, $id);
    }

    if ($jenis == '03') {
      $data = array(
        'knt_cair'  => 1,
        'knt_stat'  => 1,
      );

      $model->_updatekontrak($data, $id);
    }
    $id = $this->request->getPost('kin_code');
    $moddelete->_deletejurnal($id);

    // Jurnal
    if ($jenis == '03') {
      $v_trx_dbcr = 'K';
      $v_dbt_amnt = 0;
      $v_crd_amnt = $kin_gtot;
    } else {
      $v_trx_dbcr = 'D';
      $v_dbt_amnt = $kin_gtot;
      $v_crd_amnt = 0;
    }

    $data = array(
      'trx_code' => $this->request->getPost('kin_code'),
      'trx_date' => $this->request->getPost('kin_date'),
      'acc_code'  => $this->request->getPost('acc_cash'),
      'trx_jens'  => $this->request->getPost('kin_type'),
      'trx_urut' => 1,
      'trx_dbcr'  => $v_trx_dbcr,
      'trx_amnt'  => $kin_gtot,
      'dbt_amnt'  => $v_dbt_amnt,
      'crd_amnt'  => $v_crd_amnt,
      'trx_des1'  => $this->request->getPost('kin_desc'),
      'trx_des2'  => '',
      'com_code'  => 1,
      'kode_cabang' => session()->get('kode_cabang'),

    );
    $model->_savejurnal($data);


    // Jurnal 
    //Piutang
    if ($jenis == '03') {
      $v_trx_dbcr = 'D';
      $v_dbt_amnt = $kin_tcos;
      $v_crd_amnt = 0;
      $v_trx_amnt = $kin_tcos;
    } else {
      $v_trx_dbcr = 'K';
      $v_dbt_amnt = 0;
      $v_crd_amnt = $kin_pokkh;
      $v_trx_amnt = $kin_pokkh;
    }

    $data = array(
      'trx_code' => $this->request->getPost('kin_code'),
      'trx_date' => $this->request->getPost('kin_date'),
      'acc_code'  => $this->request->getPost('acc_prod'),
      'trx_jens'  => $this->request->getPost('kin_type'),
      'trx_urut' => 1,
      'trx_dbcr'  => 'K',
      'trx_amnt'  => $v_trx_amnt,
      'dbt_amnt'  => $v_dbt_amnt,
      'crd_amnt'  => $v_crd_amnt,
      'trx_des1'  => $this->request->getPost('kin_desc'),
      'trx_des2'  => 'Piutang ',
      'com_code'  => 1,
      'kode_cabang' => session()->get('kode_cabang'),
    );
    $model->_savejurnal($data);


    // Pendapatan Bunga
    $data = array(
      'trx_code' => $this->request->getPost('kin_code'),
      'trx_date' => $this->request->getPost('kin_date'),
      'acc_code'  => $this->request->getPost('acc_bung'),
      'trx_jens'  => $this->request->getPost('kin_type'),
      'trx_urut' => 1,
      'trx_dbcr'  => 'K',
      'trx_amnt'  => $kin_bungh,
      'dbt_amnt'  => 0,
      'crd_amnt'  => $kin_bungh,
      'trx_des1'  => $this->request->getPost('kin_desc'),
      'trx_des2'  => 'Pendapatan Bunga',
      'com_code'  => 1,
      'kode_cabang' => session()->get('kode_cabang'),
    );
    $model->_savejurnal($data);
    // Denda
    $denda = $kin_dendh;
    if ($denda > 0) {
      $code = '02';
      $caccount = $modecek->get_acckhusus($code);
      $v_acc_code = $caccount['acc_code'];
      $data = array(
        'trx_code' => $this->request->getPost('kin_code'),
        'trx_date' => $this->request->getPost('kin_date'),
        'acc_code'  => $v_acc_code,
        'trx_jens'  => $this->request->getPost('kin_type'),
        'trx_urut' => 1,
        'trx_dbcr'  => 'K',
        'trx_amnt'  => $kin_dendh,
        'dbt_amnt'  => 0,
        'crd_amnt'  => $kin_dendh,
        'trx_des1'  => $this->request->getPost('kin_desc'),
        'trx_des2'  => 'Pendapatan Denda',
        'com_code'  => 1,
        'kode_cabang' => session()->get('kode_cabang'),
      );
      $model->_savejurnal($data);
    }
    //admin
    // Jurnal Admin
    $admin = $kin_tadmn;
    if ($admin > 0) {
      $code = '01';
      $caccount = $modecek->get_acckhusus($code);
      $v_acc_code = $caccount['acc_code'];
      $data = array(
        'trx_code' => $this->request->getPost('kin_code'),
        'trx_date' => $this->request->getPost('kin_date'),
        'acc_code'  => $v_acc_code,
        'trx_jens'  => $this->request->getPost('kin_type'),
        'trx_urut' => 1,
        'trx_dbcr'  => 'K',
        'trx_amnt'  => $kin_tadmn,
        'dbt_amnt'  => 0,
        'crd_amnt'  => $kin_tadmn,
        'trx_des1'  => $this->request->getPost('kin_desc'),
        'trx_des2'  => 'Pendapatan Admin',
        'com_code'  => 1,
        'kode_cabang' => session()->get('kode_cabang'),
      );
      $model->_savejurnal($data);
    }
    // Jurnal Provisi

    if ($kin_tprov > 0) {
      $code = '06';
      $caccount = $modecek->get_acckhusus($code);
      $v_acc_code = $caccount['acc_code'];
      $data = array(
        'trx_code' => $this->request->getPost('kin_code'),
        'trx_date' => $this->request->getPost('kin_date'),
        'acc_code'  => $v_acc_code,
        'trx_jens'  => $this->request->getPost('kin_type'),
        'trx_urut' => 1,
        'trx_dbcr'  => 'K',
        'trx_amnt'  => $kin_tprov,
        'dbt_amnt'  => 0,
        'crd_amnt'  => $kin_tprov,
        'trx_des1'  => $this->request->getPost('kin_desc'),
        'trx_des2'  => 'Pendapatan Provisi',
        'com_code'  => 1,
        'kode_cabang' => session()->get('kode_cabang'),
      );
      $model->_savejurnal($data);
    }

    if ($kin_notr > 0) {
      $code = '13';
      $caccount = $modecek->get_acckhusus($code);
      $v_acc_code = $caccount['acc_code'];
      $data = array(
        'trx_code' => $this->request->getPost('kin_code'),
        'trx_date' => $this->request->getPost('kin_date'),
        'acc_code'  => $v_acc_code,
        'trx_jens'  => $this->request->getPost('kin_type'),
        'trx_urut' => 1,
        'trx_dbcr'  => 'K',
        'trx_amnt'  => $kin_notr,
        'dbt_amnt'  => 0,
        'crd_amnt'  => $kin_notr,
        'trx_des1'  => $this->request->getPost('kin_desc'),
        'trx_des2'  => 'Notariel',
        'com_code'  => 1,
        'kode_cabang' => session()->get('kode_cabang'),
      );
      $model->_savejurnal($data);
    }
    if ($kin_jiwa > 0) {
      $code = '12';
      $caccount = $modecek->get_acckhusus($code);
      $v_acc_code = $caccount['acc_code'];
      $data = array(
        'trx_code' => $this->request->getPost('kin_code'),
        'trx_date' => $this->request->getPost('kin_date'),
        'acc_code'  => $v_acc_code,
        'trx_jens'  => $this->request->getPost('kin_type'),
        'trx_urut' => 1,
        'trx_dbcr'  => 'K',
        'trx_amnt'  => $kin_jiwa,
        'dbt_amnt'  => 0,
        'crd_amnt'  => $kin_simw,
        'trx_des2'  => $this->request->getPost('kin_desc'),
        'trx_des1'  => 'Asuransi Jiwa ' . $this->request->getPost('agt_name'),
        'com_code'  => 1,
        'kode_cabang' => session()->get('kode_cabang'),
      );
      $model->_savejurnal($data);
    }
    if ($kin_kend > 0) {
      $code = '10';
      $caccount = $modecek->get_acckhusus($code);
      $v_acc_code = $caccount['acc_code'];
      $data = array(
        'trx_code' => $this->request->getPost('kin_code'),
        'trx_date' => $this->request->getPost('kin_date'),
        'acc_code'  => $v_acc_code,
        'trx_jens'  => $this->request->getPost('kin_type'),
        'trx_urut' => 1,
        'trx_dbcr'  => 'K',
        'trx_amnt'  => $kin_simw,
        'dbt_amnt'  => 0,
        'crd_amnt'  => $kin_simw,
        'trx_des2'  => $this->request->getPost('kin_desc'),
        'trx_des1'  => 'Asuransi Kendaraan',
        'com_code'  => 1,
        'kode_cabang' => session()->get('kode_cabang'),
      );
      $model->_savejurnal($data);
    }
    if ($kin_kebk > 0) {
      $code = '08';
      $caccount = $modecek->get_acckhusus($code);
      $v_acc_code = $caccount['acc_code'];
      $data = array(
        'trx_code' => $this->request->getPost('kin_code'),
        'trx_date' => $this->request->getPost('kin_date'),
        'acc_code'  => $v_acc_code,
        'trx_jens'  => $this->request->getPost('kin_type'),
        'trx_urut' => 1,
        'trx_dbcr'  => 'K',
        'trx_amnt'  => $kin_kebk,
        'dbt_amnt'  => 0,
        'crd_amnt'  => $kin_kebk,
        'trx_des2'  => $this->request->getPost('kin_desc'),
        'trx_des1'  => 'Premi Asuransi Kebakaran',
        'com_code'  => 1,
        'kode_cabang' => session()->get('kode_cabang'),
      );
      $model->_savejurnal($data);
    }
    if ($kin_krdt > 0) {
      $code = '07';
      $caccount = $modecek->get_acckhusus($code);
      $v_acc_code = $caccount['acc_code'];
      $data = array(
        'trx_code' => $this->request->getPost('kin_code'),
        'trx_date' => $this->request->getPost('kin_date'),
        'acc_code'  => $v_acc_code,
        'trx_jens'  => $this->request->getPost('kin_type'),
        'trx_urut' => 1,
        'trx_dbcr'  => 'K',
        'trx_amnt'  => $kin_krdt,
        'dbt_amnt'  => 0,
        'crd_amnt'  => $kin_krdt,
        'trx_des2'  => $this->request->getPost('kin_desc'),
        'trx_des1'  => 'Premi Asuransi Kredit',
        'com_code'  => 1,
        'kode_cabang' => session()->get('kode_cabang'),
      );
      $model->_savejurnal($data);
    }
    if ($kin_dana > 0) {
      $code = '03';
      $caccount = $modecek->get_acckhusus($code);
      $v_acc_code = $caccount['acc_code'];
      $data = array(
        'trx_code' => $this->request->getPost('kin_code'),
        'trx_date' => $this->request->getPost('kin_date'),
        'acc_code'  => $v_acc_code,
        'trx_jens'  => $this->request->getPost('kin_type'),
        'trx_urut' => 1,
        'trx_dbcr'  => 'K',
        'trx_amnt'  => $kin_dana,
        'dbt_amnt'  => 0,
        'crd_amnt'  => $kin_dana,
        'trx_des2'  => $this->request->getPost('kin_desc'),
        'trx_des1'  => 'Tahan Dana Anggota '
          . $this->request->getPost('agt_name'),
        'com_code'  => 1,
        'kode_cabang' => session()->get('kode_cabang'),
      );
      $model->_savejurnal($data);
    }
    if ($kin_lain > 0) {
      $code = '16';
      $caccount = $modecek->get_acckhusus($code);
      $v_acc_code = $caccount['acc_code'];
      $data = array(
        'trx_code' => $this->request->getPost('kin_code'),
        'trx_date' => $this->request->getPost('kin_date'),
        'acc_code'  => $v_acc_code,
        'trx_jens'  => $this->request->getPost('kin_type'),
        'trx_urut' => 1,
        'trx_dbcr'  => 'K',
        'trx_amnt'  => $kin_lain,
        'dbt_amnt'  => 0,
        'crd_amnt'  => $kin_lain,
        'trx_des2'  => $this->request->getPost('kin_desc'),
        'trx_des1'  => 'Pendapatan Admin',
        'com_code'  => 1,
        'kode_cabang' => session()->get('kode_cabang'),
      );
      $model->_savejurnal($data);
    }
    if ($kin_matr > 0) {
      $code = '14';
      $caccount = $modecek->get_acckhusus($code);
      $v_acc_code = $caccount['acc_code'];
      $data = array(
        'trx_code' => $this->request->getPost('kin_code'),
        'trx_date' => $this->request->getPost('kin_date'),
        'acc_code'  => $v_acc_code,
        'trx_jens'  => $this->request->getPost('kin_type'),
        'trx_urut' => 1,
        'trx_dbcr'  => 'K',
        'trx_amnt'  => $kin_matr,
        'dbt_amnt'  => 0,
        'crd_amnt'  => $kin_matr,
        'trx_des1'  => 'Pendapatan materai', //$this->request->getPost('kin_desc'),
        'trx_des2'  => $this->request->getPost('kin_desc'),
        'com_code'  => 1,
        'kode_cabang' => session()->get('kode_cabang'),
      );
      $model->_savejurnal($data);
    }

    if ($kin_pmat > 0) {
      $code = '14';
      $caccount = $modecek->get_acckhusus($code);
      $v_acc_code = $caccount['acc_code'];
      $data = array(
        'trx_code' => $this->request->getPost('kin_code'),
        'trx_date' => $this->request->getPost('kin_date'),
        'acc_code'  => $v_acc_code,
        'trx_jens'  => $this->request->getPost('kin_type'),
        'trx_urut' => 1,
        'trx_dbcr'  => 'K',
        'trx_amnt'  => $kin_pmat,
        'dbt_amnt'  => 0,
        'crd_amnt'  => $kin_pmat,

        'trx_des1'  => 'Pokok Materai',
        'trx_des2'  => $this->request->getPost('kin_desc'),
        'com_code'  => 1,
        'kode_cabang' => session()->get('kode_cabang'),
      );
      $model->_savejurnal($data);
    }
    if ($kin_rtgs > 0) {
      $code = '15';
      $caccount = $modecek->get_acckhusus($code);
      $v_acc_code = $caccount['acc_code'];
      $data = array(
        'trx_code' => $this->request->getPost('kin_code'),
        'trx_date' => $this->request->getPost('kin_date'),
        'acc_code'  => $v_acc_code,
        'trx_jens'  => $this->request->getPost('kin_type'),
        'trx_urut' => 1,
        'trx_dbcr'  => 'K',
        'trx_amnt'  => $kin_rtgs,
        'dbt_amnt'  => 0,
        'crd_amnt'  => $kin_rtgs,

        'trx_des1'  => 'RTGS',
        'trx_des2'  => $this->request->getPost('kin_desc'),
        'com_code'  => 1,
        'kode_cabang' => session()->get('kode_cabang'),
      );
      $model->_savejurnal($data);
    }

    if ($kin_pinl > 0) {
      $code = '04';
      $caccount = $modecek->get_acckhusus($code);
      $v_acc_code = $caccount['acc_code'];
      $data = array(
        'trx_code' => $this->request->getPost('kin_code'),
        'trx_date' => $this->request->getPost('kin_date'),
        'acc_code'  => $v_acc_code,
        'trx_jens'  => $this->request->getPost('kin_type'),
        'trx_urut' => 1,
        'trx_dbcr'  => 'D',
        'trx_amnt'  => $kin_pinl,
        'dbt_amnt'  => 0,
        'crd_amnt'  => $kin_pinl,

        'trx_des1'  => 'Pinalti',
        'trx_des2'  => $this->request->getPost('kin_desc'),
        'com_code'  => 1,
        'kode_cabang' => session()->get('kode_cabang'),
      );
      $model->_savejurnal($data);
    }

    if ($kin_simw > 0) {
      $code = '19';
      $caccount = $modecek->get_acckhusus($code);
      $v_acc_code = $caccount['acc_code'];
      $data = array(
        'trx_code' => $this->request->getPost('kin_code'),
        'trx_date' => $this->request->getPost('kin_date'),
        'acc_code'  => $v_acc_code,
        'trx_jens'  => $this->request->getPost('kin_type'),
        'trx_urut' => 1,
        'trx_dbcr'  => 'D',
        'trx_amnt'  => $kin_simw,
        'dbt_amnt'  => 0,
        'crd_amnt'  => $kin_simw,

        'trx_des1'  => 'Simpanan Wajib',
        'trx_des2'  => $this->request->getPost('kin_desc'),
        'com_code'  => 1,
        'kode_cabang' => session()->get('kode_cabang'),
      );
      $model->_savejurnal($data);
    }
    if ($kin_infq > 0) {
      $code = '11';
      $caccount = $modecek->get_acckhusus($code);
      $v_acc_code = $caccount['acc_code'];
      $data = array(
        'trx_code' => $this->request->getPost('kin_code'),
        'trx_date' => $this->request->getPost('kin_date'),
        'acc_code'  => $v_acc_code,
        'trx_jens'  => $this->request->getPost('kin_type'),
        'trx_urut' => 1,
        'trx_dbcr'  => 'D',
        'trx_amnt'  => $kin_infq,
        'dbt_amnt'  => 0,
        'crd_amnt'  => $kin_infq,

        'trx_des1'  => 'Infaq',
        'trx_des2'  => $this->request->getPost('kin_desc'),
        'com_code'  => 1,
        'kode_cabang' => session()->get('kode_cabang'),
      );
      $model->_savejurnal($data);
    }

    return redirect()->to('cash/setoran')->with('success', 'Merubah Data Berhasil');
  }
  //end

  public function setortabungan()
  {
    $model = new Model_git();
    $_SESSION['com_menu'] = '03';
    $_SESSION['com_men1'] = '0302';
    $_SESSION['com_men2'] = '';

    $tanggal = date("Y-m-d");
    $data['hariini'] = $tanggal;
    $cabang  = session()->get('kode_cabang');
    $id = '01';
    if ($_SESSION['usr_jabt'] == 'Administrator') {
      $data['v_setortabungan']  = $model->_get_setortabungana($tanggal, $id)->getResult();
    } else {
      $data['v_setortabungan']  = $model->_get_setortabungan($tanggal, $cabang, $id)->getResult();
    }

    return view('kas/setortabungan/setortabungan_list', $data);
  }

  public function addsetortabungan()
  {
    $model = new Model_git();

    $id = "01";
    $id1 = "08";
    $id2 = "09";
    $tanggal = date('Y-m-d');
    $cabang  = session()->get('kode_cabang');
    $data['tgl2'] = $tanggal;
    $data['v_bank']  = $model->_getbank_cab($cabang)->getResult();
    // $data['v_kontrak']  = $model->_get_lkontrak()->getResult();
    $data['v_khusus']  = $model->_acckhusus($id)->getResult();
    $data['v_premi']  = $model->_acckhusus($id1)->getResult();
    $data['v_pajak']  = $model->_acckhusus($id2)->getResult();
    // $data['v_rekening']  = $model->_get_rektabungan()->getResult();
    return view('kas/setortabungan/setortabungan_add', $data);
  }

  public function savesetortabungan()
  {


    $model = new Save_model();
    $mgit = new Model_git();
    $modecek = new Auto_model();
    $note = "";
    $tanggal = $this->request->getPost('kin_date');
    $xprod1 = $this->request->getPost('prd_code');
    $xprod = substr($xprod1, 0, 1);
    $bulan = date('m', strtotime($tanggal));
    $tahun = date('Y', strtotime($tanggal));
    $waktu = date('Y-d-m H:i:s');
    $type = '11';

    $jns = $this->request->getPost('kin_type');
    $description = $this->request->getPost('kin_desc');
    $cek = $modecek->get_nosetortabungan($bulan, $tahun);
    $nourut = $cek['kin_srno'];
    $norek = $this->request->getPost('tbg_code');
    $cek1 = $modecek->get_setortabungan($norek);
    $rekening = $cek1['tbg_code'];


    $kodecabang = session()->get('kode_cabang');
    // if ($description == '') {
    if ($jns == '01') {

      $description = 'Setoran ' . $this->request->getPost('prd_name') . ' - ' . $this->request->getPost('agt_name');
      $description1 = 'Setoran ' . $this->request->getPost('prd_name');
    } else if ($jns == '02') {
      $description = 'Penarikan Tunai ' . $this->request->getPost('prd_name') . ' - ' . $this->request->getPost('agt_name');
      $description1 = 'Penarikan Tunai ' . $this->request->getPost('prd_name');
    } else if ($jns == '03') {
      $description = 'Penutupan Rekening : ' . $this->request->getPost('prd_name') . ' - ' . $this->request->getPost('agt_name');
      $description1 = 'Penutupan Rekening : ' . $this->request->getPost('prd_name');
    } else {
      $description = $this->request->getPost('prd_name') . ' - ' . $this->request->getPost('agt_name');
      $description1 = $this->request->getPost('prd_name');
    }

    // }
    if ($nourut == '') {
      $nourut = 1;
      $v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . '00001';
      $v_trx_urut = $kodecabang . '11' . $tahun . $bulan . '00001';
    } else {
      $nourut = $nourut + 1;
      if ($nourut < 10) {
        $v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . '0000' . $nourut;
        $v_trx_urut = $kodecabang . '11' . $tahun . $bulan . '0000' . $nourut;

      } else if ($nourut >= 10 and $nourut < 100) {
        $v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . '000' . $nourut;

 $v_trx_urut = $kodecabang . '11' . $tahun . $bulan . '000' . $nourut;
      } else if ($nourut >= 100 and $nourut < 1000) {
        $v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . '00' . $nourut;
 $v_trx_urut = $kodecabang . '11' . $tahun . $bulan . '00' . $nourut;

      } else if ($nourut >= 1000 and $nourut < 10000) {
        $v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . '0' . $nourut;
 $v_trx_urut = $kodecabang . '11' . $tahun . $bulan . '0' . $nourut;

      } else {
        $v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . $nourut;
 $v_trx_urut = $kodecabang . '11' . $tahun . $bulan  . $nourut;

      }
    }


    $kin_stot = str_replace(',', '', $this->request->getPost('kin_stot'));
    $kin_admn = str_replace(',', '', $this->request->getPost('kin_admn'));
    $kin_totl = str_replace(',', '', $this->request->getPost('kin_totl'));
    $kin_nstr = str_replace(',', '', $this->request->getPost('kin_nstr'));
    $kin_astr = str_replace(',', '', $this->request->getPost('kin_astr'));
    $kin_prem = str_replace(',', '', $this->request->getPost('kin_prem'));
    $kin_pajk = str_replace(',', '', $this->request->getPost('kin_pajk'));
    $kin_marg = str_replace(',', '', $this->request->getPost('kin_marg'));
    $kin_mstr = str_replace(',', '', $this->request->getPost('kin_mstr'));
    $kin_awal = str_replace(',', '', $this->request->getPost('tbg_sald'));
    $acc_cash = '';
    $accbank = $modecek->get_bank($this->request->getPost('bnk_code'));
    $acc_cash = $accbank['acc_code'];
    $cektanggal = $modecek->_get_tgltabungan($norek, $tanggal, $bulan, $tahun);
    $kin_code = $cektanggal['kin_code'];
    $kin_dat1 = $cektanggal['kin_dat1'];
    $kin_dat2 = $cektanggal['kin_date'];

    // if ($kin_code == '') {
    //   $kin_gtot = $kin_totl;
    //   $jmlhari = 0;
    // } else {
    //   $kin_gtot = $cektanggal['kin_gtot'];
    //   $kin_gtot = $kin_gtot + $kin_totl;
    //   $jmlhari = (($tanggal - $kin_dat1) / 60 / 60 / 24) + 1;
    // }
    if ($jns == '01') {
      $debcrt = 'K';
      $v_crd_amnt = $kin_stot; //$kin_totl;
      $v_dbt_amnt = 0;
    } else {
      $debcrt = 'D';
      $v_dbt_amnt = $kin_totl;
      $v_crd_amnt = 0;
    }
    $kin_akhr = $kin_awal - $v_dbt_amnt + $v_crd_amnt;
    if ($kin_code == '') {
      if ($jns == '01') {
        $kin_gtot = $kin_stot;
      } else {
        $kin_gtot = $kin_totl;
      }
      $kin_dat1 = $cektanggal['kin_date'];
      $jmlhari = (($tanggal - $kin_dat1) / 60 / 60 / 24);
    } else {
      $kin_dat1 = $cektanggal['kin_date'];
      $kin_gtot = $cektanggal['kin_gtot'];
      $kin_gtot = $kin_gtot + $v_crd_amnt - $v_dbt_amnt;
      // $kin_dat1 = date('Y-m-d', strtotime($kin_dat1));
      $tanggl2 = strtotime($tanggal);
      $tanggl1 = strtotime($kin_dat1);
      $jmlhari = (($tanggl2 - $tanggl1) / 60 / 60 / 24);
    }

    $data = array(
      'kin_code' => $v_trx_code,
      //$this->request->getPost('kin_code'),
      'kin_date' => $this->request->getPost('kin_date'),
      'agt_numb' => $this->request->getPost('agt_numb'),
      'bnk_code' => $this->request->getPost('bnk_code'),
      'acc_cash' => $acc_cash,
      'kin_type' => $this->request->getPost('prd_code'),
      'kin_desc' => $description,
      'kin_note' => $note,
      'kin_stot' => $kin_stot,
      'kin_admn' => $kin_admn,
      'acc_admn' => $this->request->getPost('acc_admn'),
      'acc_prod' => $this->request->getPost('acc_prod'),
      'tbg_code' => $this->request->getPost('tbg_code'),
      'kin_mont' => $bulan,
      'kin_year' => $tahun,
      'kin_totl' => $kin_totl,
      'kin_srno' => $nourut,
      'kin_jens' => $this->request->getPost('kin_type'),
      'kin_nstr' => $kin_nstr,
      'kin_astr' => $kin_astr,
      'kin_prem' => $kin_prem,
      'kin_pajk' => $kin_pajk,
      'kin_marg' => $kin_marg,
      'acc_prem' => $this->request->getPost('acc_prem'),
      'acc_pajk' => $this->request->getPost('acc_pajk'),
      'acc_marg' => $this->request->getPost('acc_marg'),
      'kin_mstr' => $kin_mstr,
      'kin_debt' => $v_dbt_amnt,
      'kin_crdt' => $v_crd_amnt,
      'kin_dbcr' => $debcrt,
      'kin_stat' => 0,
      'com_code' => session()->get('com_code'),
      'trx_jens' => '01',
      'kode_cabang' => $kodecabang,
      'kin_gtot' => $kin_gtot,
      'kin_awal' => $kin_awal,
      'kin_akhr' => $kin_akhr,
      'kin_time' => date('Y/m/d H:s:m'),
      'kin_user' => session()->get('username'),

    );
    $model->_savesetortabungan($data);
    if ($jns != '01') {
      if ($kin_admn > 0) {
        $cek = $modecek->get_nosetortabungan($bulan, $tahun);
        $nourut = $cek['kin_srno'];
        if ($nourut == '') {
          $nourut = 1;
          $v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . '00001';
        } else {
          $nourut = $nourut + 1;
          if ($nourut < 10) {
            $v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . '0000' . $nourut;
          } else if ($nourut >= 10 and $nourut < 100) {
            $v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . '000' . $nourut;
          } else if ($nourut >= 100 and $nourut < 1000) {
            $v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . '00' . $nourut;
          } else if ($nourut >= 1000 and $nourut < 10000) {
            $v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . '0' . $nourut;
          } else {
            $v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . $nourut;
          }
        }
        $sldawal = $mgit->saldotabungan($norek);
        $kin_awal = 0;
        foreach ($sldawal->getResult() as $awal) {
          $kin_awal = $awal->kin_awal;
        }
        // if ($jenistype == '01') {
        //   $kin_akhr =
        //     $kin_awal + $kin_admn;
        // } else {
        $kin_akhr = $kin_awal - $kin_admn;
        // }
        // $ceksaldo1 = $modecek->_get_tgltabungan($norek, $tanggal, $bulan, $tahun);
        // $kin_gsal = $ceksaldo1['kin_gtot'];

        // $kin_akhr = $kin_gsal - $kin_admn;
        $data = array(
          'kin_code' => $v_trx_code,
          //$this->request->getPost('kin_code'),
          'kin_date' => $this->request->getPost('kin_date'),
          'agt_numb' => $this->request->getPost('agt_numb'),
          'bnk_code' => $this->request->getPost('bnk_code'),
          'acc_cash' => $acc_cash,
          'kin_type' => $this->request->getPost('prd_code'),
          'kin_desc' => 'Adiministrasi Penarikan',
          'kin_note' => $note,
          'kin_stot' => 0,
          'kin_admn' => $kin_admn,
          'acc_admn' => $this->request->getPost('acc_admn'),
          'acc_prod' => $this->request->getPost('acc_prod'),
          'tbg_code' => $this->request->getPost('tbg_code'),
          'kin_mont' => $bulan,
          'kin_year' => $tahun,
          'kin_totl' => $kin_admn,
          'kin_srno' => $nourut,
          'kin_jens' => $this->request->getPost('kin_type'),
          'kin_nstr' => $kin_nstr,
          'kin_astr' => $kin_astr,
          'kin_prem' => $kin_prem,
          'kin_pajk' => $kin_pajk,
          'kin_marg' => $kin_marg,
          'acc_prem' => $this->request->getPost('acc_prem'),
          'acc_pajk' => $this->request->getPost('acc_pajk'),
          'acc_marg' => $this->request->getPost('acc_marg'),
          'kin_mstr' => $kin_mstr,
          'kin_debt' => $kin_admn,
          'kin_crdt' => 0,
          'kin_dbcr' => 'D',
          'kin_stat' => 0,
          'com_code' => session()->get('com_code'),
          'trx_jens' => '20',
          'kode_cabang' => $kodecabang,
          'kin_gtot' => $kin_gtot,
          'kin_awal' =>  $kin_awal,
          'kin_akhr' => $kin_akhr,
          'kin_time' => date('Y/m/d H:s:m'),
          'kin_user' => session()->get('username'),

        );
        $model->_savesetortabungan($data);
      }

      if ($kin_prem > 0) {
        $cek = $modecek->get_nosetortabungan($bulan, $tahun);
        $nourut = $cek['kin_srno'];
        if ($nourut == '') {
          $nourut = 1;
          $v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . '00001';
        } else {
          $nourut = $nourut + 1;
          if ($nourut < 10) {
            $v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . '0000' . $nourut;
          } else if ($nourut >= 10 and $nourut < 100) {
            $v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . '000' . $nourut;
          } else if ($nourut >= 100 and $nourut < 1000) {
            $v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . '00' . $nourut;
          } else if ($nourut >= 1000 and $nourut < 10000) {
            $v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . '0' . $nourut;
          } else {
            $v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . $nourut;
          }
        }
        $kin_akhr = 0;
        $kin_gsal = 0;
        // $ceksaldo1 = $modecek->_get_tgltabungan($norek, $tanggal, $bulan, $tahun);
        // $kin_gsal = $ceksaldo1['kin_gtot'];
        $sldawal = $mgit->saldotabungan($rekening);
        $kin_awal = 0;
        foreach ($sldawal->getResult() as $awal) {
          $kin_awal = $awal->kin_awal;
        }

        $kin_akhr = $kin_awal - $kin_prem;
        $data = array(
          'kin_code' => $v_trx_code,
          //$this->request->getPost('kin_code'),
          'kin_date' => $this->request->getPost('kin_date'),
          'agt_numb' => $this->request->getPost('agt_numb'),
          'bnk_code' => $this->request->getPost('bnk_code'),
          'acc_cash' => $acc_cash,
          'kin_type' => $this->request->getPost('prd_code'),
          'kin_desc' => 'Adiministrasi ',
          'kin_note' => $note,
          'kin_stot' => 0,
          'kin_admn' => 0,
          'acc_admn' => $this->request->getPost('acc_admn'),
          'acc_prod' => $this->request->getPost('acc_prod'),
          'tbg_code' => $this->request->getPost('tbg_code'),
          'kin_mont' => $bulan,
          'kin_year' => $tahun,
          'kin_totl' => $kin_prem,
          'kin_srno' => $nourut,
          'kin_jens' => $this->request->getPost('kin_type'),
          'kin_nstr' => $kin_nstr,
          'kin_astr' => $kin_astr,
          'kin_prem' => $kin_prem,
          'kin_pajk' => 0,
          'kin_marg' => $kin_marg,
          'acc_prem' => $this->request->getPost('acc_prem'),
          'acc_pajk' => $this->request->getPost('acc_pajk'),
          'acc_marg' => $this->request->getPost('acc_marg'),
          'kin_mstr' => $kin_mstr,
          'kin_debt' => $kin_prem,
          'kin_crdt' => 0,
          'kin_dbcr' => 'D',
          'kin_stat' => 0,
          'com_code' => session()->get('com_code'),

          'trx_jens' => '21',
          'kode_cabang' => $kodecabang,
          'kin_gtot' => $kin_gtot,
          'kin_awal' =>  $kin_awal,
          'kin_akhr' => $kin_akhr,
          'kin_time' => date('Y/m/d H:s:m'),
          'kin_user' => session()->get('username'),

        );
        $model->_savesetortabungan($data);
      }
      if ($kin_pajk > 0) {
        $cek = $modecek->get_nosetortabungan($bulan, $tahun);
        $nourut = $cek['kin_srno'];
        if ($nourut == '') {
          $nourut = 1;
          $v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . '00001';
        } else {
          $nourut = $nourut + 1;
          if ($nourut < 10) {
            $v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . '0000' . $nourut;
          } else if ($nourut >= 10 and $nourut < 100) {
            $v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . '000' . $nourut;
          } else if ($nourut >= 100 and $nourut < 1000) {
            $v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . '00' . $nourut;
          } else if ($nourut >= 1000 and $nourut < 10000) {
            $v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . '0' . $nourut;
          } else {
            $v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . $nourut;
          }
        }
        $kin_akhr = 0;
        $kin_gsal = 0;
        // $ceksaldo1 = $modecek->_get_tgltabungan($norek, $tanggal, $bulan, $tahun);
        // $kin_gsal = $ceksaldo1['kin_gtot'];
        $sldawal = $mgit->saldotabungan($rekening);
        $kin_awal = 0;
        foreach ($sldawal->getResult() as $awal) {
          $kin_awal = $awal->kin_awal;
        }

        $kin_akhr = $kin_awal - $kin_pajk;
        $data = array(
          'kin_code' => $v_trx_code,
          //$this->request->getPost('kin_code'),
          'kin_date' => $this->request->getPost('kin_date'),
          'agt_numb' => $this->request->getPost('agt_numb'),
          'bnk_code' => $this->request->getPost('bnk_code'),
          'acc_cash' => $acc_cash,
          'kin_type' => $this->request->getPost('prd_code'),
          'kin_desc' => 'Biaya Pajak ',
          'kin_note' => $note,
          'kin_stot' => 0,
          'kin_admn' => 0,
          'acc_admn' => $this->request->getPost('acc_admn'),
          'acc_prod' => $this->request->getPost('acc_prod'),
          'tbg_code' => $this->request->getPost('tbg_code'),
          'kin_mont' => $bulan,
          'kin_year' => $tahun,
          'kin_totl' => $kin_pajk,
          'kin_srno' => $nourut,
          'kin_jens' => $this->request->getPost('kin_type'),
          'kin_nstr' => $kin_nstr,
          'kin_astr' => $kin_astr,
          'kin_prem' => 0,
          'kin_pajk' => $kin_pajk,
          'kin_marg' => 0,
          'acc_prem' => $this->request->getPost('acc_prem'),
          'acc_pajk' => $this->request->getPost('acc_pajk'),
          'acc_marg' => $this->request->getPost('acc_marg'),
          'kin_mstr' => $kin_mstr,
          'kin_debt' => $kin_pajk,
          'kin_crdt' => 0,
          'kin_dbcr' => 'D',
          'kin_stat' => 0,
          'com_code' => session()->get('com_code'),

          'trx_jens' => '22',
          'kode_cabang' => $kodecabang,
          'kin_gtot' => $kin_gtot,
          'kin_awal' =>  $kin_awal,
          'kin_akhr' => $kin_akhr,
          'kin_time' => date('Y/m/d H:s:m'),
          'kin_user' => session()->get('username'),

        );
        $model->_savesetortabungan($data);
      }
    }

    if ($jns == '01') {
      $data = array(
        'kin_code' => $v_trx_code,
        //$this->request->getPost('kin_code'),
        'kin_date' => $this->request->getPost('kin_date'),
        'agt_numb' => $this->request->getPost('agt_numb'),
        'bnk_code' => $this->request->getPost('bnk_code'),
        'acc_cash' => $acc_cash,
        'knt_code' => $this->request->getPost('knt_code'),
        'kin_type' => $this->request->getPost('prd_code'),
        'kin_desc' => $description,
        'kin_note' => $note,
        'kin_stot' => $kin_stot,
        'kin_admn' => $kin_admn,
        'acc_admn' => $this->request->getPost('acc_admn'),
        'acc_prod' => $this->request->getPost('acc_prod'),
        'kin_dend' => 0,
        'kin_angs' => 0,
        'kin_bung' => 0,
        'kin_pokk' => 0,
        'kin_mont' => $bulan,
        'kin_year' => $tahun,
        'kin_totl' => $kin_totl,
        'kin_stat' => 0,
        'kin_jens' => '03',
        'com_code' => session()->get('com_code'),
        'kode_cabang' => session()->get('kode_cabang'),
      );

      $model->_savesetorpembiayaan($data);
    }


    $data = array(
      'kin_dat1' => $this->request->getPost('kin_date'),
      'kin_hari' => $jmlhari,
      // 'kin_apus' => $kin_dat1,
    );

    $model->_updatetabungantgl($data, $kin_code);

    // $tgltabungan = $modelgit->_get_tgltabungan($this->request->getPost('tbg_code'), $this->request->getPost('kin_date'), $bulan, $tahun);
    // foreach ($tgltabungan->getResult()  as $rowtrans) {

    //   $data = array(
    //     'kin_dat1' => $this->request->getPost('kin_date'),
    //     'kin_apus' => 1,
    //   );
    //   $idtrans = $rowtrans->kin_code;
    //   $model->_updatetabungantgl($data,  $idtrans);
    //   // var_dump($data);
    // }
    // Jurnal
    if ($jns == '01') {
      $v_trx_dbcr = 'D';
      $v_trx_debt = $kin_totl;
      $v_trx_crdt = 0;
    } else {
      $v_trx_dbcr = 'K';
      $v_trx_debt = 0;
      $v_trx_crdt = $kin_totl;
    }
    if ($jns == '01') {
      if ($xprod == '3') {
        $cabang = session()->get('kode_cabang');
        if ($cabang != '100') {
          $cabcod12 = '100';
        } else {
          $cabcod12 = session()->get('kode_cabang');
        }
      } else {
        $cabcod12 = session()->get('kode_cabang');
      }
    } else {
      $cabcod12 = session()->get('kode_cabang');
    }
    $data = array(
      'trx_code' => $v_trx_code,
      //$this->request->getPost('kin_code'),
      'trx_date' => $this->request->getPost('kin_date'),
      'acc_code' => $acc_cash,
      'trx_jens' => $this->request->getPost('kin_type'),
      'psb_code' => $this->request->getPost('prd_code'),
      'trx_urut' => 1,
      'trx_dbcr' => $v_trx_dbcr,
      'trx_amnt' => $kin_totl,
      'dbt_amnt' => $v_trx_debt,
      'crd_amnt' => $v_trx_crdt,
      'trx_des1' => $description,
      'trx_des2' => $description1,
      'com_code' => session()->get('com_code'),
      'kode_cabang' => session()->get('kode_cabang'),
      'ent_time' => $waktu,
      'usercreated' => session()->get('username'),
    );
    $model->_savejurnal($data);


    // Jurnal

    if ($jns == '01') {
      $v_trx_dbcr = 'K';
      $v_trx_debt = 0;
      $v_trx_crdt = $kin_stot;
    } else {
      $v_trx_dbcr = 'D';
      $v_trx_debt = $kin_stot;
      $v_trx_crdt = 0;
    }

    $data = array(
      'trx_code' => $v_trx_code,
      //$this->request->getPost('kin_code'),
      'trx_date' => $this->request->getPost('kin_date'),
      'acc_code' => $this->request->getPost('acc_prod'),
      'trx_jens' => $this->request->getPost('kin_type'),
      'trx_urut' => 1,
      'trx_dbcr' => $v_trx_dbcr,
      'trx_amnt' => $kin_stot,
      'dbt_amnt' => $v_trx_debt,
      'crd_amnt' => $v_trx_crdt,
      'trx_des1' => $description,
      'trx_des2' => $description1,
      'com_code' => 1,
      'kode_cabang' => $cabcod12,
      'ent_time' => $waktu,
      'usercreated' => session()->get('username'),
    );
    $model->_savejurnal($data);

    //admin
    // Jurnal Admin
    $admin = $this->request->getPost('kin_admn');
    if ($admin > 0) {
      $data = array(
        'trx_code' => $v_trx_code,
        //$this->request->getPost('kin_code'),
        'trx_date' => $this->request->getPost('kin_date'),
        'acc_code' => $this->request->getPost('acc_admn'),
        'trx_jens' => $this->request->getPost('kin_type'),
        'trx_urut' => 1,
        'trx_dbcr' => 'K',
        'trx_amnt' => $kin_admn,
        'dbt_amnt' => 0,
        'crd_amnt' => $kin_admn,
        'trx_des1' => 'Administrasi ' . $this->request->getPost('prd_name') . ' - ' . $this->request->getPost('agt_name'),
        'trx_des2' => $description,
        'com_code' => 1,
        'kode_cabang' => session()->get('kode_cabang'),
        'ent_time' => $waktu,
        'usercreated' => session()->get('username'),
      );
      $model->_savejurnal($data);
    }
    //Premi
    // Jurnal Premi
    $premi = $this->request->getPost('kin_prem');
    if ($premi > 0) {
      $data = array(
        'trx_code' => $v_trx_code,
        //$this->request->getPost('kin_code'),
        'trx_date' => $this->request->getPost('kin_date'),
        'acc_code' => $this->request->getPost('acc_prem'),
        'trx_jens' => $this->request->getPost('kin_type'),
        'trx_urut' => 1,
        'trx_dbcr' => 'K',
        'trx_amnt' => $kin_prem,
        'dbt_amnt' => 0,
        'crd_amnt' => $kin_prem,
        'trx_des1' => 'Premi' . $this->request->getPost('prd_name') . ' - ' . $this->request->getPost('agt_name'),
        'trx_des2' => $description,
        'com_code' => 1,
        'kode_cabang' => session()->get('kode_cabang'),
        'ent_time' => $waktu,
        'usercreated' => session()->get('username'),
      );
      $model->_savejurnal($data);
    }


    // Jurnal Pajak
    if ($jns == '01') {
      $v_trx_dbcr = 'D';
      $v_trx_debt = $kin_pajk;
      $v_trx_crdt = 0;
    } else {
      $v_trx_dbcr = 'K';
      $v_trx_debt = 0;
      $v_trx_crdt = $kin_pajk;
    }

    $pajak = $kin_pajk;
    if ($pajak > 0) {
      $data = array(
        'trx_code' => $v_trx_code,
        //$this->request->getPost('kin_code'),
        'trx_date' => $this->request->getPost('kin_date'),
        'acc_code' => $this->request->getPost('acc_pajk'),
        'trx_jens' => $this->request->getPost('kin_type'),
        'trx_urut' => 1,
        'trx_dbcr' => $v_trx_dbcr,
        'trx_amnt' => $kin_pajk,
        'dbt_amnt' => $v_trx_debt,
        'crd_amnt' => $v_trx_crdt,
        'trx_des1' => 'Pajak ' . $this->request->getPost('prd_name') . ' - ' . $this->request->getPost('agt_name'),
        'trx_des2' => $description,
        'com_code' => 1,
        'kode_cabang' => session()->get('kode_cabang'),
        'ent_time' => $waktu,
        'usercreated' => session()->get('username'),
      );
      $model->_savejurnal($data);
    }

    // Magin
    if ($jns == '01') {
      $v_trx_dbcr = 'K';
      $v_trx_debt = 0;
      $v_trx_crdt = $kin_marg;
    } else {
      $v_trx_dbcr = 'D';
      $v_trx_debt = $kin_marg;
      $v_trx_crdt = 0;
    }

    $bunga = $kin_marg;

    if ($bunga > 0) {
      $data = array(
        'trx_code' => $v_trx_code,
        //$this->request->getPost('kin_code'),
        'trx_date' => $this->request->getPost('kin_date'),
        'acc_code' => $this->request->getPost('acc_marg'),
        'trx_jens' => $this->request->getPost('kin_type'),
        'trx_urut' => 1,
        'trx_dbcr' => $v_trx_dbcr,
        'trx_amnt' => $kin_marg,
        'dbt_amnt' => $v_trx_debt,
        'crd_amnt' => $v_trx_crdt,
        'trx_des1' => 'Bunga ' . $this->request->getPost('prd_name') . ' - ' . $this->request->getPost('agt_name'),
        'trx_des2' => $description,
        'com_code' => 1,
        'kode_cabang' => session()->get('kode_cabang'),
        'ent_time' => $waktu,
        'usercreated' => session()->get('username'),
      );
      $model->_savejurnal($data);
    }
    $id = $this->request->getPost('tbg_code');

    if ($jns == '03') {
      $vstatus = '2';
      $data = array(

        'tbg_stat' => $vstatus,
        'tbg_clos' => $this->request->getPost('kin_date'),

      );
      $model->_updatetabungan($data, $id);
    }

    if ($rekening == '') {
      if ($jns == '01') {

        $vstatus = '1';
        $data = array(

          'tbg_stat' => $vstatus,
          'tbg_aktv' => $this->request->getPost('kin_date'),
          'tbg_awal' => $kin_stot,

        );
        $model->_updatetabungan($data, $id);
      }
    }

    if ($jns == '01') {

      if ($xprod == '3') {
        // $model->_savejurnal10($data);
        $cabang = session()->get('kode_cabang');
        if ($cabang != '100') {
          $dbakuncabang = $mgit->get_dtakuncabang('100');
          foreach ($dbakuncabang->getResult() as $row) {
            $acc_cab1 = $row->acc_arcd;
          }

          $data = array(
            'trx_code' => $v_trx_code,
            //$this->request->getPost('kin_code'),
            'trx_date' => $this->request->getPost('kin_date'),
            'acc_code' => $acc_cab1,
            'trx_jens' => $this->request->getPost('kin_type'),
            'trx_urut' => 1,
            'trx_dbcr' => 'D',
            'trx_amnt' => $kin_totl,
            'dbt_amnt' => $kin_totl,
            'crd_amnt' => 0,
            'trx_des1' => 'Piutang ' . $this->request->getPost('prd_name') . ' - ' . $this->request->getPost('agt_name'),
            'trx_des2' => 'Piutang cabang :' . $this->request->getPost('prd_name'),
            'com_code' => session()->get('com_code'),
            'kode_cabang' => '100',
            //()->get('kode_cabang'),
            'ent_time' => $waktu,
            'usercreated' => session()->get('username'),
          );
          $model->_savejurnal($data);
          // Piutang
          $dbakuncabang = $mgit->get_dtakuncabang($cabang);
          foreach ($dbakuncabang->getResult() as $row1) {
            $acc_cab2 = $row->acc_apcd;
          }
          $data = array(
            'trx_code' => $v_trx_code,
            //$this->request->getPost('kin_code'),
            'trx_date' => $this->request->getPost('kin_date'),
            'acc_code' => $acc_cab2,
            'trx_jens' => $this->request->getPost('kin_type'),
            'trx_urut' => 1,
            'trx_dbcr' => 'K',
            'trx_amnt' => $kin_totl,
            'dbt_amnt' => 0,
            'crd_amnt' => $kin_totl,
            'trx_des1' => 'Hutang ' . $this->request->getPost('prd_name') . ' - ' . $this->request->getPost('agt_name'),
            'trx_des2' => 'Hutang cabang :' . $this->request->getPost('prd_name'),
            'com_code' => session()->get('com_code'),
            'kode_cabang' => session()->get('kode_cabang'),
            'ent_time' => $waktu,
            'usercreated' => session()->get('username'),
          );
          $model->_savejurnal($data);
        }
      }
    }


    return redirect()->to('cash/setortabungan')->with('success', 'Menambah Data Berhasil');
  }

  public function edittabungan($id)
  {
    $model = new Model_git();
    $cabang = session()->get('kode_cabang');
    $data['v_bank']  = $model->_getbank_cab($cabang)->getResult();
    $data['v_rekening']  = $model->_get_rektabungan()->getResult();
    $data['tabungan']  = $model->_get_edsetortabungan($id)->getResult();
    return view('kas/setortabungan/setortabungan_edit', $data);
  }
  public function deletetabungan($id)
  {
    $model = new Delete_model();
    // $id = $this->request->getPost('code');
    $model->m_deletekastabungan($id);
    $model->_deletejurnal($id);
    return redirect()->to('cash/hapustabungan')->with('success', 'Menghapus Data Berhasil');
  }

  public function editpembiayaan($id)
  {
    $model = new Model_git();
    $model1 = new Master_model();
    $cabang = session()->get('kode_cabang');
    $data['v_bank']  = $model->_getbank_cab($cabang)->getResult();
    $data['v_kontrak']  = $model->_get_lkontrak()->getResult();
    $data['v_biaya']  = $model->_get_dpembiayaan($id)->getResult();
    return view('kas/in/in_edit', $data);
  }
  public function deletepembiayaan($id)
  {
    $model = new Delete_model();
    // $id = $this->request->getPost('code');
    $model->m_deletekaspembiayaan($id);
    $model->_deletejurnal($id);
    return redirect()->to('cash/setoran')->with('success', 'Menghapus Data Berhasil');
  }

  public function kasssb()
  {
    $model = new Model_git();
    $_SESSION['com_menu'] = '03';
    $_SESSION['com_men1'] = '';
    $_SESSION['com_men2'] = '';
    $tanggal = date('Y/m/d');
    $cabang  = session()->get('kode_cabang');
    if ($_SESSION['usr_jabt'] == 'Administrator') {
      $data['v_ssb']  = $model->_get_cashssba($tanggal)->getResult();
    } else {
      $data['v_ssb']  = $model->_get_cashssb($tanggal, $cabang)->getResult();
    }

    return view('kas/ssb/kasssb_list', $data);
  }

  public function addkasssb()
  {
    $model = new Model_git();

    $id = "01";
    $id1 = "08";
    $id2 = "09";
    $tanggal = date('Y-m-d');
    $data['tgl2'] = $tanggal;

    $cabang = session()->get('kode_cabang');
    $data['v_bank']  = $model->_getbank_cab($cabang)->getResult();
    $data['v_khusus']  = $model->_acckhusus($id)->getResult();
    $data['v_premi']  = $model->_acckhusus($id1)->getResult();
    $data['v_pajak']  = $model->_acckhusus($id2)->getResult();
    // $data['v_rekening']  = $model->_get_rekssb()->getResult();
    return view('kas/ssb/kasssb_add', $data);
  }

  public function editkasssb($id)
  {
    $model = new Model_git();
    $cabang = session()->get('kode_cabang');
    $data['v_bank']  = $model->_getbank_cab($cabang)->getResult();
    $data['v_rekening']  = $model->_get_rekssb()->getResult();
    $data['v_ssb']  = $model->_get_editcashssb($id)->getResult();
    return view('kas/ssb/kasssb_edit', $data);
  }

  public function deletekasssb($id)
  {
    $model = new Delete_model();
    // $id = $this->request->getPost('code');
    $data = $model->_deletekasssb($id);
    $data = $model->_deletejurnaldtl($id);
    return redirect()->to('cash/kasssb')->with('success', 'Menghapus Data Berhasil');
  }

  public function savekasssb()
  {
    $model = new Save_model();
    $modecek = new Auto_model();
    $note = "";
    $tanggal = $this->request->getPost('kin_date');
    $bulan = date('m', strtotime($tanggal));
    $tahun = date('Y', strtotime($tanggal));
    $waktu = date('Y-m-d H:i:s');
    $type = '11';
    $cek = $modecek->get_nosetorssb($bulan, $tahun);
    $jns = $this->request->getPost('kin_type');
    if ($jns == '01') {

      $description = 'Setoran ' . $this->request->getPost('prd_name') . ' - ' . $this->request->getPost('agt_name');
      $description1 = 'Setoran ' . $this->request->getPost('prd_name');
    } else if ($jns == '02') {
      $description = 'Pengambilan Basil ' . $this->request->getPost('prd_name') . ' - ' . $this->request->getPost('agt_name');
      $description1 = 'Pengambilan Basil ' . $this->request->getPost('prd_name');
    } else if ($jns == '03') {
      $description = 'Top Up ' . $this->request->getPost('prd_name') . ' - ' . $this->request->getPost('agt_name');
      $description1 = 'Top Up ' . $this->request->getPost('prd_name');
    } else if ($jns == '04') {
      $description = 'Penutupan Rekening : ' . $this->request->getPost('prd_name') . ' - ' .  $this->request->getPost('agt_name');
      $description1 = 'Penutupan Rekening : ' . $this->request->getPost('prd_name');
    } else {
      $description = $this->request->getPost('prd_name') . ' - ' .  $this->request->getPost('agt_name');
      $description = $this->request->getPost('prd_name');
    }


    $nourut = $cek['kin_srno'];
    $kodecabang = session()->get('kode_cabang');
    if ($nourut == '') {
      $nourut = 1;
      $v_trx_code = $kodecabang . '.13.' . $tahun . $bulan . '00001';
    } else {
      $nourut = $nourut + 1;
      if ($nourut < 10) {
        $v_trx_code = $kodecabang . '.13.' . $tahun . $bulan . '0000' . $nourut;
      } else if ($nourut >= 10 and $nourut < 100) {
        $v_trx_code = $kodecabang . '.13.' . $tahun . $bulan . '000' . $nourut;
      } else if ($nourut >= 100 and $nourut < 1000) {
        $v_trx_code = $kodecabang . '.13.' . $tahun . $bulan . '00' . $nourut;
      } else if ($nourut >= 1000 and $nourut < 10000) {
        $v_trx_code = $kodecabang . '.13.' . $tahun . $bulan . '0' . $nourut;
      } else {
        $v_trx_code = $kodecabang . '.13.' . $tahun . $bulan . $nourut;
      }
    }



    $kin_stot = str_replace(',', '', $this->request->getPost('kin_stot'));
    $kin_admn = str_replace(',', '', $this->request->getPost('kin_admn'));
    $kin_totl = str_replace(',', '', $this->request->getPost('kin_totl'));
    $kin_prem = str_replace(',', '', $this->request->getPost('kin_prem'));
    $kin_pajk = str_replace(',', '', $this->request->getPost('kin_pajk'));
    $kin_marg = str_replace(',', '', $this->request->getPost('kin_marg'));
    $kin_pilt = str_replace(',', '', $this->request->getPost('kin_pilt'));
    $kin_mstr = str_replace(',', '', $this->request->getPost('kin_mstr'));
    $acc_cash = '';
    $accbank = $modecek->get_bank($this->request->getPost('bnk_code'));
    $acc_cash = $accbank['acc_code'];
    $data = array(
      'kin_code'       => $v_trx_code, //$this->request->getPost('kin_code'),
      'kin_date'       => $this->request->getPost('kin_date'),
      'agt_numb'       => $this->request->getPost('agt_numb'),
      'bnk_code'       => $this->request->getPost('bnk_code'),
      'acc_code'       => $this->request->getPost('acc_cash'),
      'acc_cash'       => $acc_cash,
      'kin_type'       => $this->request->getPost('kin_type'),
      'prd_code'       => $this->request->getPost('prd_code'),
      'kin_desc'       => $this->request->getPost('kin_desc'),
      'kin_note'       => $note,
      'kin_stot'       => $kin_stot,
      'kin_admn'       => $kin_admn,
      'acc_admn'       => $this->request->getPost('acc_admn'),
      'acc_prod'       => $this->request->getPost('acc_prod'),
      'pen_code'       => $this->request->getPost('tbg_code'),
      'kin_mont'       => $bulan,
      'kin_year'       => $tahun,
      'kin_totl'       => $kin_totl,
      'kin_srno'       => $nourut,
      'kin_jens'        => $this->request->getPost('kin_type'),
      'kin_prem'       => $kin_prem,
      'kin_pajk'       => $kin_pajk,
      'kin_marg'       => $kin_marg,
      'kin_pilt'       => $kin_pilt,
      'acc_prem'       => $this->request->getPost('acc_prem'),
      'acc_pajk'       => $this->request->getPost('acc_pajk'),
      'acc_marg'       => $this->request->getPost('acc_marg'),
      'kin_mstr'       => $kin_mstr,
      'kin_stat' => 0,
      'com_code'  => session()->get('com_code'),
      'kode_cabang'  => session()->get('kode_cabang'),


    );

    $model->_savekasssb($data);
    // if (trim($this->request->getPost('kin_type')) == '01') {
    //   $setor = $kin_stot;
    // } else {
    //   $setor = 0;
    // }
    // $data = array(
    //   'kin_code'       => $v_trx_code, //$this->request->getPost('kin_code'),
    //   'kin_date'       => $this->request->getPost('kin_date'),
    //   'agt_numb'       => $this->request->getPost('agt_numb'),
    //   'bnk_code'       => $this->request->getPost('bnk_code'),
    //   'acc_code'       => $this->request->getPost('acc_cash'),
    //   'acc_cash'       => $this->request->getPost('acc_cash'),
    //   'kin_type'       => $this->request->getPost('kin_type'),
    //   'prd_code'       => $this->request->getPost('prd_code'),
    //   'kin_desc'       => $this->request->getPost('kin_desc'),
    //   'kin_note'       => $note,
    //   'kin_setr'       => $setor,
    //   'kin_stot'       => $kin_stot,
    //   'kin_admn'       => $kin_admn,
    //   'acc_admn'       => $this->request->getPost('acc_admn'),
    //   'acc_prod'       => $this->request->getPost('acc_prod'),
    //   'pen_code'       => $this->request->getPost('tbg_code'),
    //   'kin_mont'       => $bulan,
    //   'kin_year'       => $tahun,
    //   'kin_totl'       => $kin_totl,
    //   'kin_srno'       => $nourut,
    //   'kin_jens'        => $this->request->getPost('kin_type'),
    //   'kin_prem'       => $kin_prem,
    //   'kin_pajk'       => $kin_pajk,
    //   'kin_marg'       => $kin_marg,
    //   'kin_pilt'       => $kin_pilt,
    //   'acc_prem'       => $this->request->getPost('acc_prem'),
    //   'acc_pajk'       => $this->request->getPost('acc_pajk'),
    //   'acc_marg'       => $this->request->getPost('acc_marg'),
    //   'kin_mstr'       => $kin_mstr,
    //   'kin_stat' => 0,
    //   'com_code'  => session()->get('com_code'),
    //   'kode_cabang'  => session()->get('kode_cabang'),


    // );

    // $model->_savetransssb($data);
    //     if ($jns=='01'){
    //     $data = array(
    //       'kin_code'       => $v_trx_code,//$this->request->getPost('kin_code'),
    //       'kin_date'       => $this->request->getPost('kin_date'),
    //       'agt_numb'       => $this->request->getPost('agt_numb'),
    //       'bnk_code'       => $this->request->getPost('bnk_code'),
    //       'acc_cash'       => $this->request->getPost('acc_cash'),
    //       'knt_code'       => $this->request->getPost('knt_code'),
    //       'kin_type'       => $this->request->getPost('prd_code'),
    //       'kin_desc'       => $this->request->getPost('kin_desc'),
    //       'kin_note'       => $note,
    //       'kin_stot'       => $this->request->getPost('kin_stot'),
    //       'kin_admn'       => $this->request->getPost('kin_admn'),
    //       'acc_admn'       => $this->request->getPost('acc_admn'),
    //       'acc_prod'       => $this->request->getPost('acc_prod'),
    //       'kin_dend'       => 0,
    //       'kin_angs'       => 0,
    //       'kin_bung'       => 0,
    //       'kin_pokk'       => 0,
    //       'kin_mont'       => $bulan,
    //       'kin_year'       => $tahun,
    //       'kin_totl'       => $this->request->getPost('kin_totl'),
    //       'kin_stat' => 0,
    //       'kin_jens' => 'T',
    //        'com_code'  => session()->get('com_code'),
    //   );

    //   $model->_savesetorpembiayaan($data);
    // }

    // Jurnal
    if ($jns == '01') {
      $v_trx_dbcr = 'D';
      $v_trx_debt = $kin_totl;
      $v_trx_crdt = 0;
    } else {
      $v_trx_dbcr = 'K';
      $v_trx_debt = 0;
      $v_trx_crdt = $kin_totl;
    }

    $data = array(
      'trx_code' => $v_trx_code, //$this->request->getPost('kin_code'),
      'trx_date' => $this->request->getPost('kin_date'),
      'acc_code'  => $acc_cash,
      'trx_jens'  => $this->request->getPost('kin_type'),
      'psb_code'  => $this->request->getPost('prd_code'),
      'trx_urut' => 1,
      'trx_dbcr'  => $v_trx_dbcr,
      'trx_amnt'  => $kin_totl,
      'dbt_amnt'  => $v_trx_debt,
      'crd_amnt'  => $v_trx_crdt,
      'trx_des1'  => $description,
      'trx_des2'  =>  $description1,
      'com_code'  => 1,
      'kode_cabang'  => session()->get('kode_cabang'),
      'ent_time' => $waktu,
      'usercreated' => session()->get('username'),
    );
    $model->_savejurnal($data);


    // Jurnal

    if ($jns == '01') {
      $v_trx_dbcr = 'K';
      $v_trx_debt = 0;
      $v_trx_crdt = $kin_stot;
    } else {
      $v_trx_dbcr = 'D';
      $v_trx_debt = $kin_stot;
      $v_trx_crdt = 0;
    }

    if (($v_trx_debt + $v_trx_crdt) > 0) {

      $data = array(
        'trx_code' => $v_trx_code, //$this->request->getPost('kin_code'),
        'trx_date' => $this->request->getPost('kin_date'),
        'acc_code'  => $this->request->getPost('acc_prod'),
        'trx_jens'  => $this->request->getPost('kin_type'),
        'psb_code'  => $this->request->getPost('prd_code'),
        'trx_urut' => 1,
        'trx_dbcr'  => $v_trx_dbcr,
        'trx_amnt'  => $kin_stot,
        'dbt_amnt'  => $v_trx_debt,
        'crd_amnt'  => $v_trx_crdt,
        'trx_des1'  => $description,
        'trx_des2'  =>  $description1,
        'com_code'  => 1,
        'kode_cabang'  => session()->get('kode_cabang'),
        'ent_time' => $waktu,
        'usercreated' => session()->get('username'),
      );
      $model->_savejurnal($data);
    }


    //admin materai
    // Jurnal Admin
    $admin = $kin_admn;
    if ($admin > 0) {
      $data = array(
        'trx_code' => $v_trx_code, //$this->request->getPost('kin_code'),
        'trx_date' => $this->request->getPost('kin_date'),
        'acc_code'  => $this->request->getPost('acc_admn'),
        'trx_jens'  => $this->request->getPost('kin_type'),
        'trx_urut' => 1,
        'trx_dbcr'  => 'K',
        'trx_amnt'  => $kin_admn,
        'dbt_amnt'  => 0,
        'crd_amnt'  => $kin_admn,
        'trx_des1'  => 'Addmin ' . $this->request->getPost('prd_name') . ' - ' . $this->request->getPost('agt_name'),
        'trx_des2'  => $this->request->getPost('prd_name') . ' - ' . $this->request->getPost('agt_name'),
        'com_code'  => 1,
        'kode_cabang'  => session()->get('kode_cabang'),
        'ent_time' => $waktu,
        'usercreated' => session()->get('username'),
      );
      $model->_savejurnal($data);
    }
    //Premi 
    // Jurnal Premi / Titipan
    $premi = $kin_prem;
    if ($premi > 0) {
      $data = array(
        'trx_code' => $v_trx_code, //$this->request->getPost('kin_code'),
        'trx_date' => $this->request->getPost('kin_date'),
        'acc_code'  => $this->request->getPost('acc_prem'),
        'trx_jens'  => $this->request->getPost('kin_type'),
        'trx_urut' => 1,
        'trx_dbcr'  => 'K',
        'trx_amnt'  =>  $kin_prem,
        'dbt_amnt'  => 0,
        'crd_amnt'  => $kin_prem,
        'trx_des1'  => 'Premi ' . $this->request->getPost('prd_name') . ' - ' . $this->request->getPost('agt_name'),
        'trx_des2'  => '',
        'com_code'  => 1,
        'kode_cabang'  => session()->get('kode_cabang'),
        'ent_time' => $waktu,
        'usercreated' => session()->get('username'),
      );
      $model->_savejurnal($data);
    }


    // Jurnal Pajak


    $pajak = $kin_pajk;
    if ($pajak > 0) {
      $data = array(
        'trx_code' => $v_trx_code, //$this->request->getPost('kin_code'),
        'trx_date' => $this->request->getPost('kin_date'),
        'acc_code'  => $this->request->getPost('acc_pajk'),
        'trx_jens'  => $this->request->getPost('kin_type'),
        'trx_urut' => 1,
        'trx_dbcr'  => 'K',
        'trx_amnt'  =>  $kin_pajk,
        'dbt_amnt'  => 0,
        'crd_amnt'  =>  $kin_pajk,
        'trx_des1'  => 'Pajak ' . $this->request->getPost('prd_name') . ' - ' . $this->request->getPost('agt_name'),
        'trx_des2'  => '',
        'com_code'  => 1,
        'kode_cabang'  => session()->get('kode_cabang'),
        'ent_time' => $waktu,
        'usercreated' => session()->get('username'),
      );
      $model->_savejurnal($data);
    }

    // Magin
    // if ($jns=='01'){
    //   $v_trx_dbcr='K';
    //   $v_trx_debt=0;
    //   $v_trx_crdt=$this->request->getPost('kin_marg');
    // } else {
    //   $v_trx_dbcr='D';
    //   $v_trx_debt=$this->request->getPost('kin_marg');
    //   $v_trx_crdt=0;
    // }

    $bunga = $kin_marg;

    if ($bunga > 0) {
      $data = array(
        'trx_code' => $v_trx_code, //$this->request->getPost('kin_code'),
        'trx_date' => $this->request->getPost('kin_date'),
        'acc_code'  => $this->request->getPost('acc_marg'),
        'trx_jens'  => $this->request->getPost('kin_type'),
        'trx_urut' => 1,
        'trx_dbcr'  => 'D',
        'trx_amnt'  => $kin_marg,
        'dbt_amnt'  => $kin_marg,
        'crd_amnt'  => 0,
        'trx_des1'  => 'Bunga ' . $this->request->getPost('prd_name') . ' - ' . $this->request->getPost('agt_name'),
        'trx_des2'  => '',
        'com_code'  => 1,
        'kode_cabang'  => session()->get('kode_cabang'),
        'ent_time' => $waktu,
        'usercreated' => session()->get('username'),
      );
      $model->_savejurnal($data);
    }
    if ($jns == '01') {
      $id = $this->request->getPost('tbg_code');
      $data = array(

        'pen_stat'  => 1,
        'pen_aktv' => $this->request->getPost('kin_date'),
      );
      $model->_updatepenempatan($data, $id);
    }
    if ($jns == '04') {
      $id = $this->request->getPost('tbg_code');
      $data = array(

        'pen_stat'  => 2,
        'pnt_date' => $this->request->getPost('kin_date'),
      );
      $model->_updatepenempatan($data, $id);
    }
    if ($jns == '04') {
      $data = array(
        'trx_code' => $v_trx_code,
        //$this->request->getPost('kin_code'),
        'trx_date' => $this->request->getPost('kin_date'),
        'acc_code' => $this->request->getPost('acc_marg'),
        'trx_jens' => $this->request->getPost('kin_type'),
        'trx_urut' => 1,
        'trx_dbcr' => 'D',
        'trx_amnt' => $kin_marg,
        'dbt_amnt' => $kin_marg,
        'crd_amnt' => 0,
        'trx_des1' => 'Penutupan ' . $this->request->getPost('prd_name') . ' - ' . $this->request->getPost('agt_name'),
        'trx_des2' => '',
        'com_code' => 1,
        'kode_cabang' => session()->get('kode_cabang'),
        'ent_time' => $waktu,
        'usercreated' => session()->get('username'),
      );
      $model->_savejurnal($data);
    }

    if ($jns == '02') {
      $data = array(
        'trx_code' => $v_trx_code, //$this->request->getPost('kin_code'),
        'rek_date' => $this->request->getPost('kin_date'),
        'tbg_code' => $this->request->getPost('tbg_code'),
        'agt_numb' => $this->request->getPost('agt_numb'),
        'trn_code'  => $jns,
        'ttp_ambl'  => $kin_prem,
        'pok_ambl' => $kin_stot,
        'jas_amnt' => (-1 * $kin_marg),
        'jas_pajk' => (-1 * $kin_pajk),
        'trx_desc'  => 'PENGAMBILAN BASIL',
        'com_code'  => 1,
        'kode_cabang'  => session()->get('kode_cabang'),

        //'usercreated' => session()->get('username'),
      );
      $model->_savetranssb($data);
    }

    if ($jns == '01') {
      $data = array(
        'trx_code' => $v_trx_code, //$this->request->getPost('kin_code'),
        'rek_date' => $this->request->getPost('kin_date'),
        'tbg_code' => $this->request->getPost('tbg_code'),
        'agt_numb' => $this->request->getPost('agt_numb'),
        'trn_code'  => $jns,
        'ttp_ambl'  => 0,
        'pok_ambl' => 0,
        'jas_amnt' => 0,
        'jas_pajk' => 0,
        'pok_setr' => $kin_stot,
        'trx_desc'  => 'SETORAN SSB',
        'com_code'  => 1,
        'kode_cabang'  => session()->get('kode_cabang'),

        //  'usercreated' => session()->get('username'),
      );
      $model->_savetranssb($data);
    }
    $norekening = trim($this->request->getPost('tbg_code'));
    $bulan1 = trim($this->request->getPost('jas_mont'));
    $tahun1 = trim($this->request->getPost('jas_year'));

    if ($jns == '02') {
      $data = array(
        'jas_bayr' => $kin_marg,
        'jas_bpph' => $kin_pajk,
        'jas_btip' => $kin_prem,
      );
      $model->_updatejasa2($data, $norekening, $bulan1, $tahun1);
    }
    return redirect()->to('cash/kasssb')->with('success', 'Menambah Data Berhasil');
  }


  // 
  public function updatekasssb()
  {
    $model = new Save_model();
    $modecek = new Auto_model();
    $model1 =  new Delete_model();
    $note = "";
    $tanggal = $this->request->getPost('kin_date');
    $bulan = date('m', strtotime($tanggal));
    $tahun = date('Y', strtotime($tanggal));
    $id = $this->request->getPost('kin_code');
    $jns = $this->request->getPost('kin_type');
    $v_trx_code = $this->request->getPost('kin_code');

    $type = '11';


    $kin_stot = str_replace(',', '', $this->request->getPost('kin_stot'));
    $kin_admn = str_replace(',', '', $this->request->getPost('kin_admn'));
    $kin_totl = str_replace(',', '', $this->request->getPost('kin_totl'));
    $kin_prem = str_replace(',', '', $this->request->getPost('kin_prem'));
    $kin_pajk = str_replace(',', '', $this->request->getPost('kin_pajk'));
    $kin_marg = str_replace(',', '', $this->request->getPost('kin_marg'));
    $kin_pilt = str_replace(',', '', $this->request->getPost('kin_pilt'));
    $kin_mstr = str_replace(',', '', $this->request->getPost('kin_mstr'));
    $acc_cash = '';
    $accbank = $modecek->get_bank($this->request->getPost('bnk_code'));
    $acc_cash = $accbank['acc_code'];
    $data = array(

      'kin_date'       => $this->request->getPost('kin_date'),
      'agt_numb'       => $this->request->getPost('agt_numb'),
      'bnk_code'       => $this->request->getPost('bnk_code'),
      'acc_code'       => $this->request->getPost('acc_cash'),
      'acc_cash'       => $acc_cash,
      'kin_type'       => $this->request->getPost('kin_type'),
      'prd_code'       => $this->request->getPost('prd_code'),
      'kin_desc'       => $this->request->getPost('kin_desc'),
      'kin_note'       => $note,
      'kin_stot'       => $kin_stot,
      'kin_admn'       => $kin_admn,
      'acc_admn'       => $this->request->getPost('acc_admn'),
      'acc_prod'       => $this->request->getPost('acc_prod'),
      'pen_code'       => $this->request->getPost('tbg_code'),
      'kin_mont'       => $bulan,
      'kin_year'       => $tahun,
      'kin_totl'       => $kin_totl,
      'kin_jens'        => $this->request->getPost('kin_type'),
      'kin_prem'       => $kin_prem,
      'kin_pajk'       => $kin_pajk,
      'kin_marg'       => $kin_marg,
      'kin_pilt'       => $kin_pilt,
      'acc_prem'       => $this->request->getPost('acc_prem'),
      'acc_pajk'       => $this->request->getPost('acc_pajk'),
      'acc_marg'       => $this->request->getPost('acc_marg'),
      'kin_mstr'       => $kin_mstr,

      'kin_stat' => 0,
      'com_code'  => session()->get('com_code'),



    );

    $model->_updatekasssb($data, $id);


    if (trim($this->request->getPost('kin_type')) == '01') {
      $setor = $kin_stot;
    } else {
      $setor = 0;
    }
    $data = array(
      'kin_date'       => $this->request->getPost('kin_date'),
      'agt_numb'       => $this->request->getPost('agt_numb'),
      'bnk_code'       => $this->request->getPost('bnk_code'),
      'acc_code'       => $this->request->getPost('acc_cash'),
      'acc_cash'       => $acc_cash,
      'kin_type'       => $this->request->getPost('kin_type'),
      'prd_code'       => $this->request->getPost('prd_code'),
      'kin_desc'       => $this->request->getPost('kin_desc'),
      'kin_note'       => $note,
      'kin_setr'       => $setor,
      'kin_stot'       => $kin_stot,
      'kin_admn'       => $kin_admn,
      'acc_admn'       => $this->request->getPost('acc_admn'),
      'acc_prod'       => $this->request->getPost('acc_prod'),
      'pen_code'       => $this->request->getPost('tbg_code'),
      'kin_mont'       => $bulan,
      'kin_year'       => $tahun,
      'kin_totl'       => $kin_totl,
      'kin_jens'        => $this->request->getPost('kin_type'),
      'kin_prem'       => $kin_prem,
      'kin_pajk'       => $kin_pajk,
      'kin_marg'       => $kin_marg,
      'kin_pilt'       => $kin_pilt,
      'acc_prem'       => $this->request->getPost('acc_prem'),
      'acc_pajk'       => $this->request->getPost('acc_pajk'),
      'acc_marg'       => $this->request->getPost('acc_marg'),
      'kin_mstr'       => $kin_mstr,

      'kin_stat' => 0,
      'com_code'  => session()->get('com_code'),


    );

    $model->_updatetranssb($data, $id);

    $model1->_deletejurnal($id);

    // Jurnal
    if ($jns == '01') {
      $v_trx_dbcr = 'D';
      $v_trx_debt = $kin_totl;
      $v_trx_crdt = 0;
    } else {
      $v_trx_dbcr = 'K';
      $v_trx_debt = 0;
      $v_trx_crdt =
        $kin_totl;
    }

    $data = array(
      'trx_code' => $v_trx_code, //$this->request->getPost('kin_code'),
      'trx_date' => $this->request->getPost('kin_date'),
      'acc_code'  => $acc_cash,
      'trx_jens'  => $this->request->getPost('kin_type'),
      'trx_urut' => 1,
      'trx_dbcr'  => $v_trx_dbcr,
      'trx_amnt'  => $kin_totl,
      'dbt_amnt'  => $v_trx_debt,
      'crd_amnt'  => $v_trx_crdt,
      'trx_des1'  => $kin_totl,
      'trx_des2'  => '',
      'com_code'  => 1,
      'kode_cabang'  => session()->get('kode_cabang'),
    );
    $model->_savejurnal($data);


    // Jurnal

    if ($jns == '01') {
      $v_trx_dbcr = 'K';
      $v_trx_debt = 0;
      $v_trx_crdt = $kin_stot;
    } else {
      $v_trx_dbcr = 'D';
      $v_trx_debt = $kin_stot;
      $v_trx_crdt = 0;
    }

    if (($v_trx_debt + $v_trx_crdt) > 0) {

      $data = array(
        'trx_code' => $v_trx_code, //$this->request->getPost('kin_code'),
        'trx_date' => $this->request->getPost('kin_date'),
        'acc_code'  => $this->request->getPost('acc_prod'),
        'trx_jens'  => $this->request->getPost('kin_type'),
        'trx_urut' => 1,
        'trx_dbcr'  => $v_trx_dbcr,
        'trx_amnt'  => $kin_stot,
        'dbt_amnt'  => $v_trx_debt,
        'crd_amnt'  => $v_trx_crdt,
        'trx_des1'  => $this->request->getPost('kin_desc'),
        'trx_des2'  => '',
        'com_code'  => 1,
        'kode_cabang'  => session()->get('kode_cabang'),
      );
      $model->_savejurnal($data);
    }


    //admin materai
    // Jurnal Admin
    $admin = $kin_admn;
    if ($admin > 0) {
      $data = array(
        'trx_code' => $v_trx_code, //$this->request->getPost('kin_code'),
        'trx_date' => $this->request->getPost('kin_date'),
        'acc_code'  => $this->request->getPost('acc_admn'),
        'trx_jens'  => $this->request->getPost('kin_type'),
        'trx_urut' => 1,
        'trx_dbcr'  => 'K',
        'trx_amnt'  => $kin_admn,
        'dbt_amnt'  => 0,
        'crd_amnt'  => $kin_admn,
        'trx_des1'  => $this->request->getPost('kin_desc'),
        'trx_des2'  => '',
        'com_code'  => 1,
        'kode_cabang'  => session()->get('kode_cabang'),
      );
      $model->_savejurnal($data);
    }
    //Premi 
    // Jurnal Premi / Titipan
    $premi = $kin_prem;
    if ($premi > 0) {
      $data = array(
        'trx_code' => $v_trx_code, //$this->request->getPost('kin_code'),
        'trx_date' => $this->request->getPost('kin_date'),
        'acc_code'  => $this->request->getPost('acc_prem'),
        'trx_jens'  => $this->request->getPost('kin_type'),
        'trx_urut' => 1,
        'trx_dbcr'  => 'K',
        'trx_amnt'  => $kin_prem,
        'dbt_amnt'  => 0,
        'crd_amnt'  =>
        $kin_prem,
        'trx_des1'  => $this->request->getPost('kin_desc'),
        'trx_des2'  => '',
        'com_code'  => 1,
        'kode_cabang'  => session()->get('kode_cabang'),
      );
      $model->_savejurnal($data);
    }


    // Jurnal Pajak


    $pajak = $kin_pajk;
    if ($pajak > 0) {
      $data = array(
        'trx_code' => $v_trx_code, //$this->request->getPost('kin_code'),
        'trx_date' => $this->request->getPost('kin_date'),
        'acc_code'  => $this->request->getPost('acc_pajk'),
        'trx_jens'  => $this->request->getPost('kin_type'),
        'trx_urut' => 1,
        'trx_dbcr'  => 'K',
        'trx_amnt'  => $kin_pajk,
        'dbt_amnt'  => 0,
        'crd_amnt'  => $kin_pajk,
        'trx_des1'  => $this->request->getPost('kin_desc'),
        'trx_des2'  => '',
        'com_code'  => 1,
        'kode_cabang'  => session()->get('kode_cabang'),
      );
      $model->_savejurnal($data);
    }

    // Magin
    // if ($jns=='01'){
    //   $v_trx_dbcr='K';
    //   $v_trx_debt=0;
    //   $v_trx_crdt=$this->request->getPost('kin_marg');
    // } else {
    //   $v_trx_dbcr='D';
    //   $v_trx_debt=$this->request->getPost('kin_marg');
    //   $v_trx_crdt=0;
    // }

    $bunga = $kin_marg;

    if ($bunga > 0) {
      $data = array(
        'trx_code' => $v_trx_code, //$this->request->getPost('kin_code'),
        'trx_date' => $this->request->getPost('kin_date'),
        'acc_code'  => $this->request->getPost('acc_marg'),
        'trx_jens'  => $this->request->getPost('kin_type'),
        'trx_urut' => 1,
        'trx_dbcr'  => 'D',
        'trx_amnt'  => $kin_marg,
        'dbt_amnt'  => $kin_marg,
        'crd_amnt'  => 0,
        'trx_des1'  => $this->request->getPost('kin_desc'),
        'trx_des2'  => '',
        'com_code'  => 1,
        'kode_cabang'  => session()->get('kode_cabang'),
      );
      $model->_savejurnal($data);
    }
    if ($jns == '04') {
      $id = $this->request->getPost('tbg_code');
      $data = array(

        'pen_stat'  => 2,

      );
      $model->_updatepenempatan($data, $id);
    }



    return redirect()->to('cash/kasssb')->with('success', 'Merubah Data Berhasil');
  }

  public function setortabungancol()
  {
    $model = new Model_git();
    $_SESSION['com_menu'] = '03';
    $_SESSION['com_men1'] = '0302';
    $_SESSION['com_men2'] = '';
    $tanggal = date('Y/m/d');
    $cabang  = session()->get('kode_cabang');
    if ($_SESSION['usr_jabt'] == 'Administrator') {
      $data['v_data']  = $model->_get_tabcolectifa($tanggal)->getResult();
    } else {
      $data['v_data']  = $model->_get_tabcolectif($tanggal, $cabang)->getResult();
    }

    return view('kas/tabungancolec/tabcolect_list', $data);
  }

  public function addsetortabungancol()
  {
    $model = new Model_git();
    $model1 = new Master_model();
    $cabang = session()->get('kode_cabang');
    $tanggal = date('Y-m-d');
    $data['tgl2'] = $tanggal;
    $data['v_bank']  = $model->_getbank_cab($cabang)->getResult();
    // $data['v_rek']  = $model->_get_tabungan1($cabang)->getResult();
    $data['v_employee']  = $model1->_get_employee()->getResult();
    return view('kas/tabungancolec/tabcolect_add', $data);
  }

  public function editsetortabungancol($id)
  {
    $model = new Model_git();
    $model1 = new Master_model();
    $cabang = session()->get('kode_cabang');
    $data['v_bank']  = $model->_getbank_cab($cabang)->getResult();
    // $data['v_rek']  = $model->_get_tabungan1($cabang)->getResult();
    $data['v_data']  = $model->_get_edtabcolectif($id)->getResult();
    $data['v_employee']  = $model1->_get_employee()->getResult();
    return view('kas/tabungancolec/tabcolect_edit', $data);
  }

  public function setorancol()
  {
    $model = new Model_git();

    $_SESSION['com_menu'] = '03';
    $_SESSION['com_men1'] = '0304';
    $_SESSION['com_men2'] = '';
    $tanggal = date('Y-m-d');
    $data['tgl2'] = date('Y-m-d');
    $cabang  = session()->get('kode_cabang');
    if ($_SESSION['usr_jabt'] == 'Administrator') {
      $data['v_data']  = $model->_getcoscolectif($tanggal)->getResult();
    } else {
      $data['v_data']  = $model->_getcoscolectifcab($tanggal, $cabang)->getResult();
    }

    return view('kas/pembiayaancolec/pembiayaancolect_list', $data);
  }

  public function setorancoladd()
  {
    $model = new Model_git();
    $model1 = new Master_model();
    $_SESSION['com_menu'] = '03';
    $_SESSION['com_men1'] = '0304';
    $_SESSION['com_men2'] = '';
    $data['tgl2'] = date('Y-m-d');
    $data['v_bank']  = $model->_getbank()->getResult();
    $data['v_rek'] = $model->_get_lkontrak()->getResult();
    $data['v_employee']  = $model1->_get_employee()->getResult();
    return view('kas/pembiayaancolec/pembiayaancolect_add', $data);
  }
  public function setorancoledit($id)
  {
    $model = new Model_git();
    $model1 = new Master_model();
    $_SESSION['com_menu'] = '03';
    $_SESSION['com_men1'] = '0304';
    $_SESSION['com_men2'] = '';
    $data['tgl2'] = date('Y-m-d');
    $data['v_data']  = $model->_editgetcoscolectif($id)->getResult();
    $data['v_bank']  = $model->_getbank()->getResult();
    $data['v_rek'] = $model->_get_lkontrak()->getResult();
    $data['v_data'] = $model->_editgetcoscolectif($id)->getResult();
    $data['v_employee']  = $model1->_get_employee()->getResult();
    return view('kas/pembiayaancolec/pembiayaancolect_edit', $data);
  }


  public function savetabcolectif()
  {
    $model = new Save_model();
    $modecek = new Auto_model();
    $mgit = new Model_git();
    $tanggal = $this->request->getPost('tcl_date');
    $bulan = date('m', strtotime($tanggal));
    $tahun = date('Y', strtotime($tanggal));
    $cek = $modecek->get_tabungancol($bulan, $tahun);
    $waktu = date('Y-m-d H:i:s');
    $jenistype = $this->request->getPost('tcl_type');

    $nourut = $cek['tcl_srno'];
    $kodecabang = session()->get('kode_cabang');
    if ($nourut == '') {
      $nourut = 1;
      $v_trx_code = $kodecabang . '.14.' . $tahun . $bulan . '00001';
    } else {
      $nourut = $nourut + 1;
      if ($nourut < 10) {
        $v_trx_code = $kodecabang . '.14.' . $tahun . $bulan . '0000' . $nourut;
      } else if ($nourut >= 10 and $nourut < 100) {
        $v_trx_code = $kodecabang . '.14.' . $tahun . $bulan . '000' . $nourut;
      } else if ($nourut >= 100 and $nourut < 1000) {
        $v_trx_code = $kodecabang . '.14.' . $tahun . $bulan . '00' . $nourut;
      } else if ($nourut >= 1000 and $nourut < 10000) {
        $v_trx_code = $kodecabang . '.14.' . $tahun . $bulan . '0' . $nourut;
      } else {
        $v_trx_code = $kodecabang . '.14.' . $tahun . $bulan . $nourut;
      }
    }


    $acc_cash = '';
    $accbank = $modecek->get_bank($this->request->getPost('bnk_code'));
    $acc_cash = $accbank['acc_code'];
    $kot_totl = str_replace(',', '', $this->request->getPost('grn_stot'));
    if ($jenistype == '02') {
      $vdbcrh = 'K';
      $vdbcrd = 'D';
      $dbmant = 0;
      $crdamnt = $kot_totl;
    } else {
      $vdbcrh = 'D';
      $vdbcrd = 'K';
      $dbmant =
        $kot_totl;
      $crdamnt = 0;
    }
    $data = array(
      'tcl_code'       => $v_trx_code, //$this->request->getPost('kot_code'),
      'tcl_date'       => $this->request->getPost('tcl_date'),

      'bnk_code'       => $this->request->getPost('bnk_code'),
      'tcl_type'       => $this->request->getPost('tcl_type'),
      'tcl_desc'       => $this->request->getPost('tcl_desc'),
      'tcl_totl'       => $kot_totl,
      'acc_code'       => $acc_cash,
      'emp_code'       => $this->request->getPost('emp_code'),
      'tcl_mont'       => $bulan,
      'tcl_year'       => $tahun,
      'tcl_srno'       => $nourut,
      'com_code'  => 1,
      'kode_cabang'  => session()->get('kode_cabang'),
    );

    $model->_savetabcolectif($data);
    //Jurnal Header (K)

    // $acc_code = $this->request->getPost('acc_cash');


    $data = array(
      'trx_code' => $v_trx_code, //$this->request->getPost('kot_code'),
      'trx_date' => $this->request->getPost('tcl_date'),
      'acc_code'  => $acc_cash,
      'trx_urut' => 1,
      'trx_dbcr'  => $vdbcrh,
      'trx_amnt'  => $kot_totl,
      'dbt_amnt'  => $dbmant,
      'crd_amnt'  => $crdamnt,
      'trx_des1'  => $this->request->getPost('tcl_desc'),
      'trx_des2'  => $this->request->getPost('tcl_desc'),
      'com_code'  => session()->get('com_code'),
      'kode_cabang'  => session()->get('kode_cabang'),
      'ent_time' => $waktu,
      'usercreated' => session()->get('username'),
    );

    $model->_savejurnal($data);
    //-----end save header-----
    //----- Kartu Debitur-----
    $id = 1;
    $kode = $_POST['kode'];
    $jumlah = count($kode);
    // $jenistype = $this->request->getPost('tcl_type');

    for ($x = 0; $x < $jumlah; $x++) {

      $kode1 = $this->request->getPost('kode[' . $x . ']');
      if ($kode1 != '') {
        $kot_stot = str_replace(',', '', $this->request->getPost('dbttotl[' . $x . ']'));

        $data = array(
          'tcl_code' => $v_trx_code, //$this->request->getPost('kot_code'),
          'tcl_cod1' => $v_trx_code . '-' . $x, //$this->request->getPost('kot_code'),
          'tbg_code' => $this->request->getPost('kode[' . $x . ']'),
          'tcl_amnt'  => $kot_stot,
          'acc_code'  => $this->request->getPost('acccode[' . $x . ']'),
          'agt_numb'  => $this->request->getPost('agtnumb[' . $x . ']'),
          'prd_code'  => $this->request->getPost('prdcode[' . $x . ']'),
          // 'ref_code'  => $this->request->getPost('refcode[' . $x . ']'),
          // 'com_code'  => 1,

        );
        $model->_savetabcolectifdtl($data);

        if ($jenistype == '01') {
          $debcrt = 'K';
          $v_crd_amnt = $kot_stot;
          $v_dbt_amnt = 0;
        } else {
          $debcrt = 'D';
          $v_dbt_amnt = $kot_stot;
          $v_crd_amnt = 0;
        }

        $cek1 = $modecek->get_nosetortabungan($bulan, $tahun);
        $nourut1 = $cek1['kin_srno'];
        if ($nourut1 == '') {
          $nourut1 = 1;
          $v_trx_code1 = $kodecabang . '.11.' . $tahun . $bulan . '00001';
        } else {
          $nourut1 = $nourut1 + 1;
          if ($nourut1 < 10) {
            $v_trx_code1 = $kodecabang . '.11.' . $tahun . $bulan . '0000' . $nourut1;
          } else if ($nourut1 >= 10 and $nourut1 < 100) {
            $v_trx_code1 = $kodecabang . '.11.' . $tahun . $bulan . '000' . $nourut1;
          } else if ($nourut1 >= 100 and $nourut1 < 1000) {
            $v_trx_code1 = $kodecabang . '.11.' . $tahun . $bulan . '00' . $nourut1;
          } else if ($nourut1 >= 1000 and $nourut1 < 10000) {
            $v_trx_code1 = $kodecabang . '.11.' . $tahun . $bulan . '0' . $nourut1;
          } else {
            $v_trx_code1 = $kodecabang . '.11.' . $tahun . $bulan . $nourut1;
          }
        }
        $norek = $this->request->getPost('kode[' . $x . ']');
        // $ceksaldo1 = $modecek->_get_tgltabungan($kode1, $tanggal, $bulan, $tahun);
        // $kin_gsal = 0;
        // $kin_gsal = $ceksaldo1['kin_gtot'];
        // if ($kin_gsal == '') {
        //   $kin_gsal = 0;
        // }
        $sldawal = $mgit->saldotabungan($kode1);
        $kin_awal = 0;
        foreach ($sldawal->getResult() as $awal) {
          $kin_awal = $awal->kin_awal;
        }
        if ($jenistype == '01') {
          $kin_akhr =
            $kin_awal + $kot_stot;
        } else {
          $kin_akhr = $kin_awal - $kot_stot;
        }

        $data = array(
          'kin_code'       => $v_trx_code1, //$this->request->getPost('kin_code'),
          'kin_pstr'       => $v_trx_code, //$this->request->getPost('kin_code'),
          'kin_date'       => $this->request->getPost('tcl_date'),
          'agt_numb'       => $this->request->getPost('agtnumb[' . $x . ']'),
          'bnk_code'       => $this->request->getPost('bnk_code'),
          'acc_cash'       => $this->request->getPost('acc_cash'),
          // 'kin_type'       => $this->request->getPost('prd_code'),
          // 'kin_desc'       => $this->request->getPost('kin_desc'),
          'kin_stot'       => $kot_stot,
          'kin_admn'       => 0,
          // 'acc_admn'       => $this->request->getPost('acc_admn'),
          // 'acc_prod'       => $this->request->getPost('acc_prod'),
          'tbg_code'       => $this->request->getPost('kode[' . $x . ']'),
          'kin_mont'       => $bulan,
          'kin_year'       => $tahun,
          'kin_totl'       => $kot_stot,
          'kin_desc'       => 'Setoran-Kolektif',
          'kin_srno'    => $nourut1,
          'kin_jens'        => $jenistype,
          'kin_nstr'       => 0,
          'kin_astr'       => 0,
          'kin_prem'       => 0,
          'kin_pajk'       => 0,
          'kin_marg'       => 0,
          // 'acc_prem'       => $this->request->getPost('acc_prem'),
          // 'acc_pajk'       => $this->request->getPost('acc_pajk'),
          // 'acc_marg'       => $this->request->getPost('acc_marg'),
          'kin_mstr'       => 0,
          'kin_debt'       => $v_dbt_amnt,
          'kin_crdt'       => $v_crd_amnt,
          'kin_dbcr'       => $debcrt,
          'kin_stat' => 0,
          'com_code'  => session()->get('com_code'),
          'trx_jens'  => '04',
          'kode_cabang'  => session()->get('kode_cabang'),
          'kin_time'  => $waktu,
          'kin_user' => session()->get('username'),
          'kin_awal'  => $kin_awal,
          'kin_akhr' => $kin_akhr,

        );

        $model->_savesetortabungan($data);
        $vprode = trim($this->request->getPost('prdcode[' . $x . ']'));
        $xprod = substr($vprode, 0, 1);
        if ($jenistype = '01') {
          if ($xprod == '3') {
            $xcabang = '100';
          } else {
            $xcabang = session()->get('kode_cabang');
          }
        } else {
          $xcabang = session()->get('kode_cabang');
        }

        // Jurnal Detil
        $data = array(
          'trx_code' => $v_trx_code, //$this->request->getPost('kot_code'),
          'trx_date' => $this->request->getPost('tcl_date'),
          'trx_urut' => $x,
          'acc_code'  => $this->request->getPost('acccode[' . $x . ']'),
          'trx_dbcr'  => $vdbcrd,
          'trx_amnt'  => $kot_stot,
          'dbt_amnt'  => $v_dbt_amnt,
          'crd_amnt' => $v_crd_amnt,
          'trx_des1'  => $this->request->getPost('ket[' . $x . ']'),

          'trx_des2'  =>
          $this->request->getPost('reffcode[' . $x . ']'),
          'com_code'  => 1,
          'kode_cabang'  => $xcabang,
          'ent_time' => $waktu,
          'usercreated' => session()->get('username'),
        );
        $model->_savejurnal($data);

        if ($jenistype == '01') {



          if ($xprod == '3') {

            // $model->_savejurnal10($data);
            $cabang = session()->get('kode_cabang');
            if ($cabang != '100') {

              $dbakuncabang = $mgit->get_dtakuncabang('100');
              foreach ($dbakuncabang->getResult() as $row) {
                $acc_cab1 = $row->acc_arcd;
              }

              $data = array(
                'trx_code' => $v_trx_code,
                //$this->request->getPost('kin_code'),
                'trx_date' => $this->request->getPost('tcl_date'),
                'acc_code' => $acc_cab1,
                'trx_jens' => 'TAB_COL1',
                'trx_urut' => 1,
                'trx_dbcr' => 'D',
                'trx_amnt' => $kot_stot,
                'dbt_amnt' => $kot_stot,
                'crd_amnt' => 0,
                'trx_des1' => 'Piutang ' . $this->request->getPost('nametrans[' . $x . ']'),
                'trx_des2' => 'Piutang cabang :' . $this->request->getPost('nametrans[' . $x . ']'),
                'com_code' => session()->get('com_code'),
                'kode_cabang' => '100',
                //()->get('kode_cabang'),
                'ent_time' => $waktu,
                'usercreated' => session()->get('username'),
              );
              $model->_savejurnal($data);
              // Piutang
              $dbakuncabang = $mgit->get_dtakuncabang($cabang);
              foreach ($dbakuncabang->getResult() as $row1) {
                $acc_cab2 = $row->acc_apcd;
              }
              $data = array(
                'trx_code' => $v_trx_code,
                //$this->request->getPost('kin_code'),
                'trx_date' => $this->request->getPost('tcl_date'),
                'acc_code' => $acc_cab2,
                'trx_jens' => 'TAB_COL1',
                'trx_urut' => 1,
                'trx_dbcr' => 'K',
                'trx_amnt' => $kot_stot,
                'dbt_amnt' => 0,
                'crd_amnt' => $kot_stot,
                'trx_des1' => 'Hutang ' . $this->request->getPost('nametrans[' . $x . ']'),
                'trx_des2' => 'Hutang cabang :' . $this->request->getPost('nametrans[' . $x . ']'),
                'com_code' => session()->get('com_code'),
                'kode_cabang' => session()->get('kode_cabang'),
                'ent_time' => $waktu,
                'usercreated' => session()->get('username'),
              );
              $model->_savejurnal($data);
            }
          }
        }
      }
    }


    return redirect()->to('cash/setortabungancol')->with('success', 'Menambah Data Berhasil');
  }


  public function updatetabcolectif()
  {
    $model = new Save_model();
    $modelete = new Delete_model();
    $modecek = new Auto_model();
    $mgit = new Model_git();
    $id = $this->request->getPost('tcl_code');
    $v_trx_code = $id;
    $tanggal = $this->request->getPost('tcl_date');
    $waktu = date('Y-m-d H:i:s');
    $bulan = date('m', strtotime($tanggal));
    $tahun = date('Y', strtotime($tanggal));
    $kot_totl = str_replace(',', '', $this->request->getPost('grn_stot'));
    $jenistype = $this->request->getPost('tcl_type');
    if ($jenistype == '02') {
      $vdbcrh = 'K';
      $vdbcrd = 'D';
      $dbmant = 0;
      $crdamnt = $kot_totl;
    } else {
      $vdbcrh = 'D';
      $vdbcrd = 'K';
      $dbmant =
        $kot_totl;
      $crdamnt = 0;
    }


    $kot_totl = str_replace(',', '', $this->request->getPost('grn_stot'));

    $data = array(
      'tcl_code'       => $this->request->getPost('tcl_code'),
      'tcl_date'       => $this->request->getPost('tcl_date'),

      'bnk_code'       => $this->request->getPost('bnk_code'),
      'tcl_type'       => $this->request->getPost('tcl_type'),
      'tcl_desc'       => $this->request->getPost('tcl_desc'),
      'tcl_totl'       => $kot_totl,
      'acc_code'       => $this->request->getPost('acc_cash'),
      'emp_code'       => $this->request->getPost('emp_code'),
      'tcl_mont'       => $bulan,
      'tcl_year'       => $tahun,
      'com_code'  => 1,
    );

    $model->_updatetabcolectif($data, $id);
    //Jurnal Header (K)
    $modelete->_deletetabcolectifdtl($id);
    $modelete->_deletejurnal($id);
    $modelete->_deletekabtabcol($id);

    $accbank = $modecek->get_bank($this->request->getPost('bnk_code'));
    $acc_cash = $accbank['acc_code'];

    $data = array(
      'trx_code' => $this->request->getPost('tcl_code'),
      'trx_date' => $this->request->getPost('tcl_date'),
      'acc_code'  => $acc_cash,
      'trx_urut' => 1,
      'trx_dbcr'  => $vdbcrh,
      'trx_amnt'  => $kot_totl,
      'dbt_amnt'  => $dbmant,
      'crd_amnt'  => $crdamnt,
      'trx_des1'  => $this->request->getPost('tcl_desc'),
      'trx_des2'  => $this->request->getPost('tcl_desc'),
      'com_code'  => session()->get('com_code'),
      'kode_cabang'  => session()->get('kode_cabang'),
      'ent_time' => $waktu,
      'usercreated' => session()->get('username'),

    );
    $model->_savejurnal($data);
    //-----end save header-----
    //----- Kartu Debitur-----
    $id = 1;
    $kode = $_POST['kode'];
    $jumlah = count($kode);


    for ($x = 0; $x < $jumlah; $x++) {

      $kode1 = $this->request->getPost('kode[' . $x . ']');
      if ($kode1 != '') {
        $kot_stot = str_replace(',', '', $this->request->getPost('dbttotl[' . $x . ']'));

        $data = array(
          'tcl_code' => $this->request->getPost('tcl_code'),
          'tcl_cod1' => $this->request->getPost('tcl_code') . '-' . $x, //$this->request->getPost('kot_code'),
          'tbg_code' => $this->request->getPost('kode[' . $x . ']'),
          'tcl_amnt'  => $kot_stot,
          'acc_code'  => $this->request->getPost('acccode[' . $x . ']'),
          'agt_numb'  => $this->request->getPost('acccode[' . $x . ']'),
          'prd_code'  => $this->request->getPost('prdcode[' . $x . ']'),
          // 'ref_code'  => $this->request->getPost('refcode[' . $x . ']'),
          // 'com_code'  => 1,

        );
        $model->_savetabcolectifdtl($data);

        $id1 = $this->request->getPost('tclcod1[' . $x . ']');
        // $modelete->m_deletetabungancol($id1);
        if ($jenistype == '01') {
          $debcrt = 'K';
          $v_crd_amnt = $kot_stot;
          $v_dbt_amnt = 0;
        } else {
          $debcrt = 'D';
          $v_dbt_amnt = $kot_stot;
          $v_crd_amnt = 0;
        }
        $kodecabang = session()->get('kode_cabang');
        $cek1 = $modecek->get_nosetortabungan($bulan, $tahun);
        $nourut1 = $cek1['kin_srno'];
        if ($nourut1 == '') {
          $nourut1 = 1;
          $v_trx_code1 = $kodecabang . '.11.' . $tahun . $bulan . '00001';
        } else {
          $nourut1 = $nourut1 + 1;
          if ($nourut1 < 10) {
            $v_trx_code1 = $kodecabang . '.11.' . $tahun . $bulan . '0000' . $nourut1;
          } else if ($nourut1 >= 10 and $nourut1 < 100) {
            $v_trx_code1 = $kodecabang . '.11.' . $tahun . $bulan . '000' . $nourut1;
          } else if ($nourut1 >= 100 and $nourut1 < 1000) {
            $v_trx_code1 = $kodecabang . '.11.' . $tahun . $bulan . '00' . $nourut1;
          } else if ($nourut1 >= 1000 and $nourut1 < 10000) {
            $v_trx_code1 = $kodecabang . '.11.' . $tahun . $bulan . '0' . $nourut1;
          } else {
            $v_trx_code1 = $kodecabang . '.11.' . $tahun . $bulan . $nourut1;
          }
        }
        $sldawal = $mgit->saldotabungan($kode1);
        $kin_awal = 0;
        foreach ($sldawal->getResult() as $awal) {
          $kin_awal = $awal->kin_awal;
        }
        if ($jenistype == '01') {
          $kin_akhr =
            $kin_awal + $kot_stot;
        } else {
          $kin_akhr = $kin_awal - $kot_stot;
        }

        $data = array(
          'kin_code'       => $v_trx_code1,
          'kin_date'       => $this->request->getPost('tcl_date'),
          'agt_numb'       => $this->request->getPost('agtnumb[' . $x . ']'),
          'bnk_code'       => $this->request->getPost('bnk_code'),
          'acc_cash'       => $this->request->getPost('acc_cash'),
          // 'kin_type'       => $this->request->getPost('prd_code'),
          // 'kin_desc'       => $this->request->getPost('kin_desc'),
          'kin_stot'       => $kot_stot,
          'kin_admn'       => 0,
          // 'acc_admn'       => $this->request->getPost('acc_admn'),
          // 'acc_prod'       => $this->request->getPost('acc_prod'),
          'tbg_code'       => $this->request->getPost('kode[' . $x . ']'),
          'kin_mont'       => $bulan,
          'kin_year'       => $tahun,
          'kin_totl'       => $kot_stot,
          'kin_srno' => $nourut1,
          'kin_desc'       => 'Setoran-Kolektif',

          'kin_jens'        => $jenistype,
          'kin_nstr'       => 0,
          'kin_astr'       => 0,
          'kin_prem'       => 0,
          'kin_pajk'       => 0,
          'kin_marg'       => 0,
          'kin_pstr'       => $v_trx_code,
          // 'acc_prem'       => $this->request->getPost('acc_prem'),
          // 'acc_pajk'       => $this->request->getPost('acc_pajk'),
          // 'acc_marg'       => $this->request->getPost('acc_marg'),
          'kin_mstr'       => 0,
          'kin_debt'       => $v_dbt_amnt,
          'kin_crdt'       => $v_crd_amnt,
          'kin_dbcr'       => $debcrt,
          'kin_stat' => 0,
          'com_code'  => session()->get('com_code'),
          'trx_jens' => '04',
          'kode_cabang'  => session()->get('kode_cabang'),
          'kin_time'  => $waktu,
          'kin_user' => session()->get('username'),
          'kin_awal'  => $kin_awal,
          'kin_akhr' => $kin_akhr,

        );

        $model->_savesetortabungan($data);
        // Jurnal Detil
        $vprode = trim($this->request->getPost('prdcode[' . $x . ']'));
        $xprod = substr($vprode, 0, 1);
        if ($jenistype = '01') {
          if ($xprod == '3') {
            $xcabang = '100';
          } else {
            $xcabang = session()->get('kode_cabang');
          }
        } else {
          $xcabang = session()->get('kode_cabang');
        }

        $data = array(
          'trx_code' => $v_trx_code, //$this->request->getPost('kot_code'),
          'trx_date' => $this->request->getPost('tcl_date'),
          'trx_urut' => $x,
          'acc_code'  => $this->request->getPost('acccode[' . $x . ']'),
          'trx_dbcr'  => $vdbcrd,
          'trx_amnt'  => $kot_stot,
          'dbt_amnt'  => $v_dbt_amnt,
          'crd_amnt' => $v_crd_amnt,
          'trx_des1'  => $this->request->getPost('ket[' . $x . ']'),

          'trx_des2'  =>
          $this->request->getPost('reffcode[' . $x . ']'),
          'com_code'  => 1,
          'kode_cabang'  => session()->get('kode_cabang'),
          'ent_time' => $waktu,
          'usercreated' => session()->get('username'),
        );
        $model->_savejurnal($data);

        if ($jenistype == '01') {



          if ($xprod == '3') {

            // $model->_savejurnal10($data);
            $cabang = session()->get('kode_cabang');
            if ($cabang != '100') {

              $dbakuncabang = $mgit->get_dtakuncabang('100');
              foreach ($dbakuncabang->getResult() as $row) {
                $acc_cab1 = $row->acc_arcd;
              }

              $data = array(
                'trx_code' => $v_trx_code,
                //$this->request->getPost('kin_code'),
                'trx_date' => $this->request->getPost('tcl_date'),
                'acc_code' => $acc_cab1,
                'trx_jens' => 'TAB_COL1',
                'trx_urut' => 1,
                'trx_dbcr' => 'D',
                'trx_amnt' => $kot_stot,
                'dbt_amnt' => $kot_stot,
                'crd_amnt' => 0,
                'trx_des1' => 'Piutang ' . $this->request->getPost('nametrans[' . $x . ']'),
                'trx_des2' => 'Piutang cabang :' . $this->request->getPost('nametrans[' . $x . ']'),
                'com_code' => session()->get('com_code'),
                'kode_cabang' => '100',
                //()->get('kode_cabang'),
                'ent_time' => $waktu,
                'usercreated' => session()->get('username'),
              );
              $model->_savejurnal($data);
              // Piutang
              $dbakuncabang = $mgit->get_dtakuncabang($cabang);
              foreach ($dbakuncabang->getResult() as $row1) {
                $acc_cab2 = $row->acc_apcd;
              }
              $data = array(
                'trx_code' => $v_trx_code,
                //$this->request->getPost('kin_code'),
                'trx_date' => $this->request->getPost('tcl_date'),
                'acc_code' => $acc_cab2,
                'trx_jens' => 'TAB_COL1',
                'trx_urut' => 1,
                'trx_dbcr' => 'K',
                'trx_amnt' => $kot_stot,
                'dbt_amnt' => 0,
                'crd_amnt' => $kot_stot,
                'trx_des1' => 'Hutang ' . $this->request->getPost('nametrans[' . $x . ']'),
                'trx_des2' => 'Hutang cabang :' . $this->request->getPost('nametrans[' . $x . ']'),
                'com_code' => session()->get('com_code'),
                'kode_cabang' => session()->get('kode_cabang'),
                'ent_time' => $waktu,
                'usercreated' => session()->get('username'),
              );
              $model->_savejurnal($data);
            }
          }
        }
      }
    }


    return redirect()->to('cash/setortabungancol')->with('success', 'Menambah Data Berhasil');
  }

  //save Pembiayaan Colectif

  public function savebiayacoletif()
  {
    if ($this->request->getPost('ccl_code') != '') {
      return redirect()->to('cash/setorancol')->with('success', 'No Transaksi sudah ada');
    }
    $model = new Save_model();
    $modecek = new Auto_model();
    $modgit = new Model_git();
    $tanggal = $this->request->getPost('ccl_date');
    $bulan = date('m', strtotime($tanggal));
    $tahun = date('Y', strtotime($tanggal));
    $waktu = date('Y-m-d H:i:s');
    $cek = $modecek->get_pembiayaancol($bulan, $tahun);
    $jenistype = $this->request->getPost('ccl_type');
    if ($jenistype == '02') {
      $vdbcrh = 'K';
      $vdbcrd = 'D';
    } else {
      $vdbcrh = 'D';
      $vdbcrd = 'K';
    }
    $nourut = $cek['ccl_srno'];
    $kodecabang = session()->get('kode_cabang');
    if ($nourut == '') {
      $nourut = 1;
      $v_trx_code = $kodecabang . '.15.' . $tahun . $bulan . '00001';
    } else {
      $nourut = $nourut + 1;
      if ($nourut < 10) {
        $v_trx_code = $kodecabang . '.15.' . $tahun . $bulan . '0000' . $nourut;
      } else if ($nourut >= 10 and $nourut < 100) {
        $v_trx_code = $kodecabang . '.15.' . $tahun . $bulan . '000' . $nourut;
      } else if ($nourut >= 100 and $nourut < 1000) {
        $v_trx_code = $kodecabang . '.15.' . $tahun . $bulan . '00' . $nourut;
      } else if ($nourut >= 1000 and $nourut < 10000) {
        $v_trx_code = $kodecabang . '.15.' . $tahun . $bulan . '0' . $nourut;
      } else {
        $v_trx_code = $kodecabang . '.15.' . $tahun . $bulan . $nourut;
      }
    }
    $acc_cash = '';
    $accbank = $modecek->get_bank($this->request->getPost('bnk_code'));
    $acc_cash = $accbank['acc_code'];

    $kot_totl = str_replace(',', '', $this->request->getPost('grn_stot'));
    $data = array(
      'ccl_code' => $v_trx_code,
      //$this->request->getPost('kot_code'),
      'ccl_date' => $this->request->getPost('ccl_date'),

      'bnk_code' => $this->request->getPost('bnk_code'),
      'ccl_type' => $this->request->getPost('ccl_type'),
      'ccl_desc' => $this->request->getPost('ccl_desc'),
      'ccl_totl' => $kot_totl,
      'acc_code' => $acc_cash,
      'emp_code' => $this->request->getPost('emp_code'),
      'ccl_mont' => $bulan,
      'ccl_year' => $tahun,
      'ccl_srno' => $nourut,
      'com_code' => 1,
      'kode_cabang' => session()->get('kode_cabang'),
    );

    $model->_savepembiayaancolectif($data);
    //Jurnal Header (K)
    $data = array(
      'trx_code' => $v_trx_code,
      //$this->request->getPost('kot_code'),
      'trx_date' => $this->request->getPost('ccl_date'),
      'acc_code' => $acc_cash,
      'trx_urut' => 1,
      'trx_dbcr' => "D",
      'trx_amnt' => $kot_totl,
      'dbt_amnt' => $kot_totl,
      'crd_amnt' => 0,
      'trx_des1' => $this->request->getPost('ccl_desc'),
      'trx_des2' => $this->request->getPost('ccl_desc'),
      'com_code' => 1,
      'kode_cabang' => session()->get('kode_cabang'),
      'ent_time' => $waktu,
      'usercreated' => session()->get('username'),
    );
    $model->_savejurnal($data);
    //-----end save header-----
    //----- Kartu Debitur-----
    $id = 1;
    $kode = $_POST['kode'];
    if ($kode != '') {
      $jumlah = count($kode);
    } else {
      $jumlah = 0;
    }



    for ($x = 0; $x < $jumlah; $x++) {

      $kode1 = $this->request->getPost('kode[' . $x . ']');
      if ($kode1 != '') {
        $akh_pamt = str_replace(',', '', $this->request->getPost('akhpokok[' . $x . ']'));
        $akh_jamt = str_replace(',', '', $this->request->getPost('akhbunga[' . $x . ']'));
        $angspokok = str_replace(',', '', $this->request->getPost('pokok[' . $x . ']'));
        $angsmargin = str_replace(',', '', $this->request->getPost('basil[' . $x . ']'));
        $admin = str_replace(',', '', $this->request->getPost('admin[' . $x . ']'));
        $denda = str_replace(',', '', $this->request->getPost('denda[' . $x . ']'));
        $jumlah = str_replace(',', '', $this->request->getPost('jumlah[' . $x . ']'));
        $extra = str_replace(',', '', $this->request->getPost('extracom[' . $x . ']'));
        $stabungan = str_replace(',', '', $this->request->getPost('saldotab[' . $x . ']'));
        $total = $angspokok + $angsmargin + $admin;



        $data = array(
          'ccl_code' => $v_trx_code,
          //$this->request->getPost('kot_code'),
          'ccl_cod1' => $v_trx_code . '-' . $x,
          //$this->request->getPost('kot_code'),
          'knt_code' => $this->request->getPost('kode[' . $x . ']'),
          'agt_numb' => $this->request->getPost('agtnumb[' . $x . ']'),
          'akh_pamt' => $akh_pamt,
          'akh_jamt' => $akh_jamt,
          'ccl_cole' => $this->request->getPost('empkolec[' . $x . ']'),
          'ccl_pokk' => $angspokok,
          'ccl_marg' => $angsmargin,
          'ccl_admn' => $admin,
          'ccl_dend' => $denda,
          'ccl_juml' => $jumlah,
          'ccl_extc' => $extra,
          'ccl_stab' => $stabungan,
          'ccl_logs' => $angspokok,
          'tbg_code' => $this->request->getPost('tbgcode[' . $x . ']'),
          'acc_code' => $this->request->getPost('acccode[' . $x . ']'),
          'ccl_angk' => $this->request->getPost('angske[' . $x . ']'),
          // 'ref_code'  => $this->request->getPost('refcode[' . $x . ']'),
          // 'com_code'  => 1,

        );
        $model->_savepembiayaancolectifdtl($data);

        // Jurnal Detil Piutang
        $cekacc = $modgit->get_accpembiayaan($this->request->getPost('kode[' . $x . ']'));
        foreach ($cekacc->getResult() as $acc) {
          $acc_code = $acc->acc_code;
          $acc_cod1 = $acc->acc_cod1;
        }


        $cek = $modecek->get_acckhusus('01');
        $acc_admn = $cek['acc_code'];
        //Isi Ke Pembiayaan
        $data = array(
          'kin_code' => $v_trx_code . '-' . $x,
          //$this->request->getPost('kin_code'),
          'kin_date' => $this->request->getPost('ccl_date'),
          'agt_numb' => $this->request->getPost('agtnumb[' . $x . ']'),
          'bnk_code' => $this->request->getPost('bnk_code'),
          'knt_code' => $this->request->getPost('kode[' . $x . ']'),
          'kin_type' => $jenistype,
          'kin_desc' => 'Pindah Buku Auto Debet Pembiayaan No Kontrak : ' . $this->request->getPost('kode[' . $x . ']'),
          'kin_stot' => $angspokok,
          'kin_totl' => $jumlah,
          'acc_cash' => $this->request->getPost('acc_cash'),
          'acc_prod' => $acc_code,
          'acc_dend' => '',
          'acc_admn' => '',
          'acc_bung' => $acc_cod1,

          'kin_tdendh' => 0,
          'kin_ddendh' => 0,
          'kin_tbungh' => $angsmargin,
          'kin_dbungh' => 0,
          'kin_tpokkh' => $angspokok,
          'kin_dpokkh' => 0,

          'kin_mont' => $bulan,
          'kin_year' => $tahun,
          'kin_tran' => '2',
          'kin_stat' => '0',
          'com_code' => 1,
          'kin_note' => $v_trx_code,
          'kode_cabang' => session()->get('kode_cabang'),
        );

        $model->_savepembiayaan($data);

        $data = array(
          'kin_code' => $v_trx_code,
          //$this->request->getPost('kin_code'),
          'kin_date' => $this->request->getPost('ccl_date'),
          'agt_numb' => $this->request->getPost('agtnumb[' . $x . ']'),
          'bnk_code' => $this->request->getPost('bnk_code'),
          'knt_code' => $this->request->getPost('kode[' . $x . ']'),
          'kin_type' => $this->request->getPost('ccl_type'),
          'kin_desc' => 'Pembayaran Colectif atas nama ' . $this->request->getPost('agt_name[' . $x . ']'),
          'kin_stot' => $angspokok + $angsmargin,
          'kin_admn' => $angsmargin,


          'kin_angs' => $angspokok + $angsmargin,
          'kin_bung' => $akh_jamt,
          'kin_pokk' => $akh_pamt,
          'kin_angk' => $this->request->getPost('angske[' . $x . ']'),

          'kin_totl' => $angspokok + $angsmargin + $admin,
          // 'kin_gtot'       => $kin_gtot,
          'acc_cash' => $this->request->getPost('acc_cash'),
          'acc_prod' => $acc_code,
          'acc_dend' => '',
          'acc_admn' => $acc_admn,
          'acc_bung' => $acc_cod1,
          'kin_tcos' => 0,
          'kin_tprov' => 0,
          'kin_notr' => 0,
          'kin_jiwa' => 0,
          'kin_kend' => 0,
          'kin_kebk' => 0,
          'kin_krdt' => 0,
          'kin_dana' => 0,
          'kin_lain' => 0,
          'kin_matr' => 0,
          'kin_pmat' => 0,
          'kin_infq' => 0,
          'kin_simw' => 0,
          'kin_pinl' => 0,
          'kin_tdendh' => 0,
          'kin_ddendh' => 0,
          'kin_tadmn' => $admin,
          'kin_dadmn' => $admin,
          'kin_tbungh' => $angsmargin,
          'kin_dbungh' => $angsmargin,
          'kin_tpokkh' => $angspokok,
          'kin_dpokkh' => $angspokok,
          'kin_rtgs' => 0,
          'kin_tran' => 2,
          'kin_mont' => $bulan,
          'kin_year' => $tahun,
          'kin_jens' => 'K',
          'kin_stat' => '0',
          'com_code' => 1,
        );


        // Pembiayaan

        if ($jenistype == '01') {
          $id1 = $this->request->getPost('angske[' . $x . ']');
          $id = $kode1; //$this->request->getPost('knt_code');
          $data = array(

            'trx_lnsh' => $angspokok + $angsmargin,
            'lns_pokk' => $angspokok,
            'lns_bung' => $angsmargin,
            'lns_date' => $this->request->getPost('ccl_date'),
            'lns_code' => $v_trx_code,
            //$this->request->getPost('kin_code'),
          );

          $model->_Updatekartu($data, $id, $id1);
        }
        if ($jenistype == '02') {

          $id = $kode1; //$this->request->getPost('knt_code');
          $v_angsuran = 0;
          $dtangsuran = $modecek->_get_angsuran($id);
          $v_angpokok = $dtangsuran['trx_pokk'];
          $v_anglunas = $dtangsuran['trx_lnsh'];
          $v_angbunga = $dtangsuran['trx_bung'];

          $data = array(

            'trx_lnsh' => $v_anglunas,
            'lns_pokk' => $v_angpokok,
            'lns_bung' => $v_angbunga,
            'lns_date' => $this->request->getPost('ccl_date'),
            'lns_code' => $v_trx_code,
            //$this->request->getPost('kin_code'),
          );

          $model->_Updatekartuclose($data, $id);
        }

        if ($jenistype == '01') {
          $id = $kode1; // $this->request->getPost('knt_code');
          $data = array(
            'knt_stat' => 1,
            // 'knt_cair'  => 1,

          );

          $model->_updatekontrak($data, $id);
        }

        if ($jenistype == '02') {
          $id = $kode1; //$this->request->getPost('knt_code');
          $data = array(
            'knt_stat' => 2,
            // 'knt_cair'  => 1,

          );

          $model->_updatekontrak($data, $id);
        }

        if ($jenistype == '03') {
          $id = $kode1; //$this->request->getPost('knt_code');
          $data = array(
            'knt_cair' => 1,
            'knt_stat' => 1,
            'knt_dcar' => $this->request->getPost('kin_date'),
          );

          $model->_updatekontrak($data, $id);
        }

        $data = array(
          'trx_code' => $v_trx_code,
          //$this->request->getPost('kot_code'),
          'trx_date' => $this->request->getPost('ccl_date'),
          'trx_urut' => $x,
          'acc_code' => $acc_code,
          //$this->request->getPost('tbgcode[' . $x . ']'),
          'trx_dbcr' => 'K',
          'trx_amnt' => $angspokok,
          'dbt_amnt' => 0,
          'trx_des1' => 'Pelunasan Pokok : ' . $kode1,
          'crd_amnt' => $angspokok,
          'trx_des2' => 'Setoran Pebiayaan Colectif',
          'com_code' => 1,
          'kode_cabang' => session()->get('kode_cabang'),
          'ent_time' => $waktu,
          'usercreated' => session()->get('username'),
        );
        $model->_savejurnal($data);

        // Jurnal Detil Jasa

        $data = array(
          'trx_code' => $v_trx_code,
          //$this->request->getPost('kot_code'),
          'trx_date' => $this->request->getPost('ccl_date'),
          'trx_urut' => $x,
          'acc_code' => $acc_cod1,
          //$this->request->getPost('tbgcode[' . $x . ']'),
          'trx_dbcr' => 'K',
          'trx_amnt' => $angsmargin,
          'dbt_amnt' => 0,
          'trx_des1' => 'Pembayaran Jasa : ' . $kode1,
          'crd_amnt' => $angsmargin,
          'trx_des2' => 'etoran Pebiayaan Colectif',
          'com_code' => 1,
          'kode_cabang' => session()->get('kode_cabang'),
          'ent_time' => $waktu,
          'usercreated' => session()->get('username'),
        );
        $model->_savejurnal($data);


        // Jurnal Detil Admin

        // $admin = $this->request->getPost('admin');
        if ($admin > 0) {
          $data = array(
            'trx_code' => $v_trx_code,
            //$this->request->getPost('kot_code'),
            'trx_date' => $this->request->getPost('ccl_date'),
            'trx_urut' => $x,
            'acc_code' => $acc_admn,
            //$this->request->getPost('tbgcode[' . $x . ']'),
            'trx_dbcr' => 'K',
            'trx_amnt' => $admin,
            'dbt_amnt' => 0,
            'trx_des1' => 'Pendapatan Administrasi : ' . $kode1,
            'crd_amnt' => $admin,
            'trx_des2' => 'Setoran Pebiayaan Colectif',
            'com_code' => 1,
            'kode_cabang' => session()->get('kode_cabang'),
            'ent_time' => $waktu,
            'usercreated' => session()->get('username'),
          );
          $model->_savejurnal($data);
        }

        //  $denda = $this->request->getPost('admin');
        if ($denda > 0) {
          $data = array(
            'trx_code' => $v_trx_code,
            //$this->request->getPost('kot_code'),
            'trx_date' => $this->request->getPost('ccl_date'),
            'trx_urut' => $x,
            'acc_code' => $acc_admn,
            //$this->request->getPost('tbgcode[' . $x . ']'),
            'trx_dbcr' => 'K',
            'trx_amnt' => $denda,
            'dbt_amnt' => 0,
            'trx_des1' => 'Pendapatan Denda : ' . $kode1,
            'crd_amnt' => $denda,
            'trx_des2' => 'Setoran Pebiayaan Colectif',
            'com_code' => 1,
            'kode_cabang' => session()->get('kode_cabang'),
            'ent_time' => $waktu,
            'usercreated' => session()->get('username'),
          );
          $model->_savejurnal($data);
        }
      }
    }

    return redirect()->to('cash/setorancol')->with('success', 'Menambah Data Berhasil');
  }
  public function updatebiayacoletif()
  {
    $model = new Save_model();
    $modelete = new Delete_model();
    $modecek = new Auto_model();
    $modgit = new Model_git();
    $id = $this->request->getPost('ccl_code');

    $tanggal = $this->request->getPost('ccl_date');
    $v_trx_code = $this->request->getPost('ccl_code');
    $bulan = date('m', strtotime($tanggal));
    $tahun = date('Y', strtotime($tanggal));
    $waktu = date('Y-m-d H:i:s');
    $jenistype = $this->request->getPost('ccl_type');

    $modelete->_deletepembiayandtl($id);
    $modelete->_deletejurnal($id);
    $modelete->m_deletekaspembiayaancol($id);

    if ($jenistype == '02') {
      $vdbcrh = 'K';
      $vdbcrd = 'D';
    } else {
      $vdbcrh = 'D';
      $vdbcrd = 'K';
    }
    $acc_cash = '';
    $accbank = $modecek->get_bank($this->request->getPost('bnk_code'));
    $acc_cash = $accbank['acc_code'];

    $kot_totl = str_replace(',', '', $this->request->getPost('grn_stot'));
    $data = array(
      'ccl_code' => $v_trx_code,
      //$this->request->getPost('kot_code'),
      'ccl_date' => $this->request->getPost('ccl_date'),

      'bnk_code' => $this->request->getPost('bnk_code'),
      'ccl_type' => $this->request->getPost('ccl_type'),
      'ccl_desc' => $this->request->getPost('ccl_desc'),
      'ccl_totl' => $kot_totl,
      'acc_code' => $acc_cash,
      'emp_code' => $this->request->getPost('emp_code'),
      'ccl_mont' => $bulan,
      'ccl_year' => $tahun,

      'com_code' => 1,
      'kode_cabang' => session()->get('kode_cabang'),
    );

    $model->_updatepembiayaancolectif($data, $id);
    //Jurnal Header (K)
    $data = array(
      'trx_code' => $v_trx_code,
      //$this->request->getPost('kot_code'),
      'trx_date' => $this->request->getPost('ccl_date'),
      'acc_code' => $acc_cash,
      'trx_urut' => 1,
      'trx_dbcr' => "D",
      'trx_amnt' => $kot_totl,
      'dbt_amnt' => $kot_totl,
      'crd_amnt' => 0,
      'trx_des1' => $this->request->getPost('ccl_desc'),
      'trx_des2' => $this->request->getPost('ccl_desc'),
      'com_code' => 1,
      'kode_cabang' => session()->get('kode_cabang'),
      'ent_time' => $waktu,
      'usercreated' => session()->get('username'),
    );
    $model->_savejurnal($data);
    //-----end save header-----
    //----- Kartu Debitur-----
    $id = 1;
    $kode = $_POST['kode'];
    if ($kode != '') {
      $jumlah = count($kode);
    } else {
      $jumlah = 0;
    }



    for ($x = 0; $x < $jumlah; $x++) {

      $kode1 = $this->request->getPost('kode[' . $x . ']');
      if ($kode1 != '') {
        $akh_pamt = str_replace(',', '', $this->request->getPost('akhpokok[' . $x . ']'));
        $akh_jamt = str_replace(',', '', $this->request->getPost('akhbunga[' . $x . ']'));
        $angspokok = str_replace(',', '', $this->request->getPost('pokok[' . $x . ']'));
        $angsmargin = str_replace(',', '', $this->request->getPost('basil[' . $x . ']'));
        $admin = str_replace(',', '', $this->request->getPost('admin[' . $x . ']'));
        $denda = str_replace(',', '', $this->request->getPost('denda[' . $x . ']'));
        // $jumlah = $angspokok +  $angsmargin; //str_replace(',', '', $this->request->getPost('jumlah[' . $x . ']'));
        $extra = str_replace(',', '', $this->request->getPost('extracom[' . $x . ']'));
        $stabungan = str_replace(',', '', $this->request->getPost('saldotab[' . $x . ']'));
        $jumlah = $angspokok + $angsmargin + $admin + $denda;



        $data = array(
          'ccl_code' => $v_trx_code,
          //$this->request->getPost('kot_code'),
          'ccl_cod1' => $v_trx_code . '-' . $x,
          //$this->request->getPost('kot_code'),
          'knt_code' => $this->request->getPost('kode[' . $x . ']'),
          'agt_numb' => $this->request->getPost('agtnumb[' . $x . ']'),
          'akh_pamt' => $akh_pamt,
          'akh_jamt' => $akh_jamt,
          'ccl_cole' => $this->request->getPost('empkolec[' . $x . ']'),
          'ccl_pokk' => $angspokok,
          'ccl_marg' => $angsmargin,
          'ccl_admn' => $admin,
          'ccl_dend' => $denda,
          'ccl_juml' => $jumlah,
          'ccl_extc' => $extra,
          'ccl_stab' => $stabungan,
          'ccl_logs' => $angspokok,
          'tbg_code' => $this->request->getPost('tbgcode[' . $x . ']'),
          'acc_code' => $this->request->getPost('acccode[' . $x . ']'),
          'ccl_angk' => $this->request->getPost('angske[' . $x . ']'),
          // 'ref_code'  => $this->request->getPost('refcode[' . $x . ']'),
          // 'com_code'  => 1,

        );
        $model->_savepembiayaancolectifdtl($data);

        // Jurnal Detil Piutang
        $cekacc = $modgit->get_accpembiayaan($this->request->getPost('kode[' . $x . ']'));
        foreach ($cekacc->getResult() as $acc) {
          $acc_code = $acc->acc_code;
          $acc_cod1 = $acc->acc_cod1;
        }


        $cek = $modecek->get_acckhusus('01');
        $acc_admn = $cek['acc_code'];
        //Isi Ke Pembiayaan
        $data = array(
          'kin_code' => $v_trx_code . '-' . $x,
          //$this->request->getPost('kin_code'),
          'kin_date' => $this->request->getPost('ccl_date'),
          'agt_numb' => $this->request->getPost('agtnumb[' . $x . ']'),
          'bnk_code' => $this->request->getPost('bnk_code'),
          'knt_code' => $this->request->getPost('kode[' . $x . ']'),
          'kin_type' => $jenistype,
          'kin_desc' => 'Pindah Buku Auto Debet Pembiayaan No Kontrak : ' . $this->request->getPost('kode[' . $x . ']'),
          'kin_stot' => $angspokok,
          'kin_totl' => $jumlah,
          'acc_cash' => $this->request->getPost('acc_cash'),
          'acc_prod' => $acc_code,
          'acc_dend' => '',
          'acc_admn' => '',
          'acc_bung' => $acc_cod1,

          'kin_tdendh' => 0,
          'kin_ddendh' => 0,
          'kin_tbungh' => $angsmargin,
          'kin_dbungh' => 0,
          'kin_tpokkh' => $angspokok,
          'kin_dpokkh' => 0,

          'kin_mont' => $bulan,
          'kin_year' => $tahun,
          'kin_tran' => '2',
          'kin_stat' => '0',
          'com_code' => 1,
          'kin_note' => $v_trx_code,
          'kode_cabang' => session()->get('kode_cabang'),
        );

        $model->_savepembiayaan($data);

        $data = array(
          'kin_code' => $v_trx_code,
          //$this->request->getPost('kin_code'),
          'kin_date' => $this->request->getPost('ccl_date'),
          'agt_numb' => $this->request->getPost('agtnumb[' . $x . ']'),
          'bnk_code' => $this->request->getPost('bnk_code'),
          'knt_code' => $this->request->getPost('kode[' . $x . ']'),
          'kin_type' => $this->request->getPost('ccl_type'),
          'kin_desc' => 'Pembayaran Colectif atas nama ' . $this->request->getPost('agt_name[' . $x . ']'),
          'kin_stot' => $angspokok + $angsmargin,
          'kin_admn' => $angsmargin,


          'kin_angs' => $angspokok + $angsmargin,
          'kin_bung' => $akh_jamt,
          'kin_pokk' => $akh_pamt,
          'kin_angk' => $this->request->getPost('angske[' . $x . ']'),

          'kin_totl' => $angspokok + $angsmargin + $admin,
          // 'kin_gtot'       => $kin_gtot,
          'acc_cash' => $this->request->getPost('acc_cash'),
          'acc_prod' => $acc_code,
          'acc_dend' => '',
          'acc_admn' => $acc_admn,
          'acc_bung' => $acc_cod1,
          'kin_tcos' => 0,
          'kin_tprov' => 0,
          'kin_notr' => 0,
          'kin_jiwa' => 0,
          'kin_kend' => 0,
          'kin_kebk' => 0,
          'kin_krdt' => 0,
          'kin_dana' => 0,
          'kin_lain' => 0,
          'kin_matr' => 0,
          'kin_pmat' => 0,
          'kin_infq' => 0,
          'kin_simw' => 0,
          'kin_pinl' => 0,
          'kin_tdendh' => 0,
          'kin_ddendh' => 0,
          'kin_tadmn' => $admin,
          'kin_dadmn' => $admin,
          'kin_tbungh' => $angsmargin,
          'kin_dbungh' => $angsmargin,
          'kin_tpokkh' => $angspokok,
          'kin_dpokkh' => $angspokok,
          'kin_rtgs' => 0,
          'kin_tran' => 2,
          'kin_mont' => $bulan,
          'kin_year' => $tahun,
          'kin_jens' => 'K',
          'kin_stat' => '0',
          'com_code' => 1,
        );


        // Pembiayaan

        if ($jenistype == '01') {
          $id1 = $this->request->getPost('angske[' . $x . ']');
          $id = $kode1; //$this->request->getPost('knt_code');
          $data = array(

            'trx_lnsh' => $angspokok + $angsmargin,
            'lns_pokk' => $angspokok,
            'lns_bung' => $angsmargin,
            'lns_date' => $this->request->getPost('ccl_date'),
            'lns_code' => $v_trx_code,
            //$this->request->getPost('kin_code'),
          );

          $model->_Updatekartu($data, $id, $id1);
        }
        if ($jenistype == '02') {

          $id = $kode1; //$this->request->getPost('knt_code');
          $v_angsuran = 0;
          $dtangsuran = $modecek->_get_angsuran($id);
          $v_angpokok = $dtangsuran['trx_pokk'];
          $v_anglunas = $dtangsuran['trx_lnsh'];
          $v_angbunga = $dtangsuran['trx_bung'];

          $data = array(

            'trx_lnsh' => $v_anglunas,
            'lns_pokk' => $v_angpokok,
            'lns_bung' => $v_angbunga,
            'lns_date' => $this->request->getPost('ccl_date'),
            'lns_code' => $v_trx_code,
            //$this->request->getPost('kin_code'),
          );

          $model->_Updatekartuclose($data, $id);
        }

        if ($jenistype == '01') {
          $id = $kode1; // $this->request->getPost('knt_code');
          $data = array(
            'knt_stat' => 1,
            // 'knt_cair'  => 1,

          );

          $model->_updatekontrak($data, $id);
        }

        if ($jenistype == '02') {
          $id = $kode1; //$this->request->getPost('knt_code');
          $data = array(
            'knt_stat' => 2,
            // 'knt_cair'  => 1,

          );

          $model->_updatekontrak($data, $id);
        }

        if ($jenistype == '03') {
          $id = $kode1; //$this->request->getPost('knt_code');
          $data = array(
            'knt_cair' => 1,
            'knt_stat' => 1,
            'knt_dcar' => $this->request->getPost('kin_date'),
          );

          $model->_updatekontrak($data, $id);
        }

        $data = array(
          'trx_code' => $v_trx_code,
          //$this->request->getPost('kot_code'),
          'trx_date' => $this->request->getPost('ccl_date'),
          'trx_urut' => $x,
          'acc_code' => $acc_code,
          //$this->request->getPost('tbgcode[' . $x . ']'),
          'trx_dbcr' => 'K',
          'trx_amnt' => $angspokok,
          'dbt_amnt' => 0,
          'trx_des1' => 'Pelunasan Pokok : ' . $kode1,
          'crd_amnt' => $angspokok,
          'trx_des2' => 'Setoran Pebiayaan Colectif',
          'com_code' => 1,
          'kode_cabang' => session()->get('kode_cabang'),
          'ent_time' => $waktu,
          'usercreated' => session()->get('username'),
        );
        $model->_savejurnal($data);

        // Jurnal Detil Jasa

        $data = array(
          'trx_code' => $v_trx_code,
          //$this->request->getPost('kot_code'),
          'trx_date' => $this->request->getPost('ccl_date'),
          'trx_urut' => $x,
          'acc_code' => $acc_cod1,
          //$this->request->getPost('tbgcode[' . $x . ']'),
          'trx_dbcr' => 'K',
          'trx_amnt' => $angsmargin,
          'dbt_amnt' => 0,
          'trx_des1' => 'Pembayaran Jasa : ' . $kode1,
          'crd_amnt' => $angsmargin,
          'trx_des2' => 'etoran Pebiayaan Colectif',
          'com_code' => 1,
          'kode_cabang' => session()->get('kode_cabang'),
          'ent_time' => $waktu,
          'usercreated' => session()->get('username'),
        );
        $model->_savejurnal($data);


        // Jurnal Detil Admin

        // $admin = $this->request->getPost('admin');
        if ($admin > 0) {
          $data = array(
            'trx_code' => $v_trx_code,
            //$this->request->getPost('kot_code'),
            'trx_date' => $this->request->getPost('ccl_date'),
            'trx_urut' => $x,
            'acc_code' => $acc_admn,
            //$this->request->getPost('tbgcode[' . $x . ']'),
            'trx_dbcr' => 'K',
            'trx_amnt' => $admin,
            'dbt_amnt' => 0,
            'trx_des1' => 'Pendapatan Administrasi : ' . $kode1,
            'crd_amnt' => $admin,
            'trx_des2' => 'Setoran Pebiayaan Colectif',
            'com_code' => 1,
            'kode_cabang' => session()->get('kode_cabang'),
            'ent_time' => $waktu,
            'usercreated' => session()->get('username'),
          );
          $model->_savejurnal($data);
        }

        //  $denda = $this->request->getPost('admin');
        if ($denda > 0) {
          $data = array(
            'trx_code' => $v_trx_code,
            //$this->request->getPost('kot_code'),
            'trx_date' => $this->request->getPost('ccl_date'),
            'trx_urut' => $x,
            'acc_code' => $acc_admn,
            //$this->request->getPost('tbgcode[' . $x . ']'),
            'trx_dbcr' => 'K',
            'trx_amnt' => $denda,
            'dbt_amnt' => 0,
            'trx_des1' => 'Pendapatan Denda : ' . $kode1,
            'crd_amnt' => $denda,
            'trx_des2' => 'Setoran Pebiayaan Colectif',
            'com_code' => 1,
            'kode_cabang' => session()->get('kode_cabang'),
            'ent_time' => $waktu,
            'usercreated' => session()->get('username'),
          );
          $model->_savejurnal($data);
        }
      }
    }


    return redirect()->to('cash/setorancol')->with('success', 'Menambah Data Berhasil');
  }

  public function deletekasumum()
  {

    $model = new Delete_model();
    // $msave = new Save_model();
    $kode = $_POST['code1'];
    // if ($kode == '') {
    //   $jumlah = 0;
    // } else {
    $jumlah = count($kode);
    // }


    for ($x = 0; $x < $jumlah; $x++) {
      $x1 = $x + 1;
      $kode1 = $this->request->getPost('code1[' . $x . ']');

      if ($kode1 != '') {
        $id = $this->request->getVar('cek[' . $x . ']');



        $model->_deletepencairanhdr($id);
        $model->_deletepencairandtl($id);
        $model->_deletejurnal($id);
      }
    }
    $model = new Model_git();
    $tanggal1 = $this->request->getPost('trx_date');
    $tanggal2 = $this->request->getPost('trx_dat1');
    $data['tgl1'] = $tanggal1;
    $data['tgl2'] = $tanggal2;
    $data['v_kas']  = $model->_delkasumum($tanggal1, $tanggal2)->getResult();
    return view('kas/out/out_delete', $data);
  }
  //End

  public function hapustabungan()
  {

    $model = new Delete_model();


    $msave = new Save_model();
    $kode = $_POST['code1'];
    if ($kode == '') {
      $jumlah = 0;
    } else {
      $jumlah = count($kode);
    }


    for ($x = 0; $x < $jumlah; $x++) {
      $x1 = $x + 1;

      $kode1 = $this->request->getPost('code[' . $x . ']');

      if ($kode1 != '') {
        $id = $this->request->getPost('cek[' . $x . ']');


        $model->m_deletekastabungan($id);
        $model->_deletejurnal($id);
      }
    }
    $model = new Model_git();
    $tanggal1 = $this->request->getPost('trx_date');
    $tanggal2 = $this->request->getPost('trx_dat1');
    $data['tgl1'] = $tanggal1;
    $data['tgl2'] = $tanggal2;
    $data['v_data'] = $model->_get_dtsetortabungan($tanggal1, $tanggal2)->getResult();
    return view('simpanan/tabungan/tabungan_hapus', $data);
  }

  public function transfer()
  {
    $model = new Model_git();
    $_SESSION['com_menu'] = '03';
    $_SESSION['com_men1'] = '0302';
    $tanggal = date('Y-m-d');
    $cabang  = session()->get('kode_cabang');
    $id = '04';
    if ($_SESSION['usr_jabt'] == 'Administrator') {
      $data['v_data']  = $model->_get_setortabungana($tanggal, $id)->getResult();
    } else {
      $data['v_data']  = $model->_get_setortabungan($tanggal, $cabang, $id)->getResult();
    }

    return view('kas/transfer/transfer_list', $data);
  }

  public function savetransfer()
  {
    $model = new Save_model();
    $mgit = new Model_git();
    $modecek = new Auto_model();

    $note = "";
    $tanggal = $this->request->getvar('kin_date');

    $bulan = date('m', strtotime($tanggal));
    $tahun = date('Y', strtotime($tanggal));
    $waktu = date('Y-d-m H:i:s');

    $cek = $modecek->get_nosetortabungan($bulan, $tahun);
    $jns = '04';
    $description = $this->request->getvar('kin_desc');
    $rektujuan = $this->request->getvar('tbg_cod1');
    $nourut = $cek['kin_srno'];
    $rekening = $this->request->getvar('tbg_code');
    $sldawal = $mgit->saldotabungan($rekening);
    $kin_awal = 0;
    foreach ($sldawal->getResult() as $awal) {
      $kin_awal = $awal->kin_awal;
    }
    $cek1 = $mgit->_get_datatabunganab($rekening);
    $agt_numb = '';
    $agt_name = '';
    $prd_code = '';
    $acc_prod = '';
    $acc_admn = '';
    $kodecabang = '';
    foreach ($cek1->getResult() as $cekrow) {
      $agt_numb = $cekrow->agt_numb;
      $agt_name = $cekrow->agt_name;
      $prd_code = $cekrow->prd_code;
      $prd_name = $cekrow->prd_name;
      $acc_prod = $cekrow->acc_code;
      $acc_admn = $cekrow->acc_cod2;
      $kodecabang = $cekrow->kode_cabang;
    }
    $xprod1 = $prd_code;
    $xprod = substr($xprod1, 0, 1);
    $bnk_code = '90';
    $dbbank = $modecek->get_bank($bnk_code);
    $acc_cash = $dbbank['acc_code'];;
    // $kodecabang = session()->get('kode_cabang');
    // if ($description == '') {
    if ($jns == '01') {

      // $description = 'Setoran ' . $prd_name . ' - ' . $agt_name;
      $description1 = 'Setoran ' . $prd_name;
      // } else if ($jns == '02') {
      //     $description = 'Penarikan Tunai ' . $prd_name . ' - ' . $agt_name;
      //     $description1 = 'Penarikan Tunai ' . $prd_name;
      // } else if ($jns == '03') {
      //     $description = 'Penutupan Rekening : ' . $prd_name . ' - ' . $agt_name;
      //     $description1 = 'Penutupan Rekening : ' . $prd_name;
      // } else {
      //     $description = $prd_name . ' - ' . $agt_name;
      //     $description1 = $prd_name;
    }

    // }
    if ($nourut == '') {
      $nourut = 1;
      $v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . '00001';
    } else {
      $nourut = $nourut + 1;
      if ($nourut < 10) {
        $v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . '0000' . $nourut;
      } else if ($nourut >= 10 and $nourut < 100) {
        $v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . '000' . $nourut;
      } else if ($nourut >= 100 and $nourut < 1000) {
        $v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . '00' . $nourut;
      } else if ($nourut >= 1000 and $nourut < 10000) {
        $v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . '0' . $nourut;
      } else {
        $v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . $nourut;
      }
    }


    $kin_stot = str_replace(',', '', $this->request->getvar('jumlah'));
    $kin_totl = str_replace(',', '', $this->request->getvar('jumlah'));

    // $kin_awal = 0;
    $v_dbt_amnt = 0;
    $v_crd_amnt = 0;
    $cektanggal = $modecek->_get_tgltabungan1($rekening, $tanggal);

    $kin_code = $cektanggal['kin_code'];
    $kin_dat1 = $cektanggal['kin_dat1'];
    $kin_dat2 = $cektanggal['kin_date'];


    // if ($kin_code == '') {
    //   $kin_gtot = $kin_totl;
    //   $jmlhari = 0;
    // } else {
    //   $kin_gtot = $cektanggal['kin_gtot'];
    //   $kin_gtot = $kin_gtot + $kin_totl;
    //   $jmlhari = (($tanggal - $kin_dat1) / 60 / 60 / 24) + 1;
    // }
    if ($jns == '01') {
      $debcrt = 'K';
      $v_crd_amnt = $kin_totl;
      $v_dbt_amnt = 0;
    } else {
      $debcrt = 'D';
      $v_dbt_amnt = $kin_totl;
      $v_crd_amnt = 0;
    }

    if ($kin_code == '') {
      $kin_gtot = $kin_totl;
      // $kin_awal = 0;
      $kin_dat1 = $cektanggal['kin_date'];
      $jmlhari = (($tanggal - $kin_dat1) / 60 / 60 / 24);
    } else {
      $kin_dat1 = $cektanggal['kin_date'];
      // $kin_awal = $cektanggal['kin_akhr'];
      $kin_gtot = $kin_awal + $v_crd_amnt - $v_dbt_amnt;
      // $kin_dat1 = date('Y-m-d', strtotime($kin_dat1));
      $tanggl2 = strtotime($tanggal);
      $tanggl1 = strtotime($kin_dat1);
      $jmlhari = (($tanggl2 - $tanggl1) / 60 / 60 / 24);
    }
    $kin_akhr = floatval($kin_awal) - floatval($v_dbt_amnt) +  floatval($v_crd_amnt);
    $data = array(
      'kin_code' => $v_trx_code,
      //$this->request->getvar('norek'),
      'kin_date' => $this->request->getvar('tgl'),
      'agt_numb' => $agt_numb,
      'bnk_code' => $bnk_code,
      'acc_cash' => $acc_cash,
      'kin_type' => $prd_code,
      'kin_desc' => $description,
      'kin_note' => $note,
      'kin_stot' => $kin_stot,

      'acc_admn' => $acc_admn,
      'acc_prod' => $acc_prod,
      'tbg_code' => $rekening,
      'kin_mont' => $bulan,
      'kin_year' => $tahun,
      'kin_totl' => $kin_totl,
      'kin_srno' => $nourut,
      'kin_pstr' => $rektujuan,
      'kin_jens' => '01',
      'kin_nstr' => 0,
      'kin_astr' => 0,
      'kin_prem' => 0,
      'kin_pajk' => 0,
      'kin_marg' => 0,
      'acc_prem' => '',
      'acc_pajk' => '',
      'acc_marg' => '',
      'kin_mstr' => 0,
      'kin_debt' => $kin_totl,
      'kin_crdt' => 0,
      'kin_dbcr' => 'D',
      'kin_stat' => 0,
      'com_code' => 1,

      'trx_jens' => '04',
      'kode_cabang' => $kodecabang,
      'kin_gtot' => $kin_gtot,
      'kin_awal' => $kin_awal,
      'kin_akhr' => $kin_akhr,
      'kin_time' => $waktu,
      'kin_user' => 'Mobile',

    );

    $model->_savesetortabungan($data);
    if ($jns == '2000') {
      $data = array(
        'kin_code' => $v_trx_code,
        //$this->request->getvar('norek'),
        'kin_date' => $this->request->getvar('tgl'),
        'agt_numb' => $agt_numb,
        'bnk_code' => $bnk_code,
        'acc_cash' => $acc_cash,
        'knt_code' => $this->request->getvar('norek'),
        'kin_type' => $prd_code,
        'kin_desc' => $description,
        'kin_note' => $note,
        'kin_stot' => $kin_stot,
        'kin_admn' => 0,
        'acc_admn' => $acc_admn,
        'acc_prod' => $acc_prod,
        'kin_dend' => 0,
        'kin_angs' => 0,
        'kin_bung' => 0,
        'kin_pokk' => 0,
        'kin_mont' => $bulan,
        'kin_year' => $tahun,
        'kin_totl' => $kin_totl,
        'kin_stat' => 0,
        'kin_jens' => '03',
        'com_code' => 1,
        'kode_cabang' => $kodecabang,
      );

      $model->_savesetorpembiayaan($data);
    }


    $data = array(
      'kin_dat1' => $this->request->getvar('kin_date'),
      'kin_hari' => $jmlhari,
      // 'kin_apus' => $kin_dat1,
    );

    $model->_updatetabungantgl($data, $kin_code);


    // Jurnal
    $v_trx_dbcr = 'D';
    $v_trx_debt = $kin_totl;
    $v_trx_crdt = 0;

    $data = array(
      'trx_code' => $v_trx_code,
      //$this->request->getvar('norek'),
      'trx_date' => $this->request->getvar('kin_date'),
      'acc_code' => $acc_cash,
      'trx_jens' => '01',
      'psb_code' => $prd_code,
      'trx_urut' => 1,
      'trx_dbcr' => 'D',
      'trx_amnt' => $kin_totl,
      'dbt_amnt' => $kin_totl,
      'crd_amnt' => 0,
      'trx_des1' => $description,
      'trx_des2' => $description1,
      'com_code' =>   1,
      'kode_cabang' => $kodecabang,
      'ent_time' => $waktu,
      'usercreated' => 'Mobile',
    );
    $model->_savejurnal($data);


    // Jurnal



    $data = array(
      'trx_code' => $v_trx_code,
      //$this->request->getvar('norek'),
      'trx_date' => $this->request->getvar('kin_date'),
      'acc_code' => $acc_prod,
      'trx_jens' => '01',
      'trx_urut' => 1,
      'trx_dbcr' => 'K',
      'trx_amnt' => $kin_stot,
      'dbt_amnt' => 0,
      'crd_amnt' => $kin_stot,
      'trx_des1' => $description,
      'trx_des2' => $description1,
      'com_code' => 1,
      'kode_cabang' => $kodecabang,
      'ent_time' => $waktu,
      'usercreated' => 'Mobile',
    );
    $model->_savejurnal($data);

    return redirect()->to('cash/transfer')->with('success', 'Menambah Data Berhasil');
  }

  public function gridrekpembiayaan()
  {
    $model = new model_git();
    $draw = $this->request->getVar('draw');
    $start = $this->request->getVar('start');
    $length = $this->request->getVar('length');
    $search = $this->request->getVar('search[value]');
    $data = $model->_get_lkontrakfind($start, $length, $search);
    //{"draw":4,"recordsTotal":57,"recordsFiltered":57,"data":[{"first_name":"Airi","last_name":"Satou","position":"Accountant","office":"Tokyo","start_date":"28th Nov 08","salary":"$162,700"},{"first_name":"Angelica","last_name":"Ramos","position":"Chief Executive Officer (CEO)","office":"London","start_date":"9th Oct 09","salary":"$1,200,000"},{"first_name":"Ashton","last_name":"Cox","position":"Junior Technical Author","office":"San Francisco","start_date":"12th Jan 09","salary":"$86,000"},{"first_name":"Bradley","last_name":"Greer","position":"Software Engineer","office":"London","start_date":"13th Oct 12","salary":"$132,000"},{"first_name":"Brenden","last_name":"Wagner","position":"Software Engineer","office":"San Francisco","start_date":"7th Jun 11","salary":"$206,850"},{"first_name":"Brielle","last_name":"Williamson","position":"Integration Specialist","office":"New York","start_date":"2nd Dec 12","salary":"$372,000"},{"first_name":"Bruno","last_name":"Nash","position":"Software Engineer","office":"London","start_date":"3rd May 11","salary":"$163,500"},{"first_name":"Caesar","last_name":"Vance","position":"Pre-Sales Support","office":"New York","start_date":"12th Dec 11","salary":"$106,450"},{"first_name":"Cara","last_name":"Stevens","position":"Sales Assistant","office":"New York","start_date":"6th Dec 11","salary":"$145,600"},{"first_name":"Cedric","last_name":"Kelly","position":"Senior Javascript Developer","office":"Edinburgh","start_date":"29th Mar 12","salary":"$433,060"}]}
    $resp = array(
      'draw' => $draw,
      'recordsTotal' => $data['recordsTotal'],
      'recordsFiltered' => $data['recordsFiltered'],
      'data' => $data['data']
    );
    echo json_encode($resp);
  }

  public function gridrektabungan()
  {
    $model = new  Model_git();
    $draw = $this->request->getVar('draw');
    $start = $this->request->getVar('start');
    $length = $this->request->getVar('length');
    $search = $this->request->getVar('search[value]');
    $data = $model->_get_tabunganfind($start, $length, $search);
    //{"draw":4,"recordsTotal":57,"recordsFiltered":57,"data":[{"first_name":"Airi","last_name":"Satou","position":"Accountant","office":"Tokyo","start_date":"28th Nov 08","salary":"$162,700"},{"first_name":"Angelica","last_name":"Ramos","position":"Chief Executive Officer (CEO)","office":"London","start_date":"9th Oct 09","salary":"$1,200,000"},{"first_name":"Ashton","last_name":"Cox","position":"Junior Technical Author","office":"San Francisco","start_date":"12th Jan 09","salary":"$86,000"},{"first_name":"Bradley","last_name":"Greer","position":"Software Engineer","office":"London","start_date":"13th Oct 12","salary":"$132,000"},{"first_name":"Brenden","last_name":"Wagner","position":"Software Engineer","office":"San Francisco","start_date":"7th Jun 11","salary":"$206,850"},{"first_name":"Brielle","last_name":"Williamson","position":"Integration Specialist","office":"New York","start_date":"2nd Dec 12","salary":"$372,000"},{"first_name":"Bruno","last_name":"Nash","position":"Software Engineer","office":"London","start_date":"3rd May 11","salary":"$163,500"},{"first_name":"Caesar","last_name":"Vance","position":"Pre-Sales Support","office":"New York","start_date":"12th Dec 11","salary":"$106,450"},{"first_name":"Cara","last_name":"Stevens","position":"Sales Assistant","office":"New York","start_date":"6th Dec 11","salary":"$145,600"},{"first_name":"Cedric","last_name":"Kelly","position":"Senior Javascript Developer","office":"Edinburgh","start_date":"29th Mar 12","salary":"$433,060"}]}
    $resp = array(
      'draw' => $draw,
      'recordsTotal' => $data['recordsTotal'],
      'recordsFiltered' => $data['recordsFiltered'],
      'data' => $data['data']
    );
    echo json_encode($resp);
  }

  public function gridrekskb()
  {
    $model = new  Model_git();
    $draw = $this->request->getVar('draw');
    $start = $this->request->getVar('start');
    $length = $this->request->getVar('length');
    $search = $this->request->getVar('search[value]');
    $data = $model->_get_skbfind($start, $length, $search);
    //{"draw":4,"recordsTotal":57,"recordsFiltered":57,"data":[{"first_name":"Airi","last_name":"Satou","position":"Accountant","office":"Tokyo","start_date":"28th Nov 08","salary":"$162,700"},{"first_name":"Angelica","last_name":"Ramos","position":"Chief Executive Officer (CEO)","office":"London","start_date":"9th Oct 09","salary":"$1,200,000"},{"first_name":"Ashton","last_name":"Cox","position":"Junior Technical Author","office":"San Francisco","start_date":"12th Jan 09","salary":"$86,000"},{"first_name":"Bradley","last_name":"Greer","position":"Software Engineer","office":"London","start_date":"13th Oct 12","salary":"$132,000"},{"first_name":"Brenden","last_name":"Wagner","position":"Software Engineer","office":"San Francisco","start_date":"7th Jun 11","salary":"$206,850"},{"first_name":"Brielle","last_name":"Williamson","position":"Integration Specialist","office":"New York","start_date":"2nd Dec 12","salary":"$372,000"},{"first_name":"Bruno","last_name":"Nash","position":"Software Engineer","office":"London","start_date":"3rd May 11","salary":"$163,500"},{"first_name":"Caesar","last_name":"Vance","position":"Pre-Sales Support","office":"New York","start_date":"12th Dec 11","salary":"$106,450"},{"first_name":"Cara","last_name":"Stevens","position":"Sales Assistant","office":"New York","start_date":"6th Dec 11","salary":"$145,600"},{"first_name":"Cedric","last_name":"Kelly","position":"Senior Javascript Developer","office":"Edinburgh","start_date":"29th Mar 12","salary":"$433,060"}]}
    $resp = array(
      'draw' => $draw,
      'recordsTotal' => $data['recordsTotal'],
      'recordsFiltered' => $data['recordsFiltered'],
      'data' => $data['data']
    );
    echo json_encode($resp);
  }
}
