<?php

namespace App\Controllers;

use PHPExcel;
use PHPExcel_IOFactory;
use App\Models\Save_model;
use App\Models\Master_model;
use App\Models\Model_git;

class Import extends BaseController
{
    public function __construct()
    {
        // $this->contact = new Master_model();
    }
    public function index()
    {
        $model = new Master_model;

        //$data['v_data'] = $model->_getkota()->getResult();
        return view('import/menu');
    }

    public function anggota()
    {
        $model = new Master_model;
        $data['v_data'] = $model->_get_anggota()->getResult();
        return view('import/anggota_list', $data);
    }

    public function tabungan()
    {
        $model = new Model_git();
        $tanggal = date('Y-m-d');
        $data['v_tabungan']  = $model->_get_tabungana($tanggal)->getResult();
        return view('import/tabungan_list', $data);
    }

    public function tabungantrans()
    {
        $model = new Model_git();
        $tanggal = date('Y-m-d');
        $id = '01';
        $data['v_setortabungan']  = $model->_get_setortabungana($tanggal, $id)->getResult();

        return view('import/setortabungan_list', $data);
    }

    public function skb()
    {
        $model = new Model_git();
        $tanggal = date('Y-m-d');
        $id = '01';
        $data['v_setortabungan']  = $model->_get_setortabungana($tanggal, $id)->getResult();

        return view('import/setortabungan_list', $data);
    }

    public function skbtrans()
    {
        $model = new Model_git();
        $tanggal = date('Y-m-d');
        $id = '01';
        $data['v_setortabungan']  = $model->_get_setortabungana($tanggal, $id)->getResult();

        return view('import/setortabungan_list', $data);
    }

    public function pinjaman()
    {
        $model = new Model_git();
        $tanggal = date('Y-m-d');
        $id = '01';
        $data['v_kontrak']  = $model->_get_kontrak()->getResult();

        return view('import/kontrak_list', $data);
    }


    public function Importdata()
    {
        // $_SESSION['com_menu'] = '08';
        // $_SESSION['com_men1'] = '0803';
        // $_SESSION['com_men2'] = '';
        // $id = 'S';
        return view('import/menu');
    }
    public function prosesExcel()
    {
        $msave = new Save_model();
        $file = $this->request->getFile('fileexcel');
        if ($file) {
            $excelReader  = new PHPExcel();
            //mengambil lokasi temp file
            $fileLocation = $file->getTempName();
            //baca file
            $objPHPExcel = PHPExcel_IOFactory::load($fileLocation);
            //ambil sheet active
            $sheet    = $objPHPExcel->getActiveSheet()->toArray(null, true, true, true);
            //looping untuk mengambil data
            foreach ($sheet as $idx => $data) {
                //skip index 1 karena title excel
                if ($idx == 1) {
                    continue;
                }
                $kode = $data['A'];
                $nama = $data['B'];
                $provinsi = $data['C'];


                // insert data
                $data = array(
                    'kot_code' => $kode,
                    'kot_name' => $nama,
                    'pro_code' => $provinsi,
                    'neg_code' => '062',
                    'kot_stat' => 'Y',
                );
                $msave->_savekota($data);
            }
        }
        return redirect()->to('master/kota')->with('success', 'Import Data Berhasil');
    }

    public function kodepos()
    {
        $msave = new Save_model();
        $file = $this->request->getFile('fileexcel');
        if ($file) {
            $excelReader  = new PHPExcel();
            //mengambil lokasi temp file
            $fileLocation = $file->getTempName();
            //baca file
            $objPHPExcel = PHPExcel_IOFactory::load($fileLocation);
            //ambil sheet active
            $sheet    = $objPHPExcel->getActiveSheet()->toArray(null, true, true, true);
            //looping untuk mengambil data
            foreach ($sheet as $idx => $data) {
                //skip index 1 karena title excel
                if ($idx == 1) {
                    continue;
                }
                $kode = $data['D'];
                $kecamatan = $data['B'];
                $kota = $data['E'];
                $kelurahan = $data['A'];


                // insert data
                $data = array(
                    'kdp_code' => $kode,
                    'kdp_kelu' => $kelurahan,
                    'kdp_keca' => $kecamatan,
                    'kot_code' => $kota,
                    'kdp_stat' => 'Y',
                );
                $msave->_savekodepos($data);
            }
        }
        return redirect()->to('master/kodepos')->with('success', 'Import Data Berhasil');
    }

    public function impanggota()
    {
        $msave = new Save_model();
        $file = $this->request->getFile('fileexcel');
        if ($file) {
            $excelReader  = new PHPExcel();
            //mengambil lokasi temp file
            $fileLocation = $file->getTempName();
            //baca file
            $objPHPExcel = PHPExcel_IOFactory::load($fileLocation);
            //ambil sheet active
            $sheet    = $objPHPExcel->getActiveSheet()->toArray(null, true, true, true);
            //looping untuk mengambil data
            foreach ($sheet as $idx => $data) {
                //skip index 1 karena title excel
                if ($idx == 1) {
                    continue;
                }
                $noanggota = trim($data['A']);
                $nama = trim($data['B']);
                $templahir = trim($data['C']);
                $tgllahir = $data['D'];
                $alamat = trim($data['F']);
                $sexcode = $data['E'];
                $phone = trim($data['H']);
                $mail = $data['G'];
                $noktp = $data['I'];
                $npwp = $data['J'];
                $nobpjs = $data['K'];
                $jenis = $data['L'];
                $norekening = $data['M'];
                $namarekening = $data['N'];
                $namabank = $data['O'];
                $kodecabang = trim($data['P']);
                // insert data
                $data = array(
                    'agt_numb'        => ($noanggota), //$this->request->getPost('agt_numb'),
                    'agt_name'       => ($nama),
                    'agt_tlhr'       => ($templahir),
                    'agt_dlhr'       => $tgllahir,
                    'agt_adrs'       => ($alamat),
                    'sex_code'       => $sexcode,
                    'agt_phon'       => ($phone),
                    //'agt_mail'       => $mail,
                    //'grd_code'       => $jenis,

                    //'agt_bpjs'       => $nobpjs,
                    //'agt_nktp'       => $noktp,
                    //'agt_nokk'       => '',
                    //'agt_npwp'       => $npwp,
                    //'bnk_rekg'       => $norekening,
                    //'agt_nban'       => $namabank,
                    //'agt_nrek'       => $namarekening,
                    //'bnk_cabg'       => '',

                    'kode_cabang'       => trim($kodecabang),

                    'agt_stat' => 'Y',
                );

                $msave->_saveanggota($data);
            }
        }
        return redirect()->to('master/anggota')->with('success', 'Import Data Berhasil');
    }

    public function reksimpanan()
    {
        $msave = new Save_model();
        $mmaster = new Master_model();
        $file = $this->request->getFile('fileexcel');
        if ($file) {
            $excelReader  = new PHPExcel();
            //mengambil lokasi temp file
            $fileLocation = $file->getTempName();
            //baca file
            $objPHPExcel = PHPExcel_IOFactory::load($fileLocation);
            //ambil sheet active
            $sheet    = $objPHPExcel->getActiveSheet()->toArray(null, true, true, true);
            //looping untuk mengambil data
            foreach ($sheet as $idx => $data) {
                //skip index 1 karena title excel
                if ($idx == 1) {
                    continue;
                }
                $norekening = $data['A'];
                $tglrekenig = $data['B'];
                $noanggota = $data['C'];
                $namaanggota = $data['D'];
                $kodeproduct = $data['E'];
                $tbg_marg = $data['G'];
                $nourut = (substr($norekening, 11, 6));
                $tbg_admn = 0; // $data['H'];
                $tbg_sawl = $data['H'];
                $tbg_smin = $data['G'];
                $tbg_smin = $data['I'];
                $tbg_stmn = $data['J'];
                $tbg_bons = $data['K'];
                $tbg_smjs = $data['L'];
                $tbg_spas = $data['M'];
                $tbg_tutp = $data['N'];
                $tbg_pinl = $data['O'];
                $kodecabang = $data['S'];
                $empcode = $data['P'];
                $kelcode = $data['Q'];
                $colcode = $data['R'];
                $alamat =  trim($data['T']);
                $bulan = date('m', $tglrekenig);
                $tahun = date('Y', $tglrekenig);

                // $dbbiaya = $mmaster->_get_finfanggota($namaanggota, $alamat);
                //$noanggota = '';
                //foreach ($dbbiaya->getResult() as $row) {

                //  $noanggota = $row->agt_numb;
                //}
                // insert data
                $data = array(
                    'tbg_code'       => $norekening, //$this->request->getPost('pen_code'),
                    'tbg_date'       => $tglrekenig,
                    //'tbg_ahdt'       => $this->request->getPost('tbg_ahdt'),
                    'agt_numb'       => $noanggota,
                    'prd_code'       => $kodeproduct,
                    'tbg_qqqq'       => '',
                    'tbg_marg'       => $tbg_marg,
                    'tbg_admn'       => $tbg_admn,
                    //'tbg_padm'       => $this->request->getPost('tbg_padm'),
                    'tbg_smin'       => $tbg_smin,
                    'tbg_stmn'       => $tbg_stmn,
                    'tbg_bons'       => $tbg_bons,
                    'tbg_smjs'       => $tbg_smjs,
                    'tbg_spas'       => $tbg_spas,
                    'tbg_sawl'       => $tbg_sawl,
                    'tbg_pinl'       => $tbg_pinl,
                    'tbg_tutp'       => $tbg_tutp,
                    'tbg_name'       => $namaanggota,

                    'tbg_desc'       => 'Migrasi',
                    'tbg_mont'       => $bulan,
                    'tbg_year'       => $tahun,
                    'tbg_srno'       => $nourut,
                    'tbg_des1'       => $alamat,
                    // 'tbg_dana'       => $this->request->getPost('tbg_dana'),
                    //'tbg_dest'       => $this->request->getPost('tbg_dest'),
                    //'tbg_pemk'       => $this->request->getPost('tbg_pemk'),
                    'com_code'  => session()->get('com_code'),
                    'kode_cabang'  => $kodecabang,
                    //'emp_code'  => $empcode,
                    //'kel_code'  => $kelcode,
                    //'col_code'  => $colcode,

                    'tbg_stat' => 1,
                );

                $msave->_savetabungan($data);
            }
        }
        return redirect()->to('simpanan/tabungan')->with('success', 'Import Data Berhasil');
    }

    public function transsimpanan()
    {
        $msave = new Save_model();
        $file = $this->request->getFile('fileexcel');
        if ($file) {
            $excelReader  = new PHPExcel();
            //mengambil lokasi temp file
            $fileLocation = $file->getTempName();
            //baca file
            $objPHPExcel = PHPExcel_IOFactory::load($fileLocation);
            //ambil sheet active
            $sheet    = $objPHPExcel->getActiveSheet()->toArray(null, true, true, true);
            //looping untuk mengambil data
            foreach ($sheet as $idx => $data) {
                //skip index 1 karena title excel
                if ($idx == 1) {
                    continue;
                }
                $norekening = $data['C'];
                $tglrekenig = $data['B'];
                $noanggota = $data['D'];
                $kodeproduct = $data['E'];
                $jenis = $data['G'];
                $kodebank = $data['H'];

                $jumlah = $data['I'];
                $admin = $data['J'];
                $total = $jumlah + $admin;
                if ($jenis == '01') {
                    $debcrt = 'K';
                    $v_dbt_amnt = 0;
                    $v_crd_amnt = $total;
                } else {
                    $debcrt = 'D';
                    $v_dbt_amnt = $total;
                    $v_crd_amnt = 0;
                }
                $kodecabang = $data['M'];
                $bulan = date('m', $tglrekenig);
                $tahun = date('Y', $tglrekenig);
                // insert data
                $data = array(
                    'kin_code' => $norekening,
                    //$this->request->getPost('kin_code'),
                    'kin_date' => $tglrekenig,
                    'agt_numb' => $noanggota,
                    'bnk_code' => $kodebank,
                    // 'acc_cash' => $acc_cash,
                    'kin_type' => $kodeproduct,
                    // 'kin_desc' => $description,
                    // 'kin_note' => $note,
                    'kin_stot' => $jumlah,
                    'kin_admn' => $admin,
                    // 'acc_admn' => $this->request->getPost('acc_admn'),
                    //  'acc_prod' => $this->request->getPost('acc_prod'),
                    'tbg_code' => $norekening,
                    'kin_mont' => $bulan,
                    'kin_year' => $tahun,
                    'kin_totl' => $total,
                    // 'kin_srno' => $nourut,
                    'kin_jens' => $jenis,
                    'kin_nstr' => 0,
                    'kin_astr' => 0,
                    'kin_prem' => 0,
                    'kin_pajk' => 0,
                    'kin_marg' => 0,
                    //    'acc_prem' => $this->request->getPost('acc_prem'),
                    //    'acc_pajk' => $this->request->getPost('acc_pajk'),
                    //    'acc_marg' => $this->request->getPost('acc_marg'),
                    'kin_mstr' => 0,
                    'kin_debt' => $v_dbt_amnt,
                    'kin_crdt' => $v_crd_amnt,
                    'kin_dbcr' => $debcrt,
                    'kin_stat' => 0,
                    'com_code' => session()->get('com_code'),
                    'trx_jens' => '01',
                    'kode_cabang' => $kodecabang,
                    'kin_gtot' => 0,
                    'kin_awal' => 0,
                    'kin_akhr' => 0,
                    'kin_time' => date('Y/m/d H:s:m'),
                    'kin_user' => session()->get('username'),

                );
                $msave->_savesetortabungan($data);
            }
        }
        return redirect()->to('import/tabungantrans')->with('success', 'Import Data Berhasil');
    }

    public function rekpinjaman()
    {
        $msave = new Save_model();
        $file = $this->request->getFile('fileexcel');
        if ($file) {
            $excelReader  = new PHPExcel();
            //mengambil lokasi temp file
            $fileLocation = $file->getTempName();
            //baca file
            $objPHPExcel = PHPExcel_IOFactory::load($fileLocation);
            //ambil sheet active
            $sheet    = $objPHPExcel->getActiveSheet()->toArray(null, true, true, true);
            //looping untuk mengambil data
            foreach ($sheet as $idx => $data) {
                //skip index 1 karena title excel
                if ($idx == 1) {
                    continue;
                }
                $norekening = $data['A'];
                $tglrekenig = $data['B'];
                $noanggota = trim($data['C']);
                $namaanggota = $data['D'];
                $kodeproduct = trim($data['E']);
                $jenispembayaran = trim($data['H']);
                $tenor = $data['I'];
                $jumlah = $data['G'];
                $bunga = $data['J'];
                $bunga = floatval($bunga) * 12;
                $knt_angs = $data['K'];
                $knt_angb = $knt_angs; //($knt_angs / ($tenor * 12));
                $knt_angp = $knt_angb;
                $knt_tmar = floatval($knt_angs)  * (floatval($tenor) * 12);
                $tglangsuran = $data['L'];
                $tgljty = $data['M'];
                $empcode = $data['O'];
                $kelcode = $data['P'];
                $colector = $data['Q'];
                $kodecabang = $data['R'];
                $rekdebet = $data['N'];
                $bulan = date('m', $tglrekenig);
                $tahun = date('Y', $tglrekenig);
                $days = date('d', $tglrekenig);
                // insert data
                $data = array(
                    'knt_code'       => $norekening,
                    'knt_date'       => $tglrekenig,
                    'agt_numb'       => $noanggota,
                    // 'png_code'       => $this->request->getPost('png_code'),
                    'prd_code'       => $kodeproduct,
                    'bng_type'       => 1,
                    'knt_tnid'       => $tenor,
                    'knt_tenr'       => $tenor,
                    'knt_totl'       => $jumlah,
                    'knt_marg'       => $bunga,
                    'smd_code'       => '01',
                    'knt_desc'       => $namaanggota,
                    'knt_prov'       => 0,
                    'knt_admn'       => 0,
                    'knt_asrn'       => 0,
                    'knt_tdan'       => 0,
                    'knt_matr'       => 0,
                    'knt_lain'       => 0,
                    'knt_tpot'       => 0,
                    'knt_tot1'       => 0,
                    'knt_gper'       => $tglangsuran,
                    'knt_angs'       => $knt_angs,
                    'knt_angb'       => $knt_angb,
                    'knt_agun'       => 0,
                    'knt_angp'       => $knt_angp,
                    'knt_jtdt'       => $tgljty,
                    'knt_pden'       => 0,
                    'knt_nden'       => 0,
                    'knt_mont'       => $bulan,
                    'knt_year'       => $tahun,
                    'knt_days'       => $days,
                    'knt_grac'       => 0,
                    'tbg_code'       => $rekdebet,
                    'knt_tmar'       => $knt_tmar,
                    'knt_nmrg'       => 0, //$this->request->getPost('knt_nmrg'),
                    'knt_asrk'       => 0, //$this->request->getPost('knt_asrk'),
                    'knt_notr'       => 0, //$this->request->getPost('knt_notr'),
                    'com_code'       => 1,
                    'kode_cabang'  => $kodecabang,
                    //'emp_code'  => $empcode,
                    // 'kel_code'  => $kelcode,
                    //'col_code'  => $colector,
                    'knt_stat' => 0,
                    'knt_jang' => $jenispembayaran,
                    'knt_hari' => 0,
                    // 'knt_name' => 0,
                );

                $msave->_savekontrak($data);
            }
        }
        return redirect()->to('import/pinjaman')->with('success', 'Import Data Berhasil');
    }

    public function pinjamantrans()
    {
        $msave = new Save_model();
        $file = $this->request->getFile('fileexcel');
        if ($file) {
            $excelReader  = new PHPExcel();
            //mengambil lokasi temp file
            $fileLocation = $file->getTempName();
            //baca file
            $objPHPExcel = PHPExcel_IOFactory::load($fileLocation);
            //ambil sheet active
            $sheet    = $objPHPExcel->getActiveSheet()->toArray(null, true, true, true);
            //looping untuk mengambil data
            foreach ($sheet as $idx => $data) {
                //skip index 1 karena title excel
                if ($idx == 1) {
                    continue;
                }
                $norekening = $data['A'];
                $tglrekenig = $data['B'];
                $noanggota = $data['C'];
                $kodeproduct = $data['E'];
                $jenispembayaran = $data['H'];
                $tenor = $data['I'];
                $jumlah = $data['G'];
                $bunga = $data['J'];
                $knt_angs = $data['K'];
                $knt_angb = $knt_angs; //($knt_angs / ($tenor * 12));
                $knt_angp = $knt_angb;
                $knt_tmar = $knt_angs * ($tenor * 12);
                $tglangsuran = $data['L'];
                $tgljty = $data['M'];
                $empcode = $data['O'];
                $kelcode = $data['P'];
                $colector = $data['Q'];
                $kodecabang = $data['R'];
                $rekdebet = $data['N'];
                $bulan = date('m', $tglrekenig);
                $tahun = date('Y', $tglrekenig);
                $days = date('d', $tglrekenig);
                // insert data
                $data = array(
                    'knt_code'       => $norekening,
                    'knt_date'       => $tglrekenig,
                    'agt_numb'       => $noanggota,
                    // 'png_code'       => $this->request->getPost('png_code'),
                    'prd_code'       => $kodeproduct,
                    'bng_type'       => 1,
                    'knt_tnid'       => $tenor,
                    'knt_tenr'       => $tenor,
                    'knt_totl'       => $jumlah,
                    'knt_marg'       => $bunga,
                    'smd_code'       => '01',
                    'knt_desc'       => 'Menabung',
                    'knt_prov'       => 0,
                    'knt_admn'       => 0,
                    'knt_asrn'       => 0,
                    'knt_tdan'       => 0,
                    'knt_matr'       => 0,
                    'knt_lain'       => 0,
                    'knt_tpot'       => 0,
                    'knt_tot1'       => 0,
                    'knt_gper'       => $tglangsuran,
                    'knt_angs'       => $knt_angs,
                    'knt_angb'       => $knt_angb,
                    'knt_agun'       => 0,
                    'knt_angp'       => $knt_angp,
                    'knt_jtdt'       => $tgljty,
                    'knt_pden'       => 0,
                    'knt_nden'       => 0,
                    'knt_mont'       => $bulan,
                    'knt_year'       => $tahun,
                    'knt_days'       => $days,
                    'knt_grac'       => 0,
                    'tbg_code'       => $rekdebet,
                    'knt_tmar'       => $knt_tmar,
                    'knt_nmrg'       => 0, //$this->request->getPost('knt_nmrg'),
                    'knt_asrk'       => 0, //$this->request->getPost('knt_asrk'),
                    'knt_notr'       => 0, //$this->request->getPost('knt_notr'),
                    'com_code'       => 1,
                    'kode_cabang'  => $kodecabang,
                    'emp_code'  => $empcode,
                    'kel_code'  => $kelcode,
                    'col_code'  => $colector,
                    'knt_stat' => 0,
                    'knt_jang' => $jenispembayaran,
                    'knt_hari' => 0,
                );

                $msave->_savekontrak($data);
            }
        }
        return redirect()->to('pinjaman/kontrak')->with('success', 'Import Data Berhasil');
    }

    public function kartuangsuran()
    {
        $msave = new Save_model();
        $file = $this->request->getFile('fileexcel');
        if ($file) {
            $excelReader  = new PHPExcel();
            //mengambil lokasi temp file
            $fileLocation = $file->getTempName();
            //baca file
            $objPHPExcel = PHPExcel_IOFactory::load($fileLocation);
            //ambil sheet active
            $sheet    = $objPHPExcel->getActiveSheet()->toArray(null, true, true, true);
            //looping untuk mengambil data
            $i = 0;
            foreach ($sheet as $idx => $data) {
                //skip index 1 karena title excel
                if ($idx == 1) {
                    continue;
                }
                $i = $i + 1;
                $norekening = trim($data['A']);
                $tglrekenig = $data['B'];
                $angsuranke = $data['C'];
                $tglangsuran = $data['D'];
                $noanggota = trim($data['E']);
                $knt_angs = $data['F'];
                $knt_angb =   $data['H'];
                $knt_angp =   $data['G'];
                $tglsetor = $data['I'];
                $setoranpokok = $data['J'];
                $setoranbnga = $data['K'];
                $kodecabang = trim($data['L']);

                // insert data
                $data = array(

                    'trx_date' => $tglrekenig,
                    'agt_numb' => $noanggota,
                    'trx_jens'  => 'AR-T007',
                    'trx_amnh'  => $knt_angs, //$this->request->getPost('totansuran[' . $x . ']'),
                    'lns_code'  => "MIGRASI-" . $i,
                    //'lns_date' => $tglsetor,
                    'trx_lnsh'  => 0,
                    'lns_pokk'  => $setoranpokok,
                    'lns_bung'  => $setoranbnga,
                    'trx_angk'  => $angsuranke,
                    'bkt_code'  => $norekening,
                    'bkt_date' => $tglangsuran,
                    'bkt_amnh'  => $knt_angs, //$this->request->getPost('totansuran[' . $x . ']'),
                    'trx_pokk'  => $knt_angp, //$this->request->getPost('pokokangsuran[' . $x . ']'),
                    'trx_bung'  => $knt_angb, //$this->request->getPost('pokokbunga[' . $x . ']'),
                    'trx_jtdt'  => $tglangsuran,
                    'trx_code' => $norekening, //$this->request->getPost('knt_code'),
                    'com_code'  => session()->get('com_code'),
                    'kode_cabang'  => $kodecabang,

                );
                $msave->_savekartupiutang($data);
            }
        }
        return redirect()->to('import/pinjaman')->with('success', 'Import Data Berhasil');
    }

    public function saldoawalgl()
    {
        $msave = new Save_model();
        $file = $this->request->getFile('fileexcel');
        if ($file) {
            $excelReader  = new PHPExcel();
            //mengambil lokasi temp file
            $fileLocation = $file->getTempName();
            //baca file
            $objPHPExcel = PHPExcel_IOFactory::load($fileLocation);
            //ambil sheet active
            $sheet    = $objPHPExcel->getActiveSheet()->toArray(null, true, true, true);
            //looping untuk mengambil data
            $i = 0;
            foreach ($sheet as $idx => $data) {
                //skip index 1 karena title excel
                if ($idx == 1) {
                    continue;
                }
                $i = $i + 1;
                $v_acc_code = $data['A'];

                $bulan = $data['B'];
                $tahun = $data['C'];
                $hari_ini = $tahun . '-' . $bulan . '-01'; // date("Y-m-d");

                $tgl_terakhir = date('Y-m-t', strtotime($hari_ini));
                $awl_amnt = $data['D'];
                $dbt_amnt = $data['E'];
                $crd_amnt =   $data['F'];
                $akh_amnt =   $data['G'];

                $kodecabang = $data['H'];

                // insert data
                $data = array(
                    'acc_code'       => $v_acc_code,
                    'acc_date'       => $tgl_terakhir,
                    'acc_buln'       => $bulan,
                    'acc_tahn'       => $tahun,
                    'acc_awhc'       => $awl_amnt,
                    'acc_dbhc'       => $dbt_amnt,
                    'acc_crhc'       => $crd_amnt,
                    'acc_akhc'       => $akh_amnt,

                    'com_code'       => 1,
                    'kode_cabang'  => $kodecabang,
                );
                $msave->_saveaposting($data);
            }
        }
        return redirect()->to('import/saldoawalgl')->with('success', 'Import Data Berhasil');
    }

    public function jurnaltrans()
    {
        $msave = new Save_model();
        $waktu = date('Y-m-d H:i:s');
        $file = $this->request->getFile('fileexcel');
        if ($file) {
            $excelReader  = new PHPExcel();
            //mengambil lokasi temp file
            $fileLocation = $file->getTempName();
            //baca file
            $objPHPExcel = PHPExcel_IOFactory::load($fileLocation);
            //ambil sheet active
            $sheet    = $objPHPExcel->getActiveSheet()->toArray(null, true, true, true);
            //looping untuk mengambil data
            $i = 0;
            foreach ($sheet as $idx => $data) {
                //skip index 1 karena title excel
                if ($idx == 1) {
                    continue;
                }
                $i = $i + 1;
                $v_trx_code = $data['A'];
                $v_trx_date = $data['B'];
                $v_acc_code = $data['C'];
                $trx_jens = 'MIG-01';
                $cos_cent = $data['D'];
                $trx_dbcr = $data['E'];
                $trx_amnt = $data['F'];
                if ($trx_dbcr == 'D') {
                    $trx_debt = $trx_amnt;
                    $trxcrdt = 0;
                } else {
                    $trx_debt = 0;
                    $trxcrdt = $trx_amnt;
                }
                $keterangan = $data['G'];

                $kodecabang = $data['H'];

                // insert data
                $data = array(
                    'trx_code' => $v_trx_code, // $this->request->getPost('trx_code'),
                    'trx_cod1' => $v_trx_code . '-1', // $this->request->getPost('trx_code'),
                    'trx_date' => $v_trx_date,
                    'trx_urut' => $i,
                    'acc_code'  => $v_acc_code,
                    'trx_dbcr'  => 'D',
                    'trx_jens'  => $trx_jens,
                    'trx_amnt'  => $trx_amnt,
                    'dbt_amnt'  => $trx_debt,
                    'crd_amnt'  => $trxcrdt,
                    'trx_des1'  => $keterangan,
                    'trx_des2'  => $keterangan,
                    'kode_cabang' => $kodecabang,
                    'ent_time' => $waktu,
                    'usercreated' => session()->get('username'),
                );

                $msave->_savejurnal($data);
            }
        }
        return redirect()->to('import/saldoawalgl')->with('success', 'Import Data Berhasil');
    }

    public function updateanggota()
    {
        $msave = new Save_model();
        $mgit = new Model_git();
        $dbanggota = $mgit->_get_finfanggotasma();
        $noanggota = '';
        foreach ($dbanggota->getResult() as $row) {
            $namaanggota = trim($row->nama);
            $dbanggota1 = $mgit->_get_finfanggotasma1($namaanggota);
            $data = array(
                'agt_numb' => '',
            );
            $msave->_updatetabungannama($data, $namaanggota);
            foreach ($dbanggota1->getResult() as $row1) {
                $nama = trim($row1->tbg_name);
                $alamat = trim($row1->tbg_des1);
                $dbanggota2 = $mgit->_get_finfanggota($nama, $alamat);
                foreach ($dbanggota2->getResult() as $row2) {
                    $noanggota = trim($row2->agt_numb);
                    $data = array(
                        'agt_numb' => $noanggota,
                    );
                    $msave->_updatetabungannama1($data, $nama, $alamat);
                }
            }
        }
        return redirect()->to('import/tabungan')->with('success', 'Import Data Berhasil');
    }

    public function updateanggotasimpanan()
    {
        $msave = new Save_model();
        $mgit = new Model_git();
        $dbanggota = $mgit->_get_finfanggotasma();
        $noanggota = '';
        foreach ($dbanggota->getResult() as $row) {
            $namaanggota = trim($row->nama);


            $dbanggota1 = $mgit->_get_finfanggotasma1($namaanggota);
            foreach ($dbanggota1->getResult() as $row1) {

                $norek = trim($row1->tbg_code);
                $noanggota = trim($row1->agt_numb);

                $data = array(
                    'agt_numb' => $noanggota,
                );
                $msave->_updatesimpanantab($data, $norek);
            }
        }
        return redirect()->to('import/tabungantrans')->with('success', 'Import Data Berhasil');
    }
}
