<?php

namespace App\Controllers;

use App\Models\Master_model;
use App\Models\Parameter_model;
use App\Models\Save_model;
use App\Models\Delete_model;
use App\Models\Auto_model;

class Management extends BaseController
{
    public function __construct()
    {
        $session = session();
    }
    protected $table = 'bcore_counter';
    private $db;
    public function index()
    {
        $_SESSION['com_menu'] = '';
        $_SESSION['com_men1'] = '';
        $_SESSION['com_men2'] = '';
    }
    public function lembaga()
    {
        $_SESSION['com_menu'] = '01';
        $_SESSION['com_men1'] = '0101';
        $model = new Master_model();
        $data['v_account']  = $model->_get_accountm()->getResult();
        $data['v_aplikasi']  = $model->_get_aplikasi()->getResult();
        return view('setup/aplikasi', $data);
    }

    public function user()
    {
        $model = new Master_model();
        $_SESSION['com_menu'] = '01';
        $_SESSION['com_men1'] = '0101';
        $data['v_user']  = $model->_get_user()->getResult();
        return view('setup/user/user_list', $data);
    }

    public function setclose()
    {
        $model = new Master_model();
        $data['v_close']  = $model->_get_closing()->getResult();
        return view('setup/closing/closing_list', $data);
    }

    public function tambahuser()
    {
        $model = new Master_model();
        $_SESSION['com_menu'] = '01';
        $_SESSION['com_men1'] = '0101';
        $data['v_role']  = $model->_getgroup()->getResult();
        $data['v_cabang']  = $model->_get_cabang()->getResult();
        return view('setup/user/user_add', $data);
    }

    public function edituser($id)
    {
        $model = new Master_model();
        $_SESSION['com_menu'] = '01';
        $_SESSION['com_men1'] = '0101';
        $data['v_role']  = $model->_getgroup()->getResult();
        $data['v_user']  = $model->_get_edituser($id)->getResult();
        return view('setup/user/user_edit', $data);
    }

    public function aksesuser()
    {
        $model = new Master_model();
        $data['v_user']  = $model->_get_user()->getResult();

        return view('setup/aksesuser/aksesuser', $data);
    }

    public function editakses($id)
    {
        $model = new Master_model();
        $_SESSION['com_menu'] = '01';
        $_SESSION['com_men1'] = '0101';
        $data['v_akses']  = $model->_get_aksesuser($id)->getResult();
        // $data['v_user']  = $model->_get_edituser($id)->getResult();
        $data['v_form']  = $model->_get_formakseuser()->getResult();
        return view('setup/aksesuser/editakses', $data);
    }

    public function saveuser()
    {
        $model = new Save_model();
        $vpass = $this->request->getPost('password');
        $datafoto = $this->request->getFile('fot_path');
        $filefoto = $datafoto->getRandomName();
        // $pass= password_generate($vpass);
        $data = array(

            'username'       => $this->request->getPost('username'),
            'password'       => $this->request->getPost('password'),
            'usr_name'       => $this->request->getPost('usr_name'),
            'usr_jabt'       => $this->request->getPost('usr_jabt'),
            'fot_path'       => $filefoto,

        );
        $model->_saveuser($data);
        $datafoto->move('assets/images/user', $filefoto);

        return redirect()->to('setup/user')->with('success', 'Tambah Data Berhasil');
    }


    public function updateuser()
    {
        $model = new Save_model();

        $id = $this->request->getPost('username');
        $datafoto = $this->request->getFile('fot_path');
        $filefoto = $datafoto->getRandomName();
        $data = array(

            'username'       => $this->request->getPost('username'),
            'password'       => $this->request->getPost('password'),
            'usr_name'       => $this->request->getPost('usr_name'),
            'usr_jabt'       => $this->request->getPost('usr_jabt'),
            'fot_path'       => $filefoto,

        );
        $model->_updateuser($data, $id);
        $datafoto->move('assets/images/user', $filefoto);
        return redirect()->to('setup/user')->with('success', 'Merubah Data Berhasil');
    }
    public function deleteuser()

    {
        $model =  new Delete_model();
        $id = $this->request->getPost('code');
        $model->_deleteuser($id);
        return redirect()->to('setup/user')->with('success', 'Hapus Data Berhasil');
    }

    public function  saveaplikasi()
    {
        $model = new Save_model();
        $id = $this->request->getPost('com_code');
        $datacover = $this->request->getFile('com_covr');
        $filecover = $datacover->getRandomName();
        $datalogo = $this->request->getFile('com_logo');
        $filelogo = $datacover->getRandomName();


        $data = array(

            'com_name'       => $this->request->getPost('com_name'),
            'com_adrs'       => $this->request->getPost('com_adrs'),
            'com_zcod'       => $this->request->getPost('com_zcod'),
            'com_phon'       => $this->request->getPost('com_phon'),
            'com_mail'       => $this->request->getPost('com_mail'),
            'com_covr'       => $filecover,
            'com_logo'       => $filelogo,
            'com_npwp'       => $this->request->getPost('com_npwp'),
            'com_ppht'       => $this->request->getPost('com_ppht'),
            'com_pphd'       => $this->request->getPost('com_pphd'),
            'com_shub'       => $this->request->getPost('com_shub'),
            'com_shut'       => $this->request->getPost('com_shut'),
            'com_shul'       => $this->request->getPost('com_shul'),

        );

        $model->_updatecompany($data, $id);
        if ($filecover != '') {
            $datacover->move('assets/images/', $filecover);
        }
        if ($filelogo != '') {
            $datalogo->move('assets/images/', $filelogo);
        }

        return redirect()->to('setup/aplikasi')->with('success', 'Menyimpan Data Berhasil');
    }


    public function save_aksesuser()
    {
        $model = new Save_model();
        $moddel = new Delete_model();

        $id = $this->request->getPost('username');

        $data = array(

            'usr_addd' => $this->request->getPost('usr_addd'),

        );
        $model->_updateuserakses($data, $id);

        // <!-- $kode = $_POST['frm_code']; -->
        $kode1 = $_POST['frm_stat'];

        $jumlah = count($kode1);
        $x = 0;
        if ($jumlah > 0) {
            $moddel->_deleteakses($id);
        }
        for ($x = 0; $x < $jumlah; $x++) {
            $kode = $this->request->getPost('frm_code[' . $x . ']');

            $akses = $this->request->getPost('frm_stat[' . $x . ']');



            $data = array(
                'username' => $this->request->getPost('username'),
                'frm_code' => $kode,
                'frm_stat' => $akses,

            );
            $model->_saveaksesuser($data);
        }
        return redirect()->to('setup/aksesuser/aksesuser')->with('success', 'Menyimpan Data Berhasil');
    }






    public function akses()
    {
        $model = new Master_model();
        $_SESSION['com_menu'] = '01';
        $_SESSION['com_men1'] = '0101';
        $data['v_user']  = $model->_get_user()->getResult();

        return view('setup/aksesuser/aksesuser', $data);
    }


    public function akun()
    {
        $_SESSION['com_menu'] = '01';
        $_SESSION['com_men1'] = '0101';
        $model = new Master_model();
        $data['v_akun']  = $model->_getakun()->getResult();
        return view('manajemen/akun/akun_list', $data);
    }

    public function addakun()
    {
        $_SESSION['com_menu'] = '01';
        $_SESSION['com_men1'] = '0101';
        $model = new Master_model();
        return view('manajemen/akun/akun_add');
    }
    public function editakun($id)
    {
        $_SESSION['com_menu'] = '01';
        $_SESSION['com_men1'] = '0101';
        $model = new Master_model();
        $data['v_data']  = $model->_dtgetakun($id)->getResult();
        return view('manajemen/akun/akun_edit', $data);
    }

    public function saveakun()
    {
        $model = new save_model();
        $data = array(
            'akun_cabang' => $this->request->getPost('akn_code'),
            'nama_cabang' => $this->request->getPost('akn_name'),
            'bi_kode_kantor' => $this->request->getPost('akn_kntr'),
            // 'akn_stat' => 'Y',
            'tgl_create' => date('Y-m-d'),
        );
        $model->_saveakun($data);
        return redirect()->to('management/akun')->with('success', 'Simpan Data Berhasil');
    }

    public function updateakun()
    {
        $model = new save_model();
        $id = $this->request->getPost('akn_code');
        $data = array(
            'akun_cabang' => $this->request->getPost('akn_code'),
            'nama_cabang' => $this->request->getPost('akn_name'),
            'bi_kode_kantor' => $this->request->getPost('akn_kntr'),
            'tgl_update' => date('Y-m-d'),
        );
        $model->_updateakun($data, $id);
        return redirect()->to('management/akun')->with('success', 'Update Data Berhasil');
    }


    public function deleteakun($id)
    {
        $model = new Delete_model();
        $model->_deleteakun($id);
        return redirect()->to('management/akun')->with('success', 'Menghapus Data Berhasil');
    }
    public function group()
    {
        $model = new Master_model();
        $_SESSION['com_menu'] = '01';
        $_SESSION['com_men1'] = '0101';
        $data['v_group']  = $model->_getgroup()->getResult();
        return view('manajemen/group/group_list', $data);
    }
    // Group
    public function addgroup()
    {
        $model = new Master_model();
        $_SESSION['com_menu'] = '01';
        $_SESSION['com_men1'] = '0101';
        $data['v_group']  = $model->_getgroup()->getResult();
        return view('manajemen/group/group_add', $data);
    }


    public function editgroup($id)
    {
        $model = new Master_model();
        $_SESSION['com_menu'] = '01';
        $_SESSION['com_men1'] = '0101';
        $data['v_data']  = $model->_dtgetgroup($id)->getResult();
        return view('manajemen/group/group_edit', $data);
    }

    public function savegroup()
    {
        $model = new save_model();

        $data = array(
            'grp_code' => $this->request->getPost('kel_code'),
            'grp_name' => $this->request->getPost('kel_name'),
            'akses_ubah_tanggal' =>       $this->request->getPost(
                'ubh_date'
            ),
            'akses_ubah_cabang' => $this->request->getPost(
                'ubh_cabg'
            ),
            'limit_penarikan_tabungan' => $this->request->getPost(
                'pnr_simpan'
            ),
            'limit_setoran_tabungan ' => $this->request->getPost('str_simpan'),
            'limit_pencairan_pinjaman ' => $this->request->getPost(
                'lmt_cairbiaya'
            ),
            'akses_ovrd_restricted_tabungan ' => $this->request->getPost('fil_restri'),

            'limit_setoran_pinjaman' => $this->request->getPost(
                'lmt_strbiaya'
            ),
            'limit_penarikan_deposito' => $this->request->getPost(
                'lmt_trkssb'
            ),
            'limit_setoran_deposito' => $this->request->getPost(
                'lmt_simssb'
            ),
            'limit_penarikan_bunga_deposito' => $this->request->getPost(
                'lmt_ambbasil'
            ),
            'akses_break_deposito' => $this->request->getPost(
                'lmt_brekssb'
            ),
            'akses_print_bilyet_deposito' => $this->request->getPost(
                'bilyetssb'
            ),
            'limit_pengeluaran_kas_besar' => $this->request->getPost(
                'lmt_kbesarpengeluaran'
            ),
            'limit_penerimaan_kas_besar ' => $this->request->getPost(
                'lmt_kbesarpenerimaan'
            ),
            'limit_droping_kas_kecil' => $this->request->getPost(
                'lmt_dropingkecil'
            ),
            'limit_droping_kas_teller' => $this->request->getPost(
                'lmt_dropingkasir'
            ),
            'limit_droping_kas_edc' => $this->request->getPost(
                'lmt_dropingedc'
            ),
            'limit_pengeluaran_kas_kecil' => $this->request->getPost(
                'lmt_kecilpengeluaran'
            ),
            'limit_penerimaan_kas_kecil' => $this->request->getPost(
                'lmt_kecilpenerimaan'
            ),
            'limit_pengeluaran_kas_teller' => $this->request->getPost(
                'lmt_kasirpengeluaran'
            ),
            'limit_penerimaan_kas_teller' => $this->request->getPost(
                'lmt_kasirpenerimaan'
            ),
            'limit_rab_kas_teller' => $this->request->getPost('lmt_kasirrab'),
            'limit_rab_kas_kecil' => $this->request->getPost('lmt_kecilrab'),
            'limit_rab_kas_edc' => $this->request->getPost('lmt_edcrab'),
            'limit_pengeluaran_kas_edc' => $this->request->getPost('lmt_edcpengeluaran'),
            'limit_penerimaan_kas_edc' => $this->request->getPost('lmt_edcpenerimaan'),
            'akses_filter_norek' => $this->request->getPost('lmt_filter'),
        );
        $model->_savegroup($data);
        return redirect()->to('management/group')->with('success', 'Tambah Data Berhasil');
    }

    public function updategroup()
    {
        $model = new save_model();
        $id = $this->request->getPost('kel_code');
        $data = array(
            'grp_name' => $this->request->getPost('kel_name'),
            'akses_ubah_tanggal' =>       $this->request->getPost(
                'ubh_date'
            ),
            'akses_ubah_cabang' => $this->request->getPost(
                'ubh_cabg'
            ),
            'limit_penarikan_tabungan' => $this->request->getPost(
                'pnr_simpan'
            ),
            'limit_setoran_tabungan ' => $this->request->getPost('str_simpan'),
            'limit_pencairan_pinjaman ' => $this->request->getPost(
                'lmt_cairbiaya'
            ),
            'limit_setoran_pinjaman' => $this->request->getPost(
                'lmt_strbiaya'
            ),
            'limit_penarikan_deposito' => $this->request->getPost(
                'lmt_trkssb'
            ),
            'limit_setoran_deposito' => $this->request->getPost(
                'lmt_simssb'
            ),
            'limit_penarikan_bunga_deposito' => $this->request->getPost(
                'lmt_ambbasil'
            ),
            'akses_break_deposito' => $this->request->getPost(
                'lmt_brekssb'
            ),
            'akses_print_bilyet_deposito' => $this->request->getPost(
                'bilyetssb'
            ),
            'limit_pengeluaran_kas_besar' => $this->request->getPost(
                'lmt_kbesarpengeluaran'
            ),
            'limit_penerimaan_kas_besar ' => $this->request->getPost(
                'lmt_kbesarpenerimaan'
            ),
            'limit_droping_kas_kecil' => $this->request->getPost(
                'lmt_dropingkecil'
            ),
            'limit_droping_kas_edc' => $this->request->getPost(
                'lmt_dropingedc'
            ),
            'limit_pengeluaran_kas_kecil' => $this->request->getPost(
                'lmt_kecilpengeluaran'
            ),
            'limit_penerimaan_kas_kecil' => $this->request->getPost(
                'lmt_kecilpenerimaan'
            ),
            'limit_pengeluaran_kas_teller' => $this->request->getPost(
                'lmt_kasirpengeluaran'
            ),
            'limit_penerimaan_kas_teller' => $this->request->getPost(
                'lmt_kasirpenerimaan'
            ),
            'limit_rab_kas_teller' => $this->request->getPost('lmt_kasirrab'),
            'limit_rab_kas_kecil' => $this->request->getPost('lmt_kecilrab'),
            'limit_rab_kas_edc' => $this->request->getPost('lmt_edcrab'),
            'limit_pengeluaran_kas_edc' => $this->request->getPost('lmt_edcpengeluaran'),
            'limit_penerimaan_kas_edc' => $this->request->getPost('lmt_edcpenerimaan'),
            'akses_filter_norek' => $this->request->getPost('lmt_filter'),
        );
        $model->_updategroup($data, $id);
        return redirect()->to('management/group')->with('success', 'Tambah Data Berhasil');
    }


    public function deletegroup($id)
    {
        $model = new Delete_model();
        $model->_deletegroup($id);
        return redirect()->to('management/group')->with('success', 'Menghapus Data Berhasil');
    }
    public function counter()
    {

        $_SESSION['com_menu'] = '01';
        $_SESSION['com_men1'] = '0101';
        $this->db = \Config\Database::connect();


        $data['v_pinjaman'] = $this->db->table($this->table)->like('trans_key', 'M3', 'before')->like('trans_key', '001', 'after')->get()->getResult();
        $data['v_simpanan'] = $this->db->table($this->table)->like('trans_key', 'M1', 'before')->like('trans_key', '001', 'after')->get()->getResult();
        return view('manajemen/counter/counter_list', $data);
    }
    public function konsolidasi()
    {
        $model = new Master_model();
        $_SESSION['com_menu'] = '01';
        $_SESSION['com_men1'] = '0101';
        $data['v_data']  = $model->_get_konsolidasi()->getResult();

        return view('manajemen/konsolidasi/konsolidasi_list', $data);
    }
    public function addkonsolidasi()
    {
        $model = new Master_model();
        // $data['v_cabang']  = $model->_getgroup()->getResult();
        return view('manajemen/konsolidasi/konsolidasi_add');
    }
    public function editkonsolidasi($id)
    {
        $model = new Master_model();
        // $data['v_cabang']  = $model->_getgroup()->getResult();
        $data['v_data']  = $model->_get_edkonsolidasi($id)->getResult();
        return view('manajemen/konsolidasi/konsolidasi_edit', $data);
    }

    public function savekonsolidasi()
    {
        $model = new save_model();
        $data = array(
            'akun_konsolidasi' => $this->request->getPost('kon_code'),
            'deskripsi' => $this->request->getPost('kon_name'),
            'akun_cabang_all' => $this->request->getPost('kon_chek'),

            'tgl_create' => date('Y-m-d'),
        );
        $model->_savekodekonsolidasi($data);
        return redirect()->to('management/konsolidasi')->with('success', 'Simpan Data Berhasil');
    }

    public function updatekonsolidasi()
    {
        $model = new save_model();
        $id = $this->request->getPost('kon_code');
        $data = array(

            'deskripsi' => $this->request->getPost('kon_name'),
            'akun_cabang_all' => $this->request->getPost('kon_chek'),

            'tgl_create' => date('Y-m-d'),
        );
        $model->_updatekodekonsolidasi($data, $id);
        return redirect()->to('management/konsolidasi')->with('success', 'Update Data Berhasil');
    }

    public function deletekonsolidasi($id)
    {
        $model = new  Delete_model();
        $model->_deletetkodekonsolidasi($id);
        return redirect()->to('management/konsolidasi')->with('success', 'Update Data Berhasil');
    }
    public function aplikasi()
    {
        $model = new Parameter_model();
        $_SESSION['com_menu'] = '01';
        $_SESSION['com_men1'] = '0101';
        $id = 'S';
        /* $data['v_tahun']  = $model->_get_tahun()->getResult();
        $data['v_product']  = $model->_get_productb($id)->getResult(); */
        $data['v_keamanan']  = $model->_get_param(['param_kode <' => '00100'])->getResult();
        $data['v_admin']  = $model->_get_param(['param_kode >=' => '00100', 'param_kode <=' => '00200'])->getResult();
        $data['v_tabung']  = $model->_get_param(['param_kode >=' => '10000', 'param_kode <' => '20000'])->getResult();
        $data['v_deposito']  = $model->_get_param(['param_kode >=' => '20000', 'param_kode <' => '30000'])->getResult();
        $data['v_kredit']  = $model->_get_param(['param_kode >=' => '30000', 'param_kode <' => '40000'])->getResult();
        $data['v_inventaris']  = $model->_get_param(['param_kode >=' => '40000', 'param_kode <' => '50000'])->getResult();
        $data['v_rra']  = $model->_get_param(['param_kode >=' => '50000', 'param_kode <' => '60000'])->getResult();
        $data['v_rrp']  = $model->_get_param(['param_kode >=' => '60000', 'param_kode <' => '70000'])->getResult();
        $data['v_rak']  = $model->_get_param(['param_kode >=' => '70000', 'param_kode <' => '80000'])->getResult();
        $data['v_pembukuan']  = $model->_get_param(['param_kode >=' => '90000', 'param_kode <' => '96000'])->getResult();
        return view('manajemen/aplikasi/aplikasi_list', $data);
    }
    public function updateaplikasi()
    {
        $model = new Parameter_model();
        $_SESSION['com_menu'] = '01';
        $_SESSION['com_men1'] = '0101';
        $id = $this->request->getPost('pk');
        $val = $this->request->getPost('value');
        $data = array(
            'param_value' => $val,
        );
        $model->_updateparam($data, $id);
        //return redirect()->to('management/konsolidasi')->with('success', 'Update Data Berhasil');
    }
    public function cabang()
    {

        $model = new Master_model();
        $_SESSION['com_menu'] = '01';
        $_SESSION['com_men1'] = '0101';
        $data['v_cabang']  = $model->_get_cabang()->getResult();

        return view('manajemen/cabang/cabang_list', $data);
    }
    public function addcabang()
    {
        $model = new Master_model();
        $_SESSION['com_menu'] = '01';
        $_SESSION['com_men1'] = '0101';
        // $data['v_cabang']  = $model->_getgroup()->getResult();
        $data['v_akun']  = $model->_getakun()->getResult();
        //$data['v_kodepos']  = $model->_getkodepos()->getResult();
        $data['v_kota']  = $model->_getkota()->getResult();
        $data['v_account']  = $model->_get_account()->getResult();
        return view('manajemen/cabang/cabang_add', $data);
    }

    public function editcabang($id)
    {
        $model = new Master_model();
        $_SESSION['com_menu'] = '01';
        $_SESSION['com_men1'] = '0101';
        $data['v_data']  = $model->__get_edcabang($id)->getResult();
        $data['v_akun']  = $model->_getakun()->getResult();
        // $data['v_kodepos']  = $model->_getkodepos()->getResult();
        $data['v_kota']  = $model->_getkota()->getResult();
        $data['v_account']  = $model->_get_account()->getResult();
        return view('manajemen/cabang/cabang_edit', $data);
    }

    public function savecabang()
    {
        $model = new Save_model();
        $data = array(
            'jenis_cabang' => $this->request->getPost('jns_kntr'),
            'kode_cabang' => $this->request->getPost('cab_code'),
            'akun_cabang' => $this->request->getPost('akun_code'),
            'nama_cabang' => $this->request->getPost('kntr_nama'),
            'alamat_cabang' => $this->request->getPost('kntr_adrs'),
            'kode_kota' => $this->request->getPost('kota_code'),
            'kdp_code' => $this->request->getPost('pos_code'),
            'telp' => $this->request->getPost('cab_telp'),
            'fax' => $this->request->getPost('cab_faxs'),
            'pimpinan_cabang' => $this->request->getPost('cab_pimp'),
            'kas_prepared_name' => $this->request->getPost('kas_buat'),
            'kas_prepared_as	' => $this->request->getPost('kas_jbut'),
            'kas_checked_name' => $this->request->getPost('kas_pers'),
            'kas_checked_as	' => $this->request->getPost('kas_jper'),
            'kas_audit_name' => $this->request->getPost('kas_iaud'),
            'kas_audit_as' => $this->request->getPost('kas_jiau'),
            'kas_approved_name' => $this->request->getPost('kas_setj'),
            'kas_approved_as' => $this->request->getPost('kas_jset'),
            'gl_prepared_name' => $this->request->getPost('acn_buat'),
            'gl_prepared_as' => $this->request->getPost('acn_jbut'),
            'gl_checked_name' => $this->request->getPost('acn_pers'),
            'gl_checked_as' => $this->request->getPost('acn_jper'),
            'gl_audit_name' => $this->request->getPost('acn_iaud'),
            'gl_audit_as' => $this->request->getPost('acn_jiau'),
            'gl_approved_name' => $this->request->getPost('acn_setj'),
            'gl_approved_as' => $this->request->getPost('acn_jset'),
            'acc_arcd' => $this->request->getPost('acc_arcd'),
            'acc_apcd' => $this->request->getPost('acc_apcd'),



        );
        $model->_savecabang($data);
        return redirect()->to('management/cabang')->with('success', 'Tambah Data Berhasil');
    }

    public function updatecabang()
    {
        $model = new Save_model();
        $id = $this->request->getPost('cab_code');
        $data = array(

            'jenis_cabang' => $this->request->getPost('jns_kntr'),
            'akun_cabang' => $this->request->getPost('akun_code'),
            'nama_cabang' => $this->request->getPost('kntr_nama'),
            'alamat_cabang' => $this->request->getPost('kntr_adrs'),
            'kode_kota' => $this->request->getPost('kota_code'),
            'kdp_code' => $this->request->getPost('pos_code'),
            'telp' => $this->request->getPost('cab_telp'),
            'fax' => $this->request->getPost('cab_faxs'),
            'pimpinan_cabang' => $this->request->getPost('cab_pimp'),
            'kas_prepared_name' => $this->request->getPost('kas_buat'),
            'kas_prepared_as	' => $this->request->getPost('kas_jbut'),
            'kas_checked_name' => $this->request->getPost('kas_pers'),
            'kas_checked_as	' => $this->request->getPost('kas_jper'),
            'kas_audit_name' => $this->request->getPost('kas_iaud'),
            'kas_audit_as' => $this->request->getPost('kas_jiau'),
            'kas_approved_name' => $this->request->getPost('kas_setj'),
            'kas_approved_as' => $this->request->getPost('kas_jset'),
            'gl_prepared_name' => $this->request->getPost('acn_buat'),
            'gl_prepared_as' => $this->request->getPost('acn_jbut'),
            'gl_checked_name' => $this->request->getPost('acn_pers'),
            'gl_checked_as' => $this->request->getPost('acn_jper'),
            'gl_audit_name' => $this->request->getPost('acn_iaud'),
            'gl_audit_as' => $this->request->getPost('acn_jiau'),
            'gl_approved_name' => $this->request->getPost('acn_setj'),
            'gl_approved_as' => $this->request->getPost('acn_jset'),
            'acc_arcd' => $this->request->getPost('acc_arcd'),
            'acc_apcd' => $this->request->getPost('acc_apcd'),



        );
        $model->_updatecabang($data, $id);
        return redirect()->to('management/cabang')->with('success', 'Tambah Data Berhasil');
    }

    public function backup()
    {
        $_SESSION['com_menu'] = '01';
        $_SESSION['com_men1'] = '0103';
        return view('manajemen/backup');
    }
    public function restore()
    {
        $_SESSION['com_menu'] = '01';
        $_SESSION['com_men1'] = '0103';
        return view('manajemen/restore');
    }

    public function reposting()
    {
        $model = new Master_model();
        $_SESSION['com_menu'] = '01';
        $_SESSION['com_men1'] = '0103';
        $data['v_tahun']  = $model->_get_tahun()->getResult();
        return view('manajemen/reposting', $data);
    }

    public function savegroupcabang()
    {
        $model = new Save_model();
        $data = array(
            'grp_code' => $this->request->getPost('kel_code'),
            'kel_name' => $this->request->getPost('kel_name'),
            'akses_ubah_tanggal' =>       $this->request->getPost(
                'ubh_date'
            ),
            'akses_ubah_cabang' => $this->request->getPost(
                'ubh_cabg'
            ),
            'limit_penarikan_tabungan' => $this->request->getPost(
                'pnr_simpan'
            ),
            'limit_setoran_tabungan ' => $this->request->getPost('str_simpan'),
            'limit_pencairan_pinjaman ' => $this->request->getPost(
                'lmt_cairbiaya'
            ),
            'limit_setoran_pinjaman' => $this->request->getPost(
                'lmt_strbiaya'
            ),
            'limit_penarikan_deposito' => $this->request->getPost(
                'lmt_trkssb'
            ),
            'limit_setoran_deposito' => $this->request->getPost(
                'lmt_simssb'
            ),
            'limit_penarikan_bunga_deposito' => $this->request->getPost(
                'lmt_ambbasil'
            ),
            'akses_break_deposito' => $this->request->getPost(
                'lmt_brekssb'
            ),
            'akses_print_bilyet_deposito' => $this->request->getPost(
                'bilyetssb'
            ),
            'limit_pengeluaran_kas_besar' => $this->request->getPost(
                'lmt_kbesarpengeluaran'
            ),
            'limit_penerimaan_kas_besar ' => $this->request->getPost(
                'lmt_kbesarpenerimaan'
            ),
            'limit_droping_kas_kecil' => $this->request->getPost(
                'lmt_dropingkecil'
            ),
            'limit_droping_kas_edc' => $this->request->getPost(
                'lmt_dropingedc'
            ),
            'limit_pengeluaran_kas_kecil' => $this->request->getPost(
                'lmt_kecilpengeluaran'
            ),
            'limit_penerimaan_kas_kecil' => $this->request->getPost(
                'lmt_kecilpenerimaan'
            ),
            'limit_pengeluaran_kas_teller' => $this->request->getPost(
                'lmt_kasirpengeluaran'
            ),
            'limit_penerimaan_kas_teller' => $this->request->getPost(
                'lmt_kasirpenerimaan'
            ),
            'limit_rab_kas_teller' => $this->request->getPost('lmt_kasirrab'),
            'limit_rab_kas_kecil' => $this->request->getPost('lmt_kecilrab'),
            'limit_rab_kas_edc' => $this->request->getPost('lmt_edcrab'),
            'limit_pengeluaran_kas_edc' => $this->request->getPost('lmt_edcpengeluaran'),
            'limit_penerimaan_kas_edc' => $this->request->getPost('lmt_edcpenerimaan'),
            'akses_filter_norek' => $this->request->getPost('lmt_filter'),
        );
        $model->_savegroupcabang($data);
        return redirect()->to('management/group')->with('success', 'Tambah Data Berhasil');
    }
    public function logtrans()
    {
        $_SESSION['com_menu'] = '01';
        $_SESSION['com_men1'] = '0103';
        return view('manajemen/logtransaksi');
    }

    public function updateconter()
    {
        $model = new save_model();
        // Simpanan
        $kode = $_POST['id_simpanan'];
        if ($kode == '') {
            $jumlah = 0;
        } else {
            $jumlah = count($kode);
        }


        for ($x = 0; $x < $jumlah; $x++) {
            $x1 = $x + 1;
            $kode1 = $this->request->getPost('id_simpanan[' . $x . ']');

            if ($kode1 != '') {
                $data = array(
                    'counter_no' => $this->request->getPost('no_simpanan[' . $x . ']'),
                );


                $model->_updatecounter($data, $kode1);
            }
        }

        // Pinjaman
        $kode = $_POST['id_pinjaman'];
        if ($kode == '') {
            $jumlah = 0;
        } else {
            $jumlah = count($kode);
        }


        for ($x = 0; $x < $jumlah; $x++) {
            $x1 = $x + 1;
            $kode1 = $this->request->getPost('id_pinjaman[' . $x . ']');

            if ($kode1 != '') {
                $data = array(
                    'counter_no' => $this->request->getPost('no_pinjaman[' . $x . ']'),
                );

                $model->_updatecounter($data, $kode1);
            }
        }
        return redirect()->to('management/counter')->with('success', 'update  counter Berhasil');
    }
    public function deletecabang($id)
    {
        $model =  new Delete_model();
        // $id = $this->request->getPost('code');
        $model->_deletecabang($id);
        return redirect()->to('management/cabang')->with('success', 'Hapus Data Berhasil');
    }
    //end
}
