<?php

namespace App\Controllers;

use App\Models\Master_model;
use App\Models\Save_model;
use App\Models\Delete_model;
use App\Models\Auto_model;
use phpDocumentor\Reflection\Types\This;
use PhpParser\Builder\FunctionLike;
use PHPExcel;
use PHPExcel_IOFactory;

use function PHPUnit\Framework\isNull;

class Master extends BaseController
{
  public function __construct()
  {
    $session = session();
  }
  public function index()
  {
    $_SESSION['com_menu'] = '';
    $_SESSION['com_men1'] = '';
    $_SESSION['com_men2'] = '';
  }
  public function bank()
  {
    $model = new Master_model();
    $_SESSION['com_menu'] = '03';
    $_SESSION['com_men1'] = '0301';
    $_SESSION['com_men2'] = '030103';
    $data['v_bank']  = $model->_get_bank()->getResult();
    return view('master/bank/bank_list', $data);
  }

  public function addbank()
  {
    $model = new Master_model();
    $_SESSION['com_menu'] = '03';
    $_SESSION['com_men1'] = '0301';
    $_SESSION['com_men2'] = '030103';

    $data['v_account']  = $model->_get_account()->getResult();
    $data['v_cabang']  = $model->_get_cabang()->getResult();
    return view('master/bank/bank_add', $data);
  }

  public function editbank($id)
  {
    $model = new Master_model();
    $_SESSION['com_menu'] = '03';
    $_SESSION['com_men1'] = '0301';
    $_SESSION['com_men2'] = '030103';
    $data['v_cabang']  = $model->_get_cabang()->getResult();
    $data['v_bank']  = $model->_get_editbank($id)->getResult();
    $data['v_account']  = $model->_get_account()->getResult();

    return view('master/bank/bank_edit', $data);
  }


  public function savebank()
  {
    $model = new Save_model();
    $data = array(
      'bnk_code'       => $this->request->getPost('bnk_code'),
      'bnk_name'       => $this->request->getPost('bnk_name'),
      'acc_code'       => $this->request->getPost('acc_code'),
      'kode' => $this->request->getPost('cab_code'),
      'bnk_stat' => 'Y',

    );

    $model->_savebank($data);
    return redirect()->to('master/bank')->with('sukses', 'Menyimpan Data Baru Berhasil');
  }

  public function updatebank()
  {
    $model = new Save_model();
    $id = $this->request->getPost('bnk_code');
    $data = array(

      'bnk_name'       => $this->request->getPost('bnk_name'),
      'acc_code'       => $this->request->getPost('acc_code'),
      'bnk_stat'       => $this->request->getPost('bnk_stat'),
      'kode' => $this->request->getPost('cab_code'),
    );

    $model->_updatebank($data, $id);
    return redirect()->to('master/bank')->with('success', 'Merubah Data Berhasil');
  }
  public function deletebank($id)
  {
    $model = new Delete_model();
    // $id=$this->request->getPost('code');
    $model->m_deletebank($id);
    return redirect()->to('master/bank')->with('success', 'Menghapus Data Berhasil');
  }
  public function product()
  {
    $model = new Master_model();
    $_SESSION['com_menu'] = '04';
    $_SESSION['com_men1'] = '0401';
    $_SESSION['com_men2'] = '040103';
    $id = 'T';
    $data['v_product']  = $model->_get_product12($id)->getResult();
    return view('master/product/product_list', $data);
  }

  public function productssb()
  {
    $model = new Master_model();
    $id = 'D';
    $_SESSION['com_menu'] = '04';
    $_SESSION['com_men1'] = '0402';
    $_SESSION['com_men2'] = '040203';
    $data['v_product']  = $model->_get_product1($id)->getResult();
    return view('master/productsb/product_list', $data);
  }

  public function productpinjaman()
  {
    $model = new Master_model();
    $_SESSION['com_menu'] = '04';
    $_SESSION['com_men1'] = '0403';
    $_SESSION['com_men2'] = '040303';
    $id = 'K';
    $data['v_product']  = $model->_get_product1($id)->getResult();
    return view('master/productpembiayaan/product_list', $data);
  }

  public function addproduct()
  {
    $model = new Master_model();
    $_SESSION['com_menu'] = '04';
    $_SESSION['com_men1'] = '0401';
    $_SESSION['com_men2'] = '040103';
    $data['v_type']  = $model->_get_type()->getResult();
    $data['v_account']  = $model->_get_account()->getResult();
    $data['v_jenis']  = $model->_get_jenis()->getResult();
    return view('master/product/product_add', $data);
  }

  public function addproductssb()
  {
    $model = new Master_model();
    $_SESSION['com_menu'] = '04';
    $_SESSION['com_men1'] = '0402';
    $_SESSION['com_men2'] = '040203';
    $data['type'] = 'D';
    $data['v_type']  = $model->_get_type()->getResult();
    $data['v_account']  = $model->_get_account()->getResult();
    $data['v_jenis']  = $model->_get_jenis()->getResult();
    return view('master/productsb/product_add', $data);
  }
  public function addproductpembiayaan()
  {
    $model = new Master_model();
    $_SESSION['com_menu'] = '04';
    $_SESSION['com_men1'] = '0403';
    $_SESSION['com_men2'] = '040303';
    $data['type'] = 'K';
    $data['v_type']  = $model->_get_type()->getResult();
    $data['v_account']  = $model->_get_account()->getResult();
    $data['v_jenis']  = $model->_get_jenis()->getResult();
    return view('master/productpembiayaan/product_add', $data);
  }
  public function eproduct($id)
  {
    $model = new Master_model();
    $_SESSION['com_menu'] = '04';
    $_SESSION['com_men1'] = '0401';
    $_SESSION['com_men2'] = '040103';
    $data['v_product']  = $model->_get_eproduct($id)->getResult();
    $data['v_type']  = $model->_get_type()->getResult();
    $data['v_account']  = $model->_get_account()->getResult();
    $data['v_detil']  = $model->_get_hmargin($id)->getResult();
    $data['v_margin']  = $model->_get_periode()->getResult();
    $data['v_jenis']  = $model->_get_jenis()->getResult();
    return view('master/product/product_edit', $data);
  }

  public function eproductssb($id)
  {
    $model = new Master_model();
    $_SESSION['com_menu'] = '04';
    $_SESSION['com_men1'] = '0402';
    $_SESSION['com_men2'] = '040203';
    $data['v_product']  = $model->_get_eproduct($id)->getResult();
    $data['v_type']  = $model->_get_type()->getResult();
    $data['v_account']  = $model->_get_account()->getResult();
    $data['v_detil']  = $model->_get_hmargin($id)->getResult();
    $data['v_margin']  = $model->_get_periode()->getResult();
    $data['v_jenis']  = $model->_get_jenis()->getResult();
    return view('master/productsb/product_edit', $data);
  }

  public function eproductpembiayaan($id)
  {
    $model = new Master_model();
    $_SESSION['com_menu'] = '04';
    $_SESSION['com_men1'] = '0403';
    $_SESSION['com_men2'] = '040303';
    $data['v_product']  = $model->_get_eproduct($id)->getResult();
    $data['v_type']  = $model->_get_type()->getResult();
    $data['v_account']  = $model->_get_account()->getResult();
    $data['v_detil']  = $model->_get_hmargin($id)->getResult();
    $data['v_margin']  = $model->_get_periode()->getResult();
    $data['v_jenis']  = $model->_get_jenis()->getResult();
    return view('master/productpembiayaan/product_edit', $data);
  }
  public function saveproduct()
  {
    $prd_smin = str_replace(',', '', $this->request->getPost('prd_smin'));
    $prd_mstr = str_replace(',', '', $this->request->getPost('prd_mstr'));
    $prd_marg = str_replace(',', '', $this->request->getPost('prd_marg'));
    $prd_bons = str_replace(',', '', $this->request->getPost('prd_bons'));
    $prd_sawl = str_replace(',', '', $this->request->getPost('prd_sawl'));
    $prd_keli = str_replace(',', '', $this->request->getPost('prd_keli'));
    $prd_pilt = str_replace(',', '', $this->request->getPost('prd_pilt'));
    $prd_mjas = str_replace(',', '', $this->request->getPost('prd_mjas'));
    $prd_attp = str_replace(',', '', $this->request->getPost('prd_attp'));
    $prd_admn = str_replace(',', '', $this->request->getPost('prd_admn'));
    $prd_spas = str_replace(',', '', $this->request->getPost('prd_spas'));
    $jenisbonus = trim($this->request->getPost('prd_jbon'));
    $typ_angs = trim($this->request->getPost('typ_angs'));
    if ($this->request->getPost('prd_ykel') == 'Y') {
      $prd_ykel = 'Y';
    } else {
      $prd_ykel = 'N';
    }
    $model = new Save_model();
    $data = array(
      'prd_code' => $this->request->getPost('prd_code'),
      'prd_name' => $this->request->getPost('prd_name'),
      'typ_code' => $this->request->getPost('typ_code'),
      'typ_marg' => $this->request->getPost('typ_marg'),
      'acc_code' => $this->request->getPost('acc_code'),
      'acc_cod1' => $this->request->getPost('acc_cod1'),
      'acc_cod2' => $this->request->getPost('acc_cod2'),
      'prd_jens' => $this->request->getPost('prd_jens'),
      'prd_smin' => $prd_smin, //$this->request->getPost('prd_smin'),
      'prd_mstr' => $prd_mstr, //$this->request->getPost('prd_mstr'),
      'prd_marg' => $prd_marg, //$this->request->getPost('prd_marg'),
      'prd_bons' => $prd_bons, //$this->request->getPost('prd_bons'),
      'prd_sawl' => $prd_sawl, //$this->request->getPost('prd_sawl'),
      'prd_keli' => $prd_keli, //$this->request->getPost('prd_keli'),
      'prd_pilt' => $prd_pilt, //$this->request->getPost('prd_keli'),
      'prd_mjas' => $prd_mjas, //$this->request->getPost('prd_keli'),
      'prd_attp' => $prd_attp, //$this->request->getPost('prd_keli'),
      'prd_admn' => $prd_admn, //$this->request->getPost('prd_keli'),
      'prd_spas' => $prd_spas, //$this->request->getPost('prd_keli'),
      'prd_ykel' => $prd_ykel,
      'prd_jbon' => $jenisbonus,
      //'typ_angs' => $typ_angs,
      'prd_stat' => 'Y',
    );

    $model->_saveproduct($data);


    $id = 1;
    $kode = $_POST['jnk_code'];
    if ($kode != '') {
      $jumlah = count($kode);
    } else {
      $jumlah = 0;
    }


    for ($x = 0; $x < $jumlah; $x++) {
      $kode = $this->request->getPost('jnk_code[' . $x . ']');
      if ($kode != '') {

        $data = array(
          'prd_code' => $this->request->getPost('prd_code'),
          'jnk_idno' => $this->request->getPost('jnk_code[' . $x . ']'),
          'mrg_totl' => $this->request->getPost('mrg_totl[' . $x . ']'),

        );
        $model->insertmargin($data);
      }
    }
    $jenis = $this->request->getPost('prd_jens');
    if ($jenis == 'T') {
      return redirect()->to('master/product')->with('success', 'Tambah Data Berhasil');
    } else if ($jenis == 'S') {
      return redirect()->to('master/product')->with('success', 'Tambah Data Berhasil');
    } else if ($jenis == 'D') {
      return redirect()->to('master/productssb')->with('success', 'Tambah Data Berhasil');
    } else if ($jenis == 'K') {
      return redirect()->to('master/productpinjaman')->with('success', 'Tambah Data Berhasil');
    }
  }
  public function updateproduct()
  {
    $id = $this->request->getPost('prd_code');
    $model = new Save_model();
    $model1 = new Delete_model();

    $prd_smin = str_replace(',', '', $this->request->getPost('prd_smin'));
    $prd_mstr = str_replace(',', '', $this->request->getPost('prd_mstr'));
    $prd_marg = str_replace(',', '', $this->request->getPost('prd_marg'));
    $prd_bons = str_replace(',', '', $this->request->getPost('prd_bons'));
    $prd_sawl = str_replace(',', '', $this->request->getPost('prd_sawl'));
    $prd_keli = str_replace(',', '', $this->request->getPost('prd_keli'));
    $prd_pilt = str_replace(',', '', $this->request->getPost('prd_pilt'));
    $prd_mjas = str_replace(',', '', $this->request->getPost('prd_mjas'));
    $prd_attp = str_replace(',', '', $this->request->getPost('prd_attp'));
    $prd_admn = str_replace(',', '', $this->request->getPost('prd_admn'));
    $prd_spas = str_replace(',', '', $this->request->getPost('prd_spas'));
    $jenisbonus = trim($this->request->getPost('prd_jbon'));
    $typ_angs = trim($this->request->getPost('typ_angs'));
    if ($this->request->getPost('prd_ykel') == 'Y') {
      $prd_ykel = 'Y';
    } else {
      $prd_ykel = 'N';
    }
    $data = array(
      'prd_code'       => $this->request->getPost('prd_code'),
      'prd_name'       => $this->request->getPost('prd_name'),
      'typ_code'       => $this->request->getPost('typ_code'),
      'typ_marg'       => $this->request->getPost('typ_marg'),
      'acc_code'       => $this->request->getPost('acc_code'),
      'acc_cod1'       => $this->request->getPost('acc_cod1'),
      'acc_cod2' => $this->request->getPost('acc_cod2'),
      'prd_jens'       => $this->request->getPost('prd_jens'),
      'prd_smin' => $prd_smin, //$this->request->getPost('prd_smin'),
      'prd_mstr' => $prd_mstr, //$this->request->getPost('prd_mstr'),
      'prd_marg' => $prd_marg, //$this->request->getPost('prd_marg'),
      'prd_bons' => $prd_bons, //$this->request->getPost('prd_bons'),
      'prd_sawl' => $prd_sawl, //$this->request->getPost('prd_sawl'),
      'prd_keli' => $prd_keli, //$this->request->getPost('prd_keli'),
      'prd_pilt' => $prd_pilt, //$this->request->getPost('prd_keli'),
      'prd_mjas' => $prd_mjas, //$this->request->getPost('prd_keli'),
      'prd_attp' => $prd_attp, //$this->request->getPost('prd_keli'),
      'prd_admn' => $prd_admn, //$this->request->getPost('prd_keli'),
      'prd_spas' => $prd_spas, //$this->request->getPost('prd_keli'),
      'prd_ykel' => $prd_ykel,
      'prd_jbon' => $jenisbonus,
      // 'typ_angs' => $typ_angs,
      'prd_stat'  => $this->request->getPost('prd_stat'),
    );
    $model->_updateproduct($data, $id);

    $model1->m_deleteproductmargin($id);
    $id = 1;
    $kode = $_POST['jnk_code'];
    if ($kode != '') {
      $jumlah = count($kode);
    } else {
      $jumlah = 0;
    }



    for ($x = 0; $x < $jumlah; $x++) {
      $kode = $this->request->getPost('jnk_code[' . $x . ']');
      $mrg_totl = str_replace(',', '', $this->request->getPost('mrg_totl[' . $x . ']'));
      if ($kode != '') {

        $data = array(
          'prd_code' => $this->request->getPost('prd_code'),
          'jnk_idno' => $this->request->getPost('jnk_code[' . $x . ']'),
          'mrg_totl' => $mrg_totl,

        );
        $model->insertmargin($data);
      }
    }

    $jenis = $this->request->getPost('prd_jens');
    if ($jenis == 'T') {
      return redirect()->to('master/product')->with('success', 'Update Data Berhasil');
    } else if ($jenis == 'S') {
      return redirect()->to('master/product')->with('success', 'Update Data Berhasil');
    } else if ($jenis == 'D') {
      return redirect()->to('master/productssb')->with('success', 'Update Data Berhasil');
    } else if ($jenis == 'K') {
      return redirect()->to('master/productpinjaman')->with('success', 'Update Data Berhasil');
    }
  }
  public function deleteproduct($id)
  {
    $model = new Delete_model();
    // $id = $this->request->getPost('code');
    $id1 = substr($id, -1);

    $id2 = substr($id, 0, strlen($id) - 1);

    $model->m_deleteproduct($id2);
    $model->m_deleteproductmargin($id2);
    if ($id1 == 'T') {
      return redirect()->to('master/product')->with('success', 'Hapus Data Berhasil');
    } else if ($id1 == 'D') {
      return redirect()->to('master/productssb')->with('success', 'Hapus Data Berhasil');
    } else if ($id1 == 'K') {
      return redirect()->to('master/productpinjaman')->with('success', 'Hapus Data Berhasil');
    } else if ($id1 == 'S') {
      return redirect()->to('master/product')->with('success', 'Hapus Data Berhasil');
    }
  }

  public function grade()
  {
    $model = new Master_model();
    $data['v_grade']  = $model->_get_grade()->getResult();
    return view('master/grade/grade_list', $data);
  }

  public function addgrade()
  {

    return view('master/grade/grade_add');
  }

  public function editgrade($id)
  {
    $model = new Master_model();
    $data['v_grade']  = $model->_get_edit_grade($id)->getResult();
    return view('master/grade/grade_edit', $data);
  }
  public function savegrade()
  {
    $model = new Save_model();

    $data = array(
      'grd_code'       => $this->request->getPost('grd_code'),
      'grd_name'       => $this->request->getPost('grd_name'),
      'grd_smpk'       => $this->request->getPost('grd_smpk'),
      'grd_smwa'       => $this->request->getPost('grd_smwa'),
      'grd_skrl'       => $this->request->getPost('grd_skrl'),
      'grd_plat'       => $this->request->getPost('grd_plat'),
      'grd_bshu'       => $this->request->getPost('grd_bshu'),
      'grd_stat' => 'Y',
    );

    $model->_savegrade($data);
    return redirect()->to('master/grade')->with('success', 'Tambah Data Berhasil');
  }

  public function updategrade()
  {
    $model = new Save_model();
    $id = $this->request->getPost('grd_code');
    $data = array(

      'grd_name'       => $this->request->getPost('grd_name'),
      'grd_smpk'       => $this->request->getPost('grd_smpk'),
      'grd_smwa'       => $this->request->getPost('grd_smwa'),
      'grd_skrl'       => $this->request->getPost('grd_skrl'),
      'grd_plat'       => $this->request->getPost('grd_plat'),
      'grd_bshu'       => $this->request->getPost('grd_bshu'),
      'grd_stat'       => $this->request->getPost('grd_stat'),
    );

    $model->_updategrade($data, $id);
    return redirect()->to('master/grade')->with('success', 'Merubah Data Berhasil');
  }

  public function deletegrade($id)
  {

    $model = new Delete_model();
    // $id = $this->request->getPost('code');
    $model->m_deletegrade($id);

    return redirect()->to('master/grade')->with('success', 'Menghapus Data Berhasil');
  }
  public function departemen()
  {
    $model = new Master_model();
    $data['v_departemen']  = $model->_get_departemen()->getResult();
    return view('master/departemen/departemen_list', $data);
  }

  public function adddepartemen()
  {

    return view('master/departemen/departemen_add');
  }

  public function editdepartemen($id)
  {
    $model = new Master_model();
    $data['v_departemen']  = $model->_get_editdepartemen($id)->getResult();
    return view('master/departemen/departemen_edit', $data);
  }


  public function psb()
  {
    $model = new Master_model();
    $data['v_psb']  = $model->_get_psb()->getResult();
    return view('master/psb/psb_list', $data);
  }

  public function psbadd()
  {

    return view('master/psb/psb_add');
  }

  public function psbedit($id)
  {
    $model = new Master_model();
    $data['v_psb']  = $model->_get_edpsb($id)->getResult();
    return view('master/psb/psb_edit', $data);
  }

  public function psbsave()
  {
    $model = new save_model();
    $data = array(
      'psb_code'       => $this->request->getPost('psb_code'),
      'id'             => $this->request->getPost('psb_code'),
      'psb_name'       => $this->request->getPost('psb_name'),
      'psb_stat' => 'Y',
    );
    $model->m_savepsb($data);
    return redirect()->to('master/psb')->with('success', 'Tambah Data Berhasil');
  }
  public function psbupdate()
  {
    $model = new save_model();
    $id = $this->request->getPost('psb_code');
    $data = array(

      'psb_name'       => $this->request->getPost('psb_name'),
      'psb_stat' => $this->request->getPost('psb_stat'),
    );
    $model->m_updatepsb($data, $id);
    return redirect()->to('master/psb')->with('success', 'Merubah Data Berhasil');
  }
  public function deletepsb($id)
  {
    $model = new Delete_model();
    // $id = $this->request->getPost('code');
    $model->m_deletepsb($id);
    return redirect()->to('master/psb')->with('success', 'Tambah Data Berhasil');
  }


  public function smd()
  {
    $model = new Master_model();
    $_SESSION['com_menu'] = '04';
    $_SESSION['com_men1'] = '0403';
    $_SESSION['com_men2'] = '040303';
    $data['v_sumber']  = $model->_get_smd()->getResult();
    return view('master/sumber/smd_list', $data);
  }

  public function addsumber()
  {
    $_SESSION['com_menu'] = '04';
    $_SESSION['com_men1'] = '0401';
    $_SESSION['com_men2'] = '040103';
    return view('master/sumber/smd_add');
  }

  public function editsumber($id)
  {
    $model = new Master_model();
    $_SESSION['com_menu'] = '04';
    $_SESSION['com_men1'] = '0401';
    $_SESSION['com_men2'] = '040103';
    $data['v_sumber']  = $model->_get_editsmd($id)->getResult();
    return view('master/sumber/smd_edit', $data);
  }

  public function savesumber()
  {
    $model = new Save_model();
    $data = array(
      'smd_code'        => $this->request->getPost('smd_code'),
      'smd_name'       => $this->request->getPost('smd_name'),
      'smd_stat' => 'Y',
    );

    $model->_savesumber($data);


    return redirect()->to('master/smd')->with('success', 'Tambah Data Berhasil');
  }

  public function updatesumber()
  {
    $model = new Save_model();
    $id = $this->request->getPost('smd_code');
    $data = array(

      'smd_name'       => $this->request->getPost('smd_name'),
      'smd_stat'       => $this->request->getPost('smd_stat'),
    );

    $model->_updatesumber($data, $id);


    return redirect()->to('master/smd')->with('success', 'Merubah Data Berhasil');
  }

  public function deletesumber($id)
  {
    $model = new Delete_model();
    // $id = $this->request->getPost('code');
    $model->m_deletesumber($id);


    return redirect()->to('master/smd')->with('success', 'Menghapus Data Berhasil');
  }
  public function anggota()
  {
    $model = new Master_model();
    $_SESSION['com_menu'] = '02';
    $_SESSION['com_men1'] = '';
    //$data['v_anggota']  = $model->_get_anggota()->getResult();
    return view('anggota/anggota_list');
  }
  
  public function gridAnggota() {
	$model = new Master_model();
	$draw = $this->request->getVar('draw');
	$start = $this->request->getVar('start');
	$length = $this->request->getVar('length');
	$search = $this->request->getVar('search[value]');
	$data = $model->_get_anggota($start,$length,$search);
	//{"draw":4,"recordsTotal":57,"recordsFiltered":57,"data":[{"first_name":"Airi","last_name":"Satou","position":"Accountant","office":"Tokyo","start_date":"28th Nov 08","salary":"$162,700"},{"first_name":"Angelica","last_name":"Ramos","position":"Chief Executive Officer (CEO)","office":"London","start_date":"9th Oct 09","salary":"$1,200,000"},{"first_name":"Ashton","last_name":"Cox","position":"Junior Technical Author","office":"San Francisco","start_date":"12th Jan 09","salary":"$86,000"},{"first_name":"Bradley","last_name":"Greer","position":"Software Engineer","office":"London","start_date":"13th Oct 12","salary":"$132,000"},{"first_name":"Brenden","last_name":"Wagner","position":"Software Engineer","office":"San Francisco","start_date":"7th Jun 11","salary":"$206,850"},{"first_name":"Brielle","last_name":"Williamson","position":"Integration Specialist","office":"New York","start_date":"2nd Dec 12","salary":"$372,000"},{"first_name":"Bruno","last_name":"Nash","position":"Software Engineer","office":"London","start_date":"3rd May 11","salary":"$163,500"},{"first_name":"Caesar","last_name":"Vance","position":"Pre-Sales Support","office":"New York","start_date":"12th Dec 11","salary":"$106,450"},{"first_name":"Cara","last_name":"Stevens","position":"Sales Assistant","office":"New York","start_date":"6th Dec 11","salary":"$145,600"},{"first_name":"Cedric","last_name":"Kelly","position":"Senior Javascript Developer","office":"Edinburgh","start_date":"29th Mar 12","salary":"$433,060"}]}
	$resp = array('draw'=>$draw,'recordsTotal'=>$data['recordsTotal'],
					'recordsFiltered'=>$data['recordsFiltered'],'data'=>$data['data']);
	echo json_encode($resp);
  }

  public function anggotaadd()
  {
    $model = new Master_model();
    $data['v_dept']  = $model->_get_departemen()->getResult();
    $data['v_grade']  = $model->_get_grade()->getResult();
    return view('anggota/anggota_add', $data);
  }


  public function eanggota($id)
  {
    $model = new Master_model();

    $data['v_dept']  = $model->_get_departemen()->getResult();
    $data['v_grade']  = $model->_get_grade()->getResult();
    $data['v_anggota']  = $model->_get_eanggota($id)->getResult();
    return view('anggota/anggota_edit', $data);
  }

  public function closeanggota($id)
  {
    $model = new Master_model();
    $data['v_anggota']  = $model->_get_eanggota($id)->getResult();
    $data['v_simpanan']  = $model->_get_simpanggota($id)->getResult();
    return view('anggota/anggota_close', $data);
  }

  public function saveanggota()
  {
    $model = new Save_model();
    $tanggal = $this->request->getPost('agt_jdat');
    $days1 = date('d', strtotime($tanggal));
    $tgllahir = $this->request->getPost('agt_dlhr');
    $bulan = date('m', strtotime($tgllahir));
    $tahun = date('y', strtotime($tgllahir));
    $days = date('d', strtotime($tgllahir));
    $kodecabang = session()->get('kode_cabang');
    $noktp = substr(trim($this->request->getPost('agt_nktp')), -3);
    $sexcode = $this->request->getPost('sex_code');
    $grade = $this->request->getPost('grd_code');
    $v_trx_code = $kodecabang . '.' . $tahun . '.' . $bulan . '.' . $days . '.' . $noktp . '.' . $sexcode . '.' . $grade;
 $v_trx_cod2 = $kodecabang . $tahun  . $bulan . $days . $noktp . $sexcode . $grade;

    $data = array(
      'id'        => $v_trx_cod2, //$this->request->getPost('agt_numb'),
      'agt_numb'        => $v_trx_code, //$this->request->getPost('agt_numb'),
      'agt_name'       => $this->request->getPost('agt_name'),
      'agt_tlhr'       => $this->request->getPost('agt_tlhr'),
      'agt_dlhr'       => $this->request->getPost('agt_dlhr'),
      'agt_adrs'       => $this->request->getPost('agt_adrs'),
      'sex_code'       => $this->request->getPost('sex_code'),
      'agt_phon'       => $this->request->getPost('agt_phon'),
      'agt_mail'       => $this->request->getPost('agt_mail'),
      // 'dep_code'       => $this->request->getPost('dep_code'),
      'dep_name'       => $this->request->getPost('dep_name'),
      'grd_code'       => $this->request->getPost('grd_code'),
      'emp_code'       => $this->request->getPost('emp_code'),
      'agt_bpjs'       => $this->request->getPost('agt_bpjs'),
      'agt_nktp'       => $this->request->getPost('agt_nktp'),
      'agt_nokk'       => $this->request->getPost('agt_nokk'),
      'agt_npwp'       => $this->request->getPost('agt_npwp'),
      'bnk_rekg'       => $this->request->getPost('bnk_rekg'),
      'agt_nban'       => $this->request->getPost('agt_nban'),
      'agt_nrek'       => $this->request->getPost('agt_nrek'),
      'bnk_cabg'       => $this->request->getPost('bnk_cabg'),
      'agt_jdat'       => $this->request->getPost('agt_jdat'),
      'kode_cabang'       => session()->get('kode_cabang'),
      'agt_aday'       => $days1,
      'agt_stat' => 'Y',
    );

    $model->_saveanggota($data);


    return redirect()->to('master/anggota')->with('success', 'Tambah Data Berhasil');
  }

  public function updateanggota()
  {
    $model = new Save_model();
    $id = $this->request->getPost('agt_numb');
    $data = array(


      'agt_name'       => $this->request->getPost('agt_name'),
      'agt_tlhr'       => $this->request->getPost('agt_tlhr'),
      'agt_dlhr'       => $this->request->getPost('agt_dlhr'),
      'agt_adrs'       => $this->request->getPost('agt_adrs'),
      'sex_code'       => $this->request->getPost('sex_code'),
      'agt_phon'       => $this->request->getPost('agt_phon'),
      'agt_mail'       => $this->request->getPost('agt_mail'),
      // 'dep_code'       => $this->request->getPost('dep_code'),
      'dep_name'       => $this->request->getPost('dep_name'),
      'grd_code'       => $this->request->getPost('grd_code'),
      'emp_code'       => $this->request->getPost('emp_code'),
      'agt_bpjs'       => $this->request->getPost('agt_bpjs'),
      'agt_nktp'       => $this->request->getPost('agt_nktp'),
      'agt_nokk'       => $this->request->getPost('agt_nokk'),
      'agt_npwp'       => $this->request->getPost('agt_npwp'),
      'bnk_rekg'       => $this->request->getPost('bnk_rekg'),
      'agt_nban'       => $this->request->getPost('agt_nban'),
      'agt_nrek'       => $this->request->getPost('agt_nrek'),
      'bnk_cabg'       => $this->request->getPost('bnk_cabg'),
      'agt_jdat'       => $this->request->getPost('agt_jdat'),

      'agt_stat' =>  $this->request->getPost('agt_stat'),
    );

    $model->_updateanggota($data, $id);


    return redirect()->to('master/anggota')->with('success', 'Merubah Data Berhasil');
  }

  public function upclose()
  {
    $model = new Save_model();
    $modecek = new Auto_model();
    $id = $this->request->getPost('agt_numb');
    $status = $this->request->getPost('agt_clos');

    // $cek = $modecek->get_closeanggota($id);



    $tanggal = $this->request->getPost('cls_date');
    $bulan = date('m', strtotime($tanggal));
    $tahun = date('Y', strtotime($tanggal));
    $cek = $modecek->get_notutupanggota($bulan, $tahun);
    if ($bulan < 10) {
      $bulan1 = '0' . $bulan;
    } else {
      $bulan1 = $bulan;
    }

    $nourut = $cek['cls_srno'];
    if ($nourut == '') {
      $nourut = 1;
      $v_trx_code = '08.' . $tahun . $bulan . '00001';
    } else {
      $nourut = $nourut + 1;
      if ($nourut < 10) {
        $v_trx_code = '08.' . $tahun . $bulan . '0000' . $nourut;
      } else if ($nourut >= 10 and $nourut < 100) {
        $v_trx_code = '08.' . $tahun . $bulan . '000' . $nourut;
      } else if ($nourut >= 100 and $nourut < 1000) {
        $v_trx_code = '08.' . $tahun . $bulan . '00' . $nourut;
      } else if ($nourut >= 1000 and $nourut < 10000) {
        $v_trx_code = '08.' . $tahun . $bulan . '0' . $nourut;
      } else {
        $v_trx_code = '08.' . $tahun . $bulan . $nourut;
      }
    }


    $data = array(

      // 'cls_code'        => $this->request->getPost('cls_code'),
      'cls_date'        => $this->request->getPost('cls_date'),
      'agt_numb'        => $this->request->getPost('agt_numb'),
      'cls_spok'        => $this->request->getPost('cls_spok'),
      'cls_swaj'        => $this->request->getPost('cls_swaj'),
      'cls_suka'        => $this->request->getPost('cls_suka'),
      'cls_sssb'        => $this->request->getPost('cls_sssb'),
      'cls_stab'        => $this->request->getPost('cls_stab'),
      'cls_tsim'        => $this->request->getPost('cls_tsim'),
      'cls_tpjm'        => $this->request->getPost('cls_tpjm'),
      'cls_stot'        => $this->request->getPost('cls_stot'),
      'cls_code'        => $v_trx_code,
      'cls_srno'        => $nourut,
      'cls_mont'        => $bulan,
      'cls_year'        => $tahun,
      'com_code'        => 1,
      'cls_stat'        => 0,
    );


    $model->_closeanggota($data);


    $data = array(
      'agt_cdat' =>  $this->request->getPost('cls_date'),
      'agt_stat' =>  5,

    );

    $model->_updateanggota($data, $id);


    return redirect()->to('master/anggota')->with('success', 'Penutupan Anggota Berhasil');
  }



  public function deleteanggota($id)
  {
    $model = new Delete_model();
    // $id = $this->request->getPost('code');
    $model->m_deleteanggota($id);


    return redirect()->to('master/anggota')->with('success', 'Menghapus Data Berhasil');
  }
  public function savedepartemen()
  {
    $model = new Save_model();
    $data = array(
      'dep_code'        => $this->request->getPost('dep_code'),
      'dep_name'       => $this->request->getPost('dep_name'),
      'dep_stat' => 'Y',
    );

    $model->_savedepartemen($data);


    return redirect()->to('master/departemen')->with('success', 'Tambah Data Berhasil');
  }

  public function updatedepartemen()
  {
    $model = new Save_model();
    $id = $this->request->getPost('dep_code');
    $data = array(

      'dep_name'       => $this->request->getPost('dep_name'),
      'dep_stat'       => $this->request->getPost('dep_stat'),
    );

    $model->_updatedepartemen($data, $id);


    return redirect()->to('master/departemen')->with('success', 'Merubah Data Berhasil');
  }

  public function deletedepartemen($id)
  {
    $model = new Delete_model();
    // $id = $this->request->getPost('code');
    $model->m_deletedepartemen($id);


    return redirect()->to('master/departemen')->with('success', 'Menghapus Data Berhasil');
  }


  public function producttype()
  {
    $model = new Master_model();
    $data['v_producttype']  = $model->_get_producttype()->getResult();
    return view('master/typeproduct/typeproduct_list', $data);
  }
  public function prodcuttypeadd()
  {
    return view('master/typeproduct/typeproduct_add');
  }

  public function prodcuttypeedit($id)
  {
    $model = new Master_model();
    $data['v_typeproduct']  = $model->_get_editproducttype($id)->getResult();
    return view('master/typeproduct/typeproduct_edit', $data);
  }

  public function savetypeproduct()
  {
    $model = new Save_model();
    $data = array(
      'typ_code'        => $this->request->getPost('typ_code'),
      'typ_name'       => $this->request->getPost('typ_name'),
      'typ_stat' => 'Y',
    );

    $model->m_savetypeproduct($data);
    return redirect()->to('master/producttype')->with('success', 'Tambah Data Berhasil');
  }

  public function updatetypeproduct()
  {
    $model = new Save_model();
    $id = $this->request->getPost('typ_code');
    $data = array(
      'typ_code'        => $this->request->getPost('typ_code'),
      'typ_name'       => $this->request->getPost('typ_name'),
      'typ_stat' => 'Y',
    );

    $model->m_updatetypeproduct($data, $id);
    return redirect()->to('master/producttype')->with('success', 'Merubah Data Berhasil');
  }

  public function deleteprodcuttype($id)
  {
    $model = new Delete_model();
    // $id = $this->request->getPost('code');
    $model->m_deletetypeproduct($id);
    return redirect()->to('master/producttype')->with('success', 'Menghapus Data Berhasil');
  }

  public function infoanggota($id)
  {
    $model = new Master_model();
    $data['v_simpanan']  = $model->_get_simpanan($id)->getResult();
    $data['v_ssb']  = $model->_getssb($id)->getResult();
    $data['v_pinjaman']  = $model->_getpinjaman($id)->getResult();
    return view('anggota/info', $data);
  }

  public function negara()
  {
    $model = new Master_model();
    $_SESSION['com_menu'] = '02';
    $_SESSION['com_men1'] = '0203';
    $data['v_negara']  = $model->_getnegara()->getResult();
    return view('master/kodenegara/negara_list', $data);
  }

  public function addnegara()
  {
    $_SESSION['com_menu'] = '02';
    $_SESSION['com_men1'] = '0203';
    return view('master/kodenegara/negara_add');
  }
  public function editnegara($id)
  {
    $model = new Master_model();
    $_SESSION['com_menu'] = '02';
    $_SESSION['com_men1'] = '0203';
    $data['v_negara']  = $model->_edgetnegara($id)->getResult();
    return view('master/kodenegara/negara_edit', $data);
  }

  public function savenegara()
  {
    $model = new save_model();
    $data = array(
      'neg_code' => $this->request->getPost('neg_code'),
      'neg_name' => $this->request->getPost('neg_name'),
      'neg_stat' => 'Y',
    );
    $model->_savenegara($data);
    return redirect()->to('master/negara')->with('success', 'Simpan Data Berhasil');
  }

  public function updatenegara()
  {
    $model = new save_model();
    $id = $this->request->getPost('neg_code');
    $data = array(
      'neg_code' => $this->request->getPost('neg_code'),
      'neg_name' => $this->request->getPost('neg_name'),
      'neg_stat' => $this->request->getPost('neg_stat'),

    );
    $model->_updatenegara($data, $id);
    return redirect()->to('master/negara')->with('success', 'Hapus Data Berhasil');
  }


  public function deletenegara($id)
  {
    $model = new Delete_model();
    $model->_deletenegara($id);
    return redirect()->to('master/negara')->with('success', 'Hapus Data Berhasil');
  }

  //--------
  public function kota()
  {
    $model = new Master_model();
    $_SESSION['com_menu'] = '02';
    $_SESSION['com_men1'] = '0203';
    $data['v_kota']  = $model->_getkota()->getResult();
    return view('master/kota/kota_list', $data);
  }

  public function addkota()
  {
    $_SESSION['com_menu'] = '02';
    $_SESSION['com_men1'] = '0203';
    return view('master/kota/kota_add');
  }
  public function editkota($id)
  {
    $model = new Master_model();
    $_SESSION['com_menu'] = '02';
    $_SESSION['com_men1'] = '0203';
    $data['v_kota']  = $model->_edgetkota($id)->getResult();
    return view('master/kota/kota_edit', $data);
  }

  public function savekota()
  {
    $model = new save_model();
    $data = array(
      'kot_code' => $this->request->getPost('kot_code'),
      'kot_name' => $this->request->getPost('kot_name'),
      'kot_stat' => 'Y',
    );
    $model->_savekota($data);
    return redirect()->to('master/kota')->with('success', 'Simpan Data Berhasil');
  }

  public function updatekota()
  {
    $model = new save_model();
    $id = $this->request->getPost('kot_code');
    $data = array(
      'kot_code' => $this->request->getPost('kot_code'),
      'kot_name' => $this->request->getPost('kot_name'),
      'kot_stat' => $this->request->getPost('kot_stat'),
    );
    $model->_updatekota($data, $id);
    return redirect()->to('master/kota')->with('success', 'Update Data Berhasil');
  }


  public function deletekota($id)
  {
    $model = new Delete_model();
    $model->_deletekota($id);
    return redirect()->to('master/kota')->with('success', 'Menghapus Data Berhasil');
  }

  public function kodepos()
  {
    $model = new Master_model();
    $_SESSION['com_menu'] = '02';
    $_SESSION['com_men1'] = '0203';
    $data['v_kodepos']  = $model->_getkodepos()->getResult();
    return view('master/kodepos/kodepos_list', $data);
  }

  public function addkodepos()
  {
    $model = new Master_model();
    $_SESSION['com_menu'] = '02';
    $_SESSION['com_men1'] = '0203';
    $data['v_kota'] = $model->_getkota()->getResult();
    return view('master/kodepos/kodepos_add', $data);
  }
  public function editkodepos($id)
  {
    $model = new Master_model();
    $data['v_kota'] = $model->_getkota()->getResult();
    $data['v_kodepos']  = $model->_dtgetkodepos($id)->getResult();
    return view('master/kodepos/kodepos_edit', $data);
  }

  public function savekodepos()
  {
    $model = new save_model();
    $data = array(
      'kdp_code' => $this->request->getPost('kdp_code'),
      'kdp_kelu' => $this->request->getPost('kdp_kelu'),
      'kdp_keca' => $this->request->getPost('kdp_keca'),
      'kot_code' => $this->request->getPost('kot_code'),
      'kdp_stat' => 'Y',
    );
    $model->_savekodepos($data);
    return redirect()->to('master/kodepos')->with('success', 'Simpan Data Berhasil');
  }

  public function updatekodepos()
  {
    $model = new save_model();
    $id = $this->request->getPost('kdp_code');
    $data = array(
      'kdp_code' => $this->request->getPost('kdp_code'),
      'kdp_name' => $this->request->getPost('kdp_name'),
      'kdp_stat' => $this->request->getPost('kdp_stat'),
      'kot_code' => $this->request->getPost('kot_code'),
    );
    $model->_updatekodepos($data, $id);
    return redirect()->to('master/kodepos')->with('success', 'Update Data Berhasil');
  }


  public function deletekodepos($id)
  {
    $model = new Delete_model();
    $model->_deletekodepos($id);
    return redirect()->to('master/kodepos')->with('success', 'Menghapus Data Berhasil');
  }


  public function gelar()
  {
    $model = new Master_model();
    $_SESSION['com_menu'] = '02';
    $_SESSION['com_men1'] = '0203';
    $data['v_gelar']  = $model->_getgelar()->getResult();
    return view('master/gelar/gelar_list', $data);
  }

  public function addgelar()
  {
    $model = new Master_model();
    $_SESSION['com_menu'] = '02';
    $_SESSION['com_men1'] = '0203';
    return view('master/gelar/gelar_add');
  }
  public function editgelar($id)
  {
    $model = new Master_model();
    $_SESSION['com_menu'] = '02';
    $_SESSION['com_men1'] = '0203';
    $data['v_gelar']  = $model->_dtgetgelar($id)->getResult();
    return view('master/gelar/gelar_edit', $data);
  }

  public function savegelar()
  {
    $model = new save_model();
    $data = array(
      'jab_code' => $this->request->getPost('jab_code'),
      'jab_name' => $this->request->getPost('jab_name'),
      'jab_stat' => 'Y',
      'jab_cret' => date('Y-m-d'),
    );
    $model->_savegelar($data);
    return redirect()->to('master/gelar')->with('success', 'Simpan Data Berhasil');
  }

  public function updategelar()
  {
    $model = new save_model();
    $id = $this->request->getPost('jab_code');
    $data = array(
      'jab_code' => $this->request->getPost('jab_code'),
      'jab_name' => $this->request->getPost('jab_name'),
      'jab_stat' => $this->request->getPost('jab_stat'),
      'jab_updt' => date('Y-m-d'),
    );
    $model->_updategelar($data, $id);
    return redirect()->to('master/gelar')->with('success', 'Update Data Berhasil');
  }


  public function deletegelar($id)
  {
    $model = new Delete_model();
    $model->_deletegelar($id);
    return redirect()->to('master/gelar')->with('success', 'Menghapus Data Berhasil');
  }


  public function cabang()
  {
    $model = new Master_model();
    $data['v_cabang']  = $model->_getcabang()->getResult();
    return view('master/cabang/cabang_list', $data);
  }

  public function addcabang()
  {
    $model = new Master_model();
    return view('master/cabang/cabang_add');
  }
  public function editcabang($id)
  {
    $model = new Master_model();
    $data['v_cabang']  = $model->_dtgetcabang($id)->getResult();
    return view('master/cabang/cabang_edit', $data);
  }

  public function savecabang()
  {
    $model = new save_model();
    $data = array(
      'cab_code' => $this->request->getPost('cab_code'),
      'cab_name' => $this->request->getPost('cab_name'),
      'cab_stat' => 'Y',
      'cab_cret' => date('Y-m-d'),
    );
    $model->_savecabang($data);
    return redirect()->to('master/cabang')->with('success', 'Simpan Data Berhasil');
  }

  public function updatecabang()
  {
    $model = new save_model();
    $id = $this->request->getPost('cab_code');
    $data = array(
      'cab_code' => $this->request->getPost('cab_code'),
      'cab_name' => $this->request->getPost('cab_name'),
      'cab_stat' => $this->request->getPost('cab_stat'),
      'cab_updt' => date('Y-m-d'),
    );
    $model->_updatecabang($data, $id);
    return redirect()->to('master/cabang')->with('success', 'Update Data Berhasil');
  }


  public function deletecabang($id)
  {
    $model = new Delete_model();
    $model->_deletecabang($id);
    return redirect()->to('master/cabang')->with('success', 'Menghapus Data Berhasil');
  }

  public function akun()
  {
    $model = new Master_model();
    $data['v_akun']  = $model->_getakun()->getResult();
    return view('managemen/akun/akun_list', $data);
  }

  public function addakun()
  {
    $model = new Master_model();
    return view('managemen/akun/akun_add');
  }
  public function editakun($id)
  {
    $model = new Master_model();
    $data['v_akun']  = $model->_dtgetakun($id)->getResult();
    return view('managemen/akun/akun_edit', $data);
  }

  public function saveakun()
  {
    $model = new save_model();
    $data = array(
      'akn_code' => $this->request->getPost('akn_code'),
      'akn_name' => $this->request->getPost('akn_name'),
      'akn_bcod' => $this->request->getPost('akn_bcod'),
      'akn_stat' => 'Y',
      'akn_cret' => date('Y-m-d'),
    );
    $model->_saveakun($data);
    return redirect()->to('master/akun')->with('success', 'Simpan Data Berhasil');
  }

  public function updateakun()
  {
    $model = new save_model();
    $id = $this->request->getPost('jab_code');
    $data = array(
      'akn_code' => $this->request->getPost('akn_code'),
      'akn_name' => $this->request->getPost('akn_name'),
      'akn_bcod' => $this->request->getPost('akn_bcod'),
      'akn_updt' => date('Y-m-d'),
    );
    $model->_updateakun($data, $id);
    return redirect()->to('master/akun')->with('success', 'Update Data Berhasil');
  }


  public function deleteakun($id)
  {
    $model = new Delete_model();
    $model->_deleteakun($id);
    return redirect()->to('master/akun')->with('success', 'Menghapus Data Berhasil');
  }

  public function dnominasi()
  {
    $model = new Master_model();
    $_SESSION['com_menu'] = '03';
    $_SESSION['com_men1'] = '0301';
    $_SESSION['com_men2'] = '030103';

    $data['dnominasi']  = $model->_dnominasi()->getResult();
    return view('master/dnominasi/dnominasi_list', $data);
  }

  public function adddnominasi()
  {
    $_SESSION['com_menu'] = '03';
    $_SESSION['com_men1'] = '0301';
    $_SESSION['com_men2'] = '030103';
    return view('master/dnominasi/dnominasi_add');
  }

  public function editdnominasi($id)
  {
    $model = new Master_model();
    $_SESSION['com_menu'] = '03';
    $_SESSION['com_men1'] = '0301';
    $_SESSION['com_men2'] = '030103';
    $data['dnominasi']  = $model->_ednominasi($id)->getResult();
    return view('master/dnominasi/dnominasi_edit', $data);
  }

  public function savednominasi()
  {
    $model = new Save_model();
    $data = array(
      'kode_dnominasi' => $this->request->getPost('nom_code'),
      'jenis_dnominasi' => $this->request->getPost('nom_name'),
      'nilai_dnominasi' => $this->request->getPost('nom_nila'),
    );
    $model->_savednominasi($data);
    return redirect()->to('master/dnominasi')->with('success', 'Tambah Data Berhasil');
  }

  public function updatednominasi()
  {
    $model = new Save_model();
    $id = $this->request->getPost('nom_code');
    $data = array(
      // 'kode_dnominasi' => $this->request->getPost('nom_code'),
      'jenis_dnominasi' => $this->request->getPost('nom_name'),
      'nilai_dnominasi' => $this->request->getPost('nom_nila'),
    );
    $model->_updatednominasi($data, $id);
    return redirect()->to('master/dnominasi')->with('success', 'Merubah Data Berhasil');
  }

  public function deletednominasi($id)
  {
    $model = new Delete_model();

    $model->_deletednominasi($id);
    return redirect()->to('master/dnominasi')->with('success', 'Menghapus Data Berhasil');
  }


  public function transaksi()
  {
    $model = new Master_model();
    $_SESSION['com_menu'] = '03';
    $_SESSION['com_men1'] = '0301';
    $_SESSION['com_men2'] = '030103';;
    $data['v_transaksi']  = $model->_transaksi()->getResult();
    return view('master/kodetransaksi/kdtransaksi_list', $data);
  }

  public function addtransaksi()

  {
    $model = new Master_model();
    $_SESSION['com_menu'] = '03';
    $_SESSION['com_men1'] = '0301';
    $_SESSION['com_men2'] = '030103';
    $data['v_account']  = $model->_get_account()->getResult();
    return view('master/kodetransaksi/kdtransaksi_add', $data);
  }

  public function edittransaksi($id)
  {
    $model = new Master_model();
    $_SESSION['com_menu'] = '03';
    $_SESSION['com_men1'] = '0301';
    $_SESSION['com_men2'] = '030103';
    $data['v_account']  = $model->_get_account()->getResult();
    $data['v_transaksi']  = $model->_edtransaksi($id)->getResult();
    return view('master/kodetransaksi/kdtransaksi_edit', $data);
  }

  public function savetransaksi()
  {
    $model = new Save_model();
    $data = array(
      'kode_trans' => $this->request->getPost('kjt_code'),
      'deskripsi_trans' => $this->request->getPost('kjt_name'),
      'kode_perk' => $this->request->getPost('acc_code'),
    );
    $model->_savetransaksi($data);
    return redirect()->to('master/transaksi')->with('success', 'Tambah Data Berhasil');
  }

  public function updatetransaksi()
  {
    $model = new Save_model();
    $id = $this->request->getPost('kjt_code');
    $data = array(

      'deskripsi_trans' => $this->request->getPost('kjt_name'),
      'kode_perk' => $this->request->getPost('acc_code'),
    );
    $model->_updatetransaksi($data, $id);
    return redirect()->to('master/transaksi')->with('success', 'Update Data Berhasil');
  }

  public function deletetransaksi($id)
  {
    $model = new Delete_model();
    $model->_deletetransaksi($id);
    return redirect()->to('master/transaksi')->with('success', 'Hapus Data Berhasil');
  }

  public function smdtabungan()
  {
    $model = new Master_model();
    $data['v_transaksi']  = $model->_sdtabungan()->getResult();
    return view('master/sdtabungan/sdtabungan_list', $data);
  }

  public function addsmdtabungan()
  {
    $model = new Master_model();
    $data['v_account']  = $model->_get_account()->getResult();
    return view('master/sdtabungan/sdtabungan_add', $data);
  }

  public function editsmdtabungan($id)
  {
    $model = new Master_model();
    $data['v_account']  = $model->_get_account()->getResult();
    $data['v_transaksi']  = $model->_editsdtabungan($id)->getResult();
    return view('master/sdtabungan/sdtabungan_edit', $data);
  }

  public function savesmdtabungan($id)
  {
    $model = new Save_model();
    $hariini = date('Y-m-d H:i:s');
    $data = array(
      'deskripsi_sumber_dana_tab' => $this->request->getPost('kjt_name'),
      'sdt_stat' => 'Y',
      'tgl_create' => $hariini,
    );
    $model->_savesdtabungan($data);
    return redirect()->to('master/smdtabungan')->with('success', 'Tambah Data Berhasil');
  }
  public function updatesmdtabungan($id)
  {
    $model = new Save_model();
    $id = $this->request->getPost('kjt_code');
    $hariini = date('Y-m-d H:i:s');
    $data = array(
      'deskripsi_sumber_dana_tab' => $this->request->getPost('kjt_name'),
      'sdt_stat' =>  $this->request->getPost('sdt_stat'),
      'tgl_update' => $hariini,
    );
    $model->_updatesdtabungan($data, $id);
    return redirect()->to('master/smdtabungan')->with('success', 'Update Data Berhasil');
  }
  public function deletesmdtabungan($id)
  {
    $model = new Delete_model();
    $model->_deletesdtabungan($id);
    return redirect()->to('master/smdtabungan')->with('success', 'Hapus Data Berhasil');
  }

  public function tujuantabungan()
  {
    $model = new Master_model();
    $_SESSION['com_menu'] = '04';
    $_SESSION['com_men1'] = '0401';
    $_SESSION['com_men2'] = '040103';
    $data['v_transaksi']  = $model->_tjtabungan()->getResult();
    return view('master/tjtabungan/tjtabungan_list', $data);
  }
  public function addtjtabungan()
  {
    $model = new Master_model();
    $_SESSION['com_menu'] = '04';
    $_SESSION['com_men1'] = '0401';
    $_SESSION['com_men2'] = '040103';
    $data['v_account']  = $model->_get_account()->getResult();
    return view('master/tjtabungan/tjtabungan_add', $data);
  }

  public function edittjtabungan($id)
  {
    $model = new Master_model();
    $_SESSION['com_menu'] = '04';
    $_SESSION['com_men1'] = '0401';
    $_SESSION['com_men2'] = '040103';
    $data['v_account']  = $model->_get_account()->getResult();
    $data['v_transaksi']  = $model->_edittjtabungan($id)->getResult();
    return view('master/tjtabungan/tjtabungan_edit', $data);
  }

  public function savetujuantabungan()
  {
    $model = new Save_model();
    $hariini = date('Y-m-d H:i:s');
    $data = array(
      'deskripsi_tujuan_pembukaan_tab' => $this->request->getPost('kjt_name'),
      'tjt_stat' => 'Y',
      'tgl_create' => $hariini,
    );
    $model->_savetjtabungan($data);
    return redirect()->to('master/tujuantabungan')->with('success', 'Tambah Data Berhasil');
  }

  public function updatetujuantabungan()
  {
    $model = new Save_model();
    $id = $this->request->getPost('kjt_code');
    $hariini = date('Y-m-d H:i:s');
    $data = array(
      'deskripsi_tujuan_pembukaan_tab' => $this->request->getPost('kjt_name'),
      'tjt_stat' =>  $this->request->getPost('sdt_stat'),
      'tgl_update' => $hariini,
    );
    $model->_updatetjtabungan($data, $id);
    return redirect()->to('master/tujuantabungan')->with('success', 'Update Data Berhasil');
  }

  public function deletetujuantabungan($id)
  {
    $model = new Delete_model();
    $model->_deletetjtabungan($id);
    return redirect()->to('master/tujuantabungan')->with('success', 'Hapus Data Berhasil');
  }

  public function ekonomi()
  {
    $model = new Master_model();
    $_SESSION['com_menu'] = '04';
    $_SESSION['com_men1'] = '0403';
    $_SESSION['com_men2'] = '040303';
    $data['v_negara']  = $model->_ekonomi()->getResult();
    return view('master/ekonomi/ekonomi_list', $data);
  }
  public function addekonomi()
  {
    $model = new Master_model();
    $_SESSION['com_menu'] = '04';
    $_SESSION['com_men1'] = '0403';
    $_SESSION['com_men2'] = '040303';
    return view('master/ekonomi/ekonomi_add');
  }

  public function editekonomi($id)
  {
    $model = new Master_model();
    $_SESSION['com_menu'] = '04';
    $_SESSION['com_men1'] = '0403';
    $_SESSION['com_men2'] = '040303';
    $data['v_data']  = $model->_edekonomi($id)->getResult();
    return view('master/ekonomi/ekonomi_edit', $data);
  }

  public function saveekonomi()
  {
    $model = new Save_model();
    $hariini = date('Y-m-d H:i:s');
    $data = array(
      'kode_sektor_ekonomi' => $this->request->getPost('kjt_code'),
      'deskripsi_sektor_ekonomi' => $this->request->getPost('kjt_name'),

      'tgl_create' => $hariini,
    );
    $model->_savetekonomi($data);
    return redirect()->to('master/ekonomi')->with('success', 'Tambah Data Berhasil');
  }

  public function updateekonomi()
  {
    $model = new Save_model();
    $id = $this->request->getPost('kjt_code');
    $hariini = date('Y-m-d H:i:s');
    $data = array(

      'deskripsi_sektor_ekonomi' => $this->request->getPost('kjt_name'),
      'tgl_update' => $hariini,
    );
    $model->_updateekonomi($data, $id);
    return redirect()->to('master/ekonomi')->with('success', 'Update Data Berhasil');
  }

  public function deleteekonomi($id)
  {
    $model = new Delete_model();
    $model->_deletetekonomi($id);
    return redirect()->to('master/ekonomi')->with('success', 'Hapus Data Berhasil');
  }

  public function debitur()
  {
    $model = new Master_model();
    $_SESSION['com_menu'] = '04';
    $_SESSION['com_men1'] = '0403';
    $_SESSION['com_men2'] = '040303';
    $data['v_data']  = $model->_kodedebitur()->getResult();
    return view('master/debitur/debitur_list', $data);
  }
  public function adddebitur()
  {
    $model = new Master_model();
    $_SESSION['com_menu'] = '04';
    $_SESSION['com_men1'] = '0403';
    $_SESSION['com_men2'] = '040303';
    return view('master/debitur/debitur_add');
  }

  public function editdebitur($id)
  {
    $model = new Master_model();
    $_SESSION['com_menu'] = '04';
    $_SESSION['com_men1'] = '0403';
    $_SESSION['com_men2'] = '040303';
    $data['v_data']  = $model->_edkodedebitur($id)->getResult();
    return view('master/debitur/debitur_edit', $data);
  }

  public function savedebitur()
  {
    $model = new Save_model();
    $hariini = date('Y-m-d H:i:s');
    $data = array(
      'kode_gol_debitur' => $this->request->getPost('kjt_code'),
      'deskripsi_gol_debitur' => $this->request->getPost('kjt_name'),

      'tgl_create' => $hariini,
    );
    $model->_savekodedebitur($data);
    return redirect()->to('master/debitur')->with('success', 'Tambah Data Berhasil');
  }

  public function updatedebitur()
  {
    $model = new Save_model();
    $id = $this->request->getPost('kjt_code');
    $hariini = date('Y-m-d H:i:s');
    $data = array(

      'deskripsi_gol_debitur' => $this->request->getPost('kjt_name'),
      'tgl_update' => $hariini,
    );
    $model->_updatekodedebitur($data, $id);
    return redirect()->to('master/debitur')->with('success', 'Update Data Berhasil');
  }

  public function deletedebitur($id)
  {
    $model = new Delete_model();
    $model->_deletetkodedebitur($id);
    return redirect()->to('master/debitur')->with('success', 'Hapus Data Berhasil');
  }



  public function penjamin()
  {
    $model = new Master_model();
    $_SESSION['com_menu'] = '04';
    $_SESSION['com_men1'] = '0403';
    $_SESSION['com_men2'] = '040303';
    $data['v_data']  = $model->_kodepenjamin()->getResult();
    return view('master/penjamin/penjamin_list', $data);
  }
  public function addpenjamin()
  {
    $model = new Master_model();
    $_SESSION['com_menu'] = '04';
    $_SESSION['com_men1'] = '0403';
    $_SESSION['com_men2'] = '040303';
    return view('master/penjamin/penjamin_add');
  }

  public function editpenjamin($id)
  {
    $model = new Master_model();
    $_SESSION['com_menu'] = '04';
    $_SESSION['com_men1'] = '0403';
    $_SESSION['com_men2'] = '040303';
    $data['v_data']  = $model->_edkodepenjamin($id)->getResult();
    return view('master/penjamin/penjamin_edit', $data);
  }

  public function savepenjamin()
  {
    $model = new Save_model();
    $hariini = date('Y-m-d H:i:s');
    $data = array(
      'kode_gol_penjamin' => $this->request->getPost('kjt_code'),
      'deskripsi_gol_penjamin' => $this->request->getPost('kjt_name'),

      'tgl_create' => $hariini,
    );
    $model->_savekodepenjamin($data);
    return redirect()->to('master/penjamin')->with('success', 'Tambah Data Berhasil');
  }

  public function updatepenjamin()
  {
    $model = new Save_model();
    $id = $this->request->getPost('kjt_code');
    $hariini = date('Y-m-d H:i:s');
    $data = array(

      'deskripsi_gol_penjamin' => $this->request->getPost('kjt_name'),
      'tgl_update' => $hariini,
    );
    $model->_updatekodepenjamin($data, $id);
    return redirect()->to('master/penjamin')->with('success', 'Update Data Berhasil');
  }

  public function deletepenjamin($id)
  {
    $model = new Delete_model();
    $model->_deletetkodepenjamin($id);
    return redirect()->to('master/penjamin')->with('success', 'Hapus Data Berhasil');
  }

  public function sifatbiaya()
  {
    $model = new Master_model();
    $_SESSION['com_menu'] = '04';
    $_SESSION['com_men1'] = '0403';
    $_SESSION['com_men2'] = '040303';
    $data['v_data']  = $model->_kodesifatbiaya()->getResult();
    return view('master/sifatbiaya/sifatbiaya_list', $data);
  }
  public function addsifatbiaya()
  {
    $model = new Master_model();
    $_SESSION['com_menu'] = '04';
    $_SESSION['com_men1'] = '0403';
    $_SESSION['com_men2'] = '040303';
    return view('master/sifatbiaya/sifatbiaya_add');
  }

  public function editsifatbiaya($id)
  {
    $model = new Master_model();
    $_SESSION['com_menu'] = '04';
    $_SESSION['com_men1'] = '0403';
    $_SESSION['com_men2'] = '040303';
    $data['v_data']  = $model->_edkodesifatbiaya($id)->getResult();
    return view('master/sifatbiaya/sifatbiaya_edit', $data);
  }

  public function savesifatbiaya()
  {
    $model = new Save_model();
    $hariini = date('Y-m-d H:i:s');
    $data = array(
      'kode_sifat' => $this->request->getPost('kjt_code'),
      'deskripsi_sifat' => $this->request->getPost('kjt_name'),

      'tgl_create' => $hariini,
    );
    $model->_savekodesifatbiaya($data);
    return redirect()->to('master/sifatbiaya')->with('success', 'Tambah Data Berhasil');
  }

  public function updatesifatbiaya()
  {
    $model = new Save_model();
    $id = $this->request->getPost('kjt_code');
    $hariini = date('Y-m-d H:i:s');
    $data = array(

      'deskripsi_sifat' => $this->request->getPost('kjt_name'),
      'tgl_update' => $hariini,
    );
    $model->_updatekodesifatbiaya($data, $id);
    return redirect()->to('master/sifatbiaya')->with('success', 'Update Data Berhasil');
  }

  public function deletesifatbiaya($id)
  {
    $model = new Delete_model();
    $model->_deletetkodesifatbiaya($id);
    return redirect()->to('master/sifatbiaya')->with('success', 'Hapus Data Berhasil');
  }

  // penggunaan Biaya 
  public function penggunaan()
  {
    $model = new Master_model();
    $_SESSION['com_menu'] = '04';
    $_SESSION['com_men1'] = '0403';
    $_SESSION['com_men2'] = '040303';
    $data['v_data']  = $model->_kodepenggunaan()->getResult();
    return view('master/penggunaan/penggunaan_list', $data);
  }
  public function addpenggunaan()
  {
    $model = new Master_model();
    $_SESSION['com_menu'] = '04';
    $_SESSION['com_men1'] = '0403';
    $_SESSION['com_men2'] = '040303';
    return view('master/penggunaan/penggunaan_add');
  }

  public function editpenggunaan($id)
  {
    $model = new Master_model();
    $_SESSION['com_menu'] = '04';
    $_SESSION['com_men1'] = '0403';
    $_SESSION['com_men2'] = '040303';
    $data['v_data']  = $model->_edkodepenggunaan($id)->getResult();
    return view('master/penggunaan/penggunaan_edit', $data);
  }

  public function savepenggunaan()
  {
    $model = new Save_model();
    $hariini = date('Y-m-d H:i:s');
    $data = array(
      'kode_jenis_penggunaan' => $this->request->getPost('kjt_code'),
      'deskripsi_jenis_penggunaan' => $this->request->getPost('kjt_name'),

      'tgl_create' => $hariini,
    );
    $model->_savekodepenggunaan($data);
    return redirect()->to('master/penggunaan')->with('success', 'Tambah Data Berhasil');
  }

  public function updatepenggunaan()
  {
    $model = new Save_model();
    $id = $this->request->getPost('kjt_code');
    $hariini = date('Y-m-d H:i:s');
    $data = array(

      'deskripsi_jenis_penggunaan' => $this->request->getPost('kjt_name'),
      'tgl_update' => $hariini,
    );
    $model->_updatekodepenggunaan($data, $id);
    return redirect()->to('master/penggunaan')->with('success', 'Update Data Berhasil');
  }

  public function deletepenggunaan($id)
  {
    $model = new Delete_model();
    $model->_deletetkodepenggunaan($id);
    return redirect()->to('master/penggunaan')->with('success', 'Hapus Data Berhasil');
  }

  // Asuransi


  public function asuransi()
  {
    $model = new Master_model();
    $_SESSION['com_menu'] = '04';
    $_SESSION['com_men1'] = '0403';
    $_SESSION['com_men2'] = '040303';
    $data['v_data']  = $model->_kodeasuransi()->getResult();
    return view('master/asuransi/asuransi_list', $data);
  }
  public function addasuransi()
  {
    $model = new Master_model();
    $_SESSION['com_menu'] = '04';
    $_SESSION['com_men1'] = '0403';
    $_SESSION['com_men2'] = '040303';
    return view('master/asuransi/asuransi_add');
  }

  public function editasuransi($id)
  {
    $model = new Master_model();
    $_SESSION['com_menu'] = '04';
    $_SESSION['com_men1'] = '0403';
    $_SESSION['com_men2'] = '040303';
    $data['v_data']  = $model->_edkodeasuransi($id)->getResult();
    return view('master/asuransi/asuransi_edit', $data);
  }

  public function saveasuransi()
  {
    $model = new Save_model();
    $hariini = date('Y-m-d H:i:s');
    $data = array(
      'kode_asuransi' => $this->request->getPost('kjt_code'),
      'deskripsi_asuransi' => $this->request->getPost('kjt_name'),
      'persentase' => $this->request->getPost('kjt_pros'),
      'tgl_create' => $hariini,
    );
    $model->_savekodeasuransi($data);
    return redirect()->to('master/asuransi')->with('success', 'Tambah Data Berhasil');
  }

  public function updateasuransi()
  {
    $model = new Save_model();
    $id = $this->request->getPost('kjt_code');
    $hariini = date('Y-m-d H:i:s');
    $data = array(

      'deskripsi_asuransi' => $this->request->getPost('kjt_name'),
      'persentase' => $this->request->getPost('kjt_pros'),
      'tgl_update' => $hariini,
    );
    $model->_updatekodeasuransi($data, $id);
    return redirect()->to('master/asuransi')->with('success', 'Update Data Berhasil');
  }

  public function deleteasuransi($id)
  {
    $model = new Delete_model();
    $model->_deletetkodeasuransi($id);
    return redirect()->to('master/asuransi')->with('success', 'Hapus Data Berhasil');
  }

  // Ikatan Hukum Agunan


  public function hukumagunan()
  {
    $model = new Master_model();
    $_SESSION['com_menu'] = '04';
    $_SESSION['com_men1'] = '0403';
    $_SESSION['com_men2'] = '040303';
    $data['v_data']  = $model->_kodehukumagunan()->getResult();
    return view('master/hukumagunan/hukumagunan_list', $data);
  }
  public function addhukumagunan()
  {
    $model = new Master_model();
    $_SESSION['com_menu'] = '04';
    $_SESSION['com_men1'] = '0403';
    $_SESSION['com_men2'] = '040303';
    return view('master/hukumagunan/hukumagunan_add');
  }

  public function edithukumagunan($id)
  {
    $model = new Master_model();
    $_SESSION['com_menu'] = '04';
    $_SESSION['com_men1'] = '0403';
    $_SESSION['com_men2'] = '040303';
    $data['v_data']  = $model->_edkodehukumagunan($id)->getResult();
    return view('master/hukumagunan/hukumagunan_edit', $data);
  }

  public function savehukumagunan()
  {
    $model = new Save_model();
    $hariini = date('Y-m-d H:i:s');
    $data = array(
      'kode_ikatan_hukum' => $this->request->getPost('kjt_code'),
      'deskripsi_ikatan_hukum' => $this->request->getPost('kjt_name'),
      'bobot' => $this->request->getPost('kjt_bobt'),
      'formula_ppap' => $this->request->getPost('kjt_paap'),
      'tgl_create' => $hariini,
    );
    $model->_savekodehukumagunan($data);
    return redirect()->to('master/hukumagunan')->with('success', 'Tambah Data Berhasil');
  }

  public function updatehukumagunan()
  {
    $model = new Save_model();
    $id = $this->request->getPost('kjt_code');
    $hariini = date('Y-m-d H:i:s');
    $data = array(

      'deskripsi_ikatan_hukum' => $this->request->getPost('kjt_name'),
      'bobot' => $this->request->getPost('kjt_bobt'),
      'formula_ppap' => $this->request->getPost('kjt_paap'),
      'tgl_update' => $hariini,
    );
    $model->_updatekodehukumagunan($data, $id);
    return redirect()->to('master/hukumagunan')->with('success', 'Update Data Berhasil');
  }

  public function deletehukumagunan($id)
  {
    $model = new Delete_model();
    $model->_deletetkodehukumagunan($id);
    return redirect()->to('master/hukumagunan')->with('success', 'Hapus Data Berhasil');
  }


  public function trantabungan()
  {
    $model = new Master_model();
    $_SESSION['com_menu'] = '04';
    $_SESSION['com_men1'] = '0401';
    $_SESSION['com_men2'] = '040103';
    $data['v_data']  = $model->_get_trantabungan()->getResult();
    return view('master/trantabungan/trantabungan_list', $data);
  }

  public function addtrantabungan()
  {
    $model = new Master_model();
    $_SESSION['com_menu'] = '04';
    $_SESSION['com_men1'] = '0401';
    $_SESSION['com_men2'] = '040103';
    $data['v_bank']  = $model->_get_bank()->getResult();
    return view('master/trantabungan/trantabungan_add', $data);
  }

  public function edittrantabungan($id)
  {
    $model = new Master_model();
    $_SESSION['com_menu'] = '04';
    $_SESSION['com_men1'] = '0401';
    $_SESSION['com_men2'] = '040103';
    $data['v_data']  = $model->_get_edittrantabungan($id)->getResult();
    $data['v_bank']  = $model->_get_bank()->getResult();

    return view('master/trantabungan/trantabungan_edit', $data);
  }


  public function savetrantabungan()
  {
    $model = new Save_model();
    $data = array(
      'trn_code'       => $this->request->getPost('trn_code'),
      'trn_name'       => $this->request->getPost('trn_name'),
      'jns_bayr'       => $this->request->getPost('bnk_code'),
      'tgl_create'       => date('Y-m-d'),

    );

    $model->_savekodetrantabungan($data);
    return redirect()->to('master/trantabungan')->with('sukses', 'Menyimpan Data Baru Berhasil');
  }

  public function updatetrantabungan()
  {
    $model = new Save_model();
    $id = $this->request->getPost('trn_code');
    $data = array(

      'trn_name'       => $this->request->getPost('trn_name'),
      'jns_bayr'       => $this->request->getPost('bnk_code'),
      'tgl_update'       => date('Y-m-d'),
    );

    $model->_updatekodetrantabungan($data, $id);
    return redirect()->to('master/trantabungan')->with('success', 'Merubah Data Berhasil');
  }
  public function deletetrantabungan($id)
  {
    $model = new Delete_model();
    // $id=$this->request->getPost('code');
    $model->m_deletekodetrantabungan($id);
    return redirect()->to('master/trantabungan')->with('success', 'Menghapus Data Berhasil');
  }

  public function transb()
  {
    $model = new Master_model();
    $_SESSION['com_menu'] = '04';
    $_SESSION['com_men1'] = '0402';
    $_SESSION['com_men2'] = '040203';
    $data['v_data']  = $model->_get_transb()->getResult();
    return view('master/transb/transb_list', $data);
  }

  public function addtransb()
  {
    $model = new Master_model();
    $_SESSION['com_menu'] = '04';
    $_SESSION['com_men1'] = '0402';
    $_SESSION['com_men2'] = '040203';
    $data['v_bank']  = $model->_get_bank()->getResult();
    return view('master/transb/transb_add', $data);
  }

  public function edittransb($id)
  {
    $model = new Master_model();
    $_SESSION['com_menu'] = '04';
    $_SESSION['com_men1'] = '0402';
    $_SESSION['com_men2'] = '040203';
    $data['v_data']  = $model->_get_edittransb($id)->getResult();
    $data['v_bank']  = $model->_get_bank()->getResult();

    return view('master/transb/transb_edit', $data);
  }


  public function savetransb()
  {
    $model = new Save_model();
    $data = array(
      'trn_code'       => $this->request->getPost('trn_code'),
      'trn_name'       => $this->request->getPost('trn_name'),
      'jns_bayr'       => $this->request->getPost('bnk_code'),
      'tgl_create'       => date('Y-m-d'),

    );

    $model->_savekodetransb($data);
    return redirect()->to('master/transb')->with('sukses', 'Menyimpan Data Baru Berhasil');
  }

  public function updatetransb()
  {
    $model = new Save_model();
    $id = $this->request->getPost('trn_code');
    $data = array(
      'trn_name'       => $this->request->getPost('trn_name'),
      'jns_bayr'       => $this->request->getPost('bnk_code'),
      'tgl_update'       => date('Y-m-d'),
    );

    $model->_updatekodetransb($data, $id);
    return redirect()->to('master/transb')->with('success', 'Merubah Data Berhasil');
  }
  public function deletetransb($id)
  {
    $model = new Delete_model();
    // $id=$this->request->getPost('code');
    $model->m_deletekodetransb($id);
    return redirect()->to('master/transb')->with('success', 'Menghapus Data Berhasil');
  }

  public function tranpembiayaan()
  {
    $model = new Master_model();
    $_SESSION['com_menu'] = '04';
    $_SESSION['com_men1'] = '0403';
    $_SESSION['com_men2'] = '040303';
    $data['v_data']  = $model->_get_tranpembiayaan()->getResult();
    return view('master/tranpembiayaan/tranpembiayaan_list', $data);
  }

  public function addtranpembiayaan()
  {
    $model = new Master_model();
    $_SESSION['com_menu'] = '04';
    $_SESSION['com_men1'] = '0403';
    $_SESSION['com_men2'] = '040303';
    $data['v_bank']  = $model->_get_bank()->getResult();
    return view('master/tranpembiayaan/tranpembiayaan_add', $data);
  }

  public function edittranpembiayaan($id)
  {
    $model = new Master_model();
    $_SESSION['com_menu'] = '04';
    $_SESSION['com_men1'] = '0403';
    $_SESSION['com_men2'] = '040303';
    $data['v_data']  = $model->_get_edittranpembiayaan($id)->getResult();
    $data['v_bank']  = $model->_get_bank()->getResult();

    return view('master/tranpembiayaan/tranpembiayaan_edit', $data);
  }


  public function savetranpembiayaan()
  {
    $model = new Save_model();
    $data = array(
      'trn_code'       => $this->request->getPost('trn_code'),
      'trn_name'       => $this->request->getPost('trn_name'),
      'jns_bayr'       => $this->request->getPost('bnk_code'),
      'tgl_create'       => date('Y-m-d'),

    );

    $model->_savekodetranpembiayaan($data);
    return redirect()->to('master/tranpembiayaan')->with('sukses', 'Menyimpan Data Baru Berhasil');
  }

  public function updatetranpembiayaan()
  {
    $model = new Save_model();
    $id = $this->request->getPost('trn_code');
    $data = array(


      'trn_name'       => $this->request->getPost('trn_name'),
      'jns_bayr'       => $this->request->getPost('bnk_code'),
      'tgl_update'       => date('Y-m-d'),
    );

    $model->_updatekodetranpembiayaan($data, $id);
    return redirect()->to('master/tranpembiayaan')->with('success', 'Merubah Data Berhasil');
  }
  public function deletetranpembiayaan($id)
  {
    $model = new Delete_model();
    // $id=$this->request->getPost('code');
    $model->m_deletekodetranpembiayaan($id);
    return redirect()->to('master/tranpembiayaan')->with('success', 'Menghapus Data Berhasil');
  }

  public function module()
  {
    $model = new Master_model();
    $_SESSION['com_menu'] = '';
    $_SESSION['com_men1'] = '';
    $_SESSION['com_men2'] = '';
    $data['v_data']  = $model->_get_form()->getResult();
    return view('master/form/form_list', $data);
  }

  public function addmodule()
  {
    $model = new Master_model();
    $_SESSION['com_menu'] = '';
    $_SESSION['com_men1'] = '';
    $_SESSION['com_men2'] = '';
    // $data['v_data']  = $model->_get_module()->getResult();
    return view('master/form/form_add');
  }
  public function editmodule($id)
  {
    $model = new Master_model();
    $_SESSION['com_menu'] = '';
    $_SESSION['com_men1'] = '';
    $_SESSION['com_men2'] = '';
    $data['v_data']  = $model->_get_edform($id)->getResult();
    return view('master/form/form_edit', $data);
  }

  public function savemodule()
  {
    $model = new Save_model();
    $data = array(
      'frm_code'       => $this->request->getPost('frm_code'),
      'id'       => $this->request->getPost('frm_code'),
      'frm_name'       => $this->request->getPost('frm_name'),
      'frm_levl'       => $this->request->getPost('frm_levl'),
      'frm_indk'       => $this->request->getPost('frm_indk'),
      'frm_link'       => $this->request->getPost('frm_link'),
      'frm_icon'       => $this->request->getPost('frm_icon'),

    );
    $model->_savemodule($data);

    $data = array(
      'frm_code'       => $this->request->getPost('frm_code'),
      'username'      => session()->get('username'),

      'frm_stat' => 1,
    );
    $model->_saveaksesmodule($data);
    return redirect()->to('master/module')->with('success', 'Tambah Data Berhasil');
  }

  public function updatemodule()
  {
    $model = new Save_model();
    $id = $this->request->getPost('frm_code');
    $data = array(
      // 'frm_code'       => $this->request->getPost('frm_code'),
      'frm_name'       => $this->request->getPost('frm_name'),
      'frm_levl'       => $this->request->getPost('frm_levl'),
      'frm_indk'       => $this->request->getPost('frm_indk'),
      'frm_link'       => $this->request->getPost('frm_link'),
      'frm_icon'       => $this->request->getPost('frm_icon'),
    );
    $model->_updatemodule($data, $id);
    return redirect()->to('master/module')->with('success', 'Merubah Data Berhasil');
  }

  public function deletemodule($id)
  {
    $model = new Delete_model();
    $model->_deletemodule($id);
    return redirect()->to('master/module')->with('success', 'Hapus Data Berhasil');
  }

  public function kolektor()
  {
    $model = new Master_model();
    $_SESSION['com_menu'] = '02';
    $_SESSION['com_men1'] = '0203';
    $_SESSION['com_men2'] = '020305';
    $data['v_data']  = $model->_get_employee()->getResult();
    return view('master/kolektor/kolektor_list', $data);
  }

  public function addkolektor()
  {
    $model = new Master_model();
    $_SESSION['com_menu'] = '02';
    $_SESSION['com_men1'] = '0203';
    $_SESSION['com_men2'] = '020305';
    $data['v_bank']  = $model->_get_bank()->getResult();
    $data['v_cabang']  = $model->_get_cabang()->getResult();
    return view('master/kolektor/kolektor_add', $data);
  }

  public function editkolektor($id)
  {
    $model = new Master_model();
    $_SESSION['com_menu'] = '02';
    $_SESSION['com_men1'] = '0203';
    $_SESSION['com_men2'] = '020305';
    $data['v_bank']  = $model->_get_bank()->getResult();
    $data['v_cabang']  = $model->_get_cabang()->getResult();
    $data['v_data']  = $model->_ed_edemployee($id)->getResult();
    return view('master/kolektor/kolektor_edit', $data);
  }

  public function savekolektor()
  {
    $model = new Save_model();
    $hariini = date('Y-m-d H:i:s');
    $data = array(
      'emp_code' => $this->request->getPost('emp_code'),
      'emp_name' => $this->request->getPost('emp_name'),
      'emp_jabs' => $this->request->getPost('emp_jabs'),
      'emp_adrs' => $this->request->getPost('emp_adrs'),
      'emp_rekg' => $this->request->getPost('emp_rekg'),
      'emp_phon' => $this->request->getPost('emp_phon'),
      'bnk_code' => $this->request->getPost('bnk_code'),
      'kode_cabang' => $this->request->getPost('dep_code'),

    );
    $model->_savekolektor($data);
    return redirect()->to('master/kolektor')->with('success', 'Tambah Data Berhasil');
  }

  public function updatekolektor()
  {
    $model = new Save_model();
    $id = $this->request->getPost('emp_code');
    $hariini = date('Y-m-d H:i:s');
    $data = array(

      'emp_name' => $this->request->getPost('emp_name'),
      'emp_jabs' => $this->request->getPost('emp_jabs'),
      'emp_adrs' => $this->request->getPost('emp_adrs'),
      'emp_rekg' => $this->request->getPost('emp_rekg'),
      'emp_phon' => $this->request->getPost('emp_phon'),
      'bnk_code' => $this->request->getPost('bnk_code'),
      'kode_cabang' => $this->request->getPost('dep_code'),
    );
    $model->_updatekolektor($data, $id);
    return redirect()->to('master/kolektor')->with('success', 'Update Data Berhasil');
  }

  public function deletekolektor($id)
  {
    $model = new Delete_model();
    $model->m_deletekolektor($id);
    return redirect()->to('master/kolektor')->with('success', 'Hapus Data Berhasil');
  }

  public function kelompok()
  {
    $model = new Master_model();
    $_SESSION['com_menu'] = '02';
    $_SESSION['com_men1'] = '0203';
    $_SESSION['com_men2'] = '020306';

    $data['v_data']  = $model->_get_kelompok()->getResult();
    return view('master/kelompok/kelompok_list', $data);
  }

  public function addkelompok()
  {
    $model = new Master_model();
    $_SESSION['com_menu'] = '02';
    $_SESSION['com_men1'] = '0203';
    $_SESSION['com_men2'] = '020306';
    $data['v_employee']  = $model->_get_employee()->getResult();
    return view('master/kelompok/kelompok_add', $data);
  }

  public function editkelompok($id)
  {
    $model = new Master_model();
    $_SESSION['com_menu'] = '02';
    $_SESSION['com_men1'] = '0203';
    $_SESSION['com_men2'] = '020306';
    $data['v_employee']  = $model->_get_employee()->getResult();
    $data['v_data']  = $model->_edkelompok($id)->getResult();
    return view('master/kelompok/kelompok_edit', $data);
  }

  public function savekelompok()
  {
    $model = new Save_model();
    $hariini = date('Y-m-d H:i:s');
    $data = array(
      'emp_code' => $this->request->getPost('emp_code'),
      'kel_name' => $this->request->getPost('kel_name'),
      'kel_code' => $this->request->getPost('kel_code'),



    );
    $model->_savekelompok($data);
    return redirect()->to('master/kelompok')->with('success', 'Tambah Data Berhasil');
  }

  public function updatekelompok()
  {
    $model = new Save_model();
    $id = $this->request->getPost('kel_code');
    $hariini = date('Y-m-d H:i:s');
    $data = array(

      'kel_name' => $this->request->getPost('kel_name'),
      'emp_code' => $this->request->getPost('emp_code'),

    );
    $model->_updatekelompok($data, $id);
    return redirect()->to('master/kelompok')->with('success', 'Update Data Berhasil');
  }

  public function deletekelompok($id)
  {
    $model = new Delete_model();
    $model->m_deletekelompok($id);
    return redirect()->to('master/kelompok')->with('success', 'Hapus Data Berhasil');
  }


  public function simpanExcelkota()
  {

    $msave = new Save_model();
    $file = $this->request->getFile('fileexcel');
    if ($file) {
      $excelReader  = new PHPExcel();
      //mengambil lokasi temp file
      $fileLocation = $file->getTempName();
      //baca file
      $objPHPExcel = PHPExcel_IOFactory::load($fileLocation);
      //ambil sheet active
      $sheet    = $objPHPExcel->getActiveSheet()->toArray(null, true, true, true);
      //looping untuk mengambil data
      foreach ($sheet as $idx => $data) {
        //skip index 1 karena title excel
        if ($idx == 1) {
          continue;
        }
        $kode = $data['A'];
        $nama = $data['B'];
        $provinsi = $data['C'];


        // insert data
        $data = array(
          'kot_code' => $kode,
          'kot_name' => $nama,
          'pro_code' => $provinsi,
          'neg_code' => '062',
          'kot_stat' => 'Y',
        );
        $msave->_savekota1($data);
      }
    }
    return redirect()->to('master/kota')->with('success', 'Simpan Data Berhasil' . $file);
  }
}
