<?php

namespace App\Controllers;

use App\Models\Auto_model;
use App\Models\Delete_model;
use App\Models\Master_model;
use App\Models\Save_model;
use App\Models\Model_git;

class Pinjaman extends BaseController
{
  public function __construct()
  {
    $session = session();
    date_default_timezone_set('Asia/Jakarta');
  }
  public function index()
  {
    $_SESSION['com_menu'] = '';
    $_SESSION['com_men1'] = '';
    $_SESSION['com_men2'] = '';
  }
  public function simulasi()
  {
    $model = new Master_model();
    $_SESSION['com_menu'] = '02';
    $_SESSION['com_men1'] = '0202';
    $id1 = 'K';
    $data['v_product']  = $model->_get_productb($id1)->getResult();
    $data['v_jangkawaktu']  = $model->_get_periode()->getResult();
    return view('pinjaman/simulasi', $data);
  }

  public function pengajuan()
  {
    $model = new Model_git();
    // if ($_SESSION['usr_jabt'] == 'Administrator') {
    //   $data['v_data']  = $model->_get_tabcolectifa($tanggal)->getResult();
    // } else {
    //   $data['v_data']  = $model->_get_tabcolectif($tanggal, $cabang)->getResult();
    // }
    $data['v_pengajuan']  = $model->_get_pengajuan()->getResult();
    return view('pinjaman/pengajuan/pengajuan_list', $data);
  }

  public function adpengajuan()
  {
    $model = new Master_model();
    $id1 = 'K';
    $data['v_product']  = $model->_get_productb($id1)->getResult();
    $data['v_anggota']  = $model->_get_langgota()->getResult();
    // $data['v_jangkawaktu']  = $model->_get_periode()->getResult();
    return view('pinjaman/pengajuan/pengajuan_add', $data);
  }

  public function edpengajuan($id)
  {
    $model = new Model_git();
    $model1 = new Master_model();
    $id1 = 'K';
    $data['v_product']  = $model1->_get_productb($id1)->getResult();
    $data['v_jangkawaktu']  = $model1->_get_periode()->getResult();
    $data['v_pengajuan']  = $model->_get_edpengajuan($id)->getResult();
    $data['v_anggota']  = $model1->_get_langgota()->getResult();
    $data['v_agunan']  = $model->_get_agunan($id)->getResult();
    $data['v_jenis']  = $model1->_get_jenisagunan()->getResult();
    return view('pinjaman/pengajuan/pengajuan_edit', $data);
  }


  public function pengajuandetil($id)
  {
    $model = new Model_git();
    $model1 = new Master_model();
    $id1 = 'K';
    $data['v_product']  = $model1->_get_productb($id1)->getResult();
    $data['v_jangkawaktu']  = $model1->_get_periode()->getResult();
    $data['v_pengajuan']  = $model->_get_edpengajuan($id)->getResult();

    return view('pinjaman/pengajuan/pengajuan_detil', $data);
  }
  public function persetujuan()
  {
    $model = new Model_git();
    $data['v_pengajuan']  = $model->_get_persetujuan()->getResult();
    return view('pinjaman/persetujuan', $data);
  }

  public function kontrak()
  {
    $model = new Model_git();
    $_SESSION['com_menu'] = '04';
    $_SESSION['com_men1'] = '0403';
    $_SESSION['com_men2'] = '';
    $tanggal = date('Y/m/d');

    $cabang  = session()->get('kode_cabang');
    if ($_SESSION['usr_jabt'] == 'Administrator') {
      $data['v_kontrak']  = $model->_get_kontrakla($tanggal)->getResult();
    } else {
      $data['v_kontrak']  = $model->_get_kontrakl($tanggal, $cabang)->getResult();
    }

    return view('pinjaman/kontrak/kontrak_list', $data);
  }

  public function hapuspembiayaan()
  {
    $model = new Model_git();
    $_SESSION['com_menu'] = '04';
    $_SESSION['com_men1'] = '0403';
    $_SESSION['com_men2'] = '040302';
    $tgl1 = '';
    $tgl2 = '';
    $data['v_kas']  = $model->_get_loaddpembiyaan($tgl1, $tgl2)->getResult();
    return view('pinjaman/kontrak/kontrak_delete', $data);
  }

  public function adkontrak()
  {

    $model = new Master_model();
    $_SESSION['com_menu'] = '04';
    $_SESSION['com_men1'] = '0403';
    $_SESSION['com_men2'] = '';
    $id1 = 'K';
    $tanggal = date('Y-m-d');
    $data['hariini'] = $tanggal;
    $data['v_anggota']  = $model->_get_langgota()->getResult();
    $data['v_product']  = $model->_get_productb($id1)->getResult();
    $data['v_petugas']  = $model->_get_employee()->getResult();
    $data['v_kelompok']  = $model->_get_kelompok()->getResult();
    return view('pinjaman/kontrak/kontrak_add', $data);
  }

  public function edkontrak($id)
  {
    $model = new Model_git();
    $mmaster = new Master_model();
    $_SESSION['com_menu'] = '04';
    $_SESSION['com_men1'] = '0403';
    $_SESSION['com_men2'] = '';
    $id1 = 'K';
    $data['v_data']  = $model->_get_edkontrak($id)->getResult();
    $data['v_product']  = $mmaster->_get_productb($id1)->getResult();
    $data['v_kartu']  = $model->_get_kartu($id)->getResult();
    $data['v_agunan']  = $model->_get_agunan($id)->getResult();
    // $data['v_anggota']  = $mmaster->_get_langgota()->getResult();
    $data['v_kelompok']  = $mmaster->_get_kelompok()->getResult();
    $data['v_petugas']  = $mmaster->_get_employee()->getResult();
    $data['v_tabungan']  = $model->_list_tabungan()->getResult();

    return view('pinjaman/kontrak/kontrak_edit', $data);
  }
  public function viewpembiayaan($id)
  {
    $model = new Model_git();
    $mmaster = new Master_model();
    $_SESSION['com_menu'] = '04';
    $_SESSION['com_men1'] = '0403';
    $_SESSION['com_men2'] = '';
    $id1 = 'K';
    $data['v_data']  = $model->_get_edkontrak($id)->getResult();
    $data['v_product']  = $mmaster->_get_productb($id1)->getResult();
    $data['v_kartu']  = $model->_get_kartu($id)->getResult();
    $data['v_agunan']  = $model->_get_agunan($id)->getResult();
    $data['v_anggota']  = $mmaster->_get_langgota()->getResult();
    $data['v_kelompok']  = $mmaster->_get_kelompok()->getResult();
    $data['v_petugas']  = $mmaster->_get_employee()->getResult();
    $data['v_tabungan']  = $model->_list_tabungan()->getResult();

    return view('pinjaman/kontrak/kontrak_view', $data);
  }

  public function printkartu($id)
  {
    $model = new Model_git();
    $data['v_kontrak']  = $model->_get_edkontrak($id)->getResult();
    $data['v_kartu']  = $model->_get_kartu($id)->getResult();
    return view('pinjaman/kontrak/printkartu', $data);
  }



  public function savepengajuan()
  {
    $model = new Save_model();
    $modecek = new Auto_model();
    $tanggal = $this->request->getPost('png_date');
    $bulan = date('m', strtotime($tanggal));
    $tahun = date('Y', strtotime($tanggal));

    $cek = $modecek->get_nopengajuan($bulan, $tahun);
    if ($bulan < 10) {
      $bulan1 = '0' . $bulan;
    } else {
      $bulan1 = $bulan;
    }

    $nourut = $cek['png_srno'];
    if ($nourut == '') {
      $nourut = 1;
      $v_trx_code = '01.' . $tahun . $bulan . '00001';
    } else {
      $nourut = $nourut + 1;
      if ($nourut < 10) {
        $v_trx_code = '01.' . $tahun . $bulan . '0000' . $nourut;
      } else if ($nourut >= 10 and $nourut < 100) {
        $v_trx_code = '01.' . $tahun . $bulan . '000' . $nourut;
      } else if ($nourut >= 100 and $nourut < 1000) {
        $v_trx_code = '01.' . $tahun . $bulan . '00' . $nourut;
      } else if ($nourut >= 1000 and $nourut < 10000) {
        $v_trx_code = '01.' . $tahun . $bulan . '0' . $nourut;
      } else {
        $v_trx_code = '01.' . $tahun . $bulan . $nourut;
      }
    }
    $png_totl = str_replace(',', '', $this->request->getPost('png_totl'));
    $png_prov = str_replace(',', '', $this->request->getPost('png_prov'));
    $png_admn = str_replace(',', '', $this->request->getPost('png_admn'));
    $png_tdan = str_replace(',', '', $this->request->getPost('png_tdan'));
    $png_matr = str_replace(',', '', $this->request->getPost('png_matr'));
    $png_lain = str_replace(',', '', $this->request->getPost('png_lain'));
    $png_asrn = str_replace(',', '', $this->request->getPost('png_asrn'));
    $png_angs = str_replace(',', '', $this->request->getPost('png_angs'));
    $png_tot1 = str_replace(',', '', $this->request->getPost('png_tot1'));
    $png_phut = str_replace(',', '', $this->request->getPost('png_phut'));
    $png_tpot = str_replace(',', '', $this->request->getPost('png_tpot'));
    $png_angb = str_replace(',', '', $this->request->getPost('png_angb'));
    $png_angp = str_replace(',', '', $this->request->getPost('png_angp'));
    $data = array(

      'png_date'       => $this->request->getPost('png_date'),
      'agt_numb'       => $this->request->getPost('agt_numb'),
      'prd_code'       => $this->request->getPost('prd_code'),
      'bng_type'       => $this->request->getPost('bng_type'),
      'png_tnid'       => $this->request->getPost('png_tenr'),
      'png_tenr'       => $this->request->getPost('png_tnid'),
      'png_totl'       => $png_totl,
      'png_marg'       => $this->request->getPost('png_marg'),
      'smd_code'       => $this->request->getPost('smd_code'),
      'png_desc'       => $this->request->getPost('png_desc'),
      'png_prov'       => $png_prov,
      'png_admn'       => $png_admn,
      'png_tdan'       => $png_tdan,
      'png_matr'       => $png_matr,
      'png_lain'       => $png_lain,
      'png_asrn'       => $png_asrn,
      'png_tpot'       => $png_tpot,
      'png_tot1'       => $png_tot1,
      'png_plat'       => $this->request->getPost('png_plat'),
      'png_angs'       => $png_angs,
      'png_angb'       => $png_angb,
      'png_angp'       => $png_angp,
      'png_phut'       => $png_phut,
      'png_splt'       => $this->request->getPost('png_splt'),
      'png_mont'       => $bulan,
      'png_year'       => $tahun,
      'png_srno'       => $nourut,
      'png_kntr' => 0,
      'png_stat' => 0,
      'com_code'  => session()->get('com_code'),
      'kode_cabang'  => session()->get('kode_cabang'),
      'png_code' => $v_trx_code,
    );

    $model->_savepengajuan($data);


    $kode = $_POST['jns_idno'];
    $jumlah = count($kode);

    for ($x = 0; $x < $jumlah; $x++) {
      $kode = $this->request->getPost('jns_idno[' . $x . ']');

      if ($kode != '') {
        $data = array(
          'png_code'       => $v_trx_code,

          'agn_type'       => $this->request->getPost('jns_idno[' . $x . ']'),
          'agn_numb'       => $this->request->getPost('agn_numb[' . $x . ']'),
          'agn_name'       => $this->request->getPost('agn_name[' . $x . ']'),
          'agn_jtdt'       => $this->request->getPost('agn_date[' . $x . ']'),
          'agn_adrs'       => $this->request->getPost('agn_adrs[' . $x . ']'),
          'agn_loks'       => $this->request->getPost('agn_loks[' . $x . ']'),
          'agn_jens'       => $this->request->getPost('agn_jens[' . $x . ']'),
          'agn_totl'       => $this->request->getPost('agn_totl[' . $x . ']'),
          'agn_idno'       => $x,
          'loc_code'       => $this->request->getPost('loc_code[' . $x . ']'),

        );
        $model->_saveagunan($data);
      }
    }
    return redirect()->to('pinjaman/pengajuan')->with('success', 'Menambah Data Berhasil');
  }

  public function updatepengajuan()
  {
    $model = new Save_model();
    $moddel = new Delete_model();
    $id = $this->request->getPost('png_code');
    $tanggal = $this->request->getPost('png_date');
    $bulan = date('m', strtotime($tanggal));
    $tahun = date('Y', strtotime($tanggal));
    $png_totl = str_replace(',', '', $this->request->getPost('png_totl'));
    $png_prov = str_replace(',', '', $this->request->getPost('png_prov'));
    $png_admn = str_replace(',', '', $this->request->getPost('png_admn'));
    $png_tdan = str_replace(',', '', $this->request->getPost('png_tdan'));
    $png_matr = str_replace(',', '', $this->request->getPost('png_matr'));
    $png_lain = str_replace(',', '', $this->request->getPost('png_lain'));
    $png_asrn = str_replace(',', '', $this->request->getPost('png_asrn'));
    $png_angs = str_replace(',', '', $this->request->getPost('png_angs'));
    $png_tot1 = str_replace(',', '', $this->request->getPost('png_tot1'));
    $png_phut = str_replace(',', '', $this->request->getPost('png_phut'));
    $png_tpot = str_replace(',', '', $this->request->getPost('png_tpot'));


    $data = array(
      // 'png_code'       => $this->request->getPost('png_code'),
      'png_date'       => $this->request->getPost('png_date'),
      'agt_numb'       => $this->request->getPost('agt_numb'),
      'prd_code'       => $this->request->getPost('prd_code'),
      'bng_type'       => $this->request->getPost('bng_type'),
      'png_tnid'       => $this->request->getPost('png_tenr'),
      'png_tenr'       => $this->request->getPost('png_tnid'),
      'png_totl'       => $png_totl,
      'png_marg'       => $this->request->getPost('png_marg'),
      'smd_code'       => $this->request->getPost('smd_code'),
      'png_desc'       => $this->request->getPost('png_desc'),
      'png_prov'       => $png_prov,
      'png_admn'       => $png_admn,
      'png_tdan'       => $png_tdan,
      'png_matr'       => $png_matr,
      'png_lain'       => $png_lain,
      'png_asrn'       => $png_asrn,
      'png_tpot'       => $png_tpot,
      'png_tot1'       => $png_tot1,
      'png_plat'       => $this->request->getPost('png_plat'),
      'png_angs'       => $png_angs,
      'png_angb'       => $this->request->getPost('png_angb'),
      'png_angp'       => $this->request->getPost('png_angp'),
      'png_phut'       =>  $png_phut,
      'png_splt'       => $this->request->getPost('png_splt'),
      'png_mont'       => $bulan,
      'png_year'       => $tahun,

    );

    $model->_updatepengajuan($data, $id);
    $moddel->_deleteagunan($id);
    $kode = $_POST['jns_idno'];
    $jumlah = count($kode);

    for ($x = 0; $x < $jumlah; $x++) {
      $kode = $this->request->getPost('jns_idno[' . $x . ']');

      if ($kode != '') {
        $data = array(
          'png_code'       => $this->request->getPost('png_code'),

          'agn_type'       => $this->request->getPost('jns_idno[' . $x . ']'),
          'agn_numb'       => $this->request->getPost('agn_numb[' . $x . ']'),
          'agn_name'       => $this->request->getPost('agn_name[' . $x . ']'),
          'agn_jtdt'       => $this->request->getPost('agn_date[' . $x . ']'),
          'agn_adrs'       => $this->request->getPost('agn_adrs[' . $x . ']'),
          'agn_loks'       => $this->request->getPost('agn_loks[' . $x . ']'),
          'agn_jens'       => $this->request->getPost('agn_jens[' . $x . ']'),
          'agn_totl'       => $this->request->getPost('agn_totl[' . $x . ']'),
          'agn_idno'       => $x,
          'loc_code'       => $this->request->getPost('loc_code[' . $x . ']'),

        );
        $model->_saveagunan($data);
      }
    }

    return redirect()->to('pinjaman/pengajuan')->with('success', 'Merubah Data Berhasil');
  }

  public function deletepengajuan($id)
  {
    $model = new Delete_model();
    // $id = $this->request->getPost('code');

    $model->m_deletepengajuan($id);
    return redirect()->to('pinjaman/pengajuan')->with('success', 'Menghapus Data Berhasil');
  }

  public function approved()
  {
    $id = $this->request->getPost('git_code');
    $model = new Save_model();

    $data = array(
      'png_code'       => $this->request->getPost('git_code'),
      'png_des1'       => $this->request->getPost('png_des1'),
      'png_appr'       => $_SESSION['username'],
      'png_stat'  => $this->request->getPost('app_type'),
    );
    $model->_approved($data, $id);
    return redirect()->to('pinjaman/persetujuan')->with('success', 'Menambah Data Berhasil');
  }


  public function savekontrak()
  {
    $model = new Save_model();
    $modecek = new Auto_model();
    $tanggal = $this->request->getPost('knt_date');

    $bulan = date('m', strtotime($tanggal));
    $tahun = date('Y', strtotime($tanggal));
    $kodecabang = trim(session()->get('kode_cabang'));
    $kodeproduct = trim($this->request->getPost('prd_code'));

    $cek = $modecek->get_nokontrak($kodecabang, $kodeproduct);


    $nourut = $cek['knt_srno'];


    if ($nourut == '') {
      $nourut = 1;
      $v_trx_code = $kodeproduct . '.' . $kodecabang . '.0000001';
    } else {
      $nourut = $nourut + 1;
      if ($nourut < 10) {
        $v_trx_code = $kodeproduct . '.' . $kodecabang . '.000000' . $nourut;
      } else if ($nourut >= 10 and $nourut < 100) {
        $v_trx_code = $kodeproduct . '.' . $kodecabang . '.00000' . $nourut;
      } else if ($nourut >= 100 and $nourut < 1000) {
        $v_trx_code = $kodeproduct . '.' . $kodecabang . '.0000' . $nourut;
      } else if ($nourut >= 1000 and $nourut < 10000) {
        $v_trx_code = $kodeproduct . '.' . $kodecabang . '.000' . $nourut;
      } else if ($nourut >= 10000 and $nourut < 100000) {
        $v_trx_code = $kodeproduct . '.' . $kodecabang . '.00' . $nourut;
      } else if ($nourut >= 100000 and $nourut < 1000000) {
        $v_trx_code = $kodeproduct . '.' . $kodecabang . '.0' . $nourut;
      } else {
        $v_trx_code = $kodeproduct . '.' . $kodecabang . '.' . $nourut;
      }
    }


    $periode = $this->request->getPost('knt_tenr');
    $tgljtx = $this->request->getPost('knt_jtdt');

    $tgljty = substr($tgljtx, 6, 4) . '/' . substr($tgljtx, 3, 2) . '/' . substr($tgljtx, 0, 2);
    // $tgljtx = strtotime('30/04/2024');
    $hari = substr($tgljtx, 0, 2);

    // $tgljty = $tahun  . '-' . $bulan . '-' . $hari;

    $days = is_integer($hari);
    $kin_totl = str_replace(',', '', $this->request->getPost('knt_totl'));
    $kon_prov = str_replace(',', '', $this->request->getPost('knt_prov'));
    $knt_admn = str_replace(',', '', $this->request->getPost('knt_admn'));
    $knt_asrn = str_replace(',', '', $this->request->getPost('knt_asrn'));
    $knt_tdan = str_replace(',', '', $this->request->getPost('knt_tdan'));
    $knt_matr = str_replace(',', '', $this->request->getPost('knt_matr'));
    $knt_lain = str_replace(',', '', $this->request->getPost('knt_lain'));
    $knt_tpot = str_replace(',', '', $this->request->getPost('knt_tpot'));
    $knt_tot1 = str_replace(',', '', $this->request->getPost('knt_tot1'));
    $knt_pden = str_replace(',', '', $this->request->getPost('knt_pden'));
    $knt_nden = str_replace(',', '', $this->request->getPost('knt_nden'));
    $knt_angs = str_replace(',', '', $this->request->getPost('knt_angs'));
    $knt_tmar = str_replace(',', '', $this->request->getPost('knt_tmar'));
    $knt_angp = str_replace(',', '', $this->request->getPost('knt_angp'));
    $knt_angb = str_replace(',', '', $this->request->getPost('knt_angb'));
    $knt_agun = str_replace(',', '', $this->request->getPost('knt_agun'));
    $data = array(
      //'id'       =>    $v_trx_code, //request->getPost('knt_code'),
      'knt_code'       => $v_trx_code, //request->getPost('knt_code'),
      'knt_date'       => $this->request->getPost('knt_date'),
      'agt_numb'       => $this->request->getPost('agt_numb'),
      'png_code'       => $this->request->getPost('png_code'),
      'prd_code'       => $this->request->getPost('prd_code'),
      'bng_type'       => $this->request->getPost('bng_type'),
      'knt_tnid'       => $this->request->getPost('knt_tnid'),
      'knt_tenr'       => $this->request->getPost('knt_tenr'),
      'knt_totl'       => $kin_totl,
      'knt_marg'       => $this->request->getPost('knt_marg'),
      'smd_code'       => $this->request->getPost('smd_code'),
      'knt_desc'       => $this->request->getPost('agt_name'),
      'knt_prov'       => $kon_prov,
      'knt_admn'       => $knt_admn,
      'knt_asrn'       => $knt_asrn,
      'knt_tdan'       => $knt_tdan,
      'knt_matr'       => $knt_matr,
      'knt_lain'       => $knt_lain,
      'knt_tpot'       => $knt_tpot,
      'knt_tot1'       => $knt_tot1,
      'knt_gper'       => $this->request->getPost('knt_gper'),
      'knt_angs'       => $knt_angs,
      'knt_angb'       => $knt_angb,
      'knt_agun'       => $knt_agun,
      'knt_angp'       => $knt_angp,
      'knt_jtdt'       => $tgljty,
      'knt_pden'       => $knt_pden,
      'knt_nden'       => $knt_nden,
      'knt_mont'       => $bulan,
      'knt_year'       => $tahun,
      'knt_srno'       => $nourut,
      'knt_code'       => $v_trx_code,
      'knt_days'       => $days,
      'knt_grac'       => $this->request->getPost('knt_grac'),
      'tbg_code'       => $this->request->getPost('tbg_code'),
      'knt_tmar'       => $knt_tmar,
      //'knt_nmrg'       => $this->request->getPost('knt_nmrg'),
      'knt_asrk'       => 0, //$this->request->getPost('knt_asrk'),
      'knt_notr'       => $this->request->getPost('knt_notr'),
      'com_code'       => 1,
      'kode_cabang'  => session()->get('kode_cabang'),
      'emp_code'  => $this->request->getPost('emp_code'),
      'kel_code'  => $this->request->getPost('kel_code'),
      'col_code'  => $this->request->getPost('col_code'),
      'knt_stat' => 0,
      'knt_jang' => $this->request->getPost('knt_jang'),
      'knt_hari' => $this->request->getPost('jml_hari'),

    );

    $model->_savekontrak($data);
    //-----end save header-----
    //----- Kartu Debitur-----
    $id = 1;
    $kode = $_POST['angsuranke'];
    if ($kode != '') {
      $jumlah = count($kode);
    } else {
      $jumlah = 0;
    }

    $tgljt = $this->request->getPost('knt_gper');


    for ($x = 0; $x < $jumlah; $x++) {

      $kode = $this->request->getPost('angsuranke[' . $x . ']');
      $knt_angp = str_replace(',', '', $this->request->getPost('pokokangsuran[' . $x . ']'));
      $knt_angb = str_replace(',', '', $this->request->getPost('pokokbunga[' . $x . ']'));
      $knt_angs = str_replace(',', '', $this->request->getPost('totansuran[' . $x . ']'));
      $knt_poko = str_replace(',', '', $this->request->getPost('pokokhutang[' . $x . ']'));
      $tgljtx1 = $this->request->getPost('tgl[' . $x . ']');
      if ($kode != '') {
        $tgljt1 = substr($tgljtx1, 6, 4) . '/' . substr($tgljtx1, 3, 2) . '/' . substr($tgljtx1, 0, 2);
        // $tgljt1 = date('Y-m-d', strtotime('+' . $x . 'month', strtotime($tgljt)));
        $data = array(

          //  'knt_code' => $this->$v_trx_code,//request->getPost('knt_code'),
          'knt_idno' => $this->request->getPost('angsuranke[' . $x . ']'),
          'knt_angp'  => $knt_angp, //$this->request->getPost('pokokangsuran[' . $x . ']'),
          'knt_angb'  => $knt_angb, //$this->request->getPost('pokokbunga[' . $x . ']'),
          'knt_angs'  => $knt_angs, //$this->request->getPost('totansuran[' . $x . ']'),
          'knt_poko'  => $knt_poko, //$this->request->getPost('pokokhutang[' . $x . ']'),
          'knt_jtdt'  => $tgljt1,
          'knt_code'  => $v_trx_code,
        );
        $model->_savedebitur($data);
      }
    }
    // end Kartu debitur

    //save kartu Piutang

    for ($x = 0; $x < $jumlah; $x++) {

      $kode = $this->request->getPost('angsuranke[' . $x . ']');
      $knt_angp = str_replace(',', '', $this->request->getPost('pokokangsuran[' . $x . ']'));
      $knt_angb = str_replace(',', '', $this->request->getPost('pokokbunga[' . $x . ']'));
      $knt_angs = str_replace(',', '', $this->request->getPost('totansuran[' . $x . ']'));
      $knt_poko = str_replace(',', '', $this->request->getPost('pokokhutang[' . $x . ']'));
      $tgljtx1 = $this->request->getPost('tgl[' . $x . ']');
      if ($kode != '') {

        if ($x > 0) {
          $tgljt1 = substr($tgljtx1, 6, 4) . '/' . substr($tgljtx1, 3, 2) . '/' . substr($tgljtx1, 0, 2);
          // $tgljt1 = date('Y-m-d', strtotime('+' . $x . 'month', strtotime($tgljt)));
          $data = array(

            'trx_date' => $this->request->getPost('knt_date'),
            'agt_numb' => $this->request->getPost('agt_numb'),
            'trx_jens'  => 'AR-T007',
            'trx_amnh'  => $knt_angs, //$this->request->getPost('totansuran[' . $x . ']'),
            'trx_lnsh'  => 0,
            'lns_pokk'  => 0,
            'lns_bung'  => 0,
            'trx_angk'  => $this->request->getPost('angsuranke[' . $x . ']'),
            'bkt_code'  => $this->request->getPost('knt_code'),
            'bkt_date' => $tgljt1,
            'bkt_amnh'  => $knt_angs, //$this->request->getPost('totansuran[' . $x . ']'),
            'trx_pokk'  => $knt_angp, //$this->request->getPost('pokokangsuran[' . $x . ']'),
            'trx_bung'  => $knt_angb, //$this->request->getPost('pokokbunga[' . $x . ']'),
            'trx_jtdt'  => $tgljt1,
            'trx_code' => $v_trx_code, //$this->request->getPost('knt_code'),
            'com_code'  => session()->get('com_code'),
            'kode_cabang'  => session()->get('kode_cabang'),

          );
          $model->_savekartupiutang($data);
        }
      }
    }

    // save Agunan

    $kode = $_POST['jns_idno'];
    if ($kode != '') {
      $jumlah = count($kode);
    } else {
      $jumlah = 0;
    }

    for ($x = 0; $x < $jumlah; $x++) {
      $kode = $this->request->getPost('jns_idno[' . $x . ']');
      $agntotl = str_replace(',', '', $this->request->getPost('agntotl[' . $x . ']'));

      if ($kode != '') {
        $data = array(
          'knt_code'       => $v_trx_code,
          'knt_cod1'       => $v_trx_code . '-' . $x,
          'agn_type'       => $this->request->getPost('jns_idno[' . $x . ']'),
          'agn_numb'       => $this->request->getPost('agn_numb[' . $x . ']'),
          'agn_name'       => $this->request->getPost('agn_name[' . $x . ']'),
          'agn_jtdt'       => $this->request->getPost('agn_date[' . $x . ']'),
          'agn_adrs'       => $this->request->getPost('agn_adrs[' . $x . ']'),
          'agn_loks'       => $this->request->getPost('agn_loks[' . $x . ']'),
          'agn_jens'       => $this->request->getPost('agn_jens[' . $x . ']'),
          'agn_totl'       => $agntotl,
          'agn_idno'       => $x,
          'loc_code'       => $this->request->getPost('loc_code[' . $x . ']'),

        );
        $model->_saveagunan($data);
      }
    }

    //----- end kartu Piutang----
    //update status kontrak
    // $id = $this->request->getPost('png_code');
    // $data = array(
    //   'png_kntr'  => 1,
    // );
    // $model->_approved($data, $id);
    //end status 
    return redirect()->to('pinjaman/kontrak')->with('success', 'Menambah Data Berhasil');
  }



  public function updatekontrak()
  {
    $id = $this->request->getPost('knt_code');

    $tanggal = $this->request->getPost('knt_date');
    $bulan = date('m', strtotime($tanggal));
    $tahun = date('Y', strtotime($tanggal));
    $model = new Save_model();
    $moddelete = new Delete_model();
    $kodecabang = trim(session()->get('kode_cabang'));
    $kodeproduct = trim($this->request->getPost('prd_code'));

    $periode = $this->request->getPost('knt_tenr');
    $tgljtx = $this->request->getPost('knt_jtdt');

    $tgljty = substr($tgljtx, 6, 4) . '/' . substr($tgljtx, 3, 2) . '/' . substr($tgljtx, 0, 2);
    // $tgljtx = strtotime('30/04/2024');
    $hari = substr($tgljtx, 0, 2);

    // $tgljty = $tahun  . '-' . $bulan . '-' . $hari;

    $days = is_integer($hari);
    $kin_totl = str_replace(',', '', $this->request->getPost('knt_totl'));
    $kon_prov = str_replace(',', '', $this->request->getPost('knt_prov'));
    $knt_admn = str_replace(',', '', $this->request->getPost('knt_admn'));
    $knt_asrn = str_replace(',', '', $this->request->getPost('knt_asrn'));
    $knt_tdan = str_replace(',', '', $this->request->getPost('knt_tdan'));
    $knt_matr = str_replace(',', '', $this->request->getPost('knt_matr'));
    $knt_lain = str_replace(',', '', $this->request->getPost('knt_lain'));
    $knt_tpot = str_replace(',', '', $this->request->getPost('knt_tpot'));
    $knt_tot1 = str_replace(',', '', $this->request->getPost('knt_tot1'));
    $knt_pden = str_replace(',', '', $this->request->getPost('knt_pden'));
    $knt_nden = str_replace(',', '', $this->request->getPost('knt_nden'));
    $knt_angs = str_replace(',', '', $this->request->getPost('knt_angs'));
    $knt_tmar = str_replace(',', '', $this->request->getPost('knt_tmar'));
    $knt_angp = str_replace(',', '', $this->request->getPost('knt_angp'));
    $knt_angb = str_replace(',', '', $this->request->getPost('knt_angb'));
    $knt_agun = str_replace(',', '', $this->request->getPost('knt_agun'));
    $data = array(
      // 'knt_code'       => $this->$v_trx_code,//request->getPost('knt_code'),
      'knt_date'       => $this->request->getPost('knt_date'),
      'agt_numb'       => $this->request->getPost('agt_numb'),
      'png_code'       => $this->request->getPost('png_code'),
      'prd_code'       => $this->request->getPost('prd_code'),
      'bng_type'       => $this->request->getPost('bng_type'),
      'knt_tnid'       => $this->request->getPost('knt_tnid'),
      'knt_tenr'       => $this->request->getPost('knt_tenr'),
      'knt_totl'       => $kin_totl,
      'knt_marg'       => $this->request->getPost('knt_marg'),
      'smd_code'       => $this->request->getPost('smd_code'),
      'knt_desc'       => $this->request->getPost('agt_name'),
      'knt_prov'       => $kon_prov,
      'knt_admn'       => $knt_admn,
      'knt_asrn'       => $knt_asrn,
      'knt_tdan'       => $knt_tdan,
      'knt_matr'       => $knt_matr,
      'knt_lain'       => $knt_lain,
      'knt_tpot'       => $knt_tpot,
      'knt_tot1'       => $knt_tot1,
      'knt_gper'       => $this->request->getPost('knt_gper'),
      'knt_angs'       => $knt_angs,
      'knt_angb'       => $knt_angb,
      'knt_agun'       => $knt_agun,
      'knt_angp'       => $knt_angp,
      'knt_jtdt'       => $tgljty,
      'knt_pden'       => $knt_pden,
      'knt_nden'       => $knt_nden,
      'knt_mont'       => $bulan,
      'knt_year'       => $tahun,
      'knt_days'       => $days,
      'knt_grac'       => $this->request->getPost('knt_grac'),
      'tbg_code'       => $this->request->getPost('tbg_code'),
      'knt_tmar'       => $knt_tmar,
      'knt_nmrg'       => $this->request->getPost('knt_nmrg'),
      'knt_asrk'       => $this->request->getPost('knt_asrk'),
      'knt_notr'       => $this->request->getPost('knt_notr'),
      'com_code'       => 1,
      'kode_cabang'  => session()->get('kode_cabang'),
      'emp_code'  => $this->request->getPost('emp_code'),
      'kel_code'  => $this->request->getPost('kel_code'),
      'col_code'  => $this->request->getPost('col_code'),
      'knt_stat' => 0,
      'knt_jang' => $this->request->getPost('knt_jang'),
      'knt_hari' => $this->request->getPost('jml_hari'),
    );


    //-----end save header-----
    $model->_updatekontrak($data, $id);
    //-----end save header-----
    //----- Kartu Debitur-----
    $save = 0;
    if ($save == 1) {
      $moddelete->_deletedebitur($id);


      $kode = $_POST['angsuranke'];
      if ($kode != '') {
        $jumlah = count($kode);
      } else {
        $jumlah = 0;
      }

      $tgljt = $this->request->getPost('knt_gper');


      for ($x = 0; $x < $jumlah; $x++) {

        $kode = $this->request->getPost('angsuranke[' . $x . ']');
        $knt_angp = str_replace(',', '', $this->request->getPost('pokokangsuran[' . $x . ']'));
        $knt_angb = str_replace(',', '', $this->request->getPost('pokokbunga[' . $x . ']'));
        $knt_angs = str_replace(',', '', $this->request->getPost('totansuran[' . $x . ']'));
        $knt_poko = str_replace(',', '', $this->request->getPost('pokokhutang[' . $x . ']'));
        $tgljtx1 = $this->request->getPost('tgl[' . $x . ']');
        if ($kode != '') {
          $tgljt1 = substr($tgljtx1, 6, 4) . '/' . substr($tgljtx1, 3, 2) . '/' . substr($tgljtx1, 0, 2);
          // $tgljt1 = date('Y-m-d', strtotime('+' . $x . 'month', strtotime($tgljt)));
          $data = array(

            //  'knt_code' => $this->$v_trx_code,//request->getPost('knt_code'),
            'knt_idno' => $this->request->getPost('angsuranke[' . $x . ']'),
            'knt_angp'  => $knt_angp, //$this->request->getPost('pokokangsuran[' . $x . ']'),
            'knt_angb'  => $knt_angb, //$this->request->getPost('pokokbunga[' . $x . ']'),
            'knt_angs'  => $knt_angs, //$this->request->getPost('totansuran[' . $x . ']'),
            'knt_poko'  => $knt_poko, //$this->request->getPost('pokokhutang[' . $x . ']'),
            'knt_jtdt'  => $tgljt1,
            'knt_code'  => $id,
          );
          $model->_savedebitur($data);
        }
      }
      // end Kartu debitur

      //save kartu Piutang

      for ($x = 0; $x < $jumlah; $x++) {

        $kode = $this->request->getPost('angsuranke[' . $x . ']');
        $knt_angp = str_replace(',', '', $this->request->getPost('pokokangsuran[' . $x . ']'));
        $knt_angb = str_replace(',', '', $this->request->getPost('pokokbunga[' . $x . ']'));
        $knt_angs = str_replace(',', '', $this->request->getPost('totansuran[' . $x . ']'));
        $knt_poko = str_replace(',', '', $this->request->getPost('pokokhutang[' . $x . ']'));
        $tgljtx1 = $this->request->getPost('tgl[' . $x . ']');
        if ($kode != '') {

          if ($x > 0) {
            $tgljt1 = substr($tgljtx1, 6, 4) . '/' . substr($tgljtx1, 3, 2) . '/' . substr($tgljtx1, 0, 2);
            // $tgljt1 = date('Y-m-d', strtotime('+' . $x . 'month', strtotime($tgljt)));
            $data = array(

              'trx_date' => $this->request->getPost('knt_date'),
              'agt_numb' => $this->request->getPost('agt_numb'),
              'trx_jens'  => 'AR-T007',
              'trx_amnh'  => $knt_angs, //$this->request->getPost('totansuran[' . $x . ']'),
              'trx_lnsh'  => 0,
              'lns_pokk'  => 0,
              'lns_bung'  => 0,
              'trx_angk'  => $this->request->getPost('angsuranke[' . $x . ']'),
              'bkt_code'  => $this->request->getPost('knt_code'),
              'bkt_date' => $tgljt1,
              'bkt_amnh'  => $knt_angs, //$this->request->getPost('totansuran[' . $x . ']'),
              'trx_pokk'  => $knt_angp, //$this->request->getPost('pokokangsuran[' . $x . ']'),
              'trx_bung'  => $knt_angb, //$this->request->getPost('pokokbunga[' . $x . ']'),
              'trx_jtdt'  => $tgljt1,
              'trx_code' => $id, //$this->request->getPost('knt_code'),
              'com_code'  => session()->get('com_code'),
              'kode_cabang'  => session()->get('kode_cabang'),

            );
            $model->_savekartupiutang($data);
          }
        }
      }
    }


    //----- end kartu Piutang----

    // save Agunan
    $moddelete->_deleteagunan($id);
    $kode = $_POST['jns_idno'];
    if ($kode != '') {
      $jumlah = count($kode);
    } else {
      $jumlah = 0;
    }

    for ($x = 0; $x < $jumlah; $x++) {
      $kode = $this->request->getPost('jns_idno[' . $x . ']');

      if ($kode != '') {
        $data = array(
          'knt_code'       => $this->request->getPost('knt_code'),
          'knt_cod1'       => $this->request->getPost('knt_code') . '-' . $x,
          'agn_type'       => $this->request->getPost('jns_idno[' . $x . ']'),
          'agn_numb'       => $this->request->getPost('agn_numb[' . $x . ']'),
          'agn_name'       => $this->request->getPost('agn_name[' . $x . ']'),
          'agn_jtdt'       => $this->request->getPost('agn_date[' . $x . ']'),
          'agn_adrs'       => $this->request->getPost('agn_adrs[' . $x . ']'),
          'agn_loks'       => $this->request->getPost('agn_loks[' . $x . ']'),
          'agn_jens'       => $this->request->getPost('agn_jens[' . $x . ']'),
          'agn_totl'       => $this->request->getPost('agn_totl[' . $x . ']'),
          'agn_idno'       => $x,
          'loc_code'       => $this->request->getPost('loc_code[' . $x . ']'),

        );
        $model->_saveagunan($data);
      }
    }

    //update status kontrak
    $id = $this->request->getPost('png_code');
    $data = array(
      'png_kntr'  => 1,
    );
    $model->_approved($data, $id);
    //end status


    return redirect()->to('pinjaman/kontrak')->with('success', 'Merubah Data Berhasil');
  }

  public function saverestruktur()
  {
    $model = new Save_model();
    $mdelete = new Delete_model();
    $id = $this->request->getPost('knt_code');
    $tanggal = $this->request->getPost('knt_gper');
    $tanggal1 = $this->request->getPost('knt_dres');
    $bulan = date('m', strtotime($tanggal));
    $tahun = date('Y', strtotime($tanggal));

    $kin_totl = str_replace(',', '', $this->request->getPost('knt_totl'));
    $kon_prov = str_replace(',', '', $this->request->getPost('knt_prov'));
    $knt_admn = str_replace(',', '', $this->request->getPost('knt_admn'));
    $knt_asrn = str_replace(',', '', $this->request->getPost('knt_asrn'));
    $knt_tdan = str_replace(',', '', $this->request->getPost('knt_tdan'));
    $knt_matr = str_replace(',', '', $this->request->getPost('knt_matr'));
    $knt_lain = str_replace(',', '', $this->request->getPost('knt_lain'));
    $knt_tpot = str_replace(',', '', $this->request->getPost('knt_tpot'));
    $knt_tot1 = str_replace(',', '', $this->request->getPost('knt_tot1'));
    $knt_pden = str_replace(',', '', $this->request->getPost('knt_pden'));
    $knt_nden = str_replace(',', '', $this->request->getPost('knt_nden'));
    $knt_angs = str_replace(',', '', $this->request->getPost('knt_angs'));
    $knt_rest = str_replace(',', '', $this->request->getPost('knt_rest'));
    $knt_tmar = str_replace(',', '', $this->request->getPost('knt_tmar'));
    $data = array(
      'knt_code'       => $this->request->getPost('knt_code'),
      'agt_numb'       => $this->request->getPost('agt_numb'),
      'png_code'       => $this->request->getPost('png_code'),
      'prd_code'       => $this->request->getPost('prd_code'),
      'bng_type'       => $this->request->getPost('bng_type'),
      'knt_tnid'       => $this->request->getPost('knt_tnid'),
      'knt_tenr'       => $this->request->getPost('knt_tenr'),
      'knt_totl'       => $kin_totl,
      'knt_marg'       => $this->request->getPost('knt_marg'),
      'smd_code'       => $this->request->getPost('smd_code'),
      'knt_desc'       => $this->request->getPost('knt_desc'),
      'knt_prov'       => $kon_prov,
      'knt_admn'       => $knt_admn,
      'knt_asrn'       => $knt_asrn,
      'knt_tdan'       => $knt_tdan,
      'knt_matr'       => $knt_matr,
      'knt_lain'       => $knt_lain,
      'knt_tpot'       => $knt_tpot,
      'knt_tot1'       => $knt_tot1,
      'knt_gper'       => $this->request->getPost('knt_gper'),
      'knt_angs'       => $knt_angs,
      'knt_angb'       => $this->request->getPost('knt_angb'),
      'knt_angp'       => $this->request->getPost('knt_angp'),
      'knt_jtdt'       => $this->request->getPost('knt_jtdt'),
      'knt_pden'       => $knt_pden,
      'knt_nden'       => $knt_nden,
      'knt_mont'       => $bulan,
      'knt_year'       => $tahun,
      'tbg_code'       => $this->request->getPost('tbg_code'),
      'knt_grac'       => $this->request->getPost('knt_grac'),
      'knt_tmar'       => $knt_tmar,
      'knt_tres'       => $knt_rest,
      'knt_dres'       => $this->request->getPost('knt_dres'),
      'knt_tnrs'       => $this->request->getPost('knt_tnrs'),
      'knt_mflt'       => $this->request->getPost('knt_mflt'),
      'knt_mrfk'       => $this->request->getPost('knt_mrfk'),
      'knt_manu'       => $this->request->getPost('knt_manu'),
      'knt_tang'       => $this->request->getPost('knt_tang'),
      'knt_extc'       => $this->request->getPost('knt_extc'),

      // 'knt_stat' => 0,
    );

    $model->_updatekontrak($data, $id);
    //-----end save header-----
    //----- Kartu Debitur-----
    // $save = 0;
    // if ($save == 1) {
    $mdelete->_kontrakdtltop($id, $tanggal1);


    $kode = $_POST['angsuranke'];
    if ($kode != '') {
      $jumlah = count($kode);
    } else {
      $jumlah = 0;
    }

    $tgljt = $this->request->getPost('knt_jtdt');


    for ($x = 0; $x < $jumlah; $x++) {

      $kode = $this->request->getPost('angsuranke[' . $x . ']');
      $knt_angp = str_replace(',', '', $this->request->getPost('pokokangsuran[' . $x . ']'));
      $knt_angb = str_replace(',', '', $this->request->getPost('pokokbunga[' . $x . ']'));
      $knt_angs = str_replace(',', '', $this->request->getPost('totansuran[' . $x . ']'));
      $knt_poko = str_replace(',', '', $this->request->getPost('pokokhutang[' . $x . ']'));

      if ($kode != '') {
        $tgljt1 = date('Y-m-d', strtotime('+' . $x . 'month', strtotime($tgljt)));
        $data = array(

          //  'knt_code' => $this->$v_trx_code,//request->getPost('knt_code'),
          'knt_idno' => $this->request->getPost('angsuranke[' . $x . ']'),
          'knt_angp'  => $knt_angp, //$this->request->getPost('pokokangsuran[' . $x . ']'),
          'knt_angb'  => $knt_angb, //$this->request->getPost('pokokbunga[' . $x . ']'),
          'knt_angs'  => $knt_angs, //$this->request->getPost('totansuran[' . $x . ']'),
          'knt_poko'  => $knt_poko, //$this->request->getPost('pokokhutang[' . $x . ']'),
          'knt_jtdt'  => $tgljt1,
          'knt_code'  => $id,
        );
        $model->_savedebitur($data);
      }
    }
    // end Kartu debitur

    //save kartu Piutang
    $mdelete->_kartupiutangtop($id, $tanggal1);
    for ($x = 0; $x < $jumlah; $x++) {

      $kode = $this->request->getPost('angsuranke[' . $x . ']');
      $knt_angp = str_replace(',', '', $this->request->getPost('pokokangsuran[' . $x . ']'));
      $knt_angb = str_replace(',', '', $this->request->getPost('pokokbunga[' . $x . ']'));
      $knt_angs = str_replace(',', '', $this->request->getPost('totansuran[' . $x . ']'));
      $knt_poko = str_replace(',', '', $this->request->getPost('pokokhutang[' . $x . ']'));
      if ($kode != '') {

        if ($x > 0) {
          $tgljt1 = date('Y-m-d', strtotime('+' . $x . 'month', strtotime($tgljt)));
          $data = array(

            'trx_date' => $this->request->getPost('knt_gper'),
            'agt_numb' => $this->request->getPost('agt_numb'),
            'trx_jens'  => 'AR-T007',
            'trx_amnh'  => $knt_angs, //$this->request->getPost('totansuran[' . $x . ']'),
            'trx_lnsh'  => 0,
            'lns_pokk'  => 0,
            'lns_bung'  => 0,
            'trx_angk'  => $this->request->getPost('angsuranke[' . $x . ']'),
            'bkt_code'  => $this->request->getPost('knt_code'),
            'bkt_date' => $this->request->getPost('knt_gper'),
            'bkt_amnh'  => $knt_angs, //$this->request->getPost('totansuran[' . $x . ']'),
            'trx_pokk'  => $knt_angp, //$this->request->getPost('pokokangsuran[' . $x . ']'),
            'trx_bung'  => $knt_angb, //$this->request->getPost('pokokbunga[' . $x . ']'),
            'trx_jtdt'  => $tgljt1,
            'trx_code' => $id, //$this->request->getPost('knt_code'),
            'kode_cabang'  => session()->get('kode_cabang'),
          );
          $model->_savekartupiutang($data);
        }
      }
    }



    //----- end kartu Piutang----

    // save Agunan
    $mdelete->_deleteagunan($id);
    $kode = $_POST['jns_idno'];
    if ($kode != '') {
      $jumlah = count($kode);
    } else {
      $jumlah = 0;
    }


    for ($x = 0; $x < $jumlah; $x++) {
      $kode = $this->request->getPost('jns_idno[' . $x . ']');

      if ($kode != '') {
        $data = array(
          'knt_code'       => $this->request->getPost('knt_code'),
          'knt_cod1'       => $this->request->getPost('knt_code') . '-' . $x,
          'agn_type'       => $this->request->getPost('jns_idno[' . $x . ']'),
          'agn_numb'       => $this->request->getPost('agn_numb[' . $x . ']'),
          'agn_name'       => $this->request->getPost('agn_name[' . $x . ']'),
          'agn_jtdt'       => $this->request->getPost('agn_date[' . $x . ']'),
          'agn_adrs'       => $this->request->getPost('agn_adrs[' . $x . ']'),
          'agn_loks'       => $this->request->getPost('agn_loks[' . $x . ']'),
          'agn_jens'       => $this->request->getPost('agn_jens[' . $x . ']'),
          'agn_totl'       => $this->request->getPost('agn_totl[' . $x . ']'),
          'agn_idno'       => $x,
          'loc_code'       => $this->request->getPost('loc_code[' . $x . ']'),

        );
        $model->_saveagunan($data);
      }
    }

    //update status kontrak
    // $id = $this->request->getPost('png_code');
    // $data = array(
    //   'png_kntr'  => 1,
    // );
    // $model->_approved($data, $id);
    //end status


    return redirect()->to('pinjaman/restrukturisasi')->with('success', 'Menambah Data Berhasil');
  }
  public function  deletekontrak($id)
  {
    $model = new Delete_model();
    // $id = $this->request->getPost('code');
    $model->_kontrakheader($id);
    $model->_kontrakdtl($id);
    $model->_kartupiutang($id);

    return redirect()->to('pinjaman/kontrak')->with('success', 'Menghapus Data Berhasil');
  }

  public  function koreksipinjaman()
  {
    $model = new Model_git();
    $_SESSION['com_menu'] = '04';
    $_SESSION['com_men1'] = '0403';
    $_SESSION['com_men2'] = '040302';

    // if ($_SESSION['usr_jabt'] == 'Administrator') {
    //   $data['v_kontrak']  = $model->_get_kontrakla($tanggal)->getResult();
    // } else {
    //   $data['v_kontrak']  = $model->_get_kontrakl($tanggal, session()->get('kode_cabang'))->getResult();
    // }

    $data['v_kontrak']  = $model->_get_kontrak()->getResult();
    return view('pinjaman/kontrak/kontrak_listedit', $data);
  }

  public function restrukturisasi()
  {
    $model = new Model_git();
    $_SESSION['com_menu'] = '04';
    $_SESSION['com_men1'] = '0403';
    $_SESSION['com_men2'] = '040302';

    $data['v_anggota'] = $model->_get_lkontrak()->getResult();
    return view('pinjaman/restruktur/restruktur_add', $data);
  }

  public function hapusbukupembiyaan()
  {
    $model = new Model_git();
    $_SESSION['com_menu'] = '04';
    $_SESSION['com_men1'] = '0403';
    $_SESSION['com_men2'] = '040302';
    $data['v_anggota'] = $model->_get_lkontrak()->getResult();

    return view('pinjaman/hapusbuku/hapusbuku_add', $data);
  }

  public function savehapusbuku()
  {
    $model = new Save_model();
    $v_trx_code = '';
    $data = array(
      'hps_code' => $v_trx_code,
      'hps_date' => $v_trx_code,
      'agt_numb' => $v_trx_code,
      'hps_totl' => $v_trx_code,
      'hps_bung' => $v_trx_code,
      'hps_dend' => $v_trx_code,
      'hps_rest' => $v_trx_code,
    );
    $model->_savehapusbuku($data);
  }



  public function hapustranpembiayaan()
  {

    $model = new Model_git();
    $mdelete = new Delete_model();

    $kode = $_POST['code1'];
    if ($kode == '') {
      $jumlah = 0;
    } else {
      $jumlah = count($kode);
    }


    for ($x = 0; $x < $jumlah; $x++) {
      $x1 = $x + 1;
      $kode1 = $this->request->getPost('code1[' . $x . ']');

      if ($kode1 != '') {
        $id = $this->request->getPost('cek[' . $x . ']');


        $mdelete->m_deletekaspembiayaan($id);
        $mdelete->_deletejurnal($id);
      }
    }
    $tanggal1 = $this->request->getPost('trx_date');
    $tanggal2 = $this->request->getPost('trx_dat1');

    $data['tgl1'] = $tanggal1;
    $data['tgl2'] = $tanggal2;

    $data['v_kas']  = $model->_get_loaddpembiyaan($tanggal1, $tanggal2)->getResult();
    return view('pinjaman/kontrak/kontrak_delete', $data);
  }

  public function hapusbukupembiayaan()
  {

    $model = new Save_model();
    $modecek = new Auto_model();
    $tanggal = $this->request->getPost('hps_date');

    $bulan = date('m', strtotime($tanggal));
    $tahun = date('Y', strtotime($tanggal));
    $cek = $modecek->get_nohpsbukupembiayaan($bulan, $tahun);
    if ($bulan < 10) {
      $bulan1 = '0' . $bulan;
    } else {
      $bulan1 = $bulan;
    }

    $nourut = $cek['hps_srno'];
    $kodecabang = session()->get('kode_cabang');
    if ($nourut == '') {
      $nourut = 1;
      $v_trx_code = $kodecabang . '02.' . $tahun . $bulan . '00001';
    } else {
      $nourut = $nourut + 1;
      if ($nourut < 10) {
        $v_trx_code = $kodecabang . '02.' . $tahun . $bulan . '0000' . $nourut;
      } else if ($nourut >= 10 and $nourut < 100) {
        $v_trx_code = $kodecabang . '02.' . $tahun . $bulan . '000' . $nourut;
      } else if ($nourut >= 100 and $nourut < 1000) {
        $v_trx_code = $kodecabang . '02.' . $tahun . $bulan . '00' . $nourut;
      } else if ($nourut >= 1000 and $nourut < 10000) {
        $v_trx_code = $kodecabang . '02.' . $tahun . $bulan . '0' . $nourut;
      } else {
        $v_trx_code = $kodecabang . '02.' . $tahun . $bulan . $nourut;
      }
    }


    $total = str_replace(',', '', $this->request->getPost('hps_totl'));
    $bunga = str_replace(',', '', $this->request->getPost('hps_bung'));
    $denda = str_replace(',', '', $this->request->getPost('hps_dend'));
    $restruktur = str_replace(',', '', $this->request->getPost('hps_rest'));
    $data = array(
      'hps_code' => $v_trx_code,
      'hps_date' => $this->request->getPost('hps_date'),
      'hps_mont' => $bulan,
      'hps_year' => $tahun,
      'knt_code' =>  $this->request->getPost('hps_date'),
      'agt_numb' =>  $this->request->getPost('agt_numb'),
      'hps_totl' => $total,
      'hps_bung' => $bunga,
      'hps_dend' => $denda,
      'hps_rest' => $restruktur,
      'hps_srno' => $nourut,
      'com_code'  => session()->get('com_code'),
      'kode_cabang'  => session()->get('kode_cabang'),
    );
    $model->_savehapusbuku($data);
    return redirect()->to('pinjaman/hapusbukupembiyaan')->with('success', 'Simpan Data Berhasil');
  }



  public function hapusppap()
  {
    $model = new Model_git();
    $_SESSION['com_menu'] = '04';
    $_SESSION['com_men1'] = '0403';
    $_SESSION['com_men2'] = '040302';
    $tanggal1 = '';
    $tanggal2 = '';
    $data['v_data'] = $model->_get_dttkreapp($tanggal1, $tanggal2)->getResult();
    return view('pinjaman/hapusppap/hapusppap_list', $data);
  }

  public function hapuskreapp()
  {
    $model = new Delete_model();
    // $msave = new Save_model();
    $kode = $_POST['code1'];
    if ($kode == '') {
      $jumlah = 0;
    } else {
      $jumlah = count($kode);
    }


    for ($x = 0; $x < $jumlah; $x++) {
      $x1 = $x + 1;
      $kode1 = $this->request->getPost('code1[' . $x . ']');

      if ($kode1 != '') {
        $id = $this->request->getPost('cek[' . $x . ']');
        $model->_deletekreapp($id);
      }
    }
    $model = new Model_git();
    $tanggal1 = $this->request->getPost('trx_date');
    $tanggal2 = $this->request->getPost('trx_dat1');
    $data['tgl1'] = $tanggal1;
    $data['tgl2'] = $tanggal2;
    $data['v_data'] = $model->_get_dttkreapp($tanggal1, $tanggal2)->getResult();
    return view('pinjaman/hapusppap/hapusppap_list', $data);
  }

  public function dafarpembiayaan()
  {
    $model = new Model_git();
    $_SESSION['com_menu'] = '04';
    $_SESSION['com_men1'] = '0403';
    $_SESSION['com_men2'] = '';
    $tanggal1 = date('Y/m/d');
    $tanggal2 = date('Y/m/d');
    $cabang  = session()->get('kode_cabang');
    if ($_SESSION['usr_jabt'] == 'Administrator') {
      $data['v_kontrak']  = $model->_get_dftpembiayaan($tanggal1, $tanggal2)->getResult();
    } else {
      $data['v_kontrak']  = $model->_get_dftpembiayaancab($tanggal1, $tanggal2, $cabang)->getResult();
    }

    return view('pinjaman/kontrak/kontrak_daftar', $data);
  }

  public function cancelpembiayaan()
  {
    $model = new Save_model();
    $id = $this->request->getPost('code');
    $data = array(

      'knt_stat' => 3,
      // 'tbg_clos' => date('Y-m-d'),
      // 'tbg_desc' => $this->request->getPost('tbg_desc'),
    );
    $model->_updatekontrak($data, $id);
    return redirect()->to('pinjaman/kontrak')->with('success', 'Pembatalan Data Berhasil');
  }
  //End
}
