<?php

namespace App\Controllers;


use App\Models\Delete_model;
use App\Models\Master_model;
use App\Models\Model_git;
use App\Models\Report_model;
use App\Models\Save_model;
use App\Libraries\MY_TCPDF as TCPDF;

class Printreport extends BaseController
{

    public function __construct()
    {
        $session = session();
        date_default_timezone_set('Asia/Jakarta');
    }
    public function get_ssbjatuhtempo()
    {
        $model = new Report_Model();
        $productid = $this->request->getPost('id');
        $bulan = $this->request->getPost('bulan');
        $tahun = $this->request->getPost('tahun');
        $data = $model->_get_deposito($productid, $bulan, $tahun)->getResult();
        echo json_encode($data);
    }




    public function get_jurnalharian()
    {
        $model = new Report_Model();
        $id = $this->request->getPost('id');
        $id1 = $this->request->getPost('id1');
        $data = $model->_get_jurnal($id, $id1)->getResult();
        echo json_encode($data);
    }

    public function get_simpanan()
    {
        $model = new Report_Model();
        $productid = $this->request->getPost('id');
        $bulan = $this->request->getPost('bulan');
        $tahun = $this->request->getPost('tahun');
        $data = $model->_get_simpanan($productid, $bulan, $tahun)->getResult();
        echo json_encode($data);
    }



    public function get_rbukutabungan()
    {
        $model = new Report_Model();
        $norekening = $this->request->getPost('norekening');
        $tanggal1 = $this->request->getPost('tanggal1');
        $tanggal2 = $this->request->getPost('tanggal2');
        $data = $model->_get_bukutabungan($norekening, $tanggal1, $tanggal2)->getResult();
        echo json_encode($data);
    }

    public function printbukutabungan()
    {
        $model = new Report_Model();
        $norekening = $this->request->getPost('tbg_code');
        $tanggal1 = $this->request->getPost('trx_date');
        $tanggal2 = $this->request->getPost('trx_dat1');


        $data['v_tabungan'] = $model->_get_bukutabungan($norekening, $tanggal1, $tanggal2)->getResult();
        return view('print/rptbukutabungan', $data);
    }


    public function get_rangsuran()
    {
        $model = new Report_Model();
        $id = $this->request->getPost('id');
        $data = $model->_get_kartuangsuran($id)->getResult();
        echo json_encode($data);
    }

    public function printkartuangsuran()
    {
        $model = new Report_Model();
        $id = $this->request->getPost('kin_type');
        $data['v_kartu'] = $model->_get_kartuangsuran($id)->getResult();
        return view('print/rptkartuangsuran', $data);
    }

    public function deposito()
    {
        $model = new Master_model();
        $id = 'D';
        $data['v_tahun']  = $model->_get_tahun()->getResult();
        $data['v_product']  = $model->_get_productb($id)->getResult();
        return view('report/ssbjatuhtempo', $data);
    }

    public function printssbjatuhtempo()
    {

        $model = new Report_Model();
        $productid = $this->request->getPost('kin_type');
        $bulan = $this->request->getPost('kin_buln');
        $tahun = $this->request->getPost('kin_tahn');
        $data['v_ssb'] = $model->_get_deposito($productid, $bulan, $tahun)->getResult();

        return view('print/ssbjatuhtempo', $data);
    }

    public function get_pengajuan()
    {
        $model = new Report_Model();
        $bulan = $this->request->getPost('bulan');
        $tahun = $this->request->getPost('tahun');
        $data = $model->_get_pengajuan($bulan, $tahun)->getResult();
        echo json_encode($data);
    }

    public function printpengajuan()
    {
        $model = new Report_Model();
        $bulan = $this->request->getPost('kin_buln');
        $tahun = $this->request->getPost('kin_tahn');
        $data['v_pengajuan'] = $model->_get_pengajuan($bulan, $tahun)->getResult();
        return view('print/rptpengajuan', $data);
    }


    public function get_penutupan()
    {
        $model = new Report_Model();
        $bulan = $this->request->getPost('bulan');
        $tahun = $this->request->getPost('tahun');
        $data = $model->_get_penutupan($bulan, $tahun)->getResult();
        echo json_encode($data);
    }


    public function printpenutupan()
    {
        $model = new Report_Model();
        $bulan = $this->request->getPost('kin_buln');
        $tahun = $this->request->getPost('kin_tahn');
        $data['v_penutupan'] = $model->_get_penutupan($bulan, $tahun)->getResult();
        return view('print/rptpenutupan', $data);
    }

    public function bukubesar()
    {
        $model = new Master_model();
        $data['v_account']  = $model->_get_account()->getResult();

        return view('report/bukubesar', $data);
    }

    public function get_bukubesar()
    {
        $model = new Report_Model();
        $norekening = $this->request->getPost('norekening');
        $tanggal1 = $this->request->getPost('tanggal1');
        $tanggal2 = $this->request->getPost('tanggal2');
        $data = $model->_get_bukubesar($norekening, $tanggal1, $tanggal2)->getResult();
        echo json_encode($data);
    }


    public function get_saldoawal()
    {
        $model = new Report_Model();
        $norekening = $this->request->getPost('norekening');
        $tanggal1 = $this->request->getPost('tanggal1');
        $data = $model->_get_saldoawal($norekening, $tanggal1)->getResult();
        echo json_encode($data);
    }

    public function jasadeposito()
    {
        $model = new Master_model();
        $data['v_tahun']  = $model->_get_tahun()->getResult();

        return view('report/jasadeposito', $data);
    }
    public function get_bungadeposito()
    {
        $model = new Report_Model();
        $bulan = $this->request->getPost('bulan');
        $tahun = $this->request->getPost('tahun');
        $data = $model->_get_bungadeposito($bulan, $tahun)->getResult();
        echo json_encode($data);
    }

    public function printjasadeposito()
    {

        $model = new Report_Model();
        $bulan = $this->request->getPost('kin_buln');
        $tahun = $this->request->getPost('kin_tahn');
        $data['v_ssb'] = $model->_get_bungadeposito($bulan, $tahun)->getResult();


        return view('print/rptjasassb', $data);
    }

    public function printbukubesar()
    {
        $model = new Report_Model();
        $norekening = $this->request->getPost('tbg_code');
        $tanggal1 = $this->request->getPost('trx_date');
        $tanggal2 = $this->request->getPost('trx_dat1');
        $data['v_saldoawal'] = $model->_get_saldoawal($norekening, $tanggal1)->getResult();
        $data['v_bukubesar'] = $model->_get_bukubesar($norekening, $tanggal1, $tanggal2)->getResult();
        return view('print/rptbukubesar', $data);
    }
    public function neracasaldo()
    {
        $model = new Master_model();
        $data['v_tahun']  = $model->_get_tahun()->getResult();

        return view('report/neracasaldo', $data);
    }
    public function get_neracasaldo()
    {
        $model = new Report_Model();
        $bulan = $this->request->getPost('bulan');
        $tahun = $this->request->getPost('tahun');
        $data = $model->_get_neracasaldo($bulan, $tahun)->getResult();
        echo json_encode($data);
    }

    public function printneracasaldo()
    {
        $model = new Report_Model();
        $bulan = $this->request->getPost('kin_buln');
        $tahun = $this->request->getPost('kin_tahn');
        $data['v_neracasaldo'] = $model->_get_neracasaldo($bulan, $tahun)->getResult();
        return view('print/rptneracasaldo', $data);
    }

    public function rugilaba()
    {
        $model = new Master_model();
        $data['v_tahun']  = $model->_get_tahun()->getResult();

        return view('report/labarugi', $data);
    }
    public function get_labarugi()
    {
        $model = new Report_Model();
        $modsave = new Save_model();
        $moddel = new  Delete_model();
        $bulan = $this->request->getPost('bulan');
        $tahun = $this->request->getPost('tahun');
        $id = 1;
        $delaccount = $moddel->m_delrugulaba($id);

        $account = $model->_get_labarugi();
        $trx_amnt = 0;
        $i = 0;
        $total = 0;
        $subtotal = 0;
        $v_level = '';
        $v_umum = '';
        $total = 0;
        foreach ($account->getResult()  as $row) {
            $acc_code = $row->acc_code;
            $i = $i + 1;
            $subtotal = 0;
            $data = array(
                'acod1'       => $row->acc_code,
                'urut'        => $i,
                'aname1'      => $row->acc_name,
                'fnilai1'     => '',
                'com_code'    => 1,
                'acc_levl'    => $row->acc_levl,
            );
            $modsave->_saverugilaba($data);

            $dtaccount = $model->_get_labarugi1($acc_code);

            foreach ($dtaccount->getResult()  as $row1) {
                $v_acc_code1 = $row1->acc_code;

                $i = $i + 1;
                $nilai = $model->_get_nilai($v_acc_code1, $bulan, $tahun);
                $trx_amnt = 0;

                foreach ($nilai->getResult()  as $nil) {
                    $trx_amnt = $nil->acc_akhc;
                }

                $subtotal = $subtotal + $trx_amnt;
                if ($row->acc_nblc == 'K') {
                    $total = $total + $trx_amnt;
                } else {
                    $total = $total - $trx_amnt;
                }

                if ($trx_amnt != 0) {
                    $data = array(
                        'acod1'       => $v_acc_code1,
                        'urut'        => $i,
                        'aname1'      => $row1->acc_name,
                        'fnilai1'     =>  $trx_amnt,
                        'com_code'    => 1,
                        'acc_levl'    => $row1->acc_levl,
                    );
                    $modsave->_saverugilaba($data);
                }
            }

            // sub total
            if ($subtotal != 0) {
                $i = $i + 1;

                //  $subtotal=$subtotal+$trx_amnt;

                $data = array(
                    'acod1'       => 'BRS', //$row->acc_code
                    'urut'        => $i,
                    'aname1'      => 'SUB TOTAL ' . $row->acc_name,
                    'fnilai1'     =>  $subtotal,
                    'com_code'    => 1,
                    'acc_levl'    => $row->acc_levl,
                );
                $modsave->_saverugilaba($data);
            }
        }

        $i = $i + 1;

        //  $subtotal=$subtotal+$trx_amnt;
        $rugilaba = "LABA";
        if ($total < 0) {
            $rugilaba = "RUGI";
        }

        $data = array(
            'acod1'       => $row->acc_code,
            'urut'        => $i,
            'aname1'      => $rugilaba,
            'fnilai1'     =>  $total,
            'com_code'    => 1,
            'acc_levl'    => $row->acc_levl,
        );
        $modsave->_saverugilaba($data);

        $data = $model->_get_txlabarugi()->getResult();
        echo json_encode($data);
    }
    public function get_labarugi1() {}


    public function printrugilaba()
    {
        $model = new Report_Model();
        $modsave = new Save_model();
        $moddel = new  Delete_model();
        $bulan = $this->request->getPost('kin_buln');
        $tahun = $this->request->getPost('kin_tahn');
        $hari_ini = $tahun . '-' . $bulan . '-01'; // date("Y-m-d");
        $tgl_pertama = date('Y-m-01', strtotime($hari_ini));
        $tgl_terakhir = date('Y-m-t', strtotime($hari_ini));
        $id = 1;
        $delaccount = $moddel->m_delrugulaba($id);

        $account = $model->_get_labarugi();
        $trx_amnt = 0;
        $i = 0;
        $total = 0;
        $subtotal = 0;
        $v_level = '';
        $v_umum = '';
        $total = 0;
        foreach ($account->getResult()  as $row) {
            $acc_code = $row->acc_code;
            $i = $i + 1;
            $subtotal = 0;
            $data = array(
                'acod1'       => $row->acc_code,
                'urut'        => $i,
                'aname1'      => $row->acc_name,
                'fnilai1'     => '',
                'com_code'    => 1,
                'acc_levl'    => $row->acc_levl,
                'trx_date'    => $tgl_terakhir,
            );
            $modsave->_saverugilaba($data);

            $dtaccount = $model->_get_labarugi1($acc_code);

            foreach ($dtaccount->getResult()  as $row1) {
                $v_acc_code1 = $row1->acc_code;

                $i = $i + 1;
                $nilai = $model->_get_nilai($v_acc_code1, $bulan, $tahun);
                $trx_amnt = 0;

                foreach ($nilai->getResult()  as $nil) {
                    $trx_amnt = $nil->acc_akhc;
                }

                $subtotal = $subtotal + $trx_amnt;
                if ($row->acc_nblc == 'K') {
                    $total = $total + $trx_amnt;
                } else {
                    $total = $total - $trx_amnt;
                }

                if ($trx_amnt != 0) {
                    $data = array(
                        'acod1'       => $v_acc_code1,
                        'urut'        => $i,
                        'aname1'      => $row1->acc_name,
                        'fnilai1'     =>  $trx_amnt,
                        'com_code'    => 1,
                        'acc_levl'    => $row1->acc_levl,
                        'trx_date'    => $tgl_terakhir,
                    );
                    $modsave->_saverugilaba($data);
                }
            }

            // sub total
            if ($subtotal != 0) {
                $i = $i + 1;

                //  $subtotal=$subtotal+$trx_amnt;

                $data = array(
                    'acod1'       => 'BRS', //$row->acc_code
                    'urut'        => $i,
                    'aname1'      => 'SUB TOTAL ' . $row->acc_name,
                    'fnilai1'     =>  $subtotal,
                    'com_code'    => 1,
                    'acc_levl'    => $row->acc_levl,
                    'trx_date'    => $tgl_terakhir,
                );
                $modsave->_saverugilaba($data);
            }
        }

        $i = $i + 1;

        //  $subtotal=$subtotal+$trx_amnt;
        $rugilaba = "LABA";
        if ($total < 0) {
            $rugilaba = "RUGI";
        }

        $data = array(
            'acod1'       => $row->acc_code,
            'urut'        => $i,
            'aname1'      => $rugilaba,
            'fnilai1'     =>  $total,
            'com_code'    => 1,
            'acc_levl'    => $row->acc_levl,
            'trx_date'    => $tgl_terakhir,
        );
        $modsave->_saverugilaba($data);

        $data['v_rugilba'] = $model->_get_txlabarugi()->getResult();
        return view('print/rptrugilaba', $data);
    }

    public function neraca()
    {
        $model = new Master_model();
        $data['v_tahun']  = $model->_get_tahun()->getResult();

        return view('report/neraca', $data);
    }

    public function get_neraca()
    {
        $model = new Report_Model();
        $modsave = new Save_model();
        $moddel = new  Delete_model();
        $bulan = $this->request->getPost('bulan');
        $tahun = $this->request->getPost('tahun');
        $id = 1;
        $delaccount = $moddel->m_delneraca($id);
        $acc_klas1 = '1';
        $acc_klas2 = '1';
        $account = $model->_get_neraca($acc_klas1, $acc_klas2);
        $trx_amnt = 0;
        $i = 0;
        $total = 0;
        $subtotal = 0;
        $v_level = '';
        $v_umum = '';
        $total = 0;
        $i = $i + 1;
        $subtotal = 0;
        $data = array(
            'acc_cod1'       => 1,
            'urut'        => $i,
            'acc_nam1'      => 'AKTIVA',
            'acc_nil1'     => '',
            'com_code'    => 1,
            'acc_levl'    => 1,
        );
        $modsave->_saveneraca($data);
        foreach ($account->getResult()  as $row) {
            $acc_code = $row->acc_code;
            $i = $i + 1;
            $subtotal = 0;
            $data = array(
                'acc_cod1'       => $row->acc_code,
                'urut'        => $i,
                'acc_nam1'      => $row->acc_name,
                'acc_nil1'     => '',
                'com_code'    => 1,
                'acc_levl'    => $row->acc_levl,
            );
            $modsave->_saveneraca($data);

            $dtaccount = $model->_get_neraca1($acc_code);

            foreach ($dtaccount->getResult()  as $row1) {
                $v_acc_code1 = $row1->acc_code;

                //  $i=$i+1;
                $nilai = $model->_get_nilai($v_acc_code1, $bulan, $tahun);
                $trx_amnt = 0;

                foreach ($nilai->getResult()  as $nil) {
                    $trx_amnt = $nil->acc_akhc;
                }

                $subtotal = $subtotal + $trx_amnt;
                if ($row->acc_nblc == 'K') {
                    $total = $total - $trx_amnt;
                } else {
                    $total = $total + $trx_amnt;
                }

                if ($trx_amnt != 0) {
                    $i = $i + 1;
                    $data = array(
                        'acc_cod1'       => $v_acc_code1,
                        'urut'        => $i,
                        'acc_nam1'      => $row1->acc_name,
                        'acc_nil1'     => $trx_amnt,
                        'com_code'    => 1,
                        'acc_levl'    => $row1->acc_levl,


                    );
                    $modsave->_saveneraca($data);
                }
            }

            // sub total
            if ($subtotal != 0) {
                $i = $i + 1;

                //  $subtotal=$subtotal+$trx_amnt;

                $data = array(

                    'acc_cod1'    => 'BRS',
                    'urut'        => $i,
                    'acc_nam1'    => 'SUB TOTAL ' . $row->acc_name,
                    'acc_nil1'    => $subtotal,
                    'com_code'    => 1,
                    'acc_levl'    => $row->acc_levl,

                );
                $modsave->_saveneraca($data);
            }
        }



        //  $subtotal=$subtotal+$trx_amnt;


        $i = $i + 1;
        $baris = $i;
        $data = array(
            'acc_cod1'    => $row->acc_code,
            'urut'        => $i,
            'acc_nam1'    => 'TOTAL AKTIVA',
            'acc_nil1'    => $total,
            'com_code'    => 1,
            'acc_levl'    => $row->acc_levl,

        );
        $modsave->_saveneraca($data);

        /// Pasiva
        $acc_klas1 = '2';
        $acc_klas2 = '3';
        $account = $model->_get_neracap($acc_klas1, $acc_klas2);
        $trx_amnt = 0;
        $i = 0;
        $total = 0;
        $subtotal = 0;
        $v_level = '';
        $v_umum = '';
        $total = 0;
        $i = $i + 1;
        $id = $i;
        $data = array(
            'acc_cod2'     => 3,
            'acc_nam2'     => 'PASIVA',
            'acc_nil2'     => '',
            'acc_lev2'     => 1,
        );
        $modsave->_updateneraca($data, $id);
        foreach ($account->getResult()  as $row) {
            $acc_code = $row->acc_code;
            $i = $i + 1;
            $subtotal = 0;
            $id = $i;
            $data = array(
                'acc_cod2'     => $row->acc_code,
                'acc_nam2'     => $row->acc_name,
                'acc_nil2'     => '',
                'acc_lev2'     => $row->acc_levl,
            );
            $modsave->_updateneraca($data, $id);

            $dtaccount = $model->_get_neraca1p($acc_code);

            foreach ($dtaccount->getResult()  as $row1) {
                $v_acc_code1 = $row1->acc_code;

                $nilai = $model->_get_nilai($v_acc_code1, $bulan, $tahun);

                $trx_amnt = 0;

                foreach ($nilai->getResult()  as $nil) {
                    $trx_amnt = $nil->acc_akhc;
                }

                $subtotal = $subtotal + $trx_amnt;
                if ($row->acc_nblc == 'K') {
                    $total = $total - $trx_amnt;
                    //  $subtotal=$subtotal-$trx_amnt;
                } else {
                    $total = $total + $trx_amnt;
                    //  $subtotal=$subtotal+$trx_amnt;
                }

                if ($trx_amnt != 0) {
                    $i = $i + 1;
                    $id = $i;
                    $data = array(

                        'acc_cod2'    => $v_acc_code1,
                        'acc_nam2'    => $row1->acc_name,
                        'acc_nil2'    => $trx_amnt,
                        'acc_lev2'    => $row1->acc_levl,


                    );
                    $modsave->_updateneraca($data, $id);
                }
            }

            // sub total

            if ($subtotal != 0) {
                $i = $i + 1;

                //  $subtotal=$subtotal+$trx_amnt;
                $id = $i;
                $data = array(

                    'acc_cod2'    => 'BRS',
                    'acc_nam2'    => 'SUB TOTAL ' . $row->acc_name,
                    'acc_nil2'    => $subtotal,
                    'acc_lev2'    => $row->acc_levl,

                );
                $modsave->_updateneraca($data, $id);
            }
        }

        $i = $i + 1;

        //  $subtotal=$subtotal+$trx_amnt;


        $id = $baris;
        if ($total < 0) {
            $total = $total * -1;
        }
        $data = array(
            'acc_cod2'    => $row->acc_code,

            'acc_nam2'    => 'TOTAL PASIVA',
            'acc_nil2'    => $total,
            'acc_lev2'    => $row->acc_levl,

        );
        $modsave->_updateneraca($data, $id);
        /// End Pasiva

        $data = $model->_get_txneraca()->getResult();
        echo json_encode($data);
    }

    ///---------------------------------------
    public function printneraca()
    {
        $model = new Report_Model();
        $modsave = new Save_model();
        $moddel = new  Delete_model();
        $bulan = $this->request->getPost('kin_buln');
        $tahun = $this->request->getPost('kin_tahn');
        $hari_ini = $tahun . '-' . $bulan . '-01'; // date("Y-m-d");
        $tgl_pertama = date('Y-m-01', strtotime($hari_ini));
        $tgl_terakhir = date('Y-m-t', strtotime($hari_ini));

        $id = 1;
        $delaccount = $moddel->m_delneraca($id);
        $acc_klas1 = '1';
        $acc_klas2 = '1';
        $account = $model->_get_neraca($acc_klas1, $acc_klas2);
        $trx_amnt = 0;
        $i = 0;
        $total = 0;
        $subtotal = 0;
        $v_level = '';
        $v_umum = '';
        $total = 0;
        $i = $i + 1;
        $subtotal = 0;
        $data = array(
            'acc_cod1'       => 1,
            'urut'        => $i,
            'acc_nam1'      => 'AKTIVA',
            'acc_nil1'     => '',
            'com_code'    => 1,
            'acc_levl'    => 1,
            'acc_date'    => $tgl_terakhir,
        );
        $modsave->_saveneraca($data);
        foreach ($account->getResult()  as $row) {
            $acc_code = $row->acc_code;
            $i = $i + 1;
            $subtotal = 0;
            $data = array(
                'acc_cod1'       => $row->acc_code,
                'urut'        => $i,
                'acc_nam1'      => $row->acc_name,
                'acc_nil1'     => '',
                'com_code'    => 1,
                'acc_levl'    => $row->acc_levl,
                'acc_date'    => $tgl_terakhir,
            );
            $modsave->_saveneraca($data);

            $dtaccount = $model->_get_neraca1($acc_code);

            foreach ($dtaccount->getResult()  as $row1) {
                $v_acc_code1 = $row1->acc_code;

                //  $i=$i+1;
                $nilai = $model->_get_nilai($v_acc_code1, $bulan, $tahun);
                $trx_amnt = 0;

                foreach ($nilai->getResult()  as $nil) {
                    $trx_amnt = $nil->acc_akhc;
                }

                $subtotal = $subtotal + $trx_amnt;
                if ($row->acc_nblc == 'K') {
                    $total = $total - $trx_amnt;
                } else {
                    $total = $total + $trx_amnt;
                }

                if ($trx_amnt != 0) {
                    $i = $i + 1;
                    $data = array(
                        'acc_cod1'       => $v_acc_code1,
                        'urut'        => $i,
                        'acc_nam1'      => $row1->acc_name,
                        'acc_nil1'     => $trx_amnt,
                        'com_code'    => 1,
                        'acc_levl'    => $row1->acc_levl,
                        'acc_date'    => $tgl_terakhir,

                    );
                    $modsave->_saveneraca($data);
                }
            }

            // sub total
            if ($subtotal != 0) {
                $i = $i + 1;

                //  $subtotal=$subtotal+$trx_amnt;

                $data = array(

                    'acc_cod1'    => 'BRS',
                    'urut'        => $i,
                    'acc_nam1'    => 'SUB TOTAL ' . $row->acc_name,
                    'acc_nil1'    => $subtotal,
                    'com_code'    => 1,
                    'acc_levl'    => $row->acc_levl,
                    'acc_date'    => $tgl_terakhir,

                );
                $modsave->_saveneraca($data);
            }
        }



        //  $subtotal=$subtotal+$trx_amnt;


        $i = $i + 1;
        $baris = $i;
        $data = array(
            'acc_cod1'    => $row->acc_code,
            'urut'        => $i,
            'acc_nam1'    => 'TOTAL AKTIVA',
            'acc_nil1'    => $total,
            'com_code'    => 1,
            'acc_levl'    => $row->acc_levl,
            'acc_date'    => $tgl_terakhir,
        );
        $modsave->_saveneraca($data);

        /// Pasiva
        $acc_klas1 = '2';
        $acc_klas2 = '3';
        $account = $model->_get_neracap($acc_klas1, $acc_klas2);
        $trx_amnt = 0;
        $i = 0;
        $total = 0;
        $subtotal = 0;
        $v_level = '';
        $v_umum = '';
        $total = 0;
        $i = $i + 1;
        $id = $i;
        $data = array(
            'acc_cod2'     => 3,
            'acc_nam2'     => 'PASIVA',
            'acc_nil2'     => '',
            'acc_lev2'     => 1,
        );
        $modsave->_updateneraca($data, $id);
        foreach ($account->getResult()  as $row) {
            $acc_code = $row->acc_code;
            $i = $i + 1;
            $subtotal = 0;
            $id = $i;
            $data = array(
                'acc_cod2'     => $row->acc_code,
                'acc_nam2'     => $row->acc_name,
                'acc_nil2'     => '',
                'acc_lev2'     => $row->acc_levl,
            );
            $modsave->_updateneraca($data, $id);

            $dtaccount = $model->_get_neraca1p($acc_code);

            foreach ($dtaccount->getResult()  as $row1) {
                $v_acc_code1 = $row1->acc_code;

                $nilai = $model->_get_nilai($v_acc_code1, $bulan, $tahun);

                $trx_amnt = 0;

                foreach ($nilai->getResult()  as $nil) {
                    $trx_amnt = $nil->acc_akhc;
                }

                $subtotal = $subtotal + $trx_amnt;
                if ($row->acc_nblc == 'K') {
                    $total = $total - $trx_amnt;
                    //  $subtotal=$subtotal-$trx_amnt;
                } else {
                    $total = $total + $trx_amnt;
                    //  $subtotal=$subtotal+$trx_amnt;
                }

                if ($trx_amnt != 0) {
                    $i = $i + 1;
                    $id = $i;
                    $data = array(

                        'acc_cod2'    => $v_acc_code1,
                        'acc_nam2'    => $row1->acc_name,
                        'acc_nil2'    => $trx_amnt,
                        'acc_lev2'    => $row1->acc_levl,


                    );
                    $modsave->_updateneraca($data, $id);
                }
            }

            // sub total

            if ($subtotal != 0) {
                $i = $i + 1;

                //  $subtotal=$subtotal+$trx_amnt;
                $id = $i;
                $data = array(

                    'acc_cod2'    => 'BRS',
                    'acc_nam2'    => 'SUB TOTAL ' . $row->acc_name,
                    'acc_nil2'    => $subtotal,
                    'acc_lev2'    => $row->acc_levl,

                );
                $modsave->_updateneraca($data, $id);
            }
        }

        $i = $i + 1;

        //  $subtotal=$subtotal+$trx_amnt;


        $id = $baris;
        $data = array(
            'acc_cod2'    => $row->acc_code,

            'acc_nam2'    => 'TOTAL PASIVA',
            'acc_nil2'    => $total,
            'acc_lev2'    => $row->acc_levl,

        );
        $modsave->_updateneraca($data, $id);



        //------
        $data['v_neraca'] = $model->_get_txneraca()->getResult();
        return view('print/rptneraca', $data);
    }

    public function nominatif()
    {
        return view('report/nominatif');
    }

    public function get_nominatif()
    {
        $model = new Report_Model();
        $modsave = new Save_model();
        $tanggal = $this->request->getPost('id');
        $tgl = strtotime($tanggal);
        $jmlhari = 0;
        $v_col = '';
        $id = 1;
        $model->_deletenominatif($id);
        $dttunggakan = $model->get_dbtunggakan($tanggal);
        foreach ($dttunggakan->getResult() as $row1) {
            $norekening = $row1->trx_code;
            $bclosing = $model->get_dttunggakan($norekening, $tanggal);
            $i = 0;
            foreach ($bclosing->getResult() as $row) {
                $v_trx_code = $row->trx_code;
                $v_tgk_pokk = $row->tgk_pokk;
                $v_tgk_bung = $row->tgk_bung;
                $v_trx_jtdt = $row->trx_jtdt;
                $jmlhari = 0;
                if ($v_tgk_pokk > 0) {
                    $tgl1 = strtotime($v_trx_jtdt);
                    $tgl2 = strtotime($tanggal);
                    $jmlhari = ($tgl2 - $tgl1) / 60 / 60 / 24;
                }
                //     Kredit Lancar (L)
                // Debitur memenuhi kewajiban pembayaran setiap bulannya, secara tepat waktu dan tepat jumlah ;
                //  Kredit Dalam Perhatian Khusus (DPK)
                // Debitur tercatat mengalami penunggakan angsuran kredit mulai 31 – 90 Hari dari jadwal pembayaran seharusnya ;
                //  Kredit Kurang Lancar (KL)

                // Debitur mengalami penunggakan angsuran kredit mulai 91 – 120 Hari dari jadwal pembayaran seharusnya ;
                // Kredit Diraguakan (D)
                // Debitur tercatat mengalami penunggakan angsuran kredit mulai 121 – 180 Hari dari jadwal pembayaran seharusnya ;
                //  Kredit Macet (M)
                // Debitur tercatat mengalami penunggakan angsuran kredit selama lebih dari 180 hari dari jadwal pembayaran seharusnya.

                if ($jmlhari > 30 and $jmlhari <= 90) {
                    $v_col = 'DPK';
                } elseif ($jmlhari > 90 and $jmlhari <= 120) {
                    $v_col = 'KL';
                } elseif ($jmlhari > 120 and $jmlhari <= 180) {
                    $v_col = 'D';
                } elseif ($jmlhari > 180) {
                    $v_col = 'M';
                } else {
                    $v_col = 'L';
                }

                $data = array(
                    'tgk_code' => $v_trx_code,
                    'tgk_pokk' => $v_tgk_pokk,
                    'tgk_bung' => $v_tgk_bung,
                    'tgk_dfdf' => $jmlhari,
                    'tgk_date' => $v_trx_jtdt,
                    'rgk_dcol' => $v_col,
                    'tgk_hari' => $jmlhari,
                    'com_code' => 1,

                );

                $modsave->_save_nominatif($data);
            }
        }




        $data = $model->_get_nominatif()->getResult();

        echo json_encode($data);
    }

    public function printnominatip()
    {

        $model = new Report_Model();
        $modsave = new Save_model();
        $tanggal = $this->request->getPost('trx_date');
        $tgl = strtotime($tanggal);
        $jmlhari = 0;
        $v_col = '';
        $id = 1;
        $model->_deletenominatif($id);
        $dttunggakan = $model->get_dbtunggakan($tanggal);
        foreach ($dttunggakan->getResult() as $row1) {
            $norekening = $row1->trx_code;
            $bclosing = $model->get_dttunggakan($norekening, $tanggal);
            $i = 0;
            foreach ($bclosing->getResult() as $row) {
                $v_trx_code = $row->trx_code;
                $v_tgk_pokk = $row->tgk_pokk;
                $v_tgk_bung = $row->tgk_bung;
                $v_trx_jtdt = $row->trx_jtdt;
                $jmlhari = 0;
                if ($v_tgk_pokk > 0) {
                    $tgl1 = strtotime($v_trx_jtdt);
                    $tgl2 = strtotime($tanggal);
                    $jmlhari = ($tgl2 - $tgl1) / 60 / 60 / 24;
                }
                //     Kredit Lancar (L)
                // Debitur memenuhi kewajiban pembayaran setiap bulannya, secara tepat waktu dan tepat jumlah ;
                //  Kredit Dalam Perhatian Khusus (DPK)
                // Debitur tercatat mengalami penunggakan angsuran kredit mulai 31 – 90 Hari dari jadwal pembayaran seharusnya ;
                //  Kredit Kurang Lancar (KL)

                // Debitur mengalami penunggakan angsuran kredit mulai 91 – 120 Hari dari jadwal pembayaran seharusnya ;
                // Kredit Diraguakan (D)
                // Debitur tercatat mengalami penunggakan angsuran kredit mulai 121 – 180 Hari dari jadwal pembayaran seharusnya ;
                //  Kredit Macet (M)
                // Debitur tercatat mengalami penunggakan angsuran kredit selama lebih dari 180 hari dari jadwal pembayaran seharusnya.

                if ($jmlhari > 30 and $jmlhari <= 90) {
                    $v_col = 'DPK';
                } elseif ($jmlhari > 90 and $jmlhari <= 120) {
                    $v_col = 'KL';
                } elseif ($jmlhari > 120 and $jmlhari <= 180) {
                    $v_col = 'D';
                } elseif ($jmlhari > 180) {
                    $v_col = 'M';
                } else {
                    $v_col = 'L';
                }

                $data = array(
                    'tgk_code' => $v_trx_code,
                    'tgk_pokk' => $v_tgk_pokk,
                    'tgk_bung' => $v_tgk_bung,
                    'tgk_dfdf' => $jmlhari,
                    'tgk_date' => $v_trx_jtdt,
                    'rgk_dcol' => $v_col,
                    'tgk_hari' => $jmlhari,
                    'com_code' => 1,
                );

                $modsave->_save_nominatif($data);
            }
        }

        $data['v_nominatip'] = $model->_get_nominatif()->getResult();
        return view('print/rptnominatif', $data);
    }

    public function get_tabharian()
    {
        $model = new Report_Model();

        $tanggal1 = $this->request->getPost('tanggal1');
        $tanggal2 = $this->request->getPost('tanggal2');
        $cabang = $this->request->getPost('kodecabang');
        if ($cabang != '') {
            $data = $model->_get_trantabcab($tanggal1, $tanggal2, $cabang)->getResult();
        } else {
            $data = $model->_get_trantab($tanggal1, $tanggal2)->getResult();
        }

        echo json_encode($data);
    }

    public function get_tabharian1()
    {
        $model = new Report_Model();
        $tanggal1 = $this->request->getPost('tanggal1');
        $tanggal2 = $this->request->getPost('tanggal2');
        $cabang = $this->request->getPost('kodecabang');
        $id = $this->request->getPost('id');

        $draw = $this->request->getVar('draw');
        $start = 1; // $this->request->getVar('start');
        $length = 10; // $this->request->getVar('length');
        $search = $this->request->getVar('search[value]');

        if ($cabang != '') {
            $data = $model->_get_trantabcab1($tanggal1, $tanggal2, $cabang, $start, $length, $search);
        } else {
            $data = $model->_get_trantab1($tanggal1, $tanggal2, $start, $length, $search);
        }

        //{"draw":4,"recordsTotal":57,"recordsFiltered":57,"data":[{"first_name":"Airi","last_name":"Satou","position":"Accountant","office":"Tokyo","start_date":"28th Nov 08","salary":"$162,700"},{"first_name":"Angelica","last_name":"Ramos","position":"Chief Executive Officer (CEO)","office":"London","start_date":"9th Oct 09","salary":"$1,200,000"},{"first_name":"Ashton","last_name":"Cox","position":"Junior Technical Author","office":"San Francisco","start_date":"12th Jan 09","salary":"$86,000"},{"first_name":"Bradley","last_name":"Greer","position":"Software Engineer","office":"London","start_date":"13th Oct 12","salary":"$132,000"},{"first_name":"Brenden","last_name":"Wagner","position":"Software Engineer","office":"San Francisco","start_date":"7th Jun 11","salary":"$206,850"},{"first_name":"Brielle","last_name":"Williamson","position":"Integration Specialist","office":"New York","start_date":"2nd Dec 12","salary":"$372,000"},{"first_name":"Bruno","last_name":"Nash","position":"Software Engineer","office":"London","start_date":"3rd May 11","salary":"$163,500"},{"first_name":"Caesar","last_name":"Vance","position":"Pre-Sales Support","office":"New York","start_date":"12th Dec 11","salary":"$106,450"},{"first_name":"Cara","last_name":"Stevens","position":"Sales Assistant","office":"New York","start_date":"6th Dec 11","salary":"$145,600"},{"first_name":"Cedric","last_name":"Kelly","position":"Senior Javascript Developer","office":"Edinburgh","start_date":"29th Mar 12","salary":"$433,060"}]}
        $resp = array(
            'draw' => $draw,
            'recordsTotal' => $data['recordsTotal'],
            'recordsFiltered' => $data['recordsFiltered'],
            'data' => $data['data']
        );
        echo json_encode($resp);
    }
    public function printtabharian()
    {
        $model = new Report_Model();

        $tanggal1 = $this->request->getPost('trx_date');
        $tanggal2 = $this->request->getPost('trx_dat1');
        $data['tgl1'] = $tanggal1;
        $data['tgl2'] = $tanggal2;
        $cabang = $this->request->getPost('cab_code');
        if ($cabang != '') {
            $data['v_tabungan'] = $model->_get_trantabcab($tanggal1, $tanggal2, $cabang)->getResult();
        } else {
            $data['v_tabungan'] = $model->_get_trantab($tanggal1, $tanggal2)->getResult();
        }


        return view('print/rpttranstabungan', $data);
    }



    public function get_tutuptab()
    {
        $model = new Report_Model();

        $tanggal1 = $this->request->getPost('tanggal1');
        $tanggal2 = $this->request->getPost('tanggal2');
        $cabang = $this->request->getPost('kodecabang');
        if ($cabang != '') {
            $data = $model->__get_tutuptabscab($tanggal1, $tanggal2, $cabang)->getResult();
        } else {
            $data = $model->_get_tutuptabs($tanggal1, $tanggal2)->getResult();
        }

        echo json_encode($data);
    }

    public function printtutuptab()
    {
        $model = new Report_Model();

        $tanggal1 = $this->request->getPost('trx_date');
        $tanggal2 = $this->request->getPost('trx_dat1');
        $cabang = $this->request->getPost('cab_code');
        if ($cabang != '') {
            $data['v_tabungan'] = $model->__get_tutuptabscab($tanggal1, $tanggal2, $cabang)->getResult();
        } else {
            $data['v_tabungan'] = $model->_get_tutuptabs($tanggal1, $tanggal2)->getResult();
        }

        return view('print/rpttutuptabungan', $data);
    }


    public function get_barutab()
    {
        $model = new Report_Model();

        $tanggal1 = $this->request->getPost('tanggal1');
        $tanggal2 = $this->request->getPost('tanggal2');
        $cabang = $this->request->getPost('kodecabang');
        if ($cabang != '') {
            $data = $model->_get_barutabscab($tanggal1, $tanggal2, $cabang)->getResult();
        } else {
            $data = $model->_get_barutabs($tanggal1, $tanggal2)->getResult();
        }

        echo json_encode($data);
    }

    public function printbarutab()
    {
        $model = new Report_Model();

        $tanggal1 = $this->request->getPost('trx_date');
        $tanggal2 = $this->request->getPost('trx_dat1');
        $cabang = $this->request->getPost('cab_code');
        $data['tgl1'] = $tanggal1;
        $data['tgl2'] = $tanggal2;
        if ($cabang != '') {
            $data['v_tabungan'] = $model->_get_barutabscab($tanggal1, $tanggal2, $cabang)->getResult();
        } else {
            $data['v_tabungan'] = $model->_get_barutabs($tanggal1, $tanggal2)->getResult();
        }



        return view('print/rptbarutabungan', $data);
    }


    public function get_pajaktab()
    {
        $model = new Report_Model();

        $tanggal1 = $this->request->getPost('tanggal1');
        $tanggal2 = $this->request->getPost('tanggal2');
        $cabang = $this->request->getPost('kodecabang');
        if ($cabang != '') {
            $data = $model->_get_pajaktabscab($tanggal1, $tanggal2, $cabang)->getResult();
        } else {
            $data = $model->_get_pajaktabs($tanggal1, $tanggal2)->getResult();
        }

        echo json_encode($data);
    }

    public function printpajaktab()
    {
        $model = new Report_Model();

        $tanggal1 = $this->request->getPost('trx_date');
        $tanggal2 = $this->request->getPost('trx_dat1');
        $cabang = $this->request->getPost('cab_code');
        if ($cabang != '') {
            $data['v_tabungan'] = $model->_get_pajaktabscab($tanggal1, $tanggal2, $cabang)->getResult();
        } else {
            $data['v_tabungan'] = $model->_get_pajaktabs($tanggal1, $tanggal2)->getResult();
        }

        return view('print/rptpajaktabungan', $data);
    }


    public function get_nominatiftabfind()
    {
        $model = new Report_Model();

        $tanggal1 = $this->request->getPost('tanggal1');
        $id = $this->request->getPost('id');
        // $tanggal2 = $this->request->getPost('tanggal2');
        $data = $model->_get_nominatiftabfind($tanggal1, $id)->getResult();

        echo json_encode($data);
    }
    public function loadnominatif()
    {
        $model = new Report_Model();

        $tanggal1 = $this->request->getPost('tanggal1');
        // $id = $this->request->getPost('id');
        // $tanggal2 = $this->request->getPost('tanggal2');
        $data = $model->_get_nominatiftabstab1new($tanggal1);

        echo json_encode($data);
    }
    public function get_nominatiftab()
    {
        $model = new Report_Model();
        $tanggal1 = $this->request->getPost('tanggal1');
        $cabang = $this->request->getPost('kodecabang');
        $id = $this->request->getPost('id');

        $draw = $this->request->getVar('draw');
        $start = $this->request->getVar('start');
        $length = $this->request->getVar('length');
        $search = $this->request->getVar('search[value]');

        if ($cabang != '') {
            $data = $model->_get_nominatiftabstabcab($tanggal1, $cabang, $start, $length, $search);
        } else {
            $data = $model->_get_nominatiftabstab($tanggal1,  $start, $length, $search);
        }

        //{"draw":4,"recordsTotal":57,"recordsFiltered":57,"data":[{"first_name":"Airi","last_name":"Satou","position":"Accountant","office":"Tokyo","start_date":"28th Nov 08","salary":"$162,700"},{"first_name":"Angelica","last_name":"Ramos","position":"Chief Executive Officer (CEO)","office":"London","start_date":"9th Oct 09","salary":"$1,200,000"},{"first_name":"Ashton","last_name":"Cox","position":"Junior Technical Author","office":"San Francisco","start_date":"12th Jan 09","salary":"$86,000"},{"first_name":"Bradley","last_name":"Greer","position":"Software Engineer","office":"London","start_date":"13th Oct 12","salary":"$132,000"},{"first_name":"Brenden","last_name":"Wagner","position":"Software Engineer","office":"San Francisco","start_date":"7th Jun 11","salary":"$206,850"},{"first_name":"Brielle","last_name":"Williamson","position":"Integration Specialist","office":"New York","start_date":"2nd Dec 12","salary":"$372,000"},{"first_name":"Bruno","last_name":"Nash","position":"Software Engineer","office":"London","start_date":"3rd May 11","salary":"$163,500"},{"first_name":"Caesar","last_name":"Vance","position":"Pre-Sales Support","office":"New York","start_date":"12th Dec 11","salary":"$106,450"},{"first_name":"Cara","last_name":"Stevens","position":"Sales Assistant","office":"New York","start_date":"6th Dec 11","salary":"$145,600"},{"first_name":"Cedric","last_name":"Kelly","position":"Senior Javascript Developer","office":"Edinburgh","start_date":"29th Mar 12","salary":"$433,060"}]}
        $resp = array(
            'draw' => $draw,
            'recordsTotal' => $data['recordsTotal'],
            'recordsFiltered' => $data['recordsFiltered'],
            'data' => $data['data']
        );
        echo json_encode($resp);
    }


    public function printnominatiftab()
    {
        $model = new Report_Model();

        $tanggal1 = $this->request->getPost('trx_date');

        // $tanggal2 = $this->request->getPost('trx_dat1');
        $cabang = $this->request->getPost('cab_code');

        $tanggal2 = $this->request->getPost('tanggal2');

        $pdf = new TCPDF('L', PDF_UNIT, 'A4', true, 'UTF-8', false);

        $pdf->SetCreator(PDF_CREATOR);
        $pdf->SetAuthor('GIT');
        $pdf->SetTitle('Simpanan');
        $pdf->SetSubject('Simpanan');

        $pdf->setPrintHeader(false);
        $pdf->setPrintFooter(false);

        $pdf->addPage();
        //$image_file = 'assets/images/' . $_SESSION['com_logo'];
        /**
         * width : 50
         */


        $image_file = 'assets/images/' . $_SESSION['com_logo'];

        /**
         * width : 50
         */
        $pdf->Image($image_file, '', '', 20);

        // Set font
        $pdf->SetFont('helvetica', 'B', 11);
        $pdf->SetX(40);
        $pdf->Cell(0, 2, $_SESSION['com_name'], 0, 1, '', 0, '', 0);

        $pdf->SetX(40);
        $pdf->SetFont('helvetica', '', 8);
        $pdf->Cell(0, 2, $_SESSION['com_adrs'], 0, 1, '', 0, '', 0);
        $pdf->SetX(40);
        $pdf->Cell(0, 2, 'Phone : ' . $_SESSION['com_phon'], 0, 1, '', 0, '', 0);

        // $pdf->SetX(40);
        // Title

        // Footer
        // Position at 15 mm from bottom


        //

        $pdf->Ln();


        $pdf->Ln();
        $pdf->SetFont('helvetica', '', 11);
        $pdf->Cell(275, 7, 'NOMINATIF TABUNGAN', 0, 1, 'C');
        // $pdf->Ln();
        $pdf->SetFont('helvetica', '', 9);
        $pdf->Cell(275, 5, 'Tanggal : ' . date('d/m/Y', strtotime($tanggal1)), 0, 1, 'C');

        $pdf->SetFont('helvetica', '', 8);

        // $pdf->Ln();
        // $pdf->Cell(190, 4, $row->prd_name, 1, 0, 'C');

        $pdf->Ln();
        $pdf->Cell(10, 14, 'No. ', 1, 0, 'C');
        $pdf->Cell(30, 14, 'No. Rekening', 1, 0, 'C');
        $pdf->Cell(65, 14, 'Nama', 1, 0, 'C');
        $pdf->Cell(30, 14, 'Lokasi', 1, 0, 'C');
        $pdf->Cell(50, 14, 'Pemilik', 'RT', 0, 'C');
        $pdf->Cell(25, 14, 'Kelompok', 'RT', 0, 'C');
        $pdf->Cell(20, 14, 'Jenis Kelamin', 'RT', 0, 'C');
        $pdf->Cell(15, 14, 'Status', 'RT', 0, 'C');
        $pdf->Cell(30, 14, 'Saldo Akhir', 'RT', 0, 'C');

        $pdf->Ln();
        if ($cabang != '') {
            $dbtabungan = $model->_get_nominatiftabscabrpt($tanggal1, $cabang);
        } else {
            $dbtabungan = $model->_get_nominatiftabsrpt($tanggal1)->getResult();
        }
        $i = 0;
        $saldo = 0;
        foreach ($dbtabungan->getResult() as $row) {
            $i
                = $i + 1;
            if ($row->tbg_stat == '0') {
                $stat = 'Baru';
            } else if ($row->tbg_stat == '1') {
                $stat = 'Aktif';
            } else {
                $stat = 'Tidak Aktif';
            }
            $jeniskelamin = $row->sex_code;
            if ($jeniskelamin == 1) {
                $jeniskelamin = 'Laki-Laki';
            } else {
                $jeniskelamin = 'Perempuan';
            }
            $saldo = $saldo + $row->tbg_akhr;
            $pdf->Cell(10, 7,  $i, 1, 0, 'C');
            $pdf->Cell(30, 7, $row->tbg_code, 1, 0, 'C');
            $pdf->Cell(65, 7, $row->agt_name, 1, 0, 'L');
            $pdf->Cell(30, 7, $row->nama_cabang, 1, 0, 'L');
            $pdf->Cell(50, 7, $row->tbg_pemk, 1, 0, 'L');
            $pdf->Cell(25, 7, $row->kel_code, 1, 0, 'L');
            $pdf->Cell(20, 7, $jeniskelamin, 1, 0, 'C');
            $pdf->Cell(15, 7, $stat, 1, 0, 'C');
            $pdf->Cell(30, 7, number_format($row->tbg_akhr), 1, 0, 'R');

            $pdf->Ln();

            // $pdf->Ln();
            // if ($i >= 19) {
            //     $pdf->Cell(10, 14, 'No. ', 1, 0, 'C');
            //     $pdf->Cell(30, 14, 'No. Rekening', 1, 0, 'C');
            //     $pdf->Cell(60, 14, 'Nama', 1, 0, 'C');
            //     $pdf->Cell(30, 14, 'Lokasi', 1, 0, 'C');
            //     $pdf->Cell(50, 14, 'Pemilik', 'RT', 0, 'C');
            //     $pdf->Cell(25, 14, 'Kelompok', 'RT', 0, 'C');
            //     $pdf->Cell(20, 14, 'Jenis Kelamin', 'RT', 0, 'C');
            //     $pdf->Cell(15, 14, 'Status', 'RT', 0, 'C');
            //     $pdf->Cell(30, 14, 'Saldo Akhir', 'RT', 0, 'C');
            //     $pdf->Ln();
            // }
        }

        $pdf->Cell(220, 10, 'TOTAL', 1, 0, 'C');
        $pdf->Cell(45, 10, number_format($saldo), 1, 0, 'R');


        $pdf->Ln();
        // output the HTML content


        // $pdf->writeHTML($html, true, false, true, false, '');
        //line ini penting

        $this->response->setContentType('application/pdf');

        $pdf->SetY(-24);
        // Set font
        $pdf->SetFont('helvetica', 'I', 8);
        // Page number
        $pdf->Cell(0, 2, 'Page ' . $pdf->getAliasNumPage() . '/' . $pdf->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
        //Close and output PDF document
        $pdf->Output('Repsimpanan.pdf', 'I');
    }
    public function printnominatiftab1()
    {
        $model = new Report_Model();

        $tanggal1 = $this->request->getPost('trx_date');
        // $tanggal2 = $this->request->getPost('trx_dat1');
        $cabang = $this->request->getPost('cab_code');
        $data['tanggal1'] = $tanggal1;
        $data['cabang'] = $cabang;

        $tanggal2 = $this->request->getPost('tanggal2');
        if ($cabang != '') {
            $data['v_tabungan'] = $model->_get_nominatiftabscabrpt($tanggal1, $cabang)->getResult();
        } else {
            $data['v_tabungan'] = $model->_get_nominatiftabsrpt($tanggal1)->getResult();
        }


        // return view('print/rptnominaiftabungan', $data);
        $pdf = new TCPDF('P', 'mm', 'A4', true, 'UTF-8', false);

        // set document information
        $pdf->SetCreator(PDF_CREATOR);
        $pdf->SetAuthor('galunggung.biz');
        $pdf->SetTitle('Form RL. 5.4');
        $pdf->SetSubject('Form RL. 5.4');
        // $pdf->SetHeaderMargin(30);

        $pdf->SetKeywords('TCPDF, PDF, Form RL');
        $pdf->SetAutoPageBreak(true);
        // set default header data
        $pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . ' 001', PDF_HEADER_STRING, array(0, 64, 255), array(0, 64, 128));
        $pdf->setFooterData(array(0, 64, 0), array(0, 64, 128));

        // set header and footer fonts
        $pdf->setHeaderFont(array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
        $pdf->setFooterFont(array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

        // set default monospaced font
        $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

        // set margins
        $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
        $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
        $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

        // set auto page breaks
        $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

        // set image scale factor
        $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

        // set default font subsetting mode
        $pdf->setFontSubsetting(true);

        // Set font
        // dejavusans is a UTF-8 Unicode font, if you only need to
        // print standard ASCII chars, you can use core fonts like
        // helvetica or times to reduce file size.
        $pdf->SetFont('dejavusans', '', 14, '', true);

        // Add a page
        // This method has several options, check the source code documentation for more information.

        $pdf->AddPage();

        //view mengarah ke form RL.php
        $pdf->SetFont('dejavusans', '', 9, '', true);

        $html = view('print/rptnominatiftabungan.php', $data);


        // Print text using writeHTMLCell()
        $pdf->writeHTMLCell(0, 0, '', '', $html, 0, 1, 0, true, '', true);

        // ---------------------------------------------------------
        $this->response->setContentType('application/pdf');
        // Close and output PDF document
        // This method has several options, check the source code documentation for more information.
        $pdf->Output('rl54.pdf', 'I');
    }

    public function get_mutasitab()
    {
        $model = new Report_Model();

        $model1 = new Model_git();
        $modsave = new Save_model();
        $modelete = new Delete_model();
        $tanggal1 = $this->request->getPost('tanggal1');
        $tanggal2 = $this->request->getPost('tanggal2');
        $cabang = $this->request->getPost('kodecabang');
        if ($cabang != '') {
            $tabungan = $model1->_get_dttabungancab($cabang);
        } else {
            $tabungan = $model1->_get_dttabungan();
        }

        $host = gethostbyaddr($_SERVER['REMOTE_ADDR']);
        $modelete->_deletetxtabungan($host);
        foreach ($tabungan->getResult()  as $row) {
            $norekning = $row->tbg_code;
            $agt_numb = $row->agt_numb;
            $dttabungan = $model1->get_niltabunganawal($norekning, $tanggal1);
            $saldoawal =
                $dttabungan['tbg_awal'];
            $akhir = 0;
            $dttabungan1 = $model1->get_niltabunganrek($norekning, $tanggal1, $tanggal2);
            $debet = $dttabungan1['tbg_debt'];
            $credit =
                $dttabungan1['tbg_crdt'];
            $akhir = $saldoawal + $credit - $debet;
            $data = array(
                'tbg_code' => $norekning,
                'agt_numb' => $agt_numb,
                'tbg_awal' => $saldoawal,
                'tbg_debt' => $debet,
                'tbg_crdt' => $credit,
                'tbg_akhr' => $akhir,
                'tbg_dat1' => $tanggal1,
                'tbg_dat2' => $tanggal2,
                'trx_host' => $host,
            );
            $modsave->_savetxtabungan($data);
        }

        $data = $model->_get_mutasitabs($host)->getResult();
        echo json_encode($data);
    }

    public function printmutasitab()
    {
        $model = new Report_Model();

        $model1 = new Model_git();
        $modsave = new Save_model();
        $modelete = new Delete_model();
        $tanggal1 = $this->request->getPost('trx_date');
        $tanggal2 = $this->request->getPost('trx_dat1');
        $cabang = $this->request->getPost('cab_code');
        $host = gethostbyaddr($_SERVER['REMOTE_ADDR']);
        $modelete->_deletetxtabungan($host);

        if ($cabang != '') {
            $tabungan = $model1->_get_dttabungancab($cabang);
        } else {
            $tabungan = $model1->_get_dttabungan();
        }

        foreach ($tabungan->getResult()  as $row) {
            $norekning = $row->tbg_code;
            $agt_numb = $row->agt_numb;
            $dttabungan = $model1->get_niltabunganawal($norekning, $tanggal1);
            $saldoawal =
                $dttabungan['tbg_awal'];
            $akhir = 0;
            $dttabungan1 = $model1->get_niltabunganrek($norekning, $tanggal1, $tanggal2);
            $debet = $dttabungan1['tbg_debt'];
            $credit =
                $dttabungan1['tbg_crdt'];
            $akhir = $saldoawal + $credit - $debet;
            $data = array(
                'tbg_code' => $norekning,
                'agt_numb' => $agt_numb,
                'tbg_awal' => $saldoawal,
                'tbg_debt' => $debet,
                'tbg_crdt' => $credit,
                'tbg_akhr' => $akhir,
                'tbg_dat1' => $tanggal1,
                'tbg_dat2' => $tanggal2,
                'trx_host' => $host,
                'com_code' => 1,
            );
            $modsave->_savetxtabungan($data);
        }
        if ($cabang != '') {
            $data['v_tabungan'] = $model->_get_mutasitabscab($host, $cabang)->getResult();
        } else {
            $data['v_tabungan'] = $model->_get_mutasitabs($host)->getResult();
        }

        return view('print/rpttabmutasi', $data);
    }

    public function get_nominatifssb()
    {
        $model = new Report_Model();
        $id = $this->request->getPost('tanggal1');
        $data = $model->_get_nomintaifssb($id)->getResult();

        echo json_encode($data);
    }

    public function printnominatifssb()
    {
        $model = new Report_Model();
        $id = $this->request->getPost('trx_date');
        $data['v_ssb'] = $model->_get_nomintaifssb($id)->getResult();
        return view('print/rptssb/rptssbnominatif', $data);
    }


    public function get_transaksissb()
    {
        $model = new Report_Model();
        $tanggal1 = $this->request->getPost('tanggal1');
        $tanggal2 = $this->request->getPost('tanggal2');
        $data = $model->_get_transaksissb($tanggal1, $tanggal2)->getResult();

        echo json_encode($data);
    }

    public function printtransaksissb()
    {
        $model = new Report_Model();
        $tanggal1 = $this->request->getPost('trx_date');
        $tanggal2 = $this->request->getPost('trx_dat1');
        $data['v_ssb'] = $model->_get_transaksissb($tanggal1, $tanggal2)->getResult();
        return view('print/rptssb/rptssbtransaksi', $data);
    }

    public function get_barussb()
    {
        $model = new Report_Model();
        $tanggal1 = $this->request->getPost('tanggal1');
        $tanggal2 = $this->request->getPost('tanggal2');
        $cabang = $this->request->getPost('kodecabang');
        if ($cabang != '') {
            $data = $model->_get_barussbcab($tanggal1, $tanggal2, $cabang)->getResult();
        } else {
            $data = $model->_get_barussb($tanggal1, $tanggal2)->getResult();
        }

        echo json_encode($data);
    }

    public function printbarussb()
    {
        $model = new Report_Model();
        $tanggal1 = $this->request->getPost('trx_date');
        $tanggal2 = $this->request->getPost('trx_dat1');
        $cabang = $this->request->getPost('cab_code');
        if ($cabang != '') {
            $data['v_ssb'] = $model->_get_barussbcab($tanggal1, $tanggal2, $cabang)->getResult();
        } else {
            $data['v_ssb'] = $model->_get_barussb($tanggal1, $tanggal2)->getResult();
        }

        return view('print/rptssb/rptssbbaru', $data);
    }


    public function get_tutupssb()
    {
        $model = new Report_Model();
        $tanggal1 = $this->request->getPost('tanggal1');
        $tanggal2 = $this->request->getPost('tanggal2');
        $cabang = $this->request->getPost('kodecabang');
        if ($cabang != '') {
            $data = $model->_get_tutupssbcab($tanggal1, $tanggal2, $cabang)->getResult();
        } else {
            $data = $model->_get_tutupssb($tanggal1, $tanggal2)->getResult();
        }


        echo json_encode($data);
    }

    public function printtutupssb()
    {
        $model = new Report_Model();
        $tanggal1 = $this->request->getPost('trx_date');
        $tanggal2 = $this->request->getPost('trx_dat1');
        $cabang = $this->request->getPost('cab_code');
        if ($cabang != '') {
            $data['v_ssb'] = $model->_get_tutupssbcab($tanggal1, $tanggal2, $cabang)->getResult();
        } else {
            $data['v_ssb'] = $model->_get_tutupssb($tanggal1, $tanggal2)->getResult();
        }

        return view('print/rptssb/rptssbtutup', $data);
    }


    public function get_jadwwalbunga()
    {
        $model = new Report_Model();
        $tanggal1 = $this->request->getPost('tanggal1');
        $tanggal2 = $this->request->getPost('tanggal2');
        $cabang = $this->request->getPost('kodecabang');
        if ($cabang != '') {
            $data = $model->_get_jadwalbungassbcab($tanggal1, $tanggal2, $cabang)->getResult();
        } else {
            $data = $model->_get_jadwalbungassb($tanggal1, $tanggal2)->getResult();
        }


        echo json_encode($data);
    }

    public function printjadwwalbunga()
    {
        $model = new Report_Model();
        $tanggal1 = $this->request->getPost('trx_date');
        $tanggal2 = $this->request->getPost('trx_dat1');
        $cabang = $this->request->getPost('cab_code');
        if ($cabang != '') {
            $data['v_ssb'] = $model->_get_jadwalbungassbcab($tanggal1, $tanggal2, $cabang)->getResult();
        } else {
            $data['v_ssb'] = $model->_get_jadwalbungassb($tanggal1, $tanggal2)->getResult();
        }

        return view('print/rptssb/rptssbjadwalpajak', $data);
    }


    public function get_rekkoranssb()
    {
        $model = new Report_Model();
        $norekening = $this->request->getPost('norekening');
        $tanggal1 = $this->request->getPost('tanggal1');
        $tanggal2 = $this->request->getPost('tanggal2');
        $data = $model->_get_rekkoranssb($norekening, $tanggal1, $tanggal2)->getResult();

        echo json_encode($data);
    }

    public function printrekkoranssb()
    {
        $model = new Report_Model();
        $norekening = $this->request->getPost('tbg_code');
        $tanggal1 = $this->request->getPost('trx_date');
        $tanggal2 = $this->request->getPost('trx_dat1');
        $data['tgl1'] = $tanggal1;
        $data['tgl2'] = $tanggal2;
        $data['v_ssb'] = $model->_get_rekkoranssb($norekening, $tanggal1, $tanggal2)->getResult();
        return view('print/rptssb/rptssbrekkoran', $data);
    }

    public function get_transaksipembiayaan()
    {
        $model = new Report_Model();

        $tanggal1 = $this->request->getPost('tanggal1');
        $tanggal2 = $this->request->getPost('tanggal2');
        $cabang = $this->request->getPost('kodecabang');
        if ($cabang != '') {
            $data = $model->_get_transpembiayaancab($tanggal1, $tanggal2, $cabang)->getResult();
        } else {
            $data = $model->_get_transpembiayaan($tanggal1, $tanggal2)->getResult();
        }
        echo json_encode($data);
    }

    public function printtranspembiayaan()
    {
        $model = new Report_Model();

        $tanggal1 = $this->request->getPost('trx_date');
        $tanggal2 = $this->request->getPost('trx_dat1');
        $data['tgl1'] = $tanggal1;
        $data['tgl2'] = $tanggal2;
        $cabang = $this->request->getPost('cab_code');
        if ($cabang != '') {
            $data['v_report'] = $model->_get_transpembiayaancab($tanggal1, $tanggal2, $cabang)->getResult();
        } else {
            $data['v_report'] = $model->_get_transpembiayaan($tanggal1, $tanggal2)->getResult();
        }

        return view('print/pembiayaan/rpttranpembiayaan', $data);
    }

    public function get_mutasipembiayaan()
    {
        $model = new Report_Model();
        $model1 = new Model_git();
        $modsave = new Save_model();
        $tanggal1 = $this->request->getPost('tanggal1');
        $tanggal2 = $this->request->getPost('tanggal2');
        $cabang = $this->request->getPost('kodecabang');
        if ($cabang != '') {
            $dtrekening = $model1->_get_gkontrakcab($cabang);
        } else {
            $dtrekening = $model1->_get_gkontrak();
        }

        foreach ($dtrekening->getResult() as $row) {
            $v_knt_code = $row->knt_code;
            $id = $row->knt_code;
            $v_knt_totl = $row->knt_totl;
            $nilai = $model1->_get_salawalkredit($v_knt_code, $tanggal1);
            $trx_amnt = 0;
            $trx_amnt = $nilai['tbg_bayr'];
            $nilai2 = $model1->_get_niltransbiaya($v_knt_code, $tanggal1, $tanggal2);
            $trx_debt = 0; //$nilai2['knt_debt'];
            $trx_crdt = $nilai2['knt_krdt'];
            // foreach ($nilai->getResult()  as $nil) {
            // $trx_amnt = $nilai['tbg_bayr'];
            // };
            $trx_sawl = $v_knt_totl - $trx_amnt;
            $data = array(
                'knt_awal' => $trx_sawl,
                'knt_debt' => $trx_debt,
                'knt_crdt' => $trx_crdt,
                'knt_dawl' => $tanggal1,
            );
            $modsave->_updatekontrak($data, $id);
        }
        if ($cabang != '') {
            $data = $model->_get_mutasupembiayaancab($tanggal1, $tanggal2, $cabang)->getResult();
        } else {
            $data = $model->_get_mutasupembiayaan($tanggal1, $tanggal2)->getResult();
        }


        echo json_encode($data);
    }


    public function printmutasipembiayaan()
    {
        $model = new Report_Model();
        $model1 = new Model_git();
        $modsave = new Save_model();

        $tanggal1 = $this->request->getPost('trx_date');
        $tanggal2 = $this->request->getPost('trx_dat1');
        $cabang = $this->request->getPost('cab_code');
        $data['tgl1'] = $tanggal1;
        $data['tgl2'] = $tanggal2;
        if ($cabang != '') {
            $dtrekening = $model1->_get_gkontrakcab($cabang);
        } else {
            $dtrekening = $model1->_get_gkontrak();
        }

        foreach ($dtrekening->getResult() as $row) {
            $v_knt_code = $row->knt_code;
            $id = $row->knt_code;
            $v_knt_totl = $row->knt_totl;
            $nilai = $model1->_get_salawalkredit($v_knt_code, $tanggal1);
            $trx_amnt = 0;
            $trx_amnt = $nilai['tbg_bayr'];
            $nilai2 = $model1->_get_niltransbiaya($v_knt_code, $tanggal1, $tanggal2);
            $trx_debt = $nilai2['knt_debt'];
            $trx_crdt = $nilai2['knt_crdt'];
            // foreach ($nilai->getResult()  as $nil) {
            // $trx_amnt = $nilai['tbg_bayr'];
            // };
            $trx_sawl = $v_knt_totl - $trx_amnt;
            $data = array(
                'knt_awal' => $trx_sawl,
                'knt_debt' => $trx_debt,
                'knt_crdt' => $trx_crdt,
                'knt_dawl' => $tanggal1,
            );
            $modsave->_updatekontrak($data, $id);
        }
        if ($cabang != '') {
            $data['v_report'] = $model->_get_mutasupembiayaancab($tanggal1, $tanggal2, $cabang)->getResult();
        } else {
            $data['v_report'] = $model->_get_mutasupembiayaan($tanggal1, $tanggal2)->getResult();
        }


        return view('print/pembiayaan/rptmutasipembiayaan', $data);
    }



    public function get_tagihan()
    {
        $model = new Report_Model();

        $tanggal1 = $this->request->getPost('tanggal1');
        $tanggal2 = $this->request->getPost('tanggal2');
        $cabang = $this->request->getPost('kodecabang');
        if ($cabang != '') {
            $data = $model->_get_tagihancab($tanggal1, $tanggal2, $cabang)->getResult();
        } else {
            $data = $model->_get_tagihan($tanggal1, $tanggal2)->getResult();
        }


        echo json_encode($data);
    }

    public function printtagihan()
    {
        $model = new Report_Model();

        $tanggal1 = $this->request->getPost('trx_date');
        $tanggal2 = $this->request->getPost('trx_dat1');
        $cabang = $this->request->getPost('cab_code');
        $data['tgl1'] = $tanggal1;
        $data['tgl2'] = $tanggal2;
        if ($cabang != '') {
            $data['v_report'] = $model->_get_tagihancab($tanggal1, $tanggal2, $cabang)->getResult();
        } else {
            $data['v_report'] = $model->_get_tagihan($tanggal1, $tanggal2)->getResult();
        }


        return view('print/pembiayaan/rpttagihan', $data);
    }


    public function get_ppap()
    {
        $model = new Report_Model();
        $modsave = new Save_model();
        $tanggal = $this->request->getPost('id');
        $cabang  = $this->request->getPost('kodecabang');
        $tgl = strtotime($tanggal);
        $jmlhari = 0;
        $v_col = '';
        $id = 1;
        $model->_deletenominatif($id);
        if ($cabang != '') {
            $dttunggakan = $model->get_dbtunggakancab($tanggal, $cabang);
        } else {
            $dttunggakan = $model->get_dbtunggakan($tanggal);
        }

        foreach ($dttunggakan->getResult() as $row1) {
            $norekening = $row1->trx_code;
            $bclosing = $model->get_dttunggakan($norekening, $tanggal);
            $i = 0;
            foreach ($bclosing->getResult() as $row) {
                $v_trx_code = $row->trx_code;
                $v_tgk_pokk = $row->tgk_pokk;
                $v_tgk_bung = $row->tgk_bung;
                $v_trx_jtdt = $row->trx_jtdt;
                $jmlhari = 0;
                if ($v_tgk_pokk > 0) {
                    $tgl1 = strtotime($v_trx_jtdt);
                    $tgl2 = strtotime($tanggal);
                    $jmlhari = ($tgl2 - $tgl1) / 60 / 60 / 24;
                    $jmlhari = round($jmlhari, PHP_ROUND_HALF_UP);
                }
                //     Kredit Lancar (L)
                // Debitur memenuhi kewajiban pembayaran setiap bulannya, secara tepat waktu dan tepat jumlah ;
                //  Kredit Dalam Perhatian Khusus (DPK)
                // Debitur tercatat mengalami penunggakan angsuran kredit mulai 31 – 90 Hari dari jadwal pembayaran seharusnya ;
                //  Kredit Kurang Lancar (KL)

                // Debitur mengalami penunggakan angsuran kredit mulai 91 – 120 Hari dari jadwal pembayaran seharusnya ;
                // Kredit Diraguakan (D)
                // Debitur tercatat mengalami penunggakan angsuran kredit mulai 121 – 180 Hari dari jadwal pembayaran seharusnya ;
                //  Kredit Macet (M)
                // Debitur tercatat mengalami penunggakan angsuran kredit selama lebih dari 180 hari dari jadwal pembayaran seharusnya.

                if (empty($jmlhari)) {
                    $jmlhari = 0;
                }
                if ($jmlhari == '') {
                    $jmlhari = 0;
                }
                if ($jmlhari > 30 and $jmlhari <= 90) {
                    $v_col = 'DPK';
                } elseif ($jmlhari > 90 and $jmlhari <= 120) {
                    $v_col = 'KL';
                } elseif ($jmlhari > 120 and $jmlhari <= 180) {
                    $v_col = 'D';
                } elseif ($jmlhari > 180) {
                    $v_col = 'M';
                } else {
                    $v_col = 'L';
                }


                $data = array(
                    'tgk_code' => $v_trx_code,
                    'tgk_pokk' => $v_tgk_pokk,
                    'tgk_bung' => $v_tgk_bung,
                    'tgk_dfdf' => $jmlhari,
                    'tgk_date' => $v_trx_jtdt,
                    'tgk_hari' => $jmlhari,
                    'rgk_dcol' => $v_col,
                    'com_code' => 1,
                    'kode_cabang'  => session()->get('kode_cabang'),
                );

                $modsave->_save_nominatif($data);
            }
        }
        if ($cabang != '') {
            $data = $model->_get_nominatifcab($cabang)->getResult($cabang);
        } else {
            $data = $model->_get_nominatif()->getResult();
        }
        echo json_encode($data);
    }

    public function printppap()
    {

        $model = new Report_Model();
        $modsave = new Save_model();
        $tanggal = $this->request->getPost('trx_dat1');
        $cabang = $this->request->getPost('cab_code');
        $tgl = strtotime($tanggal);
        $jmlhari = 0;
        $v_col = '';
        $id = 1;
        $model->_deletenominatif($id);
        if ($cabang != '') {
            $dttunggakan = $model->get_dbtunggakancab($tanggal, $cabang);
        } else {
            $dttunggakan = $model->get_dbtunggakan($tanggal);
        }

        foreach ($dttunggakan->getResult() as $row1) {
            $norekening = $row1->trx_code;
            $bclosing = $model->get_dttunggakan($norekening, $tanggal);
            $i = 0;
            foreach ($bclosing->getResult() as $row) {
                $v_trx_code = $row->trx_code;
                $v_tgk_pokk = $row->tgk_pokk;
                $v_tgk_bung = $row->tgk_bung;
                $v_trx_jtdt = $row->trx_jtdt;
                if ($v_tgk_pokk > 0) {
                    $tgl1 = strtotime($v_trx_jtdt);
                    $tgl2 = strtotime($tanggal);
                    $jmlhari = ($tgl2 - $tgl1) / 60 / 60 / 24;
                }
                //     Kredit Lancar (L)
                // Debitur memenuhi kewajiban pembayaran setiap bulannya, secara tepat waktu dan tepat jumlah ;
                //  Kredit Dalam Perhatian Khusus (DPK)
                // Debitur tercatat mengalami penunggakan angsuran kredit mulai 31 – 90 Hari dari jadwal pembayaran seharusnya ;
                //  Kredit Kurang Lancar (KL)

                // Debitur mengalami penunggakan angsuran kredit mulai 91 – 120 Hari dari jadwal pembayaran seharusnya ;
                // Kredit Diraguakan (D)
                // Debitur tercatat mengalami penunggakan angsuran kredit mulai 121 – 180 Hari dari jadwal pembayaran seharusnya ;
                //  Kredit Macet (M)
                // Debitur tercatat mengalami penunggakan angsuran kredit selama lebih dari 180 hari dari jadwal pembayaran seharusnya.

                if ($jmlhari > 30 and $jmlhari <= 90) {
                    $v_col = 'DPK';
                } elseif ($jmlhari > 90 and $jmlhari <= 120) {
                    $v_col = 'KL';
                } elseif ($jmlhari > 120 and $jmlhari <= 180) {
                    $v_col = 'D';
                } elseif ($jmlhari > 180) {
                    $v_col = 'M';
                } else {
                    $v_col = 'L';
                }

                $data = array(
                    'tgk_code' => $v_trx_code,
                    'tgk_pokk' => $v_tgk_pokk,
                    'tgk_bung' => $v_tgk_bung,
                    'tgk_dfdf' => $jmlhari,
                    'tgk_date' => $v_trx_jtdt,
                    'rgk_dcol' => $v_col,
                    'tgk_hari' => $jmlhari,
                    'com_code' => 1,
                    'kode_cabang'  => session()->get('kode_cabang'),
                );

                $modsave->_save_nominatif($data);
            }
        }
        if ($cabang != '') {
            $data['v_report'] = $model->_get_nominatifcab($cabang)->getResult();
        } else {
            $data['v_report'] = $model->_get_nominatif()->getResult();
        }

        return view('print/pembiayaan/rptppap', $data);
    }




    public function get_printcolection()
    {
        $model = new Report_Model();
        $modsave = new Save_model();
        $tanggal = $this->request->getPost('id');
        $tgl = strtotime($tanggal);
        $jmlhari = 0;
        $v_col = '';
        $id = 1;
        $model->_deletenominatif($id);
        $dttunggakan = $model->get_dbtunggakan($tanggal);
        foreach ($dttunggakan->getResult() as $row1) {
            $norekening = $row1->trx_code;
            $bclosing = $model->get_dttunggakan($norekening, $tanggal);
            $i = 0;
            foreach ($bclosing->getResult() as $row) {
                $v_trx_code = $row->trx_code;
                $v_tgk_pokk = $row->tgk_pokk;
                $v_tgk_bung = $row->tgk_bung;
                $v_trx_jtdt = $row->trx_jtdt;
                $jmlhari = 0;
                if ($v_tgk_pokk > 0) {
                    $tgl1 = strtotime($v_trx_jtdt);
                    $tgl2 = strtotime($tanggal);
                    if (($tgl2 - $tgl1) > 0) {
                        $jmlhari = 0;
                    } else {
                        $jmlhari = ($tgl2 - $tgl1) / 60 / 60 / 24;
                    }
                }
                //     Kredit Lancar (L)
                // Debitur memenuhi kewajiban pembayaran setiap bulannya, secara tepat waktu dan tepat jumlah ;
                //  Kredit Dalam Perhatian Khusus (DPK)
                // Debitur tercatat mengalami penunggakan angsuran kredit mulai 31 – 90 Hari dari jadwal pembayaran seharusnya ;
                //  Kredit Kurang Lancar (KL)

                // Debitur mengalami penunggakan angsuran kredit mulai 91 – 120 Hari dari jadwal pembayaran seharusnya ;
                // Kredit Diraguakan (D)
                // Debitur tercatat mengalami penunggakan angsuran kredit mulai 121 – 180 Hari dari jadwal pembayaran seharusnya ;
                //  Kredit Macet (M)
                // Debitur tercatat mengalami penunggakan angsuran kredit selama lebih dari 180 hari dari jadwal pembayaran seharusnya.
                if ($jmlhari == 'NaN') {
                    $jmlhari = 0;
                }
                if ($jmlhari > 30 and $jmlhari <= 90) {
                    $v_col = 'DPK';
                } elseif ($jmlhari > 90 and $jmlhari <= 120) {
                    $v_col = 'KL';
                } elseif ($jmlhari > 120 and $jmlhari <= 180) {
                    $v_col = 'D';
                } elseif ($jmlhari > 180) {
                    $v_col = 'M';
                } else {
                    $v_col = 'L';
                }

                $data = array(
                    'tgk_code' => $v_trx_code,
                    'tgk_pokk' => $v_tgk_pokk,
                    'tgk_bung' => $v_tgk_bung,
                    'tgk_dfdf' => $jmlhari,
                    'tgk_date' => $v_trx_jtdt,
                    'rgk_dcol' => $v_col,
                    'tgk_hari' => $jmlhari,
                    'com_code' => 1,
                    'kode_cabang'  => session()->get('kode_cabang'),
                );

                $modsave->_save_nominatif($data);
            }
        }




        $data = $model->_get_nominatif()->getResult();

        echo json_encode($data);
    }

    public function printcolection()
    {

        $model = new Report_Model();


        $modsave = new Save_model();
        $moddelete = new Delete_model();
        $tanggal1 = $this->request->getPost('trx_date');
        $tanggal2 = $this->request->getPost('trx_dat1');
        $cabang = $this->request->getPost('cab_code');
        $tgl1 = strtotime($tanggal1);
        $tgl2 = strtotime($tanggal2);

        $moddelete->_deleteperformance();
        if ($cabang == '') {
            $dttunggakan = $model->get_pinjamana();
        } else {
            $dttunggakan = $model->get_pinjaman($cabang);
        }

        foreach ($dttunggakan->getResult() as $row1) {
            $norekening = $row1->knt_code;
            $agt_numb = $row1->agt_numb;
            $a_trx_amnh = 0;
            $a_tgk_pokk = 0;
            $a_tgk_bung = 0;
            $a_tgk_admn = 0;
            $v_tgk_pokk = 0;
            $v_tgk_bung = 0;
            $v_tgk_admn = 0;
            $v_byr_pokk = 0;
            $dbpinjaman = $model->get_dtlpinjaman($norekening);
            $i = 0;
            foreach ($dbpinjaman->getResult() as $row) {

                $a_trx_amnh = $row->trx_amnh;
            }

            if (empty($a_trx_amnh)) {
                $a_trx_amnh = 0;
            }

            $dbbyrpokok = $model->get_dtbayarpokok($norekening, $tanggal1);
            $i = 0;
            foreach ($dbbyrpokok->getResult() as $row) {

                $v_byr_pokk = $row->trx_amnh;
            }

            if (empty($v_byr_pokk)) {
                $v_byr_pokk = 0;
            }

            $awal = $model->get_dttunggakanawal($norekening, $tanggal1);
            $i = 0;
            foreach ($awal->getResult() as $row) {

                $a_tgk_pokk = $row->tgk_pokk;
                $a_tgk_bung = $row->tgk_bung;
                $a_tgk_admn = $row->tgk_admn;
            }

            if (empty($a_tgk_pokk)) {
                $a_tgk_pokk = 0;
            }
            if (empty($a_tgk_bung)) {
                $a_tgk_bung = 0;
            }
            if (empty($a_tgk_admn)) {
                $a_tgk_admn = 0;
            }
            $awal = $model->get_dttunggakan1($norekening, $tgl1, $tgl2);
            $i = 0;
            foreach ($awal->getResult() as $row) {

                $v_tgk_pokk = $row->tgk_pokk;
                $v_tgk_bung = $row->tgk_bung;
                $v_tgk_admn = $row->tgk_admn;

                if (empty($v_tgk_pokk)) {
                    $v_tgk_pokk = 0;
                }
                if (empty($v_tgk_bung)) {
                    $v_tgk_bung = 0;
                }
                if (empty($v_tgk_admn)) {
                    $v_tgk_admn = 0;
                }
            }
            $data = array(
                'knt_code' => $norekening,
                'per_pokk' => $a_trx_amnh,
                'awl_pokk' => $a_tgk_pokk,
                'awl_bung' => $a_tgk_bung,
                'awl_admn' => $a_tgk_admn,
                'trx_pokk' => $v_tgk_pokk,
                'trx_bung' => $v_tgk_bung,
                'trx_admn' => $v_tgk_admn,
                'byr_pokk' => $v_byr_pokk,
                'agt_numb' => $agt_numb,
                'com_code' => 1,
                'kode_cabang'  => session()->get('kode_cabang'),
            );

            $modsave->_save_performance($data);
        }
        $data['tgl1'] = $tanggal1;
        $data['tgl2'] = $tanggal2;
        $data['v_report'] = $model->_get_perfromance($tanggal1, $tanggal2)->getResult();
        return view('print/pembiayaan/rptperformance', $data);
    }

    public function get_pembayaranlunas()
    {
        $model = new Report_Model();
        $tanggal1 = $this->request->getPost('tanggal1');
        $tanggal2 = $this->request->getPost('tanggal2');
        $cabang = $this->request->getPost('kodecabang');
        if ($cabang != '') {
            $data = $model->_get_lunaspembiayaancab($tanggal1, $tanggal2, $cabang)->getResult();
        } else {
            $data = $model->_get_lunaspembiayaan($tanggal1, $tanggal2)->getResult();
        }


        echo json_encode($data);
    }

    public function printpembayaranlunas()
    {
        $model = new Report_Model();
        $tanggal1 = $this->request->getPost('trx_date');
        $tanggal2 = $this->request->getPost('trx_dat1');
        $cabang = $this->request->getPost('cab_code');
        $data['tgl1'] = $tanggal1;
        $data['tgl2'] = $tanggal2;
        if ($cabang != '') {
            $data['v_report'] = $model->_get_lunaspembiayaancab($tanggal1, $tanggal2, $cabang)->getResult();
        } else {
            $data['v_report'] = $model->_get_lunaspembiayaan($tanggal1, $tanggal2)->getResult();
        }

        return view('print/pembiayaan/rptlunaspembiayaan', $data);
    }

    public function getanggota()
    {
        $model = new Report_Model();
        $tanggal1 = $this->request->getPost('tanggal1');
        $tanggal2 = $this->request->getPost('tanggal2');

        $data = $model->_get_rptanggota($tanggal1, $tanggal2)->getResult();

        echo json_encode($data);
    }
    public function printanggota()
    {
        $model = new Report_Model();
        $tanggal1 = $this->request->getPost('trx_date');
        $tanggal2 = $this->request->getPost('trx_dat1');
        $data['tgl1'] = $tanggal1;

        $data['v_report'] = $model->_get_rptanggota($tanggal1, $tanggal2)->getResult();
        return view('print/rptanggota', $data);
    }

    public function printposisikas()
    {
        $model = new Model_git();
        $tanggal1 = $this->request->getPost('trx_date');
        $tanggal2 = $this->request->getPost('trx_dat1');
        $jnstrans = $this->request->getPost('bnk_code');
        $cabang = $this->request->getPost('cab_code');
        $data['tgl1'] = $tanggal1;
        $data['tgl2'] = $tanggal2;
        if ($cabang == '') {
            $data['v_sawal'] = $model->_get_awalkas($tanggal1, $jnstrans)->getResult();
            $data['v_report'] = $model->_rptkasumum($tanggal1, $tanggal2, $jnstrans)->getResult();
        } else {
            $data['v_sawal'] = $model->_get_awalkascab($tanggal1, $jnstrans, $cabang)->getResult();
            $data['v_report'] = $model->_rptkasumumcab($tanggal1, $tanggal2, $jnstrans, $cabang)->getResult();
        }

        return view('print/kas/rptposisikas', $data);
    }

    public function get_performance()
    {
        $model = new Report_Model();


        $modsave = new Save_model();
        $moddelete = new Delete_model();
        $tanggal1 = $this->request->getPost('tanggal1');
        $tanggal2 = $this->request->getPost('tanggal2');
        $cabang = $this->request->getPost('cabang');
        $tgl1 = strtotime($tanggal1);
        $tgl2 = strtotime($tanggal2);

        $moddelete->_deleteperformance();
        if ($cabang == '') {
            $dttunggakan = $model->get_pinjamana();
        } else {
            $dttunggakan = $model->get_pinjaman($cabang);
        }

        foreach ($dttunggakan->getResult() as $row1) {
            $norekening = $row1->knt_code;
            $agt_numb = $row1->agt_numb;
            $a_trx_amnh = 0;
            $a_tgk_pokk = 0;
            $a_tgk_bung = 0;
            $a_tgk_admn = 0;
            $v_tgk_pokk = 0;
            $v_tgk_bung = 0;
            $v_tgk_admn = 0;
            $v_byr_pokk = 0;
            $dbpinjaman = $model->get_dtlpinjaman($norekening);
            $i = 0;
            foreach ($dbpinjaman->getResult() as $row) {

                $a_trx_amnh = $row->trx_amnh;
            }

            if (empty($a_trx_amnh)) {
                $a_trx_amnh = 0;
            }

            $dbbyrpokok = $model->get_dtbayarpokok($norekening, $tanggal2);
            $i = 0;
            foreach ($dbbyrpokok->getResult() as $row) {

                $v_byr_pokk = $row->lns_pokk;
            }

            if (empty($v_byr_pokk)) {
                $v_byr_pokk = 0;
            }

            $awal = $model->get_dttunggakanawal($norekening, $tanggal1);
            $i = 0;
            foreach ($awal->getResult() as $row) {

                $a_tgk_pokk = $row->tgk_pokk;
                $a_tgk_bung = $row->tgk_bung;
                $a_tgk_admn = $row->tgk_admn;
            }

            if (empty($a_tgk_pokk)) {
                $a_tgk_pokk = 0;
            }
            if (empty($a_tgk_bung)) {
                $a_tgk_bung = 0;
            }
            if (empty($a_tgk_admn)) {
                $a_tgk_admn = 0;
            }
            $awal = $model->get_dttunggakan1($norekening, $tgl1, $tgl2);
            $i = 0;
            foreach ($awal->getResult() as $row) {

                $v_tgk_pokk = $row->tgk_pokk;
                $v_tgk_bung = $row->tgk_bung;
                $v_tgk_admn = $row->tgk_admn;

                if (empty($v_tgk_pokk)) {
                    $v_tgk_pokk = 0;
                }
                if (empty($v_tgk_bung)) {
                    $v_tgk_bung = 0;
                }
                if (empty($v_tgk_admn)) {
                    $v_tgk_admn = 0;
                }
            }
            $data = array(
                'knt_code' => $norekening,
                'per_pokk' => $a_trx_amnh,
                'awl_pokk' => $a_tgk_pokk,
                'awl_bung' => $a_tgk_bung,
                'awl_admn' => $a_tgk_admn,
                'trx_pokk' => $v_tgk_pokk,
                'trx_bung' => $v_tgk_bung,
                'trx_admn' => $v_tgk_admn,
                'byr_pokk' => $v_byr_pokk,
                'agt_numb' => $agt_numb,
                'com_code' => 1,
                'kode_cabang'  => session()->get('kode_cabang'),
            );

            $modsave->_save_performance($data);
        }



        $data = $model->_get_perfromance($tanggal1, $tanggal2)->getResult();

        echo json_encode($data);
    }
    //---------------------------


}
