<?php

namespace App\Controllers;

// defined('BASEPATH') OR exit('No direct script access allowed');
use CodeIgniter\Controller;
use App\Models\Accounting_model;
use App\Models\M_login;
use TCPDF;

$session = \Config\Services::session();
class Repaccounting extends BaseController
{
    protected $session;


    function __construct()
    {

        $this->session = \Config\Services::session();
        $this->session->start();
        // parent::__construct();
        // $this->load->model('Gitlist_model','gitlist_model');
        // $this->load->library('session');
    }


    public function neraca()
    {
        $model = new Accounting_model();
        $mcek = new M_login();
        $bulan = $this->request->getPost('kin_buln');
        $tahun = $this->request->getPost('kin_tahn');
        $cabang1 = $this->request->getPost('cab_code');
        $jnslap = $this->request->getPost('kns_code');
        if ($jnslap == '01') {
            $cabang = $cabang1;
            $judul1 = 'CABANG ';
            $namacabang = $mcek->get_getcabang($cabang);
            $judul2 = $namacabang['nama_cabang'];
        } else {
            $cabang = '';
            $judul1 = 'KONSOLIDASI';
            $judul2 = '';
        }
        $tahun1 = $tahun - 1;
        if ($bulan == 1) {
            $nbulan = "Januari";
        } else if ($bulan == 2) {
            $nbulan = "Februari ";
        } else if ($bulan == 3) {
            $nbulan = "Maret ";
        } else if ($bulan == 4) {
            $nbulan = "April ";
        } else if ($bulan == 5) {
            $nbulan = "Mei ";
        } else if ($bulan == 6) {
            $nbulan = "Juni ";
        } else if ($bulan == 7) {
            $nbulan = "Juli ";
        } else if ($bulan == 8) {
            $nbulan = "Agustus ";
        } else if ($bulan == 9) {
            $nbulan = "September ";
        } else if ($bulan == 10) {
            $nbulan = "Oktober ";
        } else if ($bulan == 11) {
            $nbulan = "November ";
        } else if ($bulan == 12) {
            $nbulan = "Desember ";
        }

        // $html = view('rpt/accounting/neraca.php');
        $pdf = new TCPDF('P', PDF_UNIT, 'A4', true, 'UTF-8', false);

        $pdf->SetCreator(PDF_CREATOR);
        $pdf->SetAuthor('GIT');
        $pdf->SetTitle('Neraca');
        $pdf->SetSubject('Neraca');

        $pdf->setPrintHeader(false);
        $pdf->setPrintFooter(false);

        $pdf->addPage();
        $image_file = 'assets/images/' . $_SESSION['com_logo'];
        /**
         * width : 50
         */


        $image_file = 'assets/images/' . $_SESSION['com_logo'];

        /**
         * width : 50
         */
        $pdf->Image($image_file, '', '', 20);

        // Set font
        $pdf->SetFont('helvetica', 'B', 11);
        $pdf->SetX(40);
        $pdf->Cell(0, 2, $_SESSION['com_name'], 0, 1, '', 0, '', 0);

        $pdf->SetX(40);
        $pdf->SetFont('helvetica', '', 8);
        $pdf->Cell(0, 2, $_SESSION['com_adrs'], 0, 1, '', 0, '', 0);

        // $pdf->SetX(40);
        // Title

        $pdf->Ln();


        $pdf->Ln(2);
        $pdf->SetFont('helvetica', '', 11);
        $pdf->Cell(190, 2, 'LAPORAN NERACA '  . $judul2, 0, 1, 'C');


        $pdf->Cell(190, 2, 'Bulan ' . $nbulan . ' Tahun : ' . $tahun, 0, 1, 'C');

        $pdf->SetFont('helvetica', '', 9);

        $pdf->Ln();
        $pdf->Cell(130, 10, 'Keterangan', 1, 0, 'C');
        $pdf->Cell(30, 10, $nbulan . ' ' . $tahun, 1, 0, 'C');
        $pdf->Cell(30, 10, $nbulan . ' ' . $tahun1, 1, 0, 'C');

        $pdf->Ln();


        $i = 0;
        $grup1 = '1';
        $grup2 = '2';

        $accgrup = $model->_get_grpneraca($grup1, $grup2);

        foreach ($accgrup->getResult() as $rowgrp) {
            $total = 0;
            $total1 = 0;
            $grup = $rowgrp->acc_grup;

            $pdf->Cell(10, 2, $rowgrp->acc_ngrp, 0, 1, '', 0, '', 0);
            $acc_klas1 = '1';
            $acc_klas2 = '3';
            $account = $model->_get_neraca($acc_klas1, $acc_klas2, $grup);

            foreach ($account->getResult() as $row) {
                $acc_code = $row->acc_code;

                $subtotal = 0;
                $subtotal1 = 0;

                $pdf->Cell(10, 2, $row->acc_name, 0, 1, '', 0, '', 0);


                $dtaccount = $model->_get_neraca1($acc_code);


                foreach ($dtaccount->getResult() as $row1) {
                    $v_acc_code1 = substr($row1->acc_cod1, 0, 4);

                    // $i=$i+1;
                    if ($cabang != '') {
                        $nilai = $model->_get_nilaicab($v_acc_code1, $bulan, $tahun, $cabang);
                    } else {
                        $nilai = $model->_get_nilai($v_acc_code1, $bulan, $tahun);
                    }

                    $trx_amnt = 0;

                    foreach ($nilai->getResult() as $nil) {
                        $trx_amnt = $nil->acc_akhc;
                    }

                    $subtotal = $subtotal + $trx_amnt;
                    // $total = $total + $trx_amnt;
                    if ($row->acc_nblc == 'K') {

                        if ($grup == '1') {
                            $total = $total - $trx_amnt;
                        } else {
                            $total = $total + $trx_amnt;
                        }
                    } else {
                        $total = $total + $trx_amnt;
                    }

                    $tahun1 = $tahun - 1;
                    if ($cabang != '') {
                        $nilai1 = $model->_get_nilaicab($v_acc_code1, $bulan, $tahun1, $cabang);
                    } else {
                        $nilai1 = $model->_get_nilai($v_acc_code1, $bulan, $tahun1);
                    }

                    foreach ($nilai1->getResult() as $nil) {
                        $trx_amnt1 = $nil->acc_akhc;
                    }

                    $subtotal1 = $subtotal1 + $trx_amnt1;
                    // $total1 = $total1 + $trx_amnt1;
                    if ($row->acc_nblc == 'K') {
                        if ($grup == '1') {
                            $total1 = $total1 - $trx_amnt1;
                        } else {
                            $total1 = $total1 + $trx_amnt1;
                        }

                        // $subtotal=$subtotal-$trx_amnt;
                    } else {
                        $total1 = $total1 + $trx_amnt1;
                        // $subtotal=$subtotal+$trx_amnt;
                    }
                    // if ($trx_amnt != 0) {
                    $i = $i + 1;
                    $pdf->Cell(10, 2, '', 0, 0, 'C');
                    $pdf->Cell(120, 2, $row1->acc_name, 0, 0, 'L');
                    $pdf->Cell(30, 2, number_format($trx_amnt), 0, 0, 'R');
                    $pdf->Cell(30, 2, number_format($trx_amnt1), 0, 0, 'R');

                    $pdf->Ln();
                }


                // $pdf->Ln();
                $pdf->Cell(130, 1, '', 0, 0, 'L');
                $pdf->Cell(30, 1, '________________', 0, 0, 'R');
                $pdf->Cell(30, 1, '________________', 0, 0, 'R');
                $pdf->Ln();
                $pdf->Cell(130, 2, 'SUB TOTAL' . $row->acc_name, 0, 0, 'L');
                $pdf->Cell(30, 2, number_format($subtotal), 0, 0, 'R');
                $pdf->Cell(30, 2, number_format($subtotal1), 0, 0, 'R');
                $pdf->Ln();
                $pdf->Ln();
                // sub total
                // if ($subtotal != 0) {
                $i = $i + 1;

                // $subtotal=$subtotal+$trx_amnt;

                // $data = array(

                // 'acc_cod1' => 'BRS',
                // 'urut' => $i,
                // 'acc_nam1' => 'SUB TOTAL ' . $row->acc_name,
                // 'acc_nil1' => $subtotal,
                // 'acc_nil1a' => $subtotal1,
                // 'com_code' => 1,
                // 'acc_levl' => $row->acc_levl,

                // );
                // $modsave->_saveneraca($data);
                // }
            }

            // $pdf->Cell(5, 2, '', 0, 0, 'C');

            $pdf->Cell(130, 1, '', 0, 0, 'L');
            $pdf->Cell(30, 1, '________________', 0, 0, 'R');
            $pdf->Cell(30, 1, '________________', 0, 0, 'R');
            $pdf->Ln();
            $pdf->Cell(130, 2, 'TOTAL ' . $rowgrp->acc_ngrp, 0, 0, 'L');
            $pdf->Cell(30, 2, number_format($total), 0, 0, 'R');
            $pdf->Cell(30, 2, number_format($total1), 0, 0, 'R');
            $pdf->Ln();
            $pdf->Cell(130, 1, '', 0, 0, 'L');
            $pdf->Cell(30, 1, '________________', 0, 0, 'R');
            $pdf->Cell(30, 1, '________________', 0, 0, 'R');
            $pdf->Ln();
        }

        // output the HTML content
        // $pdf->writeHTML($html, true, false, true, false, '');
        //line ini penting
        $this->response->setContentType('application/pdf');
        //Close and output PDF document
        $pdf->Output('rl32.pdf', 'I');
    }


    public function labarugi()
    {
        $model = new Accounting_model();
        $mcek = new M_login();
        $bulan = $this->request->getPost('kin_buln');
        $tahun = $this->request->getPost('kin_tahn');

        $cabang1 = $this->request->getPost('cab_code');
        $jnslap = $this->request->getPost('kns_code');
        if ($jnslap == '01') {
            $cabang = $cabang1;
            $judul1 = 'CABANG ';
            $namacabang = $mcek->get_getcabang($cabang);
            $judul2 = $namacabang['nama_cabang'];
        } else {
            $cabang = '';
            $judul1 = 'KONSOLIDASI';
            $judul2 = '';
        }
        $tahun1 = $tahun - 1;
        if ($bulan == 1) {
            $nbulan = "Januari";
        } else if ($bulan == 2) {
            $nbulan = "Februari ";
        } else if ($bulan == 3) {
            $nbulan = "Maret ";
        } else if ($bulan == 4) {
            $nbulan = "April ";
        } else if ($bulan == 5) {
            $nbulan = "Mei ";
        } else if ($bulan == 6) {
            $nbulan = "Juni ";
        } else if ($bulan == 7) {
            $nbulan = "Juli ";
        } else if ($bulan == 8) {
            $nbulan = "Agustus ";
        } else if ($bulan == 9) {
            $nbulan = "September ";
        } else if ($bulan == 10) {
            $nbulan = "Oktober ";
        } else if ($bulan == 11) {
            $nbulan = "November ";
        } else if ($bulan == 12) {
            $nbulan = "Desember ";
        }
        // $html = view('rpt/accounting/neraca.php');
        $pdf = new TCPDF('P', PDF_UNIT, 'A4', true, 'UTF-8', false);

        $pdf->SetCreator(PDF_CREATOR);
        $pdf->SetAuthor('GIT');
        $pdf->SetTitle('Laba Rugi');
        $pdf->SetSubject('Laba Rugi');

        $pdf->setPrintHeader(false);
        $pdf->setPrintFooter(false);

        $pdf->addPage();
        $image_file = 'assets/images/' . $_SESSION['com_logo'];
        /**
         * width : 50
         */


        $image_file = 'assets/images/' . $_SESSION['com_logo'];

        /**
         * width : 50
         */
        $pdf->Image($image_file, '', '', 20);

        // Set font
        $pdf->SetFont('helvetica', 'B', 11);
        $pdf->SetX(40);
        $pdf->Cell(0, 2, $_SESSION['com_name'], 0, 1, '', 0, '', 0);

        $pdf->SetX(40);
        $pdf->SetFont('helvetica', '', 8);
        $pdf->Cell(0, 2, $_SESSION['com_adrs'], 0, 1, '', 0, '', 0);

        // $pdf->SetX(40);
        // Title

        $pdf->Ln();


        $pdf->Ln();
        $pdf->SetFont('helvetica', '', 10);
        $pdf->Cell(190, 2, 'LAPORAN LABA RUGI '  . $judul2, 0, 1, 'C');


        $pdf->Cell(190, 2, 'Bulan ' . $nbulan . ' Tahun : ' . $tahun, 0, 1, 'C');

        $pdf->SetFont('helvetica', '', 9);

        $pdf->Ln();
        $pdf->Cell(130, 10, 'Keterangan', 1, 0, 'C');
        $pdf->Cell(30, 10, $nbulan . ' ' . $tahun, 1, 0, 'C');
        $pdf->Cell(30, 10, $nbulan . ' ' . $tahun1, 1, 0, 'C');

        $pdf->Ln();

        $total = 0;
        $total1 = 0;
        $i = 0;
        $grup = '3';
        $grup2 = '9';
        $accgrup = $model->_get_grpneraca($grup, $grup2);
        foreach ($accgrup->getResult() as $rowgrp) {
            $grup = $rowgrp->acc_grup;

            $pdf->Cell(10, 2, $rowgrp->acc_ngrp, 0, 1, '', 0, '', 0);
            $acc_klas1 = '3';
            $acc_klas2 = '9';
            $account = $model->_get_neraca($acc_klas1, $acc_klas2, $grup);
            foreach ($account->getResult() as $row) {
                $acc_code = $row->acc_code;


                $subtotal = 0;
                $subtotal1 = 0;
                $pdf->Cell(10, 2, $row->acc_name, 0, 1, '', 0, '', 0);


                $dtaccount = $model->_get_neraca1($acc_code);


                foreach ($dtaccount->getResult() as $row1) {
                    $v_acc_code1 = substr($row1->acc_cod1, 0, 4);

                    // $i=$i+1;
                    if ($cabang != '') {
                        $nilai = $model->_get_nilaicab($v_acc_code1, $bulan, $tahun, $cabang);
                    } else {
                        $nilai = $model->_get_nilai($v_acc_code1, $bulan, $tahun);
                    }

                    $trx_amnt = 0;

                    foreach ($nilai->getResult() as $nil) {
                        $trx_amnt = $nil->acc_akhc;
                    }

                    $subtotal = $subtotal + $trx_amnt;

                    if ($row->acc_nblc == 'D') {
                        $total = $total - $trx_amnt;
                    } else {
                        $total = $total + $trx_amnt;
                    }

                    $tahun1 = $tahun - 1;
                    if ($cabang != '') {
                        $nilai1 = $model->_get_nilaicab($v_acc_code1, $bulan, $tahun1, $cabang);
                    } else {
                        $nilai1 = $model->_get_nilai($v_acc_code1, $bulan, $tahun1);
                    }

                    foreach ($nilai1->getResult() as $nil1) {
                        $trx_amnt1 = $nil1->acc_akhc;
                    }

                    $subtotal1 = $subtotal1 + $trx_amnt1;

                    if ($row->acc_nblc == 'D') {
                        $total1 = $total1 - $trx_amnt1;
                        // $subtotal=$subtotal-$trx_amnt;
                    } else {
                        $total1 = $total1 + $trx_amnt1;
                        // $subtotal=$subtotal+$trx_amnt;
                    }
                    // if ($trx_amnt != 0) {
                    $i = $i + 1;

                    $pdf->Cell(10, 2, '', 0, 0, 'C');
                    $pdf->Cell(120, 2,  $row1->acc_name, 0, 0, 'L');
                    $pdf->Cell(30, 2, number_format($trx_amnt), 0, 0, 'R');
                    $pdf->Cell(30, 2, number_format($trx_amnt1), 0, 0, 'R');

                    $pdf->Ln();
                }

                $pdf->Cell(130, 1, '', 0, 0, 'L');
                $pdf->Cell(30, 1, '________________', 0, 0, 'R');
                $pdf->Cell(30, 1, '________________', 0, 0, 'R');
                $pdf->Ln();
                $pdf->Ln();
                $pdf->Cell(5, 2, '', 0, 0, 'C');
                $pdf->Cell(125, 2, 'Sub Total ' . $row->acc_name, 0, 0, 'L');
                $pdf->Cell(30, 2, number_format($subtotal), 0, 0, 'R');
                $pdf->Cell(30, 2, number_format($subtotal1), 0, 0, 'R');
                $pdf->Ln();

                // sub total
                // if ($subtotal != 0) {
                $i = $i + 1;
            }

            if ($rowgrp->acc_grup == 3) {
                $rname = "Laba Kotor";
            } else if ($rowgrp->acc_grup == 4) {
                $rname = "Laba Bersih Sebelum Pajak";
            } else if ($rowgrp->acc_grup == 5) {
                $rname = "Laba Setelah Pajak";
            }
            $pdf->Cell(130, 1, '', 0, 0, 'L');
            $pdf->Cell(30, 1, '________________', 0, 0, 'R');
            $pdf->Cell(30, 1, '________________', 0, 0, 'R');
            $pdf->Ln();
            $pdf->Cell(5, 2, '', 0, 0, 'C');
            $pdf->Cell(125, 2, $rname, 0, 0, 'L');
            $pdf->Cell(30, 2, number_format($total), 0, 0, 'R');
            $pdf->Cell(30, 2, number_format($total1), 0, 0, 'R');
            $pdf->Ln();
            $pdf->Cell(130, 1, '', 0, 0, 'L');
            $pdf->Cell(30, 1, '________________', 0, 0, 'R');
            $pdf->Cell(30, 1, '________________', 0, 0, 'R');
            $pdf->Ln();
            $pdf->Ln();
        }



        // output the HTML content


        // $pdf->writeHTML($html, true, false, true, false, '');
        //line ini penting

        $this->response->setContentType('application/pdf');


        //Close and output PDF document
        $pdf->Output('rl32.pdf', 'I');
    }

    public function perubahanmodal()
    {
        $model = new Accounting_model();
        $bulan = $this->request->getPost('kin_buln');
        $tahun = $this->request->getPost('kin_tahn');
        $tahun1 = $tahun - 1;
        if ($bulan == 1) {
            $nbulan = "Januari";
        } else if ($bulan == 2) {
            $nbulan = "Februari ";
        } else if ($bulan == 3) {
            $nbulan = "Maret ";
        } else if ($bulan == 4) {
            $nbulan = "April ";
        } else if ($bulan == 5) {
            $nbulan = "Mei ";
        } else if ($bulan == 6) {
            $nbulan = "Juni ";
        } else if ($bulan == 7) {
            $nbulan = "Juli ";
        } else if ($bulan == 8) {
            $nbulan = "Agustus ";
        } else if ($bulan == 9) {
            $nbulan = "September ";
        } else if ($bulan == 10) {
            $nbulan = "Oktober ";
        } else if ($bulan == 11) {
            $nbulan = "November ";
        } else if ($bulan == 12) {
            $nbulan = "Desember ";
        }
        // $html = view('rpt/accounting/neraca.php');
        $pdf = new TCPDF('P', PDF_UNIT, 'A4', true, 'UTF-8', false);

        $pdf->SetCreator(PDF_CREATOR);
        $pdf->SetAuthor('GIT');
        $pdf->SetTitle('Laba Rugi');
        $pdf->SetSubject('Laba Rugi');

        $pdf->setPrintHeader(false);
        $pdf->setPrintFooter(false);

        $pdf->addPage();
        $image_file = 'assets/images/' . $_SESSION['com_logo'];
        /**
         * width : 50
         */


        $image_file = 'assets/images/' . $_SESSION['com_logo'];

        /**
         * width : 50
         */
        $pdf->Image($image_file, '', '', 20);

        // Set font
        $pdf->SetFont('helvetica', 'B', 11);
        $pdf->SetX(40);
        $pdf->Cell(0, 2, $_SESSION['com_name'], 0, 1, '', 0, '', 0);

        $pdf->SetX(40);
        $pdf->SetFont('helvetica', '', 8);
        $pdf->Cell(0, 2, $_SESSION['com_adrs'], 0, 1, '', 0, '', 0);

        // $pdf->SetX(40);
        // Title

        $pdf->Ln();


        $pdf->Ln();
        $pdf->SetFont('helvetica', '', 11);
        $pdf->Cell(190, 2, 'LAPORAN PERUBAHAN EKUITAS', 0, 1, 'C');


        $pdf->Cell(190, 2, 'Bulan ' . $nbulan . ' Tahun : ' . $tahun, 0, 1, 'C');

        $pdf->SetFont('helvetica', '', 9);

        $pdf->Ln();
        $pdf->Cell(130, 10, 'Keterangan', 1, 0, 'C');
        $pdf->Cell(30, 10, $nbulan . ' ' . $tahun, 1, 0, 'C');
        $pdf->Cell(30, 10, $nbulan . ' ' . $tahun1, 1, 0, 'C');

        $pdf->Ln();

        $total = 0;
        $total1 = 0;
        $i = 0;
        $grup = '2';
        $grup2 = '2';
        $accgrup = $model->_get_grpneraca($grup, $grup2);
        foreach ($accgrup->getResult() as $rowgrp) {
            $grup = $rowgrp->acc_grup;

            $pdf->Cell(10, 2, '', 0, 1, '', 0, '', 0);
            $acc_klas1 = '3';
            $acc_klas2 = '3';
            $account = $model->_get_perubahan($acc_klas1, $acc_klas2, $grup);
            foreach ($account->getResult() as $row) {
                $acc_code = $row->acc_cod1;

                $subtotal = 0;
                $subtotal1 = 0;
                $pdf->Cell(10, 2, 'Saldo Awal', 0, 1, '', 0, '', 0);


                $dtaccount = $model->_get_neraca1($acc_code);

                $totpenambahan = 0;
                $totpenambahan1 = 0;
                foreach ($dtaccount->getResult() as $row1) {
                    $v_acc_code1 = $row1->acc_cod1;

                    // $i=$i+1;
                    $nilai = $model->_get_nilai($v_acc_code1, $bulan, $tahun);
                    $trx_amnt = 0;

                    foreach ($nilai->getResult() as $nil) {
                        $trx_amnt = $nil->acc_akhc;
                    }

                    $subtotal = $subtotal + $trx_amnt;

                    if ($row->acc_nblc == 'K') {
                        $total = $total - $trx_amnt;
                    } else {
                        $total = $total + $trx_amnt;
                    }

                    $tahun1 = $tahun - 1;
                    $nilai1 = $model->_get_nilai($v_acc_code1, $bulan, $tahun1);
                    foreach ($nilai1->getResult() as $nil) {
                        $trx_amnt1 = $nil->acc_akhc;
                    }

                    $subtotal1 = $subtotal1 + $trx_amnt1;

                    if ($row->acc_nblc == 'K') {
                        $total1 = $total1 - $trx_amnt1;
                        // $subtotal=$subtotal-$trx_amnt;
                    } else {
                        $total1 = $total1 + $trx_amnt1;
                        // $subtotal=$subtotal+$trx_amnt;
                    }
                    // if ($trx_amnt != 0) {
                    $i = $i + 1;

                    $pdf->Cell(10, 2, '', 0, 0, 'C');
                    $pdf->Cell(120, 2, $row1->acc_name, 0, 0, 'L');
                    $pdf->Cell(30, 2, number_format($trx_amnt), 0, 0, 'R');
                    $pdf->Cell(30, 2, number_format($trx_amnt1), 0, 0, 'R');

                    $pdf->Ln();
                    if ($v_acc_code1 == '311') {
                        $pdf->Ln();
                        $pdf->Cell(10, 2, 'Penambahan', 0, 1, '', 0, '', 0);
                    } else {
                        $totpenambahan = $totpenambahan + $trx_amnt;
                        $totpenambahan1 = $totpenambahan1 + $trx_amnt1;
                    }
                }
                $pdf->Ln();
                $pdf->Cell(130, 1, '', 0, 0, 'L');
                $pdf->Cell(30, 1, '________________', 0, 0, 'R');
                $pdf->Cell(30, 1, '________________', 0, 0, 'R');

                $pdf->Ln();
                $pdf->Cell(10, 2, '', 0, 0, 'C');
                $pdf->Cell(120, 2, 'Jumlah Penambahan', 0, 0, 'L');
                $pdf->Cell(30, 2, number_format($totpenambahan), 0, 0, 'R');
                $pdf->Cell(30, 2, number_format($totpenambahan1), 0, 0, 'R');
                $pdf->Ln();
                $pdf->Cell(130, 1, '', 0, 0, 'L');
                $pdf->Cell(30, 1, '________________', 0, 0, 'R');
                $pdf->Cell(30, 1, '________________', 0, 0, 'R');
                $pdf->Ln();
                $pdf->Ln();
                // $pdf->Cell(5, 2, '', 0, 0, 'C');
                $pdf->Cell(130, 2, 'Jumlah Akhir Ekuitas ', 0, 0, 'L');
                $pdf->Cell(30, 2, number_format($subtotal), 0, 0, 'R');
                $pdf->Cell(30, 2, number_format($subtotal1), 0, 0, 'R');
                $pdf->Ln();

                // sub total
                // if ($subtotal != 0) {
                $i = $i + 1;
            }

            // if ($rowgrp->acc_grup == 3) {
            // $rname = "Laba Kotor";
            // } else if ($rowgrp->acc_grup == 4) {
            // $rname = "Laba Bersih Sebelum Pajak";
            // } else if ($rowgrp->acc_grup == 5) {
            // $rname = "Laba Setelah Pajak";
            // }
            // $pdf->Cell(130, 1, '', 0, 0, 'L');
            // $pdf->Cell(30, 1, '________________', 0, 0, 'R');
            // $pdf->Cell(30, 1, '________________', 0, 0, 'R');
            // $pdf->Ln();
            // $pdf->Cell(5, 2, '', 0, 0, 'C');
            // $pdf->Cell(125, 2, $rname, 0, 0, 'L');
            // $pdf->Cell(30, 2, number_format($total), 0, 0, 'R');
            // $pdf->Cell(30, 2, number_format($total1), 0, 0, 'R');
            // $pdf->Ln();
            // $pdf->Cell(130, 1, '', 0, 0, 'L');
            // $pdf->Cell(30, 1, '________________', 0, 0, 'R');
            // $pdf->Cell(30, 1, '________________', 0, 0, 'R');
            // $pdf->Ln();
            // $pdf->Ln();
        }



        // output the HTML content


        // $pdf->writeHTML($html, true, false, true, false, '');
        //line ini penting

        $this->response->setContentType('application/pdf');


        //Close and output PDF document
        $pdf->Output('rl32.pdf', 'I');
    }
    public function neracasaldo()
    {
        $model = new Accounting_model();
        $mcek = new M_login();
        $bulan = $this->request->getPost('kin_buln');
        $tahun = $this->request->getPost('kin_tahn');
        $cabang = $this->request->getPost('cab_code');
        if ($cabang != '01') {
            $cabang1 = $cabang;
            $judul1 = 'CABANG ';
            $namacabang = $mcek->get_getcabang($cabang);
            $judul2 = $namacabang['nama_cabang'];
        } else {
            $cabang = '';
            $judul1 = 'KONSOLIDASI';
            $judul2 = 'KONSOLIDASI';
        }

        $tahun1 = $tahun - 1;
        if ($bulan == 1) {
            $nbulan = "Januari";
        } else if ($bulan == 2) {
            $nbulan = "Februari ";
        } else if ($bulan == 3) {
            $nbulan = "Maret ";
        } else if ($bulan == 4) {
            $nbulan = "April ";
        } else if ($bulan == 5) {
            $nbulan = "Mei ";
        } else if ($bulan == 6) {
            $nbulan = "Juni ";
        } else if ($bulan == 7) {
            $nbulan = "Juli ";
        } else if ($bulan == 8) {
            $nbulan = "Agustus ";
        } else if ($bulan == 9) {
            $nbulan = "September ";
        } else if ($bulan == 10) {
            $nbulan = "Oktober ";
        } else if ($bulan == 11) {
            $nbulan = "November ";
        } else if ($bulan == 12) {
            $nbulan = "Desember ";
        }
        if ($bulan == 1) {
            $bulan1 = 12;
            $tahun1 = $tahun - 1;
        } else {
            $bulan1 = $bulan;
            $tahun1 = $tahun;
        }
        // $html = view('rpt/accounting/neraca.php');
        $pdf = new TCPDF('P', PDF_UNIT, 'A4', true, 'UTF-8', false);

        $pdf->SetCreator(PDF_CREATOR);
        $pdf->SetAuthor('GIT');
        $pdf->SetTitle('Neraca Saldo');
        $pdf->SetSubject('Neraca Saldo');

        $pdf->setPrintHeader(false);
        $pdf->setPrintFooter(false);

        $pdf->addPage();
        $image_file = 'assets/images/' . $_SESSION['com_logo'];
        /**
         * width : 50
         */


        $image_file = 'assets/images/' . $_SESSION['com_logo'];

        /**
         * width : 50
         */
        $pdf->Image($image_file, '', '', 20);

        // Set font
        $pdf->SetFont('helvetica', 'B', 11);
        $pdf->SetX(40);
        $pdf->Cell(0, 2, $_SESSION['com_name'], 0, 1, '', 0, '', 0);

        $pdf->SetX(40);
        $pdf->SetFont('helvetica', '', 8);
        $pdf->Cell(0, 2, $_SESSION['com_adrs'], 0, 1, '', 0, '', 0);

        // $pdf->SetX(40);
        // Title

        $pdf->Ln();


        $pdf->Ln();
        $pdf->SetFont('helvetica', '', 10);
        $pdf->Cell(180, 2, 'NERACA SALDO ' . $judul2, 0, 1, 'C');


        $pdf->Cell(180, 2, 'Bulan ' . $nbulan . ' Tahun : ' . $tahun, 0, 1, 'C');

        $pdf->SetFont('helvetica', '', 8);

        $pdf->Ln();
        $pdf->Cell(10, 5, 'No.', 'LT', 0, 'C');
        $pdf->Cell(17, 5, 'kode ', 'LT', 0, 'C');
        $pdf->Cell(79, 5, 'Nama Perkiraan', 'LT', 0, 'C');

        $pdf->Cell(21, 5, 'Saldo Awal', 'LT', 0, 'C');
        $pdf->Cell(21, 5, 'Debet', 'LT', 0, 'C');
        $pdf->Cell(21, 5, 'Kredit', 'LT', 0, 'C');
        $pdf->Cell(21, 5, 'Saldo Akhir', 'LTR', 0, 'C');
        $pdf->Ln();
        $pdf->Cell(10, 5, '', 'LRB', 0, 'C');
        $pdf->Cell(17, 5, 'Perkiraan', 'LB', 0, 'C');
        $pdf->Cell(79, 5, '', 'LB', 0, 'C');

        $pdf->Cell(21, 5, '', 'LB', 0, 'C');
        $pdf->Cell(21, 5, '', 'LB', 0, 'C');
        $pdf->Cell(21, 5, '', 'LB', 0, 'C');
        $pdf->Cell(21, 5, '', 'LBr', 0, 'C');

        $pdf->Ln();

        $i = 1;
        if ($cabang != '') {
        }
        $account = $model->_get_neracasaldo();
        $totdebet = 0;
        $totcredit = 0;
        foreach ($account->getResult() as $row) {
            $acc_code = $row->acc_code;
            $acc_awal = 0;
            $acc_debet = 0;
            $acc_credit = 0;
            $acc_akhc = 0;
            if ($cabang != '') {
                $salawal = $model->_get_neracaawalcab($acc_code, $bulan1, $tahun1, $cabang);
            } else {
                $salawal = $model->_get_neracaawal($acc_code, $bulan1, $tahun1);
            }

            foreach ($salawal->getResult() as $row1) {
                $acc_awal = $row->acc_akhc;
            }
            if ($cabang != '') {
                $dbtrans = $model->_get_transaksicab($acc_code, $bulan1, $tahun1, $cabang);
            } else {
                $dbtrans = $model->_get_transaksi($acc_code, $bulan1, $tahun1);
            }

            foreach ($dbtrans->getResult() as $row2) {
                $acc_debet = $row2->dbt_amnt;
                $acc_credit = $row2->crd_amnt;
            }
            if ($row->acc_nblc == 'D') {
                $acc_akhc = $acc_awal + $acc_debet - $acc_credit;
            } else {
                $acc_akhc = $acc_awal +  $acc_credit - $acc_debet;
            }
            $totdebet = $totdebet + $acc_debet;
            $totcredit = $totcredit + $acc_credit;
            $nilai = $acc_awal +  $acc_credit + $acc_debet;
            if ($nilai > 0) {
                $pdf->Cell(10, 5, $i, 0, 0, 'R');
                $pdf->Cell(17, 5, $row->acc_code, 0, 0, 'L');
                $pdf->Cell(79, 5, $row->acc_name, 0, 0, 'L');

                $pdf->Cell(21, 5, number_format($acc_awal), 0, 0, 'R');
                $pdf->Cell(21, 5, number_format($acc_debet), 0, 0, 'R');
                $pdf->Cell(21, 5, number_format($acc_credit), 0, 0, 'R');
                $pdf->Cell(21, 5, number_format($acc_akhc), 0, 0, 'R');
                $pdf->Ln();
                $i = $i + 1;
            }
        }

        $pdf->Cell(127, 1, '', 0, 0, 'L');
        $pdf->Cell(21, 1, '_____________', 0, 0, 'R');
        $pdf->Cell(21, 1, '_____________', 0, 0, 'R');
        $pdf->Ln();
        $pdf->Cell(5, 5, '', 0, 0, 'C');
        $pdf->Cell(123, 5, 'TOTAL', 0, 0, 'C');
        $pdf->Cell(21, 5, number_format($totdebet), 0, 0, 'R');
        $pdf->Cell(21, 5, number_format($totcredit), 0, 0, 'R');



        // output the HTML content



        //line ini penting

        $this->response->setContentType('application/pdf');


        //Close and output PDF document
        $pdf->Output('neracasaldo.pdf', 'I');
    }

    public function aruskas()
    {
        $model = new Accounting_model();
        $bulan = $this->request->getPost('kin_buln');
        $tahun = $this->request->getPost('kin_tahn');
        $tahun1 = $tahun - 1;
        if ($bulan == 1) {
            $nbulan = "Januari";
        } else if ($bulan == 2) {
            $nbulan = "Februari ";
        } else if ($bulan == 3) {
            $nbulan = "Maret ";
        } else if ($bulan == 4) {
            $nbulan = "April ";
        } else if ($bulan == 5) {
            $nbulan = "Mei ";
        } else if ($bulan == 6) {
            $nbulan = "Juni ";
        } else if ($bulan == 7) {
            $nbulan = "Juli ";
        } else if ($bulan == 8) {
            $nbulan = "Agustus ";
        } else if ($bulan == 9) {
            $nbulan = "September ";
        } else if ($bulan == 10) {
            $nbulan = "Oktober ";
        } else if ($bulan == 11) {
            $nbulan = "November ";
        } else if ($bulan == 12) {
            $nbulan = "Desember ";
        }
        // $html = view('rpt/accounting/neraca.php');
        $pdf = new TCPDF('P', PDF_UNIT, 'A4', true, 'UTF-8', false);

        $pdf->SetCreator(PDF_CREATOR);
        $pdf->SetAuthor('GIT');
        $pdf->SetTitle('Arus Kas');
        $pdf->SetSubject('Arus Kas');

        $pdf->setPrintHeader(false);
        $pdf->setPrintFooter(false);

        $pdf->addPage();
        $image_file = 'assets/images/' . $_SESSION['com_logo'];
        /**
         * width : 50
         */


        $image_file = 'assets/images/' . $_SESSION['com_logo'];

        /**
         * width : 50
         */
        $pdf->Image($image_file, '', '', 20);

        // Set font
        $pdf->SetFont('helvetica', 'B', 11);
        $pdf->SetX(40);
        $pdf->Cell(0, 2, $_SESSION['com_name'], 0, 1, '', 0, '', 0);

        $pdf->SetX(40);
        $pdf->SetFont('helvetica', '', 8);
        $pdf->Cell(0, 2, $_SESSION['com_adrs'], 0, 1, '', 0, '', 0);

        // $pdf->SetX(40);
        // Title

        // Footer
        // Position at 15 mm from bottom


        //

        $pdf->Ln();


        $pdf->Ln();
        $pdf->SetFont('helvetica', '', 11);
        $pdf->Cell(190, 2, 'LAPORAN ARUS KAS', 0, 1, 'C');


        $pdf->Cell(190, 2, 'Bulan ' . $nbulan . ' Tahun : ' . $tahun, 0, 1, 'C');

        $pdf->SetFont('helvetica', '', 9);

        $pdf->Ln();
        $pdf->Cell(130, 10, 'Keterangan', 1, 0, 'C');
        $pdf->Cell(30, 10, $nbulan . ' ' . $tahun, 1, 0, 'C');
        $pdf->Cell(30, 10, $nbulan . ' ' . $tahun1, 1, 0, 'C');

        $pdf->Ln();

        $total = 0;
        $total1 = 0;
        $i = 0;

        $acc_klas1 = 3;
        $acc_klas2 = 3;

        // $rugilaba = $model->_get_rugilaba();
        // $v_rlj_code = "";
        // $v_rll_code = "";
        // $v_rls_code = "";
        // foreach ($rugilaba->getResult() as $awl) {
        // $v_rlj_code = $awl->rlj_code;
        // $v_rll_code = $awl->rll_code;
        // $v_rls_code = $awl->rls_code;
        // }





        $account = $model->_get_proyeksi($acc_klas1, $acc_klas2);
        foreach ($account->getResult() as $row) {

            $acc_code = $row->acc_cod1;

            $subtotal = 0;
            $subtotal1 = 0;
            // if (substr($acc_code, 0, 1) == '4') {
            $aruskas = 'Arus Kas dari (untuk) Kas operasional';
            // } else {
            // $aruskas = 'Penyesuaian untuk rekonsialisasi perubahan dalam asset';
            // }
            $pdf->Cell(10, 2, $aruskas, 0, 1, '', 0, '', 0);


            $dtaccount = $model->_get_neraca1($acc_code);

            $totpenambahan = 0;
            $totpenambahan1 = 0;
            foreach ($dtaccount->getResult() as $row1) {
                $v_acc_code1 = $row1->acc_cod1;

                if ($v_acc_code1 >= '312') {
                    // $i=$i+1;
                    $nilai = $model->_get_nilai($v_acc_code1, $bulan, $tahun);
                    $trx_amnt = 0;

                    foreach ($nilai->getResult() as $nil) {
                        $trx_amnt = $nil->acc_akhc;
                    }

                    $subtotal = $subtotal + $trx_amnt;

                    if ($row->acc_nblc == 'K') {
                        $total = $total - $trx_amnt;
                    } else {
                        $total = $total + $trx_amnt;
                    }

                    $tahun1 = $tahun - 1;
                    $nilai1 = $model->_get_nilai($v_acc_code1, $bulan, $tahun1);
                    foreach ($nilai1->getResult() as $nil) {
                        $trx_amnt1 = $nil->acc_akhc;
                    }

                    $subtotal1 = $subtotal1 + $trx_amnt1;

                    if ($row->acc_nblc == 'K') {
                        $total1 = $total1 - $trx_amnt1;
                        // $subtotal=$subtotal-$trx_amnt;
                    } else {
                        $total1 = $total1 + $trx_amnt1;
                        // $subtotal=$subtotal+$trx_amnt;
                    }
                    // if ($trx_amnt != 0) {
                    $i = $i + 1;

                    $pdf->Cell(10, 2, '', 0, 0, 'C');
                    $pdf->Cell(120, 2, $row1->acc_name, 0, 0, 'L');
                    $pdf->Cell(30, 2, number_format($trx_amnt), 0, 0, 'R');
                    $pdf->Cell(30, 2, number_format($trx_amnt1), 0, 0, 'R');

                    $pdf->Ln();
                    // if (substr($v_acc_code1, 0, 1) == '4') {
                    // $aruskasoperasi = 'Arus Kas Operasi Sebelum Perubahan Asset Netto';
                    // } else {
                    // $aruskasoperasi = 'Kas Bersih dari/untuk Aktivitas operasi';
                    // }
                    // $pdf->Cell(10, 2, $aruskasoperasi, 0, 1, '', 0, '', 0);
                    // // if ($v_acc_code1 == '311') {
                    // $pdf->Ln();
                    // $pdf->Cell(10, 2, $aruskasoperasi, 0, 1, '', 0, '', 0);
                    // } else {
                    // // $totpenambahan = $totpenambahan + $trx_amnt;
                    // // $totpenambahan1 = $totpenambahan1 + $trx_amnt1;
                    // }
                }
            }

            //Prnyusutan
            $acc_codep1 = '122';
            $acc_codep2 = '122';
            $dtaccount1p = $model->_get_neraca1pa($acc_codep1, $acc_codep2);
            foreach ($dtaccount1p->getResult() as $row1p) {
                $v_acc_code1 = $row1p->acc_cod1;


                // $i=$i+1;
                $nilai = $model->_get_nilai($v_acc_code1, $bulan, $tahun);
                $trx_amnt = 0;

                foreach ($nilai->getResult() as $nil) {
                    $trx_amnt = $nil->acc_akhc;
                }

                $subtotal = $subtotal + $trx_amnt;

                if (
                    $row->acc_nblc == 'K'
                ) {
                    $total = $total - $trx_amnt;
                } else {
                    $total = $total + $trx_amnt;
                }

                $tahun1 = $tahun - 1;
                $nilai1 = $model->_get_nilai($v_acc_code1, $bulan, $tahun1);
                foreach ($nilai1->getResult() as $nil) {
                    $trx_amnt1 = $nil->acc_akhc;
                }

                $subtotal1 = $subtotal1 + $trx_amnt1;

                if (
                    $row->acc_nblc == 'K'
                ) {
                    $total1 = $total1 - $trx_amnt1;
                    // $subtotal=$subtotal-$trx_amnt;
                } else {
                    $total1 = $total1 + $trx_amnt1;
                    // $subtotal=$subtotal+$trx_amnt;
                }
                // if ($trx_amnt != 0) {
                $i = $i + 1;


                $pdf->Cell(10, 2, '', 0, 0, 'C');
                $pdf->Cell(120, 2, $row1p->acc_name, 0, 0, 'L');
                $pdf->Cell(30, 2, number_format($trx_amnt), 0, 0, 'R');
                $pdf->Cell(30, 2, number_format($trx_amnt1), 0, 0, 'R');

                $pdf->Ln();
            }

            // $pdf->Cell(120, 2, 'Asset Bersih Sebelum Perubahan Aktivitas Operasi', 0, 0, 'L');

            // $pdf->Ln();
            $pdf->Cell(130, 0, '', 0, 0, 'L');
            $pdf->Cell(30, 0, '________________', 0, 0, 'R');
            $pdf->Cell(30, 0, '________________', 0, 0, 'R');

            $pdf->Ln();
            // $pdf->Cell(10, 2, $aruskas, 0, 1, '', 0, '', 0);
            // $pdf->Cell(10, 2, '', 0, 0, 'C');
            $pdf->Cell(10, 2, 'Asset Bersih Sebelum Perubahan Aktivitas Operasi', 0, 0, 'L');
            $pdf->Cell(120, 2, '', 0, 0, 'L');
            $pdf->Cell(30, 2, number_format($totpenambahan), 0, 0, 'R');
            $pdf->Cell(30, 2, number_format($totpenambahan1), 0, 0, 'R');
            $pdf->Ln();
            // $pdf->Cell(10, 2, '', 0, 0, 'C');
            $pdf->Cell(10, 2, 'Perubahan dan pada Asset dan Liabilitas Operasi', 0, 0, 'L');
            $pdf->Ln();
            // Piutang

            $acc_codep1 = '112';
            $acc_codep2 = '119';
            $dtaccount1p = $model->_get_neraca1pa($acc_codep1, $acc_codep2);
            foreach ($dtaccount1p->getResult() as $row1p) {
                $v_acc_code1 = $row1p->acc_cod1;


                // $i=$i+1;
                $nilai = $model->_get_nilai($v_acc_code1, $bulan, $tahun);
                $trx_amnt = 0;

                foreach ($nilai->getResult() as $nil) {
                    $trx_amnt = $nil->acc_akhc;
                }

                $subtotal = $subtotal + $trx_amnt;

                if (
                    $row->acc_nblc == 'K'
                ) {
                    $total = $total - $trx_amnt;
                } else {
                    $total = $total + $trx_amnt;
                }

                $tahun1 = $tahun - 1;
                $nilai1 = $model->_get_nilai($v_acc_code1, $bulan, $tahun1);
                foreach ($nilai1->getResult() as $nil) {
                    $trx_amnt1 = $nil->acc_akhc;
                }

                $subtotal1 = $subtotal1 + $trx_amnt1;

                if (
                    $row->acc_nblc == 'K'
                ) {
                    $total1 = $total1 - $trx_amnt1;
                    // $subtotal=$subtotal-$trx_amnt;
                } else {
                    $total1 = $total1 + $trx_amnt1;
                    // $subtotal=$subtotal+$trx_amnt;
                }
                // if ($trx_amnt != 0) {
                $i = $i + 1;


                $pdf->Cell(10, 2, '', 0, 0, 'C');
                $pdf->Cell(120, 2, $row1p->acc_name, 0, 0, 'L');
                $pdf->Cell(30, 2, number_format($trx_amnt), 0, 0, 'R');
                $pdf->Cell(30, 2, number_format($trx_amnt1), 0, 0, 'R');

                $pdf->Ln();
            }

            // sub total
            // if ($subtotal != 0) {
            $i = $i + 1;
        }
        //Hutang
        $acc_codep1 = '20.00';
        $acc_codep2 = '29.99';
        $dtaccount1p = $model->_get_neraca1pa($acc_codep1, $acc_codep2);
        foreach ($dtaccount1p->getResult() as $row1p) {
            $v_acc_code1 = $row1p->acc_cod1;


            // $i=$i+1;
            $nilai = $model->_get_nilai($v_acc_code1, $bulan, $tahun);
            $trx_amnt = 0;

            foreach ($nilai->getResult() as $nil) {
                $trx_amnt = $nil->acc_akhc;
            }

            $subtotal = $subtotal + $trx_amnt;

            if (
                $row->acc_nblc == 'K'
            ) {
                $total = $total - $trx_amnt;
            } else {
                $total = $total + $trx_amnt;
            }

            $tahun1 = $tahun - 1;
            $nilai1 = $model->_get_nilai($v_acc_code1, $bulan, $tahun1);
            foreach ($nilai1->getResult() as $nil) {
                $trx_amnt1 = $nil->acc_akhc;
            }

            $subtotal1 = $subtotal1 + $trx_amnt1;

            if (
                $row->acc_nblc == 'K'
            ) {
                $total1 = $total1 - $trx_amnt1;
                // $subtotal=$subtotal-$trx_amnt;
            } else {
                $total1 = $total1 + $trx_amnt1;
                // $subtotal=$subtotal+$trx_amnt;
            }
            // if ($trx_amnt != 0) {
            $i = $i + 1;


            $pdf->Cell(10, 2, '', 0, 0, 'C');
            $pdf->Cell(120, 2, $row1p->acc_name, 0, 0, 'L');
            $pdf->Cell(30, 2, number_format($trx_amnt), 0, 0, 'R');
            $pdf->Cell(30, 2, number_format($trx_amnt1), 0, 0, 'R');

            $pdf->Ln();
        }

        $pdf->Cell(130, 0, '', 0, 0, 'L');
        $pdf->Cell(30, 0, '________________', 0, 0, 'R');
        $pdf->Cell(30, 0, '________________', 0, 0, 'R');

        $pdf->Ln();
        // $pdf->Cell(10, 2, $aruskas, 0, 1, '', 0, '', 0);
        // $pdf->Cell(10, 2, '', 0, 0, 'C');
        $pdf->Cell(10, 2, 'Kas Bersih dari aktivitas operasi', 0, 0, 'L');
        $pdf->Cell(120, 2, '', 0, 0, 'L');
        $pdf->Cell(30, 2, number_format($totpenambahan), 0, 0, 'R');
        $pdf->Cell(30, 2, number_format($totpenambahan1), 0, 0, 'R');
        $pdf->Ln();
        // $pdf->Cell(10, 2, '', 0, 0, 'C');
        $pdf->Ln();
        $pdf->Cell(10, 2, 'Arus Kas dari Investasi', 0, 0, 'L');
        $pdf->Ln();
        //Asset (investasi)
        $acc_codep1 = '12.1';
        $acc_codep2 = '12.1';
        $dtaccount1p = $model->_get_neraca1pa($acc_codep1, $acc_codep2);
        foreach ($dtaccount1p->getResult() as $row1p) {
            $v_acc_code1 = $row1p->acc_cod1;


            // $i=$i+1;
            $nilai = $model->_get_nilai($v_acc_code1, $bulan, $tahun);
            $trx_amnt = 0;

            foreach ($nilai->getResult() as $nil) {
                $trx_amnt = $nil->acc_akhc;
            }

            $subtotal = $subtotal + $trx_amnt;

            if (
                $row->acc_nblc == 'K'
            ) {
                $total = $total - $trx_amnt;
            } else {
                $total = $total + $trx_amnt;
            }

            $tahun1 = $tahun - 1;
            $nilai1 = $model->_get_nilai($v_acc_code1, $bulan, $tahun1);
            foreach ($nilai1->getResult() as $nil) {
                $trx_amnt1 = $nil->acc_akhc;
            }

            $subtotal1 = $subtotal1 + $trx_amnt1;

            if (
                $row->acc_nblc == 'K'
            ) {
                $total1 = $total1 - $trx_amnt1;
                // $subtotal=$subtotal-$trx_amnt;
            } else {
                $total1 = $total1 + $trx_amnt1;
                // $subtotal=$subtotal+$trx_amnt;
            }
            // if ($trx_amnt != 0) {
            $i = $i + 1;


            $pdf->Cell(10, 2, '', 0, 0, 'C');
            $pdf->Cell(120, 2, $row1p->acc_name, 0, 0, 'L');
            $pdf->Cell(30, 2, number_format($trx_amnt), 0, 0, 'R');
            $pdf->Cell(30, 2, number_format($trx_amnt1), 0, 0, 'R');

            $pdf->Ln();
        }
        $pdf->Cell(130, 0, '', 0, 0, 'L');
        $pdf->Cell(30, 0, '________________', 0, 0, 'R');
        $pdf->Cell(30, 0, '________________', 0, 0, 'R');

        $pdf->Ln();
        $pdf->Cell(10, 2, 'Kas Bersih digunakan Investasi', 0, 0, 'L');
        $pdf->Cell(120, 2, '', 0, 0, 'L');
        $pdf->Cell(30, 2, number_format($totpenambahan), 0, 0, 'R');
        $pdf->Cell(30, 2, number_format($totpenambahan1), 0, 0, 'R');
        $pdf->Ln();

        //Asset (Pendanaan)
        $pdf->Ln();
        $pdf->Cell(10, 2, 'Arus Kas dari Aktivitas Pendanaan', 0, 0, 'L');
        $pdf->Ln();
        $acc_codep1 = '31.1';
        $acc_codep2 = '31.1';
        $dtaccount1p = $model->_get_neraca1pa($acc_codep1, $acc_codep2);
        foreach ($dtaccount1p->getResult() as $row1p) {
            $v_acc_code1 = $row1p->acc_cod1;


            // $i=$i+1;
            $nilai = $model->_get_nilai($v_acc_code1, $bulan, $tahun);
            $trx_amnt = 0;

            foreach ($nilai->getResult() as $nil) {
                $trx_amnt = $nil->acc_akhc;
            }

            $subtotal = $subtotal + $trx_amnt;

            if (
                $row->acc_nblc == 'K'
            ) {
                $total = $total - $trx_amnt;
            } else {
                $total = $total + $trx_amnt;
            }

            $tahun1 = $tahun - 1;
            $nilai1 = $model->_get_nilai($v_acc_code1, $bulan, $tahun1);
            foreach ($nilai1->getResult() as $nil) {
                $trx_amnt1 = $nil->acc_akhc;
            }

            $subtotal1 = $subtotal1 + $trx_amnt1;

            if (
                $row->acc_nblc == 'K'
            ) {
                $total1 = $total1 - $trx_amnt1;
                // $subtotal=$subtotal-$trx_amnt;
            } else {
                $total1 = $total1 + $trx_amnt1;
                // $subtotal=$subtotal+$trx_amnt;
            }
            // if ($trx_amnt != 0) {
            $i = $i + 1;


            $pdf->Cell(10, 2, '', 0, 0, 'C');
            $pdf->Cell(120, 2, $row1p->acc_name, 0, 0, 'L');
            $pdf->Cell(30, 2, number_format($trx_amnt), 0, 0, 'R');
            $pdf->Cell(30, 2, number_format($trx_amnt1), 0, 0, 'R');

            $pdf->Ln();
        }
        $pdf->Cell(130, 0, '', 0, 0, 'L');
        $pdf->Cell(30, 0, '________________', 0, 0, 'R');
        $pdf->Cell(30, 0, '________________', 0, 0, 'R');

        $pdf->Ln();
        $pdf->Cell(10, 2, 'Kas yang diperolh (digunakan untuk) Aktivitas pendanaan', 0, 0, 'L');
        $pdf->Cell(120, 2, '', 0, 0, 'L');
        $pdf->Cell(30, 2, number_format($totpenambahan), 0, 0, 'R');
        $pdf->Cell(30, 2, number_format($totpenambahan1), 0, 0, 'R');
        $pdf->Ln();

        $pdf->Cell(10, 2, 'Kenaikan Bersih kas dan setara kas', 0, 0, 'L');
        $pdf->Cell(120, 2, '', 0, 0, 'L');
        $pdf->Cell(30, 2, number_format($totpenambahan), 0, 0, 'R');
        $pdf->Cell(30, 2, number_format($totpenambahan1), 0, 0, 'R');
        $pdf->Ln();
        $pdf->Cell(10, 2, 'Kas dan setara kas Awal Tahunn', 0, 0, 'L');
        $pdf->Cell(120, 2, '', 0, 0, 'L');
        $pdf->Cell(30, 2, number_format($totpenambahan), 0, 0, 'R');
        $pdf->Cell(30, 2, number_format($totpenambahan1), 0, 0, 'R');
        $pdf->Ln();
        $pdf->Cell(130, 0, '', 0, 0, 'L');
        $pdf->Cell(30, 0, '________________', 0, 0, 'R');
        $pdf->Cell(30, 0, '________________', 0, 0, 'R');
        $pdf->Ln();
        $pdf->Cell(10, 2, 'kas dan setara kas Akhir Tahunn', 0, 0, 'L');
        $pdf->Cell(120, 2, '', 0, 0, 'L');
        $pdf->Cell(30, 2, number_format($totpenambahan), 0, 0, 'R');
        $pdf->Cell(30, 2, number_format($totpenambahan1), 0, 0, 'R');

        $this->response->setContentType('application/pdf');

        $pdf->SetY(-24);
        // Set font
        $pdf->SetFont('helvetica', 'I', 8);
        // Page number
        $pdf->Cell(0, 2, 'Page ' . $pdf->getAliasNumPage() . '/' . $pdf->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
        //Close and output PDF document
        $pdf->Output('rl32.pdf', 'I');
    }


    public function aruskasdtl()
    {
        $model = new Accounting_model();
        $bulan = $this->request->getPost('kin_buln');
        $tahun = $this->request->getPost('kin_tahn');
        $tahun1 = $tahun - 1;
        if ($bulan == 1) {
            $nbulan = "Januari";
        } else if ($bulan == 2) {
            $nbulan = "Februari ";
        } else if ($bulan == 3) {
            $nbulan = "Maret ";
        } else if ($bulan == 4) {
            $nbulan = "April ";
        } else if ($bulan == 5) {
            $nbulan = "Mei ";
        } else if ($bulan == 6) {
            $nbulan = "Juni ";
        } else if ($bulan == 7) {
            $nbulan = "Juli ";
        } else if ($bulan == 8) {
            $nbulan = "Agustus ";
        } else if ($bulan == 9) {
            $nbulan = "September ";
        } else if ($bulan == 10) {
            $nbulan = "Oktober ";
        } else if ($bulan == 11) {
            $nbulan = "November ";
        } else if ($bulan == 12) {
            $nbulan = "Desember ";
        }
        // $html = view('rpt/accounting/neraca.php');
        $pdf = new TCPDF('P', PDF_UNIT, 'A4', true, 'UTF-8', false);

        $pdf->SetCreator(PDF_CREATOR);
        $pdf->SetAuthor('GIT');
        $pdf->SetTitle('Arus Kas');
        $pdf->SetSubject('Arus Kas');

        $pdf->setPrintHeader(false);
        $pdf->setPrintFooter(false);

        $pdf->addPage();
        $image_file = 'assets/images/' . $_SESSION['com_logo'];
        /**
         * width : 50
         */


        $image_file = 'assets/images/' . $_SESSION['com_logo'];

        /**
         * width : 50
         */
        $pdf->Image($image_file, '', '', 20);

        // Set font
        $pdf->SetFont('helvetica', 'B', 11);
        $pdf->SetX(40);
        $pdf->Cell(0, 2, $_SESSION['com_name'], 0, 1, '', 0, '', 0);

        $pdf->SetX(40);
        $pdf->SetFont('helvetica', '', 8);
        $pdf->Cell(0, 2, $_SESSION['com_adrs'], 0, 1, '', 0, '', 0);

        // $pdf->SetX(40);
        // Title

        // Footer
        // Position at 15 mm from bottom


        //

        $pdf->Ln();


        $pdf->Ln();
        $pdf->SetFont('helvetica', '', 11);
        $pdf->Cell(190, 2, 'LAPORAN ARUS KAS', 0, 1, 'C');


        $pdf->Cell(190, 2, 'Bulan ' . $nbulan . ' Tahun : ' . $tahun, 0, 1, 'C');

        $pdf->SetFont('helvetica', '', 9);

        $pdf->Ln();
        $pdf->Cell(130, 10, 'Keterangan', 1, 0, 'C');
        $pdf->Cell(30, 10, $nbulan . ' ' . $tahun, 1, 0, 'C');
        $pdf->Cell(30, 10, $nbulan . ' ' . $tahun1, 1, 0, 'C');

        $pdf->Ln();

        $total = 0;
        $total1 = 0;
        $i = 0;

        $acc_klas1 = 4;
        $acc_klas2 = 4;

        $rugilaba = $model->_get_rugilaba();
        $v_rlj_code = "";
        $v_rll_code = "";
        $v_rls_code = "";
        foreach ($rugilaba->getResult() as $awl) {
            $v_rlj_code = $awl->rlj_code;
            $v_rll_code = $awl->rll_code;
            $v_rls_code = $awl->rls_code;
        }

        $account = $model->_get_proyeksi($acc_klas1, $acc_klas2);
        foreach ($account->getResult() as $row) {
            $acc_code = $row->acc_cod1;

            $subtotal = 0;
            $subtotal1 = 0;
            if (substr($acc_code, 0, 1) == '4') {
                $aruskas = 'Arus Kas dari (untuk) Kas operasional';
            } else {
                $aruskas = 'Penyesuaian untuk rekonsialisasi perubahan dalam asset';
            }
            $pdf->Cell(10, 2, $aruskas, 0, 1, '', 0, '', 0);


            $dtaccount = $model->_get_neraca1($acc_code);

            $totpenambahan = 0;
            $totpenambahan1 = 0;
            foreach ($dtaccount->getResult() as $row1) {
                $v_acc_code1 = $row1->acc_cod1;

                // $i=$i+1;
                $nilai = $model->_get_nilai($v_acc_code1, $bulan, $tahun);
                $trx_amnt = 0;

                foreach ($nilai->getResult() as $nil) {
                    $trx_amnt = $nil->acc_akhc;
                }

                $subtotal = $subtotal + $trx_amnt;

                if ($row->acc_nblc == 'K') {
                    $total = $total - $trx_amnt;
                } else {
                    $total = $total + $trx_amnt;
                }

                $tahun1 = $tahun - 1;
                $nilai1 = $model->_get_nilai($v_acc_code1, $bulan, $tahun1);
                foreach ($nilai1->getResult() as $nil) {
                    $trx_amnt1 = $nil->acc_akhc;
                }

                $subtotal1 = $subtotal1 + $trx_amnt1;

                if ($row->acc_nblc == 'K') {
                    $total1 = $total1 - $trx_amnt1;
                    // $subtotal=$subtotal-$trx_amnt;
                } else {
                    $total1 = $total1 + $trx_amnt1;
                    // $subtotal=$subtotal+$trx_amnt;
                }
                // if ($trx_amnt != 0) {
                $i = $i + 1;

                $pdf->Cell(10, 2, '', 0, 0, 'C');
                $pdf->Cell(120, 2, $row1->acc_name, 0, 0, 'L');
                $pdf->Cell(30, 2, number_format($trx_amnt), 0, 0, 'R');
                $pdf->Cell(30, 2, number_format($trx_amnt1), 0, 0, 'R');

                $pdf->Ln();
                if (substr($v_acc_code1, 0, 1) == '4') {
                    $aruskasoperasi = 'Arus Kas Operasi Sebelum Perubahan Asset Netto';
                } else {
                    $aruskasoperasi = 'Kas Bersih dari/untuk Aktivitas operasi';
                }
                // $pdf->Cell(10, 2, $aruskasoperasi, 0, 1, '', 0, '', 0);
                // // if ($v_acc_code1 == '311') {
                // $pdf->Ln();
                // $pdf->Cell(10, 2, $aruskasoperasi, 0, 1, '', 0, '', 0);
                // } else {
                // // $totpenambahan = $totpenambahan + $trx_amnt;
                // // $totpenambahan1 = $totpenambahan1 + $trx_amnt1;
                // }
            }
            // $pdf->Ln();
            $pdf->Cell(130, 0, '', 0, 0, 'L');
            $pdf->Cell(30, 0, '________________', 0, 0, 'R');
            $pdf->Cell(30, 0, '________________', 0, 0, 'R');

            $pdf->Ln();
            $pdf->Cell(10, 2, '', 0, 0, 'C');
            $pdf->Cell(120, 2, $aruskasoperasi, 0, 0, 'L');
            $pdf->Cell(30, 2, number_format($totpenambahan), 0, 0, 'R');
            $pdf->Cell(30, 2, number_format($totpenambahan1), 0, 0, 'R');
            $pdf->Ln();
            $pdf->Ln();

            // sub total
            // if ($subtotal != 0) {
            $i = $i + 1;
        }


        // output the HTML content


        // $pdf->writeHTML($html, true, false, true, false, '');
        //line ini penting

        $this->response->setContentType('application/pdf');

        $pdf->SetY(-24);
        // Set font
        $pdf->SetFont('helvetica', 'I', 8);
        // Page number
        $pdf->Cell(0, 2, 'Page ' . $pdf->getAliasNumPage() . '/' . $pdf->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
        //Close and output PDF document
        $pdf->Output('rl32.pdf', 'I');
    }

    public function kartubukubesar()
    {
        $model = new Accounting_model();
        $acc_cod1 = $this->request->getPost('acc_cod1');
        $acc_cod2 = $this->request->getPost('acc_cod2');
        $tgl1 = $this->request->getPost('trx_date');
        $tgl2 = $this->request->getPost('trx_dat1');
        $bulan = $this->request->getPost('kin_buln');
        $tahun = $this->request->getPost('kin_tahn');
        $cabang = $this->request->getPost('cab_code');
        $tahun1 = $tahun - 1;
        if ($bulan == 1) {
            $nbulan = "Januari";
        } else if ($bulan == 2) {
            $nbulan = "Februari ";
        } else if ($bulan == 3) {
            $nbulan = "Maret ";
        } else if ($bulan == 4) {
            $nbulan = "April ";
        } else if ($bulan == 5) {
            $nbulan = "Mei ";
        } else if ($bulan == 6) {
            $nbulan = "Juni ";
        } else if ($bulan == 7) {
            $nbulan = "Juli ";
        } else if ($bulan == 8) {
            $nbulan = "Agustus ";
        } else if ($bulan == 9) {
            $nbulan = "September ";
        } else if ($bulan == 10) {
            $nbulan = "Oktober ";
        } else if ($bulan == 11) {
            $nbulan = "November ";
        } else if ($bulan == 12) {
            $nbulan = "Desember ";
        }
        // $html = view('rpt/accounting/neraca.php');
        $pdf = new TCPDF('P', PDF_UNIT, 'A4', true, 'UTF-8', false);

        $pdf->SetCreator(PDF_CREATOR);
        $pdf->SetAuthor('GIT');
        $pdf->SetTitle('Buku Besar');
        $pdf->SetSubject('Buku Besar');

        $pdf->setPrintHeader(false);
        $pdf->setPrintFooter(false);

        $pdf->addPage();
        $image_file = 'assets/images/' . $_SESSION['com_logo'];
        /**
         * width : 50
         */


        $image_file = 'assets/images/' . $_SESSION['com_logo'];

        /**
         * width : 50
         */
        $pdf->Image($image_file, '', '', 20);

        // Set font
        $pdf->SetFont('helvetica', 'B', 11);
        $pdf->SetX(40);
        $pdf->Cell(0, 2, $_SESSION['com_name'], 0, 1, '', 0, '', 0);

        $pdf->SetX(40);
        $pdf->SetFont('helvetica', '', 8);
        $pdf->Cell(0, 2, $_SESSION['com_adrs'], 0, 1, '', 0, '', 0);

        // $pdf->SetX(40);
        // Title

        // Footer
        // Position at 15 mm from bottom


        //

        $pdf->Ln();


        $pdf->Ln();
        $pdf->SetFont('helvetica', '', 11);
        $pdf->Cell(190, 2, 'KARTU BUKU BESAR', 0, 1, 'C');


        $pdf->Cell(190, 2, 'Dari Tanggal : ' . date('d/m/Y', strtotime($tgl1)) . ' sd Tanggal : ' . date('d/m/Y', strtotime($tgl2)), 0, 1, 'C');

        $pdf->SetFont('helvetica', '', 7);

        $pdf->Ln();
        $pdf->Cell(10, 10, 'No', 1, 0, 'C');
        $pdf->Cell(20, 10, 'Tanggal', 1, 0, 'C');
        $pdf->Cell(30, 10, 'No. Transaksi', 1, 0, 'C');
        $pdf->Cell(60, 10, 'Keterangan', 1, 0, 'C');
        $pdf->Cell(25, 10, 'Debet', 1, 0, 'C');
        $pdf->Cell(25, 10, 'Kredit', 1, 0, 'C');
        $pdf->Cell(25, 10, 'Saldo', 1, 0, 'C');

        $pdf->Ln();


        $i = 0;


        $account = $model->_get_dtakun($acc_cod1, $acc_cod2);
        foreach ($account->getResult() as $row) {
            $acc_code = $row->acc_code;
            $acc_name = $row->acc_name;
            if ($cabang != '') {
                $dtawal = $model->_get_saldoawalcab($acc_code, $tgl1, $cabang);
            } else {
                $dtawal = $model->_get_saldoawal($acc_code, $tgl1);
            }

            foreach ($dtawal->getResult() as $rowawl) {
                $saldoawal = $rowawl->acc_akhc;
            }
            $i = 1;
            $pdf->Cell(10, 2, $acc_code . ' - ' . $acc_name, 0, 1, '', 0, '', 0);
            $pdf->Ln();
            $pdf->Cell(10, 2, $i, 0, 0, 'C');
            $pdf->Cell(20, 2, date('d/m/Y', strtotime($tgl1)), 0, 0, 'C');
            $pdf->Cell(30, 2, 'Saldo Awal', 0, 0, 'C');

            $pdf->Cell(60, 2, '', 0, 0, 'C');
            $pdf->Cell(25, 2, number_format(0), 0, 0, 'R');
            $pdf->Cell(25, 2, number_format(0), 0, 0, 'R');
            $pdf->Cell(25, 2, number_format($saldoawal), 0, 0, 'R');
            $pdf->Ln();


            if ($cabang != '') {
                $dtaccount = $model->get_dttransaksicab($acc_code, $tgl1, $tgl2, $cabang);
            } else {
                $dtaccount = $model->get_dttransaksi($acc_code, $tgl1, $tgl2);
            }


            $saldo = $saldoawal;
            $tdebet = 0;
            $tcredit = 0;
            $Y_Table_Position = 56;
            foreach ($dtaccount->getResult() as $row1) {
                $v_acc_code1 = $row1->acc_cod1;
                $Y_Table_Position = $Y_Table_Position + 6;

                if ($row->acc_nblc == 'K') {
                    $saldo = $saldo - $row1->dbt_amnt + $row1->crd_amnt;
                } else {
                    $saldo = $saldo + $row1->dbt_amnt - $row1->crd_amnt;
                }
                $tdebet = $tdebet + $row1->dbt_amnt;
                $tcredit = $tcredit + $row1->crd_amnt;

                $keterangan = substr($row1->trx_des1, 0, 42);
                // if ($trx_amnt != 0) {
                $i = $i + 1;
                $pdf->Cell(10, 2, $i, 0, 0, 'C');
                $pdf->Cell(20, 2, date('d/m/Y', strtotime($row1->trx_date)), 0, 0, 'C');
                $pdf->Cell(30, 2, $row1->trx_code, 0, 0, 'l');
                $pdf->Cell(60, 2, $keterangan, 0, 0, 'L');
                // $pdf->MultiCell(60, 5, $row1->trx_des1, 0, 'L');
                // $pdf->MultiCell(25, 5, $row1->dbt_amnt, 0, 'L');
                $pdf->Cell(25, 5, number_format($row1->dbt_amnt), 0, 0, 'R');
                $pdf->Cell(25, 5, number_format($row1->crd_amnt), 0, 0, 'R');
                $pdf->Cell(25, 5, number_format($saldo), 0, 0, 'R');


                // $pdf->SetY($Y_Table_Position);
                // $pdf->SetX(10);
                // $pdf->MultiCell(10, 6, $i, 0, 'R');

                // $pdf->SetY($Y_Table_Position);
                // $pdf->SetX(20);
                // $pdf->MultiCell(20, 6, date('d/m/Y', strtotime($row1->trx_date)), 0, 'L');

                // $pdf->SetY($Y_Table_Position);
                // $pdf->SetX(40);
                // $pdf->MultiCell(30, 6, $row1->trx_code, 0, 'C');

                // $pdf->SetY($Y_Table_Position);
                // $pdf->SetX(70);
                // $pdf->MultiCell(60, 6, $row1->trx_des1, 0, 'L');

                // $pdf->SetY($Y_Table_Position);
                // $pdf->SetX(130);
                // $pdf->MultiCell(25, 6, number_format($row1->dbt_amnt), 0, 'R');

                // $pdf->SetY($Y_Table_Position);
                // $pdf->SetX(155);
                // $pdf->MultiCell(25, 6, number_format($row1->crd_amnt), 0, 'R');

                // $pdf->SetY($Y_Table_Position);
                // $pdf->SetX(180);
                // $pdf->MultiCell(25, 6, number_format($saldo), 0, 'R');

                $pdf->Ln();
            }
            $pdf->Ln();

            $pdf->Cell(122, 0, '', 0, 0, 'L');
            $pdf->Cell(25, 0, '________________', 0, 0, 'R');
            $pdf->Cell(25, 0, '________________', 0, 0, 'R');
            $pdf->Cell(25, 0, '________________', 0, 0, 'R');

            $pdf->Ln();
            $pdf->Cell(10, 2, '', 0, 0, 'C');
            $pdf->Cell(110, 2, 'TOTAL', 0, 0, 'C');

            $pdf->Cell(25, 2, number_format($tdebet), 0, 0, 'R');
            $pdf->Cell(25, 2, number_format($tcredit), 0, 0, 'R');
            $pdf->Cell(25, 2, number_format($saldo), 0, 0, 'R');
            $pdf->Ln();
            $pdf->Ln();

            // sub total
            // if ($subtotal != 0) {
            $i = $i + 1;
        }


        // output the HTML content


        // $pdf->writeHTML($html, true, false, true, false, '');
        //line ini penting

        $this->response->setContentType('application/pdf');

        $pdf->SetY(-24);
        // Set font
        $pdf->SetFont('helvetica', 'I', 8);
        // Page number
        $pdf->Cell(0, 2, 'Page ' . $pdf->getAliasNumPage() . '/' . $pdf->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
        //Close and output PDF document
        $pdf->Output('BukuBesar.pdf', 'I');
    }

    public function jurnal()
    {
        $model = new Accounting_model();
        // $acc_cod1 = $this->request->getPost('acc_cod1');
        // $acc_cod2 = $this->request->getPost('acc_cod2');
        $tgl1 = $this->request->getPost('trx_dat1');
        $tgl2 = $this->request->getPost('trx_dat2');
        $bulan = $this->request->getPost('kin_buln');
        $tahun = $this->request->getPost('kin_tahn');
        $tahun1 = $tahun - 1;
        // if ($bulan == 1) {
        // $nbulan = "Januari";
        // } else if ($bulan == 2) {
        // $nbulan = "Februari ";
        // } else if ($bulan == 3) {
        // $nbulan = "Maret ";
        // } else if ($bulan == 4) {
        // $nbulan = "April ";
        // } else if ($bulan == 5) {
        // $nbulan = "Mei ";
        // } else if ($bulan == 6) {
        // $nbulan = "Juni ";
        // } else if ($bulan == 7) {
        // $nbulan = "Juli ";
        // } else if ($bulan == 8) {
        // $nbulan = "Agustus ";
        // } else if ($bulan == 9) {
        // $nbulan = "September ";
        // } else if ($bulan == 10) {
        // $nbulan = "Oktober ";
        // } else if ($bulan == 11) {
        // $nbulan = "November ";
        // } else if ($bulan == 12) {
        // $nbulan = "Desember ";
        // }
        // $html = view('rpt/accounting/neraca.php');
        $pdf = new TCPDF('P', PDF_UNIT, 'A4', true, 'UTF-8', false);

        $pdf->SetCreator(PDF_CREATOR);
        $pdf->SetAuthor('GIT');
        $pdf->SetTitle('Buku Besar');
        $pdf->SetSubject('Buku Besar');

        $pdf->setPrintHeader(false);
        $pdf->setPrintFooter(false);

        $pdf->addPage();
        $image_file = 'assets/images/' . $_SESSION['com_logo'];
        /**
         * width : 50
         */


        $image_file = 'assets/images/' . $_SESSION['com_logo'];

        /**
         * width : 50
         */
        $pdf->Image($image_file, '', '', 20);

        // Set font
        $pdf->SetFont('helvetica', 'B', 11);
        $pdf->SetX(40);
        $pdf->Cell(0, 2, $_SESSION['com_name'], 0, 1, '', 0, '', 0);

        $pdf->SetX(40);
        $pdf->SetFont('helvetica', '', 8);
        $pdf->Cell(0, 2, $_SESSION['com_adrs'], 0, 1, '', 0, '', 0);

        // $pdf->SetX(40);
        // Title

        // Footer
        // Position at 15 mm from bottom


        //

        $pdf->Ln();


        $pdf->Ln();
        $pdf->SetFont('helvetica', '', 11);
        $pdf->Cell(190, 2, 'KARTU BUKU BESAR', 0, 1, 'C');


        $pdf->Cell(190, 2, 'Dari Tanggal : ' . date('d/m/Y', strtotime($tgl1)) . ' sd Tanggal : ' . date('d/m/Y', strtotime($tgl2)), 0, 1, 'C');

        $pdf->SetFont('helvetica', '', 9);

        $pdf->Ln();
        $pdf->Cell(10, 10, 'No', 1, 0, 'C');
        $pdf->Cell(20, 10, 'Tanggal', 1, 0, 'C');
        $pdf->Cell(25, 10, 'No. Transaksi', 1, 0, 'C');
        $pdf->Cell(80, 10, 'Keterangan', 1, 0, 'C');
        $pdf->Cell(30, 10, 'Debet', 1, 0, 'C');
        $pdf->Cell(30, 10, 'Kredit', 1, 0, 'C');

        $pdf->Ln();






        $dtheader = $model->get_dttransaksijrnheader($tgl1, $tgl2);

        foreach ($dtheader->getResult() as $row) {
            $v_trx_code = $row->trx_code;
            $pdf->Cell(25, 2, 'No Transaksi : ' . $v_trx_code, 0, 0, 'L');
            $pdf->Ln();
            $dtaccount = $model->get_dttransaksijrn($v_trx_code);


            $tdebet = 0;
            $tcredit = 0;
            $i = 0;
            foreach ($dtaccount->getResult() as $row1) {
                $v_acc_code = $row1->acc_code;
                $v_acc_name = $row1->acc_name;


                $tdebet = $tdebet + $row1->dbt_amnt;
                $tcredit = $tcredit + $row1->crd_amnt;


                // if ($trx_amnt != 0) {
                $i = $i + 1;
                $pdf->Cell(10, 2, $i, 0, 0, 'C');
                $pdf->Cell(20, 2, date('d/m/Y', strtotime($row1->trx_date)), 0, 0, 'C');
                $pdf->Cell(25, 2, $v_acc_code, 0, 0, 'C');
                $pdf->Cell(40, 2, $v_acc_name, 0, 0, 'L');
                $pdf->Cell(40, 2, $row1->trx_desc, 0, 0, 'L');
                $pdf->Cell(30, 2, number_format($row1->dbt_amnt), 0, 0, 'R');
                $pdf->Cell(30, 2, number_format($row1->crd_amnt), 0, 0, 'R');



                $pdf->Ln();
            }

            $pdf->Cell(10, 2, '', 0, 0, 'C');
            $pdf->Cell(20, 2, '', 0, 0, 'C');
            $pdf->Cell(25, 2, '', 0, 0, 'C');
            $pdf->Cell(80, 2, ' ', 0, 0, 'R');
            $pdf->Cell(30, 2, '_______________', 0, 0, 'R');
            $pdf->Cell(30, 2, '_______________', 0, 0, 'R');
            $pdf->Ln();

            $pdf->Cell(10, 2, '', 0, 0, 'C');
            $pdf->Cell(20, 2, '', 0, 0, 'C');
            $pdf->Cell(25, 2, '', 0, 0, 'C');
            $pdf->Cell(80, 2, 'Total ', 0, 0, 'R');
            $pdf->Cell(30, 2, number_format($tdebet), 0, 0, 'R');
            $pdf->Cell(30, 2, number_format($tcredit), 0, 0, 'R');
            $pdf->Ln();
        }
        // output the HTML content


        // $pdf->writeHTML($html, true, false, true, false, '');
        //line ini penting

        $this->response->setContentType('application/pdf');

        $pdf->SetY(-24);
        // Set font
        $pdf->SetFont('helvetica', 'I', 8);
        // Page number
        $pdf->Cell(0, 2, 'Page ' . $pdf->getAliasNumPage() . '/' . $pdf->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
        //Close and output PDF document
        $pdf->Output('BukuBesar.pdf', 'I');
    }
}
