<?php

namespace App\Models;

use CodeIgniter\Model;

class Master_model extends Model
{
    // start -------------------

    public function _get_productb($id1)
    {

        $builder = $this->db->table('tblproduct');
        $builder->select('*');
        $builder->where('prd_jens', $id1);
        return $builder->get();
    }

    public function _get_khusus()
    {
        $builder = $this->db->table('tblsetkhmdb');
        $builder->select('*');
        $builder->join('tblaccount', 'tblsetkhmdb.acc_code=tblaccount.acc_code', 'left');
        $builder->orderBy('khs_code');
        return $builder->get();
    }

    public function _editget_khusus($id)
    {
        $builder = $this->db->table('tblsetkhmdb');
        $builder->select('*');
        $builder->join('tblaccount', 'tblsetkhmdb.acc_code=tblaccount.acc_code', 'left');
        $builder->where('khs_code', $id);
        return $builder->get();
    }


    public function _get_product()
    {

        $builder = $this->db->table('tblproduct');
        $builder->select('*');
        $builder->join('tbltype', 'tblproduct.typ_code = tbltype.typ_code', 'left');

        return $builder->get();
    }

    public function _get_employee()
    {
        $builder = $this->db->table('tblemployee');
        $builder->select('*');
        $builder->orderBy('emp_code', 'asc');
        return $builder->get();
    }

    public function _ed_edemployee($id)
    {
        $builder = $this->db->table('tblemployee');
        $builder->select('*');
        $builder->where('emp_code', $id);
        return $builder->get();
    }
    public function _get_product1($id)
    {

        $builder = $this->db->table('tblproduct');
        $builder->select('*');
        $builder->join('tbltype', 'tblproduct.typ_code = tbltype.typ_code', 'left');
        $builder->where('prd_jens', $id);
        return $builder->get();
    }
    public function _get_product12($id)
    {

        $builder = $this->db->table('tblproduct');
        $builder->select('*');
        $builder->join('tbltype', 'tblproduct.typ_code = tbltype.typ_code', 'left');
        $builder->where('prd_jens>=', 'S');

        return $builder->get();
    }
    public function _get_product1A($id, $id1)
    {

        $builder = $this->db->table('tblproduct');
        $builder->select('*');
        $builder->join('tbltype', 'tblproduct.typ_code = tbltype.typ_code', 'left');
        $builder->where('prd_jens', $id);
        $builder->where('prd_code', $id1);
        return $builder->get();
    }
    public function _get_producttype()
    {

        $builder = $this->db->table('tbltype');
        $builder->select('*');
        return $builder->get();
    }

    public function _get_editproducttype($id)
    {

        $builder = $this->db->table('tbltype');
        $builder->select('*');
        $builder->where('typ_code', $id);
        return $builder->get();
    }


    public function _get_periode()
    {

        $builder = $this->db->table('tbljangkawaktu');
        $builder->select('*');


        return $builder->get();
    }
    public function _get_type()
    {

        $builder = $this->db->table('tbltype');
        $builder->select('*');


        return $builder->get();
    }
    public function _get_grade()
    {

        $builder = $this->db->table('tblgrade');
        $builder->select('*');

        return $builder->get();
    }

    public function _get_edit_grade($id)
    {

        $builder = $this->db->table('tblgrade');
        $builder->select('*');
        $builder->where('grd_code', $id);
        return $builder->get();
    }


    public function _get_departemen()
    {

        $builder = $this->db->table('tbldepartemen');
        $builder->select('*');
        return $builder->get();
    }
    public function _get_editdepartemen($id)
    {

        $builder = $this->db->table('tbldepartemen');
        $builder->select('*');
        $builder->where('dep_code', $id);
        return $builder->get();
    }

    public function _get_psb()
    {

        $builder = $this->db->table('tblcoscentre');
        $builder->select('*');
        return $builder->get();
    }
    public function _get_edpsb($id)
    {

        $builder = $this->db->table('tblcoscentre');
        $builder->select('*');
        $builder->where('psb_code', $id);
        return $builder->get();
    }
    public function _get_smd()
    {

        $builder = $this->db->table('tblsumberdana');
        $builder->select('*');
        return $builder->get();
    }
    public function _get_jenis()
    {

        $builder = $this->db->table('tbljnstransaksi');
        $builder->select('*');
        return $builder->get();
    }


    public function _get_tahun()
    {

        $builder = $this->db->table('tbltahun');
        $builder->select('*');
        $builder->orderBy('thn_tahn', 'asc');
        return $builder->get();
    }

    public function _get_bulan()
    {

        $builder = $this->db->table('tblbulan');
        $builder->select('*');
        $builder->orderBy('bln_code', 'asc');
        return $builder->get();
    }

    public function _get_editsmd($id)
    {

        $builder = $this->db->table('tblsumberdana');
        $builder->select('*');
        $builder->where('smd_code', $id);
        return $builder->get();
    }
    public function _get_mainmenu()
    {

        $builder = $this->db->table('tblmenu');
        $builder->select('*');
        $builder->where('mnu_main', 0);
        return $builder->get();
    }


    public function _get_submenu($id)
    {

        $builder = $this->db->table('tblmenu');
        $builder->select('*');
        $builder->where('mnu_main', $id);

        return $builder->get();
    }


    public function _get_perencanaan()
    {

        $builder = $this->db->table('trxaplanmdb');
        $builder->select('*');
        return $builder->get();
    }


    public function _get_editperencanaan($id)
    {

        $builder = $this->db->table('trxaplanmdb');
        $builder->select('*');
        $builder->where('pln_code', $id);

        return $builder->get();
    }

    public function _get_pengadaan()
    {

        $builder = $this->db->table('trxippmdb');
        $builder->select('*');
        $builder->join('tbldepartemen', 'trxippmdb.dep_code=tbldepartemen.dep_code', 'left');

        return $builder->get();
    }

    public function _get_assets()
    {

        $builder = $this->db->table('trxassets');
        $builder->select('*');
        $builder->join('tbldepartemen', 'trxassets.dep_code=tbldepartemen.dep_code', 'left');
        $builder->join('tblemployee', 'trxassets.emp_code=tblemployee.emp_code', 'left');
        $builder->join('tblkelompok', 'trxassets.kel_code=tblkelompok.kel_code', 'left');
        $builder->join('tblklas', 'trxassets.kls_code=tblklas.kls_code', 'left');

        return $builder->get();
    }


    public function _get_penempatan()
    {

        $builder = $this->db->table('trximpmdb');
        $builder->select('*');
        $builder->join('tbldepartemen', 'trximpmdb.dep_code=tbldepartemen.dep_code', 'left');
        $builder->join('tblemployee', 'trximpmdb.emp_code=tblemployee.emp_code', 'left');
        $builder->join('trxassets', 'trximpmdb.ast_code=trxassets.ast_code', 'left');


        return $builder->get();
    }

    public function _get_reqmaintenance()
    {

        $builder = $this->db->table('trxremdb');
        $builder->select('*');
        $builder->join('tbldepartemen', 'trxremdb.dep_code=tbldepartemen.dep_code', 'left');
        $builder->join('tblemployee', 'trxremdb.emp_code=tblemployee.emp_code', 'left');
        $builder->join('trxassets', 'trxremdb.ast_code=trxassets.ast_code', 'left');


        return $builder->get();
    }

    public function _get_anggota($start,$length,$search='')
    {

        $builder = $this->db->table('tblanggota');
        $builder->select('tblanggota.*');
        // $builder->join('tbldepartemen','tblanggota.dep_code=tbldepartemen.dep_code','inner');
        // $builder->limit (100,1);
        $builder->where('agt_stat!=', '5');
		$recordsTotal = $builder->countAllResults(false);
		//echo $length;
        $builder->limit($length,$start);
        $builder->orderBy('id', 'desc');
		if($search != ''){
			$builder->like('agt_name',$search);
			$builder->orLike('agt_adrs',$search);
		}
		$recordsFiltered = $builder->countAllResults(false);
        return array('recordsTotal'=>$recordsTotal,'recordsFiltered'=>$recordsFiltered,'data'=>$builder->get()->getResult());
    }

    public function _get_simpanggota($id)
    {

        $builder = $this->db->table('v_simpananw');
        $builder->select('*');
        $builder->join('v_ssb', 'v_ssb.agt_numb=v_ssb.agt_numb', 'left');
        $builder->join('v_tabungan', 'v_ssb.agt_numb=v_tabungan.agt_numb', 'left');
        $builder->join('v_kartuhutang', 'v_ssb.agt_numb=v_kartuhutang.agt_numb', 'left');
        $builder->where('v_simpananw.agt_numb', $id);
        return $builder->get();
    }


    public function _get_eanggota($id)
    {

        $builder = $this->db->table('tblanggota');
        $builder->select('tblanggota.*,tblgrade.grd_name');
        $builder->join('tblgrade', 'tblanggota.grd_code=tblgrade.grd_code', 'left');
        $builder->where('agt_numb', $id);

        // $builder->join('tbldepartemen','tblanggota.dep_code=tbldepartemen.dep_code','left');
        // $builder->limit (1);
        return $builder->get();
    }



    public function _get_langgota()
    {

        $builder = $this->db->table('tblanggota');
        $builder->select('agt_numb,agt_name,agt_adrs');
        return $builder->get();
    }
public function _get_anggotadep($id)
    {

        $builder = $this->db->table('tblanggota');
        $builder->select('emp_code,agt_name,tblanggota.grd_code');
        // $builder->join('tblgrade', 'tblanggota.grd_code=tblanggota.grd_code', 'inner');
        // $builder->join('tbldepartemen', 'tblanggota.dep_code=tbldepartemen.dep_name', 'inner');

        $builder->where('agt_stat!=', '5');
        $builder->where('tblanggota.dep_name', $id);

        // $builder->groupBy('emp_code,agt_name,grd_smpk,grd_smwa');
        $builder->orderBy('id', 'asc');
        return $builder->get();
    }

    function _get_eproduct($id)
    {
        $builder = $this->db->table('tblproduct');
        $builder->select('tblproduct.*,typ_name,tblaccount.acc_name,account1.acc_name as acc_nam1');
        $builder->join('tbltype', 'tblproduct.typ_code = tbltype.typ_code', 'left');
        $builder->join('tbljnstransaksi', 'tblproduct.stn_code = tbljnstransaksi.stn_code', 'left');
        $builder->join('tblaccount', 'tblproduct.acc_code = tblaccount.acc_code', 'left');
        $builder->join('tblaccount as account1', 'tblproduct.acc_cod1 = account1.acc_code', 'left');
        $builder->where('prd_code', $id);
        return $builder->get();
    }

    function _get_hmargin($id)
    {
        $builder = $this->db->table('tblmarginproduct');
        $builder->select('*');
        $builder->join('tbljangkawaktu', 'tblmarginproduct.jnk_idno = tbljangkawaktu.id', 'left');
        $builder->where('prd_code', $id);
        $builder->orderBy('tbljangkawaktu.jnk_buln', 'asc');
        return $builder->get();
    }

    function m_deleteproduct($id)
    {
        $query = $this->db->table('tblproduct')->delete(array('prd_code' => $id));

        return $query;
    }

    function _get_account()
    {
        $builder = $this->db->table('tblaccount');
        $builder->select('*');
        $builder->where('acc_dtum', 'D');
        return $builder->get();
    }

    function _get_bank()
    {
        $builder = $this->db->table('tblbank');
        $builder->select('*');
        return $builder->get();
    }
    function _get_bankteller()
    {
        $builder = $this->db->table('tblbank');
        $builder->select('*');
        $builder->like('bnk_name', 'teller', 'both');
        return $builder->get();
    }
    function _get_bankcabang($id)
    {
        $builder = $this->db->table('tblbank');
        $builder->select('*');
        $builder->where('kode', $id);
        return $builder->get();
    }
    function _get_banktellercabang($id)
    {
        $builder = $this->db->table('tblbank');
        $builder->select('*');
        $builder->where('kode', $id);
        $builder->like('bnk_name', 'teller', 'both');
        return $builder->get();
    }
    function _get_editbank($id)
    {
        $builder = $this->db->table('tblbank');
        $builder->select('*');
        $builder->join('tblaccount', 'tblbank.acc_code=tblaccount.acc_code', 'left');
        $builder->where('bnk_code', $id);
        return $builder->get();
    }

    public function _get_user()
    {
        $builder = $this->db->table('tbluser');
        $builder->select('*');

        return $builder->get();
    }


    public function _get_edituser($id)
    {
        $builder = $this->db->table('tbluser');
        $builder->select('*');
        $builder->where('username', $id);
        return $builder->get();
    }


    public function _get_aplikasi()
    {
        $builder = $this->db->table('tblcompany');
        $builder->select('tblcompany.*,tblaccount.acc_name,account1.acc_name as acc_shut,account2.acc_name as acc_shul');
        $builder->join('tblaccount', 'tblcompany.com_shub=tblaccount.acc_code', 'left');
        $builder->join('tblaccount as account1', 'tblcompany.com_shut = account1.acc_code', 'left');
        $builder->join('tblaccount as account2', 'tblcompany.com_shul = account2.acc_code', 'left');

        return $builder->get();
    }

    public function _get_accountm()
    {
        $builder = $this->db->table('tblaccount');
        $builder->select('*');
        $builder->where('acc_dtum', 'D');
        $builder->where('acc_klas', '3');
        return $builder->get();
    }

    public function _get_closing()
    {
        $builder = $this->db->table('tblsetclsday');
        $builder->select('*');

        return $builder->get();
    }


    public function _get_aksesuser($id)
    {
        $builder = $this->db->table('tbluser');
        $builder->select('tbluser.*,tblformakses.frm_code,frm_name,frm_levl,frm_stat');
        $builder->join('tblformakses', 'tbluser.username=tblformakses.username', 'left');
        $builder->join('tblform', 'tblformakses.frm_code = tblform.frm_code', 'left');
        $builder->orderBy('frm_code', 'asc');

        $builder->where('tbluser.username', $id);
        return $builder->get();
    }

    public function _get_simpanan($id)
    {
        $builder = $this->db->table('trxtabungan');
        $builder->select('trxtabungan.agt_numb,trxtabungan.tbg_code,prd_name,tbg_date,tbg_stat,sum(kin_crdt-kin_debt)as trx_saldo');
        $builder->join('trxkastabungan', 'trxtabungan.tbg_code=trxkastabungan.tbg_code', 'left');
        $builder->join('tblproduct', 'trxtabungan.prd_code = tblproduct.prd_code', 'left');
        $builder->where('trxtabungan.agt_numb', $id);
        $builder->groupBy('trxtabungan.agt_numb,trxtabungan.tbg_code,prd_name,tbg_date,tbg_stat');

        return $builder->get();
    }

    public function _getssb($id)
    {
        $builder = $this->db->table('trxpenempatan');
        $builder->select('*');
        $builder->join('tblproduct', 'trxpenempatan.prd_code = tblproduct.prd_code', 'left');
        $builder->where('trxpenempatan.agt_numb', $id);
        return $builder->get();
    }

    public function _getpinjaman($id)
    {
        $builder = $this->db->table('trxkontrak');
        $builder->select('*');
        $builder->join('v_saldo_hutang_anggota', 'trxkontrak.knt_code = v_saldo_hutang_anggota.trx_code', 'left');
        $builder->join('v_tunggakan_pokok', 'trxkontrak.knt_code = v_tunggakan_pokok.trx_code', 'left');
        $builder->join('v_tunggakan_jasa', 'trxkontrak.knt_code = v_tunggakan_jasa.trx_code', 'left');
        $builder->join('tblproduct', 'trxkontrak.prd_code = tblproduct.prd_code', 'left');
        $builder->where('trxkontrak.agt_numb', $id);
        return $builder->get();
    }

    public function _get_jenisagunan()
    {
        $builder = $this->db->table('tbljnsagunan');
        $builder->select('*');
        return $builder->get();
    }

    public function _get_formakseuser()
    {
        $builder = $this->db->table('tblform');
        $builder->select('*');
        $builder->where('frm_hide', 0);

        return $builder->get();
    }
    //End----------------------
    public function _userakses($id)
    {
        $builder = $this->db->table('tblformakses');
        $builder->select('*');
        $builder->join('tblform', 'tblformakses.frm_code=tblform.frm_code,frm_stat', 'inner');
        $builder->join('tbluser', 'tblformakses.username=tbluser.username', 'inner');
        $builder->where('username', $id);
        $builder->orderBy('tblform.frm_code', 'asc');
        return $builder->get();
    }

    public function _getnegara()
    {
        $builder = $this->db->table('tblnegara');
        $builder->select('*');
        return $builder->get();
    }

    public function _edgetnegara($id)
    {
        $builder = $this->db->table('tblnegara');
        $builder->select('*');
        $builder->where('neg_code', $id);
        return $builder->get();
    }
    public function _getkota()
    {
        $builder = $this->db->table('tblkota');
        $builder->select('*');
        return $builder->get();
    }
    public function _edgetkota($id)
    {
        $builder = $this->db->table('tblkota');
        $builder->select('*');
        $builder->where('kot_code', $id);
        return $builder->get();
    }

    public function _getkodepos()
    {
        $builder = $this->db->table('tblkodepos');
        $builder->join('tblkota', 'tblkodepos.kot_code=tblkota.kot_code', 'left');
        $builder->select('*');
        return $builder->get();
    }

    public function _dtgetkodepos($id)
    {
        $builder = $this->db->table('tblkodepos');
        $builder->join('tblkota', 'tblkodepos.kot_code=tblkota.kot_code', 'left');
        $builder->select('*');
        $builder->where('kdp_code', $id);
        return $builder->get();
    }

    public function _getgelar()
    {
        $builder = $this->db->table('tbljabatan');
        $builder->select('*');
        return $builder->get();
    }
    public function _dtgetgelar($id)
    {
        $builder = $this->db->table('tbljabatan');
        $builder->select('*');
        $builder->where('jab_code', $id);
        return $builder->get();
    }

    public function _getcabang()
    {
        $builder = $this->db->table('tblcabang');
        $builder->select('*');
        return $builder->get();
    }
    public function _dtgetcabang($id)
    {
        $builder = $this->db->table('tblcabang');
        $builder->select('*');
        $builder->where('cab_code', $id);
        return $builder->get();
    }

    public function _getakun()
    {
        $builder = $this->db->table('manajemen_akun');
        $builder->select('*');

        return $builder->get();
    }

    public function _dtgetakun($id)
    {
        $builder = $this->db->table('manajemen_akun');
        $builder->select('*');
        $builder->where('akun_cabang', $id);
        return $builder->get();
    }

    public function _get_rekdeposito()
    {
        $builder = $this->db->table('trxpenempatan');
        $builder->select('*');
        $builder->join('tblanggota', 'trxpenempatan.agt_numb = tblanggota.agt_numb', 'left');
        $builder->where('pen_stat!=', 2);
        return $builder->get();
    }

    public function _getgroup()
    {
        $builder = $this->db->table('manajemen_group');
        $builder->select('*');
        $builder->orderBy('grp_code', 'asc');
        return $builder->get();
    }

    public function _dtgetgroup($id)
    {
        $builder = $this->db->table('manajemen_group');
        $builder->select('*');
        $builder->where('grp_code', $id);
        return $builder->get();
    }

    public function _dnominasi()
    {
        $builder = $this->db->table('kodednominasi');
        $builder->select('*');

        return $builder->get();
    }
    public function _ednominasi($id)
    {
        $builder = $this->db->table('kodednominasi');
        $builder->select('*');
        $builder->where('kode_dnominasi', $id);
        return $builder->get();
    }
    public function _transaksi()
    {
        $builder = $this->db->table('kodetransteller');
        $builder->select('*');
        $builder->join('tblaccount', 'kodetransteller.kode_perk=tblaccount.acc_code', 'left');
        return $builder->get();
    }

    public function _edtransaksi($id)
    {
        $builder = $this->db->table('kodetransteller');
        $builder->select('*');
        $builder->join('tblaccount', 'kodetransteller.kode_perk=tblaccount.acc_code', 'left');
        $builder->where('kode_trans', $id);
        return $builder->get();
    }

    public function _sdtabungan()
    {
        $builder = $this->db->table('kodesumberdanatab');
        $builder->select('*');

        return $builder->get();
    }

    public function _editsdtabungan($id)
    {
        $builder = $this->db->table('kodesumberdanatab');
        $builder->select('*');
        $builder->where('deskripsi_sumber_dana_tab', $id);
        return $builder->get();
    }

    public function _tjtabungan()
    {
        $builder = $this->db->table('kodetujuanbukatab');
        $builder->select('*');

        return $builder->get();
    }

    public function _edittjtabungan($id)
    {
        $builder = $this->db->table('kodetujuanbukatab');
        $builder->select('*');
        $builder->where('deskripsi_tujuan_pembukaan_tab', $id);
        return $builder->get();
    }

    public function _ekonomi()
    {
        $builder = $this->db->table('kodesektorekonomi');
        $builder->select('*');

        return $builder->get();
    }

    public function _edekonomi($id)
    {
        $builder = $this->db->table('kodesektorekonomi');
        $builder->select('*');
        $builder->where('kode_sektor_ekonomi', $id);
        return $builder->get();
    }

    public function _kodedebitur()
    {
        $builder = $this->db->table('kodegoldebitur');
        $builder->select('*');

        return $builder->get();
    }

    public function _edkodedebitur($id)
    {
        $builder = $this->db->table('kodegoldebitur');
        $builder->select('*');
        $builder->where('kode_gol_debitur', $id);
        return $builder->get();
    }

    public function _kodepenjamin()
    {
        $builder = $this->db->table('kodegolpenjamin');
        $builder->select('*');

        return $builder->get();
    }

    public function _edkodepenjamin($id)
    {
        $builder = $this->db->table('kodegolpenjamin');
        $builder->select('*');
        $builder->where('kode_gol_penjamin', $id);
        return $builder->get();
    }


    public function _kodesifatbiaya()
    {
        $builder = $this->db->table('kodesifat');
        $builder->select('*');

        return $builder->get();
    }

    public function _edkodesifatbiaya($id)
    {
        $builder = $this->db->table('kodesifat');
        $builder->select('*');
        $builder->where('kode_sifat', $id);
        return $builder->get();
    }


    public function _kodepenggunaan()
    {
        $builder = $this->db->table('kodejenispenggunaan');
        $builder->select('*');

        return $builder->get();
    }

    public function _edkodepenggunaan($id)
    {
        $builder = $this->db->table('kodejenispenggunaan');
        $builder->select('*');
        $builder->where('kode_jenis_penggunaan', $id);
        return $builder->get();
    }

    public function _kodeasuransi()
    {
        $builder = $this->db->table('kodeasuransi');
        $builder->select('*');

        return $builder->get();
    }

    public function _edkodeasuransi($id)
    {
        $builder = $this->db->table('kodeasuransi');
        $builder->select('*');
        $builder->where('kode_asuransi', $id);
        return $builder->get();
    }


    public function _kodehukumagunan()
    {
        $builder = $this->db->table('kodeikatanhukum');
        $builder->select('*');

        return $builder->get();
    }

    public function _edkodehukumagunan($id)
    {
        $builder = $this->db->table('kodeikatanhukum');
        $builder->select('*');
        $builder->where(
            'kode_ikatan_hukum',
            $id
        );
        return $builder->get();
    }

    public function _get_konsolidasi()
    {
        $builder = $this->db->table('manajemen_konsolidasi');
        $builder->select('*');

        return $builder->get();
    }

    public function _get_edkonsolidasi($id)
    {
        $builder = $this->db->table('manajemen_konsolidasi');
        $builder->select('*');
        $builder->where('akun_konsolidasi', $id);
        return $builder->get();
    }

    public function _get_cabang()
    {
        $builder = $this->db->table('manajemen_cabang');
        $builder->select('*');
        $builder->orderBy('kode_cabang', 'asc');
        return $builder->get();
    }


    public function __get_edcabang($id)
    {
        $builder = $this->db->table('manajemen_cabang');
        $builder->select('manajemen_cabang.*,manajemen_akun.nama_cabang as nama_cabang1,tblkodepos.kdp_kelu,tblkodepos.kdp_keca');
        $builder->join('manajemen_akun', 'manajemen_cabang.akun_cabang=manajemen_akun.akun_cabang', 'left');
        $builder->join('tblkodepos', 'manajemen_cabang.kdp_code=tblkodepos.id', 'left');
        $builder->where('kode_cabang', $id);
        return $builder->get();
    }

    public function _get_closinghari($id)
    {
        $builder = $this->db->table('manajemen_closing');
        $builder->select('*');
        $builder->where('jenis_proses', $id);
        return $builder->get();
    }

    public function _get_closingbulan($id)
    {
        $builder = $this->db->table('manajemen_closing');
        $builder->select('*');
        $builder->where('jenis_proses', $id);
        return $builder->get();
    }

    public function _get_tujuan()
    {
        $builder = $this->db->table('kodetujuanbukatab');
        $builder->select('*');
        return $builder->get();
    }

    public function _get_dana()
    {
        $builder = $this->db->table('kodesumberdanatab');
        $builder->select('*');
        return $builder->get();
    }

    public function _get_dbcounter($id)
    {
        $builder = $this->db->table('bcore_counter');
        $builder->select('*');
        $builder->like('trans_key', $id);

        return $builder->get();
    }

    public function _get_kelompok()
    {
        $builder = $this->db->table('tblkelompok');
        $builder->select('*');
        $builder->join('tblemployee', 'tblkelompok.emp_code=tblemployee.emp_code', 'inner');
        $builder->orderBy('kel_code', 'asc');
        return $builder->get();
    }

    public function _edkelompok($id)
    {
        $builder = $this->db->table('tblkelompok');
        $builder->select('*');
        $builder->where('kel_code', $id);
        return $builder->get();
    }
    public function _get_trantabungan()
    {
        $builder = $this->db->table('tbltrantabungan');
        $builder->select('*');
        $builder->orderBy('trn_code', 'asc');
        return $builder->get();
    }

    public function _get_edittrantabungan($id)
    {
        $builder = $this->db->table('tbltrantabungan');
        $builder->select('*');
        $builder->where('trn_code', $id);
        $builder->orderBy('trn_code', 'asc');
        return $builder->get();
    }
    public function _get_transb()
    {
        $builder = $this->db->table('tbltransb');
        $builder->select('*');
        $builder->orderBy('trn_code', 'asc');
        return $builder->get();
    }

    public function _get_edittransb($id)
    {
        $builder = $this->db->table('tbltransb');
        $builder->select('*');
        $builder->where('trn_code', $id);
        $builder->orderBy('trn_code', 'asc');
        return $builder->get();
    }
    public function _get_tranpembiayaan()
    {
        $builder = $this->db->table('tbltranpembiayaan');
        $builder->select('*');
        $builder->orderBy('trn_code', 'asc');
        return $builder->get();
    }

    public function _get_edittranpembiayaan($id)
    {
        $builder = $this->db->table('tbltranpembiayaan');
        $builder->select('*');
        $builder->where('trn_code', $id);
        $builder->orderBy('trn_code', 'asc');
        return $builder->get();
    }

    public function _get_katagori()
    {
        $builder = $this->db->table('tblassettype');
        $builder->select('*');
        $builder->orderBy('ast_type', 'asc');
        return $builder->get();
    }

    public function _get_kelompokasset()
    {
        $builder = $this->db->table('tblassetgrup');
        $builder->select('*');
        $builder->orderBy('ast_grup', 'asc');
        return $builder->get();
    }

    public function _get_lokasi()
    {
        $builder = $this->db->table('tblassetlokasi');
        $builder->select('*');
        $builder->orderBy('loc_code', 'asc');
        return $builder->get();
    }

    public function _get_form()
    {
        $builder = $this->db->table('tblform');
        $builder->select('*');
        $builder->orderBy('frm_code', 'asc');
        return $builder->get();
    }
    public function _get_edform($id)
    {
        $builder = $this->db->table('tblform');
        $builder->select('*');
        $builder->where('frm_code', $id);
        $builder->orderBy('frm_code', 'asc');
        return $builder->get();
    }

    public function _get_finfanggota($nama, $alamat)
    {
        $builder = $this->db->table('tblanggota');
        $builder->select('*');
        $builder->where('agt_name', $nama);
        $builder->where('agt_adrs', $alamat);

        return $builder->get();
    }
}
