<?php

namespace App\Models;

use CodeIgniter\Model;
use PHPUnit\TextUI\XmlConfiguration\Group;

class Model_closing extends Model
{
    // start -------------------


    public function get_tabungan()
    {
        $builder = $this->db->table('trxtabungan');
        $builder->select('*');
        $builder->join('tblproduct', 'trxtabungan.prd_code=tblproduct.prd_code', 'left');
        $builder->where('tbg_stat!=', '2');
        $builder->where('trxtabungan.prd_code!=', '');
        return $builder->get();
    }
    public function get_tabungancab($cabang)
    {
        $builder = $this->db->table('trxtabungan');
        $builder->select('*');
        $builder->join('tblproduct', 'trxtabungan.prd_code=tblproduct.prd_code', 'left');
        $builder->where('tbg_stat!=', '2');
        $builder->where('trxtabungan.prd_code!=', '');
        $builder->where('kode_cabang', $cabang);
        return $builder->get();
    }
    public function get_company()
    {
        $builder = $this->db->table('tblcompany');
        $builder->select('*');
        return $builder->get();
    }


    public function get_niltabungan($norekening, $bulan, $tahun)
    {
        return $this->db->table('trxkastabungan')
            ->select('sum(kin_crdt-kin_debt) as tbg_totl')
            ->where(array('tbg_code' => $norekening, 'kin_mont<=' => $bulan, 'kin_year<=' => $tahun))
            ->get()->getRowArray();
    }
    public function get_niltabungancab($norekening, $bulan, $tahun, $cabang)
    {
        return $this->db->table('trxkastabungan')
            ->select('sum(kin_crdt-kin_debt) as tbg_totl')
            ->where(array('tbg_code' => $norekening, 'kin_mont<=' => $bulan, 'kin_year<=' => $tahun, 'kode_cabang<=' => $cabang))
            ->get()->getRowArray();
    }
    public function get_jumtabungan1($agt_numb, $tanggal)
    {
        return $this->db->table('trxkastabungan')
            ->select('tbg_code,agt_numb,kin_type,acc_prod,sum(kin_crdt-kin_debt) as tbg_totl')
            ->where(array('agt_numb' => $agt_numb, 'kin_date<=' => $tanggal))
            ->groupBy('tbg_code,agt_numb,kin_type,acc_prod')
            ->get()->getRowArray();
    }
    public function get_jumtabungan1cab($agt_numb, $tanggal, $cabang)
    {
        return $this->db->table('trxkastabungan')
            ->select('tbg_code,agt_numb,kin_type,acc_prod,sum(kin_crdt-kin_debt) as tbg_totl')
            ->where(array('agt_numb' => $agt_numb, 'kin_date<=' => $tanggal, 'kode_cabang<=' => $cabang))
            ->groupBy('tbg_code,agt_numb,kin_type,acc_prod')
            ->get()->getRowArray();
    }
    public function get_jumtabungan($agt_numb, $tanggal)
    {
        $builder = $this->db->table('trxkastabungan');
        $builder->select('tbg_code,agt_numb,kin_type,acc_prod,sum(kin_crdt-kin_debt) as tbg_totl');
        $builder->where('agt_numb', $agt_numb);
        $builder->where('kin_date<=', $tanggal);
        $builder->groupBy('tbg_code,agt_numb,kin_type,acc_prod');
        return $builder->get();
    }
    public function get_jumtabungancab($agt_numb, $tanggal, $cabang)
    {
        $builder = $this->db->table('trxkastabungan');
        $builder->select('tbg_code,agt_numb,kin_type,acc_prod,sum(kin_crdt-kin_debt) as tbg_totl');
        $builder->where('agt_numb', $agt_numb);
        $builder->where('kin_date<=', $tanggal);
        $builder->groupBy('tbg_code,agt_numb,kin_type,acc_prod');
        return $builder->get();
    }
    public function get_rectabungan()
    {

        return $this->db->table('trxtabungan')
            ->select('count(tbg_code) as jumlah')
            ->where(array('tbg_stat' => 0))
            ->get()->getRowArray();
    }

    public function get_rectabungancab($cabang)
    {

        return $this->db->table('trxtabungan')
            ->select('count(tbg_code) as jumlah')
            ->where(array('tbg_stat' => 0, 'kode_cabang<=' => $cabang))
            ->get()->getRowArray();
    }

    public function get_deposito()
    {
        $builder = $this->db->table('trxpenempatan');
        $builder->select('*');
        $builder->join('tblproduct', 'trxpenempatan.prd_code=tblproduct.prd_code', 'left');
        $builder->where('pen_stat', 0);
        return $builder->get();
    }

    public function get_depositocab($cabang)
    {
        $builder = $this->db->table('trxpenempatan');
        $builder->select('*');
        $builder->join('tblproduct', 'trxpenempatan.prd_code=tblproduct.prd_code', 'left');
        $builder->where('pen_stat', 0);
        $builder->where('kode_cabang', $cabang);
        return $builder->get();
    }
    public function get_dataaccount()
    {
        $builder = $this->db->table('tblaccount');
        $builder->select('acc_code,acc_nblc');
        $builder->where('acc_dtum', 'D');
        return $builder->get();
    }


    public function _get_setup($comcode)
    {
        $builder = $this->db->table('tblcompany');
        $builder->select('*');
        $builder->where('com_code', $comcode);
        return $builder->get();
    }

    public function _get_laabrugiamnt($tgl_pertama, $tgl_terakhir)
    {
        $builder = $this->db->table('transddb');
        $builder->select('sum(crd_amnt) as crd_amnt, sum(dbt_amnt) as dbt_amnt,sum(crd_amnt-dbt_amnt) as rgl_amnt');
        $builder->join('tblaccount', 'transddb.acc_code=tblaccount.acc_code', 'inner');
        $builder->where('trx_date>=', $tgl_pertama);
        $builder->where('trx_date<=', $tgl_terakhir);
        $builder->where('acc_klas>=', '4');
        return $builder->get();
    }


    public function _get_laabrugiamntcab($tgl_pertama, $tgl_terakhir, $cabang)
    {
        $builder = $this->db->table('transddb');
        $builder->select('sum(crd_amnt) as crd_amnt, sum(dbt_amnt) as dbt_amnt,sum(crd_amnt-dbt_amnt) as rgl_amnt');
        $builder->join('tblaccount', 'transddb.acc_code=tblaccount.acc_code', 'inner');
        $builder->where('trx_date>=', $tgl_pertama);
        $builder->where('trx_date<=', $tgl_terakhir);
        $builder->where('transddb.kode_cabang', $cabang);
        $builder->where('acc_klas>=', '4');
        return $builder->get();
    }

    public function _accgettab($idx)
    {
        $builder = $this->db->table('trxpenempatan');
        $builder->select('trxpenempatan.acc_code');
        $builder->join('tblproduct', 'trxpenempatan.prd_code=tblproduct.prd_code', 'inner');
        $builder->where('pen_code=', $idx);

        return $builder->get();
    }
    public function get_dtclosinharian()
    {
        $builder = $this->db->table('tblsetclsday');
        $builder->select('*');
        $builder->where('cld_stat', 1);
        $builder->orderby('cld_code', 'asc');
        return $builder->get();
    }


    public function get_dtangota($tgl)
    {
        $builder = $this->db->table('tblanggota');
        $builder->select('*');
        // $builder->join('tblgrade', 'tblanggota.grd_code=tblgrade.grd_code', 'inner');
        $builder->where('agt_aday', $tgl);
        $builder->where('agt_stat<=', '4');

        return $builder->get();
    }

    public function get_tottabungan($anggota, $tanggal)
    {
        $builder = $this->db->table('trxkastabungan');
        $builder->select('agt_numb,kin_type,acc_prod,sum(kin_crdt-kin_debt) as ');
        $builder->join('tblproduct', 'trxkastabungan.kin_type=tblproduct.prd_code', 'inner');
        $builder->where('agt_numb', $anggota);
        $builder->where('kin_date<=', $tanggal);
    }
    public function get_tottabungancab($anggota, $tanggal, $cabang)
    {
        $builder = $this->db->table('trxkastabungan');
        $builder->select('agt_numb,kin_type,acc_prod,sum(kin_crdt-kin_debt) as ');
        $builder->join('tblproduct', 'trxkastabungan.kin_type=tblproduct.prd_code', 'inner');
        $builder->where('agt_numb', $anggota);
        $builder->where('kin_date<=', $tanggal);
        $builder->where('kode_cabang', $cabang);
    }
    public function get_totaltabungan($v_tbg_code, $tanggal)
    {
        $builder = $this->db->table('trxkastabungan');
        $builder->select('acc_code,acc_cod1,trxkastabungan.kin_type,sum(kin_crdt-kin_debt) as trx_saldo');
        $builder->join('tblproduct', 'trxkastabungan.kin_type=tblproduct.prd_code', 'inner');

        $builder->where('tbg_code', $v_tbg_code);
        $builder->where('kin_date<=', $tanggal);
        $builder->groupBy('acc_code,acc_cod1,trxkastabungan.kin_type');

        return $builder->get();
    }

    public function get_saldotabungan($v_tbg_code, $tanggal)
    {
        $builder = $this->db->table('trxkastabungan');
        $builder->select('acc_code,sum(kin_crdt-kin_debt) as trx_saldo');
        $builder->join('trxtabungan', 'trxkastabungan.tbg_code=trxtabungan.tbg_code', 'inner');
        $builder->join('tblproduct', 'trxtabungan.prd_code=tblproduct.prd_code', 'inner');
        $builder->where('trxkastabungan.tbg_code', $v_tbg_code);
        $builder->where('kin_date<=', $tanggal);
        $builder->groupBy('acc_code');

        return $builder->get();
    }
    public function get_totaltabungancab($v_tbg_code, $tanggal, $cabang)
    {
        $builder = $this->db->table('trxkastabungan');
        $builder->select('acc_code,acc_cod1,trxkastabungan.kin_type,sum(kin_crdt-kin_debt) as trx_saldo');
        $builder->join('tblproduct', 'trxkastabungan.kin_type=tblproduct.prd_code', 'inner');

        $builder->where('tbg_code', $v_tbg_code);
        $builder->where('kin_date<=', $tanggal);
        $builder->where('kode_cabang', $cabang);
        $builder->groupBy('acc_code,acc_cod1,trxkastabungan.kin_type');

        return $builder->get();
    }


    public function get_dbiaya($tanggal1)
    {
        $builder = $this->db->table('trxkontrak');
        $builder->select('trxkontrak.agt_numb,acc_code,acc_cod1,tbg_code,trxkontrak.prd_code,knt_code,trx_amnh,trx_pokk,trx_bung');
        $builder->join('krtdebit', 'trxkontrak.knt_code=krtdebit.trx_code', 'inner');
        $builder->join('tblproduct', 'trxkontrak.prd_code=tblproduct.prd_code', 'inner');
        $builder->where('trx_jtdt', $tanggal1);
        $builder->where('knt_stat', 1);
        $builder->where('tbg_code!=', '');

        return $builder->get();
    }
    public function get_dbiayacab($tanggal1, $cabang)
    {
        $builder = $this->db->table('trxkontrak');
        $builder->select('trxkontrak.agt_numb,acc_code,acc_cod1,tbg_code,trxkontrak.prd_code,knt_code,trx_amnh,trx_pokk,trx_bung');
        $builder->join('krtdebit', 'trxkontrak.knt_code=krtdebit.trx_code', 'inner');
        $builder->join('tblproduct', 'trxkontrak.prd_code=tblproduct.prd_code', 'inner');
        $builder->where('trx_jtdt', $tanggal1);
        $builder->where('knt_stat', 1);
        $builder->where('tbg_code!=', '');
        $builder->where('trxkontrak.kode_cabang', $cabang);
        return $builder->get();
    }
    public function get_dbdenda($tanggal1)
    {
        $builder = $this->db->table('krtdebit');
        $builder->select('krtdebit.*,trxkontrak.knt_pden,trxkontrak.knt_nden');
        $builder->join('trxkontrak', 'krtdebit.trx_code=trxkontrak.knt_code', 'inner');
        $builder->where('trx_jtdt<', $tanggal1);
        $builder->where('krtdebit.lns_pokk', 0);

        return $builder->get();
    }

    public function get_dbdendacab($tanggal1, $cabang)
    {
        $builder = $this->db->table('krtdebit');
        $builder->select('krtdebit.*,trxkontrak.knt_pden,trxkontrak.knt_nden');
        $builder->join('trxkontrak', 'krtdebit.trx_code=trxkontrak.knt_code', 'inner');
        $builder->where('trx_jtdt<', $tanggal1);
        $builder->where('krtdebit.lns_pokk', 0);
        $builder->where('krtdebit.kode_cabang', $cabang);
        return $builder->get();
    }
    public function _acckhusus($id)
    {

        return $this->db->table('tblsetkhmdb')
            ->where(array('khs_code' => $id))
            ->limit(1)
            ->get()->getRowArray();
    }

    public function _jumlahtitipan($norekening, $bulan, $tahun)
    {
        return $this->db->table('trxjasamdb')
            ->select('sum(jas_nett) as ttp_totl')
            ->where(array('tbg_code' => $norekening, 'jas_mont<' => $bulan, 'jas_year<=' => $tahun, 'jas_bayr' => 0, 'jas_type' => 2))
            ->orderBy('jas_date', 'desc')

            ->get()->getRowArray();
    }


    public function _jumlahpokok($norekening, $bulan, $tahun)
    {
        return $this->db->table('trxjasamdb')
            ->select('sum(jas_nett) as pok_totl')
            ->where(array('tbg_code' => $norekening, 'jas_mont<' => $bulan, 'jas_year<=' => $tahun,  'jas_type' => 3))
            ->limit(1)

            ->get()->getRowArray();
    }
    public function _get_total($norekening)
    {
        return $this->db->table('trxpenempatan')
            ->select('*')
            // ->where(array('pen_code' => $norekening))
            ->get()->getRowArray();
    }
    public function get_titipan($norekening)
    {
        return $this->db->table('trxjasamdb')
            ->select('sum(jas_amnt) as ttp_totl')
            ->where(array('tbg_code' => $norekening))
            ->get()->getRowArray();
    }

    public function get_nilawaltabungan($norekening, $tanggal)
    {
        $builder = $this->db->table('trxkastabungan');
        $builder->select('sum(kin_crdt-kin_debt) as totawal');
        $builder->where('kin_date<=', $tanggal);
        $builder->where('tbg_code', $norekening);

        return $builder->get();
    }
    public function get_niltranstabungan($norekening, $tanggal1, $tanggal2)
    {
        $builder = $this->db->table('trxkastabungan');
        $builder->select('kin_date,(kin_crdt-kin_debt) as totsaldo');
        $builder->where('kin_date>', $tanggal1);
        $builder->where('kin_date<=', $tanggal2);
        $builder->where('tbg_code', $norekening);
        $builder->orderBy('kin_date', 'asc');
        return $builder->get();
    }

    public function get_dbbonus($tanggal)
    {
        $builder = $this->db->table('trxtabungan');
        $builder->select('*');
        $builder->join('tblproduct', 'trxtabungan.prd_code=tblproduct.prd_code', 'left');
        $builder->join('v_akh_tabungan', 'trxtabungan.tbg_code=v_akh_tabungan.tbg_code', 'inner');
        $builder->where('trxtabungan.tbg_ahdt=', $tanggal);

        $builder->orderBy('trxtabungan.tbg_code', 'asc');
        return $builder->get();
    }

    public function get_dbbonuscab($tanggal, $cabang)
    {
        $builder = $this->db->table('trxtabungan');
        $builder->select('*');
        $builder->join('tblproduct', 'trxtabungan.prd_code=tblproduct.prd_code', 'left');
        $builder->join('v_akh_tabungan', 'trxtabungan.tbg_code=v_akh_tabungan.tbg_code', 'inner');
        $builder->where('trxtabungan.tbg_ahdt=', $tanggal);
        $builder->where('trxtabungan.kode_cabang', $cabang);
        $builder->orderBy('trxtabungan.tbg_code', 'asc');
        return $builder->get();
    }
    public function get_nilssrtabungan($id, $tanggal1, $tanggal2)
    {
        $builder = $this->db->table('trxkastabungan');
        $builder->select('sum(kin_hari) as hari,sum(kin_gtot) as saldo');
        $builder->where('tbg_code', $id);
        $builder->where('kin_date>=', $tanggal1);
        $builder->where('kin_date<=', $tanggal2);
        $builder->groupBy('tbg_code');
        // $builder->where('kin_mont', $bulan);
        // $builder->where('kin_year', $tahun);
        // $builder->orderBy('kin_date', 'asc');
        $builder->limit(1);
        return $builder->get();
    }


    public function _get_totakum($id)
    {
        $builder = $this->db->table('trxassetam');
        $builder->select('sum(akm_amnt) as akm_amnt');
        $builder->where('ast_code', $id);
        //$builder->groupBy('ast_code');
        $builder->limit(1);
        return $builder->get();
    }

    public function _get_akhir()
    {
        $builder = $this->db->table('akhirmdb');
        $builder->select('*');
        $builder->limit(1);
        return $builder->get();
    }

    public function _get_apasset()
    {
        $builder = $this->db->table('trxasset');
        $builder->select('*');
        $builder->where('(ast_nila-ast_ndes)>', 0);
        $builder->orderBy('ast_code', 'asc');
        return $builder->get();
    }
    public function _get_apassetcab($cabang)
    {
        $builder = $this->db->table('trxasset');
        $builder->select('*');
        $builder->where('(ast_nila-ast_ndes)>', 0);
        $builder->where('loc_code', $cabang);
        $builder->orderBy('ast_code', 'asc');

        return $builder->get();
    }
    public function get_dtskbaro($tanggal)
    {
        $builder = $this->db->table('trxpenempatan');
        $builder->select('*');
        $builder->where('pen_jtdt', $tanggal);
        $builder->where('pen_des1', '2');
        return $builder->get();
    }
    public function get_dtskbarocab($tanggal, $cabang)
    {
        $builder = $this->db->table('trxpenempatan');
        $builder->select('*');
        $builder->where('pen_jtdt', $tanggal);
        $builder->where('kode_cabang', $cabang);
        return $builder->get();
    }
    //End----------------------
}
