<?php

namespace App\Models;

use CodeIgniter\Model;

class Product_model extends Model
{

    public function getCategory()
    {
        $builder = $this->db->table('tblproducttype');
        return $builder->get();
    }

    public function getProduct()
    {
        $builder = $this->db->table('tblproduct');
        $builder->select('*');
        $builder->join('tblproducttype', 'tblproduct.typ_code =tblproducttype.typ_code', 'left');
        return $builder->get();
    }

    public function saveProduct($data)
    {
        $query = $this->db->table('tblproduct')->insert($data);
        return $query;
    }

    public function updateProduct($data, $id)
    {
        $query = $this->db->table('tblproduct')->update($data, array('prd_code' => $id));
        return $query;
    }

    public function deleteProduct($id)
    {
        $query = $this->db->table('tblproduct')->delete(array('prd_code' => $id));
        return $query;
    }
}
