<?php

namespace App\Models;

use CodeIgniter\Model;

class Report_model extends Model
{

    public function _get_jurnal($id, $id1)
    {
        $builder = $this->db->table('transddb');
        $builder->select('*');
        $builder->join('tblaccount', 'transddb.acc_code=tblaccount.acc_code', 'inner');
        $builder->join('tblcoscentre', 'transddb.psb_code=tblcoscentre.psb_code', 'left');
        $builder->join('tblcompany', 'transddb.com_code=tblcompany.com_code', 'left');
        $builder->where('transddb.trx_amnt>', 0);
        $builder->where('transddb.trx_date>=', $id);
        $builder->where('transddb.trx_date<=', $id1);
        $builder->orderBy('transddb.trx_date', 'asc');
        $builder->orderBy('transddb.trx_code', 'asc');
        $builder->orderBy('transddb.trx_dbcr', 'asc');
        $builder->orderBy('transddb.acc_code', 'asc');

        return $builder->get();
    }
    public function _get_jurnalcab($id, $id1, $cabang)
    {
        $builder = $this->db->table('transddb');
        $builder->select('*');
        $builder->join('tblaccount', 'transddb.acc_code=tblaccount.acc_code', 'inner');
        $builder->join('tblcoscentre', 'transddb.psb_code=tblcoscentre.psb_code', 'left');
        $builder->join('tblcompany', 'transddb.com_code=tblcompany.com_code', 'left');
        $builder->where('transddb.trx_amnt>', 0);
        $builder->where('transddb.trx_date>=', $id);
        $builder->where('transddb.trx_date<=', $id1);
        $builder->where('transddb.kode_cabang', $cabang);
        $builder->orderBy('transddb.trx_date', 'asc');
        $builder->orderBy('transddb.trx_code', 'asc');
        $builder->orderBy('transddb.trx_dbcr', 'asc');
        $builder->orderBy('transddb.acc_code', 'asc');

        return $builder->get();
    }
    public function _get_simpanan($productid, $bulan, $tahun)
    {
        $builder = $this->db->table('trxsetorhdb');
        $builder->select('*');
        $builder->join('tblanggota', 'trxsetorhdb.agt_numb=tblanggota.agt_numb', 'inner');
        $builder->join('tblproduct', 'trxsetorhdb.kin_type=tblproduct.prd_code', 'left');
        $builder->join('tblcompany', 'trxsetorhdb.com_code=tblcompany.com_code', 'left');
        $builder->where('trxsetorhdb.kin_type', $productid);
        $builder->where('trxsetorhdb.kin_mont', $bulan);
        $builder->where('trxsetorhdb.kin_year', $tahun);
        $builder->orderBy('trxsetorhdb.kin_date', 'asc');


        return $builder->get();
    }

    public function _get_simpanan1($productid, $bulan, $tahun)
    {
        $builder = $this->db->table('trxsetorhdb');
        $builder->select('*');
        $builder->join('tblanggota', 'trxsetorhdb.agt_numb=tblanggota.agt_numb', 'inner');

        $builder->where('trxsetorhdb.kin_year', $tahun);

        return $builder->get();
    }

    public function _get_bukutabungan($norekening, $tanggal1, $tanggal2)
    {
        $builder = $this->db->table('trxkastabungan');
        $builder->select('*');
        $builder->join('tblanggota', 'trxkastabungan.agt_numb=tblanggota.agt_numb', 'inner');
        $builder->join('tblcompany', 'trxkastabungan.com_code=tblcompany.com_code', 'left');
        $builder->join('tblproduct', 'trxkastabungan.kin_type=tblproduct.prd_code', 'left');
        $builder->where('trxkastabungan.tbg_code', $norekening);
        $builder->where('trxkastabungan.kin_date>=', $tanggal1);
        $builder->where('trxkastabungan.kin_date<=', $tanggal2);
        $builder->orderBy('trxkastabungan.kin_date', 'asc');

        return $builder->get();
    }

    public function _get_bukutabunganawal($norekening, $tanggal1)
    {
        $builder = $this->db->table('trxkastabungan');
        $builder->select('sum(kin_crdt-kin_debt) as kin_sald');
        $builder->where('trxkastabungan.tbg_code', $norekening);
        $builder->where('trxkastabungan.kin_date<', $tanggal1);

        $builder->orderBy('trxkastabungan.kin_date', 'asc');
        return $builder->get();
    }

    public function _get_kartuangsuran($id)
    {
        $builder = $this->db->table('krtdebit');
        $builder->select('*');
        $builder->join('trxkontrak', 'krtdebit.trx_code=trxkontrak.knt_code', 'left');
        $builder->join('tblcompany', 'krtdebit.com_code=tblcompany.com_code', 'left');

        $builder->join('tblproduct', 'trxkontrak.prd_code=tblproduct.prd_code', 'left');
        $builder->join('tblanggota', 'trxkontrak.agt_numb=tblanggota.agt_numb', 'left');
        $builder->where('krtdebit.trx_code', $id);
        $builder->orderBy('krtdebit.trx_angk', 'asc');

        return $builder->get();
    }


    public function _get_deposito($productid, $bulan, $tahun)
    {
        $builder = $this->db->table('trxpenempatan');
        $builder->select('*');
        $builder->join('tblanggota', 'trxpenempatan.agt_numb=tblanggota.agt_numb', 'inner');
        $builder->join('tblproduct', 'trxpenempatan.prd_code=tblproduct.prd_code', 'left');
        $builder->join('tblcompany', 'trxpenempatan.com_code=tblcompany.com_code', 'left');
        $builder->where('trxpenempatan.prd_code', $productid);
        $builder->where('trxpenempatan.pen_mjtp', $bulan);
        $builder->where('trxpenempatan.pen_yjtp', $tahun);
        $builder->where('trxpenempatan.pen_stat', 0);
        $builder->orderBy('trxpenempatan.pen_jtdt', 'asc');


        return $builder->get();
    }
    public function _get_rep_pembiayaan($product, $bulan, $tahun)
    {
        $builder = $this->db->table('trxkontrak');
        $builder->select('*');
        $builder->join('tblanggota', 'trxkontrak.agt_numb=tblanggota.agt_numb', 'inner');
        $builder->join('tblproduct', 'trxkontrak.prd_code=tblproduct.prd_code', 'left');
        $builder->join('tblcompany', 'trxkontrak.com_code=tblcompany.com_code', 'left');
        $builder->where('trxkontrak.prd_code', $product);
        $builder->where('trxkontrak.knt_mont', $bulan);
        $builder->where('trxkontrak.knt_year', $tahun);
        $builder->orderBy('trxkontrak.knt_date', 'asc');


        return $builder->get();
    }


    public function _get_pengajuan($bulan, $tahun)
    {
        $builder = $this->db->table('trxpengajuan');
        $builder->select('*');
        $builder->join('tblanggota', 'trxpengajuan.agt_numb=tblanggota.agt_numb', 'inner');
        $builder->join('tblproduct', 'trxpengajuan.prd_code=tblproduct.prd_code', 'left');
        $builder->join('tblcompany', 'trxpengajuan.com_code=tblcompany.com_code', 'left');
        $builder->where('trxpengajuan.png_mont', $bulan);
        $builder->where('trxpengajuan.png_year', $tahun);
        $builder->orderBy('trxpengajuan.png_date', 'asc');


        return $builder->get();
    }


    public function _get_penutupan($bulan, $tahun)
    {
        $builder = $this->db->table('trxpenutupan');
        $builder->select('*');
        $builder->join('tblanggota', 'trxpenutupan.agt_numb=tblanggota.agt_numb', 'inner');
        $builder->join('tblproduct', 'trxpenutupan.prd_code=tblproduct.prd_code', 'left');
        $builder->join('tblcompany', 'trxpenutupan.com_code=tblcompany.com_code', 'left');
        $builder->where('trxpenutupan.pnt_mont', $bulan);
        $builder->where('trxpenutupan.pnt_year', $tahun);
        $builder->orderBy('trxpenutupan.pnt_date', 'asc');


        return $builder->get();
    }


    public function _get_bukubesar($norekening, $tanggal1, $tanggal2)
    {
        $builder = $this->db->table('transddb');
        $builder->select('*');
        $builder->join('tblaccount', 'transddb.acc_code=tblaccount.acc_code', 'inner');
        $builder->join('tblcoscentre', 'transddb.psb_code=tblcoscentre.psb_code', 'left');
        $builder->join('tblcompany', 'transddb.com_code=tblcompany.com_code', 'left');
        $builder->where('transddb.trx_amnt>', 0);
        $builder->where('transddb.trx_date>=', $tanggal1);
        $builder->where('transddb.trx_date<=', $tanggal2);
        $builder->where('transddb.acc_code', $norekening);
        $builder->orderBy('transddb.trx_code', 'asc');
        $builder->orderBy('transddb.trx_dbcr', 'asc');
        $builder->orderBy('transddb.acc_code', 'asc');


        return $builder->get();
    }

    public function _get_saldoawal($norekening, $tanggal1)
    {
        $builder = $this->db->table('accouddb');
        $builder->select('*');
        $builder->where('accouddb.acc_code', $norekening);
        $builder->where('accouddb.acc_date<', $tanggal1);
        $builder->orderBy('accouddb.acc_date', 'desc');
        $builder->limit(1);

        return $builder->get();
    }

    public function _get_saldoawalcab($norekening, $tanggal1, $cabang)
    {
        $builder = $this->db->table('accouddb');
        $builder->select('*');
        $builder->where('accouddb.acc_code', $norekening);
        $builder->where('accouddb.acc_date<', $tanggal1);
        $builder->where('accouddb.kode_cabang', $cabang);
        $builder->orderBy('accouddb.acc_date', 'desc');
        $builder->limit(1);

        return $builder->get();
    }


    public function _get_bungadeposito($bulan, $tahun)
    {
        $builder = $this->db->table('trxjasamdb');
        $builder->select('*');
        $builder->join('tblanggota', 'trxjasamdb.agt_numb=tblanggota.agt_numb', 'inner');
        $builder->join('tblproduct', 'trxjasamdb.prd_code=tblproduct.prd_code', 'left');
        $builder->join('tblcompany', 'trxjasamdb.com_code=tblcompany.com_code', 'left');
        $builder->where('tblproduct.prd_jens', 'D');
        $builder->where('trxjasamdb.jas_mont', $bulan);
        $builder->where('trxjasamdb.jas_year', $tahun);
        $builder->where('trxjasamdb.jas_jens', 'D');
        $builder->orderBy('trxjasamdb.jas_date', 'asc');


        return $builder->get();
    }
    public function _get_bungadepositocab($bulan, $tahun, $cabang)
    {
        $builder = $this->db->table('trxjasamdb');
        $builder->select('*');
        $builder->join('tblanggota', 'trxjasamdb.agt_numb=tblanggota.agt_numb', 'inner');
        $builder->join('tblproduct', 'trxjasamdb.prd_code=tblproduct.prd_code', 'left');
        $builder->join('tblcompany', 'trxjasamdb.com_code=tblcompany.com_code', 'left');
        $builder->where('tblproduct.prd_jens', 'D');
        $builder->where('trxjasamdb.jas_mont', $bulan);
        $builder->where('trxjasamdb.jas_year', $tahun);
        $builder->where('trxjasamdb.jas_jens', 'D');
        $builder->where('trxjasamdb.kode_cabang', $cabang);
        $builder->orderBy('trxjasamdb.jas_date', 'asc');


        return $builder->get();
    }
    public function get_transaksi($v_acc_code, $tgl_pertama, $tgl_terakhir)
    {
        $builder = $this->db->table('transddb');
        $builder->select('sum(dbt_amnt) as dbt_amnt,sum(crd_amnt) as crd_amnt');
        $builder->where('acc_code', $v_acc_code);
        $builder->where('trx_date>=', $tgl_pertama);
        $builder->where('trx_date<=', $tgl_terakhir);
        return $builder->get();
    }
    public function get_transaksicab($v_acc_code, $tgl_pertama, $tgl_terakhir, $cabang)
    {
        $builder = $this->db->table('transddb');
        $builder->select('sum(dbt_amnt) as dbt_amnt,sum(crd_amnt) as crd_amnt');
        $builder->where('acc_code', $v_acc_code);
        $builder->where('trx_date>=', $tgl_pertama);
        $builder->where('trx_date<=', $tgl_terakhir);
        $builder->where('kode_cabang', $cabang);
        return $builder->get();
    }
    public function _get_neracasaldo($bulan, $tahun)
    {
        $builder = $this->db->table('accouddb');
        $builder->select('*');
        $builder->join('tblaccount', 'accouddb.acc_code=tblaccount.acc_code', 'inner');
        $builder->join('tblcompany', 'accouddb.com_code=tblcompany.com_code', 'left');
        $builder->where('acc_buln', $bulan);
        $builder->where('acc_tahn', $tahun);
        $builder->orderBy('accouddb.acc_code', 'asc');
        return $builder->get();
    }
    public function _get_neracasaldocab($bulan, $tahun, $cabang)
    {
        $builder = $this->db->table('accouddb');
        $builder->select('*');
        $builder->join('tblaccount', 'accouddb.acc_code=tblaccount.acc_code', 'inner');
        $builder->join('tblcompany', 'accouddb.com_code=tblcompany.com_code', 'left');
        $builder->where('acc_buln', $bulan);
        $builder->where('acc_tahn', $tahun);
        $builder->where('accouddb.kode_cabang', $cabang);
        $builder->orderBy('accouddb.acc_code', 'asc');
        return $builder->get();
    }
    public function _get_labarugi()
    {
        $builder = $this->db->table('tblaccount');
        $builder->select('*');

        // $builder->where('acc_levl','3');
        $builder->where('acc_klas>=', '4');
        $builder->where('acc_dtum', 'U');
        $builder->where('acc_levl', '2');
        $builder->orderBy('acc_code', 'asc');
        return $builder->get();
    }


    public function _get_labarugi1($acc_code)
    {
        $builder = $this->db->table('tblaccount');
        $builder->select('*');

        // $builder->where('acc_levl','3');
        $builder->where('acc_klas>=', '4');
        // $builder->where('acc_dtum','U');
        $builder->where('acc_levl', '3');
        $builder->where('acc_umum', $acc_code);
        $builder->orderBy('acc_code', 'asc');
        return $builder->get();
    }
    public function _get_nilai($v_acc_code1, $bulan, $tahun)
    {
        $builder = $this->db->table('accouddb');
        $builder->select('sum(acc_akhc) as acc_akhc');
        // $builder->join('tblaccount', 'accouddb.acc_code=tblaccount.acc_code', 'inner');
        $builder->where('acc_buln', $bulan);
        $builder->where('acc_tahn', $tahun);
        $builder->like('accouddb.acc_code', $v_acc_code1, 'after');
        $builder->limit(1);
        return $builder->get();
    }


    public function _get_txlabarugi()
    {
        $builder = $this->db->table('tx_labarugi');
        $builder->select('*');
        $builder->join('tblcompany', 'tx_labarugi.com_code=tblcompany.com_code', 'inner');
        $builder->orderBy('urut', 'asc');
        return $builder->get();
    }


    public function _get_neracap($acc_klas1, $acc_klas2)
    {
        $builder = $this->db->table('tblaccount');
        $builder->select('*');

        // $builder->where('acc_levl','3');
        $builder->where('acc_klas>=', $acc_klas1);
        $builder->where('acc_klas<=', $acc_klas2);
        $builder->where('acc_dtum', 'U');
        $builder->where('acc_levl', '1');
        $builder->orderBy('acc_code', 'asc');
        return $builder->get();
    }

    public function _get_neraca($acc_klas1, $acc_klas2)
    {
        $builder = $this->db->table('tblaccount');
        $builder->select('*');

        // $builder->where('acc_levl','3');
        $builder->where('acc_klas>=', $acc_klas1);
        $builder->where('acc_klas<=', $acc_klas2);
        $builder->where('acc_dtum', 'U');
        $builder->where('acc_levl', '2');
        $builder->orderBy('acc_code', 'asc');
        return $builder->get();
    }

    public function _get_neraca1($acc_code)
    {
        $builder = $this->db->table('tblaccount');
        $builder->select('*');
        $builder->where('acc_levl', '3');
        $builder->where('acc_umum', $acc_code);
        $builder->orderBy('acc_code', 'asc');
        return $builder->get();
    }

    public function _get_neraca1p($acc_code)
    {
        $builder = $this->db->table('tblaccount');
        $builder->select('*');
        $builder->where('acc_levl', '2');
        $builder->where('acc_umum', $acc_code);
        $builder->orderBy('acc_code', 'asc');
        return $builder->get();
    }
    public function _get_txneraca()
    {
        $builder = $this->db->table('tx_neraca');
        $builder->select('*');
        $builder->join('tblcompany', 'tx_neraca.com_code=tblcompany.com_code', 'inner');
        $builder->orderBy('urut', 'asc');
        return $builder->get();
    }

    public function _get_nominatif()
    {
        $builder = $this->db->table('trxkontrak');
        $builder->select('*');
        $builder->join('tblanggota', 'trxkontrak.agt_numb=tblanggota.agt_numb', 'inner');
        $builder->join('v_tunggakan_anggota', 'trxkontrak.knt_code=v_tunggakan_anggota.trx_code', 'inner');
        $builder->join('trxtunggakan', 'trxkontrak.knt_code=trxtunggakan.tgk_code', 'inner');
        $builder->join('tblcompany', 'trxkontrak.com_code=tblcompany.com_code', 'inner');
        $builder->where('knt_stat!=', '2');
        // $builder->orderBy('knt_code', 'asc');
        return $builder->get();
    }
    public function _get_nominatifcab($cabang)
    {
        $builder = $this->db->table('trxkontrak');
        $builder->select('*');
        $builder->join('tblanggota', 'trxkontrak.agt_numb=tblanggota.agt_numb', 'inner');
        $builder->join('v_tunggakan_anggota', 'trxkontrak.knt_code=v_tunggakan_anggota.trx_code', 'inner');
        $builder->join('trxtunggakan', 'trxkontrak.knt_code=trxtunggakan.tgk_code', 'inner');
        $builder->join('tblcompany', 'trxkontrak.com_code=tblcompany.com_code', 'inner');
        $builder->where('knt_stat!=', '2');
        $builder->where('trxkontrak.kode_cabang', $cabang);
        // $builder->orderBy('knt_code', 'asc');
        return $builder->get();
    }
    public function get_dbtunggakan($tgl)
    {
        $builder = $this->db->table('krtdebit');
        $builder->select('trx_code,min(trx_jtdt) as trx_jtdt,sum(trx_pokk-lns_pokk) as tgk_pokk,sum(trx_bung-lns_bung) as tgk_bung');
        $builder->where('trx_jtdt<', $tgl);
        $builder->where('lns_pokk', 0);
        $builder->groupBy('trx_code');
        return $builder->get();
    }
    public function get_dbtunggakancab($tgl, $cabang)
    {
        $builder = $this->db->table('krtdebit');
        $builder->select('trx_code,min(trx_jtdt) as trx_jtdt,sum(trx_pokk-lns_pokk) as tgk_pokk,sum(trx_bung-lns_bung) as tgk_bung');
        $builder->where('trx_jtdt<', $tgl);
        $builder->where('lns_pokk', 0);
        $builder->where('krtdebit.kode_cabang', $cabang);
        $builder->groupBy('trx_code');
        return $builder->get();
    }
    public function get_dbawal($tgl)
    {
        $builder = $this->db->table('krtdebit');
        $builder->select('trx_code,sum(trx_pokk) as awl_pokk');
        $builder->where('trx_jtdt<', $tgl);
        $builder->where('lns_pokk', 0);
        $builder->groupBy('trx_code');
        return $builder->get();
    }

    public function get_dttunggakan($norekening, $tgl)
    {
        $builder = $this->db->table('krtdebit');
        $builder->select('trx_code,min(trx_jtdt) as trx_jtdt,sum(trx_pokk-lns_pokk) as tgk_pokk,sum(trx_bung-lns_bung) as tgk_bung,sum(trx_admn-lns_admn) as tgk_admn');
        $builder->where('trx_code', $norekening);
        $builder->where('trx_jtdt<', $tgl);
        $builder->where('(trx_pokk - lns_pokk)>', 0);
        // $builder->where('lns_pokk', 0);
        $builder->groupBy('trx_code');
        $builder->orderBy('trx_jtdt');
        $builder->limit(1);
        return $builder->get();
    }

    public function get_dttunggakanawal($norekening, $tgl)
    {
        $builder = $this->db->table('krtdebit');
        $builder->select('trx_code,sum(trx_pokk-lns_pokk) as tgk_pokk,sum(trx_bung-lns_bung) as tgk_bung,sum(trx_admn-lns_admn) as tgk_admn');
        $builder->where('trx_code', $norekening);
        $builder->where('trx_jtdt<', $tgl);
        $builder->where('(trx_pokk - lns_pokk)>', 0);
        // $builder->where('lns_pokk', 0);
        $builder->groupBy('trx_code');

        $builder->limit(1);
        return $builder->get();
    }


    public function get_dttunggakan1($norekening, $tgl1, $tgl2)
    {
        $builder = $this->db->table('krtdebit');
        $builder->select('trx_code,sum(trx_pokk) as tgk_pokk,sum(trx_bung) as tgk_bung,sum(trx_admn) as tgk_admn,sum(lns_pokk) as lns_pokk');
        $builder->where('trx_code', $norekening);
        $builder->where('trx_jtdt>=', $tgl1);
        $builder->where('trx_jtdt<=', $tgl2);
        $builder->where('lns_pokk', 0);
        $builder->groupBy('trx_code');
        $builder->limit(1);
        return $builder->get();
    }
    public function _deletenominatif($id)
    {
        $query = $this->db->table('trxtunggakan')->delete(array('com_code' => $id));

        return $query;
    }
    public function _get_trantab($tanggal1, $tanggal2)
    {
        $builder = $this->db->table('trxkastabungan');
        $builder->select('*');
        $builder->join('trxtabungan', 'trxkastabungan.tbg_code=trxtabungan.tbg_code', 'inner');
        $builder->join('tblanggota', 'trxtabungan.agt_numb=tblanggota.agt_numb', 'inner');
        $builder->join('tblcompany', 'trxkastabungan.com_code=tblcompany.com_code', 'left');
        $builder->join('tblproduct', 'trxtabungan.prd_code=tblproduct.prd_code', 'left');

        $builder->where('trxkastabungan.kin_date>=', $tanggal1);
        $builder->where('trxkastabungan.kin_date<=', $tanggal2);
        $builder->orderBy('trxkastabungan.kin_date', 'asc');
        $builder->orderBy('trxkastabungan.kin_code', 'asc');
        return $builder->get();
    }
    public function _get_trantabcab($tanggal1, $tanggal2, $cabang)
    {
        $builder = $this->db->table('trxkastabungan');
        $builder->select('*');
        $builder->join('trxtabungan', 'trxkastabungan.tbg_code=trxtabungan.tbg_code', 'inner');
        $builder->join('tblanggota', 'trxtabungan.agt_numb=tblanggota.agt_numb', 'inner');
        $builder->join('tblcompany', 'trxkastabungan.com_code=tblcompany.com_code', 'left');
        $builder->join('tblproduct', 'trxtabungan.prd_code=tblproduct.prd_code', 'left');


        $builder->where('trxkastabungan.kin_date>=', $tanggal1);
        $builder->where('trxkastabungan.kin_date<=', $tanggal2);
        $builder->where('trxkastabungan.kode_cabang', $cabang);
        $builder->orderBy('trxkastabungan.kin_date', 'asc');
        $builder->orderBy('trxkastabungan.kin_code', 'asc');
        return $builder->get();
    }
    public function _get_trantabprod($id, $tanggal1, $tanggal2)
    {
        $builder = $this->db->table('trxkastabungan');
        $builder->select('*');
        $builder->join('tblanggota', 'trxkastabungan.agt_numb=tblanggota.agt_numb', 'inner');
        $builder->join('tblcompany', 'trxkastabungan.com_code=tblcompany.com_code', 'left');
        $builder->join('tblproduct', 'trxkastabungan.kin_type=tblproduct.prd_code', 'left');
        $builder->where('trxkastabungan.kin_type', $id);
        $builder->where('trxkastabungan.kin_date>=', $tanggal1);
        $builder->where('trxkastabungan.kin_date<=', $tanggal2);
        $builder->orderBy('trxkastabungan.tbg_code', 'asc');
        return $builder->get();
    }

    public function _get_tutuptabs($tanggal1, $tanggal2)
    {
        $builder = $this->db->table('trxtabungan');
        $builder->select('*');
        $builder->join('tblanggota', 'trxtabungan.agt_numb=tblanggota.agt_numb', 'inner');
        $builder->join('tblcompany', 'trxtabungan.com_code=tblcompany.com_code', 'left');
        // $builder->join('tblproduct', 'trxtabungan.kin_type=tblproduct.prd_code', 'left');

        $builder->where('trxtabungan.tbg_clos>=', $tanggal1);
        $builder->where('trxtabungan.tbg_clos<=', $tanggal2);
        $builder->orderBy('trxtabungan.tbg_clos', 'asc');
        return $builder->get();
    }
    public function _get_tutuptabscab($tanggal1, $tanggal2, $cabang)
    {
        $builder = $this->db->table('trxtabungan');
        $builder->select('*');
        $builder->join('tblanggota', 'trxtabungan.agt_numb=tblanggota.agt_numb', 'inner');
        $builder->join('tblcompany', 'trxtabungan.com_code=tblcompany.com_code', 'left');
        // $builder->join('tblproduct', 'trxtabungan.kin_type=tblproduct.prd_code', 'left');

        $builder->where('trxtabungan.tbg_clos>=', $tanggal1);
        $builder->where('trxtabungan.tbg_clos<=', $tanggal2);
        $builder->where('trxtabungan.kode_cabang', $cabang);
        $builder->orderBy('trxtabungan.tbg_clos', 'asc');
        return $builder->get();
    }
    public function _get_barutabs($tanggal1, $tanggal2)
    {
        $builder = $this->db->table('trxtabungan');
        $builder->select('trxtabungan.*,tblanggota.*,tblcompany.*,tblproduct.*,v_akh_tabungan.tbg_akh1');
        $builder->join('tblanggota', 'trxtabungan.agt_numb=tblanggota.agt_numb', 'inner');
        $builder->join('tblcompany', 'trxtabungan.com_code=tblcompany.com_code', 'left');
        // $builder->join('tblsmtmdb', 'trxtabungan.smt_code=tblsmtmdb.smt_code', 'left');
        $builder->join('tblproduct', 'trxtabungan.prd_code=tblproduct.prd_code', 'left');
        $builder->join('v_akh_tabungan', 'trxtabungan.tbg_code=v_akh_tabungan.tbg_code', 'left');
        // // $builder->join('tbltujtabungan', 'trxtabungan.tuj_code=tbltujtabungan.tuj_code', 'left');

        $builder->where('trxtabungan.tbg_date>=', $tanggal1);
        $builder->where('trxtabungan.tbg_date<=', $tanggal2);
        $builder->orderBy('trxtabungan.tbg_date', 'asc');
        return $builder->get();
    }
    public function _get_barutabscab($tanggal1, $tanggal2, $cabang)
    {
        $builder = $this->db->table('trxtabungan');
        $builder->select('trxtabungan.*,tblanggota.*,tblcompany.*,tblproduct.*,v_akh_tabungan.tbg_akh1');
        $builder->join('tblanggota', 'trxtabungan.agt_numb=tblanggota.agt_numb', 'inner');
        $builder->join('tblcompany', 'trxtabungan.com_code=tblcompany.com_code', 'left');
        // $builder->join('tblsmtmdb', 'trxtabungan.smt_code=tblsmtmdb.smt_code', 'left');
        $builder->join('tblproduct', 'trxtabungan.prd_code=tblproduct.prd_code', 'left');
        $builder->join('v_akh_tabungan', 'trxtabungan.tbg_code=v_akh_tabungan.tbg_code', 'left');
        // // $builder->join('tbltujtabungan', 'trxtabungan.tuj_code=tbltujtabungan.tuj_code', 'left');

        $builder->where('trxtabungan.tbg_date>=', $tanggal1);
        $builder->where('trxtabungan.tbg_date<=', $tanggal2);
        $builder->where('trxtabungan.kode_cabang', $cabang);
        $builder->orderBy('trxtabungan.tbg_date', 'asc');
        return $builder->get();
    }
    public function _get_pajaktabs($tanggal1, $tanggal2)
    {
        $builder = $this->db->table('trxjasamdb');
        $builder->select('*');
        $builder->join('tblanggota', 'trxjasamdb.agt_numb=tblanggota.agt_numb', 'inner');
        $builder->join('tblcompany', 'trxjasamdb.com_code=tblcompany.com_code', 'left');
        $builder->join('tblproduct', 'trxjasamdb.prd_code=tblproduct.prd_code', 'left');

        $builder->where('trxjasamdb.jas_date>=', $tanggal1);
        $builder->where('trxjasamdb.jas_date<=', $tanggal2);
        $builder->where('trxjasamdb.jas_jens', 'T');
        $builder->orderBy('trxjasamdb.jas_date', 'asc');
        return $builder->get();
    }
    public function _get_pajaktabscab($tanggal1, $tanggal2, $cabang)
    {
        $builder = $this->db->table('trxjasamdb');
        $builder->select('*');
        $builder->join('tblanggota', 'trxjasamdb.agt_numb=tblanggota.agt_numb', 'inner');
        $builder->join('tblcompany', 'trxjasamdb.com_code=tblcompany.com_code', 'left');
        $builder->join('tblproduct', 'trxjasamdb.prd_code=tblproduct.prd_code', 'left');

        $builder->where('trxjasamdb.jas_date>=', $tanggal1);
        $builder->where('trxjasamdb.jas_date<=', $tanggal2);
        $builder->where('trxjasamdb.jas_jens', 'T');
        $builder->where('trxjasamdb.kode_cabang', $cabang);
        $builder->orderBy('trxjasamdb.jas_date', 'asc');
        return $builder->get();
    }
    public function _get_nominatiftabs($tanggal)
    {
        $builder = $this->db->table('trxkastabungan');
        $builder->select('trxkastabungan.tbg_code,agt_name,com_name,com_adrs,com_logo,trxtabungan.tbg_stat,tbg_loka,tbg_pemk,sex_code,sum(kin_crdt-kin_debt) as tbg_akhr,trxtabungan.kode_cabang');
        $builder->join('trxtabungan', 'trxkastabungan.tbg_code=trxtabungan.tbg_code', 'inner');
        $builder->join('tblanggota', 'trxtabungan.agt_numb=tblanggota.agt_numb', 'inner');

        $builder->join('tblcompany', 'trxtabungan.com_code=tblcompany.com_code', 'left');
        $builder->where('trxkastabungan.kin_date<=', $tanggal);
        $builder->where('trxtabungan.tbg_stat<', '2');
        $builder->groupBy('trxkastabungan.tbg_code,agt_name,com_name,com_adrs,com_logo,trxtabungan.tbg_stat,tbg_loka,tbg_pemk,sex_code');
        $builder->orderBy('trxtabungan.tbg_date', 'asc');
        return $builder->get();
    }
    public function _get_nominatiftabscab($tanggal, $cabang)
    {
        $builder = $this->db->table('trxkastabungan');
        $builder->select('trxkastabungan.tbg_code,agt_name,com_name,com_adrs,com_logo,trxtabungan.tbg_stat,tbg_loka,tbg_pemk,sex_code,sum(kin_crdt-kin_debt) as tbg_akhr,trxtabungan.kode_cabang');
        $builder->join('trxtabungan', 'trxkastabungan.tbg_code=trxtabungan.tbg_code', 'inner');
        $builder->join('tblanggota', 'trxtabungan.agt_numb=tblanggota.agt_numb', 'inner');

        $builder->join('tblcompany', 'trxtabungan.com_code=tblcompany.com_code', 'left');
        $builder->where('trxkastabungan.kin_date<=', $tanggal);
        $builder->where('trxtabungan.tbg_stat<', '2');
        $builder->where('trxtabungan.kode_cabang', $cabang);
        $builder->groupBy('trxkastabungan.tbg_code,agt_name,com_name,com_adrs,com_logo,trxtabungan.tbg_stat,tbg_loka,tbg_pemk,sex_code');
        $builder->orderBy('trxtabungan.tbg_date', 'asc');
        return $builder->get();
    }
    public function _get_mutasitabs($host)
    {
        $builder = $this->db->table('tx_tabungan');
        $builder->select('*');

        $builder->join('tblanggota', 'tx_tabungan.agt_numb=tblanggota.agt_numb', 'inner');
        $builder->join('tblcompany', 'tx_tabungan.com_code=tblcompany.com_code', 'left');
        $builder->orderBy('tx_tabungan.tbg_code', 'asc');
        return $builder->get();
    }
    public function _get_mutasitabscab($host, $cabang)
    {
        $builder = $this->db->table('tx_tabungan');
        $builder->select('*');

        $builder->join('tblanggota', 'tx_tabungan.agt_numb=tblanggota.agt_numb', 'inner');
        $builder->join('tblcompany', 'tx_tabungan.com_code=tblcompany.com_code', 'left');
        $builder->where('tx_tabungan.kode_cabang', $cabang);
        $builder->orderBy('tx_tabungan.tbg_code', 'asc');
        return $builder->get();
    }
    public function _get_covertabungan($id)
    {
        $builder = $this->db->table('trxtabungan');
        $builder->select('*');
        $builder->join('tblanggota', 'trxtabungan.agt_numb=tblanggota.agt_numb', 'inner');

        $builder->where('trxtabungan.tbg_code', $id);
        return $builder->get();
    }

    public function _get_nomintaifssb($id)
    {
        $builder = $this->db->table('trxpenempatan');
        $builder->select('*');
        $builder->join('tblanggota', 'trxpenempatan.agt_numb=tblanggota.agt_numb', 'inner');
        $builder->join('tblcompany', 'trxpenempatan.com_code=tblcompany.com_code', 'inner');
        $builder->where('trxpenempatan.pen_rdat<=', $id);
        return $builder->get();
    }

    public function _get_transaksissb($tanggal1, $tanggal2)
    {
        $builder = $this->db->table('trxkasssb');
        $builder->select('*');
        $builder->join('tblanggota', 'trxkasssb.agt_numb=tblanggota.agt_numb', 'inner');
        $builder->join('tblcompany', 'trxkasssb.com_code=tblcompany.com_code', 'inner');
        $builder->where('trxkasssb.kin_date>=', $tanggal1);
        $builder->where('trxkasssb.kin_date<=', $tanggal2);
        return $builder->get();
    }

    public function _get_barussb($tanggal1, $tanggal2)
    {
        $builder = $this->db->table('trxpenempatan');
        $builder->select('*');
        $builder->join('tblanggota', 'trxpenempatan.agt_numb=tblanggota.agt_numb', 'inner');
        $builder->join('tblcompany', 'trxpenempatan.com_code=tblcompany.com_code', 'inner');
        $builder->where('trxpenempatan.pen_aktv>=', $tanggal1);
        $builder->where('trxpenempatan.pen_aktv<=', $tanggal2);
        return $builder->get();
    }
    public function _get_barussbcab($tanggal1, $tanggal2, $cabang)
    {
        $builder = $this->db->table('trxpenempatan');
        $builder->select('*');
        $builder->join('tblanggota', 'trxpenempatan.agt_numb=tblanggota.agt_numb', 'inner');
        $builder->join('tblcompany', 'trxpenempatan.com_code=tblcompany.com_code', 'inner');
        $builder->where('trxpenempatan.pen_aktv>=', $tanggal1);
        $builder->where('trxpenempatan.pen_aktv<=', $tanggal2);
        $builder->where('trxpenempatan.kode_cabang', $cabang);
        return $builder->get();
    }

    public function _get_tutupssb($tanggal1, $tanggal2)
    {
        $builder = $this->db->table('trxpenempatan');
        $builder->select('*');

        $builder->join('tblanggota', 'trxpenempatan.agt_numb=tblanggota.agt_numb', 'inner');
        $builder->join('tblcompany', 'trxpenempatan.com_code=tblcompany.com_code', 'inner');
        $builder->where('trxpenempatan.pnt_date>=', $tanggal1);
        $builder->where('trxpenempatan.pnt_date<=', $tanggal2);
        return $builder->get();
    }
    public function _get_tutupssbcab($tanggal1, $tanggal2, $cabang)
    {
        $builder = $this->db->table('trxpenempatan');
        $builder->select('*');

        $builder->join('tblanggota', 'trxpenempatan.agt_numb=tblanggota.agt_numb', 'inner');
        $builder->join('tblcompany', 'trxpenempatan.com_code=tblcompany.com_code', 'inner');
        $builder->where('trxpenempatan.pnt_date>=', $tanggal1);
        $builder->where('trxpenempatan.pnt_date<=', $tanggal2);
        $builder->where('trxpenempatan.kode_cabang', $cabang);
        return $builder->get();
    }
    public function _get_tutupssb1($tanggal1, $tanggal2)
    {
        $builder = $this->db->table('trxpenutupan');
        $builder->select('*');
        $builder->join('trxpenempatan', 'trxpenutupan.pen_code=trxpenempatan.pen_code', 'inner');
        $builder->join('tblanggota', 'trxpenutupan.agt_numb=tblanggota.agt_numb', 'inner');
        $builder->join('tblcompany', 'trxpenutupan.com_code=tblcompany.com_code', 'inner');
        $builder->where('trxpenutupan.pnt_date>=', $tanggal1);
        $builder->where('trxpenutupan.pnt_date<=', $tanggal2);
        return $builder->get();
    }

    public function _get_jadwalbungassb($tanggal, $tanggal2)
    {
        $builder = $this->db->table('trxjasamdb');
        $builder->select('*');
        $builder->join('trxpenempatan', 'trxjasamdb.tbg_code=trxpenempatan.pen_code', 'inner');
        $builder->join('tblanggota', 'trxjasamdb.agt_numb=tblanggota.agt_numb', 'inner');
        $builder->join('tblproduct', 'trxjasamdb.prd_code=tblproduct.prd_code', 'left');
        $builder->join('tblcompany', 'trxjasamdb.com_code=tblcompany.com_code', 'left');
        // $builder->where('tblproduct.prd_jens', 'D');
        $builder->where('trxjasamdb.jas_date>=', $tanggal);
        $builder->where('trxjasamdb.jas_date<=', $tanggal2);
        $builder->where('trxjasamdb.jas_jens', 'D');
        $builder->orderBy('trxjasamdb.jas_date', 'asc');
        return $builder->get();
    }
    public function _get_jadwalbungassbcab($tanggal, $tanggal2, $cabang)
    {
        $builder = $this->db->table('trxjasamdb');
        $builder->select('*');
        $builder->join('trxpenempatan', 'trxjasamdb.tbg_code=trxpenempatan.pen_code', 'inner');
        $builder->join('tblanggota', 'trxjasamdb.agt_numb=tblanggota.agt_numb', 'inner');
        $builder->join('tblproduct', 'trxjasamdb.prd_code=tblproduct.prd_code', 'left');
        $builder->join('tblcompany', 'trxjasamdb.com_code=tblcompany.com_code', 'left');
        // $builder->where('tblproduct.prd_jens', 'D');
        $builder->where('trxjasamdb.jas_date>=', $tanggal);
        $builder->where('trxjasamdb.jas_date<=', $tanggal2);
        $builder->where('trxjasamdb.jas_jens', 'D');
        $builder->where('trxjasamdb.kode_cabang', $cabang);
        $builder->orderBy('trxjasamdb.jas_date', 'asc');
        return $builder->get();
    }
    public function _get_rekkoranssb($norekening, $tanggal1, $tanggal2)
    {
        $builder = $this->db->table('trx_deposito');
        $builder->select('*');
        $builder->join('tblanggota', 'trx_deposito.agt_numb=tblanggota.agt_numb', 'inner');
        $builder->join('tblcompany', 'trx_deposito.com_code=tblcompany.com_code', 'inner');
        $builder->join('trxpenempatan', 'trx_deposito.tbg_code=trxpenempatan.pen_code', 'inner');
        $builder->join('tblproduct', 'trxpenempatan.prd_code=tblproduct.prd_code', 'inner');
        $builder->where('trx_deposito.rek_date>=', $tanggal1);
        $builder->where('trx_deposito.rek_date<=', $tanggal2);
        $builder->where('trx_deposito.tbg_code', $norekening);
        return $builder->get();
    }

    public function _get_transpembiayaan($tanggal1, $tanggal2)
    {
        // $builder = $this->db->table('trxkontrak');
        // $builder->select('*');
        // $builder->join('tblanggota', 'trxkontrak.agt_numb=tblanggota.agt_numb', 'inner');
        // $builder->join('tblcompany', 'trxkontrak.com_code=tblcompany.com_code', 'inner');
        // $builder->where('trxkontrak.knt_date>=', $tanggal1);
        // $builder->where('trxkontrak.knt_date<=', $tanggal2);
        // $builder->orderBy('knt_date', 'asc');

        $builder = $this->db->table('trxcashcost');
        $builder->select('*');
        $builder->join('tblanggota', 'trxcashcost.agt_numb=tblanggota.agt_numb', 'inner');
        $builder->join('tblcompany', 'trxcashcost.com_code=tblcompany.com_code', 'inner');
        $builder->where('trxcashcost.kin_date>=', $tanggal1);
        $builder->where('trxcashcost.kin_date<=', $tanggal2);
        $builder->orderBy('kin_date', 'asc');

        return $builder->get();
    }
    public function _get_transpembiayaancab($tanggal1, $tanggal2, $cabang)
    {
        $builder = $this->db->table('trxcashcost');
        $builder->select('*');
        $builder->join('tblanggota', 'trxcashcost.agt_numb=tblanggota.agt_numb', 'inner');
        $builder->join('tblcompany', 'trxcashcost.com_code=tblcompany.com_code', 'inner');
        $builder->where('trxcashcost.kin_date>=', $tanggal1);
        $builder->where('trxcashcost.kin_date<=', $tanggal2);
        $builder->where('trxcashcost.kode_cabang', $cabang);
        $builder->orderBy('kin_date', 'asc');



        return $builder->get();
    }
    public function _get_mutasupembiayaan($tanggal1, $tanggal2)
    {
        $builder = $this->db->table('trxkontrak');
        $builder->select('*');
        $builder->join('tblanggota', 'trxkontrak.agt_numb=tblanggota.agt_numb', 'inner');
        $builder->join('tblcompany', 'trxkontrak.com_code=tblcompany.com_code', 'inner');
        $builder->where('trxkontrak.knt_date>=', $tanggal1);
        $builder->where('trxkontrak.knt_date<=', $tanggal2);
        $builder->where('trxkontrak.knt_stat', '1');
        return $builder->get();
    }


    public function _get_mutasupembiayaancab($tanggal1, $tanggal2, $cabang)
    {
        $builder = $this->db->table('trxkontrak');
        $builder->select('*');
        $builder->join('tblanggota', 'trxkontrak.agt_numb=tblanggota.agt_numb', 'inner');
        $builder->join('tblcompany', 'trxkontrak.com_code=tblcompany.com_code', 'inner');
        // $builder->join('trxcashcost', 'trxkontrak.knt_code=trxcashcost.knt_code', 'left');
        $builder->where('trxkontrak.knt_date>=', $tanggal1);
        $builder->where('trxkontrak.knt_date<=', $tanggal2);
        $builder->where('trxkontrak.knt_stat', '1');
        $builder->where('trxkontrak.kode_cabang', $cabang);

        return $builder->get();
    }
    public function _get_tagihan($tanggal1, $tanggal2)
    {
        $builder = $this->db->table('krtdebit');
        $builder->select('*');
        $builder->join('tblanggota', 'krtdebit.agt_numb=tblanggota.agt_numb', 'inner');
        $builder->join('tblcompany', 'krtdebit.com_code=tblcompany.com_code', 'inner');
        $builder->join('trxkontrak', 'krtdebit.trx_code=trxkontrak.knt_code', 'inner');
        $builder->join('v_saldo_pembiayaan', 'krtdebit.trx_code=v_saldo_pembiayaan.trx_code', 'inner');
        $builder->where('trx_jtdt>=', $tanggal1);
        $builder->where('trx_jtdt<=', $tanggal2);
        // $builder->where('lns_pokk', 0);


        return $builder->get();
    }
    public function _get_tagihancab($tanggal1, $tanggal2, $cabang)
    {
        $builder = $this->db->table('krtdebit');
        $builder->select('*');
        $builder->join('tblanggota', 'krtdebit.agt_numb=tblanggota.agt_numb', 'inner');
        $builder->join('tblcompany', 'krtdebit.com_code=tblcompany.com_code', 'inner');
        $builder->join('trxkontrak', 'krtdebit.trx_code=trxkontrak.knt_code', 'inner');
        $builder->join('v_saldo_pembiayaan', 'krtdebit.trx_code=v_saldo_pembiayaan.trx_code', 'inner');
        $builder->where('trx_jtdt>=', $tanggal1);
        $builder->where('trx_jtdt<=', $tanggal2);
        $builder->where('krtdebit.kode_cabang', $cabang);
        return $builder->get();
    }
    public function get_dtlpinjaman($norekning)
    {
        $builder = $this->db->table('krtdebit');
        $builder->select('sum(trx_pokk) as trx_amnh');
        $builder->where('lns_pokk', 0);
        $builder->where('trx_code', $norekning);
        return $builder->get();
    }


    public function _get_lunaspembiayaan($tanggal1, $tanggal2)
    {
        $builder = $this->db->table('trxcashcost');
        $builder->select('*');
        $builder->join('trxkontrak', 'trxcashcost.knt_code=trxkontrak.knt_code', 'inner');
        $builder->join('tblanggota', 'trxcashcost.agt_numb=tblanggota.agt_numb', 'inner');
        $builder->join('tblcompany', 'trxkontrak.com_code=tblcompany.com_code', 'inner');
        $builder->where('trxcashcost.kin_date>=', $tanggal1);
        $builder->where('trxcashcost.kin_date<=', $tanggal2);
        $builder->where('trxcashcost.kin_type', '02');
        return $builder->get();
    }
    public function _get_lunaspembiayaancab($tanggal1, $tanggal2, $cabang)
    {
        $builder = $this->db->table('trxcashcost');
        $builder->select('*');
        $builder->join('trxkontrak', 'trxcashcost.knt_code=trxkontrak.knt_code', 'inner');
        $builder->join('tblanggota', 'trxcashcost.agt_numb=tblanggota.agt_numb', 'inner');
        $builder->join('tblcompany', 'trxkontrak.com_code=tblcompany.com_code', 'inner');
        $builder->where('trxcashcost.kin_date>=', $tanggal1);
        $builder->where('trxcashcost.kin_date<=', $tanggal2);
        $builder->where('trxcashcost.kin_type', '02');
        $builder->where('trxcashcost.kode_cabang', $cabang);
        return $builder->get();
    }
    public function _get_rptanggota($tanggal1, $tanggal2)
    {
        $builder = $this->db->table('tblanggota');
        $builder->select('*');
        $builder->join('tblcompany', 'tblanggota.com_code=tblcompany.com_code', 'left');
        $builder->where('tblanggota.agt_jdat>=', $tanggal1);
        $builder->where('tblanggota.agt_jdat<=', $tanggal2);
        return $builder->get();
    }

    public function get_pinjaman($cabang)
    {
        $builder = $this->db->table('trxkontrak');
        $builder->select('*');
        $builder->where('knt_stat<', 4);
        $builder->where('kode_cabang', $cabang);
        return $builder->get();
    }
    public function get_pinjamana()
    {
        $builder = $this->db->table('trxkontrak');
        $builder->select('*');
        $builder->where('knt_stat<', 4);
        return $builder->get();
    }
    public function _get_perfromance($tanggal1, $tanggal2)
    {
        $builder = $this->db->table('trxperformance');
        $builder->select('*');
        $builder->join('krtdebit', 'trxperformance.knt_code=krtdebit.trx_code', 'left');
        $builder->join('tblcompany', 'trxperformance.com_code=tblcompany.com_code', 'left');
        $builder->join('tblanggota', 'trxperformance.agt_numb=tblanggota.agt_numb', 'left');
        $builder->where('krtdebit.trx_jtdt>=', $tanggal1);
        $builder->where('krtdebit.trx_jtdt<=', $tanggal2);
        $builder->where('lns_pokk', 0);
        return $builder->get();
    }


    public function get_dtbayarpokok($norekening, $tanggal)
    {
        $builder = $this->db->table('krtdebit');
        $builder->select('sum(lns_pokk) as lns_pokk');
        $builder->where('trx_jtdt<=', $tanggal);
        $builder->where('trx_code', $norekening);
        return $builder->get();
    }

    public function _get_saldoawalkas($id, $tanggal)
    {
        $builder = $this->db->table('transddb');
        $builder->select('*');
        $builder->where('trx_date', $tanggal);
        $builder->where('acc_code', $id);
        $builder->like('trx_des1', '%Awal');
        return $builder->get();
    }
    public function _gettranskas($id, $id2, $tanggal)
    {
        $builder = $this->db->table('transddb');
        $builder->select('trx_des2,sum(dbt_amnt) as dbt_amnt,,sum(crd_amnt) as crd_amnt');
        $builder->where('trx_date', $tanggal);
        $builder->where('acc_code', $id);
        $builder->where('trx_dbcr', $id2);
        $builder->notLike('trx_des1', '%Awal');
        $builder->groupBy('trx_des2');

        return $builder->get();
    }

    public function _gettranskasdtl($id, $tanggal)
    {
        $builder = $this->db->table('transddb');
        $builder->select('*');
        $builder->where('trx_date', $tanggal);
        $builder->where('acc_code', $id);


        return $builder->get();
    }

    public function _get_jumkontrak()
    {
        $builder = $this->db->table('trxkontrak');
        $builder->select('*');
        $builder->join('tblcompany', 'trxkontrak.com_code=tblcompany.com_code', 'left');
        $builder->join('tblanggota', 'trxkontrak.agt_numb=tblanggota.agt_numb', 'left');
        $builder->join('tblproduct', 'trxkontrak.prd_code=tblproduct.prd_code', 'left');
        $builder->where('knt_stat<', 5);
        $builder->where('knt_totl>', 0);
        $builder->orderby('knt_totl', 'desc');
        $builder->limit(100);

        return $builder->get();
    }

    public function _get_jumkontrakcab($cabang)
    {
        $builder = $this->db->table('trxkontrak');
        $builder->select('*');
        $builder->join('tblcompany', 'trxkontrak.com_code=tblcompany.com_code', 'left');
        $builder->join('tblanggota', 'trxkontrak.agt_numb=tblanggota.agt_numb', 'left');
        $builder->join('tblproduct', 'trxkontrak.prd_code=tblproduct.prd_code', 'left');
        $builder->where('knt_stat<', 5);
        $builder->where('knt_totl>', 0);
        $builder->where('trxkontrak.kode_cabang', $cabang);
        $builder->orderby('knt_totl', 'desc');
        $builder->limit(100);

        return $builder->get();
    }
    public function _get_jumskb()
    {
        $builder = $this->db->table('trxpenempatan');
        $builder->select('*');
        $builder->join('tblcompany', 'trxpenempatan.com_code=tblcompany.com_code', 'left');
        $builder->join('tblanggota', 'trxpenempatan.agt_numb=tblanggota.agt_numb', 'left');
        $builder->join('tblproduct', 'trxpenempatan.prd_code=tblproduct.prd_code', 'left');
        $builder->where('pen_stat<', 5);
        $builder->where('pen_totl>', 0);
        $builder->orderby('pen_totl', 'desc');
        $builder->limit(100);

        return $builder->get();
    }
    public function _get_jumskbcab($cabang)
    {
        $builder = $this->db->table('trxpenempatan');
        $builder->select('*');
        $builder->join('tblcompany', 'trxpenempatan.com_code=tblcompany.com_code', 'left');
        $builder->join('tblanggota', 'trxpenempatan.agt_numb=tblanggota.agt_numb', 'left');
        $builder->join('tblproduct', 'trxpenempatan.prd_code=tblproduct.prd_code', 'left');
        $builder->where('pen_stat<', 5);
        $builder->where('pen_totl>', 0);
        $builder->where('trxpenempatan.kode_cabang', $cabang);
        $builder->orderby('pen_totl', 'desc');
        $builder->limit(100);

        return $builder->get();
    }
    public function _get_jumsimpanan()
    {
        $builder = $this->db->table('trxtabungan');
        $builder->select('*');
        $builder->join('tblcompany', 'trxtabungan.com_code=tblcompany.com_code', 'left');
        $builder->join('tblanggota', 'trxtabungan.agt_numb=tblanggota.agt_numb', 'left');
        $builder->join('tblproduct', 'trxtabungan.prd_code=tblproduct.prd_code', 'left');
        $builder->where('tbg_stat<', 5);
        $builder->where('tbg_totl>', 0);
        $builder->orderby('tbg_totl', 'desc');
        $builder->limit(100);

        return $builder->get();
    }

    public function _get_dataasset($asttype)
    {
        $builder = $this->db->table('trxasset');
        $builder->select('*');
        $builder->join('tblmethode', 'trxasset.ast_meth=tblmethode.ast_meth', 'inner');
        $builder->join('tblassettype', 'trxasset.ast_type=tblassettype.ast_type', 'inner');
        $builder->where('trxasset.ast_type', $asttype);
        return $builder->get();
    }


    public function _get_akumdataasset($asttype, $bulan, $tahun)
    {
        $builder = $this->db->table('trxassetam');
        $builder->select('*');
        $builder->join('trxasset', 'trxassetam.ast_code=trxasset.ast_code', 'inner');
        $builder->join('tblmethode', 'trxasset.ast_meth=tblmethode.ast_meth', 'inner');
        $builder->join('tblassettype', 'trxasset.ast_type=tblassettype.ast_type', 'inner');
        $builder->where('trxasset.ast_type', $asttype);
        $builder->where('akm_mont', $bulan);
        $builder->where('akm_year', $tahun);
        return $builder->get();
    }

    public function _get_sumakumdataasset($bulan, $tahun)
    {
        $builder = $this->db->table('trxassetam');
        $builder->select('trxasset.ast_type,tblassettype.ast_tnam,sum(akm_amnt) as akm_amnt');
        $builder->join('trxasset', 'trxassetam.ast_code=trxasset.ast_code', 'inner');
        $builder->join('tblmethode', 'trxasset.ast_meth=tblmethode.ast_meth', 'inner');
        $builder->join('tblassettype', 'trxasset.ast_type=tblassettype.ast_type', 'inner');
        $builder->where('akm_mont', $bulan);
        $builder->where('akm_year', $tahun);
        $builder->groupBy('trxasset.ast_type');
        $builder->groupBy('tblassettype.ast_tnam');
        // $builder->orderBy('tblassettype.ast_type', 'asc');
        return $builder->get();
    }
    public function _get_gettypeasset()
    {
        $builder = $this->db->table('tblassettype');
        $builder->select('tblassettype.ast_type,ast_tnam');
        $builder->join('trxasset', 'tblassettype.ast_type=trxasset.ast_type', 'inner');
        $builder->orderBy('tblassettype.ast_type', 'asc');
        return $builder->get();
    }
    public function _get_gettypeasset1()
    {
        $builder = $this->db->table('tblassettype');
        $builder->select('tblassettype.ast_type,ast_tnam');
        $builder->orderBy('tblassettype.ast_type', 'asc');
        return $builder->get();
    }
    public function _get_daftaragunan()
    {
        $builder = $this->db->table('trxpenagunan');
        $builder->select('*');
        $builder->join('trxkontrak', 'trxpenagunan.knt_code=trxkontrak.knt_code', 'inner');
        $builder->join('tbljnsagunan', 'trxpenagunan.agn_type=tbljnsagunan.jns_idno', 'inner');
        $builder->join('tblanggota', 'trxkontrak.agt_numb=tblanggota.agt_numb', 'inner');
        $builder->orderBy('trxpenagunan.knt_code', 'asc');
        return $builder->get();
    }
    public function _get_daftaragunanrek($id)
    {

        $builder = $this->db->table('trxpenagunan');
        $builder->select('*');
        $builder->join('trxkontrak', 'trxpenagunan.knt_code=trxkontrak.knt_code', 'inner');
        $builder->join('tbljnsagunan', 'trxpenagunan.agn_type=tbljnsagunan.jns_idno', 'inner');
        $builder->join('tblanggota', 'trxkontrak.agt_numb=tblanggota.agt_numb', 'inner');
        $builder->where('trxpenagunan.knt_code', $id);
        $builder->orderBy('trxpenagunan.knt_code', 'asc');
        return $builder->get();
    }

    public function _get_ssbjatuhtempo($tanggal1, $tanggal2)
    {
        $builder = $this->db->table('trxpenempatan');
        $builder->select('*');
        $builder->join('tblanggota', 'trxpenempatan.agt_numb=tblanggota.agt_numb', 'inner');
        $builder->join('tblproduct', 'trxpenempatan.prd_code=tblproduct.prd_code', 'left');
        $builder->join('tblcompany', 'trxpenempatan.com_code=tblcompany.com_code', 'left');
        $builder->where('trxpenempatan.pen_jtdt>=', $tanggal1);
        $builder->where('trxpenempatan.pen_jtdt<=', $tanggal2);
        // $builder->where('trxpenempatan.pen_stat', 1);
        $builder->orderBy('trxpenempatan.pen_jtdt', 'asc');
        return $builder->get();
    }
    public function _get_ssbjatuhtempocab($tanggal1, $tanggal2, $cabang)
    {
        $builder = $this->db->table('trxpenempatan');
        $builder->select('*');
        $builder->join('tblanggota', 'trxpenempatan.agt_numb=tblanggota.agt_numb', 'inner');
        $builder->join('tblproduct', 'trxpenempatan.prd_code=tblproduct.prd_code', 'left');
        $builder->join('tblcompany', 'trxpenempatan.com_code=tblcompany.com_code', 'left');
        $builder->where('trxpenempatan.pen_jtdt>=', $tanggal1);
        $builder->where('trxpenempatan.pen_jtdt<=', $tanggal2);
        $builder->where('trxpenempatan.kode_cabang', $cabang);
        $builder->orderBy('trxpenempatan.pen_jtdt', 'asc');
        return $builder->get();
    }
    public function _get_pinjamanbaru($tanggal1, $tanggal2, $cabang)
    {
        $builder = $this->db->table('trxkontrak');
        $builder->select('*');
        $builder->join('tblanggota', 'trxkontrak.agt_numb=tblanggota.agt_numb', 'inner');
        $builder->join('tblproduct', 'trxkontrak.prd_code=tblproduct.prd_code', 'left');
        $builder->join('tblcompany', 'trxkontrak.com_code=tblcompany.com_code', 'left');
        $builder->where('trxkontrak.knt_date>=', $tanggal1);
        $builder->where('trxkontrak.knt_date<=', $tanggal2);
        $builder->where('trxkontrak.kode_cabang', $cabang);
        $builder->orderBy('trxkontrak.knt_date', 'asc');
        return $builder->get();
    }
    public function _get_pinjamanbarua($tanggal1, $tanggal2)
    {
        $builder = $this->db->table('trxkontrak');
        $builder->select('*');
        $builder->join('tblanggota', 'trxkontrak.agt_numb=tblanggota.agt_numb', 'inner');
        $builder->join('tblproduct', 'trxkontrak.prd_code=tblproduct.prd_code', 'left');
        $builder->join('tblcompany', 'trxkontrak.com_code=tblcompany.com_code', 'left');
        $builder->where('trxkontrak.knt_date>=', $tanggal1);
        $builder->where('trxkontrak.knt_date<=', $tanggal2);

        $builder->orderBy('trxkontrak.knt_date', 'asc');
        return $builder->get();
    }

    public function _get_dttabungan()
    {
        $builder = $this->db->table('trxtabungan');
        $builder->select('*');
        $builder->join('tblcompany', 'trxtabungan.com_code=tblcompany.com_code', 'left');
        $builder->join('tblanggota', 'trxtabungan.agt_numb=tblanggota.agt_numb', 'left');
        $builder->join('tblproduct', 'trxtabungan.prd_code=tblproduct.prd_code', 'left');
        $builder->where('tbg_stat<', 5);


        return $builder->get();
    }

    public function _get_dttabungancab($cabang)
    {
        $builder = $this->db->table('trxtabungan');
        $builder->select('*');
        $builder->join('tblcompany', 'trxtabungan.com_code=tblcompany.com_code', 'left');
        $builder->join('tblanggota', 'trxtabungan.agt_numb=tblanggota.agt_numb', 'left');
        $builder->join('tblproduct', 'trxtabungan.prd_code=tblproduct.prd_code', 'left');
        $builder->where('tbg_stat<', 5);
        $builder->where('kode_cabang', $cabang);

        return $builder->get();
    }
}
