<?php

session_start();

$tanggal = $v_simpanan[0]->trx_date;
$bulan = date('M', strtotime($tanggal));
$tahun = date('Y', strtotime($tanggal));
$bulan = date('M');

function penyebut($nilai)
{
    $nilai = abs($nilai);
    $huruf = array("", "Satu", "Dua", "Tiga", "Empat", "Lima", "Enam", "Tujuh", "Delapan", "Sembilan", "Sepuluh", "Sebelas");
    $temp = "";
    if ($nilai < 12) {
        $temp = " " . $huruf[$nilai];
    } else if ($nilai < 20) {
        $temp = penyebut($nilai - 10) . " Belas";
    } else if ($nilai < 100) {
        $temp = penyebut($nilai / 10) . " Puluh" . penyebut($nilai % 10);
    } else if ($nilai < 200) {
        $temp = " Seratus" . penyebut($nilai - 100);
    } else if ($nilai < 1000) {
        $temp = penyebut($nilai / 100) . " Ratus" . penyebut($nilai % 100);
    } else if ($nilai < 2000) {
        $temp = " Seribu" . penyebut($nilai - 1000);
    } else if ($nilai < 1000000) {
        $temp = penyebut($nilai / 1000) . " Ribu" . penyebut($nilai % 1000);
    } else if ($nilai < 1000000000) {
        $temp = penyebut($nilai / 1000000) . " Juta" . penyebut($nilai % 1000000);
    } else if ($nilai < 1000000000000) {
        $temp = penyebut($nilai / 1000000000) . " Miliar" . penyebut(fmod($nilai, 1000000000));
    } else if ($nilai < 1000000000000000) {
        $temp = penyebut($nilai / 1000000000000) . " Triliun" . penyebut(fmod($nilai, 1000000000000));
    }
    return $temp;
}

function terbilang($nilai)
{
    if ($nilai < 0) {
        $hasil = "Minus " . trim(penyebut($nilai));
    } else {
        $hasil = trim(penyebut($nilai)) . " Rupiah";
    }
    return $hasil;
}
?>
<!-- <!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml"> -->

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />
    <link rel="icon" href="../assets/images/print.png" type="../assets/images/png">
    <title>Laporan Posisi Kas</title>
</head>
<style type="text/css">
    /* Kode CSS Untuk PAGE ini dibuat oleh http://jsfiddle.net/2wk6Q/1/ */
    body {
        width: 100%;
        height: 100%;
        margin: 0;
        padding: 0;
        background-color: #ffffff;
        font: 12pt "Tahoma";
    }

    * {
        box-sizing: border-box;
        -moz-box-sizing: border-box;
    }

    hr {
        height: 3px;
        background-color: black;
        color: black;
    }

    .page {
        width: 210mm;
        min-height: 297mm;
        padding: 10mm;
        margin: 10mm auto;
        border: 1px #D3D3D3 solid;
        border-radius: 5px;
        background: white;
    }

    .subpage {
        padding: 0;
        border: none;
        height: 277mm;
    }

    table {
        border-collapse: collapse;
    }

    table,
    th,
    td {
        border: 1px black solid;
    }

    th,
    td {
        padding: 6px;
    }

    strong {
        font-size: 10pt;
    }

    @page {
        size: A4;
        margin: 10;

    }

    @media print {

        html,
        body {
            width: 210mm;
            height: 297mm;
        }

        hr {
            height: 3px;
            background-color: black;
            color: black;
        }

        .page {
            margin: 0;
            border: initial;
            border-radius: initial;
            width: initial;
            min-height: initial;
            box-shadow: initial;
            background: initial;
            page-break-after: always;
        }
    }
</style>

<body>
    <div class="book">
        <div class="page">
            <div class="subpage">
                <div style="display: flex;">
                    <div style="display: flex; flex: 60%;">

                        <img src="<?php echo base_url('assets/images/' . $_SESSION['com_logo']) ?>" style="width: 90px; height: 75px; padding: 6px;">
                        <div style="margin-top: -10px; padding: 0 10px;">
                            <h4><?php echo $v_report[0]->com_name ?> </h4>
                            <p style="margin-top: -20px;"><?php echo $v_report[0]->com_tags ?> </p>

                            <p style="margin-top: -15px; font-size: 8pt;"><?php echo $v_report[0]->com_adrs ?> </p>
                        </div>
                    </div>
                    <div style="flex: 30%; margin-top: -10px;">
                        <p style="font-size: 7pt;">
                            <!-- JL. KALASAN II No. 9<br>
                            KOMPLEK NEW PHARMINDO<br>
                            BANDUNG 40534<br> -->

                        </p>
                    </div>
                </div>
                <p style="font-size: 12pt;text-align: center;">LAPORAN POSISI KAS </p>
                <p style="font-size: 12pt;text-align: center;">DARI TANGGAL : <?php echo date('d-m-Y', strtotime($tgl1)) ?> S/D : <?php echo date('d-m-Y', strtotime($tgl2)) ?> </p>

                <div style="margin-top: -10px;">
                    <hr>
                    <hr style="margin-top: -7px;">
                </div>

                <p style="font-size: 7pt;">
                <div style="display: flex; width: 100%;">

                </div>
                <div style="margin-top: 10px;">
                    <table class="table-ivc" id="IvcTable" style="width: 100%;">
                        <thead style="font-size: 8pt;">
                            <tr>

                                <?php $i = 0;
                                foreach ($v_sawal as $row1) : $i = $i + 1;
                                    $saldo = $row1->acc_akhc;
                                endforeach; ?>
                                <td colspan="8" style="text-align: right;">
                                    <strong>SALDO AWAL</strong>
                                </td>

                                <td style="text-align:right ;"><?= number_format($saldo); ?></td>


                            </tr>
                            <tr>

                                <th width="1%" style="text-align:center ;">No. </th>
                                <th width="10%" style="text-align:center ;">Tanggal </th>
                                <td width="10%" style="text-align:center ;">Kwitansi</td>
                                <td width="20%" style="text-align:center ;">Keterangan</td>
                                <td width="10%" style="text-align:center ;">OBC Debet</td>
                                <td width="10%" style="text-align:center ;">OBC Kredit</td>
                                <td width="10%" style="text-align:center ;">Terima</td>
                                <td width="10%" style="text-align:center ;">Keluar</td>
                                <td width="10%" style="text-align:center ;">Saldo</td>

                        <tbody id="tbody1" style="font-size: 8pt;">
                            <?php $i = 0;
                            ?>

                            <?php foreach ($v_report as $row) : $i = $i + 1;

                                if (isset($row->kot_type) <= '2') {
                                    $debet = $row->kot_stot;
                                    $credit = 0;
                                    $saldo = $saldo + $debet;
                                } else {
                                    $credit =  $row->kot_stot;
                                    $debet = 0;
                                    $saldo = $saldo - $credit;
                                }
                                $obcdebet = 0;
                                $obccredit = 0;
                            ?>


                                <tr>
                                    <td><?= $i; ?></td>
                                    <td><?= $row->kot_date; ?></td>
                                    <td><?= $row->ref_code; ?></td>

                                    <td><?= $row->prd_desc; ?></td>
                                    <td style="text-align:right ;"><?= number_format($obcdebet); ?></td>
                                    <td style="text-align:right ;"><?= number_format($obccredit); ?></td>
                                    <td style="text-align:right ;"><?= number_format($debet) ?></td>
                                    <td style="text-align:right ;"><?= number_format($credit) ?></td>
                                    <td style="text-align:right ;"><?= number_format($saldo) ?></td>

                                </tr>






                            <?php endforeach; ?>
                            <tr>

                                <td colspan="8" style="text-align: right;">
                                    <strong>SALDO AKHIR</strong>
                                </td>

                                <td style="text-align:right ;"><?= number_format($saldo); ?></td>


                            </tr>



                        </tbody>
                    </table>
                </div>

            </div>

            <!-- <div class="page">
                <div class="subpage"></div>
            </div> -->

        </div>
</body>

</html>
<script type="text/javascript">
    window.print();
</script>