<?php
// echo view('menu/header');
// echo view('menu/header');
// echo view('menu/slider');

?>

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Product Lists</title>

    <!-- Bootstrap 3.3.6 -->
    <link rel="stylesheet" href="<?php echo base_url('assets/bootstrap/css/bootstrap.min.css') ?>" />
    <!-- Font Awesome -->
    <!-- <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.5.0/css/font-awesome.min.css"> -->
    <!-- Ionicons -->
    <!-- <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/ionicons/2.0.1/css/ionicons.min.css"> -->
    <!-- daterange picker -->
    <!-- <link rel="stylesheet" href="<?php echo base_url('assets/plugins/daterangepicker/daterangepicker.css') ?>"> -->
    <!-- bootstrap datepicker -->
    <!-- <link rel="stylesheet" href="<?php echo base_url('assets/plugins/datepicker/datepicker3.css') ?>"> -->

    <!-- iCheck for checkboxes and radio inputs -->
    <!-- <link rel="stylesheet" href="<?php echo base_url('assets/plugins/iCheck/all.css') ?>"> -->
    <!-- Bootstrap Color Picker -->
    <!-- <link rel="stylesheet" href="<?php echo base_url('assets/plugins/colorpicker/bootstrap-colorpicker.min.css') ?>"> -->
    <!-- Bootstrap time Picker -->
    <!-- <link rel="stylesheet" href="<?php echo base_url('assets/plugins/timepicker/bootstrap-timepicker.min.css') ?>"> -->
    <!-- Select2 -->
    <!-- <link rel="stylesheet" href="<?php echo base_url('assets/plugins/select2/select2.min.css') ?>"> -->
    <!-- DataTables -->
    <!-- <link rel="stylesheet" href="<?php echo base_url('assets/plugins/datatables/dataTables.bootstrap.css') ?>" /> -->
    <!-- Theme style -->
    <!-- <link rel="stylesheet" href="<?php echo base_url('assets/dist/css/AdminLTE.min.css') ?>" /> -->
    <!-- AdminLTE Skins. Choose a skin from the css/skins
       folder instead of downloading all of them to reduce the load. -->
    <!-- <link rel="stylesheet" href="<?php echo base_url('assets/dist/css/skins/_all-skins.min.css') ?>" /> -->
    <!-- <link rel="stylesheet" href="<?php echo base_url('assets/css/bootstrap.min.css') ?>"> -->
</head>

<body>
    <div class="container">
        <h3>Product Lists</h3>
        <button type="button" class="btn btn-success mb-2" data-toggle="modal" data-target="#addModal">Add New</button>

        <table class="table table-striped">
            <thead>
                <tr>
                    <th>Product Name</th>
                    <th>Price</th>
                    <th>Category</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($product as $row) : ?>
                    <tr>
                        <td><?= $row->prd_name; ?></td>
                        <td><?= $row->product_price; ?></td>
                        <td><?= $row->typ_name; ?></td>
                        <td>
                            <a href="#" class="btn btn-info btn-sm btn-edit" data-id="<?= $row->product_id; ?>" data-name="<?= $row->product_name; ?>" data-price="<?= $row->product_price; ?>" data-category_id="<?= $row->product_category_id; ?>">Edit</a>
                            <a href="#" class="btn btn-danger btn-sm btn-delete" data-id="<?= $row->product_id; ?>">Delete</a>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>

    </div>

    <!-- Modal Add Product-->
    <form action="/product/save" method="post">
        <div class="modal fade" id="addModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLabel">Add New Product</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">

                        <div class="form-group">
                            <label>Product Name</label>
                            <input type="text" class="form-control" name="product_name" placeholder="Product Name">
                        </div>

                        <div class="form-group">
                            <label>Price</label>
                            <input type="text" class="form-control" name="product_price" placeholder="Product Price">
                        </div>

                        <div class="form-group">
                            <label>Category</label>
                            <select name="product_category" class="form-control">
                                <option value="">-Select-</option>
                                <?php foreach ($category as $row) : ?>
                                    <option value="<?= $row->typ_code; ?>"><?= $row->typ_name; ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>

                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary">Save</button>
                    </div>
                </div>
            </div>
        </div>
    </form>
    <!-- End Modal Add Product-->

    <!-- Modal Edit Product-->
    <form action="/product/update" method="post">
        <div class="modal fade" id="editModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLabel">Edit Product</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">

                        <div class="form-group">
                            <label>Product Name</label>
                            <input type="text" class="form-control product_name" name="product_name" placeholder="Product Name">
                        </div>

                        <div class="form-group">
                            <label>Price</label>
                            <input type="text" class="form-control product_price" name="product_price" placeholder="Product Price">
                        </div>

                        <div class="form-group">
                            <label>Category</label>
                            <select name="product_category" class="form-control product_category">
                                <option value="">-Select-</option>
                                <?php foreach ($category as $row) : ?>
                                    <option value="<?= $row->category_id; ?>"><?= $row->category_name; ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>

                    </div>
                    <div class="modal-footer">
                        <input type="hidden" name="product_id" class="product_id">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary">Update</button>
                    </div>
                </div>
            </div>
        </div>
    </form>
    <!-- End Modal Edit Product-->

    <!-- Modal Delete Product-->
    <form action="/product/delete" method="post">
        <div class="modal fade" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLabel">Delete Product</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">

                        <h4>Are you sure want to delete this product?</h4>

                    </div>
                    <div class="modal-footer">
                        <input type="hidden" name="product_id" class="productID">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">No</button>
                        <button type="submit" class="btn btn-primary">Yes</button>
                    </div>
                </div>
            </div>
        </div>
    </form>
    <!-- End Modal Delete Product-->

    <!-- <script src="/js/jquery.min.js"></script>
    <script src="/js/bootstrap.bundle.min.js"></script> -->
    <script src="<?php echo base_url('assets/plugins/jquery/jquery.min.js') ?>"></script>

    <!-- Bootstrap 3.3.6 -->
    <script src="<?php echo base_url('assets/bootstrap/js/bootstrap.bundle.min.js') ?>"></script>
    <script src="<?php echo base_url('assets/bootstrap/js/bootstrap.min.js') ?>"></script>
    <script>
        $(document).ready(function() {

            // get Edit Product
            $('.btn-edit').on('click', function() {
                // get data from button edit
                const id = $(this).data('id');
                const name = $(this).data('name');
                const price = $(this).data('price');
                const category = $(this).data('category_id');
                // Set data to Form Edit
                $('.product_id').val(id);
                $('.product_name').val(name);
                $('.product_price').val(price);
                $('.product_category').val(category).trigger('change');
                // Call Modal Edit
                $('#editModal').modal('show');
            });

            // get Delete Product
            $('.btn-delete').on('click', function() {
                // get data from button edit
                const id = $(this).data('id');
                // Set data to Form Edit
                $('.productID').val(id);
                // Call Modal Edit
                $('#deleteModal').modal('show');
            });

        });
    </script>
</body>

</html>