<?php

namespace App\Controllers;

use CodeIgniter\API\ResponseTrait;
use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;
use Psr\Log\LoggerInterface;
use App\Models\AppToken;
use App\Models\ApiModel;
use App\Models\Core_model;
use App\Models\Auto_model;

use App\Models\Model_git;
use App\Models\Save_model;
use Exception;
use Faker\Provider\Uuid;
use stdClass;

class Api extends BaseController
{
  /**
   * Return an array of resource objects, themselves in array format
   *
   * @return mixed
   */
public function __construct()
  {
    $session = session();
    date_default_timezone_set('Asia/Jakarta');
  }
  public $request;
  protected $response;
  protected $logger;
  
  protected $integration, $api;

  private $token = null;
  private $tokenValid = false;

  use ResponseTrait;

  /**
   * Initializer 
   */
  public function initController(RequestInterface $request, ResponseInterface $response, LoggerInterface $logger)
  {
    parent::initController($request, $response, $logger);

    // Load the model
    $this->integration      = new AppToken();
    $this->api      = new ApiModel();

    // Check token
    $tokenHeader = $this->request->header('token');
    $this->tokenValid = $this->checkToken($tokenHeader);
  }

  private function checkToken($tokenHeader)
  {
    if (empty($tokenHeader)) {
      return false;
    }

    $this->token = $tokenHeader->getValue();

    $check_token = $this->integration->do_check_token($this->token);
    return $check_token;
  }
  
  public function auth()
  {
	  $model = new Core_model();
	  $post_data = json_decode(file_get_contents('php://input'), true);
	  $partner_id = trim($post_data['user']);
	  $password = trim($post_data['password']);
	  //$id_col = $this->request->getPost('id_col');
	  //$phone = $this->request->getPost('phone');
	  $cond = array('partner_id'=>$partner_id,'password'=>$password);
	  //print_r($cond);
	  $data = $this->api->get_partner($cond)->getResult();
	  //$model_emp = new Save_model();
	  if ($data) {
		    $str_token = $partner_id.time();
		    //return $this->respond($str_token, 200);
			$hash_token = password_hash($str_token, PASSWORD_DEFAULT);
			$data_token = array('ait_id'=>null,'consumer'=>'mobile','token'=>$hash_token,'is_deleted'=>0);
			//print_r($data_token);
			$this->integration->do_add($data_token);
			//print_r($res);
			$resp_data = array('user'=>$partner_id,'token'=>$hash_token);
			$res['status'] = 'success';
			$res['data'] = $resp_data;
			return $this->respond($res, 200);
	   } else {
			$res['status'] = 'error';
			$res['user'] = $partner_id;
			$res['message'] = 'Authentication failed';
			return $this->respond($res, 401);
	   }
  }
  
  public function auth2()
  {
	  $model = new Core_model();
	  $post_data = json_decode(file_get_contents('php://input'), true);
	  $partner_id = trim($post_data['user']);
	  $password = trim($post_data['password']);
	  //$id_col = $this->request->getPost('id_col');
	  //$phone = $this->request->getPost('phone');
	  $cond = array('partner_id'=>$partner_id,'password'=>$password);
	  //print_r($cond);
	  $data = $this->api->get_partner($cond)->getResult();
	  //print_r($data);
	  //$model_emp = new Save_model();
	  if ($data) {
		    $str_token = $partner_id.time();
		    //return $this->respond($str_token, 200);
			$hash_token = password_hash($str_token, PASSWORD_DEFAULT);
			$data_token = array('ait_id'=>null,'consumer'=>'mobile','token'=>$hash_token,'is_deleted'=>0);
			//print_r($data_token);
			$this->integration->do_add($data_token);
			//print_r($res);
			$resp_data = array('user'=>$partner_id,'token'=>$hash_token);
			$res['status'] = 'success';
			$res['data'] = $resp_data;
			return $this->respond($res, 200);
            //return $this->respond($data);
	   } else {
			$res['status'] = 'error';
			$res['user'] = $partner_id;
			$res['message'] = 'Authentication failed';
			return $this->respond($res, 401);
	   }
  }
  
  public function petugas($id = null)
    {
        $model = new Core_model();
		   if (!$this->tokenValid) {
		  return $this->respond('Invalid Token', 401);
		}

		
        $cond = array('emp_code'=>$id);
        $data = $model->_get_petugas($cond)->getResult();
        
        if ($data) {
			$res['status'] = 'success';
			$res['data'] = $data;
			return $this->respond($res, 200);
            //return $this->respond($data);
        } else {
			$res['status'] = 'error';
			$res['message'] = 'No data found';
			return $this->respond($res, 404);
        }
    }

  function getPinjaman($agt_num)
  {
    if (!$this->tokenValid) {
      return $this->respond('Invalid Token', 401);
    }

    $res['status'] = 'failed';
    $res['data'] = [];

    $data  = $this->api->get_product_anggota($agt_num);
    if($data) {
      $i = 0;
      foreach ($data as $element) {
        $data[$i]->detail_tagihan = $this->api->get_tagihan_anggota($element->norek);
        $i++;
      }

      $res['status'] = 'success';
      $res['data'] = $data;
    } else {
      $res['message'] = 'No data found';
    }

    return $this->respond($res, 200);
  }
  
  public function index()
    {
        $model = new Core_model();
        $data['anggota'] = $model->orderBy('agt_numb', 'DESC')->findAll();
        return $this->respond($data);
    }
    // create
    // single user


    public function anggota($id = null)
    {
        $model = new Core_model();
        if (!$this->tokenValid) {
		  return $this->respond('Invalid Token', 401);
		}

		$res['status'] = 'failed';
		$res['data'] = [];
        $data = $model->_get_anggota($id)->getResult();
        // $data = $model->where('agt_numb', $id)->first();
        if ($data) {
			$res['status'] = 'success';
			$res['data'] = $data;
            //return $this->respond($data);
			return $this->respond($res, 200);
        } else {
			$res['status'] = 'error';
			$res['message'] = 'No data found';
			return $this->respond($res, 404);
            //return $this->failNotFound('Data tidak ditemukan.');
        }
		
    }

    public function simpanan($id = null)
    {
		$model = new Core_model();
        if (!$this->tokenValid) {
		  return $this->respond('Invalid Token', 401);
		}

		$res['status'] = 'failed';
		$res['data'] = [];
        $model = new Core_model();
        $data = $model->_get_tabungan($id)->getResult();
        // $data1 = $model->where('agt_numb', $id)->first();
        if ($data) {
            $res['status'] = 'success';
			$res['data'] = $data;
            //return $this->respond($data);
			return $this->respond($res, 200);
        } else {
            $res['status'] = 'error';
			$res['message'] = 'No data found';
			return $this->respond($res, 404);
        }
    }

    public function ceksimpanan($id = null)
    {
		if (!$this->tokenValid) {
		  return $this->respond('Invalid Token', 401);
		}

		$res['status'] = 'failed';
		$res['data'] = [];
        $model = new Core_model();
        $data = $model->_get_tabunganrek($id)->getResult();
        // $data = $model->where('agt_numb', $id)->first();
        if ($data) {
            $res['status'] = 'success';
			$res['data'] = $data;
            //return $this->respond($data);
			return $this->respond($res, 200);
        } else {
            $res['status'] = 'error';
			$res['message'] = 'No data found';
			return $this->respond($res, 404);
        }
    }

    function Pinjaman($id = null)
    {
		if (!$this->tokenValid) {
		  return $this->respond('Invalid Token', 401);
		}

		$res['status'] = 'failed';
		$res['data'] = [];
        $this->model      = new Core_model();
        // if (!$this->tokenValid) {
        //   return $this->respond('Invalid Token', 401);
        // }

        // $res['status'] = 'failed';
        // $res['data'] = [];

        $data  = $this->model->_get_pinjaman($id);
        if ($data) {
            $i = 0;
            foreach ($data as $element) {
                $data[$i]->detail_tagihan = $this->model->_get_pinjamandtl($element->norek);
                $i++;
            }

            $res['status'] = 'success';
			$res['data'] = $data;
            //return $this->respond($data);
			return $this->respond($res, 200);
        } else {
            $res['status'] = 'error';
			$res['message'] = 'No data found';
			return $this->respond($res, 404);
        }

        //return $this->respond($res, 200);
    }

    public function cekpinjaman($id = null)
    {
		if (!$this->tokenValid) {
		  return $this->respond('Invalid Token', 401);
		}

		$res['status'] = 'failed';
		$res['data'] = [];
        $this->model      = new Core_model();
        // if (!$this->tokenValid) {
        //   return $this->respond('Invalid Token', 401);
        // }

        // $res['status'] = 'failed';
        // $res['data'] = [];
        $data  = $this->model->_get_pinjamanrek($id);
        if ($data) {
            $i = 0;
            foreach ($data as $element) {
                $data[$i]->detail_tagihan = $this->model->_get_pinjamandtl($element->norek);
                $i++;
            }

            $res['status'] = 'success';
			$res['data'] = $data;
            //return $this->respond($data);
			return $this->respond($res, 200);
        } else {
            $res['status'] = 'error';
			$res['message'] = 'No data found';
			return $this->respond($res, 404);
        }

        //return $this->respond($res, 200);
    }

    public function mutasisimpanan($id = null)
    {
		if (!$this->tokenValid) {
		  return $this->respond('Invalid Token', 401);
		}

		$res['status'] = 'failed';
		$res['data'] = [];
        $model = new Core_model();
        $data = $model->_get_mutasisimpanan($id)->getResult();
        // $data = $model->_get_pinjamandtl()->getResult();
        // $data = $model->where('agt_numb', $id)->first();
        if ($data) {
            $res['status'] = 'success';
			$res['data'] = $data;
            //return $this->respond($data);
			return $this->respond($res, 200);
        } else {
            $res['status'] = 'error';
			$res['message'] = 'No data found';
			return $this->respond($res, 404);
        }
    }

    // update

	public function setorsimpanan() {
		//echo "test";
		$res = $this->_setortariksimpanan();
		//print_r($res);
		//die('');
		if($res['status']=='error'){
			return $this->respond($res, 404);
		}
		else if($res['status']=='Berhasil'){
			return $this->respond($res, 200);
		}
	}
	
	public function tariksimpanan() {
		$res = $this->_setortariksimpanan('02');
		if($res['status']=='error'){
			return $this->respond($res, 404);
		}
		else if($res['status']=='Berhasil'){
			return $this->respond($res, 200);
		}
	}

    private function _setortariksimpanan($jenis='01')
    {
		//if (!$this->tokenValid) {
		//  return $this->respond('Invalid Token', 401);
		//}

		$res['status'] = 'failed';
		$res['data'] = [];
		//print_r(stripslashes(file_get_contents('php://input')));
		$post_data = json_decode(stripslashes(file_get_contents('php://input')), true);
		
		//$partner_id = trim($post_data['user']);
		//$password = trim($post_data['password']);
        $model = new Save_model();
        $mgit = new Model_git();
        $modecek = new Auto_model();
        $mcore = new Core_model();
        $note = "";
        $tanggal = $post_data['tgl'];//$this->request->getPost('tgl');
		$petugas = $post_data['collector_id'];
		//$dbemployee = $modecek->get_employee($empcode);
		$cond = array('emp_code'=>$petugas);
		$dbemployee = $mcore->_get_petugas($cond)->getRow();
		//print_r($dbemployee);
        $emp_name = $dbemployee->nama_petugas;
        $bnk_code = $dbemployee->kode_kas;
        $kodecabang = $dbemployee->unit_kerja;
        if ($bnk_code == '') {
            $res['message'] = 'Petugas tidak terdaftar';
			$res['status'] = 'error';
            return $res;
        }
        $dbbank = $modecek->get_bank($bnk_code);
        $acc_cash = $dbbank['acc_code'];
		//echo $petugas_id;
        $bulan = date('m', strtotime($tanggal));
        $tahun = date('Y', strtotime($tanggal));
        $waktu = date('Y-m-d H:i:s');

        $cek = $modecek->get_nosetortabungan($bulan, $tahun);
        $jns = $jenis;
        $description = $post_data['keterangan'];//$this->request->getPost('keterangan');

        $nourut = $cek['kin_srno'];
        $rekening = $post_data['norek'];//$this->request->getPost('norek');
        $sldawal = $mcore->saldotabungan($rekening);
        $kin_awal = 0;
        foreach ($sldawal->getResult() as $awal) {
            $kin_awal = $awal->kin_awal;
        }
        $cek1 = $mgit->_get_datatabunganab($rekening);
        $agt_numb = '';
        $agt_name = '';
        $prd_code = '';
        $acc_prod = '';
        $acc_admn = '';
       // $kodecabang = '';
        foreach ($cek1->getResult() as $cekrow) {
            $agt_numb = $cekrow->agt_numb;
            $agt_name = $cekrow->agt_name;
            $prd_code = $cekrow->prd_code;
            $prd_name = $cekrow->prd_name;
            $acc_prod = $cekrow->acc_code;
            $acc_admn = $cekrow->acc_cod2;
          //  $kodecabang = $cekrow->kode_cabang;
        }
        // $rekening = $cek1['tbg_code'];

        $xprod1 = $prd_code;
        $xprod = substr($xprod1, 0, 1);
       // $bnk_code = '90';
       
        // $kodecabang = session()->get('kode_cabang');
        // if ($description == '') {
        if ($jns == '01') {

            // $description = 'Setoran ' . $prd_name . ' - ' . $agt_name;
            $description1 = 'Setoran ' . $prd_name;
            // } else if ($jns == '02') {
            //     $description = 'Penarikan Tunai ' . $prd_name . ' - ' . $agt_name;
            //     $description1 = 'Penarikan Tunai ' . $prd_name;
            // } else if ($jns == '03') {
            //     $description = 'Penutupan Rekening : ' . $prd_name . ' - ' . $agt_name;
            //     $description1 = 'Penutupan Rekening : ' . $prd_name;
            // } else {
            //     $description = $prd_name . ' - ' . $agt_name;
            //     $description1 = $prd_name;
        }

        // }
        if ($nourut == '') {
            $nourut = 1;
            $v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . '00001';
        } else {
            $nourut = $nourut + 1;
            if ($nourut < 10) {
                $v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . '0000' . $nourut;
            } else if ($nourut >= 10 and $nourut < 100) {
                $v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . '000' . $nourut;
            } else if ($nourut >= 100 and $nourut < 1000) {
                $v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . '00' . $nourut;
            } else if ($nourut >= 1000 and $nourut < 10000) {
                $v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . '0' . $nourut;
            } else {
                $v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . $nourut;
            }
        }


        $kin_stot = str_replace(',', '', $post_data['jumlah']);
        $kin_totl = str_replace(',', '', $post_data['jumlah']);
        // $kin_awal = 0;
        $v_dbt_amnt = 0;
        $v_crd_amnt = 0;
		//echo $kin_stot;
        $cektanggal = $modecek->_get_tgltabungan1($rekening, $tanggal);
		//echo $cektanggal;
		//echo $kin_stot;
        $kin_code = $cektanggal['kin_code'];
        $kin_dat1 = $cektanggal['kin_dat1'];
        $kin_dat2 = $cektanggal['kin_date'];


        // if ($kin_code == '') {
        //   $kin_gtot = $kin_totl;
        //   $jmlhari = 0;
        // } else {
        //   $kin_gtot = $cektanggal['kin_gtot'];
        //   $kin_gtot = $kin_gtot + $kin_totl;
        //   $jmlhari = (($tanggal - $kin_dat1) / 60 / 60 / 24) + 1;
        // }
        if ($jns == '01') {
            $debcrt = 'K';
            $v_crd_amnt = $kin_totl;
            $v_dbt_amnt = 0;
        } else {
            $debcrt = 'D';
            $v_dbt_amnt = $kin_totl;
            $v_crd_amnt = 0;
        }

        if ($kin_code == '') {
            $kin_gtot = $kin_totl;
            // $kin_awal = 0;
            $kin_dat1 = $cektanggal['kin_date'];
            $jmlhari = (($tanggal - $kin_dat1) / 60 / 60 / 24);
        } else {
            $kin_dat1 = $cektanggal['kin_date'];
            // $kin_awal = $cektanggal['kin_akhr'];
            $kin_gtot = $kin_awal + $v_crd_amnt - $v_dbt_amnt;
            // $kin_dat1 = date('Y-m-d', strtotime($kin_dat1));
            $tanggl2 = strtotime($tanggal);
            $tanggl1 = strtotime($kin_dat1);
            $jmlhari = (($tanggl2 - $tanggl1) / 60 / 60 / 24);
        }
        $kin_akhr = $kin_awal - $v_dbt_amnt + $v_crd_amnt;
        $data = array(
            'kin_code' => $v_trx_code,
            //$this->request->getPost('norek'),
            'kin_date' => $post_data['tgl'],
            'agt_numb' => $agt_numb,
            'bnk_code' => $bnk_code,
            'acc_cash' => $acc_cash,
            'kin_type' => $prd_code,
            'kin_desc' => $description,
            'kin_note' => $note,
            'kin_stot' => $kin_stot,

            'acc_admn' => $acc_admn,
            'acc_prod' => $acc_prod,
            'tbg_code' => $rekening,
            'kin_mont' => $bulan,
            'kin_year' => $tahun,
            'kin_totl' => $kin_totl,
            'kin_srno' => $nourut,
            'kin_jens' => '02',
            'kin_nstr' => 0,
            'kin_astr' => 0,
            'kin_prem' => 0,
            'kin_pajk' => 0,
            'kin_marg' => 0,
            'acc_prem' => '',
            'acc_pajk' => '',
            'acc_marg' => '',
            'kin_mstr' => 0,
            'kin_debt' => $v_dbt_amnt,
            'kin_crdt' => $v_crd_amnt,
            'kin_dbcr' => $debcrt,
            'kin_stat' => 0,
            'com_code' => 1,

            'trx_jens' => '05',
            'kode_cabang' => $kodecabang,
            'kin_gtot' => $kin_gtot,
            'kin_awal' => $kin_awal,
            'kin_akhr' => $kin_akhr,
            'kin_time' => $waktu,
            'kin_user' => $emp_name,

        );
		
        $model->_savesetortabungan($data);
        if ($jns == '2000') {
            $data = array(
                'kin_code' => $v_trx_code,
                //$this->request->getPost('norek'),
                'kin_date' => $post_data['tgl'],
                'agt_numb' => $agt_numb,
                'bnk_code' => $bnk_code,
                'acc_cash' => $acc_cash,
                'knt_code' => $post_data['norek'],
                'kin_type' => $prd_code,
                'kin_desc' => $description,
                'kin_note' => $note,
                'kin_stot' => $kin_stot,
                'kin_admn' => 0,
                'acc_admn' => $acc_admn,
                'acc_prod' => $acc_prod,
                'kin_dend' => 0,
                'kin_angs' => 0,
                'kin_bung' => 0,
                'kin_pokk' => 0,
                'kin_mont' => $bulan,
                'kin_year' => $tahun,
                'kin_totl' => $kin_totl,
                'kin_stat' => 0,
                'kin_jens' => '03',
                'com_code' => 1,
                'kode_cabang' => $kodecabang,
            );

            $model->_savesetorpembiayaan($data);
        }


        $data = array(
            'kin_dat1' => $post_data['tgl'],
            'kin_hari' => $jmlhari,
            // 'kin_apus' => $kin_dat1,
        );

        $model->_updatetabungantgl($data, $kin_code);

        // $tgltabungan = $modelgit->_get_tgltabungan($this->request->getPost('tbg_code'), $this->request->getPost('tgl'), $bulan, $tahun);
        // foreach ($tgltabungan->getResult()  as $rowtrans) {

        //   $data = array(
        //     'kin_dat1' => $this->request->getPost('tgl'),
        //     'kin_apus' => 1,
        //   );
        //   $idtrans = $rowtrans->kin_code;
        //   $model->_updatetabungantgl($data,  $idtrans);
        //   // var_dump($data);
        // }
        // Jurnal
        if ($jns == '01') {
            $v_trx_dbcr = 'D';
            $v_trx_debt = $kin_totl;
            $v_trx_crdt = 0;
        } else {
            $v_trx_dbcr = 'K';
            $v_trx_debt = 0;
            $v_trx_crdt = $kin_totl;
        }
        if ($jns == '01') {
            if ($xprod == '3') {
                $cabang = $kodecabang;
                if ($cabang != '100') {
                    $cabcod12 = '100';
                } else {
                    $cabcod12 = $kodecabang;
                }
            } else {
                $cabcod12 = $kodecabang;
            }
        } else {
            $cabcod12 = $kodecabang;
        }
        $data = array(
            'trx_code' => $v_trx_code,
            //$this->request->getPost('norek'),
            'trx_date' => $post_data['tgl'],
            'acc_code' => $acc_cash,
            'trx_jens' => '01',
            'psb_code' => $prd_code,
            'trx_urut' => 1,
            'trx_dbcr' => $v_trx_dbcr,
            'trx_amnt' => $kin_totl,
            'dbt_amnt' => $v_trx_debt,
            'crd_amnt' => $v_trx_crdt,
            'trx_des1' => $description,
            'trx_des2' => $description1,
            'com_code' =>   1,
            'kode_cabang' => $kodecabang,
            'ent_time' => $waktu,
            'usercreated' => $emp_name,
        );
        $model->_savejurnal($data);


        // Jurnal

        if ($jns == '01') {
            $v_trx_dbcr = 'K';
            $v_trx_debt = 0;
            $v_trx_crdt = $kin_stot;
        } else {
            $v_trx_dbcr = 'D';
            $v_trx_debt = $kin_stot;
            $v_trx_crdt = 0;
        }

        $data = array(
            'trx_code' => $v_trx_code,
            //$this->request->getPost('norek'),
            'trx_date' => $post_data['tgl'],
            'acc_code' => $acc_prod,
            'trx_jens' => '01',
            'trx_urut' => 1,
            'trx_dbcr' => $v_trx_dbcr,
            'trx_amnt' => $kin_stot,
            'dbt_amnt' => $v_trx_debt,
            'crd_amnt' => $v_trx_crdt,
            'trx_des1' => $description,
            'trx_des2' => $description1,
            'com_code' => 1,
            'kode_cabang' => $cabcod12,
            'ent_time' => $waktu,
            'usercreated' => $emp_name,
        );
        $model->_savejurnal($data);

        //admin
        // Jurnal Admin

        //Premi
        // Jurnal Premi



        // Jurnal Pajak


        // Magin

        $id = $rekening;



        if ($rekening == '') {
            if ($jns == '01') {

                $vstatus = '1';
                $data = array(

                    'tbg_stat' => $vstatus,
                    'tbg_aktv' => $post_data['tg'],
                    'tbg_awal' => $kin_stot,

                );
                $model->_updatetabungan($data, $id);
            }
        }

        if ($jns == '01') {

            if ($xprod == '3') {
                // $model->_savejurnal10($data);
                // $cabang = session()->get('kode_cabang');
                if ($kodecabang != '100') {
                    $dbakuncabang = $mgit->get_dtakuncabang('100');
                    foreach ($dbakuncabang->getResult() as $row) {
                        $acc_cab1 = $row->acc_arcd;
                    }

                    $data = array(
                        'trx_code' => $v_trx_code,
                        //$this->request->getPost('norek'),
                        'trx_date' => $post_data['tgl'],
                        'acc_code' => $acc_cab1,
                        'trx_jens' => '01',
                        'trx_urut' => 1,
                        'trx_dbcr' => 'D',
                        'trx_amnt' => $kin_totl,
                        'dbt_amnt' => $kin_totl,
                        'crd_amnt' => 0,
                        'trx_des1' => 'Piutang ' . $prd_name . ' - ' . $agt_name,
                        'trx_des2' => 'Piutang cabang :' . $prd_name,
                        'com_code' => 1,
                        'kode_cabang' => '100',
                        //()->get('kode_cabang'),
                        'ent_time' => $waktu,
                        'usercreated' => $emp_name,
                    );
                    $model->_savejurnal($data);
                    // Piutang
                    $dbakuncabang = $mgit->get_dtakuncabang($kodecabang);
                    foreach ($dbakuncabang->getResult() as $row1) {
                        $acc_cab2 = $row->acc_apcd;
                    }
                    $data = array(
                        'trx_code' => $v_trx_code,
                        //$this->request->getPost('norek'),
                        'trx_date' => $post_data['tgl'],
                        'acc_code' => $acc_cab2,
                        'trx_jens' => '01',
                        'trx_urut' => 1,
                        'trx_dbcr' => 'K',
                        'trx_amnt' => $kin_totl,
                        'dbt_amnt' => 0,
                        'crd_amnt' => $kin_totl,
                        'trx_des1' => 'Hutang ' . $prd_name . ' - ' . $agt_name,
                        'trx_des2' => 'Hutang cabang :' . $prd_name,
                        'com_code' => 1,
                        'kode_cabang' => $kodecabang,
                        'ent_time' => $waktu,
                        'usercreated' =>$emp_name,
                    );
                    $model->_savejurnal($data);
                }
            }
        }

        $data = $mcore->_get_simpanantrans($v_trx_code)->getResult();

        if ($data) {

            $res['status'] = 'Berhasil';
            $res['data'] = $data;
			//return $this->respond($response, 200);
        } else {
            $res['status'] = 'error';
			$res['message'] = 'No data found';
			//return $this->respond($res, 404);
        }

		return $res;
        //return $this->respondCreated($response);
    }

    public function angsuranpembiayaan()
    {
		if (!$this->tokenValid) {
		  return $this->respond('Invalid Token', 401);
		}
        $model = new Save_model();
        $modecek = new Auto_model();
        $mgit = new Model_git();
        $mcore = new Core_model();
        $note = "";
		$post_data = json_decode(stripslashes(file_get_contents('php://input')), true);
	
        $petugas = $post_data['collector_id'];
        $norekening = $post_data['norek'];
        $tanggal = $post_data['tgl'];
        $description = $post_data['keterangan'];
        $pokok = str_replace(',', '', $post_data['pokok']);
        $bunga = str_replace(',', '', $post_data['bunga']);
        $kin_stot =  str_replace(',', '',$post_data['total_angsuran']);
        $kin_gtot =  str_replace(',', '', $post_data['total_angsuran']);
        $angsran_ke = $post_data['angsuran_ke'];
        $bulan = date('m', strtotime($tanggal));
        $tahun = date('Y', strtotime($tanggal));
        $waktu = date('Y-m-d H:i:s');
		
		//cek angsuran apakah sudah pernah dibayar
		$cek_angsuran = $mcore->_get_angsuran_kartu($norekening,$angsran_ke);
		//print_r($cek_angsuran);
		if($cek_angsuran->lns_code != ''){
			$response['status'] = 'error';
			$response['message'] = 'Angsuran ke '.$angsran_ke.' status sudah lunas';
			return $this->respond($response, 401);
		}
		
		else{
			//get bank code
			$cond = array('emp_code'=>$petugas);
			$dbemployee = $mcore->_get_petugas($cond)->getRow();
			//print_r($dbemployee);
			//die();
			$emp_name = $dbemployee->nama_petugas;
			$bnk_code = $dbemployee->kode_kas;
			$kodecabang = $dbemployee->kode_cabang;
			
			//if ($bnk_code == '') {
			//	$response['status'] = 'error';
		       //     $response['message'] = 'Petugas tidak terdaftar';
			//		return $this->respond($response, 401);
		  //  }
			//end bank code

			$jenis = '01';
			//$bnk_code = '90';
			$dbbank = $modecek->get_bank($bnk_code);
			$acc_cash = $dbbank['acc_code'];;
			$cek = $modecek->get_nopembiayaan($bulan, $tahun);
			$nourut = $cek['kin_srno'];
			$rek_awal = $mcore->_get_pinjamanrek($norekening);
			$saldo_awal_pinjaman = $rek_awal[0]->sisa_pinjaman;

			//$acc_cash = '';
			$prd_code = '';
			$prd_name = '';
			$trx_angk = '';
			$trx_jtdt = '0000-00-00';
			$trx_pokk = '';
			$trx_bung = '';
			$trx_dend = '';
			$trx_amnh = '';
			$agt_numb = '';
			$agt_name = '';
			$prd_code = '';
			$acc_prod = '';
			$acc_bung = '';
			$acc_admn = '';
			
			$kodecabang = '';
			$dbpinjaman = $mgit->_get_dtkartuhutang($norekening);

			foreach ($dbpinjaman->getResult() as $rowtrans) {
				//$acc_cash = $rowtrans->acc_code;
				$prd_code = $rowtrans->acc_code;
				$prd_name = $rowtrans->acc_code;
				$trx_angk = $rowtrans->trx_angk;
				$trx_jtdt = $rowtrans->trx_jtdt;
				$trx_pokk = floatval($rowtrans->trx_pokk == "" ? 0 : $rowtrans->trx_pokk );
				$trx_bung = floatval($rowtrans->trx_bung == "" ? 0 : $rowtrans->trx_bung);
				$trx_dend = $rowtrans->trx_dend;
				$trx_amnh = $rowtrans->trx_saldo;
				$agt_numb = $rowtrans->agt_numb;
				$agt_name = $rowtrans->agt_name;
				$prd_code = $rowtrans->prd_code;
				$acc_prod = $rowtrans->acc_code;
				$acc_bung = $rowtrans->acc_cod1;
				$acc_admn = $rowtrans->acc_cod2;
				 $tbg_code = $rowtrans->tbg_code;
				$kodecabang = $rowtrans->kode_cabang;
				
				//$kodecabang = $rowtrans->kode_cabang;
			     
			}
			//var_dump($trx_pokk);
			//die('');
			$tot_bayr = $trx_pokk + $trx_bung;
			$selisih = 0;
        	if ($kin_gtot > $tot_bayr) {
            	$pokok = $trx_pokk;
  			    $bunga = $trx_bung;
			    $selisih = $kin_gtot - $tot_bayr;
        	}

			// $description = 'Setoran ' . $prd_name . ' - ' . $agt_name;
			// $description1 = 'Setoran ' . $prd_name;

			if ($nourut == '') {
				$nourut = 1;
				$v_trx_code = $kodecabang . '.07.' . $tahun . $bulan . '00001';
			} else {
				$nourut = $nourut + 1;
				if ($nourut < 10) {
					$v_trx_code = $kodecabang . '.07.' . $tahun . $bulan . '0000' . $nourut;
				} else if ($nourut >= 10 and $nourut < 100) {
					$v_trx_code = $kodecabang . '.07.' . $tahun . $bulan . '000' . $nourut;
				} else if ($nourut >= 100 and $nourut < 1000) {
					$v_trx_code = $kodecabang . '.07.' . $tahun . $bulan . '00' . $nourut;
				} else if ($nourut >= 1000 and $nourut < 10000) {
					$v_trx_code = $kodecabang . '.07.' . $tahun . $bulan . '0' . $nourut;
				} else {
					$v_trx_code = $kodecabang . '.07.' . $tahun . $bulan . $nourut;
				}
			}


			// $trx_angs = 0;
			// $trx_pokk = 0;
			// $trx_bung = 0;
			// $trx_dend = 0;
			$kin_tadmn = 0;
			$data = array(
				'kin_code'       => $v_trx_code, //$this->request->getvar('norek'),
				'kin_date'       => $post_data['tgl'],
				'agt_numb'       => $agt_numb,
				'bnk_code'       => $bnk_code,
				'knt_code'       => $norekening,
				'kin_type'       => '01',
				'kin_desc'       => $description,
				'kin_stot'       => $kin_stot,
				'kin_admn'       => 0, //$kin_tadmn,
				'kin_jtdt'       => $trx_jtdt,
				'kin_dend'       => 0, //$trx_dend,
				'kin_angs'       => $trx_amnh,
				'prd_code'       => $prd_code,
				'kin_bung'       => $trx_bung,
				'kin_pokk'       => $trx_pokk,
				'kin_angk'       => $trx_angk,
				'kin_note'       => $note,
				'kin_totl'       => $kin_stot,
				// 'kin_gtot'       => $kin_gtot,
				'acc_cash'       => $acc_cash,
				'acc_prod'       => $acc_prod,
				'acc_dend'       => '',
				'acc_admn'       => $acc_admn,
				'acc_bung'       => $acc_bung,
				'kin_tcos'       => 0,
				'kin_tprov'      => 0,
				'kin_notr'       => 0,
				'kin_jiwa'       => 0,
				'kin_kend'       => 0,
				'kin_kebk'       => 0,
				'kin_krdt'       => 0,
				'kin_dana'       => 0,
				'kin_lain'       => 0,
				'kin_matr'       => 0,
				'kin_pmat'       => 0,
				'kin_infq'       => 0,
				'kin_simw'       => 0,
				'kin_pinl'       => 0,
				'kin_tdendh'       => 0,
				'kin_ddendh'       => 0,
				'kin_tadmn'       => $kin_tadmn,
				'kin_dadmn'       => 0,
				'kin_tbungh'       => 0,
				'kin_dbungh'       => 0,
				'kin_tpokkh'       => 0,
				'kin_dpokkh'       => 0,
				'kin_rtgs'       => 0,
				'kin_tran'       => 0,
				'kin_mont'       => $bulan,
				'kin_year'       => $tahun,
				'kin_srno'  => $nourut,
				'kin_jens'  => 'K',
				'kin_stat' => '0',
				'kode_cabang' => $kodecabang,
				'com_code'  => 1,
			);

			$model->_savepembiayaan($data);


			if ($jenis == '01') {
				$id1 = $angsran_ke;
				$id = $norekening;
				$data = array(

					'trx_lnsh'  => $trx_amnh,
					'lns_pokk'  => $pokok,
					'lns_bung'  => $bunga,
					'lns_date'  => $tanggal,
					'bkt_date'  => $tanggal,
					'lns_code'  => $v_trx_code, //$this->request->getvar('norek'),
				);

				$model->_Updatekartu($data, $id, $angsran_ke);
			}
			


			if ($jenis == '01') {

				$data = array(
					'knt_stat'  => 1,
					// 'knt_cair'  => 1,

				);

				$model->_updatekontrak($data, $norekening);
			}

			$data = array(
				'trx_code' => $v_trx_code, //$this->request->getvar('norek'),
				'trx_date' => $post_data['tgl'],
				'acc_code'  => $acc_cash,
				'trx_jens'  => '01',
				'psb_code'  => $prd_code,
				'trx_urut' => 1,
				'trx_dbcr'  => 'D',
				'trx_amnt'  => $kin_gtot,
				'dbt_amnt'  => $kin_gtot,
				'crd_amnt'  => 0,
				'trx_des1'  => $description,
				'trx_des2'  => $description,
				'com_code'  => 1,
				'kode_cabang' => $kodecabang,
				'ent_time' => $waktu,
				'usercreated' => $emp_name,
			);
			$model->_savejurnal($data);


			// Jurnal 
			//Piutang


			$data = array(
				'trx_code' => $v_trx_code, //$this->request->getvar('norek'),
				'trx_date' => $post_data['tgl'],
				'acc_code'  => $acc_prod,
				'trx_jens'  => '01',
				'trx_urut' => 1,
				'trx_dbcr'  => 'K',
				'trx_amnt'  => $pokok,
				'dbt_amnt'  => 0,
				'crd_amnt'  => $pokok,
				'trx_des1'  => $description,
				'trx_des2'  => $description,
				'com_code'  => 1,
				'kode_cabang' => $kodecabang,
				'ent_time' => $waktu,
				'usercreated' => $emp_name,
			);
			$model->_savejurnal($data);


			// Pendapatan Bunga
			$data = array(
				'trx_code' => $v_trx_code, //$this->request->getvar('norek'),
				'trx_date' => $post_data['tgl'],
				'acc_code'  => $acc_bung,
				'trx_jens'  => '01',
				'trx_urut' => 1,
				'trx_dbcr'  => 'K',
				'trx_amnt'  => $bunga,
				'dbt_amnt'  => 0,
				'crd_amnt'  => $bunga,
				'trx_des1'  => $prd_name . ' - ' . $agt_name,
				'trx_des2'  => 'Pendapatan Bunga',
				'com_code'  => 1,
				'kode_cabang' => $kodecabang,
				'ent_time' => $waktu,
				'usercreated' => $emp_name,
			);
			$model->_savejurnal($data);
			// Denda
			$denda = 0; // $trx_dend;
			if ($denda > 0) {
				$code = '02';
				$caccount = $modecek->get_acckhusus($code);
				$v_acc_code = $caccount['acc_code'];
				$data = array(
					'trx_code' => $v_trx_code, //$this->request->getvar('norek'),
					'trx_date' => $post_data['tgl'],
					'acc_code'  => $v_acc_code,
					'trx_jens'  => '01',
					'trx_urut' => 1,
					'trx_dbcr'  => 'K',
					'trx_amnt'  => $trx_dend,
					'dbt_amnt'  => 0,
					'crd_amnt'  => $trx_dend,
					'trx_des1'  => 'Denda ' . $prd_name . ' - ' . $agt_name,
					'trx_des2'  => 'Pendapatan Denda',
					'com_code'  => 1,
					'kode_cabang' => $kodecabang,
					'ent_time' => $waktu,
					'usercreated' => $emp_name,
				);
				$model->_savejurnal($data);
			}
			//admin
			// Jurnal Admin
			$admin = 0; //$kin_tadmn;
			if ($admin > 0) {
				$code = '01';
				// $caccount =  $modecek->get_acckhusus($code);

				$data = array(
					'trx_code' => $v_trx_code, //$this->request->getvar('norek'),
					'trx_date' => $post_data['tgl'],
					'acc_code'  => $acc_admn,
					'trx_jens'  => '01',
					'trx_urut' => 1,
					'trx_dbcr'  => 'K',
					'trx_amnt'  => $admin,
					'dbt_amnt'  => 0,
					'crd_amnt'  => $kin_tadmn,
					'trx_des1'  => 'Admin ' . $prd_name . ' - ' . $agt_name,
					'trx_des2'  => 'Pendapatan Admin',
					'com_code'  => 1,
					'kode_cabang' => $kodecabang,
					'ent_time' => $waktu,
					'usercreated' => $emp_name,
				);
				$model->_savejurnal($data);
			}
				if ($selisih > 0) {

					$v_trx_code1 = $v_trx_code;
					$jenistran = '01';

					$sldawal = $mcore->saldotabungan($tbg_code);
					$kin_awal = 0;
					foreach ($sldawal->getResult() as $awal) {
						$kin_awal = $awal->kin_awal;
					}
					$cek1 = $mgit->_get_datatabunganab($tbg_code);
					$agt_numb = '';
					$agt_name = '';
					$prd_code = '';
					$acc_prod = '';
					$acc_admn = '';

					foreach ($cek1->getResult() as $cekrow) {
						$agt_numb = $cekrow->agt_numb;
						$agt_name = $cekrow->agt_name;
						$prd_code = $cekrow->prd_code;
						$prd_name = $cekrow->prd_name;
						$acc_prod = $cekrow->acc_code;
						$acc_admn = $cekrow->acc_cod2;
					}
					$xprod1 = $prd_code;
					$xprod = substr($xprod1, 0, 1);

					// $kodecabang = session()->get('kode_cabang');
					// if ($description == '') {
					if ($jenistran == '01') {

						// $description = 'Setoran ' . $prd_name . ' - ' . $agt_name;
						$description1 = 'Setoran ' . $prd_name;
						// } else if ($jns == '02') {
						//     $description = 'Penarikan Tunai ' . $prd_name . ' - ' . $agt_name;
						//     $description1 = 'Penarikan Tunai ' . $prd_name;
						// } else if ($jns == '03') {
						//     $description = 'Penutupan Rekening : ' . $prd_name . ' - ' . $agt_name;
						//     $description1 = 'Penutupan Rekening : ' . $prd_name;
						// } else {
						//     $description = $prd_name . ' - ' . $agt_name;
						//     $description1 = $prd_name;
					}

					// }
					
					if ($nourut == '') {
						$nourut = 1;
						$v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . '00001';
					} else {
						$nourut = $nourut + 1;
						if ($nourut < 10) {
							$v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . '0000' . $nourut;
						} else if ($nourut >= 10 and $nourut < 100) {
							$v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . '000' . $nourut;
						} else if ($nourut >= 100 and $nourut < 1000) {
							$v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . '00' . $nourut;
						} else if ($nourut >= 1000 and $nourut < 10000) {
							$v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . '0' . $nourut;
						} else {
							$v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . $nourut;
						}
					}


					$kin_stot = $selisih; //str_replace(',', '', $this->request->getvar('jumlah'));
					$kin_totl = $selisih; //str_replace(',', '', $this->request->getvar('jumlah'));

					// $kin_awal = 0;
					$v_dbt_amnt = 0;
					$v_crd_amnt = 0;
					$cektanggal = $modecek->_get_tgltabungan1($tbg_code, $tanggal);

					$kin_code = $cektanggal['kin_code'];
					$kin_dat1 = $cektanggal['kin_dat1'];
					$kin_dat2 = $cektanggal['kin_date'];


					// if ($kin_code == '') {
					//   $kin_gtot = $kin_totl;
					//   $jmlhari = 0;
					// } else {
					//   $kin_gtot = $cektanggal['kin_gtot'];
					//   $kin_gtot = $kin_gtot + $kin_totl;
					//   $jmlhari = (($tanggal - $kin_dat1) / 60 / 60 / 24) + 1;
					// }
					$jenis = '02';
					if ($jenistran == '01') {
						$debcrt = 'K';
						$v_crd_amnt = $selisih;
						$v_dbt_amnt = 0;
					} else {
						$debcrt = 'D';
						$v_dbt_amnt = $selisih;
						$v_crd_amnt = 0;
					}

					if ($kin_code == '') {
						$kin_gtot = $selisih;
						// $kin_awal = 0;
						$kin_dat1 = $cektanggal['kin_date'];
						$jmlhari = (($tanggal - $kin_dat1) / 60 / 60 / 24);
					} else {
						$kin_dat1 = $cektanggal['kin_date'];
						// $kin_awal = $cektanggal['kin_akhr'];
						$kin_gtot = $kin_awal + $v_crd_amnt - $v_dbt_amnt;
						// $kin_dat1 = date('Y-m-d', strtotime($kin_dat1));
						$tanggl2 = strtotime($tanggal);
						$tanggl1 = strtotime($kin_dat1);
						$jmlhari = (($tanggl2 - $tanggl1) / 60 / 60 / 24);
					}
					$kin_akhr = floatval($kin_awal) - floatval($v_dbt_amnt) +  floatval($v_crd_amnt);
					$data = array(
						'kin_code' => $v_trx_code,
						//$this->request->getvar('norek'),
						'kin_date' => $post_data['tgl'],
						'agt_numb' => $agt_numb,
						'bnk_code' => $bnk_code,
						'acc_cash' => $acc_prod,
						'kin_type' => $prd_code,
						'kin_desc' => $description,
						'kin_note' => $note,
						'kin_stot' => $selisih,

						// 'acc_admn' => $acc_admn,
						'acc_prod' => $acc_prod,
						'tbg_code' => $tbg_code,
						'kin_mont' => $bulan,
						'kin_year' => $tahun,
						'kin_totl' => $selisih,
						'kin_srno' => $nourut,
						// 'kin_pstr' => $rektujuan,
						'kin_jens' => '01',
						'kin_nstr' => 0,
						'kin_astr' => 0,
						'kin_prem' => 0,
						'kin_pajk' => 0,
						'kin_marg' => 0,
						'acc_prem' => '',
						'acc_pajk' => '',
						'acc_marg' => '',
						'kin_mstr' => 0,
						'kin_debt' => 0,
						'kin_crdt' => $selisih,
						'kin_dbcr' => 'K',
						'kin_stat' => 0,
						'com_code' => 1,

						'trx_jens' => '08',
						'kode_cabang' => $kodecabang,
						'kin_gtot' => $kin_gtot,
						'kin_awal' => $kin_awal,
						'kin_akhr' => $kin_akhr,
						'kin_time' => $waktu,
						'kin_user' => $emp_name,

					);

					$model->_savesetortabungan($data);

					$data = array(
						'kin_dat1' => $this->request->getvar('tgl'),
						'kin_hari' => $jmlhari,
						// 'kin_apus' => $kin_dat1,
					);

					$model->_updatetabungantgl($data, $kin_code);

					// Jurnal

					$data = array(
						'trx_code' => $v_trx_code1,
						'trx_date' => $post_data['tgl'],
						'acc_code' => $acc_prod,
						'trx_jens' => '01',
						'trx_urut' => 1,
						'trx_dbcr' => 'K',
						'trx_amnt' => $selisih,
						'dbt_amnt' => 0,
						'crd_amnt' => $selisih,
						'trx_des1' => $description,
						'trx_des2' => $description1,
						'com_code' => 1,
						'kode_cabang' => $kodecabang,
						'ent_time' => $waktu,
						'usercreated' => $emp_name,
					);
					$model->_savejurnal($data);
			}

			$rek_akhir = $mcore->_get_pinjamanrek($norekening);
			if ($data) {
				$saldo_akhir_pinjaman = $rek_akhir[0]->sisa_pinjaman;
				$response['status'] = 'Berhasil';
				$response['data']['nobukti'] = $v_trx_code;
				$response['data']['saldo_awal'] = $saldo_awal_pinjaman;
				$response['data']['saldo_akhir'] = $saldo_akhir_pinjaman;
				return $this->respond($response, 200);
			} else {
				$response['status'] = 'error';
				$response['message'] = 'No data found';
				return $this->respond($response, 404);
			}
		}
    }
	
	private function angsurankredit($paramkredit)
    {
        $model = new Save_model();
        $modecek = new Auto_model();
        $mgit = new Model_git();
        $mcore = new Core_model();
        $note = "";
		//$post_data = json_decode(stripslashes(file_get_contents('php://input')), true);
	
        $petugas = $paramkredit->petugas;
        $norekening = $paramkredit->norekening;
        $tanggal = $paramkredit->tanggal;
        $description = $paramkredit->description;
        $pokok = $paramkredit->pokok;
        $bunga = $paramkredit->bunga;
        $kin_stot =  $paramkredit->kin_stot;
        $kin_gtot =  $paramkredit->kin_gtot;
        $angsran_ke = $paramkredit->angsran_ke;
        $bulan = $paramkredit->bulan;
        $tahun = $paramkredit->tahun;
        $waktu = date('Y-m-d H:i:s');
		
		//cek angsuran apakah sudah pernah dibayar
		$cek_angsuran = $mcore->_get_angsuran_kartu($norekening,$angsran_ke);
		//print_r($cek_angsuran);
		if($cek_angsuran->lns_code != ''){
			$response['status'] = 'error';
			$response['message'] = 'Angsuran ke '.$angsran_ke.' status sudah lunas';
			return $this->respond($response, 401);
		}
		
		else{
			//get bank code
			$cond = array('emp_code'=>$petugas);
			$dbemployee = $mcore->_get_petugas($cond)->getRow();
			//print_r($dbemployee);
			//die();
			$emp_name = $dbemployee->nama_petugas;
			$bnk_code = $dbemployee->kode_kas;
			$kodecabang = $dbemployee->kode_cabang;
			
			//if ($bnk_code == '') {
			//	$response['status'] = 'error';
		       //     $response['message'] = 'Petugas tidak terdaftar';
			//		return $this->respond($response, 401);
		  //  }
			//end bank code

			$jenis = '01';
			//$bnk_code = '90';
			$dbbank = $modecek->get_bank($bnk_code);
			$acc_cash = $dbbank['acc_code'];;
			$cek = $modecek->get_nopembiayaan($bulan, $tahun);
			$nourut = $cek['kin_srno'];
			$rek_awal = $mcore->_get_pinjamanrek($norekening);
			$saldo_awal_pinjaman = $rek_awal[0]->sisa_pinjaman;

			//$acc_cash = '';
			$prd_code = '';
			$prd_name = '';
			$trx_angk = '';
			$trx_jtdt = '0000-00-00';
			$trx_pokk = '';
			$trx_bung = '';
			$trx_dend = '';
			$trx_amnh = '';
			$agt_numb = '';
			$agt_name = '';
			$prd_code = '';
			$acc_prod = '';
			$acc_bung = '';
			$acc_admn = '';
			
			$kodecabang = '';
			$dbpinjaman = $mgit->_get_dtkartuhutang($norekening);

			foreach ($dbpinjaman->getResult() as $rowtrans) {
				//$acc_cash = $rowtrans->acc_code;
				$prd_code = $rowtrans->acc_code;
				$prd_name = $rowtrans->acc_code;
				$trx_angk = $rowtrans->trx_angk;
				$trx_jtdt = $rowtrans->trx_jtdt;
				$trx_pokk = floatval($rowtrans->trx_pokk == "" ? 0 : $rowtrans->trx_pokk );
				$trx_bung = floatval($rowtrans->trx_bung == "" ? 0 : $rowtrans->trx_bung);
				$trx_dend = $rowtrans->trx_dend;
				$trx_amnh = $rowtrans->trx_saldo;
				$agt_numb = $rowtrans->agt_numb;
				$agt_name = $rowtrans->agt_name;
				$prd_code = $rowtrans->prd_code;
				$acc_prod = $rowtrans->acc_code;
				$acc_bung = $rowtrans->acc_cod1;
				$acc_admn = $rowtrans->acc_cod2;
				 $tbg_code = $rowtrans->tbg_code;
				$kodecabang = $rowtrans->kode_cabang;
				
				//$kodecabang = $rowtrans->kode_cabang;
			     
			}
			//var_dump($trx_pokk);
			//die('');
			$tot_bayr = $trx_pokk + $trx_bung;
			$selisih = 0;
        	if ($kin_gtot > $tot_bayr) {
            	$pokok = $trx_pokk;
  			    $bunga = $trx_bung;
			    $selisih = $kin_gtot - $tot_bayr;
        	}

			// $description = 'Setoran ' . $prd_name . ' - ' . $agt_name;
			// $description1 = 'Setoran ' . $prd_name;

			if ($nourut == '') {
				$nourut = 1;
				$v_trx_code = $kodecabang . '.07.' . $tahun . $bulan . '00001';
			} else {
				$nourut = $nourut + 1;
				if ($nourut < 10) {
					$v_trx_code = $kodecabang . '.07.' . $tahun . $bulan . '0000' . $nourut;
				} else if ($nourut >= 10 and $nourut < 100) {
					$v_trx_code = $kodecabang . '.07.' . $tahun . $bulan . '000' . $nourut;
				} else if ($nourut >= 100 and $nourut < 1000) {
					$v_trx_code = $kodecabang . '.07.' . $tahun . $bulan . '00' . $nourut;
				} else if ($nourut >= 1000 and $nourut < 10000) {
					$v_trx_code = $kodecabang . '.07.' . $tahun . $bulan . '0' . $nourut;
				} else {
					$v_trx_code = $kodecabang . '.07.' . $tahun . $bulan . $nourut;
				}
			}


			// $trx_angs = 0;
			// $trx_pokk = 0;
			// $trx_bung = 0;
			// $trx_dend = 0;
			$kin_tadmn = 0;
			$data = array(
				'kin_code'       => $v_trx_code, //$this->request->getvar('norek'),
				'kin_date'       => $tanggal,
				'agt_numb'       => $agt_numb,
				'bnk_code'       => $bnk_code,
				'knt_code'       => $norekening,
				'kin_type'       => '01',
				'kin_desc'       => $description,
				'kin_stot'       => $kin_stot,
				'kin_admn'       => 0, //$kin_tadmn,
				'kin_jtdt'       => $trx_jtdt,
				'kin_dend'       => 0, //$trx_dend,
				'kin_angs'       => $trx_amnh,
				'prd_code'       => $prd_code,
				'kin_bung'       => $trx_bung,
				'kin_pokk'       => $trx_pokk,
				'kin_angk'       => $trx_angk,
				'kin_note'       => $note,
				'kin_totl'       => $kin_stot,
				// 'kin_gtot'       => $kin_gtot,
				'acc_cash'       => $acc_cash,
				'acc_prod'       => $acc_prod,
				'acc_dend'       => '',
				'acc_admn'       => $acc_admn,
				'acc_bung'       => $acc_bung,
				'kin_tcos'       => 0,
				'kin_tprov'      => 0,
				'kin_notr'       => 0,
				'kin_jiwa'       => 0,
				'kin_kend'       => 0,
				'kin_kebk'       => 0,
				'kin_krdt'       => 0,
				'kin_dana'       => 0,
				'kin_lain'       => 0,
				'kin_matr'       => 0,
				'kin_pmat'       => 0,
				'kin_infq'       => 0,
				'kin_simw'       => 0,
				'kin_pinl'       => 0,
				'kin_tdendh'       => 0,
				'kin_ddendh'       => 0,
				'kin_tadmn'       => $kin_tadmn,
				'kin_dadmn'       => 0,
				'kin_tbungh'       => 0,
				'kin_dbungh'       => 0,
				'kin_tpokkh'       => 0,
				'kin_dpokkh'       => 0,
				'kin_rtgs'       => 0,
				'kin_tran'       => 0,
				'kin_mont'       => $bulan,
				'kin_year'       => $tahun,
				'kin_srno'  => $nourut,
				'kin_jens'  => 'K',
				'kin_stat' => '0',
				'kode_cabang' => $kodecabang,
				'com_code'  => 1,
			);

			$model->_savepembiayaan($data);


			if ($jenis == '01') {
				$id1 = $angsran_ke;
				$id = $norekening;
				$data = array(

					'trx_lnsh'  => $trx_amnh,
					'lns_pokk'  => $pokok,
					'lns_bung'  => $bunga,
					'lns_date'  => $tanggal,
					'bkt_date'  => $tanggal,
					'lns_code'  => $v_trx_code, //$this->request->getvar('norek'),
				);

				$model->_Updatekartu($data, $id, $angsran_ke);
			}
			


			if ($jenis == '01') {

				$data = array(
					'knt_stat'  => 1,
					// 'knt_cair'  => 1,

				);

				$model->_updatekontrak($data, $norekening);
			}

			$data = array(
				'trx_code' => $v_trx_code, //$this->request->getvar('norek'),
				'trx_date' => $tanggal,
				'acc_code'  => $acc_cash,
				'trx_jens'  => '01',
				'psb_code'  => $prd_code,
				'trx_urut' => 1,
				'trx_dbcr'  => 'D',
				'trx_amnt'  => $kin_gtot,
				'dbt_amnt'  => $kin_gtot,
				'crd_amnt'  => 0,
				'trx_des1'  => $description,
				'trx_des2'  => $description,
				'com_code'  => 1,
				'kode_cabang' => $kodecabang,
				'ent_time' => $waktu,
				'usercreated' => $emp_name,
			);
			$model->_savejurnal($data);


			// Jurnal 
			//Piutang


			$data = array(
				'trx_code' => $v_trx_code, //$this->request->getvar('norek'),
				'trx_date' => $tanggal,
				'acc_code'  => $acc_prod,
				'trx_jens'  => '01',
				'trx_urut' => 1,
				'trx_dbcr'  => 'K',
				'trx_amnt'  => $pokok,
				'dbt_amnt'  => 0,
				'crd_amnt'  => $pokok,
				'trx_des1'  => $description,
				'trx_des2'  => $description,
				'com_code'  => 1,
				'kode_cabang' => $kodecabang,
				'ent_time' => $waktu,
				'usercreated' => $emp_name,
			);
			$model->_savejurnal($data);


			// Pendapatan Bunga
			$data = array(
				'trx_code' => $v_trx_code, //$this->request->getvar('norek'),
				'trx_date' => $tanggal,
				'acc_code'  => $acc_bung,
				'trx_jens'  => '01',
				'trx_urut' => 1,
				'trx_dbcr'  => 'K',
				'trx_amnt'  => $bunga,
				'dbt_amnt'  => 0,
				'crd_amnt'  => $bunga,
				'trx_des1'  => $prd_name . ' - ' . $agt_name,
				'trx_des2'  => 'Pendapatan Bunga',
				'com_code'  => 1,
				'kode_cabang' => $kodecabang,
				'ent_time' => $waktu,
				'usercreated' => $emp_name,
			);
			$model->_savejurnal($data);
			// Denda
			$denda = 0; // $trx_dend;
			if ($denda > 0) {
				$code = '02';
				$caccount = $modecek->get_acckhusus($code);
				$v_acc_code = $caccount['acc_code'];
				$data = array(
					'trx_code' => $v_trx_code, //$this->request->getvar('norek'),
					'trx_date' => $tanggal,
					'acc_code'  => $v_acc_code,
					'trx_jens'  => '01',
					'trx_urut' => 1,
					'trx_dbcr'  => 'K',
					'trx_amnt'  => $trx_dend,
					'dbt_amnt'  => 0,
					'crd_amnt'  => $trx_dend,
					'trx_des1'  => 'Denda ' . $prd_name . ' - ' . $agt_name,
					'trx_des2'  => 'Pendapatan Denda',
					'com_code'  => 1,
					'kode_cabang' => $kodecabang,
					'ent_time' => $waktu,
					'usercreated' => $emp_name,
				);
				$model->_savejurnal($data);
			}
			//admin
			// Jurnal Admin
			$admin = 0; //$kin_tadmn;
			if ($admin > 0) {
				$code = '01';
				// $caccount =  $modecek->get_acckhusus($code);

				$data = array(
					'trx_code' => $v_trx_code, //$this->request->getvar('norek'),
					'trx_date' => $tanggal,
					'acc_code'  => $acc_admn,
					'trx_jens'  => '01',
					'trx_urut' => 1,
					'trx_dbcr'  => 'K',
					'trx_amnt'  => $admin,
					'dbt_amnt'  => 0,
					'crd_amnt'  => $kin_tadmn,
					'trx_des1'  => 'Admin ' . $prd_name . ' - ' . $agt_name,
					'trx_des2'  => 'Pendapatan Admin',
					'com_code'  => 1,
					'kode_cabang' => $kodecabang,
					'ent_time' => $waktu,
					'usercreated' => $emp_name,
				);
				$model->_savejurnal($data);
			}
				if ($selisih > 0) {

					$v_trx_code1 = $v_trx_code;
					$jenistran = '01';

					$sldawal = $mcore->saldotabungan($tbg_code);
					$kin_awal = 0;
					foreach ($sldawal->getResult() as $awal) {
						$kin_awal = $awal->kin_awal;
					}
					$cek1 = $mgit->_get_datatabunganab($tbg_code);
					$agt_numb = '';
					$agt_name = '';
					$prd_code = '';
					$acc_prod = '';
					$acc_admn = '';

					foreach ($cek1->getResult() as $cekrow) {
						$agt_numb = $cekrow->agt_numb;
						$agt_name = $cekrow->agt_name;
						$prd_code = $cekrow->prd_code;
						$prd_name = $cekrow->prd_name;
						$acc_prod = $cekrow->acc_code;
						$acc_admn = $cekrow->acc_cod2;
					}
					$xprod1 = $prd_code;
					$xprod = substr($xprod1, 0, 1);

					// $kodecabang = session()->get('kode_cabang');
					// if ($description == '') {
					if ($jenistran == '01') {

						// $description = 'Setoran ' . $prd_name . ' - ' . $agt_name;
						$description1 = 'Setoran ' . $prd_name;
						// } else if ($jns == '02') {
						//     $description = 'Penarikan Tunai ' . $prd_name . ' - ' . $agt_name;
						//     $description1 = 'Penarikan Tunai ' . $prd_name;
						// } else if ($jns == '03') {
						//     $description = 'Penutupan Rekening : ' . $prd_name . ' - ' . $agt_name;
						//     $description1 = 'Penutupan Rekening : ' . $prd_name;
						// } else {
						//     $description = $prd_name . ' - ' . $agt_name;
						//     $description1 = $prd_name;
					}

					// }
					
					if ($nourut == '') {
						$nourut = 1;
						$v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . '00001';
					} else {
						$nourut = $nourut + 1;
						if ($nourut < 10) {
							$v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . '0000' . $nourut;
						} else if ($nourut >= 10 and $nourut < 100) {
							$v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . '000' . $nourut;
						} else if ($nourut >= 100 and $nourut < 1000) {
							$v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . '00' . $nourut;
						} else if ($nourut >= 1000 and $nourut < 10000) {
							$v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . '0' . $nourut;
						} else {
							$v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . $nourut;
						}
					}


					$kin_stot = $selisih; //str_replace(',', '', $this->request->getvar('jumlah'));
					$kin_totl = $selisih; //str_replace(',', '', $this->request->getvar('jumlah'));

					// $kin_awal = 0;
					$v_dbt_amnt = 0;
					$v_crd_amnt = 0;
					$cektanggal = $modecek->_get_tgltabungan1($tbg_code, $tanggal);

					$kin_code = $cektanggal['kin_code'];
					$kin_dat1 = $cektanggal['kin_dat1'];
					$kin_dat2 = $cektanggal['kin_date'];


					// if ($kin_code == '') {
					//   $kin_gtot = $kin_totl;
					//   $jmlhari = 0;
					// } else {
					//   $kin_gtot = $cektanggal['kin_gtot'];
					//   $kin_gtot = $kin_gtot + $kin_totl;
					//   $jmlhari = (($tanggal - $kin_dat1) / 60 / 60 / 24) + 1;
					// }
					$jenis = '02';
					if ($jenistran == '01') {
						$debcrt = 'K';
						$v_crd_amnt = $selisih;
						$v_dbt_amnt = 0;
					} else {
						$debcrt = 'D';
						$v_dbt_amnt = $selisih;
						$v_crd_amnt = 0;
					}

					if ($kin_code == '') {
						$kin_gtot = $selisih;
						// $kin_awal = 0;
						$kin_dat1 = $cektanggal['kin_date'];
						$jmlhari = (($tanggal - $kin_dat1) / 60 / 60 / 24);
					} else {
						$kin_dat1 = $cektanggal['kin_date'];
						// $kin_awal = $cektanggal['kin_akhr'];
						$kin_gtot = $kin_awal + $v_crd_amnt - $v_dbt_amnt;
						// $kin_dat1 = date('Y-m-d', strtotime($kin_dat1));
						$tanggl2 = strtotime($tanggal);
						$tanggl1 = strtotime($kin_dat1);
						$jmlhari = (($tanggl2 - $tanggl1) / 60 / 60 / 24);
					}
					$kin_akhr = floatval($kin_awal) - floatval($v_dbt_amnt) +  floatval($v_crd_amnt);
					$data = array(
						'kin_code' => $v_trx_code,
						//$this->request->getvar('norek'),
						'kin_date' => $tanggal,
						'agt_numb' => $agt_numb,
						'bnk_code' => $bnk_code,
						'acc_cash' => $acc_prod,
						'kin_type' => $prd_code,
						'kin_desc' => $description,
						'kin_note' => $note,
						'kin_stot' => $selisih,

						// 'acc_admn' => $acc_admn,
						'acc_prod' => $acc_prod,
						'tbg_code' => $tbg_code,
						'kin_mont' => $bulan,
						'kin_year' => $tahun,
						'kin_totl' => $selisih,
						'kin_srno' => $nourut,
						// 'kin_pstr' => $rektujuan,
						'kin_jens' => '01',
						'kin_nstr' => 0,
						'kin_astr' => 0,
						'kin_prem' => 0,
						'kin_pajk' => 0,
						'kin_marg' => 0,
						'acc_prem' => '',
						'acc_pajk' => '',
						'acc_marg' => '',
						'kin_mstr' => 0,
						'kin_debt' => 0,
						'kin_crdt' => $selisih,
						'kin_dbcr' => 'K',
						'kin_stat' => 0,
						'com_code' => 1,

						'trx_jens' => '08',
						'kode_cabang' => $kodecabang,
						'kin_gtot' => $kin_gtot,
						'kin_awal' => $kin_awal,
						'kin_akhr' => $kin_akhr,
						'kin_time' => $waktu,
						'kin_user' => $emp_name,

					);

					$model->_savesetortabungan($data);

					$data = array(
						'kin_dat1' => $tanggal,
						'kin_hari' => $jmlhari,
						// 'kin_apus' => $kin_dat1,
					);

					$model->_updatetabungantgl($data, $kin_code);

					// Jurnal

					$data = array(
						'trx_code' => $v_trx_code1,
						'trx_date' => $tanggal,
						'acc_code' => $acc_prod,
						'trx_jens' => '01',
						'trx_urut' => 1,
						'trx_dbcr' => 'K',
						'trx_amnt' => $selisih,
						'dbt_amnt' => 0,
						'crd_amnt' => $selisih,
						'trx_des1' => $description,
						'trx_des2' => $description1,
						'com_code' => 1,
						'kode_cabang' => $kodecabang,
						'ent_time' => $waktu,
						'usercreated' => $emp_name,
					);
					$model->_savejurnal($data);
			}

			$rek_akhir = $mcore->_get_pinjamanrek($norekening);
			if ($data) {
				$saldo_akhir_pinjaman = $rek_akhir[0]->sisa_pinjaman;
				$response['status'] = 'Berhasil';
				$response['data']['nobukti'] = $v_trx_code;
				$response['data']['saldo_awal'] = $saldo_awal_pinjaman;
				$response['data']['saldo_akhir'] = $saldo_akhir_pinjaman;
				return $this->respond($response, 200);
			} else {
				$response['status'] = 'error';
				$response['message'] = 'No data found';
				return $this->respond($response, 404);
			}
		}
    }
	
	public function gettagihan($id = null)
    {
        $model = new Core_model();
        $data = $model->_get_pembiayaan($id)->getResult();

        if ($data) {
            $response['status'] = 'Berhasil';
			$response['data']= $data;
			return $this->respond($response, 200);
        } else {
            $response['status'] = 'error';
			$response['message'] = 'No data found';
			return $this->respond($response, 404);
        }
    }
	
	public function transfer()
    {
		if (!$this->tokenValid) {
		  return $this->respond('Invalid Token', 401);
		}
        $model = new Save_model();
        $mgit = new Model_git();
        $modecek = new Auto_model();
        $mcore = new Core_model();
        $note = "";
		$post_data = json_decode(stripslashes(file_get_contents('php://input')), true);
	
        $tanggal = $post_data['tgl'];
        $bulan = date('m', strtotime($tanggal));
        $tahun = date('Y', strtotime($tanggal));
        $waktu = date('Y-m-d H:i:s');

        $cek = $modecek->get_nosetortabungan($bulan, $tahun);
        $jns = '02';
        $description = $post_data['keterangan'];

        $nourut = $cek['kin_srno'];
        $rekening = $post_data['norek'];
        $rektujuan =$post_data['rektujuan'];
        $empcode = $post_data['collector_id'];
        $kodecabang = '';
		$cond = array('emp_code'=>$empcode);
        $dbemployee = $mcore->_get_petugas($cond)->getRow();
		
        $emp_name = $dbemployee->nama_petugas;
		$bnk_code = $dbemployee->kode_kas;
		$kodecabang = $dbemployee->unit_kerja;
		if ($bnk_code == '') {
            $res['message'] = 'Petugas tidak terdaftar';
			$res['status'] = 'error';
            return $this->respond($res, 404);
        }
       
		
		$cek_rektujuan = $mcore->_cek_norektabungan($rektujuan)->getRow();
		
		if (!$cek_rektujuan) {
            $response['status'] = 'error';
			$response['message'] = 'Rekening tujuan tidak ditemukan';
			return $this->respond($response, 401);
        }
		else{
			$dbbank = $modecek->get_bank($bnk_code);
			$acc_cash = $dbbank['acc_code'];

			$sldawal = $mcore->saldotabungan($rekening);
			$kin_awal = 0;
			foreach ($sldawal->getResult() as $awal) {
				$kin_awal = $awal->kin_awal;
			}
			$cek1 = $mgit->_get_datatabunganab($rekening);
			$agt_numb = '';
			$agt_name = '';
			$prd_code = '';
			$acc_prod = '';
			$acc_admn = '';

			foreach ($cek1->getResult() as $cekrow) {
				$agt_numb = $cekrow->agt_numb;
				$agt_name = $cekrow->agt_name;
				$prd_code = $cekrow->prd_code;
				$prd_name = $cekrow->prd_name;
				$acc_prod = $cekrow->acc_code;
				$acc_admn = $cekrow->acc_cod2;
				// $kodecabang = $cekrow->kode_cabang;
			}
			// $rekening = $cek1['tbg_code'];

			$xprod1 = $prd_code;
			$xprod = substr($xprod1, 0, 1);

			// $description = 'Setoran ' . $prd_name . ' - ' . $agt_name;
			$description1 = 'Setoran ' . $prd_name;

			// }
			if ($nourut == '') {
				$nourut = 1;
				$v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . '00001';
			} else {
				$nourut = $nourut + 1;
				if ($nourut < 10) {
					$v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . '0000' . $nourut;
				} else if ($nourut >= 10 and $nourut < 100) {
					$v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . '000' . $nourut;
				} else if ($nourut >= 100 and $nourut < 1000) {
					$v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . '00' . $nourut;
				} else if ($nourut >= 1000 and $nourut < 10000) {
					$v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . '0' . $nourut;
				} else {
					$v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . $nourut;
				}
			}


			$kin_stot = str_replace(',', '', $post_data['jumlah']);
			$kin_totl = str_replace(',', '', $post_data['jumlah']);
			// $kin_awal = 0;
			$v_dbt_amnt = 0;
			$v_crd_amnt = 0;
			$cektanggal = $modecek->_get_tgltabungan1($rekening, $tanggal);
			$kin_code = $cektanggal['kin_code'];
			$kin_dat1 = $cektanggal['kin_dat1'];
			$kin_dat2 = $cektanggal['kin_date'];



			// }
			if ($jns == '01') {
				$debcrt = 'K';
				$v_crd_amnt = $kin_totl;
				$v_dbt_amnt = 0;
			} else {
				$debcrt = 'D';
				$v_dbt_amnt = $kin_totl;
				$v_crd_amnt = 0;
			}

			if ($kin_code == '') {
				$kin_gtot = $kin_totl;
				// $kin_awal = 0;
				$kin_dat1 = $cektanggal['kin_date'];
				$jmlhari = (($tanggal - $kin_dat1) / 60 / 60 / 24);
			} else {
				$kin_dat1 = $cektanggal['kin_date'];
				// $kin_awal = $cektanggal['kin_akhr'];
				$kin_gtot = $kin_awal + $v_crd_amnt - $v_dbt_amnt;
				// $kin_dat1 = date('Y-m-d', strtotime($kin_dat1));
				$tanggl2 = strtotime($tanggal);
				$tanggl1 = strtotime($kin_dat1);
				$jmlhari = (($tanggl2 - $tanggl1) / 60 / 60 / 24);
			}
			$kin_akhr = $kin_awal - $v_dbt_amnt + $v_crd_amnt;
			$data = array(
				'kin_code' => $v_trx_code,
				//$this->request->getvar('norek'),
				'kin_date' => $post_data['tgl'],
				'agt_numb' => $agt_numb,
				'bnk_code' => $bnk_code,
				'acc_cash' => $acc_cash,
				'kin_type' => $prd_code,
				'kin_desc' => $description,
				'kin_note' => $note,
				'kin_stot' => $kin_stot,

				'acc_admn' => $acc_admn,
				'acc_prod' => $acc_prod,
				'tbg_code' => $rekening,
				'kin_mont' => $bulan,
				'kin_year' => $tahun,
				'kin_totl' => $kin_totl,
				'kin_srno' => $nourut,
				'kin_jens' => '04',
				'kin_nstr' => 0,
				'kin_astr' => 0,
				'kin_prem' => 0,
				'kin_pajk' => 0,
				'kin_marg' => 0,
				'acc_prem' => '',
				'acc_pajk' => '',
				'acc_marg' => '',
				'kin_mstr' => 0,
				'kin_debt' => $v_dbt_amnt,
				'kin_crdt' => $v_crd_amnt,
				'kin_dbcr' => $debcrt,
				'kin_stat' => 0,
				'com_code' => 1,

				'trx_jens' => '07',
				'kode_cabang' => $kodecabang,
				'kin_gtot' => $kin_gtot,
				'kin_awal' => $kin_awal,
				'kin_akhr' => $kin_akhr,
				'kin_time' => $waktu,
				'kin_user' => $emp_name,

			);

			$model->_savesetortabungan($data);



			$data = array(
				'kin_dat1' => $post_data['tgl'],
				'kin_hari' => $jmlhari,
				// 'kin_apus' => $kin_dat1,
			);

			$model->_updatetabungantgl($data, $kin_code);


			// Jurnal
			if ($jns == '01') {
				$v_trx_dbcr = 'D';
				$v_trx_debt = $kin_totl;
				$v_trx_crdt = 0;
			} else {
				$v_trx_dbcr = 'K';
				$v_trx_debt = 0;
				$v_trx_crdt = $kin_totl;
			}
			if ($jns == '01') {
				if ($xprod == '3') {
					$cabang = $kodecabang;
					if ($cabang != '100') {
						$cabcod12 = '100';
					} else {
						$cabcod12 = $kodecabang;
					}
				} else {
					$cabcod12 = $kodecabang;
				}
			} else {
				$cabcod12 = $kodecabang;
			}

			// Jurnal

			if ($jns == '01') {
				$v_trx_dbcr = 'K';
				$v_trx_debt = 0;
				$v_trx_crdt = $kin_stot;
			} else {
				$v_trx_dbcr = 'D';
				$v_trx_debt = $kin_stot;
				$v_trx_crdt = 0;
			}

			$data = array(
				'trx_code' => $v_trx_code,
				//$this->request->getvar('norek'),
				'trx_date' => $post_data['tgl'],
				'acc_code' => $acc_prod,
				'trx_jens' => '01',
				'trx_urut' => 1,
				'trx_dbcr' => $v_trx_dbcr,
				'trx_amnt' => $kin_stot,
				'dbt_amnt' => $v_trx_debt,
				'crd_amnt' => $v_trx_crdt,
				'trx_des1' => $description,
				'trx_des2' => $description1,
				'com_code' => 1,
				'kode_cabang' => $cabcod12,
				'ent_time' => $waktu,
				'usercreated' => $emp_name,
			);
			$model->_savejurnal($data);



			// Magin

			$id = $rekening;



			if ($rekening == '') {
				if ($jns == '01') {

					$vstatus = '1';
					$data = array(

						'tbg_stat' => $vstatus,
						'tbg_aktv' => $post_data['tgl'],
						'tbg_awal' => $kin_stot,

					);
					$model->_updatetabungan($data, $id);
				}
			}



			// Rekening Tujuan
			$v_trx_code1 = $v_trx_code;
			$sldawal = $mcore->saldotabungan($rektujuan);
			$kin_awal = 0;
$jns='01';
			foreach ($sldawal->getResult() as $awal) {
				$kin_awal = $awal->kin_awal;
			}
			$cek1 = $mgit->_get_datatabunganab($rektujuan);
			$agt_numb = '';
			$agt_name = '';
			$prd_code = '';
			$acc_prod = '';
			$acc_admn = '';

			foreach ($cek1->getResult() as $cekrow) {
				$agt_numb = $cekrow->agt_numb;
				$agt_name = $cekrow->agt_name;
				$prd_code = $cekrow->prd_code;
				$prd_name = $cekrow->prd_name;
				$acc_prod = $cekrow->acc_code;
				$acc_admn = $cekrow->acc_cod2;
				// $kodecabang = $cekrow->kode_cabang;
			}
			// $rekening = $cek1['tbg_code'];

			$xprod1 = $prd_code;
			$xprod = substr($xprod1, 0, 1);


			// $kodecabang = session()->get('kode_cabang');
			// if ($description == '') {
			if ($jns == '01') {

				// $description = 'Setoran ' . $prd_name . ' - ' . $agt_name;
				$description1 = 'Setoran ' . $prd_name;
			}

			// }
			if ($nourut == '') {
				$nourut = 1;
				$v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . '00001';
			} else {
				$nourut = $nourut + 1;
				if ($nourut < 10) {
					$v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . '0000' . $nourut;
				} else if ($nourut >= 10 and $nourut < 100) {
					$v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . '000' . $nourut;
				} else if ($nourut >= 100 and $nourut < 1000) {
					$v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . '00' . $nourut;
				} else if ($nourut >= 1000 and $nourut < 10000) {
					$v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . '0' . $nourut;
				} else {
					$v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . $nourut;
				}
			}


			$kin_stot = str_replace(',', '', $post_data['jumlah']);
			$kin_totl = str_replace(',', '', $post_data['jumlah']);
			// $kin_awal = 0;
			$v_dbt_amnt = 0;
			$v_crd_amnt = 0;
			$cektanggal = $modecek->_get_tgltabungan1($rektujuan, $tanggal);
			$kin_code = $cektanggal['kin_code'];
			$kin_dat1 = $cektanggal['kin_dat1'];
			$kin_dat2 = $cektanggal['kin_date'];



			if ($jns == '01') {
				$debcrt = 'K';
				$v_crd_amnt = $kin_totl;
				$v_dbt_amnt = 0;
			} else {
				$debcrt = 'D';
				$v_dbt_amnt = $kin_totl;
				$v_crd_amnt = 0;
			}

			if ($kin_code == '') {
				$kin_gtot = $kin_totl;
				// $kin_awal = 0;
				$kin_dat1 = $cektanggal['kin_date'];
				$jmlhari = (($tanggal - $kin_dat1) / 60 / 60 / 24);
			} else {
				$kin_dat1 = $cektanggal['kin_date'];
				// $kin_awal = $cektanggal['kin_akhr'];
				$kin_gtot = $kin_awal + $v_crd_amnt - $v_dbt_amnt;
				// $kin_dat1 = date('Y-m-d', strtotime($kin_dat1));
				$tanggl2 = strtotime($tanggal);
				$tanggl1 = strtotime($kin_dat1);
				$jmlhari = (($tanggl2 - $tanggl1) / 60 / 60 / 24);
			}
			$kin_akhr = $kin_awal - $v_dbt_amnt + $v_crd_amnt;
			$data = array(
				'kin_code' => $v_trx_code,
				//$this->request->getvar('norek'),
				'kin_date' => $post_data['tgl'],
				'agt_numb' => $agt_numb,
				'bnk_code' => $bnk_code,
				'acc_cash' => $acc_cash,
				'kin_type' => $prd_code,
				'kin_desc' => $description,
				'kin_note' => $note,
				'kin_stot' => $kin_stot,

				'acc_admn' => $acc_admn,
				'acc_prod' => $acc_prod,
				'tbg_code' => $rektujuan,
				'kin_mont' => $bulan,
				'kin_year' => $tahun,
				'kin_totl' => $kin_totl,
				'kin_srno' => $nourut,
				'kin_jens' => '04',
				'kin_nstr' => 0,
				'kin_astr' => 0,
				'kin_prem' => 0,
				'kin_pajk' => 0,
				'kin_marg' => 0,
				'acc_prem' => '',
				'acc_pajk' => '',
				'acc_marg' => '',
				'kin_mstr' => 0,
				'kin_debt' => 0,
				'kin_crdt' => $kin_totl,
				'kin_dbcr' => 'K',
				'kin_stat' => 0,
				'com_code' => 1,

				'trx_jens' => '07',
				'kode_cabang' => $kodecabang,
				'kin_gtot' => $kin_gtot,
				'kin_awal' => $kin_awal,
				'kin_akhr' => $kin_akhr,
				'kin_time' => $waktu,
				'kin_user' => $emp_name,

			);

			$model->_savesetortabungan($data);



			$data = array(
				'kin_dat1' => $post_data['tgl'],
				'kin_hari' => $jmlhari,
				// 'kin_apus' => $kin_dat1,
			);

			$model->_updatetabungantgl($data, $kin_code);


			// Jurnal
			if ($jns == '01') {
				$v_trx_dbcr = 'D';
				$v_trx_debt = $kin_totl;
				$v_trx_crdt = 0;
			} else {
				$v_trx_dbcr = 'K';
				$v_trx_debt = 0;
				$v_trx_crdt = $kin_totl;
			}
			if ($jns == '01') {
				if ($xprod == '3') {
					$cabang = $kodecabang;
					if ($cabang != '100') {
						$cabcod12 = '100';
					} else {
						$cabcod12 = $kodecabang;
					}
				} else {
					$cabcod12 = $kodecabang;
				}
			} else {
				$cabcod12 = $kodecabang;
			}



			// Jurnal

			if ($jns == '01') {
				$v_trx_dbcr = 'K';
				$v_trx_debt = 0;
				$v_trx_crdt = $kin_stot;
			} else {
				$v_trx_dbcr = 'D';
				$v_trx_debt = $kin_stot;
				$v_trx_crdt = 0;
			}

			$data = array(
				'trx_code' => $v_trx_code1,
				//$this->request->getvar('norek'),
				'trx_date' => $post_data['tgl'],
				'acc_code' => $acc_prod,
				'trx_jens' => '01',
				'trx_urut' => 1,
				'trx_dbcr' => $v_trx_dbcr,
				'trx_amnt' => $kin_stot,
				'dbt_amnt' => $v_trx_debt,
				'crd_amnt' => $v_trx_crdt,
				'trx_des1' => $description,
				'trx_des2' => $description1,
				'com_code' => 1,
				'kode_cabang' => $cabcod12,
				'ent_time' => $waktu,
				'usercreated' => $emp_name,
			);
			$model->_savejurnal($data);

			//admin
			// Jurnal Admin

			//Premi
			// Jurnal Premi



			// Jurnal Pajak


			// Magin

			$id = $rektujuan;



			if ($rektujuan == '') {
				if ($jns == '01') {

					$vstatus = '1';
					$data = array(

						'tbg_stat' => $vstatus,
						'tbg_aktv' => $post_data['tgl'],
						'tbg_awal' => $kin_stot,

					);
					$model->_updatetabungan($data, $id);
				}
			}



			// End Rekening Tujuan

			$data = $mcore->_get_simpanantrans($v_trx_code)->getResult();
			if ($data) {
				//$saldo_akhir_pinjaman = $rek_akhir[0]->sisa_pinjaman;
				$response['status'] = 'Berhasil';
				$response['data'] = $data;
				return $this->respond($response, 200);
			} else {
				$response['status'] = 'error';
				$response['message'] = 'No data found';
				return $this->respond($response, 404);
			};
		}
    }
//End Transfer

//transaksi PPOB

 public function transaksippob()
    {
        if (!$this->tokenValid) {
           return $this->respond('Invalid Token', 401);
        }
        $model = new Save_model();
        $mgit = new Model_git();
        $modecek = new Auto_model();
        $mcore = new Core_model();
        $note = "";
        $post_data = json_decode(stripslashes(file_get_contents('php://input')), true);

        $tanggal = $post_data['tgl'];
        $bulan = date('m', strtotime($tanggal));
        $tahun = date('Y', strtotime($tanggal));
        $waktu =  $post_data['jam_trans'];
//date('Y-m-d H:i:s');

        $cek = $modecek->get_nosetortabungan($bulan, $tahun);
        $jns = '02';
        $description = $post_data['keterangan'];

        $nourut = $cek['kin_srno'];
        $rekening = $post_data['norek'];
   
        $empcode = $post_data['collector_id'];
        $kodecabang = '';
        $cond = array('emp_code' => $empcode);
        $dbemployee = $mcore->_get_petugas($cond)->getRow();

        $emp_name = $dbemployee->nama_petugas;
        $bnk_code = $dbemployee->kode_kas;
        $kodecabang = $dbemployee->unit_kerja;
        if ($bnk_code == '') {
         //   $res['message'] = 'Petugas tidak terdaftar';
          //  $res['status'] = 'error';
          //  return $this->respond($res, 404);
        }
        
            $dbbank = $modecek->get_bank($bnk_code);
            $acc_cash = $dbbank['acc_code'];

            $sldawal = $mcore->saldotabungan($rekening);
            $kin_awal = 0;
            foreach ($sldawal->getResult() as $awal) {
                $kin_awal = $awal->kin_awal;
            }
            $cek1 = $mgit->_get_datatabunganab($rekening);
            $agt_numb = '';
            $agt_name = '';
            $prd_code = '';
            $acc_prod = '';
            $acc_admn = '';

            foreach ($cek1->getResult() as $cekrow) {
                $agt_numb = $cekrow->agt_numb;
                $agt_name = $cekrow->agt_name;
		$emp_name = $agt_name;

                $prd_code = $cekrow->prd_code;
                $prd_name = $cekrow->prd_name;
                $acc_prod = $cekrow->acc_code;
                $acc_admn = $cekrow->acc_cod2;
                // $kodecabang = $cekrow->kode_cabang;
            }
            // $rekening = $cek1['tbg_code'];

            $xprod1 = $prd_code;
            $xprod = substr($xprod1, 0, 1);

            // $description = 'Setoran ' . $prd_name . ' - ' . $agt_name;
            $description1 = 'Setoran ' . $prd_name;

            // }
            if ($nourut == '') {
                $nourut = 1;
                $v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . '00001';
            } else {
                $nourut = $nourut + 1;
                if ($nourut < 10) {
                    $v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . '0000' . $nourut;
                } else if ($nourut >= 10 and $nourut < 100) {
                    $v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . '000' . $nourut;
                } else if ($nourut >= 100 and $nourut < 1000) {
                    $v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . '00' . $nourut;
                } else if ($nourut >= 1000 and $nourut < 10000) {
                    $v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . '0' . $nourut;
                } else {
                    $v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . $nourut;
                }
            }


            $kin_stot = str_replace(',', '', $post_data['nominal']);
        $kin_admn = str_replace(',', '', $post_data['admin']);

            $kin_totl = $kin_stot+$kin_admn;//str_replace(',', '', $post_data['jnominal']);
            // $kin_awal = 0;
            $v_dbt_amnt = 0;
            $v_crd_amnt = 0;
            $cektanggal = $modecek->_get_tgltabungan1($rekening, $tanggal);
            $kin_code = $cektanggal['kin_code'];
            $kin_dat1 = $cektanggal['kin_dat1'];
            $kin_dat2 = $cektanggal['kin_date'];



            // }
            if ($jns == '01') {
                $debcrt = 'K';
                $v_crd_amnt = $kin_totl;
                $v_dbt_amnt = 0;
            } else {
                $debcrt = 'D';
                $v_dbt_amnt = $kin_totl;
                $v_crd_amnt = 0;
            }

            if ($kin_code == '') {
                $kin_gtot = $kin_totl;
                // $kin_awal = 0;
                $kin_dat1 = $cektanggal['kin_date'];
                $jmlhari = (($tanggal - $kin_dat1) / 60 / 60 / 24);
            } else {
                $kin_dat1 = $cektanggal['kin_date'];
                // $kin_awal = $cektanggal['kin_akhr'];
                $kin_gtot = $kin_awal + $v_crd_amnt - $v_dbt_amnt;
                // $kin_dat1 = date('Y-m-d', strtotime($kin_dat1));
                $tanggl2 = strtotime($tanggal);
                $tanggl1 = strtotime($kin_dat1);
                $jmlhari = (($tanggl2 - $tanggl1) / 60 / 60 / 24);
            }
            $kin_akhr = $kin_awal - $v_dbt_amnt + $v_crd_amnt;
            $data = array(
                'kin_code' => $v_trx_code,
                //$this->request->getvar('norek'),
                'kin_date' => $post_data['tgl'],
                'agt_numb' => $agt_numb,
                'bnk_code' => $bnk_code,
                'acc_cash' => $acc_cash,
                'kin_type' => $prd_code,
                'kin_desc' => $description,
                'kin_note' => $note,
                'kin_stot' => $kin_stot,

                'acc_admn' => $acc_admn,
                'acc_prod' => $acc_prod,
                'tbg_code' => $rekening,
                'kin_mont' => $bulan,
                'kin_year' => $tahun,
		'kin_admn' => $kin_admn,
                'kin_totl' => $kin_totl,
                'kin_srno' => $nourut,
                'kin_jens' => '09',
                'kin_nstr' => 0,
                'kin_astr' => 0,
                'kin_prem' => 0,
                'kin_pajk' => 0,
                'kin_marg' => 0,
                'acc_prem' => '',
                'acc_pajk' => '',
                'acc_marg' => '',
                'kin_mstr' => 0,
                'kin_debt' => $v_dbt_amnt,
                'kin_crdt' => $v_crd_amnt,
                'kin_dbcr' => $debcrt,
                'kin_stat' => 0,
                'com_code' => 1,

                'trx_jens' => '09',
                'kode_cabang' => $kodecabang,
                'kin_gtot' => $kin_gtot,
                'kin_awal' => $kin_awal,
                'kin_akhr' => $kin_akhr,
                'kin_time' => $waktu,
                'kin_user' => $emp_name,

            );

            $model->_savesetortabungan($data);



            $data = array(
                'kin_dat1' => $post_data['tgl'],
                'kin_hari' => $jmlhari,
                // 'kin_apus' => $kin_dat1,
            );

            $model->_updatetabungantgl($data, $kin_code);


            // Jurnal
            if ($jns == '01') {
                $v_trx_dbcr = 'D';
                $v_trx_debt = $kin_totl;
                $v_trx_crdt = 0;
            } else {
                $v_trx_dbcr = 'K';
                $v_trx_debt = 0;
                $v_trx_crdt = $kin_totl;
            }
            if ($jns == '01') {
                if ($xprod == '3') {
                    $cabang = $kodecabang;
                    if ($cabang != '100') {
                        $cabcod12 = '100';
                    } else {
                        $cabcod12 = $kodecabang;
                    }
                } else {
                    $cabcod12 = $kodecabang;
                }
            } else {
                $cabcod12 = $kodecabang;
            }

            // Jurnal

            if ($jns == '01') {
                $v_trx_dbcr = 'K';
                $v_trx_debt = 0;
                $v_trx_crdt = $kin_totl;
            } else {
                $v_trx_dbcr = 'D';
                $v_trx_debt = $kin_totl;
                $v_trx_crdt = 0;
            }

            $data = array(
                'trx_code' => $v_trx_code,
                //$this->request->getvar('norek'),
                'trx_date' => $post_data['tgl'],
                'acc_code' => $acc_prod,
                'trx_jens' => '01',
                'trx_urut' => 1,
                'trx_dbcr' => 'D',
                'trx_amnt' => $kin_totl,
                'dbt_amnt' => $kin_totl,
                'crd_amnt' => 0,
                'trx_des1' => $description,
                'trx_des2' => $description1,
                'com_code' => 1,
                'kode_cabang' => $cabcod12,
                'ent_time' => $waktu,
                'usercreated' => $emp_name,
            );
            $model->_savejurnal($data);


 // Jurnal
        $id = "20";
        $dbppob = $modecek->get_acckhusus($id);
        $acc_ppob = $dbppob['acc_code'];

        $data = array(
            'trx_code' => $v_trx_code,
            //$this->request->getvar('norek'),
            'trx_date' => $post_data['tgl'],
            'acc_code' => $acc_ppob,
            'trx_jens' => '01',
            'trx_urut' => 1,
            'trx_dbcr' => 'K',
            'trx_amnt' => $kin_stot,
            'dbt_amnt' => 0,
            'crd_amnt' => $kin_stot,
            'trx_des1' => $description,
            'trx_des2' => 'Deposit ' . $description1,
            'com_code' => 1,
            'kode_cabang' => $kodecabang,
            'ent_time' => $waktu,
            'usercreated' => $emp_name,
        );
        $model->_savejurnal($data);
        $id = "21";
        $dbppob = $modecek->get_acckhusus($id);
        $acc_admn = $dbppob['acc_code'];
        $data = array(
            'trx_code' => $v_trx_code,
            //$this->request->getvar('norek'),
            'trx_date' => $post_data['tgl'],
            'acc_code' => $acc_admn,
            'trx_jens' => '01',
            'trx_urut' => 1,
            'trx_dbcr' => 'K',
            'trx_amnt' => $kin_admn,
            'dbt_amnt' => 0,
            'crd_amnt' => $kin_admn,
            'trx_des1' => "Administrasi PPOB",
            'trx_des2' => 'Administrasi PPOB',
            'com_code' => 1,
            'kode_cabang' => $kodecabang,
            'ent_time' => $waktu,
            'usercreated' => $emp_name,
        );
        $model->_savejurnal($data);
            // Magin

            $id = $rekening;



            if ($rekening == '') {
                if ($jns == '01') {

                    $vstatus = '1';
                    $data = array(

                        'tbg_stat' => $vstatus,
                        'tbg_aktv' => $post_data['tgl'],
                        'tbg_awal' => $kin_stot,

                    );
                    $model->_updatetabungan($data, $id);
                }
            }



            

            $data = $mcore->_get_simpanantransppob($v_trx_code)->getResult();
            if ($data) {
                //$saldo_akhir_pinjaman = $rek_akhir[0]->sisa_pinjaman;
                $response['status'] = 'Berhasil';
				$response['message'] = 'Transaksi PPOB Berhasil';
                return $this->respond($response, 200);
            } else {
                $response['status'] = 'error';
                $response['message'] = 'No data found';
                return $this->respond($response, 404);
            };
       
    }
//End transaksi PPOB

// API Topup Virtual Account
 public function topupvirtualaccount()
    {
        if (!$this->tokenValid) {
            return $this->respond('Invalid Token', 401);
        }
        $model = new Save_model();
        $mgit = new Model_git();
        $modecek = new Auto_model();
        $mcore = new Core_model();
        $note = "";
        $post_data = json_decode(stripslashes(file_get_contents('php://input')), true);

        $tanggal = $post_data['tgl'];
        $bulan = date('m', strtotime($tanggal));
        $tahun = date('Y', strtotime($tanggal));
        $waktu = $post_data['jam_trans'];;//date('Y-m-d H:i:s');

        $cek = $modecek->get_nosetortabungan($bulan, $tahun);
        $jns = '01';
        $description = $post_data['keterangan'];

        $nourut = $cek['kin_srno'];
        $rekening = $post_data['norek'];
       // $rektujuan = $post_data['rektujuan'];
        $empcode = $post_data['collector_id'];
        $kodecabang = '';
        $cond = array('emp_code' => $empcode);
        $dbemployee = $mcore->_get_petugas($cond)->getRow();

        $emp_name = $dbemployee->nama_petugas;
        $bnk_code = $dbemployee->kode_kas;
        $kodecabang = $dbemployee->unit_kerja;
        if ($bnk_code == '') {
         //   $res['message'] = 'Petugas tidak terdaftar';
          //  $res['status'] = 'error';
          //  return $this->respond($res, 404);
        }
        
            $dbbank = $modecek->get_bank($bnk_code);
            $acc_cash = $dbbank['acc_code'];

            $sldawal = $mcore->saldotabungan($rekening);
            $kin_awal = 0;
            foreach ($sldawal->getResult() as $awal) {
                $kin_awal = $awal->kin_awal;
            }
            $cek1 = $mgit->_get_datatabunganab($rekening);
            $agt_numb = '';
            $agt_name = '';
            $prd_code = '';
            $acc_prod = '';
            $acc_admn = '';

            foreach ($cek1->getResult() as $cekrow) {
                $agt_numb = $cekrow->agt_numb;
                $agt_name = $cekrow->agt_name;
		$emp_name = $agt_name;

                $prd_code = $cekrow->prd_code;
                $prd_name = $cekrow->prd_name;
                $acc_prod = $cekrow->acc_code;
                $acc_admn = $cekrow->acc_cod2;
                // $kodecabang = $cekrow->kode_cabang;
            }
            // $rekening = $cek1['tbg_code'];

            $xprod1 = $prd_code;
            $xprod = substr($xprod1, 0, 1);

            // $description = 'Setoran ' . $prd_name . ' - ' . $agt_name;
            $description1 = 'Setoran ' . $prd_name;

            // }
            if ($nourut == '') {
                $nourut = 1;
                $v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . '00001';
            } else {
                $nourut = $nourut + 1;
                if ($nourut < 10) {
                    $v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . '0000' . $nourut;
                } else if ($nourut >= 10 and $nourut < 100) {
                    $v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . '000' . $nourut;
                } else if ($nourut >= 100 and $nourut < 1000) {
                    $v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . '00' . $nourut;
                } else if ($nourut >= 1000 and $nourut < 10000) {
                    $v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . '0' . $nourut;
                } else {
                    $v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . $nourut;
                }
            }


            $kin_stot = str_replace(',', '', $post_data['nominal']);
        $kin_admn = str_replace(',', '', $post_data['admin']);

            $kin_totl = $kin_stot+$kin_admn;//str_replace(',', '', $post_data['jnominal']);
            // $kin_awal = 0;
            $v_dbt_amnt = 0;
            $v_crd_amnt = 0;
            $cektanggal = $modecek->_get_tgltabungan1($rekening, $tanggal);
            $kin_code = $cektanggal['kin_code'];
            $kin_dat1 = $cektanggal['kin_dat1'];
            $kin_dat2 = $cektanggal['kin_date'];



            // }
            if ($jns == '01') {
                $debcrt = 'K';
                $v_crd_amnt = $kin_totl;
                $v_dbt_amnt = 0;
            } else {
                $debcrt = 'D';
                $v_dbt_amnt = $kin_totl;
                $v_crd_amnt = 0;
            }

            if ($kin_code == '') {
                $kin_gtot = $kin_totl;
                // $kin_awal = 0;
                $kin_dat1 = $cektanggal['kin_date'];
                $jmlhari = (($tanggal - $kin_dat1) / 60 / 60 / 24);
            } else {
                $kin_dat1 = $cektanggal['kin_date'];
                // $kin_awal = $cektanggal['kin_akhr'];
                $kin_gtot = $kin_awal + $v_crd_amnt - $v_dbt_amnt;
                // $kin_dat1 = date('Y-m-d', strtotime($kin_dat1));
                $tanggl2 = strtotime($tanggal);
                $tanggl1 = strtotime($kin_dat1);
                $jmlhari = (($tanggl2 - $tanggl1) / 60 / 60 / 24);
            }
            $kin_akhr = $kin_awal - $v_dbt_amnt + $v_crd_amnt;
            $data = array(
                'kin_code' => $v_trx_code,
                //$this->request->getvar('norek'),
                'kin_date' => $post_data['tgl'],
                'agt_numb' => $agt_numb,
                'bnk_code' => $bnk_code,
                'acc_cash' => $acc_cash,
                'kin_type' => $prd_code,
                'kin_desc' => $description,
                'kin_note' => $note,
                'kin_stot' => $kin_stot,

                'acc_admn' => $acc_admn,
                'acc_prod' => $acc_prod,
                'tbg_code' => $rekening,
                'kin_mont' => $bulan,
                'kin_year' => $tahun,
		'kin_admn' => $kin_admn,
                'kin_totl' => $kin_totl,
                'kin_srno' => $nourut,
                'kin_jens' => '09',
                'kin_nstr' => 0,
                'kin_astr' => 0,
                'kin_prem' => 0,
                'kin_pajk' => 0,
                'kin_marg' => 0,
                'acc_prem' => '',
                'acc_pajk' => '',
                'acc_marg' => '',
                'kin_mstr' => 0,
                'kin_debt' => $v_dbt_amnt,
                'kin_crdt' => $v_crd_amnt,
                'kin_dbcr' => $debcrt,
                'kin_stat' => 0,
                'com_code' => 1,

                'trx_jens' => '09',
                'kode_cabang' => $kodecabang,
                'kin_gtot' => $kin_gtot,
                'kin_awal' => $kin_awal,
                'kin_akhr' => $kin_akhr,
                'kin_time' => $waktu,
                'kin_user' => $emp_name,

            );

            $model->_savesetortabungan($data);



            $data = array(
                'kin_dat1' => $post_data['tgl'],
                'kin_hari' => $jmlhari,
                // 'kin_apus' => $kin_dat1,
            );

            $model->_updatetabungantgl($data, $kin_code);


            // Jurnal
            if ($jns == '01') {
                $v_trx_dbcr = 'D';
                $v_trx_debt = $kin_totl;
                $v_trx_crdt = 0;
            } else {
                $v_trx_dbcr = 'K';
                $v_trx_debt = 0;
                $v_trx_crdt = $kin_totl;
            }
            if ($jns == '01') {
                if ($xprod == '3') {
                    $cabang = $kodecabang;
                    if ($cabang != '100') {
                        $cabcod12 = '100';
                    } else {
                        $cabcod12 = $kodecabang;
                    }
                } else {
                    $cabcod12 = $kodecabang;
                }
            } else {
                $cabcod12 = $kodecabang;
            }

            // Jurnal

            if ($jns == '01') {
                $v_trx_dbcr = 'K';
                $v_trx_debt = 0;
                $v_trx_crdt = $kin_stot;
            } else {
                $v_trx_dbcr = 'D';
                $v_trx_debt = $kin_stot;
                $v_trx_crdt = 0;
            }

            $data = array(
                'trx_code' => $v_trx_code,
                //$this->request->getvar('norek'),
                'trx_date' => $post_data['tgl'],
                'acc_code' => $acc_prod,
                'trx_jens' => '01',
                'trx_urut' => 1,
                'trx_dbcr' => $v_trx_dbcr,
                'trx_amnt' => $kin_stot,
                'dbt_amnt' => $v_trx_debt,
                'crd_amnt' => $v_trx_crdt,
                'trx_des1' => $description,
                'trx_des2' => $description1,
                'com_code' => 1,
                'kode_cabang' => $cabcod12,
                'ent_time' => $waktu,
                'usercreated' => $emp_name,
            );
            $model->_savejurnal($data);


 // Jurnal
        $id = "20";
        $dbppob = $modecek->get_acckhusus($id);
        $acc_ppob = $dbppob['acc_code'];

        $data = array(
            'trx_code' => $v_trx_code,
            //$this->request->getvar('norek'),
            'trx_date' => $post_data['tgl'],
            'acc_code' => $acc_ppob,
            'trx_jens' => '01',
            'trx_urut' => 1,
            'trx_dbcr' => 'D',
            'trx_amnt' => $kin_totl,
            'dbt_amnt' => $kin_totl,
            'crd_amnt' => 0,
            'trx_des1' => $description,
            'trx_des2' => 'Deposit ' . $description1,
            'com_code' => 1,
            'kode_cabang' => $kodecabang,
            'ent_time' => $waktu,
            'usercreated' => $emp_name,
        );
        $model->_savejurnal($data);
        $id = "21";
        $dbppob = $modecek->get_acckhusus($id);
        $acc_admn = $dbppob['acc_code'];
        $data = array(
            'trx_code' => $v_trx_code,
            //$this->request->getvar('norek'),
            'trx_date' => $post_data['tgl'],
            'acc_code' => $acc_admn,
            'trx_jens' => '01',
            'trx_urut' => 1,
            'trx_dbcr' => 'K',
            'trx_amnt' => $kin_admn,
            'dbt_amnt' => 0,
            'crd_amnt' => $kin_admn,
            'trx_des1' => "Administrasi PPOB",
            'trx_des2' => 'Administrasi PPOB',
            'com_code' => 1,
            'kode_cabang' => $kodecabang,
            'ent_time' => $waktu,
            'usercreated' => $emp_name,
        );
        $model->_savejurnal($data);
            // Magin

            $id = $rekening;



            if ($rekening == '') {
                if ($jns == '01') {

                    $vstatus = '1';
                    $data = array(

                        'tbg_stat' => $vstatus,
                        'tbg_aktv' => $post_data['tgl'],
                        'tbg_awal' => $kin_stot,

                    );
                    $model->_updatetabungan($data, $id);
                }
            }



         

            $data = $mcore->_get_simpanantransppob($v_trx_code)->getResult();
            if ($data) {
                //$saldo_akhir_pinjaman = $rek_akhir[0]->sisa_pinjaman;
                $response['status'] = 'Berhasil';
				$response['message'] = 'Transaksi PPOB Berhasil';
                $response['data'] = $data;
                return $this->respond($response, 200);
            } else {
                $response['status'] = 'error';
                $response['message'] = 'No data found';
                return $this->respond($response, 404);
            };
       
    }
//End topupvirtualaccount

//Start Pendaftaran Anggota
public function pendaftarananggota()
  {
    $model = new Save_model();

     $mcore=new Core_model();
    $post_data = json_decode(stripslashes(file_get_contents('php://input')), true);
  

    $tanggal = $post_data['tanggal'];
    $days1 = date('d', strtotime($tanggal));
    $tgllahir = $post_data['tgl_lahir'];
    $bulan = date('m', strtotime($tgllahir));
    $tahun = date('y', strtotime($tgllahir));
    $days = date('d', strtotime($tgllahir));
  

    $kodecabang = $post_data['kantor_id'];
    $dbcabang = $mcore->_get_cabang($kodecabang);
    $kodewilayah="";

    foreach ($dbcabang->getResult() as $row) {
        $kodewilayah = $row->wil_code;
    }
    $noktp = substr(trim($post_data['no_ktp']), -3);
    $sexcode = $post_data['jenis_kelamin'];
    $grade =$post_data['jenis_Kenanggotaan'];
    $v_trx_code = $kodewilayah . '.' . $tahun . '.' . $bulan . '.' . $days . '.' . $noktp . '.' . $sexcode . '.' . $grade;
    $v_trx_cod2 = $kodewilayah . $tahun  . $bulan . $days . $noktp . $sexcode . $grade;
   
    $data = array(
      'id'        => $v_trx_cod2, //$this->request->getPost('agt_numb'),
      'agt_numb'        => $v_trx_cod2, //$this->request->getPost('agt_numb'),
      'agt_num1'        => $v_trx_cod2.'.0',
      'agt_name'       => $post_data['nama'],
      'agt_tlhr'       => $post_data['tempat_lahir'],
      'agt_dlhr'       => $post_data['tgl_lahir'],
      'agt_adrs'       => $post_data['alamat'],
      'sex_code'       => $post_data['jenis_kelamin'],
      'agt_phon'       => $post_data['no_telepon'],
      'agt_mail'       =>  $post_data['email'],
      'agt_nktp'       =>   $post_data['no_ktp'],
      // 'dep_code'       => $this->request->getPost('dep_code'),
    //   'dep_name'       => '',
    //   'grd_code'       => '',
    //   'emp_code'       => $this->request->getPost('emp_code'),
    //   'agt_bpjs'       => $this->request->getPost('agt_bpjs'),
    
    //   'agt_nokk'       => $this->request->getPost('agt_nokk'),
    //   'agt_npwp'       => $this->request->getPost('agt_npwp'),
    //   'bnk_rekg'       => $this->request->getPost('bnk_rekg'),
    //   'agt_nban'       => $this->request->getPost('agt_nban'),
    //   'agt_nrek'       => $this->request->getPost('agt_nrek'),
    //   'bnk_cabg'       => $this->request->getPost('bnk_cabg'),
      'agt_jdat'       => $tanggal,
      'kode_cabang'       =>$kodecabang,
      'agt_aday'       => $days1,
      'agt_stat' => '0',
    );
    $model->_saveanggota($data);

    // $data = $mcore->_get_anggota($v_trx_cod2)->getResult();
    if ($data) {
        //$saldo_akhir_pinjaman = $rek_akhir[0]->sisa_pinjaman;
        $response['status'] = 'Berhasil';
        $response['message'] = 'No Calon Anggota '.$v_trx_cod2.'.0'  ;
        // $response['data'] = $data;
        return $this->respond($response, 200);
    } else {
        $response['status'] = 'error';
        // $response['message'] = 'No data found';
        return $this->respond($response, 404);
    };
  //  return redirect()->to('master/anggota')->with('success', 'Tambah Data Berhasil');
  }


// E-Credit

public function rekeningpinjaman()
  {

 
    $model = new Save_model();
    $modecek = new Auto_model();
    $mcore = new Core_model();
       if (!$this->tokenValid) {
          return $this->respond('Invalid Token', 401);
       }
     $post_data = json_decode(file_get_contents('php://input'), true);
    $tanggal = $post_data['tanggal_trans'];
    $nomoranggota= $post_data['nomoranggota'];
    $namaanggota= $post_data['namaanggota'];
    
    $bulan = date('m', strtotime($tanggal));
    $tahun = date('Y', strtotime($tanggal));
    
    $kodecabang = trim($post_data['kantor_id']);
    $kodeproduct = trim($post_data['product_id']);
    
    $gracepriode=$post_data['grace_periode'];
    $tanggalawalanguran=$post_data['tanggal_awalangsuran'];
    $nopengajuan=$post_data['nopengajuan'];
    $jangkawaktu=$post_data['jangka_waktu'];
    $margin=$post_data['bunga'];
    $jenisangsuran=$post_data['jenis_angsuran'];

    $dbcabang = $mcore->_get_cabang($kodecabang);
    $kodewilayah="";

    
    
    foreach ($dbcabang->getResult() as $row) {
        $kodewilayah = $row->wil_code;
    }
    if ($kodewilayah=='') {
        $response['status'] = 'error';
        $response['message'] = 'Kantor id tidak ada';
        return $this->respond($response, 404);
    }
    $cek = $modecek->get_nokontrak($kodewilayah, $kodeproduct);
    
    
if (empty($cek['knt_srno'])){
  $nourut = "";
} else {
  $nourut = $cek['knt_srno'];
}

    if ($nourut == '') {
      $nourut = 1;
      $v_trx_code = $kodeproduct . '.' . $kodewilayah . '.0000001';
     

      $v_trx_urut= $kodeproduct  . $kodewilayah . '0000001';
    } else {
      $nourut = $nourut + 1;
      if ($nourut < 10) {
        $v_trx_code = $kodeproduct . '.' . $kodewilayah . '.000000' . $nourut;
        $v_trx_urut = $kodeproduct  . $kodewilayah . '000000' . $nourut;
      } else if ($nourut >= 10 and $nourut < 100) {
        $v_trx_code = $kodeproduct . '.' . $kodewilayah . '.00000' . $nourut;
        $v_trx_urut = $kodeproduct  . $kodewilayah . '00000' . $nourut;
      } else if ($nourut >= 100 and $nourut < 1000) {
        $v_trx_code = $kodeproduct . '.' . $kodewilayah . '.0000' . $nourut;
        $v_trx_urut = $kodeproduct  . $kodewilayah . '0000' . $nourut;
      } else if ($nourut >= 1000 and $nourut < 10000) {
        $v_trx_code = $kodeproduct . '.' . $kodewilayah . '.000' . $nourut;
        $v_trx_urut = $kodeproduct  . $kodewilayah . '000' . $nourut;
      } else if ($nourut >= 10000 and $nourut < 100000) {
        $v_trx_code = $kodeproduct . '.' . $kodewilayah . '.00' . $nourut;
        $v_trx_urut = $kodeproduct  . $kodewilayah . '00' . $nourut;
      } else if ($nourut >= 100000 and $nourut < 1000000) {
        $v_trx_code = $kodeproduct . '.' . $kodewilayah . '.0' . $nourut;
        $v_trx_urut = $kodeproduct  . $kodewilayah . '0' . $nourut;
      } else {
        $v_trx_code = $kodeproduct . '.' . $kodewilayah . '.' . $nourut;
        $v_trx_urut = $kodeproduct  . $kodewilayah  . $nourut;
      }
    }

 
 
    
    // $periode = $post_data['jangka_waktu'];
    $tgljty=date('Y-m-d', strtotime('+' .$jangkawaktu. ' month', strtotime($tanggalawalanguran))-1);

 

   // $tgljty1=new DateTime($tgljty);

    // $tglakhir=new date('Y-m-d',strtotime($tgljty));
    // $tgljty = date('Y-m-d', strtotime('+' .($jangkawaktu . 'month', strtotime($tanggalawalanguran))));

    //$tgljtx = $post_data['tanggal_akhirpinjaman'];
   
    //$tgljty = substr($tgljtx, 6, 4) . '/' . substr($tgljtx, 3, 2) . '/' . substr($tgljtx, 0, 2);
    // $tgljtx = strtotime('30/04/2024'];
    // $jumlahhari=date_diff($tanggalawalanguran, $tgljty1);
//    $jumlahhari=($tgljty-$tanggalawalanguran);
    $hari = date('d',strtotime($tgljty));
    
    // $tgljty = $tahun  . '-' . $bulan . '-' . $hari;
 

    $days = is_integer($hari);
    $kin_totl = str_replace(',', '', $post_data['Jumlah_pinjaman']);
    $kon_prov = 0;//str_replace(',', '', $post_data['knt_prov']);
    $knt_admn = str_replace(',', '', $post_data['potongan_adminstrasi']);
    $knt_asrn = 0;//str_replace(',', '', $post_data['knt_asrn']);
    $knt_tdan = 0;//str_replace(',', '', $post_data['knt_tdan']);
    $knt_matr = str_replace(',', '', $post_data['Matrerai']);
    $knt_lain = str_replace(',', '', $post_data['Potongan_lain']);
    
    $knt_tpot = $knt_admn+$knt_matr+$knt_lain;//str_replace(',', '', $post_data['knt_tpot']);
    
    $knt_tot1 = $kin_totl-$knt_tpot;//str_replace(',', '', $post_data['knt_tot1']);
    
    $knt_pden = 0;//str_replace(',', '', $post_data['knt_pden']);
    $knt_nden = 0;//str_replace(',', '', $post_data['knt_nden']);
    $knt_angs = str_replace(',', '', $post_data['Jumlah_angsuran']);
    $knt_tmar = (($margin/$jangkawaktu)*$kin_totl)/100;
    $knt_angp = str_replace(',', '', $post_data['angsuran_pokok']);
    $knt_angb = str_replace(',', '', $post_data['angsuran_bunga']);
    $knt_agun = str_replace(',', '', $post_data['nilai_agunan']);
    $knt_notr =0;//= str_replace(',', '', $post_data['knt_notr']);
    $knt_asrk = 0;//str_replace(',', '', $post_data['knt_asrk']);


    $data = array(
      'id'       => $v_trx_urut, //request->getPost('knt_code'),
      'knt_code'       => $v_trx_code, //request->getPost('knt_code'),
      'knt_date'       => $post_data['tanggal_trans'],
      'agt_numb'       => $nomoranggota,
      'png_code'       => $nopengajuan,
      'prd_code'       => $post_data['product_id'],
      'bng_type'       => $post_data['jenis_bunga'],
      'knt_tnid'       => $jangkawaktu,
      'knt_tenr'       => $jangkawaktu,
      'knt_totl'       => $kin_totl,
      'knt_marg'       => $margin,
      //'smd_code'       => $post_data['smd_code'],
      'knt_desc'       => $namaanggota,
      'knt_prov'       => $kon_prov,
      'knt_admn'       => $knt_admn,
      'knt_asrn'       => $knt_asrn,
      'knt_tdan'       => $knt_tdan,
      'knt_matr'       => $knt_matr,
      'knt_lain'       => $knt_lain,
      'knt_tpot'       => $knt_tpot,
      'knt_tot1'       => $knt_tot1,
      'knt_gper'       => $tanggalawalanguran,
      'knt_angs'       => $knt_angs,
      'knt_angb'       => $knt_angb,
      'knt_agun'       => $knt_agun,
      'knt_angp'       => $knt_angp,
      'knt_jtdt'       => $tgljty,
      'knt_pden'       => $knt_pden,
      'knt_nden'       => $knt_nden,
      'knt_mont'       => $bulan,
      'knt_year'       => $tahun,
      'knt_srno'       => $nourut,
      // 'knt_code'       => $v_trx_code,
      'knt_days'       => $days,
      'knt_grac'       => $gracepriode,
      'tbg_code'       => $post_data['rektabungan'],
      'knt_tmar'       => $knt_tmar,
      //'knt_nmrg'       => $post_data['knt_nmrg'],
      'knt_asrk'       => $knt_asrk, //$post_data['knt_asrk'],
      'knt_notr'       => $knt_notr,
      'com_code'       => 1,
      'kode_cabang'  =>  $kodecabang,
    //   'emp_code'  => $post_data['emp_code'],
    //   'kel_code'  => $post_data['kel_code'],
    //   'col_code'  => $post_data['col_code'],
      'knt_stat' => 0,
      'knt_jang' => $jenisangsuran,
      'knt_hari' => $hari,
      'knt_fnam' => $post_data['nama_keluarga1'],
      'knt_fad1' => $post_data['alamat_keluarga1'],
      'knt_fhp1' => $post_data['nokontak1'],
      'knt_fhub1' => $post_data['hubungan_keluarga1'],
      'knt_fnm2' => $post_data['nama_keluarga2'],
      'knt_fad2' => $post_data['alamat_keluarga2'],
      'knt_fhp2' => $post_data['nokontak2'],
      'knt_fhub2' => $post_data['hubungan_keluarga2'],
      'wil_code'=>$kodewilayah,
    );

    $model->_savekontrak($data);


    
    //-----end save header-----
    //----- Kartu Debitur-----


    $tgljt = $tgljty;

    if ($jenisangsuran==1){
        $jumlah=$hari;
    } else if ($jenisangsuran==2){
        $jumlah=$jangkawaktu*4;

    } else if ($jenisangsuran==3){
        $jumlah=$jangkawaktu*2;
    } else  {
        $jumlah=$jangkawaktu+1;
    }
$knt_poko=$kin_totl;
    for ($x = 0; $x < $jumlah; $x++) {
       //   $kode = $post_data['angsuranke[' . $x . ']'];
    //   $knt_angp = str_replace(',', '', $post_data['pokokangsuran[' . $x . ']']);
    //   $knt_angb = str_replace(',', '', $post_data['pokokbunga[' . $x . ']']);
    //   $knt_angs = str_replace(',', '', $post_data['totansuran[' . $x . ']']);
    //   $knt_poko = str_replace(',', '', $post_data['pokokhutang[' . $x . ']']);
    if ($x==0){
        $knt_poko=$knt_poko;
        $knt_angp1= 0;    
        $knt_angb1= 0;    
        $knt_angs1= 0;    
    } else {
        $knt_poko=$knt_poko-$knt_angp;
        $knt_angp1= $knt_angp;
        $knt_angb1= $knt_angb; 
        $knt_angs1= $knt_angs;       
    }
    
    if ($jenisangsuran==1){
        $tgljtx1=date('Y-m-d', strtotime('+' .$x. ' day', strtotime($tanggalawalanguran)));
        //$jumlah=$hari;
    } else if ($jenisangsuran==2){
        //$jumlah=$jangkawaktu*4;
        $tgljtx1=date('Y-m-d', strtotime('+' .($x*7). ' day', strtotime($tanggalawalanguran)));
    
    } else if ($jenisangsuran==3){
        //$jumlah=$jangkawaktu*2;
        $tgljtx1=date('Y-m-d', strtotime('+' .($x*14). ' day', strtotime($tanggalawalanguran)));
    } else  {
        //$jumlah=$jangkawaktu;
        $tgljtx1=date('Y-m-d', strtotime('+' .$jangkawaktu. ' month', strtotime($tanggalawalanguran)));
    }

    
    //   $tgljtx1 = $post_data['tgl[' . $x . ']'];
    //   if ($kode != '') {
      //  $tgljt1 = substr($tgljtx1, 6, 4) . '/' . substr($tgljtx1, 3, 2) . '/' . substr($tgljtx1, 0, 2);
         $tgljt1 = date('Y-m-d', strtotime('+' . $x . 'month', strtotime($tgljt)));
        $data = array(

          //  'knt_code' => knt_angp$this->$v_trx_code,//request->getPost('knt_code'],
          'knt_idno' => $x,
          'knt_angp'  => $knt_angp1, //$post_data['pokokangsuran[' . $x . ']'],
          'knt_angb'  => $knt_angb1, //$post_data['pokokbunga[' . $x . ']'],
          'knt_angs'  => $knt_angs1, //$post_data['totansuran[' . $x . ']'],
          'knt_poko'  => $knt_poko, //$post_data['pokokhutang[' . $x . ']'],
          'knt_jtdt'  =>$tgljtx1,
          'knt_code'  => $v_trx_code,
        );
        $model->_savedebitur($data);

    if ($x!=0){
        $data = array(

            'trx_date' => $tanggal,
            'agt_numb' => $nomoranggota,
            'trx_jens'  => 'AR-T007',
            'trx_amnh'  => $knt_angs, //$post_data['totansuran[' . $x . ']'],
            'trx_lnsh'  => 0,
            'lns_pokk'  => 0,
            'lns_bung'  => 0,
            'trx_angk'  => $x,
            'bkt_code'  => $v_trx_code,
            'bkt_date' => $tgljt1,
            'bkt_amnh'  => $knt_angs, //$post_data['totansuran[' . $x . ']'],
            'trx_pokk'  => $knt_angp, //$post_data['pokokangsuran[' . $x . ']'],
            'trx_bung'  => $knt_angb, //$post_data['pokokbunga[' . $x . ']'],
            'trx_jtdt'  => $tgljt1,
            'trx_code' => $v_trx_code, //$post_data['knt_code'],
            'com_code'  => 1,
            'kode_cabang'  => $post_data['kantor_id'],

          );
          $model->_savekartupiutang($data);
    }
        

    //   }
    }

    // $response['status'] = 'Berhasil';
    // $response['No. Rekening'] = $v_trx_code;
    // return $this->respond($response, 200);
    // save Agunan

	// if (isset($files['phptoagunan'])) { // Ensure 'agtfoto' field exists
	// 	$uploadPath = WRITEPATH . 'assets/images/agunan/'; // Set upload directory
	// 	foreach ($files['phptoagunan'] as $file) {
	// 		if ($file->isValid() && !$file->hasMoved()) {
	// 			$newName = $file->getRandomName(); // Generate unique name
	// 			$file->move($uploadPath, $newName); // Move file to uploads folder
	// 		}
	// 	}

	// 	return redirect()->to('/')->with('success', 'Files uploaded successfully!');
	// }
	//  $files = $this->request->getFiles();
     $jumlah=1;
    for ($x = 0; $x < $jumlah; $x++) {
    
          
		// if (isset($files['phptoagunan'][$x])) {
        // //if ($datafoto != '') {
		//   $datafoto = $files['phptoagunan'];
        //   $newName = $datafoto->getRandomName();
				
        $data = array(
          'knt_code'       => $v_trx_code,
          'knt_cod1'       => $v_trx_code . '-' . $x,
          'agn_type'       => $post_data['jenisagunan'],
          'agn_numb'       => $post_data['nodokumenaguanan'],
          'agn_name'       => $post_data['atas_nama_agunan'],
          'agn_jtdt'       => $post_data['beralaku_sdtanggal'],
          'agn_adrs'       => $post_data['alamat_agunan'],
          'agn_loks'       => $post_data['lokasi_agunan'],
          'agn_jens'       => $post_data['Jenis_agunan'],
          'agn_totl'       => $knt_agun,
          'agn_idno'       => $x,
          'loc_code'       =>$post_data['lokasi_agunan'],
        //   'agn_foto' => $newName,
        //   'agn_fot1' => $newName,
         
        );
        $model->_saveagunan($data);


       // $datafoto->move('assets/images/agunan', $newName);
        // } else {
		  
        //   $data = array(
        //    'knt_code'       => $v_trx_code,
        //   'knt_cod1'       => $v_trx_code . '-' . $x,
        //   'agn_type'       => $post_data['jenisagunan'],
        //   'agn_numb'       => $post_data['nodokumenaguanan'],
        //   'agn_name'       => $post_data['atas_nama_agunan'],
        //   'agn_jtdt'       => $post_data['beralaku_sdtanggal'],
        //   'agn_adrs'       => $post_data['alamat_agunan'],
        //   'agn_loks'       => $post_data['lokasi_agunan'],
        //   'agn_jens'       => $post_data['Jenis_agunan'],
        //   'agn_totl'       => $knt_agun,
        //   'agn_idno'       => $x,
        //   'loc_code'       =>$post_data['lokasi_agunan'],
            
        //   );
        //   $model->_saveagunan($data);
        }
       
       
    //   }


    //----- end kartu Piutang----
    
    $response['status'] = 'Berhasil';
    $response['No. Rekening'] = $v_trx_code;
    return $this->respond($response, 200);

  }

  public function jenisagunan()
  {
      $model = new Core_model();
 
      if (!$this->tokenValid) {
           return $this->respond('Invalid Token', 401);
       }

     

      $data = $model->_get_jenisagunan()->getResult();
 
      if ($data) {
        $res['status'] = 'success';
        $res['data'] = $data;
        return $this->respond($res, 200);
        //return $this->respond($data);
    } else {
        $res['status'] = 'error';
        $res['message'] = 'No data found';
        return $this->respond($res, 404);
    }
  }

  public function product()
  {
      $model = new Core_model();
       if (!$this->tokenValid) {
           return $this->respond('Invalid Token', 401);
       }

    
      $id='K';
      $data = $model->_get_product($id)->getResult();
   
      if ($data) {
        $res['status'] = 'success';
        $res['data'] = $data;
        return $this->respond($res, 200);
        //return $this->respond($data);
    } else {
        $res['status'] = 'error';
        $res['message'] = 'No data found';
        return $this->respond($res, 404);
    }  }

  public function jenisangsuran()
  {
      $model = new Core_model();
       if (!$this->tokenValid) {
           return $this->respond('Invalid Token', 401);
      }
 
     
      $data = $model->_get_jenisangsuran()->getResult();
     
      if ($data) {
        $res['status'] = 'success';
        $res['data'] = $data;
        return $this->respond($res, 200);
        //return $this->respond($data);
    } else {
        $res['status'] = 'error';
        $res['message'] = 'No data found';
        return $this->respond($res, 404);
    }  }

  public function jenisbunga()
  {
      $model = new Core_model();
       if (!$this->tokenValid) {
           return $this->respond('Invalid Token', 401);
       }

          
      $data = $model->_get_jenisbunga()->getResult();
     
      if ($data) {
        $res['status'] = 'success';
        $res['data'] = $data;
        return $this->respond($res, 200);
        //return $this->respond($data);
    } else {
        $res['status'] = 'error';
        $res['message'] = 'No data found';
        return $this->respond($res, 404);
    }  }
// End E-Credit

// Angsuran Multi

public function angsuranmulti()
    {

		

        $model = new Save_model();
        $modecek = new Auto_model();
        $mcore = new Core_model();
  if (!$this->tokenValid) {
          return $this->respond('Invalid Token', 401);
       }

        $note = "";
	$post_data = json_decode(stripslashes(file_get_contents('php://input')), true);
        $petugas = $post_data['collector_mobile_id'];
        $norekening = $post_data['norek_pinjaman'];
        $tanggal = $post_data['tgl_trans'];
        $jam== $post_data['jam_trans'];

        //$dbrecord = $post_data['transaksi'];
        $json = $this->request->getJSON();
        $test=6666;
        $transaksi = $json->transaksi;

             $gtotal=0;
             $no=0;
	    foreach ($transaksi as $item) {

   	
            $angsran_ke=$item->angsuran_ke;
            $pokok =str_replace(',', '',$item->pokok);
            $bunga =str_replace(',', '',$item->bunga);
            $kin_stot =str_replace(',', '',$item->total);
            $description =$item->keterangan;
            $gtotal=$gtotal+$kin_stot;
           
     
 

        $bulan = date('m', strtotime($tanggal));
        $tahun = date('Y', strtotime($tanggal));
        $waktu = date('Y-m-d H:i:s');
      
		//cek angsuran apakah sudah pernah dibayar
		$cek_angsuran = $mcore->_get_angsuran_kartu($norekening,$angsran_ke);


		//print_r($cek_angsuran);
		if(trim($cek_angsuran->lns_code) != ''){
			$response['status'] = 'error';
			$response['message'] = 'Angsuran ke '.$angsran_ke.' status sudah lunas';
			return $this->respond($response, 401);
		}	else {
			
           
			$jenis = '01';

			
			$cek = $modecek->get_nopembiayaan($bulan, $tahun);
           if (empty($cek['kin_srno'])){
            $nourut = '';
           } else {
            $nourut = $cek['kin_srno'];
           }
			
			$rek_awal = $mcore->_get_saldopinjaman($norekening);
   
            if (empty($rek_awal[0]->sisa_pinjaman)){
                $saldo_awal_pinjaman =0;
               } else {
                $saldo_awal_pinjaman = $rek_awal[0]->sisa_pinjaman;
               }
		
       

	

			//$acc_cash = '';
			$prd_code = '';
			$prd_name = '';
			$trx_angk = '';
			$trx_jtdt = '0000-00-00';
			$trx_pokk = '';
			$trx_bung = '';
			$trx_dend = '';
			$trx_amnh = '';
			$agt_numb = '';
			$agt_name = '';
			$prd_code = '';
			$acc_prod = '';
			$acc_bung = '';
			$acc_admn = '';
			
			$kodecabang = '';
     
			$dbpinjaman = $mcore->_get_dtkartuhutang($norekening);
              
			foreach ($dbpinjaman->getResult() as $rowtrans) {
				//$acc_cash = $rowtrans->acc_code;
				$prd_code = $rowtrans->acc_code;
				$prd_name = $rowtrans->acc_code;
				$trx_angk = $rowtrans->trx_angk;
				$trx_jtdt = $rowtrans->trx_jtdt;
                
				$trx_pokk = floatval($rowtrans->trx_pokk == "" ? 0 : $rowtrans->trx_pokk );
				$trx_bung = floatval($rowtrans->trx_bung == "" ? 0 : $rowtrans->trx_bung);
               
				$trx_dend = $rowtrans->trx_dend;
               
				$trx_amnh = $rowtrans->trx_saldo;
				$agt_numb = $rowtrans->agt_numb;
				$agt_name = $rowtrans->agt_name;
                               
				$prd_code = $rowtrans->prd_code;
                $acc_prod = $rowtrans->acc_code;
               
               
				$acc_bung = $rowtrans->acc_cod1;
				$acc_admn ='';// $rowtrans->acc_cod2;
                

			    $tbg_cod1 = $rowtrans->tbg_code;
				$kodecabang = $rowtrans->kode_cabang;
                			     
			}
           
			
            $bnk_code='98';

			if ($nourut == '') {
				$nourut = 1;
				$v_trx_code = $kodecabang . '.07.' . $tahun . $bulan . '00001';
			} else {
				$nourut = $nourut + 1;
				if ($nourut < 10) {
					$v_trx_code = $kodecabang . '.07.' . $tahun . $bulan . '0000' . $nourut;
				} else if ($nourut >= 10 and $nourut < 100) {
					$v_trx_code = $kodecabang . '.07.' . $tahun . $bulan . '000' . $nourut;
				} else if ($nourut >= 100 and $nourut < 1000) {
					$v_trx_code = $kodecabang . '.07.' . $tahun . $bulan . '00' . $nourut;
				} else if ($nourut >= 1000 and $nourut < 10000) {
					$v_trx_code = $kodecabang . '.07.' . $tahun . $bulan . '0' . $nourut;
				} else {
					$v_trx_code = $kodecabang . '.07.' . $tahun . $bulan . $nourut;
				}
			}

           
			if ($no==0){
            		    $v_trx_urut=$v_trx_code;
          		 }
                        $no=$no+1;
			$kin_tadmn = 0;
			$data = array(
				'kin_idno'  =>$v_trx_urut,
				'kin_code'       => $v_trx_code, //$this->request->getvar('norek'),
				'kin_date'       => $post_data['tgl_trans'],
				'agt_numb'       => $agt_numb,
				'bnk_code'       => $bnk_code,
				'knt_code'       => $norekening,
				'kin_type'       => '01',
				'kin_desc'       => $description,
				'kin_stot'       => $kin_stot,
				'kin_admn'       => 0, //$kin_tadmn,
				'kin_jtdt'       => $trx_jtdt,
				'kin_dend'       => 0, //$trx_dend,
				'kin_angs'       => $trx_amnh,
				'prd_code'       => $prd_code,
				'kin_bung'       => $trx_bung,
				'kin_pokk'       => $trx_pokk,
				'kin_angk'       => $trx_angk,
				'kin_note'       => $note,
				'kin_totl'       => $kin_stot,
				// 'kin_gtot'       => $kin_gtot,
				'acc_cash'       => '',
				'acc_prod'       => $acc_prod,
				'acc_dend'       => '',
				'acc_admn'       => $acc_admn,
				'acc_bung'       => $acc_bung,
				'kin_tcos'       => 0,
				'kin_tprov'      => 0,
				'kin_notr'       => 0,
				'kin_jiwa'       => 0,
				'kin_kend'       => 0,
				'kin_kebk'       => 0,
				'kin_krdt'       => 0,
				'kin_dana'       => 0,
				'kin_lain'       => 0,
				'kin_matr'       => 0,
				'kin_pmat'       => 0,
				'kin_infq'       => 0,
				'kin_simw'       => 0,
				'kin_pinl'       => 0,
				'kin_tdendh'       => 0,
				'kin_ddendh'       => 0,
				'kin_tadmn'       => $kin_tadmn,
				'kin_dadmn'       => 0,
				'kin_tbungh'       => $bunga,
				'kin_dbungh'       => 0,
				'kin_tpokkh'       => $pokok,
				'kin_dpokkh'       => 0,
				'kin_rtgs'       => 0,
				'kin_tran'       => 0,
				'kin_mont'       => $bulan,
				'kin_year'       => $tahun,
				'kin_srno'  => $nourut,
				'kin_jens'  => 'K',
				'kin_stat' => '0',
				'kode_cabang' => $kodecabang,
				'com_code'  => 1,
			);

			$model->_savepembiayaan($data);

			if ($jenis == '01') {
				$id1 = $angsran_ke;
				$id = $norekening;
				$data = array(

					'trx_lnsh'  => $trx_amnh,
					'lns_pokk'  => $pokok,
					'lns_bung'  => $bunga,
					'lns_date'  => $tanggal,
					'bkt_date'  => $tanggal,
					'lns_code'  => $v_trx_code, //$this->request->getvar('norek'),
				);

				$model->_Updatekartu($data, $id, $angsran_ke);
			}
			
    
			if ($jenis == '01') {

				$data = array(
					'knt_stat'  => 1,
					// 'knt_cair'  => 1,

				);

				$model->_updatekontrak($data, $norekening);
			}

			

			$data = array(
				'trx_code' => $v_trx_urut, //$this->request->getvar('norek'),
				'trx_date' => $post_data['tgl_trans'],
				'acc_code'  => $acc_prod,
				'trx_jens'  => '01',
				'trx_urut' => 1,
				'trx_dbcr'  => 'K',
				'trx_amnt'  => $pokok,
				'dbt_amnt'  => 0,
				'crd_amnt'  => $pokok,
				'trx_des1'  => $description,
				'trx_des2'  => $description,
				'com_code'  => 1,
				'kode_cabang' => $kodecabang,
				'ent_time' => $waktu,
				'usercreated' =>$agt_name,
			);
			$model->_savejurnal($data);


         
			// Pendapatan Bunga
			$data = array(
				'trx_code' => $v_trx_urut, //$this->request->getvar('norek'),
				'trx_date' => $post_data['tgl_trans'],
				'acc_code'  => $acc_bung,
				'trx_jens'  => '01',
				'trx_urut' => 1,
				'trx_dbcr'  => 'K',
				'trx_amnt'  => $bunga,
				'dbt_amnt'  => 0,
				'crd_amnt'  => $bunga,
				'trx_des1'  => $prd_name . ' - ' . $agt_name,
				'trx_des2'  => 'Pendapatan Bunga',
				'com_code'  => 1,
				'kode_cabang' => $kodecabang,
				'ent_time' => $waktu,
				'usercreated' => $agt_name,
			);
			$model->_savejurnal($data);
			// Denda
			$denda = 0; // $trx_dend;
			if ($denda > 0) {
				$code = '02';
				$caccount = $modecek->get_acckhusus($code);
				$v_acc_code = $caccount['acc_code'];
				$data = array(
					'trx_code' => $v_trx_urut, //$this->request->getvar('norek'),
					'trx_date' => $post_data['tgl_trans'],
					'acc_code'  => $v_acc_code,
					'trx_jens'  => '01',
					'trx_urut' => 1,
					'trx_dbcr'  => 'K',
					'trx_amnt'  => $trx_dend,
					'dbt_amnt'  => 0,
					'crd_amnt'  => $trx_dend,
					'trx_des1'  => 'Denda ' . $prd_name . ' - ' . $agt_name,
					'trx_des2'  => 'Pendapatan Denda',
					'com_code'  => 1,
					'kode_cabang' => $kodecabang,
					'ent_time' => $waktu,
					'usercreated' => $agt_name,
				);
				$model->_savejurnal($data);
			}
			//admin
			// Jurnal Admin
			$admin = 0; //$kin_tadmn;
			if ($admin > 0) {
				$code = '01';
				// $caccount =  $modecek->get_acckhusus($code);

				$data = array(
					'trx_code' => $v_trx_urut, //$this->request->getvar('norek'),
					'trx_date' => $post_data['tgl_trans'],
					'acc_code'  => $acc_admn,
					'trx_jens'  => '01',
					'trx_urut' => 1,
					'trx_dbcr'  => 'K',
					'trx_amnt'  => $admin,
					'dbt_amnt'  => 0,
					'crd_amnt'  => $kin_tadmn,
					'trx_des1'  => 'Admin ' . $prd_name . ' - ' . $agt_name,
					'trx_des2'  => 'Pendapatan Admin',
					'com_code'  => 1,
					'kode_cabang' => $kodecabang,
					'ent_time' => $waktu,
					'usercreated' => $agt_name,
				);
				$model->_savejurnal($data);
			}
           

        }
    }
       
				// if ($selisih > 0) {
                    $tbg_code=$post_data['norek_tabungan'];
					$v_trx_code1 = $v_trx_code;
					$jenis = '02';

					$sldawal = $mcore->saldotabungan($tbg_code);
					$kin_awal = 0;
					foreach ($sldawal->getResult() as $awal) {
						$kin_awal = $awal->kin_awal;
					}
                   
					$cek1 = $mcore->_get_datatabunganab($tbg_code);
					$agt_numb = '';
					$agt_name = '';
					$prd_code = '';
					$acc_prod = '';
					$acc_admn = '';

					foreach ($cek1->getResult() as $cekrow) {
						$agt_numb = $cekrow->agt_numb;
						$agt_name = $cekrow->agt_name;
						$prd_code = $cekrow->prd_code;
						$prd_name = $cekrow->prd_name;
						$acc_prod = $cekrow->acc_code;
						$acc_admn = $cekrow->acc_cod2;
					}
					$xprod1 = $prd_code;
					//$xprod = substr($xprod1, 0, 1);

					// $kodecabang = session()->get('kode_cabang');
					// if ($description == '') {
					if ($jenis == '02') {

						// $description = 'Setoran ' . $prd_name . ' - ' . $agt_name;
						$description1 = 'Pembayaran Angsuran ' . $prd_name;
						
					}

					// }
                    $cek = $modecek->get_nosetortabungan($bulan, $tahun);
                    if (empty($cek['kin_srno'])){
                        $nourut = '';
                    } else {
                        $nourut = $cek['kin_srno'];
                    }
                   

					if ($nourut == '') {
						$nourut = 1;
						$v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . '00001';
                        $v_trx_urut1 = $kodecabang . '11' . $tahun . $bulan . '00001';
					} else {
						$nourut = $nourut + 1;
						if ($nourut < 10) {
							$v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . '0000' . $nourut;
                            $v_trx_urut1 = $kodecabang . '11' . $tahun . $bulan . '0000' . $nourut;
						} else if ($nourut >= 10 and $nourut < 100) {
							$v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . '000' . $nourut;
                            $v_trx_urut1 = $kodecabang . '11' . $tahun . $bulan . '000' . $nourut;
						} else if ($nourut >= 100 and $nourut < 1000) {
							$v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . '00' . $nourut;
                            $v_trx_urut1 = $kodecabang . '11' . $tahun . $bulan . '00' . $nourut;
						} else if ($nourut >= 1000 and $nourut < 10000) {
							$v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . '0' . $nourut;
                            $v_trx_urut1 = $kodecabang . '11' . $tahun . $bulan . '0' . $nourut;
						} else {
							$v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . $nourut;
                            $v_trx_urut1 = $kodecabang . '11' . $tahun . $bulan . $nourut;
						}
					}


					$kin_stot = $gtotal; //str_replace(',', '', $this->request->getvar('jumlah'));
					$kin_totl = $gtotal; //str_replace(',', '', $this->request->getvar('jumlah'));

					// $kin_awal = 0;
					$v_dbt_amnt = 0;
					$v_crd_amnt = 0;
                   
					$cektanggal = $modecek->_get_tgltabungan1($tbg_code, $tanggal);
                    $kin_code = $cektanggal['kin_code'];
                $kin_dat1 = $cektanggal['kin_dat1'];
                $kin_dat2 = $cektanggal['kin_date'];
                 
                    

                    if ($jenis == '01') {
                        $debcrt = 'K';
                        $v_crd_amnt = $kin_totl;
                        $v_dbt_amnt = 0;
                    } else {
                        $debcrt = 'D';
                        $v_dbt_amnt = $kin_totl;
                        $v_crd_amnt = 0;
                    }
    
                    if ($kin_code == '') {
                        $kin_gtot = $kin_totl;
                        // $kin_awal = 0;
                        $kin_dat1 = $cektanggal['kin_date'];
                        $jmlhari = (($tanggal - $kin_dat1) / 60 / 60 / 24);
                    } else {
                        $kin_dat1 = $cektanggal['kin_date'];
                        // $kin_awal = $cektanggal['kin_akhr'];
                        $kin_gtot = $kin_awal + $v_crd_amnt - $v_dbt_amnt;
                        // $kin_dat1 = date('Y-m-d', strtotime($kin_dat1));
                        $tanggl2 = strtotime($tanggal);
                        $tanggl1 = strtotime($kin_dat1);
                        $jmlhari = (($tanggl2 - $tanggl1) / 60 / 60 / 24);
                    }
                    $kin_akhr = $kin_awal - $v_dbt_amnt + $v_crd_amnt;
					$data = array(
                        'id' => $v_trx_urut1,
						'kin_code' => $v_trx_code,
						//$this->request->getvar('norek'),
						'kin_date' => $post_data['tgl_trans'],
						'agt_numb' => $agt_numb,
						'bnk_code' => $bnk_code,
						'acc_cash' => $acc_prod,
						'kin_type' => $prd_code,
						'kin_desc' => 'Pembayaran Angsuran Pembiayaan Via Moile',
						'kin_note' => 'Pembayaran Angsuran Pembiayaan Via Moile',
						'kin_stot' => $gtotal,

						// 'acc_admn' => $acc_admn,
						'acc_prod' => $acc_prod,
						'tbg_code' => $tbg_code,
						'kin_mont' => $bulan,
						'kin_year' => $tahun,
						'kin_totl' => $gtotal,
						'kin_srno' => $nourut,
						// 'kin_pstr' => $rektujuan,
						'kin_jens' => '02',
						'kin_nstr' => 0,
						'kin_astr' => 0,
						'kin_prem' => 0,
						'kin_pajk' => 0,
						'kin_marg' => 0,
						'acc_prem' => '',
						'acc_pajk' => '',
						'acc_marg' => '',
						'kin_mstr' => 0,
						'kin_debt' => $gtotal,
						'kin_crdt' => 0,
						'kin_dbcr' => 'D',
						'kin_stat' => 0,
						'com_code' => 1,

						'trx_jens' => '08',
						'kode_cabang' => $kodecabang,
						'kin_gtot' => $kin_gtot,
						'kin_awal' => $kin_awal,
						'kin_akhr' => $kin_akhr,
						'kin_time' => $waktu,
						'kin_user' =>$agt_name,

					);

					$model->_savesetortabungan($data);
                   
					$data = array(
						'kin_dat1' =>$post_data['tgl_trans'],
						'kin_hari' => $jmlhari,
						// 'kin_apus' => $kin_dat1,
					);

					$model->_updatetabungantgl($data, $kin_code);

					// Jurnal

					$data = array(
						'trx_code' => $v_trx_urut,
						'trx_date' => $post_data['tgl_trans'],
						'acc_code' => $acc_prod,
						'trx_jens' => '01',
						'trx_urut' => 1,
						'trx_dbcr' => 'D',
						'trx_amnt' => $gtotal,
						'dbt_amnt' => $gtotal,
						'crd_amnt' => 0,
						'trx_des1' => $description,
						'trx_des2' => $description1,
						'com_code' => 1,
						'kode_cabang' => $kodecabang,
						'ent_time' => $waktu,
						'usercreated' => $agt_name,
					);
					$model->_savejurnal($data);
    $response['Status'] = 'success';
    $response['message'] = 'Transaksi Berhasil';
    $response['data']['nobukti'] = $v_trx_code;
    return $this->respond($response, 200);    
                     
		}

// End Angsuran Multi
}
