<?php

namespace App\Controllers;

use CodeIgniter\RESTful\ResourceController;
use CodeIgniter\API\ResponseTrait;
use App\Models\Core_model;
use App\Models\Auto_model;

use App\Models\Model_git;
use App\Models\Save_model;

use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;
use Psr\Log\LoggerInterface;
use App\Models\AppToken;
use App\Models\ApiModel;
use Exception;
use Faker\Provider\Uuid;
use stdClass;

class Core extends ResourceController
{
public function __construct()
  {
    $session = session();
    date_default_timezone_set('Asia/Jakarta');
  }
    public $request;
    protected $response;
    protected $logger;

    protected $integration, $api;

    private $token = null;
    private $tokenValid = false;
    use ResponseTrait;
    // all users
    public function initController(RequestInterface $request, ResponseInterface $response, LoggerInterface $logger)
    {
        parent::initController($request, $response, $logger);

        // Load the model
        $this->integration      = new AppToken();
        $this->api      = new ApiModel();

        // Check token
        $tokenHeader = $this->request->header('token');
        $this->tokenValid = $this->checkToken($tokenHeader);
    }

    private function checkToken($tokenHeader)
    {
        if (empty($tokenHeader)) {
            return false;
        }

        $this->token = $tokenHeader->getValue();

        $check_token = $this->integration->do_check_token($this->token);
        return $check_token;
    }
    public function index()
    {
        $model = new Core_model();
        $data['anggota'] = $model->orderBy('agt_numb', 'DESC')->findAll();
        return $this->respond($data);
    }
    // create
    // single user


    public function anggota($id = null)
    {
        $model = new Core_model();
        // if (!$this->tokenValid) {
        //     return $this->respond('Invalid Token', 401);
        // }

        // $res['status'] = 'failed';
        // $res['data'] = [];
        // $id1 = $this->request->getvar('id');
        $data = $model->_get_anggota($id)->getResult();
        // $data = $model->where('agt_numb', $id)->first();
        if ($data) {
            return $this->respond($data);
        } else {
            return $this->failNotFound('Data tidak ditemukan.');
        }
    }

    public function petugas($id = null)
    {
        $model = new Core_model();
        // if (!$this->tokenValid) {
        //     return $this->respond('Invalid Token', 401);
        // }

        // $res['status'] = 'failed';
        // $res['data'] = [];
        // $id1 = $this->request->getvar('id');
        $data = $model->_get_petugas($id)->getResult();
        // $data = $model->where('agt_numb', $id)->first();
        if ($data) {
            return $this->respond($data);
        } else {
            return $this->failNotFound('Data tidak ditemukan.');
        }
    }
    public function simpanan($id = null)
    {
        $model = new Core_model();
        $data = $model->_get_tabungan($id)->getResult();
        // $data1 = $model->where('agt_numb', $id)->first();
        if ($data) {
            return $this->respond($data);
        } else {
            return $this->failNotFound('Data tidak ditemukan.');
        }
    }

    public function ceksimpanan($id = null)
    {
        $model = new Core_model();
        $data = $model->_get_tabunganrek($id)->getResult();
        // $data = $model->where('agt_numb', $id)->first();
        if ($data) {
            return $this->respond($data);
        } else {
            return $this->failNotFound('Data tidak ditemukan.');
        }
    }

    function Pinjaman($id = null)
    {

        $this->model      = new Core_model();
        // if (!$this->tokenValid) {
        //   return $this->respond('Invalid Token', 401);
        // }

        // $res['status'] = 'failed';
        // $res['data'] = [];

        $data  = $this->model->_get_pinjaman($id);
        if ($data) {
            $i = 0;
            foreach ($data as $element) {
                $data[$i]->detail_tagihan = $this->model->_get_pinjamandtl($element->norek);
                $i++;
            }

            // $res['status'] = 'success';
            $res['data'] = $data;
        } else {
            $res['message'] = 'No data found';
        }

        return $this->respond($res, 200);
    }

    public function get_pembiayaan($id = null)
    {
        $model = new Core_model();
        $data = $model->_get_pembiayaan($id)->getResult();
        // $data = $model->where('agt_numb', $id)->first();
        if ($data) {
            return $this->respond($data);
        } else {
            return $this->failNotFound('Data tidak ditemukan.');
        }
    }
    public function cekpinjaman($id = null)
    {
        $this->model      = new Core_model();
        // if (!$this->tokenValid) {
        //   return $this->respond('Invalid Token', 401);
        // }

        // $res['status'] = 'failed';
        // $res['data'] = [];

        $data  = $this->model->_get_pinjamanrek($id);
        if ($data) {
            $i = 0;
            foreach ($data as $element) {
                $data[$i]->detail_tagihan = $this->model->_get_pinjamandtl1($element->norek);
                $i++;
            }

            // $res['status'] = 'success';
            $res['data'] = $data;
        } else {
            $res['message'] = 'No data found';
        }

        return $this->respond($res, 200);
    }

    public function mutasisimpanan($id = null)
    {
        $model = new Core_model();
        $data = $model->_get_mutasisimpanan($id)->getResult();
        // $data = $model->_get_pinjamandtl()->getResult();
        // $data = $model->where('agt_numb', $id)->first();
        if ($data) {
            return $this->respond($data);
        } else {
            return $this->failNotFound('Data tidak ditemukan.');
        }
    }

    // update


    public function setorsimpanan()
    {
        $model = new Save_model();
        $mgit = new Model_git();
        $modecek = new Auto_model();
        $mcore = new Core_model();
        $note = "";
        $tanggal = $this->request->getvar('tgl');

        $bulan = date('m', strtotime($tanggal));
        $tahun = date('Y', strtotime($tanggal));
        $waktu = date('Y-m-d H:i:s');

        $cek = $modecek->get_nosetortabungan($bulan, $tahun);
        $jns = '02';
        $description = $this->request->getvar('keterangan');

        $nourut = $cek['kin_srno'];
        $rekening = $this->request->getvar('norek');
        $empcode = $this->request->getvar('colector_id');
        $kodecabang = '';
        $dbemployee = $modecek->get_employee($empcode);
        $emp_name = $dbemployee['emp_name'];
        $bnk_code = $dbemployee['bnk_code'];
        $kodecabang = $dbemployee['kode_cabang'];
        if ($bnk_code == '') {
            $response['message'] = 'Collector No  data found';
            return $this->respondCreated($response);
        }
        $dbbank = $modecek->get_bank($bnk_code);
        $acc_cash = $dbbank['acc_code'];

        $sldawal = $mcore->saldotabungan($rekening);
        $kin_awal = 0;
        foreach ($sldawal->getResult() as $awal) {
            $kin_awal = $awal->kin_awal;
        }
        $cek1 = $mgit->_get_datatabunganab($rekening);
        $agt_numb = '';
        $agt_name = '';
        $prd_code = '';
        $acc_prod = '';
        $acc_admn = '';

        foreach ($cek1->getResult() as $cekrow) {
            $agt_numb = $cekrow->agt_numb;
            $agt_name = $cekrow->agt_name;
            $prd_code = $cekrow->prd_code;
            $prd_name = $cekrow->prd_name;
            $acc_prod = $cekrow->acc_code;
            $acc_admn = $cekrow->acc_cod2;
            // $kodecabang = $cekrow->kode_cabang;
        }
        // $rekening = $cek1['tbg_code'];

        $xprod1 = $prd_code;
        $xprod = substr($xprod1, 0, 1);


        // $kodecabang = session()->get('kode_cabang');
        // if ($description == '') {
        if ($jns == '01') {

            // $description = 'Setoran ' . $prd_name . ' - ' . $agt_name;
            $description1 = 'Setoran ' . $prd_name;
            // } else if ($jns == '02') {
            //     $description = 'Penarikan Tunai ' . $prd_name . ' - ' . $agt_name;
            //     $description1 = 'Penarikan Tunai ' . $prd_name;
            // } else if ($jns == '03') {
            //     $description = 'Penutupan Rekening : ' . $prd_name . ' - ' . $agt_name;
            //     $description1 = 'Penutupan Rekening : ' . $prd_name;
            // } else {
            //     $description = $prd_name . ' - ' . $agt_name;
            //     $description1 = $prd_name;
        }

        // }
        if ($nourut == '') {
            $nourut = 1;
            $v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . '00001';
        } else {
            $nourut = $nourut + 1;
            if ($nourut < 10) {
                $v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . '0000' . $nourut;
            } else if ($nourut >= 10 and $nourut < 100) {
                $v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . '000' . $nourut;
            } else if ($nourut >= 100 and $nourut < 1000) {
                $v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . '00' . $nourut;
            } else if ($nourut >= 1000 and $nourut < 10000) {
                $v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . '0' . $nourut;
            } else {
                $v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . $nourut;
            }
        }


        $kin_stot = str_replace(',', '', $this->request->getvar('jumlah'));
        $kin_totl = str_replace(',', '', $this->request->getvar('jumlah'));
        // $kin_awal = 0;
        $v_dbt_amnt = 0;
        $v_crd_amnt = 0;
        $cektanggal = $modecek->_get_tgltabungan1($rekening, $tanggal);
        $kin_code = $cektanggal['kin_code'];
        $kin_dat1 = $cektanggal['kin_dat1'];
        $kin_dat2 = $cektanggal['kin_date'];


        // if ($kin_code == '') {
        //   $kin_gtot = $kin_totl;
        //   $jmlhari = 0;
        // } else {
        //   $kin_gtot = $cektanggal['kin_gtot'];
        //   $kin_gtot = $kin_gtot + $kin_totl;
        //   $jmlhari = (($tanggal - $kin_dat1) / 60 / 60 / 24) + 1;
        // }
        if ($jns == '01') {
            $debcrt = 'K';
            $v_crd_amnt = $kin_totl;
            $v_dbt_amnt = 0;
        } else {
            $debcrt = 'D';
            $v_dbt_amnt = $kin_totl;
            $v_crd_amnt = 0;
        }

        if ($kin_code == '') {
            $kin_gtot = $kin_totl;
            // $kin_awal = 0;
            $kin_dat1 = $cektanggal['kin_date'];
            $jmlhari = (($tanggal - $kin_dat1) / 60 / 60 / 24);
        } else {
            $kin_dat1 = $cektanggal['kin_date'];
            // $kin_awal = $cektanggal['kin_akhr'];
            $kin_gtot = $kin_awal + $v_crd_amnt - $v_dbt_amnt;
            // $kin_dat1 = date('Y-m-d', strtotime($kin_dat1));
            $tanggl2 = strtotime($tanggal);
            $tanggl1 = strtotime($kin_dat1);
            $jmlhari = (($tanggl2 - $tanggl1) / 60 / 60 / 24);
        }
        $kin_akhr = $kin_awal - $v_dbt_amnt + $v_crd_amnt;
        $data = array(
            'kin_code' => $v_trx_code,
            //$this->request->getvar('norek'),
            'kin_date' => $this->request->getvar('tgl'),
            'agt_numb' => $agt_numb,
            'bnk_code' => $bnk_code,
            'acc_cash' => $acc_cash,
            'kin_type' => $prd_code,
            'kin_desc' => $description,
            'kin_note' => $note,
            'kin_stot' => $kin_stot,

            'acc_admn' => $acc_admn,
            'acc_prod' => $acc_prod,
            'tbg_code' => $rekening,
            'kin_mont' => $bulan,
            'kin_year' => $tahun,
            'kin_totl' => $kin_totl,
            'kin_srno' => $nourut,
            'kin_jens' => '01',
            'kin_nstr' => 0,
            'kin_astr' => 0,
            'kin_prem' => 0,
            'kin_pajk' => 0,
            'kin_marg' => 0,
            'acc_prem' => '',
            'acc_pajk' => '',
            'acc_marg' => '',
            'kin_mstr' => 0,
            'kin_debt' => $v_dbt_amnt,
            'kin_crdt' => $v_crd_amnt,
            'kin_dbcr' => $debcrt,
            'kin_stat' => 0,
            'com_code' => 1,

            'trx_jens' => '01',
            'kode_cabang' => $kodecabang,
            'kin_gtot' => $kin_gtot,
            'kin_awal' => $kin_awal,
            'kin_akhr' => $kin_akhr,
            'kin_time' => $waktu,
            'kin_user' => $emp_name,

        );

        $model->_savesetortabungan($data);
        if ($jns == '2000') {
            $data = array(
                'kin_code' => $v_trx_code,
                //$this->request->getvar('norek'),
                'kin_date' => $this->request->getvar('tgl'),
                'agt_numb' => $agt_numb,
                'bnk_code' => $bnk_code,
                'acc_cash' => $acc_cash,
                'knt_code' => $this->request->getvar('norek'),
                'kin_type' => $prd_code,
                'kin_desc' => $description,
                'kin_note' => $note,
                'kin_stot' => $kin_stot,
                'kin_admn' => 0,
                'acc_admn' => $acc_admn,
                'acc_prod' => $acc_prod,
                'kin_dend' => 0,
                'kin_angs' => 0,
                'kin_bung' => 0,
                'kin_pokk' => 0,
                'kin_mont' => $bulan,
                'kin_year' => $tahun,
                'kin_totl' => $kin_totl,
                'kin_stat' => 0,
                'kin_jens' => '03',
                'com_code' => 1,
                'kode_cabang' => $kodecabang,
            );

            $model->_savesetorpembiayaan($data);
        }


        $data = array(
            'kin_dat1' => $this->request->getvar('tgl'),
            'kin_hari' => $jmlhari,
            // 'kin_apus' => $kin_dat1,
        );

        $model->_updatetabungantgl($data, $kin_code);

        // $tgltabungan = $modelgit->_get_tgltabungan($this->request->getvar('tbg_code'), $this->request->getvar('tgl'), $bulan, $tahun);
        // foreach ($tgltabungan->getResult()  as $rowtrans) {

        //   $data = array(
        //     'kin_dat1' => $this->request->getvar('tgl'),
        //     'kin_apus' => 1,
        //   );
        //   $idtrans = $rowtrans->kin_code;
        //   $model->_updatetabungantgl($data,  $idtrans);
        //   // var_dump($data);
        // }
        // Jurnal
        if ($jns == '01') {
            $v_trx_dbcr = 'D';
            $v_trx_debt = $kin_totl;
            $v_trx_crdt = 0;
        } else {
            $v_trx_dbcr = 'K';
            $v_trx_debt = 0;
            $v_trx_crdt = $kin_totl;
        }
        if ($jns == '01') {
            if ($xprod == '3') {
                $cabang = $kodecabang;
                if ($cabang != '100') {
                    $cabcod12 = '100';
                } else {
                    $cabcod12 = $kodecabang;
                }
            } else {
                $cabcod12 = $kodecabang;
            }
        } else {
            $cabcod12 = $kodecabang;
        }
        $data = array(
            'trx_code' => $v_trx_code,
            //$this->request->getvar('norek'),
            'trx_date' => $this->request->getvar('tgl'),
            'acc_code' => $acc_cash,
            'trx_jens' => '01',
            'psb_code' => $prd_code,
            'trx_urut' => 1,
            'trx_dbcr' => $v_trx_dbcr,
            'trx_amnt' => $kin_totl,
            'dbt_amnt' => $v_trx_debt,
            'crd_amnt' => $v_trx_crdt,
            'trx_des1' => $description,
            'trx_des2' => $description1,
            'com_code' =>   1,
            'kode_cabang' => $kodecabang,
            'ent_time' => $waktu,
            'usercreated' => $emp_name,
        );
        $model->_savejurnal($data);


        // Jurnal

        if ($jns == '01') {
            $v_trx_dbcr = 'K';
            $v_trx_debt = 0;
            $v_trx_crdt = $kin_stot;
        } else {
            $v_trx_dbcr = 'D';
            $v_trx_debt = $kin_stot;
            $v_trx_crdt = 0;
        }

        $data = array(
            'trx_code' => $v_trx_code,
            //$this->request->getvar('norek'),
            'trx_date' => $this->request->getvar('tgl'),
            'acc_code' => $acc_prod,
            'trx_jens' => '01',
            'trx_urut' => 1,
            'trx_dbcr' => $v_trx_dbcr,
            'trx_amnt' => $kin_stot,
            'dbt_amnt' => $v_trx_debt,
            'crd_amnt' => $v_trx_crdt,
            'trx_des1' => $description,
            'trx_des2' => $description1,
            'com_code' => 1,
            'kode_cabang' => $cabcod12,
            'ent_time' => $waktu,
            'usercreated' => $emp_name,
        );
        $model->_savejurnal($data);

        //admin
        // Jurnal Admin

        //Premi
        // Jurnal Premi



        // Jurnal Pajak


        // Magin

        $id = $rekening;



        if ($rekening == '') {
            if ($jns == '01') {

                $vstatus = '1';
                $data = array(

                    'tbg_stat' => $vstatus,
                    'tbg_aktv' => $this->request->getvar('tgl'),
                    'tbg_awal' => $kin_stot,

                );
                $model->_updatetabungan($data, $id);
            }
        }

        if ($jns == '01') {

            if ($xprod == '3') {
                // $model->_savejurnal10($data);
                // $cabang = session()->get('kode_cabang');
                if ($kodecabang != '100') {
                    $dbakuncabang = $mgit->get_dtakuncabang('100');
                    foreach ($dbakuncabang->getResult() as $row) {
                        $acc_cab1 = $row->acc_arcd;
                    }

                    $data = array(
                        'trx_code' => $v_trx_code,
                        //$this->request->getvar('norek'),
                        'trx_date' => $this->request->getvar('tgl'),
                        'acc_code' => $acc_cab1,
                        'trx_jens' => '01',
                        'trx_urut' => 1,
                        'trx_dbcr' => 'D',
                        'trx_amnt' => $kin_totl,
                        'dbt_amnt' => $kin_totl,
                        'crd_amnt' => 0,
                        'trx_des1' => 'Piutang ' . $prd_name . ' - ' . $agt_name,
                        'trx_des2' => 'Piutang cabang :' . $prd_name,
                        'com_code' => 1,
                        'kode_cabang' => '100',
                        //()->get('kode_cabang'),
                        'ent_time' => $waktu,
                        'usercreated' => $emp_name,
                    );
                    $model->_savejurnal($data);
                    // Piutang
                    $dbakuncabang = $mgit->get_dtakuncabang($kodecabang);
                    foreach ($dbakuncabang->getResult() as $row1) {
                        $acc_cab2 = $row->acc_apcd;
                    }
                    $data = array(
                        'trx_code' => $v_trx_code,
                        //$this->request->getvar('norek'),
                        'trx_date' => $this->request->getvar('tgl'),
                        'acc_code' => $acc_cab2,
                        'trx_jens' => '01',
                        'trx_urut' => 1,
                        'trx_dbcr' => 'K',
                        'trx_amnt' => $kin_totl,
                        'dbt_amnt' => 0,
                        'crd_amnt' => $kin_totl,
                        'trx_des1' => 'Hutang ' . $prd_name . ' - ' . $agt_name,
                        'trx_des2' => 'Hutang cabang :' . $prd_name,
                        'com_code' => 1,
                        'kode_cabang' => $kodecabang,
                        'ent_time' => $waktu,
                        'usercreated' => $emp_name,
                    );
                    $model->_savejurnal($data);
                }
            }
        }

        $data = $mcore->_get_simpanantrans($v_trx_code)->getResult();

        if ($data) {

            $response['status'] = 'Berhasil';
            $response['data'] = $data;
        } else {
            $response['message'] = 'No data found';
        }


        return $this->respondCreated($response);
    }


public function transfer()
    {
        $model = new Save_model();
        $mgit = new Model_git();
        $modecek = new Auto_model();
        $mcore = new Core_model();
        $note = "";


        $tanggal =$this->request->getvar('tgl');

        $bulan = date('m', strtotime($tanggal));
        $tahun = date('Y', strtotime($tanggal));
        $waktu = date('Y-m-d H:i:s');

        $cek = $modecek->get_nosetortabungan($bulan, $tahun);
        $jns = '02';
        $description = $this->request->getvar('keterangan');
        $nourut = $cek['kin_srno'];
        $rekening = $this->request->getvar('norek');
        $rektujuan = $this->request->getvar('rektujuan');
	$cek_rektujuan = $mcore->_cek_norektabungan($rektujuan)->getRow();

        if (!$cek_rektujuan) {
            $response['status'] = $cek_rektujuan['tbg_code']; // 'error';
            $response['message'] = 'Rekening tujuan tidak ditemukan';
            return $this->respond($response, 401);
        }
        $empcode = $this->request->getvar('collector_id');
        $kodecabang = '';
       
        $cond = array('emp_code'=>$empcode);
        $dbemployee = $mcore->_get_petugas($cond)->getRow();
		//print_r($dbemployee);
		//die('');
        $emp_name = $dbemployee->nama_petugas;
		$bnk_code = $dbemployee->kode_kas;
		$kodecabang = $dbemployee->unit_kerja;
        $dbbank = $modecek->get_bank($bnk_code);
        $acc_cash = $dbbank['acc_code'];

        $sldawal = $mcore->saldotabungan($rekening);
        $kin_awal = 0;
        foreach ($sldawal->getResult() as $awal) {
            $kin_awal = $awal->kin_awal;
        }
        $cek1 = $mgit->_get_datatabunganab($rekening);
        $agt_numb = '';
        $agt_name = '';
        $prd_code = '';
        $acc_prod = '';
        $acc_admn = '';

        foreach ($cek1->getResult() as $cekrow) {
            $agt_numb = $cekrow->agt_numb;
            $agt_name = $cekrow->agt_name;
            $prd_code = $cekrow->prd_code;
            $prd_name = $cekrow->prd_name;
            $acc_prod = $cekrow->acc_code;
            $acc_admn = $cekrow->acc_cod2;
            // $kodecabang = $cekrow->kode_cabang;
        }
        // $rekening = $cek1['tbg_code'];

        $xprod1 = $prd_code;
        $xprod = substr($xprod1, 0, 1);

        // $description = 'Setoran ' . $prd_name . ' - ' . $agt_name;
        $description1 = 'Setoran ' . $prd_name;

        // }
        if ($nourut == '') {
            $nourut = 1;
            $v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . '00001';
        } else {
            $nourut = $nourut + 1;
            if ($nourut < 10) {
                $v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . '0000' . $nourut;
            } else if ($nourut >= 10 and $nourut < 100) {
                $v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . '000' . $nourut;
            } else if ($nourut >= 100 and $nourut < 1000) {
                $v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . '00' . $nourut;
            } else if ($nourut >= 1000 and $nourut < 10000) {
                $v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . '0' . $nourut;
            } else {
                $v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . $nourut;
            }
        }


        $kin_stot = str_replace(',', '', $this->request->getvar('jumlah'));
        $kin_totl = str_replace(',', '', $this->request->getvar('jumlah'));
        // $kin_awal = 0;
        $v_dbt_amnt = 0;
        $v_crd_amnt = 0;
        $cektanggal = $modecek->_get_tgltabungan1($rekening, $tanggal);
        $kin_code = $cektanggal['kin_code'];
        $kin_dat1 = $cektanggal['kin_dat1'];
        $kin_dat2 = $cektanggal['kin_date'];



        // }
        if ($jns == '01') {
            $debcrt = 'K';
            $v_crd_amnt = $kin_totl;
            $v_dbt_amnt = 0;
        } else {
            $debcrt = 'D';
            $v_dbt_amnt = $kin_totl;
            $v_crd_amnt = 0;
        }

        if ($kin_code == '') {
            $kin_gtot = $kin_totl;
            // $kin_awal = 0;
            $kin_dat1 = $cektanggal['kin_date'];
            $jmlhari = (($tanggal - $kin_dat1) / 60 / 60 / 24);
        } else {
            $kin_dat1 = $cektanggal['kin_date'];
            // $kin_awal = $cektanggal['kin_akhr'];
            $kin_gtot = $kin_awal + $v_crd_amnt - $v_dbt_amnt;
            // $kin_dat1 = date('Y-m-d', strtotime($kin_dat1));
            $tanggl2 = strtotime($tanggal);
            $tanggl1 = strtotime($kin_dat1);
            $jmlhari = (($tanggl2 - $tanggl1) / 60 / 60 / 24);
        }
        $kin_akhr = $kin_awal - $v_dbt_amnt + $v_crd_amnt;
        $data = array(
            'kin_code' => $v_trx_code,
            //$this->request->getvar('norek'),
            'kin_date' =>$this->request->getvar('tgl'),
            'agt_numb' => $agt_numb,
            'bnk_code' => $bnk_code,
            'acc_cash' => $acc_cash,
            'kin_type' => $prd_code,
            'kin_desc' => $description,
            'kin_note' => $note,
            'kin_stot' => $kin_stot,

            'acc_admn' => $acc_admn,
            'acc_prod' => $acc_prod,
            'tbg_code' => $rekening,
            'kin_mont' => $bulan,
            'kin_year' => $tahun,
            'kin_totl' => $kin_totl,
            'kin_srno' => $nourut,
            'kin_jens' => '04',
            'kin_nstr' => 0,
            'kin_astr' => 0,
            'kin_prem' => 0,
            'kin_pajk' => 0,
            'kin_marg' => 0,
            'acc_prem' => '',
            'acc_pajk' => '',
            'acc_marg' => '',
            'kin_mstr' => 0,
            'kin_debt' => $v_dbt_amnt,
            'kin_crdt' => $v_crd_amnt,
            'kin_dbcr' => $debcrt,
            'kin_stat' => 0,
            'com_code' => 1,

            'trx_jens' => '04',
            'kode_cabang' => $kodecabang,
            'kin_gtot' => $kin_gtot,
            'kin_awal' => $kin_awal,
            'kin_akhr' => $kin_akhr,
            'kin_time' => $waktu,
            'kin_user' => $emp_name,

        );

        $model->_savesetortabungan($data);



        $data = array(
            'kin_dat1' =>$this->request->getvar('tgl'),
            'kin_hari' => $jmlhari,
            // 'kin_apus' => $kin_dat1,
        );

        $model->_updatetabungantgl($data, $kin_code);


        // Jurnal
        if ($jns == '01') {
            $v_trx_dbcr = 'D';
            $v_trx_debt = $kin_totl;
            $v_trx_crdt = 0;
        } else {
            $v_trx_dbcr = 'K';
            $v_trx_debt = 0;
            $v_trx_crdt = $kin_totl;
        }
        if ($jns == '01') {
            if ($xprod == '3') {
                $cabang = $kodecabang;
                if ($cabang != '100') {
                    $cabcod12 = '100';
                } else {
                    $cabcod12 = $kodecabang;
                }
            } else {
                $cabcod12 = $kodecabang;
            }
        } else {
            $cabcod12 = $kodecabang;
        }

        // Jurnal

        if ($jns == '01') {
            $v_trx_dbcr = 'K';
            $v_trx_debt = 0;
            $v_trx_crdt = $kin_stot;
        } else {
            $v_trx_dbcr = 'D';
            $v_trx_debt = $kin_stot;
            $v_trx_crdt = 0;
        }

        $data = array(
            'trx_code' => $v_trx_code,
            //$this->request->getvar('norek'),
            'trx_date' =>$this->request->getvar('tgl'),
            'acc_code' => $acc_prod,
            'trx_jens' => '01',
            'trx_urut' => 1,
            'trx_dbcr' => $v_trx_dbcr,
            'trx_amnt' => $kin_stot,
            'dbt_amnt' => $v_trx_debt,
            'crd_amnt' => $v_trx_crdt,
            'trx_des1' => $description,
            'trx_des2' => $description1,
            'com_code' => 1,
            'kode_cabang' => $cabcod12,
            'ent_time' => $waktu,
            'usercreated' => $emp_name,
        );
        $model->_savejurnal($data);



        // Magin

        $id = $rekening;



        if ($rekening == '') {
            if ($jns == '01') {

                $vstatus = '1';
                $data = array(

                    'tbg_stat' => $vstatus,
                    'tbg_aktv' =>$this->request->getvar('tgl'),
                    'tbg_awal' => $kin_stot,

                );
                $model->_updatetabungan($data, $id);
            }
        }



        // Rekening Tujuan
        $v_trx_code1 = $v_trx_code;
	$jns = '01';
        $sldawal = $mcore->saldotabungan($rektujuan);
        $kin_awal = 0;
        foreach ($sldawal->getResult() as $awal) {
            $kin_awal = $awal->kin_awal;
        }
        $cek1 = $mgit->_get_datatabunganab($rektujuan);
        $agt_numb = '';
        $agt_name = '';
        $prd_code = '';
        $acc_prod = '';
        $acc_admn = '';

        foreach ($cek1->getResult() as $cekrow) {
            $agt_numb = $cekrow->agt_numb;
            $agt_name = $cekrow->agt_name;
            $prd_code = $cekrow->prd_code;
            $prd_name = $cekrow->prd_name;
            $acc_prod = $cekrow->acc_code;
            $acc_admn = $cekrow->acc_cod2;
            // $kodecabang = $cekrow->kode_cabang;
        }
        // $rekening = $cek1['tbg_code'];

        $xprod1 = $prd_code;
        $xprod = substr($xprod1, 0, 1);


        // $kodecabang = session()->get('kode_cabang');
        // if ($description == '') {
        if ($jns == '01') {

            // $description = 'Setoran ' . $prd_name . ' - ' . $agt_name;
            $description1 = 'Setoran ' . $prd_name;
        }

        // }
        if ($nourut == '') {
            $nourut = 1;
            $v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . '00001';
        } else {
            $nourut = $nourut + 1;
            if ($nourut < 10) {
                $v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . '0000' . $nourut;
            } else if ($nourut >= 10 and $nourut < 100) {
                $v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . '000' . $nourut;
            } else if ($nourut >= 100 and $nourut < 1000) {
                $v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . '00' . $nourut;
            } else if ($nourut >= 1000 and $nourut < 10000) {
                $v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . '0' . $nourut;
            } else {
                $v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . $nourut;
            }
        }


        $kin_stot = str_replace(',', '', $this->request->getvar('jumlah'));
        $kin_totl = str_replace(',', '', $this->request->getvar('jumlah'));
        // $kin_awal = 0;
        $v_dbt_amnt = 0;
        $v_crd_amnt = 0;
        $cektanggal = $modecek->_get_tgltabungan1($rektujuan, $tanggal);
        $kin_code = $cektanggal['kin_code'];
        $kin_dat1 = $cektanggal['kin_dat1'];
        $kin_dat2 = $cektanggal['kin_date'];



        if ($jns == '01') {
            $debcrt = 'K';
            $v_crd_amnt = $kin_totl;
            $v_dbt_amnt = 0;
        } else {
            $debcrt = 'D';
            $v_dbt_amnt = $kin_totl;
            $v_crd_amnt = 0;
        }

        if ($kin_code == '') {
            $kin_gtot = $kin_totl;
            // $kin_awal = 0;
            $kin_dat1 = $cektanggal['kin_date'];
            $jmlhari = (($tanggal - $kin_dat1) / 60 / 60 / 24);
        } else {
            $kin_dat1 = $cektanggal['kin_date'];
            // $kin_awal = $cektanggal['kin_akhr'];
            $kin_gtot = $kin_awal + $v_crd_amnt - $v_dbt_amnt;
            // $kin_dat1 = date('Y-m-d', strtotime($kin_dat1));
            $tanggl2 = strtotime($tanggal);
            $tanggl1 = strtotime($kin_dat1);
            $jmlhari = (($tanggl2 - $tanggl1) / 60 / 60 / 24);
        }
        $kin_akhr = $kin_awal - $v_dbt_amnt + $v_crd_amnt;
        $data = array(
            'kin_code' => $v_trx_code,
            //$this->request->getvar('norek'),
            'kin_date' =>$this->request->getvar('tgl'),
            'agt_numb' => $agt_numb,
            'bnk_code' => $bnk_code,
            'acc_cash' => $acc_cash,
            'kin_type' => $prd_code,
            'kin_desc' => $description,
            'kin_note' => $note,
            'kin_stot' => $kin_stot,

            'acc_admn' => $acc_admn,
            'acc_prod' => $acc_prod,
            'tbg_code' => $rektujuan,
            'kin_mont' => $bulan,
            'kin_year' => $tahun,
            'kin_totl' => $kin_totl,
            'kin_srno' => $nourut,
            'kin_jens' => '04',
            'kin_nstr' => 0,
            'kin_astr' => 0,
            'kin_prem' => 0,
            'kin_pajk' => 0,
            'kin_marg' => 0,
            'acc_prem' => '',
            'acc_pajk' => '',
            'acc_marg' => '',
            'kin_mstr' => 0,
            'kin_debt' => $v_dbt_amnt,
            'kin_crdt' => $v_crd_amnt,
            'kin_dbcr' => $debcrt,
            'kin_stat' => 0,
            'com_code' => 1,

            'trx_jens' => '04',
            'kode_cabang' => $kodecabang,
            'kin_gtot' => $kin_gtot,
            'kin_awal' => $kin_awal,
            'kin_akhr' => $kin_akhr,
            'kin_time' => $waktu,
            'kin_user' => $emp_name,

        );

        $model->_savesetortabungan($data);



        $data = array(
            'kin_dat1' =>$this->request->getvar('tgl'),
            'kin_hari' => $jmlhari,
            // 'kin_apus' => $kin_dat1,
        );

        $model->_updatetabungantgl($data, $kin_code);


        // Jurnal
        if ($jns == '01') {
            $v_trx_dbcr = 'D';
            $v_trx_debt = $kin_totl;
            $v_trx_crdt = 0;
        } else {
            $v_trx_dbcr = 'K';
            $v_trx_debt = 0;
            $v_trx_crdt = $kin_totl;
        }
        if ($jns == '01') {
            if ($xprod == '3') {
                $cabang = $kodecabang;
                if ($cabang != '100') {
                    $cabcod12 = '100';
                } else {
                    $cabcod12 = $kodecabang;
                }
            } else {
                $cabcod12 = $kodecabang;
            }
        } else {
            $cabcod12 = $kodecabang;
        }



        // Jurnal

        if ($jns == '01') {
            $v_trx_dbcr = 'K';
            $v_trx_debt = 0;
            $v_trx_crdt = $kin_stot;
        } else {
            $v_trx_dbcr = 'D';
            $v_trx_debt = $kin_stot;
            $v_trx_crdt = 0;
        }

        $data = array(
            'trx_code' => $v_trx_code1,
            //$this->request->getvar('norek'),
            'trx_date' =>$this->request->getvar('tgl'),
            'acc_code' => $acc_prod,
            'trx_jens' => '01',
            'trx_urut' => 1,
            'trx_dbcr' => $v_trx_dbcr,
            'trx_amnt' => $kin_stot,
            'dbt_amnt' => $v_trx_debt,
            'crd_amnt' => $v_trx_crdt,
            'trx_des1' => $description,
            'trx_des2' => $description1,
            'com_code' => 1,
            'kode_cabang' => $cabcod12,
            'ent_time' => $waktu,
            'usercreated' => $emp_name,
        );
        $model->_savejurnal($data);

        //admin
        // Jurnal Admin

        //Premi
        // Jurnal Premi



        // Jurnal Pajak


        // Magin

        $id = $rektujuan;



        if ($rektujuan == '') {
            if ($jns == '01') {

                $vstatus = '1';
                $data = array(

                    'tbg_stat' => $vstatus,
                    'tbg_aktv' =>$this->request->getvar('tgl'),
                    'tbg_awal' => $kin_stot,

                );
                $model->_updatetabungan($data, $id);
            }
        }



        // End Rekening Tujuan

        // $data = $mcore->_get_simpanantrans($v_trx_code)->getResult();
        if ($data) {
$data=$v_trx_code1;
            $response['status'] = 'Berhasil';
             $response['data'] = $data;
        } else {
            $response['message'] = 'No data found';
        }


        return $this->respondCreated($response);
    }
   

    public function angsuran()
    {
        $model = new Save_model();
        $modecek = new Auto_model();
        $mgit = new Model_git();
        $mcore = new Core_model();
        $note = "";
        $norekening = $this->request->getvar('norek');
        $tanggal = $this->request->getvar('tgl');
        $description = $this->request->getvar('keterangan');
        $kin_stot = str_replace(',', '', $this->request->getvar('jumlah'));
        $kin_gtot = str_replace(',', '', $this->request->getvar('jumlah'));
        $bulan = date('m', strtotime($tanggal));
        $tahun = date('Y', strtotime($tanggal));
        $waktu = date('Y-m-d H:i:s');

        $jenis = '01';
        $bnk_code = '90';
        $dbbank = $modecek->get_bank($bnk_code);
        $acc_cash = $dbbank['acc_code'];;
        $cek = $modecek->get_nopembiayaan($bulan, $tahun);
        $nourut = $cek['kin_srno'];


        $acc_cash = '';
        $prd_code = '';
        $prd_name = '';
        $trx_angk = '';
        $trx_jtdt = '0000-00-00';
        $trx_pokk = '';
        $trx_bung = '';
        $trx_dend = '';
        $trx_amnh = '';
        $agt_numb = '';
        $agt_name = '';
        $prd_code = '';
        $acc_prod = '';
        $acc_bung = '';
        $acc_admn = '';
        $kodecabang = '';
        $dbpinjaman = $mgit->_get_dtkartuhutang($norekening);

        foreach ($dbpinjaman->getResult() as $rowtrans) {
            $acc_cash = $rowtrans->acc_code;
            $prd_code = $rowtrans->acc_code;
            $prd_name = $rowtrans->acc_code;
            $trx_angk = $rowtrans->trx_angk;
            $trx_jtdt = $rowtrans->trx_jtdt;
            $trx_pokk = $rowtrans->trx_pokk;
            $trx_bung = $rowtrans->trx_bung;
            $trx_dend = $rowtrans->trx_dend;
            $trx_amnh = $rowtrans->trx_saldo;
            $agt_numb = $rowtrans->agt_numb;
            $agt_name = $rowtrans->agt_name;
            $prd_code = $rowtrans->prd_code;
            $acc_prod = $rowtrans->acc_code;
            $acc_bung = $rowtrans->acc_cod1;
            $acc_admn = $rowtrans->acc_cod2;
            $kodecabang = $rowtrans->kode_cabang;
        }

        $description = 'Setoran ' . $prd_name . ' - ' . $agt_name;
        $description1 = 'Setoran ' . $prd_name;

        if ($nourut == '') {
            $nourut = 1;
            $v_trx_code = $kodecabang . '.07.' . $tahun . $bulan . '00001';
        } else {
            $nourut = $nourut + 1;
            if ($nourut < 10) {
                $v_trx_code = $kodecabang . '.07.' . $tahun . $bulan . '0000' . $nourut;
            } else if ($nourut >= 10 and $nourut < 100) {
                $v_trx_code = $kodecabang . '.07.' . $tahun . $bulan . '000' . $nourut;
            } else if ($nourut >= 100 and $nourut < 1000) {
                $v_trx_code = $kodecabang . '.07.' . $tahun . $bulan . '00' . $nourut;
            } else if ($nourut >= 1000 and $nourut < 10000) {
                $v_trx_code = $kodecabang . '.07.' . $tahun . $bulan . '0' . $nourut;
            } else {
                $v_trx_code = $kodecabang . '.07.' . $tahun . $bulan . $nourut;
            }
        }


        // $trx_angs = 0;
        // $trx_pokk = 0;
        // $trx_bung = 0;
        // $trx_dend = 0;
        $kin_tadmn = 0;
        $data = array(
            'kin_code'       => $v_trx_code, //$this->request->getvar('norek'),
            'kin_date'       => $this->request->getvar('tgl'),
            'agt_numb'       => $agt_numb,
            'bnk_code'       => $bnk_code,
            'knt_code'       => $norekening,
            'kin_type'       => '01',
            'kin_desc'       => $this->request->getvar('keterangan'),
            'kin_stot'       => $kin_stot,
            'kin_admn'       => 0, //$kin_tadmn,
            'kin_jtdt'       => $trx_jtdt,
            'kin_dend'       => 0, //$trx_dend,
            'kin_angs'       => $trx_amnh,
            'prd_code'       => $prd_code,
            'kin_bung'       => $trx_bung,
            'kin_pokk'       => $trx_pokk,
            'kin_angk'       => $trx_angk,
            'kin_note'       => $note,
            'kin_totl'       => $kin_stot,
            // 'kin_gtot'       => $kin_gtot,
            'acc_cash'       => $acc_cash,
            'acc_prod'       => $acc_prod,
            'acc_dend'       => '',
            'acc_admn'       => $acc_admn,
            'acc_bung'       => $acc_bung,
            'kin_tcos'       => 0,
            'kin_tprov'      => 0,
            'kin_notr'       => 0,
            'kin_jiwa'       => 0,
            'kin_kend'       => 0,
            'kin_kebk'       => 0,
            'kin_krdt'       => 0,
            'kin_dana'       => 0,
            'kin_lain'       => 0,
            'kin_matr'       => 0,
            'kin_pmat'       => 0,
            'kin_infq'       => 0,
            'kin_simw'       => 0,
            'kin_pinl'       => 0,
            'kin_tdendh'       => 0,
            'kin_ddendh'       => 0,
            'kin_tadmn'       => $kin_tadmn,
            'kin_dadmn'       => 0,
            'kin_tbungh'       => 0,
            'kin_dbungh'       => 0,
            'kin_tpokkh'       => 0,
            'kin_dpokkh'       => 0,
            'kin_rtgs'       => 0,
            'kin_tran'       => 0,
            'kin_mont'       => $bulan,
            'kin_year'       => $tahun,
            'kin_srno'  => $nourut,
            'kin_jens'  => 'K',
            'kin_stat' => '0',
            'kode_cabang' => $kodecabang,
            'com_code'  => 1,
        );

        $model->_savepembiayaan($data);


        if ($jenis == '01') {
            $id1 = $trx_angk;
            $id = $norekening;
            $data = array(

                'trx_lnsh'  => $trx_amnh,
                'lns_pokk'  => $trx_pokk,
                'lns_bung'  => $trx_bung,
                'lns_date'  => $tanggal,
                'bkt_date'  => $tanggal,
                'lns_code'  => $v_trx_code, //$this->request->getvar('norek'),
            );

            $model->_Updatekartu($data, $id, $trx_angk);
        }


        if ($jenis == '01') {

            $data = array(
                'knt_stat'  => 1,
                // 'knt_cair'  => 1,

            );

            $model->_updatekontrak($data, $norekening);
        }

        $data = array(
            'trx_code' => $v_trx_code, //$this->request->getvar('norek'),
            'trx_date' => $this->request->getvar('tgl'),
            'acc_code'  => $acc_cash,
            'trx_jens'  => '01',
            'psb_code'  => $prd_code,
            'trx_urut' => 1,
            'trx_dbcr'  => 'D',
            'trx_amnt'  => $kin_gtot,
            'dbt_amnt'  => $kin_gtot,
            'crd_amnt'  => 0,
            'trx_des1'  => $description,
            'trx_des2'  => $description1,
            'com_code'  => 1,
            'kode_cabang' => $kodecabang,
            'ent_time' => $waktu,
            'usercreated' => 'Mobile',
        );
        $model->_savejurnal($data);


        // Jurnal 
        //Piutang


        $data = array(
            'trx_code' => $v_trx_code, //$this->request->getvar('norek'),
            'trx_date' => $this->request->getvar('tgl'),
            'acc_code'  => $acc_prod,
            'trx_jens'  => '01',
            'trx_urut' => 1,
            'trx_dbcr'  => 'K',
            'trx_amnt'  => $trx_pokk,
            'dbt_amnt'  => 0,
            'crd_amnt'  => $trx_pokk,
            'trx_des1'  => $description,
            'trx_des2'  => $description1,
            'com_code'  => 1,
            'kode_cabang' => $kodecabang,
            'ent_time' => $waktu,
            'usercreated' => 'Mobile',
        );
        $model->_savejurnal($data);


        // Pendapatan Bunga
        $data = array(
            'trx_code' => $v_trx_code, //$this->request->getvar('norek'),
            'trx_date' => $this->request->getvar('tgl'),
            'acc_code'  => $acc_bung,
            'trx_jens'  => '01',
            'trx_urut' => 1,
            'trx_dbcr'  => 'K',
            'trx_amnt'  => $trx_bung,
            'dbt_amnt'  => 0,
            'crd_amnt'  => $trx_bung,
            'trx_des1'  => $prd_name . ' - ' . $agt_name,
            'trx_des2'  => 'Pendapatan Bunga',
            'com_code'  => 1,
            'kode_cabang' => $kodecabang,
            'ent_time' => $waktu,
            'usercreated' => 'Mobile',
        );
        $model->_savejurnal($data);
        // Denda
        $denda = 0; // $trx_dend;
        if ($denda > 0) {
            $code = '02';
            $caccount = $modecek->get_acckhusus($code);
            $v_acc_code = $caccount['acc_code'];
            $data = array(
                'trx_code' => $v_trx_code, //$this->request->getvar('norek'),
                'trx_date' => $this->request->getvar('tgl'),
                'acc_code'  => $v_acc_code,
                'trx_jens'  => '01',
                'trx_urut' => 1,
                'trx_dbcr'  => 'K',
                'trx_amnt'  => $trx_dend,
                'dbt_amnt'  => 0,
                'crd_amnt'  => $trx_dend,
                'trx_des1'  => 'Denda ' . $prd_name . ' - ' . $agt_name,
                'trx_des2'  => 'Pendapatan Denda',
                'com_code'  => 1,
                'kode_cabang' => $kodecabang,
                'ent_time' => $waktu,
                'usercreated' => 'Mobile',
            );
            $model->_savejurnal($data);
        }
        //admin
        // Jurnal Admin
        $admin = 0; //$kin_tadmn;
        if ($admin > 0) {
            $code = '01';
            // $caccount =  $modecek->get_acckhusus($code);

            $data = array(
                'trx_code' => $v_trx_code, //$this->request->getvar('norek'),
                'trx_date' => $this->request->getvar('tgl'),
                'acc_code'  => $acc_admn,
                'trx_jens'  => '01',
                'trx_urut' => 1,
                'trx_dbcr'  => 'K',
                'trx_amnt'  => $admin,
                'dbt_amnt'  => 0,
                'crd_amnt'  => $kin_tadmn,
                'trx_des1'  => 'Admin ' . $prd_name . ' - ' . $agt_name,
                'trx_des2'  => 'Pendapatan Admin',
                'com_code'  => 1,
                'kode_cabang' => $kodecabang,
                'ent_time' => $waktu,
                'usercreated' => 'Mobile',
            );
            $model->_savejurnal($data);
        }


        $data = $mcore->_get_pinjamantrans($v_trx_code)->getResult();

        if ($data) {

            $response['status'] = 'Berhasil';
            $response['data'] = $data;
        } else {
            var_dump($data);
            $response['message'] = 'No data found';
        }


        return $this->respondCreated($response);
    }
    
    public function angsuranpembiayaan()
    {
        $model = new Save_model();
        $modecek = new Auto_model();
        $mgit = new Model_git();
        $mcore = new Core_model();
        $note = "";

        $empcode = $this->request->getvar('collector_id');
        $dbemployee = $modecek->get_employee($empcode);
        $emp_name = $dbemployee['emp_name'];
        $bnk_code = $dbemployee['bnk_code'];
        $kodecabang = $dbemployee['kode_cabang'];
        if ($bnk_code == '') {
            $response['message'] = 'Data Petugas tidak terdaftar';
            return $this->respondCreated($response);
        }
        $norekening = $this->request->getvar('norek');
        $tanggal = $this->request->getvar('tgl');
        $description = $this->request->getvar('keterangan');
        $pokok = str_replace(',', '', $this->request->getvar('pokok'));
        $bunga = str_replace(',', '', $this->request->getvar('bunga'));
        $kin_stot =  str_replace(',', '', $this->request->getvar('total_angsuran'));
        $kin_gtot =  str_replace(',', '', $this->request->getvar('total_angsuran'));
        $angsran_ke = $this->request->getvar('angsuran_ke');
        $bulan = date('m', strtotime($tanggal));
        $tahun = date('Y', strtotime($tanggal));
        $waktu = date('Y-m-d H:i:s');

        $jenis = '01';

        $dbbank = $modecek->get_bank($bnk_code);
        $acc_cash = $dbbank['acc_code'];;
        $cek = $modecek->get_nopembiayaan($bulan, $tahun);
        $nourut = $cek['kin_srno'];


        // $acc_cash = '';
        $prd_code = '';
        $prd_name = '';
        $trx_angk = '';
        $trx_jtdt = '0000-00-00';
        $trx_pokk = '';
        $trx_bung = '';
        $trx_dend = '';
        $trx_amnh = '';
        $agt_numb = '';
        $agt_name = '';
        $prd_code = '';
        $acc_prod = '';
        $acc_bung = '';
        $acc_admn = '';
        $tbg_code = '';
        $kodecabang = '';
        $dbpinjaman = $mgit->_get_dtkartuhutang($norekening);

        foreach ($dbpinjaman->getResult() as $rowtrans) {
            //$acc_cash = $rowtrans->acc_code;
            $prd_code = $rowtrans->acc_code;
            $prd_name = $rowtrans->acc_code;
            $trx_angk = $rowtrans->trx_angk;
            $trx_jtdt = $rowtrans->trx_jtdt;
            $trx_pokk = $rowtrans->trx_pokk;
            $trx_bung = $rowtrans->trx_bung;
            $trx_dend = $rowtrans->trx_dend;
            $trx_amnh = $rowtrans->trx_saldo;
            $agt_numb = $rowtrans->agt_numb;
            $agt_name = $rowtrans->agt_name;
            $prd_code = $rowtrans->prd_code;
            $acc_prod = $rowtrans->acc_code;
            $acc_bung = $rowtrans->acc_cod1;
            $acc_admn = $rowtrans->acc_cod2;
            $tbg_code = $rowtrans->tbg_code;
            $kodecabang = $rowtrans->kode_cabang;
        }
        $tot_bayr = $trx_pokk + $trx_bung;
        $selisih = 0;
        if ($kin_gtot > $tot_bayr) {
            $pokok = $trx_pokk;
            $bunga = $trx_bung;
            $selisih = $kin_gtot - $tot_bayr;
        }
        // $description = 'Setoran ' . $prd_name . ' - ' . $agt_name;
        // $description1 = 'Setoran ' . $prd_name;

        if ($nourut == '') {
            $nourut = 1;
            $v_trx_code = $kodecabang . '.07.' . $tahun . $bulan . '00001';
        } else {
            $nourut = $nourut + 1;
            if ($nourut < 10) {
                $v_trx_code = $kodecabang . '.07.' . $tahun . $bulan . '0000' . $nourut;
            } else if ($nourut >= 10 and $nourut < 100) {
                $v_trx_code = $kodecabang . '.07.' . $tahun . $bulan . '000' . $nourut;
            } else if ($nourut >= 100 and $nourut < 1000) {
                $v_trx_code = $kodecabang . '.07.' . $tahun . $bulan . '00' . $nourut;
            } else if ($nourut >= 1000 and $nourut < 10000) {
                $v_trx_code = $kodecabang . '.07.' . $tahun . $bulan . '0' . $nourut;
            } else {
                $v_trx_code = $kodecabang . '.07.' . $tahun . $bulan . $nourut;
            }
        }


        // $trx_angs = 0;
        // $trx_pokk = 0;
        // $trx_bung = 0;
        // $trx_dend = 0;
        $kin_tadmn = 0;
        $data = array(
            'kin_code'       => $v_trx_code, //$this->request->getvar('norek'),
            'kin_date'       => $this->request->getvar('tgl'),
            'agt_numb'       => $agt_numb,
            'bnk_code'       => $bnk_code,
            'knt_code'       => $norekening,
            'kin_type'       => '01',
            'kin_desc'       => $description,
            'kin_stot'       => $kin_stot,
            'kin_admn'       => 0, //$kin_tadmn,
            'kin_jtdt'       => $trx_jtdt,
            'kin_dend'       => 0, //$trx_dend,
            'kin_angs'       => $trx_amnh,
            'prd_code'       => $prd_code,
            'kin_bung'       => $trx_bung,
            'kin_pokk'       => $trx_pokk,
            'kin_angk'       => $trx_angk,
            'kin_note'       => $note,
            'kin_totl'       => $kin_stot,
            // 'kin_gtot'       => $kin_gtot,
            'acc_cash'       => $acc_cash,
            'acc_prod'       => $acc_prod,
            'acc_dend'       => '',
            'acc_admn'       => $acc_admn,
            'acc_bung'       => $acc_bung,
            'kin_tcos'       => 0,
            'kin_tprov'      => 0,
            'kin_notr'       => 0,
            'kin_jiwa'       => 0,
            'kin_kend'       => 0,
            'kin_kebk'       => 0,
            'kin_krdt'       => 0,
            'kin_dana'       => 0,
            'kin_lain'       => 0,
            'kin_matr'       => 0,
            'kin_pmat'       => 0,
            'kin_infq'       => 0,
            'kin_simw'       => 0,
            'kin_pinl'       => 0,
            'kin_tdendh'       => 0,
            'kin_ddendh'       => 0,
            'kin_tadmn'       => $kin_tadmn,
            'kin_dadmn'       => 0,
            'kin_tbungh'       => 0,
            'kin_dbungh'       => 0,
            'kin_tpokkh'       => 0,
            'kin_dpokkh'       => 0,
            'kin_rtgs'       => 0,
            'kin_tran'       => 0,
            'kin_mont'       => $bulan,
            'kin_year'       => $tahun,
            'kin_srno'  => $nourut,
            'kin_jens'  => 'K',
            'kin_stat' => '0',
            'kode_cabang' => $kodecabang,
            'com_code'  => 1,
        );

        $model->_savepembiayaan($data);

        
        if ($jenis == '01') {
            $ang_pokk = 0;
            $ang_bung = 0;
            $tot_angs = 0;

            $id1 = $angsran_ke;
            $dbangsuran = $mgit->_get_dttotangsuran($norekening, $angsran_ke);

            foreach ($dbangsuran->getResult() as $rowang) {
                $ang_pokk = $rowang->kin_pokk;
                $ang_bung = $rowang->kin_bung;
                $tot_angs = $rowang->kin_angs;
            }
            $id = $norekening;
            $data = array(

                'trx_lnsh'  => $tot_angs,
                'lns_pokk'  => $ang_pokk,
                'lns_bung'  => $ang_bung,
                'lns_date'  => $tanggal,
                'bkt_date'  => $tanggal,
                'lns_code'  => $v_trx_code, //$this->request->getvar('norek'),
            );

            $model->_Updatekartu($data, $id, $angsran_ke);
        }


        if ($jenis == '01') {

            $data = array(
                'knt_stat'  => 1,
                // 'knt_cair'  => 1,

            );

            $model->_updatekontrak($data, $norekening);
        }

        $data = array(
            'trx_code' => $v_trx_code, //$this->request->getvar('norek'),
            'trx_date' => $this->request->getvar('tgl'),
            'acc_code'  => $acc_cash,
            'trx_jens'  => '01',
            'psb_code'  => $prd_code,
            'trx_urut' => 1,
            'trx_dbcr'  => 'D',
            'trx_amnt'  => $kin_gtot,
            'dbt_amnt'  => $kin_gtot,
            'crd_amnt'  => 0,
            'trx_des1'  => $description,
            'trx_des2'  => $description,
            'com_code'  => 1,
            'kode_cabang' => $kodecabang,
            'ent_time' => $waktu,
            'usercreated' => $emp_name,
        );
        $model->_savejurnal($data);


        // Jurnal 
        //Piutang


        $data = array(
            'trx_code' => $v_trx_code, //$this->request->getvar('norek'),
            'trx_date' => $this->request->getvar('tgl'),
            'acc_code'  => $acc_prod,
            'trx_jens'  => '01',
            'trx_urut' => 1,
            'trx_dbcr'  => 'K',
            'trx_amnt'  => $pokok,
            'dbt_amnt'  => 0,
            'crd_amnt'  => $pokok,
            'trx_des1'  => $description,
            'trx_des2'  => $description,
            'com_code'  => 1,
            'kode_cabang' => $kodecabang,
            'ent_time' => $waktu,
            'usercreated' => $emp_name,
        );
        $model->_savejurnal($data);


        // Pendapatan Bunga
        $data = array(
            'trx_code' => $v_trx_code, //$this->request->getvar('norek'),
            'trx_date' => $this->request->getvar('tgl'),
            'acc_code'  => $acc_bung,
            'trx_jens'  => '01',
            'trx_urut' => 1,
            'trx_dbcr'  => 'K',
            'trx_amnt'  => $bunga,
            'dbt_amnt'  => 0,
            'crd_amnt'  => $bunga,
            'trx_des1'  => $prd_name . ' - ' . $agt_name,
            'trx_des2'  => 'Pendapatan Bunga',
            'com_code'  => 1,
            'kode_cabang' => $kodecabang,
            'ent_time' => $waktu,
            'usercreated' => $emp_name,
        );
        $model->_savejurnal($data);
        // Denda
        $denda = 0; // $trx_dend;
        if ($denda > 0) {
            $code = '02';
            $caccount = $modecek->get_acckhusus($code);
            $v_acc_code = $caccount['acc_code'];
            $data = array(
                'trx_code' => $v_trx_code, //$this->request->getvar('norek'),
                'trx_date' => $this->request->getvar('tgl'),
                'acc_code'  => $v_acc_code,
                'trx_jens'  => '01',
                'trx_urut' => 1,
                'trx_dbcr'  => 'K',
                'trx_amnt'  => $trx_dend,
                'dbt_amnt'  => 0,
                'crd_amnt'  => $trx_dend,
                'trx_des1'  => 'Denda ' . $prd_name . ' - ' . $agt_name,
                'trx_des2'  => 'Pendapatan Denda',
                'com_code'  => 1,
                'kode_cabang' => $kodecabang,
                'ent_time' => $waktu,
                'usercreated' => $emp_name,
            );
            $model->_savejurnal($data);
        }
        //admin
        // Jurnal Admin
        $admin = 0; //$kin_tadmn;
        if ($admin > 0) {
            $code = '01';
            // $caccount =  $modecek->get_acckhusus($code);

            $data = array(
                'trx_code' => $v_trx_code, //$this->request->getvar('norek'),
                'trx_date' => $this->request->getvar('tgl'),
                'acc_code'  => $acc_admn,
                'trx_jens'  => '01',
                'trx_urut' => 1,
                'trx_dbcr'  => 'K',
                'trx_amnt'  => $admin,
                'dbt_amnt'  => 0,
                'crd_amnt'  => $kin_tadmn,
                'trx_des1'  => 'Admin ' . $prd_name . ' - ' . $agt_name,
                'trx_des2'  => 'Pendapatan Admin',
                'com_code'  => 1,
                'kode_cabang' => $kodecabang,
                'ent_time' => $waktu,
                'usercreated' => $emp_name,
            );
            $model->_savejurnal($data);
        }

        if ($selisih > 0) {
            $v_trx_code1 = $v_trx_code;
            $jenistran = '01';

            $sldawal = $mcore->saldotabungan($tbg_code);
            $kin_awal = 0;
            foreach ($sldawal->getResult() as $awal) {
                $kin_awal = $awal->kin_awal;
            }
            $cek1 = $mgit->_get_datatabunganab($tbg_code);
            $agt_numb = '';
            $agt_name = '';
            $prd_code = '';
            $acc_prod = '';
            $acc_admn = '';

            foreach ($cek1->getResult() as $cekrow) {
                $agt_numb = $cekrow->agt_numb;
                $agt_name = $cekrow->agt_name;
                $prd_code = $cekrow->prd_code;
                $prd_name = $cekrow->prd_name;
                $acc_prod = $cekrow->acc_code;
                $acc_admn = $cekrow->acc_cod2;
            }
            $xprod1 = $prd_code;
            $xprod = substr($xprod1, 0, 1);

            // $kodecabang = session()->get('kode_cabang');
            // if ($description == '') {
            if ($jenistran == '01') {

                // $description = 'Setoran ' . $prd_name . ' - ' . $agt_name;
                $description1 = 'Setoran ' . $prd_name;
                // } else if ($jns == '02') {
                //     $description = 'Penarikan Tunai ' . $prd_name . ' - ' . $agt_name;
                //     $description1 = 'Penarikan Tunai ' . $prd_name;
                // } else if ($jns == '03') {
                //     $description = 'Penutupan Rekening : ' . $prd_name . ' - ' . $agt_name;
                //     $description1 = 'Penutupan Rekening : ' . $prd_name;
                // } else {
                //     $description = $prd_name . ' - ' . $agt_name;
                //     $description1 = $prd_name;
            }

            // }
            $cek = $modecek->get_nosetortabungan($bulan, $tahun);
            $jns = '04';

            $nourut = $cek['kin_srno'];
            if ($nourut == '') {
                $nourut = 1;
                $v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . '00001';
            } else {
                $nourut = $nourut + 1;
                if ($nourut < 10) {
                    $v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . '0000' . $nourut;
                } else if ($nourut >= 10 and $nourut < 100) {
                    $v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . '000' . $nourut;
                } else if ($nourut >= 100 and $nourut < 1000) {
                    $v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . '00' . $nourut;
                } else if ($nourut >= 1000 and $nourut < 10000) {
                    $v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . '0' . $nourut;
                } else {
                    $v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . $nourut;
                }
            }


            $kin_stot = $selisih; //str_replace(',', '', $this->request->getvar('jumlah'));
            $kin_totl = $selisih; //str_replace(',', '', $this->request->getvar('jumlah'));

            // $kin_awal = 0;
            $v_dbt_amnt = 0;
            $v_crd_amnt = 0;
            $cektanggal = $modecek->_get_tgltabungan1($tbg_code, $tanggal);

            $kin_code = $cektanggal['kin_code'];
            $kin_dat1 = $cektanggal['kin_dat1'];
            $kin_dat2 = $cektanggal['kin_date'];


            // if ($kin_code == '') {
            //   $kin_gtot = $kin_totl;
            //   $jmlhari = 0;
            // } else {
            //   $kin_gtot = $cektanggal['kin_gtot'];
            //   $kin_gtot = $kin_gtot + $kin_totl;
            //   $jmlhari = (($tanggal - $kin_dat1) / 60 / 60 / 24) + 1;
            // }
            $jenis = '02';
            if ($jenistran == '01') {
                $debcrt = 'K';
                $v_crd_amnt = $selisih;
                $v_dbt_amnt = 0;
            } else {
                $debcrt = 'D';
                $v_dbt_amnt = $selisih;
                $v_crd_amnt = 0;
            }

            if ($kin_code == '') {
                $kin_gtot = $selisih;
                // $kin_awal = 0;
                $kin_dat1 = $cektanggal['kin_date'];
                $jmlhari = (($tanggal - $kin_dat1) / 60 / 60 / 24);
            } else {
                $kin_dat1 = $cektanggal['kin_date'];
                // $kin_awal = $cektanggal['kin_akhr'];
                $kin_gtot = $kin_awal + $v_crd_amnt - $v_dbt_amnt;
                // $kin_dat1 = date('Y-m-d', strtotime($kin_dat1));
                $tanggl2 = strtotime($tanggal);
                $tanggl1 = strtotime($kin_dat1);
                $jmlhari = (($tanggl2 - $tanggl1) / 60 / 60 / 24);
            }
            $kin_akhr = floatval($kin_awal) - floatval($v_dbt_amnt) +  floatval($v_crd_amnt);
            $data = array(
                'kin_code' => $v_trx_code,
                //$this->request->getvar('norek'),
                'kin_date' => $this->request->getvar('tgl'),
                'agt_numb' => $agt_numb,
                'bnk_code' => $bnk_code,
                'acc_cash' => $acc_prod,
                'kin_type' => $prd_code,
                'kin_desc' => $description,
                'kin_note' => $note,
                'kin_stot' => $selisih,

                // 'acc_admn' => $acc_admn,
                'acc_prod' => $acc_prod,
                'tbg_code' => $tbg_code,
                'kin_mont' => $bulan,
                'kin_year' => $tahun,
                'kin_totl' => $selisih,
                'kin_srno' => $nourut,
                // 'kin_pstr' => $rektujuan,
                'kin_jens' => '01',
                'kin_nstr' => 0,
                'kin_astr' => 0,
                'kin_prem' => 0,
                'kin_pajk' => 0,
                'kin_marg' => 0,
                'acc_prem' => '',
                'acc_pajk' => '',
                'acc_marg' => '',
                'kin_mstr' => 0,
                'kin_debt' => 0,
                'kin_crdt' => $selisih,
                'kin_dbcr' => 'K',
                'kin_stat' => 0,
                'com_code' => 1,

                'trx_jens' => '01',
                'kode_cabang' => $kodecabang,
                'kin_gtot' => $kin_gtot,
                'kin_awal' => $kin_awal,
                'kin_akhr' => $kin_akhr,
                'kin_time' => $waktu,
                'kin_user' => $emp_name,

            );

            $model->_savesetortabungan($data);

            $data = array(
                'kin_dat1' => $this->request->getvar('tgl'),
                'kin_hari' => $jmlhari,
                // 'kin_apus' => $kin_dat1,
            );

            $model->_updatetabungantgl($data, $kin_code);

            // Jurnal

            $data = array(
                'trx_code' => $v_trx_code1,
                'trx_date' => $this->request->getvar('tgl'),
                'acc_code' => $acc_prod,
                'trx_jens' => '01',
                'trx_urut' => 1,
                'trx_dbcr' => 'K',
                'trx_amnt' => $selisih,
                'dbt_amnt' => 0,
                'crd_amnt' => $selisih,
                'trx_des1' => $description,
                'trx_des2' => $description1,
                'com_code' => 1,
                'kode_cabang' => $kodecabang,
                'ent_time' => $waktu,
                'usercreated' => $emp_name,
            );
            $model->_savejurnal($data);
        }

        if ($data) {

            $response['status'] = 'Berhasil';
            $response['data'] = $v_trx_code;
        } else {
            $response['message'] = 'No data found';
        }


        return $this->respondCreated($response);
    }

 public function gettagihan($id = null)
    {
        $model = new Core_model();
        $data = $model->_get_pembiayaan($id)->getResult();

        if ($data) {
            $response['status'] = 'Berhasil';
            return $this->respond($data);
        } else {
            return $this->failNotFound('Data tidak ditemukan.');
        }
    }


public function transppob()
    {
        $model = new Save_model();
        $mgit = new Model_git();
        $modecek = new Auto_model();
        $mcore = new Core_model();
        $note = "";
        $tanggal = $this->request->getvar('tgl_trans');

        $bulan = date('m', strtotime($tanggal));
        $tahun = date('Y', strtotime($tanggal));
        $waktu =
            $this->request->getvar('jam_trans');

        $cek = $modecek->get_nosetortabungan($bulan, $tahun);

        $description = $this->request->getvar('keterangan');

        $nourut = $cek['kin_srno'];
        $rekening = $this->request->getvar('norek');
        $empcode = $this->request->getvar('collector_mobile_id');
        $kodecabang = '';
        $dbemployee = $modecek->get_employee($empcode);
        $emp_name = $dbemployee['emp_name'];
        $bnk_code = $dbemployee['bnk_code'];
        $kodecabang = $dbemployee['kode_cabang'];
        // if ($bnk_code == '') {
        //     $response['message'] = 'Collector No  data found';
        //     return $this->respondCreated($response);
        // }
        $bnk_code = "90";
        $dbbank = $modecek->get_bank($bnk_code);
        $acc_cash = $dbbank['acc_code'];

        $sldawal = $mcore->saldotabungan($rekening);
        $kin_awal = 0;
        foreach ($sldawal->getResult() as $awal) {
            $kin_awal = $awal->kin_awal;
        }
        $cek1 = $mgit->_get_datatabunganab($rekening);
        $agt_numb = '';
        $agt_name = '';
        $prd_code = '';
        $acc_prod = '';
        $acc_admn = '';

        foreach ($cek1->getResult() as $cekrow) {
            $agt_numb = $cekrow->agt_numb;
            $agt_name = $cekrow->agt_name;
            $prd_code = $cekrow->prd_code;
            $prd_name = $cekrow->prd_name;
            $acc_prod = $cekrow->acc_code;
            $acc_admn = $cekrow->acc_cod2;
            // $kodecabang = $cekrow->kode_cabang;
        }
        // $rekening = $cek1['tbg_code'];

        $xprod1 = $prd_code;
        $xprod = substr($xprod1, 0, 1);


        $jns = '02';

        $description1 = 'Transaksi PPOB ' . $prd_name;

        // }
        if ($nourut == '') {
            $nourut = 1;
            $v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . '00001';
        } else {
            $nourut = $nourut + 1;
            if ($nourut < 10) {
                $v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . '0000' . $nourut;
            } else if ($nourut >= 10 and $nourut < 100) {
                $v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . '000' . $nourut;
            } else if ($nourut >= 100 and $nourut < 1000) {
                $v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . '00' . $nourut;
            } else if ($nourut >= 1000 and $nourut < 10000) {
                $v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . '0' . $nourut;
            } else {
                $v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . $nourut;
            }
        }


        $kin_stot = str_replace(',', '', $this->request->getvar('nominal'));
        $kin_admn = str_replace(',', '', $this->request->getvar('admin'));

        $kin_totl = $kin_stot + $kin_admn; // str_replace(',', '', $this->request->getvar('jumlah'));
        // $kin_awal = 0;
        $v_dbt_amnt = 0;
        $v_crd_amnt = 0;
        $cektanggal = $modecek->_get_tgltabungan1($rekening, $tanggal);
        $kin_code = $cektanggal['kin_code'];
        $kin_dat1 = $cektanggal['kin_dat1'];
        $kin_dat2 = $cektanggal['kin_date'];


        // if ($kin_code == '') {
        //   $kin_gtot = $kin_totl;
        //   $jmlhari = 0;
        // } else {
        //   $kin_gtot = $cektanggal['kin_gtot'];
        //   $kin_gtot = $kin_gtot + $kin_totl;
        //   $jmlhari = (($tanggal - $kin_dat1) / 60 / 60 / 24) + 1;
        // }
        if ($jns == '01') {
            $debcrt = 'K';
            $v_crd_amnt = $kin_totl;
            $v_dbt_amnt = 0;
        } else {
            $debcrt = 'D';
            $v_dbt_amnt = $kin_totl;
            $v_crd_amnt = 0;
        }

        if ($kin_code == '') {
            $kin_gtot = $kin_totl;
            // $kin_awal = 0;
            $kin_dat1 = $cektanggal['kin_date'];
            $jmlhari = (($tanggal - $kin_dat1) / 60 / 60 / 24);
        } else {
            $kin_dat1 = $cektanggal['kin_date'];
            // $kin_awal = $cektanggal['kin_akhr'];
            $kin_gtot = $kin_awal + $v_crd_amnt - $v_dbt_amnt;
            // $kin_dat1 = date('Y-m-d', strtotime($kin_dat1));
            $tanggl2 = strtotime($tanggal);
            $tanggl1 = strtotime($kin_dat1);
            $jmlhari = (($tanggl2 - $tanggl1) / 60 / 60 / 24);
        }
        $kin_akhr = $kin_awal - $v_dbt_amnt + $v_crd_amnt;
        $data = array(
            'kin_code' => $v_trx_code,
            //$this->request->getvar('norek'),
            'kin_date' => $this->request->getvar('tgl_trans'),
            'agt_numb' => $agt_numb,
            'bnk_code' => $bnk_code,
            'acc_cash' => $acc_cash,
            'kin_type' => $prd_code,
            'kin_desc' => $description,
            'kin_note' => $note,
            'kin_stot' => $kin_stot,
            'kin_admn' => $kin_admn,
            'acc_admn' => $acc_admn,
            'acc_prod' => $acc_prod,
            'tbg_code' => $rekening,
            'kin_mont' => $bulan,
            'kin_year' => $tahun,
            'kin_totl' => $kin_totl,
            'kin_srno' => $nourut,
            'kin_jens' => '09',
            'kin_nstr' => 0,
            'kin_astr' => 0,
            'kin_prem' => 0,
            'kin_pajk' => 0,
            'kin_marg' => 0,
            'acc_prem' => '',
            'acc_pajk' => '',
            'acc_marg' => '',
            'kin_mstr' => 0,
            'kin_debt' => $v_dbt_amnt,
            'kin_crdt' => $v_crd_amnt,
            'kin_dbcr' => $debcrt,
            'kin_stat' => 0,
            'com_code' => 1,

            'trx_jens' => '09',
            'kode_cabang' => $kodecabang,
            'kin_gtot' => $kin_gtot,
            'kin_awal' => $kin_awal,
            'kin_akhr' => $kin_akhr,
            'kin_time' => $waktu,
            'kin_user' => $emp_name,

        );

        $model->_savesetortabungan($data);



        $data = array(
            'kin_dat1' => $this->request->getvar('tgl_trans'),
            'kin_hari' => $jmlhari,
            // 'kin_apus' => $kin_dat1,
        );

        $model->_updatetabungantgl($data, $kin_code);



        $data = array(
            'trx_code' => $v_trx_code,
            //$this->request->getvar('norek'),
            'trx_date' => $this->request->getvar('tgl_trans'),
            'acc_code' => $acc_prod,
            'trx_jens' => '01',
            'psb_code' => $prd_code,
            'trx_urut' => 1,
            'trx_dbcr' => 'D',
            'trx_amnt' => $kin_totl,
            'dbt_amnt' => $kin_totl,
            'crd_amnt' => 0,
            'trx_des1' => 'Transaksi PPOB',
            'trx_des2' => 'Transaksi PPOB',
            'com_code' =>   1,
            'kode_cabang' => $kodecabang,
            'ent_time' => $waktu,
            'usercreated' => $emp_name,
        );
        $model->_savejurnal($data);


        // Jurnal
        $id = "20";
        $dbppob = $modecek->get_acckhusus($id);
        $acc_ppob = $dbppob['acc_code'];

        $data = array(
            'trx_code' => $v_trx_code,
            //$this->request->getvar('norek'),
            'trx_date' => $this->request->getvar('tgl_trans'),
            'acc_code' => $acc_ppob,
            'trx_jens' => '01',
            'trx_urut' => 1,
            'trx_dbcr' => 'K',
            'trx_amnt' => $kin_stot,
            'dbt_amnt' => 0,
            'crd_amnt' => $kin_stot,
            'trx_des1' => $description,
            'trx_des2' => $description1,
            'com_code' => 1,
            'kode_cabang' => $kodecabang,
            'ent_time' => $waktu,
            'usercreated' => $emp_name,
        );
        $model->_savejurnal($data);
        $id = "21";
        $dbppob = $modecek->get_acckhusus($id);
        $acc_admn = $dbppob['acc_code'];
        $data = array(
            'trx_code' => $v_trx_code,
            //$this->request->getvar('norek'),
            'trx_date' => $this->request->getvar('tgl_trans'),
            'acc_code' => $acc_admn,
            'trx_jens' => '01',
            'trx_urut' => 1,
            'trx_dbcr' => 'K',
            'trx_amnt' => $kin_admn,
            'dbt_amnt' => 0,
            'crd_amnt' => $kin_admn,
            'trx_des1' => "Administrasi PPOB",
            'trx_des2' => 'Administrasi PPOB',
            'com_code' => 1,
            'kode_cabang' => $kodecabang,
            'ent_time' => $waktu,
            'usercreated' => $emp_name,
        );
        $model->_savejurnal($data);

        $id = $rekening;



        // if ($rekening == '') {
        //     if ($jns == '01') {

        //         $vstatus = '1';
        //         $data = array(

        //             'tbg_stat' => $vstatus,
        //             'tbg_aktv' => $this->request->getvar('tgl'),
        //             'tbg_awal' => $kin_stot,

        //         );
        //         $model->_updatetabungan($data, $id);
        //     }
        // }



        $data = $mcore->_get_simpanantransppob($v_trx_code)->getResult();

        if ($data) {

            $response['status'] = 'Transaksi PPOB Berhasil';
            $response['data'] = $data;
        } else {
            $response['message'] = 'No data found';
        }


        return $this->respondCreated($response);
    }


    public function topupvirtualaccount()
    {
        $model = new Save_model();
        $mgit = new Model_git();
        $modecek = new Auto_model();
        $mcore = new Core_model();
        $note = "";
        $tanggal = $this->request->getvar('tgl_trans');

        $bulan = date('m', strtotime($tanggal));
        $tahun = date('Y', strtotime($tanggal));
        $waktu =
            $this->request->getvar('jam_trans');



        $description = $this->request->getvar('keterangan');

        $rekening = $this->request->getvar('norek');
        $empcode = $this->request->getvar('collector_mobile_id');
        $kodecabang = '';
        $dbemployee = $modecek->get_employee($empcode);
        $emp_name = $dbemployee['emp_name'];
        $bnk_code = $dbemployee['bnk_code'];
        $kodecabang = $dbemployee['kode_cabang'];
        // if ($bnk_code == '') {
        //     $response['message'] = 'Collector No  data found';
        //     return $this->respondCreated($response);
        // }
        $bnk_code = "90";
        $dbbank = $modecek->get_bank($bnk_code);
        $acc_cash = $dbbank['acc_code'];

        $sldawal = $mcore->saldotabungan($rekening);
        $kin_awal = 0;
        foreach ($sldawal->getResult() as $awal) {
            $kin_awal = $awal->kin_awal;
        }
        $cek1 = $mgit->_get_datatabunganab($rekening);
        $agt_numb = '';
        $agt_name = '';
        $prd_code = '';
        $acc_prod = '';
        $acc_admn = '';

        foreach ($cek1->getResult() as $cekrow) {
            $agt_numb = $cekrow->agt_numb;
            $agt_name = $cekrow->agt_name;
            $prd_code = $cekrow->prd_code;
            $prd_name = $cekrow->prd_name;
            $acc_prod = $cekrow->acc_code;
            $acc_admn = $cekrow->acc_cod2;
            // $kodecabang = $cekrow->kode_cabang;
        }
        // $rekening = $cek1['tbg_code'];

        $xprod1 = $prd_code;
        $xprod = substr($xprod1, 0, 1);


        $jns = '02';

        $description1 = 'Transaksi PPOB ' . $prd_name;

        // }
        $cek = $modecek->get_nosetortabungan($bulan, $tahun);
        $nourut = $cek['kin_srno'];
        if ($nourut == '') {
            $nourut = 1;
            $v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . '00001';
        } else {
            $nourut = $nourut + 1;
            if ($nourut < 10) {
                $v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . '0000' . $nourut;
            } else if ($nourut >= 10 and $nourut < 100) {
                $v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . '000' . $nourut;
            } else if ($nourut >= 100 and $nourut < 1000) {
                $v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . '00' . $nourut;
            } else if ($nourut >= 1000 and $nourut < 10000) {
                $v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . '0' . $nourut;
            } else {
                $v_trx_code = $kodecabang . '.11.' . $tahun . $bulan . $nourut;
            }
        }


        $kin_stot = str_replace(',', '', $this->request->getvar('nominal'));
        $kin_admn = str_replace(',', '', $this->request->getvar('admin'));

        $kin_totl = $kin_stot + $kin_admn; // str_replace(',', '', $this->request->getvar('jumlah'));
        // $kin_awal = 0;
        $v_dbt_amnt = 0;
        $v_crd_amnt = 0;
        $cektanggal = $modecek->_get_tgltabungan1($rekening, $tanggal);
        $kin_code = $cektanggal['kin_code'];
        $kin_dat1 = $cektanggal['kin_dat1'];
        $kin_dat2 = $cektanggal['kin_date'];


        // if ($kin_code == '') {
        //   $kin_gtot = $kin_totl;
        //   $jmlhari = 0;
        // } else {
        //   $kin_gtot = $cektanggal['kin_gtot'];
        //   $kin_gtot = $kin_gtot + $kin_totl;
        //   $jmlhari = (($tanggal - $kin_dat1) / 60 / 60 / 24) + 1;
        // }
        if ($jns == '01') {
            $debcrt = 'K';
            $v_crd_amnt = $kin_totl;
            $v_dbt_amnt = 0;
        } else {
            $debcrt = 'D';
            $v_dbt_amnt = $kin_totl;
            $v_crd_amnt = 0;
        }

        if ($kin_code == '') {
            $kin_gtot = $kin_totl;
            // $kin_awal = 0;
            $kin_dat1 = $cektanggal['kin_date'];
            $jmlhari = (($tanggal - $kin_dat1) / 60 / 60 / 24);
        } else {
            $kin_dat1 = $cektanggal['kin_date'];
            // $kin_awal = $cektanggal['kin_akhr'];
            $kin_gtot = $kin_awal + $v_crd_amnt - $v_dbt_amnt;
            // $kin_dat1 = date('Y-m-d', strtotime($kin_dat1));
            $tanggl2 = strtotime($tanggal);
            $tanggl1 = strtotime($kin_dat1);
            $jmlhari = (($tanggl2 - $tanggl1) / 60 / 60 / 24);
        }
        $kin_akhr = $kin_awal - $v_dbt_amnt + $v_crd_amnt;
        $data = array(
            'kin_code' => $v_trx_code,
            //$this->request->getvar('norek'),
            'kin_date' => $this->request->getvar('tgl_trans'),
            'agt_numb' => $agt_numb,
            'bnk_code' => $bnk_code,
            'acc_cash' => $acc_cash,
            'kin_type' => $prd_code,
            'kin_desc' => $description,
            'kin_note' => $note,
            'kin_stot' => $kin_stot,
            'kin_admn' => $kin_admn,
            'acc_admn' => $acc_admn,
            'acc_prod' => $acc_prod,
            'tbg_code' => $rekening,
            'kin_mont' => $bulan,
            'kin_year' => $tahun,
            'kin_totl' => $kin_totl,
            'kin_srno' => $nourut,
            'kin_jens' => '09',
            'kin_nstr' => 0,
            'kin_astr' => 0,
            'kin_prem' => 0,
            'kin_pajk' => 0,
            'kin_marg' => 0,
            'acc_prem' => '',
            'acc_pajk' => '',
            'acc_marg' => '',
            'kin_mstr' => 0,
            'kin_debt' => $v_dbt_amnt,
            'kin_crdt' => $v_crd_amnt,
            'kin_dbcr' => $debcrt,
            'kin_stat' => 0,
            'com_code' => 1,

            'trx_jens' => '09',
            'kode_cabang' => $kodecabang,
            'kin_gtot' => $kin_gtot,
            'kin_awal' => $kin_awal,
            'kin_akhr' => $kin_akhr,
            'kin_time' => $waktu,
            'kin_user' => $emp_name,

        );

        $model->_savesetortabungan($data);



        $data = array(
            'kin_dat1' => $this->request->getvar('tgl_trans'),
            'kin_hari' => $jmlhari,
            // 'kin_apus' => $kin_dat1,
        );

        $model->_updatetabungantgl($data, $kin_code);



        $data = array(
            'trx_code' => $v_trx_code,
            //$this->request->getvar('norek'),
            'trx_date' => $this->request->getvar('tgl_trans'),
            'acc_code' => $acc_prod,
            'trx_jens' => '01',
            'psb_code' => $prd_code,
            'trx_urut' => 1,
            'trx_dbcr' => 'D',
            'trx_amnt' => $kin_totl,
            'dbt_amnt' => $kin_totl,
            'crd_amnt' => 0,
            'trx_des1' => 'Transaksi PPOB',
            'trx_des2' => 'Transaksi PPOB',
            'com_code' =>   1,
            'kode_cabang' => $kodecabang,
            'ent_time' => $waktu,
            'usercreated' => $emp_name,
        );
        $model->_savejurnal($data);


        // Jurnal
        $id = "20";
        $dbppob = $modecek->get_acckhusus($id);
        $acc_ppob = $dbppob['acc_code'];

        $data = array(
            'trx_code' => $v_trx_code,
            //$this->request->getvar('norek'),
            'trx_date' => $this->request->getvar('tgl_trans'),
            'acc_code' => $acc_ppob,
            'trx_jens' => '01',
            'trx_urut' => 1,
            'trx_dbcr' => 'K',
            'trx_amnt' => $kin_stot,
            'dbt_amnt' => 0,
            'crd_amnt' => $kin_stot,
            'trx_des1' => $description,
            'trx_des2' => $description1,
            'com_code' => 1,
            'kode_cabang' => $kodecabang,
            'ent_time' => $waktu,
            'usercreated' => $emp_name,
        );
        $model->_savejurnal($data);
        $id = "21";
        $dbppob = $modecek->get_acckhusus($id);
        $acc_admn = $dbppob['acc_code'];
        $data = array(
            'trx_code' => $v_trx_code,
            //$this->request->getvar('norek'),
            'trx_date' => $this->request->getvar('tgl_trans'),
            'acc_code' => $acc_admn,
            'trx_jens' => '01',
            'trx_urut' => 1,
            'trx_dbcr' => 'K',
            'trx_amnt' => $kin_admn,
            'dbt_amnt' => 0,
            'crd_amnt' => $kin_admn,
            'trx_des1' => "Administrasi PPOB",
            'trx_des2' => 'Administrasi PPOB',
            'com_code' => 1,
            'kode_cabang' => $kodecabang,
            'ent_time' => $waktu,
            'usercreated' => $emp_name,
        );
        $model->_savejurnal($data);

        $id = $rekening;



        // if ($rekening == '') {
        //     if ($jns == '01') {

        //         $vstatus = '1';
        //         $data = array(

        //             'tbg_stat' => $vstatus,
        //             'tbg_aktv' => $this->request->getvar('tgl'),
        //             'tbg_awal' => $kin_stot,

        //         );
        //         $model->_updatetabungan($data, $id);
        //     }
        // }



        $data = $mcore->_get_simpanantransppob($v_trx_code)->getResult();

        if ($data) {

            $response['status'] = 'Transaksi PPOB Berhasil';
            $response['data'] = $data;
        } else {
            $response['message'] = 'No data found';
        }


        return $this->respondCreated($response);
    }

    public function testapi()
    {
        $model = new Save_model();
 $response['status'] = 'OK';

            return $this->respond($response, 100);

        $post_data = json_decode(file_get_contents('php://input'), true);
        $norek = trim($post_data['norek']);
        $nama = trim($post_data['nama']);
        $data = array(
            'tbg_code' => $norek,
            'tbg_name' => $nama
        );
        $model->_savevirtual($data);
        if ($data) {

            $response['status'] = 'Berhasil';

            return $this->respond($response, 200);
        } else {
            $response['status'] = 'error';
            $response['message'] = 'No data found';
            return $this->respond($response, 404);
        }
    }
}
