<?php

namespace App\Controllers;

use App\Models\Delete_model;
use App\Models\Master_model;
use App\Models\Save_model;
use App\Models\Dashboard_model;

class Dashboard extends BaseController
{
  public function __construct()
  {
    $session = session();
    date_default_timezone_set('Asia/Jakarta');
  }
  public function index()
  {
    $_SESSION['com_menu'] = '';
    $_SESSION['com_men1'] = '';
    $_SESSION['com_men2'] = '';
  }

  public function anggota1()
  {
    $model = new Dashboard_model();
    $mmodel = new Master_model();
    $_SESSION['com_menu'] = '00';
    $_SESSION['com_men1'] = '0001';
    $_SESSION['com_men2'] = '';
    $tahun = date('Y');
    $bulan = date('m');
    $data['v_bulan'] = $model->_get_dbbulan()->getResult();
    $data['v_tahun']  = $mmodel->_get_tahun()->getResult();
    $data['v_data'] = $model->_get_dbanggota($tahun, $bulan)->getResult();

    return view('dashboard/anggota', $data);
  }
  public function anggotabulan()
  {
    $model = new Dashboard_model();
    $mmodel = new Master_model();
    $_SESSION['com_menu'] = '00';
    $_SESSION['com_men1'] = '0001';
    $_SESSION['com_men2'] = '000102';
    $tahun = date('Y');
    $bulan = date('m');
    $data['v_bulan'] = $model->_get_dbbulan()->getResult();
    $data['v_tahun']  = $mmodel->_get_tahun()->getResult();
    $data['v_data'] = $model->_get_dbanggota($tahun, $bulan)->getResult();

    return view('dashboard/anggotatahun', $data);
  }
  public function anggota()
  {
    $model = new Dashboard_model();
    $mmodel = new Master_model();
    $_SESSION['com_menu'] = '00';
    $_SESSION['com_men1'] = '0001';
    $_SESSION['com_men2'] = '';

    $data['v_bulan'] = $model->_get_dbbulan()->getResult();
    $data['v_tahun']  = $mmodel->_get_tahun()->getResult();

    // $data['v_data'] = $model->_get_dbanggotatahun($tahun)->getResult();

    return view('dashboard/anggotatahun', $data);
  }
  public function get_anggotatahun()
  {
    $model = new Dashboard_model();
    $modsave = new Save_model();
    $master = new Master_model();
    $moddelete = new Delete_model();
    $tahun =  $this->request->getVar('id');
    $jns = 'A1';
    $moddelete->_deletetahunan($tahun, $jns);
    $dtbulan = $master->_get_bulan();
    foreach ($dtbulan->getResult() as $row1) {
      $blncode = ($row1->bln_cod1);
      $dbjumssb = $model->_get_dbanggota($tahun, $blncode);
      // $a = 0;
      $jum_angg = 0;
      $jum_nila = 0;
      foreach ($dbjumssb->getResult() as $nil) {
        $a = 1;
        $jum_angg = $nil->calonanggota;
        $jum_nila = $nil->aktif;
        // $totagt = $totagt . $jum_angg . ',';
        // $totnil = $totnil . $jum_nila . ',';
      }

      $data = array(
        'com_code'  => session()->get('com_code'),
        'kode_cabang'  => session()->get('kode_cabang'),
        'trx_jens' => $jns,
        'grp_mont' => $blncode,
        'grp_year' => $tahun,
        'grp_juml' => $jum_angg,
        'grp_nila' => $jum_nila,
      );
      $modsave->_savegraph($data);
    }

    $data = $model->_dbgraphtahun($tahun, $jns)->getResult();

    echo json_encode($data);
  }
  public function simpanan()
  {
    $model = new Dashboard_model();
    $mmodel = new Master_model();
    $_SESSION['com_menu'] = '00';
    $_SESSION['com_men1'] = '0001';
    $_SESSION['com_men2'] = '';
    $id1 = 'T';
    $data['v_product']  = $mmodel->_get_productb($id1)->getResult();
    $tahun = date('Y');
    $bulan = date('m');

    $data['v_bulan'] = $model->_get_dbbulan()->getResult();
    $data['v_tahun']  = $mmodel->_get_tahun()->getResult();

    $dbproduct = $model->_get_productb($id1);
    $totagt = '';
    $totnil = '';

    foreach ($dbproduct->getResult() as $prod) {
      $prd_code = $prod->prd_code;
      $dbjumskb = $model->_get_dbsimpanan($prd_code, $bulan, $tahun);
      $a = 0;
      foreach ($dbjumskb->getResult() as $nil) {
        $a = 1;
        $jum_angg = $nil->jum_angg;
        $jum_nila = $nil->jum_nila / 1000000;
        $totagt = $totagt . $jum_angg . ',';
        $totnil = $totnil . $jum_nila . ',';
      }
      if ($a < 1) {
        $totagt = $totagt . '0,';
        $totnil = $totnil . '0,';
      }
    }
    $data['jumanggota']  = $totagt;
    $data['jumnilai']  = $totnil;
    return view('dashboard/das_simpanan', $data);
  }
  public function simpananbulan()
  {
    $model = new Dashboard_model();
    $mmodel = new Master_model();
    $_SESSION['com_menu'] = '00';
    $_SESSION['com_men1'] = '0002';
    $_SESSION['com_men2'] = '000201';
    $id1 = 'T';
    $data['v_product']  = $mmodel->_get_productb($id1)->getResult();
    $data['v_bulan'] = $model->_get_dbbulan()->getResult();
    $data['v_tahun']  = $mmodel->_get_tahun()->getResult();

    // $dbproduct = $model->_get_productb($id1);
    // $totagt = '';
    // $totnil = '';

    // foreach ($dbproduct->getResult() as $prod) {
    //     $prd_code = $prod->prd_code;
    //     $dbjumskb = $model->_get_dbsimpanan($prd_code, $bulan, $tahun);
    //     $a = 0;
    //     foreach ($dbjumskb->getResult() as $nil) {
    //         $a = 1;
    //         $jum_angg = $nil->jum_angg;
    //         $jum_nila = $nil->jum_nila / 1000000;
    //         $totagt = $totagt . $jum_angg . ',';
    //         $totnil = $totnil . $jum_nila . ',';
    //     }
    //     if ($a < 1) {
    //         $totagt = $totagt . '0,';
    //         $totnil = $totnil . '0,';
    //     }
    // }
    // $data['jumanggota']  = $totagt;
    // $data['jumnilai']  = $totnil;
    return view('dashboard/das_simpananbulan', $data);
  }
  public function simpanantahun()
  {
    $model = new Dashboard_model();
    $mmodel = new Master_model();
    $_SESSION['com_menu'] = '00';
    $_SESSION['com_men1'] = '0002';
    $_SESSION['com_men2'] = '000202';
    $id1 = 'T';

    $tahun = date('Y');
    $bulan = date('m');
    $data['tahun'] = date('Y');
    $data['bulan'] = date('m');
    $data['v_product']  = $mmodel->_get_productb($id1)->getResult();
    $data['v_bulan'] = $model->_get_dbbulan()->getResult();
    $data['v_tahun']  = $mmodel->_get_tahun()->getResult();

    $dbproduct = $model->_get_productb($id1);
    $totagt = '';
    $totnil = '';

    foreach ($dbproduct->getResult() as $prod) {
      $prd_code = $prod->prd_code;
      $dbjumspinjamam = $model->_get_dbsimpanan($prd_code, $bulan, $tahun);
      $a = 0;
      foreach ($dbjumspinjamam->getResult() as $nil) {
        $a = 1;
        $jum_angg = $nil->jum_angg;
        $jum_nila = $nil->jum_nila / 1000000;
        $totagt = $totagt . $jum_angg . ',';
        $totnil = $totnil . $jum_nila . ',';
      }
      if ($a < 1) {
        $totagt = $totagt . '0,';
        $totnil = $totnil . '0,';
      }
    }
    $data['jumanggota']  = $totagt;
    $data['jumnilai']  = $totnil;

    return view('dashboard/das_simpanantahun', $data);
  }
  public function pembiayaan()
  {
    $model = new Dashboard_model();
    $mmodel = new Master_model();
    $_SESSION['com_menu'] = '00';
    $_SESSION['com_men1'] = '0001';
    $_SESSION['com_men2'] = '';
    $id1 = 'K';

    $tahun = date('Y');
    $bulan = date('m');
    $data['tahun'] = date('Y');
    $data['bulan'] = date('m');
    $data['v_product']  = $mmodel->_get_productb($id1)->getResult();
    $data['v_bulan'] = $model->_get_dbbulan()->getResult();
    $data['v_tahun']  = $mmodel->_get_tahun()->getResult();

    $dbproduct = $model->_get_productb($id1);
    $totagt = '';
    $totnil = '';

    foreach ($dbproduct->getResult() as $prod) {
      $prd_code = $prod->prd_code;
      $dbjumspinjamam = $model->_get_dbpinjaman($prd_code, $bulan, $tahun);
      $a = 0;
      foreach ($dbjumspinjamam->getResult() as $nil) {
        $a = 1;
        $jum_angg = $nil->jum_angg;
        $jum_nila = $nil->jum_nila / 1000000;
        $totagt = $totagt . $jum_angg . ',';
        $totnil = $totnil . $jum_nila . ',';
      }
      if ($a < 1) {
        $totagt = $totagt . '0,';
        $totnil = $totnil . '0,';
      }
    }
    $data['jumanggota']  = $totagt;
    $data['jumnilai']  = $totnil;

    return view('dashboard/das_pembiayaan', $data);
  }
  public function pinjamanbulan()
  {
    $model = new Dashboard_model();
    $mmodel = new Master_model();
    $_SESSION['com_menu'] = '00';
    $_SESSION['com_men1'] = '0004';
    $_SESSION['com_men2'] = '000401';
    $id1 = 'K';

    $tahun = date('Y');
    $bulan = date('m');
    $data['tahun'] = date('Y');
    $data['bulan'] = date('m');
    $data['v_product']  = $mmodel->_get_productb($id1)->getResult();
    $data['v_bulan'] = $model->_get_dbbulan()->getResult();
    $data['v_tahun']  = $mmodel->_get_tahun()->getResult();



    return view('dashboard/das_pembiayaanbulan', $data);
  }
  public function pinjamantahun()
  {
    $model = new Dashboard_model();
    $mmodel = new Master_model();
    $_SESSION['com_menu'] = '00';
    $_SESSION['com_men1'] = '0004';
    $_SESSION['com_men2'] = '000402';
    $id1 = 'K';

    $tahun = date('Y');
    $bulan = date('m');
    $data['tahun'] = date('Y');
    $data['bulan'] = date('m');
    $data['v_product']  = $mmodel->_get_productb($id1)->getResult();
    $data['v_bulan'] = $model->_get_dbbulan()->getResult();
    $data['v_tahun']  = $mmodel->_get_tahun()->getResult();

    $dbproduct = $model->_get_productb($id1);
    $totagt = '';
    $totnil = '';

    foreach ($dbproduct->getResult() as $prod) {
      $prd_code = $prod->prd_code;
      $dbjumspinjamam = $model->_get_dbpinjaman($prd_code, $bulan, $tahun);
      $a = 0;
      foreach ($dbjumspinjamam->getResult() as $nil) {
        $a = 1;
        $jum_angg = $nil->jum_angg;
        $jum_nila = $nil->jum_nila / 1000000;
        $totagt = $totagt . $jum_angg . ',';
        $totnil = $totnil . $jum_nila . ',';
      }
      if ($a < 1) {
        $totagt = $totagt . '0,';
        $totnil = $totnil . '0,';
      }
    }
    $data['jumanggota']  = $totagt;
    $data['jumnilai']  = $totnil;

    return view('dashboard/das_pembiayaantahun', $data);
  }
  public function skb()
  {
    $model = new Dashboard_model();
    $mmodel = new Master_model();
    $_SESSION['com_menu'] = '00';
    $_SESSION['com_men1'] = '0001';
    $_SESSION['com_men2'] = '';
    $id1 = 'D';

    $data['v_product']  = $mmodel->_get_productb($id1)->getResult();
    $tahun = date('Y');
    $bulan = date('m');


    $data['v_bulan'] = $model->_get_dbbulan()->getResult();
    $data['v_tahun']  = $mmodel->_get_tahun()->getResult();

    $dbproduct = $model->_get_productb($id1);
    $totagt = '';
    $totnil = '';

    foreach ($dbproduct->getResult() as $prod) {
      $prd_code = $prod->prd_code;
      $dbjumskb = $model->_get_dbskb($prd_code, $bulan, $tahun);
      $a = 0;
      foreach ($dbjumskb->getResult() as $nil) {
        $a = 1;
        $jum_angg = $nil->jum_angg;
        $jum_nila = $nil->jum_nila / 1000000;
        $totagt = $totagt . $jum_angg . ',';
        $totnil = $totnil . $jum_nila . ',';
      }
      if ($a < 1) {
        $totagt = $totagt . '0,';
        $totnil = $totnil . '0,';
      }
    }
    $data['jumanggota']  = $totagt;
    $data['jumnilai']  = $totnil;
    return view('dashboard/das_ssb', $data);
  }
  public function skbbulan()
  {
    $model = new Dashboard_model();
    $mmodel = new Master_model();
    $_SESSION['com_menu'] = '00';
    $_SESSION['com_men1'] = '0003';
    $_SESSION['com_men2'] = '000302';
    $id1 = 'D';

    $data['v_product']  = $mmodel->_get_productb($id1)->getResult();
    $tahun = date('Y');
    $bulan = date('m');


    $data['v_bulan'] = $model->_get_dbbulan()->getResult();
    $data['v_tahun']  = $mmodel->_get_tahun()->getResult();


    return view('dashboard/das_skbbulan', $data);
  }
  public function skbtahun()
  {
    $model = new Dashboard_model();
    $mmodel = new Master_model();
    $_SESSION['com_menu'] = '00';
    $_SESSION['com_men1'] = '0003';
    $_SESSION['com_men2'] = '000302';
    $id1 = 'D';

    $data['v_product']  = $mmodel->_get_productb($id1)->getResult();
    $tahun = date('Y');
    $bulan = date('m');


    $data['v_bulan'] = $model->_get_dbbulan()->getResult();
    $data['v_tahun']  = $mmodel->_get_tahun()->getResult();

    $dbproduct = $model->_get_productb($id1);
    $totagt = '';
    $totnil = '';

    foreach ($dbproduct->getResult() as $prod) {
      $prd_code = $prod->prd_code;
      $dbjumskb = $model->_get_dbskb($prd_code, $bulan, $tahun);
      $a = 0;
      foreach ($dbjumskb->getResult() as $nil) {
        $a = 1;
        $jum_angg = $nil->jum_angg;
        $jum_nila = $nil->jum_nila / 1000000;
        $totagt = $totagt . $jum_angg . ',';
        $totnil = $totnil . $jum_nila . ',';
      }
      if ($a < 1) {
        $totagt = $totagt . '0,';
        $totnil = $totnil . '0,';
      }
    }
    $data['jumanggota']  = $totagt;
    $data['jumnilai']  = $totnil;
    return view('dashboard/das_skbtahun', $data);
  }
  public function get_anggotabulanan()
  {
    $model = new Dashboard_model();
    $msave = new Save_model();
    $mdelete = new Delete_model();
    $tahun = $this->request->getPost('kin_buln');;
    $bulan = $this->request->getPost('kin_tahn');
    $jns = 'A0';
    $mdelete->_deletebulanan($tahun, $bulan, $jns);
    $dbjumskb = $model->_get_dbanggota($tahun, $bulan);
    $a = 0;
    foreach ($dbjumskb->getResult() as $nil) {
      $a = 1;
      $jum_angg = $nil->jum_angg;
      $jum_nila = $nil->jum_nila / 1000000;
      $data = array(
        'com_code'  => session()->get('com_code'),
        'kode_cabang'  => session()->get('kode_cabang'),
        'trx_jens' => $jns,
        'grp_year' => $tahun,
        'grp_mont' => $bulan,
        'grp_juml' => $jum_angg,
        'grp_nila' => $jum_nila,
      );
      $msave->_savegraph($data);
    }

    $data = $model->_dbgraphbulan($tahun, $bulan, $jns)->getResult();
    echo json_encode($data);
  }

  public function get_pinjamanbulan()
  {
    $model = new Dashboard_model();
    $msave = new Save_model();
    $mdelete = new Delete_model();

    $tahun = $this->request->getPost('tahun');;
    $bulan = $this->request->getPost('bulan');
    $id1 = 'K';
    $jns = 'K0';
    $mdelete->_deletebulanan($tahun, $bulan, $jns);
    $dbproduct = $model->_get_productb($id1);
    $totagt = '';
    $totnil = '';

    foreach ($dbproduct->getResult() as $prod) {
      $prd_code = $prod->prd_code;
      $dbjumskb = $model->_get_dbpinjaman($prd_code, $bulan, $tahun);
      $a = 0;
      foreach ($dbjumskb->getResult() as $nil) {
        $a = 1;
        $jum_angg = $nil->jum_angg;
        $jum_nila = $nil->jum_nila / 1000000;
        $totagt = $totagt . $jum_angg . ',';
        $totnil = $totnil . $jum_nila . ',';
      }
      $data = array(
        'com_code'  => session()->get('com_code'),
        'kode_cabang'  => session()->get('kode_cabang'),
        'trx_jens' => $jns,
        'prd_code' => $prd_code,
        'grp_year' => $tahun,
        'grp_mont' => $bulan,
        'grp_juml' => $jum_angg,
        'grp_nila' => $jum_nila,
      );
      $msave->_savegraph($data);
    }
    $data = $model->_dbgraphbulan($tahun, $bulan, $jns)->getResult();
    echo json_encode($data);
  }
  public function get_skbbulan()
  {
    $model = new Dashboard_model();
    $msave = new Save_model();
    $mdelete = new Delete_model();

    $tahun = $this->request->getPost('tahun');;
    $bulan = $this->request->getPost('bulan');
    $id1 = 'D';
    $jns = 'D0';
    $mdelete->_deletebulanan($tahun, $bulan, $jns);
    $dbproduct = $model->_get_productb($id1);
    $totagt = '';
    $totnil = '';

    foreach ($dbproduct->getResult() as $prod) {
      $prd_code = $prod->prd_code;
      $dbjumskb = $model->_get_dbskb($prd_code, $bulan, $tahun);
      $a = 0;
      foreach ($dbjumskb->getResult() as $nil) {
        $a = 1;
        $jum_angg = $nil->jum_angg;
        $jum_nila = $nil->jum_nila / 1000000;
        $totagt = $totagt . $jum_angg . ',';
        $totnil = $totnil . $jum_nila . ',';
      }
      $data = array(
        'com_code'  => session()->get('com_code'),
        'kode_cabang'  => session()->get('kode_cabang'),
        'trx_jens' => $jns,
        'prd_code' => $prd_code,
        'grp_year' => $tahun,
        'grp_mont' => $bulan,
        'grp_juml' => $jum_angg,
        'grp_nila' => $jum_nila,
      );
      $msave->_savegraph($data);
    }
    $data = $model->_dbgraphbulan($tahun, $bulan, $jns)->getResult();
    echo json_encode($data);
  }

  public function get_simpananbulan()
  {
    $model = new Dashboard_model();
    $modsave = new Save_model();
    $master = new Master_model();
    $moddelete = new Delete_model();
    $tahun = $this->request->getPost('tahun');;
    $bulan = $this->request->getPost('bulan');

    $id1 = 'S';
    $jns = 'T0';
    $moddelete->_deletebulanan($tahun, $bulan, $jns);
    $dbproduct = $model->_get_productb($id1);
    foreach ($dbproduct->getResult() as $row1) {
      $prd_code = ($row1->prd_code);
      $dbjumssb = $model->_get_dbsimpanan($prd_code, $bulan, $tahun);
      // $a = 0;
      $jum_angg = 0;
      $jum_nila = 0;
      foreach ($dbjumssb->getResult() as $nil) {
        $a = 1;
        $jum_angg = $nil->jum_angg;
        $jum_nila = $nil->jum_nila / 1000000;
        // $totagt = $totagt . $jum_angg . ',';
        // $totnil = $totnil . $jum_nila . ',';
      }

      $data = array(
        'com_code'  => session()->get('com_code'),
        'kode_cabang'  => session()->get('kode_cabang'),
        'prd_code' => $prd_code,
        'trx_jens' => $jns,
        'grp_mont' => $bulan,
        'grp_year' => $tahun,
        'grp_juml' => $jum_angg,
        'grp_nila' => $jum_nila,
      );
      $modsave->_savegraph($data);
    }


    $data = $model->_dbgraphbulan($tahun, $bulan, $jns)->getResult();
    echo json_encode($data);
  }
  public function _get_pembiayaantahun1()
  {
    $model = new Dashboard_model();
    $mmodel = new Master_model();
    $mdelete = new Delete_model();
    $msave = new Save_model();
    $id = $this->request->getPost('id');
    $jns = 'K';
    $data = array(
      'com_code'  => session()->get('com_code'),
      'kode_cabang'  => session()->get('kode_cabang'),
      'trx_jens' => 'K',
      'grp_year' => $id,
      'grp_juml' => 0,
      'grp_nila' => 0,
    );
    $msave->_savegraph($data);
    // $mdelete->_get_grptahun($id, $jns);
    // $totagt = '';
    // $totnil = '';
    $dbtahun = $mmodel->_get_bulan();
    foreach ($dbtahun->getResult() as $bln) {
      $bulan = $bln->bln_code;
      // $dbjumspinjamam = $model->_get_dbpinjamantahun($bulan, $id);
      // $a = 0;
      $jum_angg = 0;
      $jum_nila = 0;

      $data = array(
        'com_code'  => session()->get('com_code'),
        'kode_cabang'  => session()->get('kode_cabang'),
        'trx_jens' => 'K',
        'grp_year' => $id,
        'grp_juml' => $jum_angg,
        'grp_nila' => $jum_nila,
      );
      $msave->_savegraph($data);
    }
    $data = $model->_dbgraph($id)->getResult();
    echo json_encode($data);
  }

  public function _get_pembiayaantahun()
  {
    $model = new Dashboard_model();
    $msave = new Save_model();
    $id = $this->request->getPost('id');
    $id = 2024;
    $jns = 'K1';
    $data = array(
      'com_code'  => session()->get('com_code'),
      'kode_cabang'  => session()->get('kode_cabang'),
      'trx_jens' => $jns,
      'grp_mont' => 1,
      'grp_year' => $id,
      'grp_juml' => 0,
      'grp_nila' => 0,
    );
    $msave->_savegraph($data);

    $data = $model->_dbgraphtahun($id, $jns)->getResult();
    echo json_encode($data);
  }

  public function get_pinjamantahun()
  {
    $model = new Dashboard_model();
    $modsave = new Save_model();
    $master = new Master_model();
    $moddelete = new Delete_model();
    $tahun =  $this->request->getPost('id');
    $jns = 'K1';
    $moddelete->_deletetahunan($tahun, $jns);
    $dtbulan = $master->_get_bulan();
    $blnname = "";
    foreach ($dtbulan->getResult() as $row1) {
      $blncode = ($row1->bln_cod1);
      $blnname = $blnname . $row1->bln_nam1 . ',';
      $dbjumspinjamam = $model->_get_dbpinjamantahun($blncode, $tahun);
      // $a = 0;
      $jum_angg = 0;
      $jum_nila = 0;
      $totagt = '';
      $totnil = '';
      foreach ($dbjumspinjamam->getResult() as $nil) {
        $a = 1;
        $jum_angg = $nil->jum_angg;
        $jum_nila = $nil->jum_nila / 1000000;
        $totagt = $totagt . $jum_angg . ',';
        $totnil = $totnil . $jum_nila . ',';
      }

      $data = array(
        'com_code'  => session()->get('com_code'),
        'kode_cabang'  => session()->get('kode_cabang'),
        'trx_jens' => $jns,
        'grp_mont' => $blncode,
        'grp_year' => $tahun,
        'grp_juml' => $jum_angg,
        'grp_nila' => $jum_nila,
      );
      $modsave->_savegraph($data);
    }
    $data['bulanxx']  = $blnname;
    $data['jumanggotaxx']  = $totagt;
    $data['jumnilai']  = $totnil;
    $data = $model->_dbgraphtahun($tahun, $jns)->getResult();

    echo json_encode($data);
  }

  public function get_ssbtahun()
  {
    $model = new Dashboard_model();
    $modsave = new Save_model();
    $master = new Master_model();
    $moddelete = new Delete_model();
    $tahun =  $this->request->getPost('id');
    $jns = 'D1';
    $moddelete->_deletetahunan($tahun, $jns);
    $dtbulan = $master->_get_bulan();
    foreach ($dtbulan->getResult() as $row1) {
      $blncode = ($row1->bln_cod1);
      $dbjumssb = $model->_get_dbssbtahun($blncode, $tahun);
      // $a = 0;
      $jum_angg = 0;
      $jum_nila = 0;
      foreach ($dbjumssb->getResult() as $nil) {
        $a = 1;
        $jum_angg = $nil->jum_angg;
        $jum_nila = $nil->jum_nila / 1000000;
        // $totagt = $totagt . $jum_angg . ',';
        // $totnil = $totnil . $jum_nila . ',';
      }

      $data = array(
        'com_code'  => session()->get('com_code'),
        'kode_cabang'  => session()->get('kode_cabang'),
        'trx_jens' => $jns,
        'grp_mont' => $blncode,
        'grp_year' => $tahun,
        'grp_juml' => $jum_angg,
        'grp_nila' => $jum_nila,
      );
      $modsave->_savegraph($data);
    }

    $data = $model->_dbgraphtahun($tahun, $jns)->getResult();

    echo json_encode($data);
  }


  public function get_simpanantahun()
  {
    $model = new Dashboard_model();
    $modsave = new Save_model();
    $master = new Master_model();
    $moddelete = new Delete_model();
    $tahun =  $this->request->getPost('id');
    $jns = 'T1';
    $moddelete->_deletetahunan($tahun, $jns);
    $dtbulan = $master->_get_bulan();
    foreach ($dtbulan->getResult() as $row1) {
      $blncode = ($row1->bln_cod1);
      $dbjumssb = $model->_get_dbsimpanantahun($blncode, $tahun);
      // $a = 0;
      $jum_angg = 0;
      $jum_nila = 0;
      foreach ($dbjumssb->getResult() as $nil) {
        $a = 1;
        $jum_angg = $nil->jum_angg;
        $jum_nila = $nil->jum_nila / 1000000;
        // $totagt = $totagt . $jum_angg . ',';
        // $totnil = $totnil . $jum_nila . ',';
      }

      $data = array(
        'com_code'  => session()->get('com_code'),
        'kode_cabang'  => session()->get('kode_cabang'),
        'trx_jens' => $jns,
        'grp_mont' => $blncode,
        'grp_year' => $tahun,
        'grp_juml' => $jum_angg,
        'grp_nila' => $jum_nila,
      );
      $modsave->_savegraph($data);
    }

    $data = $model->_dbgraphtahun($tahun, $jns)->getResult();

    echo json_encode($data);
  }

  public function accounting()
  {

    $model = new Dashboard_model();
    $mmodel = new Master_model();
    $_SESSION['com_menu'] = '00';
    $_SESSION['com_men1'] = '0001';
    $_SESSION['com_men2'] = '';
    $tahun = date('Y');
    $acc_code = '';

    $data['v_bulan'] = $model->_get_dbbulan()->getResult();
    $data['v_tahun']  = $mmodel->_get_tahun()->getResult();
    $data['v_data'] = $model->_get_dblabatahun($tahun, $acc_code)->getResult();

    return view('dashboard/das_accounting', $data);
  }

  public function labatahun()
  {
    $model = new Dashboard_model();
    $modsave = new Save_model();
    $master = new Master_model();
    $moddelete = new Delete_model();
    $tahun =  $this->request->getPost('id');
    $tahun1 = $tahun - 1;
    $jns = 'D1';
    $acc_code = session()->get('com_laba');
    $moddelete->_deletetahunan($tahun, $jns);
    $dtbulan = $master->_get_bulan();

    foreach ($dtbulan->getResult() as $row1) {
      $blncode = ($row1->bln_cod1);
      $dblaba = $model->_get_dlabatahun($tahun, $blncode, $acc_code);
      // $a = 0;
      $jum_angg = 0;
      $jum_nila = 0;
      foreach ($dblaba->getResult() as $nil) {
        $a = 1;
        $jum_nila = $nil->acc_akhc;
        // $totagt = $totagt . $jum_angg . ',';
        // $totnil = $totnil . $jum_nila . ',';
      }
      $dblaba1 = $model->_get_dlabatahun($tahun1, $blncode, $acc_code);
      foreach ($dblaba1->getResult() as $nil1) {
        $a = 1;
        $jum_nila1 = $nil1->acc_akhc;
        // $totagt = $totagt . $jum_angg . ',';
        // $totnil = $totnil . $jum_nila . ',';
      }
      $data = array(
        'com_code'  => session()->get('com_code'),
        'kode_cabang'  => session()->get('kode_cabang'),
        'trx_jens' => $jns,
        'grp_mont' => $blncode,
        'grp_year' => $tahun,
        'grp_juml' => $jum_nila,
        'grp_nila' => $jum_nila1 ?? 0,
      );
      $modsave->_savegraph($data);
    }

    $data = $model->_dbgraphtahun($tahun, $jns)->getResult();

    echo json_encode($data);
  }
}
