<?php

namespace App\Controllers;

use App\Models\Delete_model;
use App\Models\Master_model;
use App\Models\Model_closing;
use App\Models\Model_git;
use App\Models\Report_model;
use App\Models\Save_model;
use App\Models\Auto_model;
use App\Models\Asset_model;

class Git extends BaseController
{
   public function __construct()
   {
      $session = session();
      date_default_timezone_set('Asia/Jakarta');
   }

   public function index()
   {
      $_SESSION['com_menu'] = '';
      $_SESSION['com_men1'] = '';
      $_SESSION['com_men2'] = '';
      return view('git');
   }

   public function closingharian()
   {
      $model = new Master_model();
      $data['hariini'] = date('Y-m-d');
      $_SESSION['com_menu'] = '07';
      $_SESSION['com_men1'] = '';
      $_SESSION['com_men2'] = '';
      $data['v_cabang']  = $model->_get_cabang()->getResult();
      return view('closing/harian', $data);
   }


   public function close_harian()
   {
      $model = new Model_closing();
      $model1 = new Save_model();
      $modecek = new Auto_model();

      $modelete = new Delete_model();
      $tanggal1 = $this->request->getPost('trx_date');
      $cabang = $this->request->getPost('cab_code');
      $waktu = date('Y-m-d H:i:s');
      $bulan = date('m', strtotime($tanggal1));
      $tahun = date('Y', strtotime($tanggal1));
      $tgl = date('d', strtotime($tanggal1));


      $trxjens = '05';
      $trxjens1 = 'OBA-0001';

      if ($cabang != '') {
         $modelete->m_deletetabungantglcab($tanggal1, 'H', $cabang);
         $modelete->m_deletjurnal2cab($tanggal1, $trxjens1, $cabang);
         $modelete->m_deletekaspembiayantglcab($tanggal1, 'H', $cabang);
      } else {
         $modelete->m_deletetabungantgl($tanggal1, 'H');
         $modelete->m_deletjurnal2($tanggal1, $trxjens1);
         $modelete->m_deletekaspembiayantgl($tanggal1, 'H');
      }

      // }

      // $modelete->m_deletejasa1($bulan, $tahun);

      $i = 0;

      $bclosing = $model->get_dtclosinharian();

      foreach ($bclosing->getResult() as $row) {
         $v_code = $row->cld_code;

         if ($v_code == '101') {

            //Data Anggota
            $dbanggota = $model->get_dtangota($tgl);
            foreach ($dbanggota->getResult() as $ranggota) {
               $agt_numb = $ranggota->agt_numb;
               $simwajib = 0; // $ranggota->grd_smwa;
               $saldotabungan = 0;
               $tbg_code = '';
               $acc_prod = '';
               $prd_code = '';
               if ($cabang != '') {
                  $dttotal = $model->get_jumtabungancab($agt_numb, $tanggal1, $cabang);
               } else {
                  $dttotal = $model->get_jumtabungan($agt_numb, $tanggal1);
               }
               foreach ($dttotal->getResult() as $rtotal) {
                  $saldotabungan = $rtotal->tbg_totl;
                  $prd_code = $rtotal->kin_type;
                  $acc_prod = $rtotal->acc_prod;
                  $tbg_code = $rtotal->tbg_code;
               }
               // foreach ($dttotal->getResult() as $tot) {


               // }
               $saldotabungan = 0;
               if ($saldotabungan > $simwajib) {
                  //save simwa
                  // $tanggal = $this->request->getPost('kin_date');

                  $type = '06';

                  $cek = $modecek->get_nosetoran($bulan, $tahun);
                  if ($bulan < 10) {
                     $bulan1 = '0' . $bulan;
                  } else {
                     $bulan1 = $bulan;
                  }

                  $nourut = $cek['kin_srno'];
                  $kode_cabang = session()->get('kode_cabang');
                  if ($nourut == '') {
                     $nourut = 1;
                     $v_trx_code = $kode_cabang . '20.' . $tahun . $bulan . '00001';
                  } else {
                     $nourut = $nourut + 1;
                     if ($nourut < 10) {
                        $v_trx_code = $kode_cabang . '20.' . $tahun . $bulan . '0000' . $nourut;
                     } else if ($nourut >= 10 and $nourut < 100) {
                        $v_trx_code = $kode_cabang . '20.' . $tahun . $bulan . '000' . $nourut;
                     } else if ($nourut >= 100 and $nourut < 1000) {
                        $v_trx_code = $kode_cabang . '20.' . $tahun . $bulan . '00' . $nourut;
                     } else if ($nourut >= 1000 and $nourut < 10000) {
                        $v_trx_code = $kode_cabang . '20.' . $tahun . $bulan . '0' . $nourut;
                     } else {
                        $v_trx_code = $kode_cabang . '20.' . $tahun . $bulan . $nourut;
                     }
                  }


                  $data = array(
                     'kin_code'       => $v_trx_code, //$this->request->getPost('kin_code'),
                     'kin_date'       => $tanggal1,
                     'agt_numb'       => $agt_numb,
                     'bnk_code'       => '201',
                     'acc_cash'       => $acc_prod,
                     'knt_code'       => '',
                     'kin_type'       => 'S002',
                     'kin_desc'       => 'Pindah Buku Setoran Simpanan Wajib',
                     'kin_stot'       => $simwajib,
                     'kin_admn'       => 0,
                     'kin_spok'       => 0,
                     'kin_swaj'       => 0,
                     'kin_suka'       => 0,
                     'acc_admn'       => '',
                     'acc_prod'       => $acc_prod,
                     'kin_dend'       => 0,
                     'kin_angs'       => 0,
                     'kin_bung'       => 0,
                     'kin_pokk'       => 0,
                     'kin_mont'       => $bulan,
                     'kin_year'       => $tahun,
                     'kin_totl'       => $simwajib,
                     'kin_srno'       => $nourut,
                     'kin_jens'       => $trxjens1,
                     'kin_stat' => 0,
                     'com_code'  => 1,
                     'kode_cabang'  => session()->get('kode_cabang'),
                  );

                  // $model1->_savesetorpembiayaan($data);


                  $type = '11';
                  $cek = $modecek->get_nosetortabungan($bulan, $tahun);
                  $jns = '02';
                  if ($jns == '01') {
                     $debcrt = 'K';
                     $v_crd_amnt =
                        $simwajib;
                     $v_dbt_amnt = 0;
                  } else {
                     $debcrt = 'D';
                     $v_dbt_amnt =
                        $simwajib;
                     $v_crd_amnt = 0;
                  }

                  if ($bulan < 10) {
                     $bulan1 = '0' . $bulan;
                  } else {
                     $bulan1 = $bulan;
                  }


                  $nourut = $cek['kin_srno'];
                  $kode_cabang = session()->get('kode_cabang');
                  if (
                     $nourut == ''
                  ) {
                     $nourut = 1;
                     $v_trx_code = $kode_cabang . '21.' . $tahun . $bulan . '00001';
                  } else {
                     $nourut = $nourut + 1;
                     if ($nourut < 10) {
                        $v_trx_code = $kode_cabang . '21.' . $tahun . $bulan . '0000' . $nourut;
                     } else if ($nourut >= 10 and $nourut < 100) {
                        $v_trx_code = $kode_cabang . '21.' . $tahun . $bulan . '000' . $nourut;
                     } else if ($nourut >= 100 and $nourut < 1000) {
                        $v_trx_code = $kode_cabang . '21.' . $tahun . $bulan . '00' . $nourut;
                     } else if ($nourut >= 1000 and $nourut < 10000) {
                        $v_trx_code = $kode_cabang . '21.' . $tahun . $bulan . '0' . $nourut;
                     } else {
                        $v_trx_code = $kode_cabang . '21.' . $tahun . $bulan . $nourut;
                     }
                  }


                  $data = array(
                     'kin_code'       => $v_trx_code, //$this->request->getPost('kin_code'),
                     'kin_date'       => $tanggal1,
                     'kin_stot'       =>  $simwajib,
                     'kin_admn'       => 0,
                     'acc_admn'       => '',
                     'acc_prod'       => $acc_prod,
                     'tbg_code'       => $tbg_code,
                     'kin_mont'       => $bulan,
                     'kin_year'       => $tahun,
                     'kin_totl'       => $simwajib,
                     'kin_type'       => 'S002',
                     'agt_numb'       => $agt_numb,
                     'kin_srno'       => $nourut,
                     'kin_nstr'       => 0,
                     'kin_astr'       => 0,
                     'kin_prem'       => 0,
                     'kin_pajk'       => 0,
                     'kin_marg'       => 0,
                     'acc_prem'       => '',
                     'acc_pajk'       => '',
                     'acc_marg'       => '',
                     'kin_mstr'       => 0,
                     'kin_debt'       =>  $simwajib,
                     'kin_crdt'       => 0,
                     'kin_dbcr'       => $debcrt,
                     'bnk_code'       => 'OB',
                     'kin_stat' => 0,
                     'com_code' => 1,
                     'trx_jens' => 'H',
                     'kin_jens'  => '05',
                     'kode_cabang'  => session()->get('kode_cabang'),
                     'kin_time'  => $waktu,
                     'kin_user' => session()->get('username'),


                  );

                  $model1->_savesetortabungan($data);

                  // Jurnal
                  $xcode = 'S-002';
                  $cek = $modecek->get_cekaccount($xcode);

                  $acc_cash = $cek['acc_code'];
                  $data = array(
                     'trx_code' => $v_trx_code, //$this->request->getPost('kin_code'),
                     'trx_date' => $tanggal1,
                     'acc_code'  => $acc_prod,
                     'trx_jens'  => 'OBA-0001',
                     'pry_code'  => 'S-002',
                     'trx_urut' => 1,
                     'trx_dbcr'  => 'D',
                     'trx_amnt'  => $simwajib,
                     'dbt_amnt'  => $simwajib,
                     'crd_amnt'  => 0,
                     'trx_des1'  => 'Over Book dari Tabungan ',
                     'trx_des2'  => '',
                     // 'trx_cod2' => $trxcode,
                     'com_code'  => 1,
                     'kode_cabang'  => session()->get('kode_cabang'),
                     'ent_time' => $waktu,
                     'usercreated' => session()->get('username'),
                  );
                  $model1->_savejurnal($data);


                  // Jurnal

                  $data = array(
                     'trx_code' => $v_trx_code, //$this->request->getPost('kin_code'),
                     'trx_date' => $tanggal1,
                     'acc_code'  => $acc_cash,
                     'psb_code'  => $prd_code,
                     'trx_jens'  => 'OBA-0001',
                     'pry_code'  => 'S-002',
                     'trx_urut' => 1,
                     'trx_dbcr'  => 'K',
                     'trx_amnt'  => $simwajib,
                     'dbt_amnt'  => 0,
                     'crd_amnt'  => $simwajib,
                     'trx_des1'  => 'Setor Wajib',
                     'trx_des2'  => '',
                     // 'trx_cod2' => $trxcode,
                     'com_code'  => 1,
                     'kode_cabang'  => session()->get('kode_cabang'),
                     'ent_time' => $waktu,
                     'usercreated' => session()->get('username'),
                  );
                  $model1->_savejurnal($data);
               }
            }
            // End auto debet simpanan wajib
            // Auto Debet Pembiayaan-------------------




            // 
         }

         // End Auto debet SIMWA
         // Start Auto debet Pembiayaan
         if ($v_code == '102') {
            $dbbiaya = $model->get_dbiaya($tanggal1);
            foreach ($dbbiaya->getResult() as $row) {

               $v_prd_cod1 = $row->prd_code;
               $v_acc_prd1 = $row->acc_code;

               $v_agt_numb = $row->agt_numb;
               $v_knt_code = $row->knt_code;
               $v_tbg_code = $row->tbg_code;
               $v_tot_angs = $row->trx_amnh;
               $v_ang_pokk = $row->trx_pokk;
               $v_ang_bung = $row->trx_bung;
               $v_acc_bung = $row->acc_cod1;
               $jtabungan = 0;
               $acctabungan = '';
               // if ($cabang != '') {
               //    $dttotal = $model->get_totaltabungancab($v_tbg_code, $tanggal1, $cabang);
               // } else {
               $dttotal = $model->get_saldotabungan($v_tbg_code, $tanggal1);
               // }



               foreach ($dttotal->getResult() as $row1) {
                  $jtabungan = $row1->trx_saldo;
                  $acctabungan = $row1->acc_code;
               }
               // $jtabungan1 = 10000000;
               if ($jtabungan > $v_tot_angs) {

                  $cek1 = $modecek->get_nopembiayaan($bulan, $tahun);
                  if ($bulan < 10) {
                     $bulan1 = '0' . $bulan;
                  } else {
                     $bulan1 = $bulan;
                  }

                  $nourut1 = $cek1['kin_srno'];
                  $kode_cabang = session()->get('kode_cabang');
                  if ($nourut1 == '') {
                     $nourut1 = 1;
                     $v_trx_code = $kode_cabang . '21.' . $tahun . $bulan . '00001';
                  } else {
                     $nourut1 = $nourut1 + 1;
                     if ($nourut1 < 10) {
                        $v_trx_code = $kode_cabang . '21.' . $tahun . $bulan . '0000' . $nourut1;
                     } else if ($nourut1 >= 10 and $nourut1 < 100) {
                        $v_trx_code = $kode_cabang . '21.' . $tahun . $bulan . '000' . $nourut1;
                     } else if ($nourut1 >= 100 and $nourut1 < 1000) {
                        $v_trx_code = $kode_cabang . '21.' . $tahun . $bulan . '00' . $nourut1;
                     } else if ($nourut1 >= 1000 and $nourut1 < 10000) {
                        $v_trx_code = $kode_cabang . '21.' . $tahun . $bulan . '0' . $nourut1;
                     } else {
                        $v_trx_code = $kode_cabang . '21.' . $tahun . $bulan . $nourut1;
                     }
                  }

                  $data = array(
                     'kin_code'       => $v_trx_code, //$this->request->getPost('kin_code'),
                     'kin_date'       => $tanggal1,
                     'agt_numb'       => $v_agt_numb,
                     'bnk_code'       => 'OBGT',
                     'knt_code'       => $v_knt_code,
                     'kin_type'       => '05',
                     'kin_desc'       => 'Pindah Buku Auto Debet Pembiayaan No Rekening : ' . $v_knt_code,
                     'kin_stot'       => $v_tot_angs,
                     'kin_totl'       => $v_tot_angs,
                     'acc_cash'       => $v_acc_prd1,
                     'acc_prod'       => $v_acc_bung,
                     'acc_dend'       => '',
                     'acc_admn'       => '',
                     'acc_bung'       => $v_acc_bung,

                     'kin_tdendh'       => 0,
                     'kin_ddendh'       => 0,
                     'kin_tbungh'       => $v_ang_bung,
                     'kin_dbungh'       => 0,
                     'kin_tpokkh'       => $v_ang_pokk,
                     'kin_dpokkh'       => 0,

                     'kin_mont'       => $bulan,
                     'kin_year'       => $tahun,
                     'kin_srno'  => $nourut1,
                     'kin_tran'  => '1',
                     'kin_stat' => '0',
                     'com_code'  => 1,
                     'kin_jens'  => 'H',
                     'kode_cabang'  => session()->get('kode_cabang'),
                  );

                  $model1->_savepembiayaan($data);


                  $cek = $modecek->get_nosetortabungan($bulan, $tahun);

                  $nourut = $cek['kin_srno'];
                  $kode_cabang = session()->get('kode_cabang');
                  if ($nourut == '') {
                     $nourut = 1;
                     $v_trx_code = $kode_cabang . '21.' . $tahun . $bulan . '00001';
                  } else {
                     $nourut = $nourut + 1;
                     if ($nourut < 10) {
                        $v_trx_code = $kode_cabang . '21.' . $tahun . $bulan . '0000' . $nourut;
                     } else if ($nourut >= 10 and $nourut < 100) {
                        $v_trx_code = $kode_cabang . '21.' . $tahun . $bulan . '000' . $nourut;
                     } else if ($nourut >= 100 and $nourut < 1000) {
                        $v_trx_code = $kode_cabang . '21.' . $tahun . $bulan . '00' . $nourut;
                     } else if ($nourut >= 1000 and $nourut < 10000) {
                        $v_trx_code = $kode_cabang . '21.' . $tahun . $bulan . '0' . $nourut;
                     } else {
                        $v_trx_code = $kode_cabang . '21.' . $tahun . $bulan . $nourut;
                     }
                  }

                  $data = array(
                     'kin_code'       => $v_trx_code, //$this->request->getPost('kin_code'),
                     'kin_date'       => $tanggal1,
                     'kin_stot'       => $v_tot_angs,
                     'kin_admn'       => 0,
                     'acc_admn'       => '',
                     'acc_prod'       => $v_acc_prd1,
                     'tbg_code'       => $v_tbg_code,
                     'kin_mont'       => $bulan,
                     'kin_year'       => $tahun,
                     'kin_totl'       => $v_tot_angs,
                     'kin_type'       => $v_prd_cod1,
                     'agt_numb' => $v_agt_numb,
                     'kin_srno'       => $nourut,
                     'kin_nstr'       => 0,
                     'kin_astr'       => 0,
                     'kin_prem'       => 0,
                     'kin_pajk'       => 0,
                     'kin_marg'       => 0,
                     'acc_prem'       => '',
                     'acc_pajk'       => '',
                     'acc_marg'       => '',
                     'kin_mstr'       => 0,
                     'kin_debt'       =>  $v_tot_angs,
                     'kin_crdt'       => 0,
                     'kin_dbcr'       => 'D',
                     'kin_desc'       =>
                     'Pembayaran pembiayaan atas Rekening : ' . $v_knt_code,
                     'kin_stat' => 0,
                     'com_code' => 1,
                     'trx_jens' => 'H',
                     'kin_jens' => '05',
                     'kode_cabang'  => session()->get('kode_cabang'),
                     'kin_time'  => $waktu,
                     'kin_user' => session()->get('username'),

                  );

                  $model1->_savesetortabungan($data);

                  $data = array(

                     'trx_lnsh'  => $v_tot_angs,
                     'lns_pokk'  => $v_ang_pokk,
                     'lns_bung'  => $v_ang_bung,
                     'lns_date'  => $tanggal1,
                     'lns_code'  => $v_trx_code, //$this->request->getPost('kin_code'),
                     'bkt_code'  => $v_trx_code, //$this->request->getPost('kin_code'),
                  );

                  $model1->_Updatekartu1($data, $v_knt_code, $tanggal1);

                  // Tabungan
                  $data = array(
                     'trx_code' => $v_trx_code, //$this->request->getPost('kin_code'),
                     'trx_date' => $tanggal1,
                     'acc_code'  => $acctabungan,
                     'psb_code'  => $v_prd_cod1,
                     'trx_jens'  => 'OBA-0001',
                     'pry_code'  => 'S-002',
                     'trx_urut' => 1,
                     'trx_dbcr'  => 'D',
                     'trx_amnt'  => $v_tot_angs,
                     'dbt_amnt'  => $v_tot_angs,
                     'crd_amnt'  => 0,
                     'trx_des1'  => 'Pindah Buku atas setoran No Rekening : ' . $v_knt_code,
                     'trx_des2'  => '',
                     'com_code'  => 1,
                     'kode_cabang'  => session()->get('kode_cabang'),
                     'ent_time' => $waktu,
                     'usercreated' => session()->get('username'),
                  );
                  $model1->_savejurnal($data);


                  // Jurnal


                  // Pokok 
                  $data = array(
                     'trx_code' => $v_trx_code, //$this->request->getPost('kin_code'),
                     'trx_date' => $tanggal1,
                     'acc_code'  =>  $v_acc_prd1,
                     'psb_code'  => $v_prd_cod1,
                     'trx_jens'  => 'OBA-0001',
                     'pry_code'  => 'S-002',
                     'trx_urut' => 1,
                     'trx_dbcr'  => 'K',
                     'trx_amnt'  => $v_ang_pokk,
                     'dbt_amnt'  => 0,
                     'crd_amnt'  => $v_ang_pokk,
                     'trx_des1'  =>
                     'Pindah Buku untuk Angsuran Setoran Pokok Rekening : ' . $v_knt_code,
                     'trx_des2'  => '',
                     // 'trx_cod2' => $trxcode,
                     'com_code'  => 1,
                     'kode_cabang'  => session()->get('kode_cabang'),
                     'ent_time' => $waktu,
                     'usercreated' => session()->get('username'),
                  );
                  $model1->_savejurnal($data);

                  // Pendapatan Basil
                  $data = array(
                     'trx_code' => $v_trx_code, //$this->request->getPost('kin_code'),
                     'trx_date' => $tanggal1,
                     'acc_code'  => $v_acc_bung,
                     'psb_code'  => $v_prd_cod1,
                     'trx_jens'  => 'OBA-0001',
                     'pry_code'  => 'S-002',
                     'trx_urut' => 1,
                     'trx_dbcr'  => 'K',
                     'trx_amnt'  => $v_ang_bung,
                     'dbt_amnt'  => 0,
                     'crd_amnt'  => $v_ang_bung,
                     'trx_des1'  => 'Bagi Hasil Pindah Buku atas setoran No Rekening : ' . $v_knt_code,
                     'trx_des2'  => '',
                     // 'trx_cod2' => $trxcode,
                     'com_code'  => 1,
                     'kode_cabang'  => session()->get('kode_cabang'),
                     'ent_time' => $waktu,
                     'usercreated' => session()->get('username'),
                  );
                  $model1->_savejurnal($data);
               }





               // Jurnal

            }
         }

         // End Auto debet Pembiayaan
         // Denda
         if ($v_code == '103') {
            $tgl = $tanggal1;
            if ($cabang != '') {
               $dbdenda = $model->get_dbdendacab($tanggal1, $cabang);
            } else {
               $dbdenda = $model->get_dbdenda($tanggal1);
            }
            foreach ($dbdenda->getResult() as $row) {

               $v_trx_code = $row->trx_code;
               $v_trx_date = $row->trx_code;
               $v_trx_jtdt = $row->trx_jtdt;
               $v_agt_numb = $row->agt_numb;
               $v_prs_dend = $row->knt_pden;
               $v_nil_dend = $row->knt_nden;
               $v_nil_angs = $row->trx_amnh;
               $tgl1 = strtotime($v_trx_jtdt);
               $tgl2 = strtotime($tanggal1);
               $jumlhari = ($tgl2 - $tgl1) / 60 / 60 / 24;
               // $jarak = $jumlhari / 60 / 60 / 24;
               // $hari = date_diff($tgl1 - $tgl2);
               $v_tot_deda = $jumlhari * (($v_prs_dend * $v_nil_angs) / 100);
               $data = array(

                  'trx_dend'  => $v_tot_deda,
                  'trx_dhar'  => $jumlhari,
                  'lns_date'  => $v_trx_jtdt,
                  'lns_code'  => $v_trx_code,

               );

               $model1->_Updatekartu1($data, $v_trx_code, $v_trx_jtdt);
            }
         }

         //Bonus
         if ($cabang != '') {
            $dbbonus = $model->get_dbbonuscab($tanggal1, $cabang);
         } else {
            $dbbonus = $model->get_dbbonus($tanggal1);
         }
         foreach ($dbbonus->getResult() as $row) {
            $id = $row->tbg_code;
            $jenbonus = $row->prd_jbon;
            $kelipatan = $row->prd_keli * 1;
            $bonus = $row->prd_bons * 1;
            $jmltabungan = $row->tbg_akh1 * 1;
            if ($jenbonus == 'Point') {
               $jmlbonus = round($jmltabungan / $kelipatan);
            } else {

               $jmlbonus = round(($bonus * $jmltabungan) / 100);
            }
            $data = array(
               'tbg_nbns' => $jmlbonus,
            );
            $model1->_updatetabungan($data, $id);
         }

         // End Denda
         $data = array(
            'inp_date' =>
            $this->request->getPost('trx_date'),
         );
         $model1->_updateakhirmdb($data);
      }

      if ($cabang != '') {
         $dbrollover = $model->get_dtskbarocab($tanggal1, $cabang);
      } else {
         $dbrollover = $model->get_dtskbaro($tanggal1);
      }

      foreach ($dbrollover->getResult() as $row) {
         $tenor = $row->pen_tenr;
         $tgljt = $row->pen_jtdt;
         $norekening = $row->pen_code;
         $tgljt1 = date('Y-m-d', strtotime('+' . $tenor . 'month', strtotime($tgljt)));
         $data = array(
            'pen_jtdt' => $tgljt1,
         );
         $model1->_updatepenempatan($data, $norekening);
      }

      // session()->setFlashdata('berhasil', 'Tutup Buku Harian Berhasil');
      return redirect()->to(base_url('git/closingharian'))->with('success', 'Closing Harian Selesai');
      //
   }


   public function closingbulanan()
   {
      $model = new Master_model();
      $_SESSION['com_menu'] = '07';
      $_SESSION['com_men1'] = '';
      $_SESSION['com_men2'] = '';
      $data['v_tahun']  = $model->_get_tahun()->getResult();
      $data['v_cabang']  = $model->_get_cabang()->getResult();
      return view('closing/bulanan', $data);
   }



   public function closingtahunan()
   {
      $model = new Master_model();
      $_SESSION['com_menu'] = '07';
      $_SESSION['com_men1'] = '';
      $_SESSION['com_men2'] = '';
      $data['v_cabang']  = $model->_get_cabang()->getResult();
      $data['v_tahun']  = $model->_get_tahun()->getResult();
      return view('closing/tahunan', $data);
   }

   public function close_bulanan()
   {

      $model = new Model_closing();
      $model1 = new Save_model();
      $modelete = new Delete_model();
      $modecek = new Auto_model();
      $bulan = $this->request->getPost('kin_buln');
      $tahun = $this->request->getPost('kin_tahn');
      if ($_SESSION['usr_jabt'] == 'Administrator') {
         $cabang = $this->request->getPost('cab_code');
      } else {
         $cabang = session()->get('kode_cabang');
      }
      $Jumlahhari = cal_days_in_month(CAL_GREGORIAN, $bulan, $tahun);
      $hari_ini = $tahun . '-' . $bulan . '-01'; // date("Y-m-d");
      $tgl_pertama = date('Y-m-01', strtotime($hari_ini));
      $tgl_terakhir = date('Y-m-t', strtotime($hari_ini));
      $waktu = date('Y-m-d H:i:s');
      $bulandepan = date('m', strtotime($tgl_pertama));
      $tahundepan = date('Y', strtotime($tgl_pertama));
      if ($bulandepan = 12) {
         $bulandepan = 1;
         $tahundepan = $tahundepan + 1;
      }
      $hari_anggaran = $tahundepan . '-' . $bulandepan . '-01';
      $tgl_pertama_ang = date('Y-m-01', strtotime($hari_anggaran));
      $tgl_terakhir_ang = date('Y-m-t', strtotime($hari_anggaran));
      $spajak = $model->get_company();
      $pjktabungan = 0;
      $pjkdeposito = 0;
      $pphfinalmax = 0;
      foreach ($spajak->getResult()  as $pjk) {
         $pjktabungan = $pjk->com_ppht;
         $pjkdeposito = $pjk->com_pphd;
         $pphfinalmax = $pjk->com_mfinl;
      }
      $trxcode = '09' . $tahun . $bulan;
      $trxjens = 'ATJ-0001';
      if ($cabang != '') {
         $modelete->m_deletetabungan1cab($bulan, $tahun, 'B', $cabang);
         $modelete->m_deletejasa1($bulan, $tahun);

         $modelete->m_deletjurnal1($trxcode, $trxjens);
         $modelete->_deletetranssb1($bulan, $tahun);
      } else {
         $modelete->m_deletetabungan1($bulan, $tahun, 'B');
         $modelete->m_deletejasa1($bulan, $tahun);

         $modelete->m_deletjurnal1($trxcode, $trxjens);
         $modelete->_deletetranssb1($bulan, $tahun);
      }

      // if ($cabang != '') {
      //    $tabungan = $model->get_tabungancab($cabang);
      // } else {
      if ($cabang != '') {
         $tabungan = $model->get_tabungancab($cabang);
      } else {
         $tabungan = $model->get_tabungan();
      }

      // }
      // $tabungan = $model->get_tabungan();
      $i = 0;
      foreach ($tabungan->getResult()  as $row) {
         $norekening = $row->tbg_code;
         $noanggota = $row->agt_numb;
         $prdcode = $row->prd_code;
         $admtype = $row->tbg_padm;
         $prd_name = $row->prd_name;
         $bunga = $row->tbg_marg;
         $admin = $row->tbg_admn;
         $acc_prod = $row->acc_cod1;
         $acc_cash = $row->acc_code;
         $tgl_aktv = $row->tbg_date;
         $pajaktabungan = 0;

         if ($bunga > 0) {
            $cektanggal = $modecek->_get_tgltabungan($norekening, $tgl_terakhir, $bulan, $tahun);
            $kin_code = $cektanggal['kin_code'];
            $kin_dat1 = $cektanggal['kin_dat1'];
            $kin_totl = $cektanggal['kin_gtot'];
            if ($kin_code == '') {

               $kin_gtot = $kin_totl;
               $kin_dat1 = $cektanggal['kin_date'];
               $jmlhari = (($tgl_terakhir - $kin_dat1) / 60 / 60 / 24) + 1;
            } else {
               $kin_dat1 = $cektanggal['kin_date'];
               $kin_gtot = $cektanggal['kin_gtot'];

               // $kin_dat1 = date('Y-m-d', strtotime($kin_dat1));
               $tanggl2 = strtotime($tgl_terakhir);
               $tanggl1 = strtotime($kin_dat1);
               $jmlhari = (($tanggl2 - $tanggl1) / 60 / 60 / 24) + 1;
            }
            $data = array(
               'kin_dat1' => $tgl_terakhir,
               'kin_hari' => $jmlhari,
               // 'kin_apus' => $kin_dat1,
            );

            $model1->_updatetabungantgl($data,  $kin_code);
         }
         if ($bunga > 0); {
            //Saldo Awal
            // $niltabungan = $model->get_nilawaltabungan($norekening, $tgl_pertama);
            // foreach ($niltabungan->getResult()  as $rowawal) {
            //    $totawaltab = $rowawal->totawal;
            // }
            //Transaksi
            // $niltrantabungan = $model->get_niltranstabungan($norekening, $tgl_pertama, $tgl_terakhir);
            // $saldotabungan = $totawaltab;
            // // $saldotabungan = 0;
            // $tgltrans1 = $tgl_terakhir;
            // $hari = 0;
            // $i = 0;
            // foreach ($niltrantabungan->getResult()  as $rowtrans) {
            //    // $niltrantabungan = $model->get_niltranstabungan133($norekening, $tgl_pertama, $tgl_terakhir);
            //    $tgltrans = $rowtrans->kin_date;
            //    //Cek tanggal terakhir trans'
            //    // $tgltabungan = $model->get_tgltabungan($norekening, $tgl_pertama);

            //    if ($i = 0) {

            //    $   $jmlhari = (($tgl_terakhir - $tgltrans) / 60 / 60 / 24) + 1;
            //       // $jmlhari = $tgltrans1 - $tgltrans;
            //    } else {
            //       $jmlhari = (($tgltrans1 - $tgltrans) / 60 / 60 / 24) + 1;
            //       // $jmlhari = $tgl_terakhir - $tgltrans;

            //    }

            //    $jmlhari = (($tgltrans1 - $tgltrans) / 60 / 60 / 24) + 1;
            //    $trantab = $rowtrans->totsaldo;
            //    $tottranstab = $trantab * $jmlhari;
            //    $saldotabungan = ($saldotabungan + $trantab);
            //    // $tgltrans1 = $rowtrans->kin_date;
            //    $hari = $hari + $jmlhari;
            //    $data = array(
            //       'tbg_code' => $norekening,
            //       'tbg_date' => $tgltrans,
            //       'tbg_dat1' => $tgltrans1,
            //       'tbg_sald' => $trantab,
            //       'tbg_hari' => $jmlhari,
            //       'tbg_totl' => $tottranstab,
            //    );
            //    $model1->_savehistoritab($data);
            //    $tgltrans1 = $rowtrans->kin_date;
            // }
            // $jmlhari = $tgltrans1 - $tgl_pertama;
            // $tottranstab = $trantab * $jmlhari;
            // $saldotabungan = ($saldotabungan + $tottranstab);
            // Sisa Saldo Harian
            $niltabungan = $model->get_nilssrtabungan($norekening, $tgl_pertama, $tgl_terakhir);
            $jmlhari = 0;
            $jmlsaldo = 0;
            $srr = 0;
            foreach ($niltabungan->getResult()  as $rowawal) {
               $jmlhari = $rowawal->hari;
               $jmlsaldo = $rowawal->saldo;
               if ($jmlsaldo > 0 and $jmlhari > 0) {
                  $srr = $jmlsaldo / $jmlhari;
               } else {
                  $srr = 0;
               }
            }

            $niljasa = round(($srr * ($bunga / 100) * $Jumlahhari) / 365);

            // $bungahari = (($bunga / 100) * $jmlhari) / 365;
            // $niljasa = round($srr * $bungahari);
            $pajaktabungan = Round(($niljasa * $pjktabungan) / 100);
            //Bunga Tabungan = Rp25 juta x (5% x 28) / 365 = Rp 95.890

         }
         // $model = new Model_closing();
         $niltabungan = $model->get_niltabungan($norekening, $bulan, $tahun);
         $jhari = 0;

         $totaltabungan = $niltabungan['tbg_totl'];
         // if ($tgl_aktv > $tgl_pertama and $tgl_aktv < $tgl_terakhir) {
         //    $bungahari = ($bunga /100)* 365;
         //    $jhari = $tgl_terakhir - $tgl_aktv;

         //    $niljasa = (($totaltabungan * $bungahari) / 100) * $jhari;
         // } else {
         //    $niljasa = (($totaltabungan * $bunga) / 100) / 12;
         // }

         // $niljasa = (($totaltabungan * $bunga) / 100) / 12;
         // $pajaktabungan = Round(($niljasa * $pjktabungan) / 100);



         if ($niljasa < 0) {
            $niljasa = round((-1 * $niljasa), 2);
         }


         if ($niljasa <> 0) {
            $data = array(
               'agt_numb' => $noanggota,
               'tbg_code' => $norekening,
               'prd_code' => $prdcode,
               'jas_mont' => $bulan,
               'jas_amnt' => $niljasa,
               'jas_year' => $tahun,
               'jas_date' => $tgl_terakhir,
               'jas_desc' => 'JASA SIMPANAN/TABUNGAN' . $prd_name,
               'jas_code' => '09' . $tahun . $bulan . $norekening . $i . -1,
               'com_code' => 1,
               'trx_type' => '04',
               'jas_jens' => 'T',
               'jas_sald' => $totaltabungan,
               'jas_pphf' => $pajaktabungan,
               'jas_marg' => $bunga,
               'jas_admn' => $admin,
               'kode_cabang' => session()->get('kode_cabang'),
            );

            $model1->_savejasa($data);
            //Jasa Bagi Hasil
            $cek = $modecek->get_nosetortabungan($bulan, $tahun);
            $nourut = $cek['kin_srno'];
            if ($nourut == '') {
               $nourut = 1;
               $v_trx_code = $$cabang . '.11.' . $tahun . $bulan . '00001';
            } else {
               $nourut = $nourut + 1;
               if ($nourut < 10) {
                  $v_trx_code = $cabang . '.11.' . $tahun . $bulan . '0000' . $nourut;
               } else if ($nourut >= 10 and $nourut < 100) {
                  $v_trx_code = $cabang . '.11.' . $tahun . $bulan . '000' . $nourut;
               } else if ($nourut >= 100 and $nourut < 1000) {
                  $v_trx_code = $cabang . '.11.' . $tahun . $bulan . '00' . $nourut;
               } else if ($nourut >= 1000 and $nourut < 10000) {
                  $v_trx_code = $cabang . '.11.' . $tahun . $bulan . '0' . $nourut;
               } else {
                  $v_trx_code = $cabang . '.11.' . $tahun . $bulan . $nourut;
               }
            }


            $data = array(
               'kin_code' => $v_trx_code,
               'kin_date' => $tgl_terakhir,
               'agt_numb' => $noanggota,
               'tbg_code' => $norekening,
               'kin_type' => $prdcode,
               'kin_mont' => $bulan,
               'kin_stot' => $niljasa,
               'kin_totl' => $niljasa,
               'kin_crdt' => $niljasa,
               'kin_debt' => 0,
               'kin_dbcr' => 'K',
               'kin_year' => $tahun,
               'com_code' => 1,
               'acc_prod' => $acc_prod,
               'acc_cash' => $acc_cash,
               'kin_srno' => $nourut,
               'kin_jens' => '05',
               'kin_desc' => 'Jasa bagi hasil',
               'trx_jens' => 'B',
               'kode_cabang' => $cabang,
               'kin_time'  => $waktu,
               'kin_user' => session()->get('username'),



            );
            $model1->_savesetortabungan($data);
         }
         if ($pajaktabungan > 0) {
            $i = $i + 1;
            $cek = $modecek->get_nosetortabungan($bulan, $tahun);
            $nourut = $cek['kin_srno'];
            if ($nourut == '') {
               $nourut = 1;
               $v_trx_code = $$cabang . '.11.' . $tahun . $bulan . '00001';
            } else {
               $nourut = $nourut + 1;
               if ($nourut < 10) {
                  $v_trx_code = $cabang . '.11.' . $tahun . $bulan . '0000' . $nourut;
               } else if ($nourut >= 10 and $nourut < 100) {
                  $v_trx_code = $cabang . '.11.' . $tahun . $bulan . '000' . $nourut;
               } else if ($nourut >= 100 and $nourut < 1000) {
                  $v_trx_code = $cabang . '.11.' . $tahun . $bulan . '00' . $nourut;
               } else if ($nourut >= 1000 and $nourut < 10000) {
                  $v_trx_code = $cabang . '.11.' . $tahun . $bulan . '0' . $nourut;
               } else {
                  $v_trx_code = $cabang . '.11.' . $tahun . $bulan . $nourut;
               }
            }
            $data = array(
               'kin_code'       => $v_trx_code,
               'kin_date'       => $tgl_terakhir,
               'agt_numb'       => $noanggota,
               'tbg_code'       => $norekening,
               'kin_type'       => $prdcode,
               'kin_mont'       => $bulan,
               'kin_stot'       => $pajaktabungan,
               'kin_totl'       => $pajaktabungan,
               'kin_crdt'       => 0,
               'kin_debt'       => $pajaktabungan,
               'kin_dbcr'       => 'D',
               'kin_year'       => $tahun,
               'com_code'       => 1,
               'acc_prod'       => $acc_prod,
               'acc_cash'       => $acc_cash,
               'kin_jens'       => '05',
               'kin_desc'       => 'Pajak Tabungan',
               'trx_jens'       => 'B',
               'kin_srno' => $nourut,
               'kode_cabang'  => $cabang,
               'kin_time'  => $waktu,
               'kin_user' => session()->get('username'),



            );
            $model1->_savesetortabungan($data);
         }

         //   Administrasi
         // $i = $i + 1;
         if ($admin > 0) {
            $cek = $modecek->get_nosetortabungan($bulan, $tahun);
            $nourut = $cek['kin_srno'];
            if ($nourut == '') {
               $nourut = 1;
               $v_trx_code = $$cabang . '.11.' . $tahun . $bulan . '00001';
            } else {
               $nourut = $nourut + 1;
               if ($nourut < 10) {
                  $v_trx_code = $cabang . '.11.' . $tahun . $bulan . '0000' . $nourut;
               } else if ($nourut >= 10 and $nourut < 100) {
                  $v_trx_code = $cabang . '.11.' . $tahun . $bulan . '000' . $nourut;
               } else if ($nourut >= 100 and $nourut < 1000) {
                  $v_trx_code = $cabang . '.11.' . $tahun . $bulan . '00' . $nourut;
               } else if ($nourut >= 1000 and $nourut < 10000) {
                  $v_trx_code = $cabang . '.11.' . $tahun . $bulan . '0' . $nourut;
               } else {
                  $v_trx_code = $cabang . '.11.' . $tahun . $bulan . $nourut;
               }
            }
            $data = array(
               'kin_code'       => session()->get('kode_cabang') . '09' . $tahun . $bulan . $norekening . $i . -2,
               'kin_date'       => $tgl_terakhir,
               'agt_numb'       => $noanggota,
               'tbg_code'       => $norekening,
               'kin_type'       => $prdcode,
               'kin_mont'       => $bulan,
               'kin_stot'       => $admin,
               'kin_totl'       => $admin,
               'kin_crdt'       => 0,
               'kin_debt'       => $admin,
               'kin_dbcr'       => 'D',
               'kin_year'       => $tahun,
               'com_code'       => 1,
               'acc_prod'       => $acc_prod,
               'acc_cash'       =>  $acc_cash,
               'kin_jens'       => '05',
               'kin_desc'       => 'Administrasi',
               'trx_jens'       => 'B',
               'kode_cabang'  => session()->get('kode_cabang'),
               'kin_time'  => $waktu,
               'kin_user' => session()->get('username'),

            );
            $model1->_savesetortabungan($data);
         }

         // $i = $i++;
      }
      //Deposito
      $i = 0;

      if ($cabang != '') {
         $deposito = $model->get_depositocab($cabang);
      } else {
         $deposito = $model->get_deposito();
      }

      foreach ($deposito->getResult()  as $row) {
         $angmarg = 0;
         $angpajak = 0;
         $norekening = $row->pen_code;
         $noanggota = $row->agt_numb;
         $prdcode = $row->prd_code;
         if (empty($prdcode)) {
            $prdcode = '';
         }

         $tbg_code = $row->tbg_code;
         $bunga = $row->pen_marg;
         $minpph = $row->pen_mpph;
         $prepphf = $row->pen_ppph;
         $tgl_daktv = $row->pen_date;
         $tgl_jtdt = $row->pen_jtdt;
         $acc_prod = $row->acc_cod1;
         $acc_cash = $row->acc_code;
         $norekening1 = $row->tbg_code;
         $prd_name = $row->prd_name;
         $tot_deposito = $row->pen_totl;
         $tot_pokok = $row->pen_bpok;
         $awaltitipan = $row->pen_titp;
         $jenisbunga = $row->pen_jmar;  //1. Dimasukan ke Tabungan 2 : ditambahkan pada Pokok  3: dimbil
         $totaltabungan = $tot_deposito + $tot_pokok;
         $tgl0 = strtotime($tgl_pertama);
         $tgl1 = strtotime($tgl_daktv);
         $tgl2 = strtotime($tgl_terakhir);
         $tgljt = strtotime($tgl_jtdt);
         $tglang1 = strtotime($tgl_pertama_ang);
         $tglang2 = strtotime($tgl_terakhir_ang);
         $titipan = 0;
         if ($tgl_daktv > $tgl_pertama and $tgl_daktv < $tgl_terakhir) {
            $bungahari = $bunga / 365;

            // $thari = (($tgl2 - $tgl0) / 60 / 60 / 24) + 1;
            $jhari = (($tgl2 - $tgl1) / 60 / 60 / 24) + 1;
            $niljasa = round(((($totaltabungan * $bungahari) / 100) * $jhari), 0, PHP_ROUND_HALF_UP);
         } else if ($tgljt > $tgl_pertama and $tgl_jtdt < $tgl_terakhir) {
            $bungahari = $bunga / 365;
            $jhari = (($tgljt - $tgl0) / 60 / 60 / 24) + 1;
            $niljasa = round(((($totaltabungan * $bungahari) / 100) * $jhari), 0, PHP_ROUND_HALF_UP);
         } else {
            $jhari = $Jumlahhari;
            //$niljasa = round(((($totaltabungan * $bunga) / 100) / 12), 0, PHP_ROUND_HALF_UP);
            $niljasa = round(((($totaltabungan * $bunga) / 100) / 12), 0, PHP_ROUND_HALF_UP);
         }


         if ($pphfinalmax > 0) {
            if ($niljasa > $pphfinalmax) {
               $pphfinal = round(($niljasa * $pjkdeposito) / 100);
            } else {
               $pphfinal = 0;
            }
         } else {
            $pphfinal = round(($niljasa * $pjkdeposito) / 100);
         }

         if ($tgljt > $tgl_pertama_ang and $tgl_jtdt < $tgl_terakhir_ang) {
            $bungahari = $bunga / 365;
            $jhariang = (($tglang2 - $tglang1) / 60 / 60 / 24) + 1;
            $niljasaang = round(((($totaltabungan * $bungahari) / 100) * $jhariang), 0, PHP_ROUND_HALF_UP);
         } else {
            $niljasaang = round(((($totaltabungan * $bunga) / 100) / 12), 0, PHP_ROUND_HALF_UP);
         }

         if ($pphfinalmax > 0) {
            if ($niljasaang > $pphfinalmax) {
               $pphfinalang = round(($niljasaang * $pjkdeposito) / 100);
            } else {
               $pphfinalang = 0;
            }
         } else {
            $pphfinalang = round(($niljasaang * $pjkdeposito) / 100);
         }

         $niljasa1 = $niljasa - $pphfinal;
         if ($jenisbunga == '3') {

            $dttitipan = $model->_jumlahtitipan($norekening, $bulan, $tahun);
            if (empty($dttitipan['ttp_totl'])) {
               $titipan = 0;
            } else {
               $titipan = $dttitipan['ttp_totl'];
            }

            // $deposito1 = $model->get_deposito12();
            // foreach ($deposito1->getResult() as $row23) {
            //    $titipan = $row23->pen_totl;
            //    $dttitipan = $model->get_titipan1()->getResult();
            // }

            // foreach ($dttitipan->getResult()  as $row12) {
            //    $titipan = $row12->jas_amnt;
            // }

            // $dttitipan = $model->get_titipan();
            // foreach ($dttitipan->getResult()  as $row) {
            //    $tpokok = $row->ttp_pokok;
            //    $titip = $row->ttp_titip;
            // } 


            $data = array(
               'agt_numb'       => $noanggota,
               'tbg_code'       => $norekening,
               'prd_code'       => $prdcode,
               'jas_mont'       => $bulan,
               'jas_amnt'       => $niljasa,
               'jas_year'       => $tahun,
               'jas_type'       => $jenisbunga,
               'jas_date'       => $tgl_terakhir,
               'jas_desc'       => 'JASA DEPOSITO/SSB' . $prd_name,
               'jas_code'       => session()->get('kode_cabang') . '09' . $tahun . $bulan . $norekening . $i . -1,
               'jas_pphf'       => $pphfinal,
               'com_code'       => 1,
               'trx_type'       => '04',
               'jas_jens'       => 'D',
               'jas_sald'       => $totaltabungan,
               'jas_titp'       => $jhari,
               'jas_absl'     => $niljasaang,
               'jas_angp'     => $pphfinalang,

               'jas_nett'       => $niljasa1,
               'kode_cabang'  => session()->get('kode_cabang'),


            );
            $model1->_savejasa($data);

            //Jurnal Titipan
            $data = array(
               'trx_code' => session()->get('kode_cabang') . '09' . $tahun . $bulan . $norekening . $i . -1, //$this->request->getPost('kin_code'),
               'trx_date' =>
               $tgl_terakhir,
               'acc_code'  => $acc_cash,
               'trx_jens'  => $trxjens,
               'trx_urut' => 1,
               'trx_dbcr'  => 'D',
               'trx_amnt'  => $titipan,
               'dbt_amnt'  => $titipan,
               'crd_amnt'  => 0,
               'trx_des1'  => 'BIAYA JASA DARI SSB/DEPOSITO ' .  $prd_name,
               'trx_des2'  => '',
               'trx_cod2' => $trxcode,
               'com_code'  => 1,
               'kode_cabang'  => session()->get('kode_cabang'),
               'ent_time' => $waktu,
               'usercreated' => session()->get('username'),
            );
            $model1->_savejurnal($data);

            $idx = '18';
            $taccount = $model->_acckhusus($idx);
            $v_acc_code = $taccount['acc_code'];
            if ($titipan > 0) {
               $data = array(
                  'trx_code' => session()->get('kode_cabang') . '09' . $tahun . $bulan . $norekening . $i . -1, //$this->request->getPost('kin_code'),
                  'trx_date' => $tgl_terakhir,
                  'acc_code'  => $v_acc_code,
                  'trx_jens'  => $trxjens,
                  'trx_urut' => 1,
                  'trx_dbcr'  => 'K',
                  'trx_amnt'  => $titipan,
                  'dbt_amnt'  => 0,
                  'crd_amnt'  => $titipan,
                  'trx_des1'  => 'HUTANG TITIPAN ' . $prd_name,
                  'trx_des2'  => '',
                  'trx_cod2' => $trxcode,
                  'com_code'  => 1,
                  'kode_cabang'  => session()->get('kode_cabang'),
                  'ent_time' => $waktu,
                  'usercreated' => session()->get('username'),
               );
               $model1->_savejurnal($data);
            }


            $data = array(
               'pen_titp' => $titipan,
               'pen_ttpb' => $titipan,
               'pen_nmar' => $niljasa,
               'pen_npph' => $pphfinal,

            );
            $model1->_updatepenempatan($data, $norekening);

            $data = array(
               'trx_code' => session()->get('kode_cabang') . '09' . $tahun . $bulan . $norekening . $i . -1,
               'rek_date' => $tgl_terakhir,
               'tbg_code' => $norekening,
               'agt_numb' => $noanggota,
               'trn_code'  => 'OB',
               'ttp_tamb'  => $titipan,
               'ttp_ambl'  => 0,
               'pok_ambl' => 0,
               'jas_amnt' => $niljasa,
               'jas_pajk' =>  $pphfinal,
               'trx_desc'  => 'JASA DEPOSITO/SSB ' . $prd_name,
               'com_code'  => 1,
               'kode_cabang'  => session()->get('kode_cabang'),
            );
            $model1->_savetranssb($data);
         }
         if ($jenisbunga == '2') {
            $titipan = 0;
            $dtpokok = $model->_jumlahpokok($norekening, $bulan, $tahun);

            $tpokok = $dtpokok['pok_totl'];

            $bpokok = $tpokok + $niljasa1;
            $data = array(
               'agt_numb'       => $noanggota,
               'tbg_code'       => $norekening,
               'prd_code'       => $prdcode,
               'jas_mont'       => $bulan,
               'jas_amnt'       => $niljasa,
               'jas_year'       => $tahun,
               'jas_type'       => $jenisbunga,
               'jas_date'       => $tgl_terakhir,
               'jas_desc'       => 'JASA DEPOSITO/SSB' . $prd_name,
               'jas_code'       => session()->get('kode_cabang') . '09' . $tahun . $bulan . $norekening . $i . -1,
               'jas_pphf'       => $pphfinal,
               'com_code'       => 1,
               'trx_type'       => '04',
               'jas_jens'       => 'D',
               'jas_sald'       => $totaltabungan,
               'jas_titp'       => $titipan,
               'jas_absl'     => $niljasaang,
               'jas_angp'     => $pphfinalang,
               'jas_nett'       => $niljasa1,
               'kode_cabang'  => session()->get('kode_cabang'),


            );
            $model1->_savejasa($data);

            $id = $norekening;
            $data = array(
               'pen_bpok'       => $bpokok,
               'pen_tmar'       => $niljasa1,
            );

            $model1->_updatepenempatan($data, $id);

            //Jurnal
            $data = array(
               'trx_code' => session()->get('kode_cabang') . '09' . $tahun . $bulan . $norekening . $i . -1, //$this->request->getPost('kin_code'),
               'trx_date' =>
               $tgl_terakhir,
               'acc_code'  => $acc_prod,
               'trx_jens'  => $trxjens,
               'trx_urut' => 1,
               'trx_dbcr'  => 'D',
               'trx_amnt'  => $niljasa,
               'dbt_amnt'  => $niljasa,
               'crd_amnt'  => 0,
               'trx_des1'  => 'BIAYA JASA DARI SSB/DEPOSITO ' .  $prd_name,
               'trx_des2'  => '',
               'trx_cod2' => $trxcode,
               'com_code'  => 1,
               'kode_cabang'  => session()->get('kode_cabang'),
               'ent_time' => $waktu,
               'usercreated' => session()->get('username'),
            );
            $model1->_savejurnal($data);

            $data = array(
               'trx_code' => session()->get('kode_cabang') . '09' . $tahun . $bulan . $norekening . $i . -1, //$this->request->getPost('kin_code'),
               'trx_date' =>
               $tgl_terakhir,
               'acc_code'  => $acc_cash,
               'trx_jens'  => $trxjens,
               'trx_urut' => 1,
               'trx_dbcr'  => 'K',
               'trx_amnt'  => $niljasa1,
               'dbt_amnt'  => 0,
               'crd_amnt'  => $niljasa1,
               'trx_des1'  => 'JASA DARI SSB/DEPOSITO ' . $prd_name,
               'trx_des2'  => '',
               'trx_cod2' => $trxcode,
               'com_code'  => 1,
               'kode_cabang'  => session()->get('kode_cabang'),
               'ent_time' => $waktu,
               'usercreated' => session()->get('username'),
            );
            $model1->_savejurnal($data);


            if ($pphfinal > 0) {
               $idx = '05';
               $taccount = $model->_acckhusus($idx);
               $v_acc_code = $taccount['acc_code'];
               //Jurnal
               $data = array(
                  'trx_code' => session()->get('kode_cabang') . '09' . $tahun . $bulan . $norekening . $i . -1, //$this->request->getPost('kin_code'),
                  'trx_date'
                  => $tgl_terakhir,
                  'acc_code'  => $v_acc_code,
                  'trx_jens'  => $trxjens,
                  'trx_urut' => 1,
                  'trx_dbcr'  => 'K',
                  'trx_amnt'  => $pphfinal,
                  'dbt_amnt'  => 0,
                  'crd_amnt'  => $pphfinal,
                  'trx_des1'  => 'PPH JASA SSB/DEPOSITO ' . $prd_name,
                  'trx_des2'  => '',
                  'trx_cod2' => $trxcode,
                  'com_code'  => 1,
                  'kode_cabang'  => session()->get('kode_cabang'),
                  'ent_time' => $waktu,
                  'usercreated' => session()->get('username'),
               );
               $model1->_savejurnal($data);
            }

            $data = array(
               'trx_code' => session()->get('kode_cabang') . '09' . $tahun . $bulan . $norekening . $i . -1,
               'rek_date' =>
               $tgl_terakhir,
               'tbg_code' =>
               $norekening,
               'agt_numb' =>
               $noanggota,
               'trn_code'  => 'OB',
               'ttp_ambl'  => 0,
               'pok_ambl' => 0,
               'jas_amnt' => $niljasa,
               'jas_pajk' =>  $pphfinal,
               'trx_desc'  =>
               'JASA DEPOSITO/SSB' . $prd_name,
               'com_code'  => 1,
               'kode_cabang'  => session()->get('kode_cabang'),
            );
            $model1->_savetranssb($data);
         }

         if ($jenisbunga == '1') {
            $titipan = 0;
            $data = array(
               'agt_numb'       => $noanggota,
               'tbg_code'       => $norekening,
               'prd_code'       => $prdcode,
               'jas_mont'       => $bulan,
               'jas_amnt'       => $niljasa,
               'jas_year'       => $tahun,
               'jas_type'       => $jenisbunga,
               'jas_date'       => $tgl_terakhir,
               'jas_desc'       => 'JASA DEPOSITO/SSB' . $prd_name,
               'jas_code'       => session()->get('kode_cabang') . '09' . $tahun . $bulan . $norekening . $i . -1,
               'jas_pphf'       => $pphfinal,
               'com_code'       => 1,
               'trx_type'       => '04',
               'jas_jens'       => 'D',
               'jas_sald'       => $totaltabungan,
               'jas_titp'       => $titipan,
               'jas_absl'     => $niljasaang,
               'jas_angp'     => $pphfinalang,
               'jas_nett'       => $niljasa1,
               'kode_cabang'  => session()->get('kode_cabang'),


            );
            $model1->_savejasa($data);
            //Jasa Bagi Hasil
            if ($niljasa1 > 0) {
               $cek = $modecek->get_nosetortabungan($bulan, $tahun);
               $nourut = $cek['kin_srno'];
               if ($nourut == '') {
                  $nourut = 1;
                  $v_trx_code = $$cabang . '.11.' . $tahun . $bulan . '00001';
               } else {
                  $nourut = $nourut + 1;
                  if ($nourut < 10) {
                     $v_trx_code = $cabang . '.11.' . $tahun . $bulan . '0000' . $nourut;
                  } else if ($nourut >= 10 and $nourut < 100) {
                     $v_trx_code = $cabang . '.11.' . $tahun . $bulan . '000' . $nourut;
                  } else if ($nourut >= 100 and $nourut < 1000) {
                     $v_trx_code = $cabang . '.11.' . $tahun . $bulan . '00' . $nourut;
                  } else if ($nourut >= 1000 and $nourut < 10000) {
                     $v_trx_code = $cabang . '.11.' . $tahun . $bulan . '0' . $nourut;
                  } else {
                     $v_trx_code = $cabang . '.11.' . $tahun . $bulan . $nourut;
                  }
               }
               $data = array(
                  'kin_code'       => $v_trx_code,
                  'kin_date'       => $tgl_terakhir,
                  'agt_numb'       => $noanggota,
                  'tbg_code'       => $norekening1,
                  'kin_type'       => $prdcode,
                  'kin_mont'       => $bulan,
                  'kin_stot'       => $niljasa1,
                  'kin_totl'       => $niljasa1,
                  'kin_crdt'       => $niljasa1,
                  'kin_debt'       => 0,
                  'kin_dbcr'       => 'K',
                  'kin_year'       => $tahun,
                  'com_code'       => 1,
                  'acc_prod'       => $acc_prod,
                  'acc_cash'       => $acc_cash,
                  'kin_jens'       => '05',
                  'kin_desc'       => 'Jasa bagi hasil SSB' . $prd_name,
                  'trx_jens'       => 'B',
                  'kode_cabang'  => session()->get('kode_cabang'),
                  'kin_time'  => $waktu,
                  'kin_user' => session()->get('username'),



               );
               $model1->_savesetortabungan($data);
            }


            $data = array(
               'trx_code' => session()->get('kode_cabang') . '09' . $tahun . $bulan . $norekening . $i . -1, //$this->request->getPost('kin_code'),
               'trx_date' =>
               $tgl_terakhir,
               'acc_code'  => $acc_prod,
               'trx_jens'  => $trxjens,
               'trx_urut' => 1,
               'trx_dbcr'  => 'D',
               'trx_amnt'  => $niljasa,
               'dbt_amnt'  => $niljasa,
               'crd_amnt'  => 0,
               'trx_des1'  => 'BIAYA JASA DARI SSB/DEPOSITO ' .  $prd_name,
               'trx_des2'  => '',
               'trx_cod2' => $trxcode,
               'com_code'  => 1,
               'kode_cabang'  => session()->get('kode_cabang'),
               'ent_time' => $waktu,
               'usercreated' => session()->get('username'),
            );
            $model1->_savejurnal($data);

            if ($niljasa1 > 0) {
               $v_acc_code = '';
               $taccount = $model->_accgettab($norekening);
               foreach ($taccount->getResult() as $row) {
                  $v_acc_code = $row->acc_code;
               }


               $data = array(
                  'trx_code' => session()->get('kode_cabang') . '09' . $tahun . $bulan . $norekening . $i . -1, //$this->request->getPost('kin_code'),
                  'trx_date' =>
                  $tgl_terakhir,
                  'acc_code'  => $v_acc_code,
                  'trx_jens'  => $trxjens,
                  'trx_urut' => 1,
                  'trx_dbcr'  => 'K',
                  'trx_amnt'  => $niljasa1,
                  'dbt_amnt'  => 0,
                  'crd_amnt'  => $niljasa1,
                  'trx_des1'  => 'HUTANG ' . $prd_name,
                  'trx_des2'  => '',
                  'trx_cod2' => $trxcode,
                  'com_code'  => 1,
                  'kode_cabang'  => session()->get('kode_cabang'),
                  'ent_time' => $waktu,
                  'usercreated' => session()->get('username'),
               );
               $model1->_savejurnal($data);
            }



            if ($pphfinal > 0) {
               $idx = '05';
               $v_acc_code = '';
               $taccount = $model->_acckhusus($idx);
               $v_acc_code = $taccount['acc_code'];
               if ($v_acc_code == null) {
                  $v_acc_code = '';
               }
               //Jurnal
               $data = array(
                  'trx_code' => session()->get('kode_cabang') . '09' . $tahun . $bulan . $norekening . $i . -1, //$this->request->getPost('kin_code'),
                  'trx_date' => $tgl_terakhir,
                  'acc_code'  => $v_acc_code,
                  'trx_jens'  => $trxjens,
                  'trx_urut' => 1,
                  'trx_dbcr'  => 'K',
                  'trx_amnt'  => $pphfinal,
                  'dbt_amnt'  => 0,
                  'crd_amnt'  => $pphfinal,
                  'trx_des1'  => 'PPH JASA SSB/DEPOSITO ' . $prd_name,
                  'trx_des2'  => '',
                  'trx_cod2' => $trxcode,
                  'com_code'  => 1,
                  'kode_cabang'  => session()->get('kode_cabang'),
                  'ent_time' => $waktu,
                  'usercreated' => session()->get('username'),
               );
               $model1->_savejurnal($data);
            }


            // Trans tabungan
            $data = array(
               'trx_code' => session()->get('kode_cabang') . '09' . $tahun . $bulan . $norekening . $i . -1,
               'rek_date' =>
               $tgl_terakhir,
               'tbg_code' =>
               $norekening,
               'agt_numb' =>
               $noanggota,
               'trn_code'  => 'OB',
               'ttp_ambl'  => 0,
               'pok_ambl' => 0,
               'jas_amnt' => $niljasa,
               'jas_pajk' =>  $pphfinal,
               'trx_desc'  =>
               'JASA DEPOSITO/SSB' . $prd_name,
               'com_code'  => 1,
               'kode_cabang'  => session()->get('kode_cabang'),
            );
            $model1->_savetranssb($data);

            // Titipan
            $v_tot_titipan = 0;
            // $dttitipan = $model->_jumlahtitipan($norekening, $bulan, $tahun);
            // foreach ($dttitipan->getResult() as $row) {
            //    $titipan = $row->ttp_totl;
            // }

            // $dttitipan = $model->_jumlahtitipan($norekening, $bulan, $tahun);
            // $titipan = $dttitipan['ttp_totl'];

            // $tottitipan = $titipan + $awaltitipan;


            $data = array(
               'jas_obtp' => 'Y',

            );
            $model1->_updatejasa(
               $data,
               $norekening,
               $bulan,
               $tahun
            );
            //

         }



         // $data = array(
         //    'kin_code'       => session()->get('kode_cabang') . '09' . $tahun . $bulan . $norekening . $i . -1, //$this->request->getPost('kin_code'),
         //    'kin_date'       => $tgl_terakhir,
         //    'agt_numb'       => $noanggota,
         //    'bnk_code'       => 'OB',
         //    'acc_code'       => '',
         //    'acc_cash'       => '',
         //    'kin_type'       => 'OB',
         //    'prd_code'       => $prdcode,
         //    'kin_desc'       => 'JASA DEPOSITO/SSB' . $prd_name,
         //    'kin_note'       => 'JASA DEPOSITO/SSB' . $prd_name,
         //    'kin_setr'       => 0,
         //    'kin_stot'       => $niljasa,
         //    'kin_admn'       => 0,
         //    'acc_admn'       => '',
         //    'acc_prod'       => '',
         //    'pen_code'       => $norekening,
         //    'kin_mont'       => $bulan,
         //    'kin_year'       => $tahun,
         //    'kin_totl'       => $niljasa,
         //    'kin_jens'        => 'CLSB',
         //    'kin_prem'       => 0,
         //    'kin_pajk'       => $pphfinal,
         //    'kin_marg'       => 0,
         //    'kin_pilt'       => 0,
         //    'acc_prem'       => '',
         //    'acc_pajk'       => '',
         //    'acc_marg'       => '',
         //    'kin_mstr'       => 0,
         //    'kin_stat' => 0,
         //    'com_code'  => session()->get('com_code'),
         //    'kode_cabang'  => session()->get('kode_cabang'),


         // );

         // $model1->_savetransssb($data);

         $i = $i++;
         // --- End
      }
      // deposito
      session()->setFlashdata('berhasil', 'Tutup Buku Bulanan Berhasil');

      return redirect()->to(base_url('git/closingbulanan'))->with('success', 'Tutup Buku Bulanan Berhasil');
   }


   public function posting()
   {
      $model = new Master_model();
      $_SESSION['com_menu'] = '06';
      $_SESSION['com_men1'] = '0601';
      $_SESSION['com_men2'] = '060102';
      $data['v_cabang']  = $model->_get_cabang()->getResult();
      $data['v_tahun']  = $model->_get_tahun()->getResult();
      return view('closing/posting', $data);
   }

   public function prosesposting()
   {
      //$masset = new Asset_model();
      $model = new Model_closing();
      $modsave = new Save_model();
      $modreport = new  Report_model();
      $moddel = new Delete_model();
      $waktu = date('Y-m-d H:i:s');
      $bulan = $this->request->getPost('kin_buln');
      $tahun = $this->request->getPost('kin_tahn');
      $jenis = $this->request->getPost('kin_type');
      $cabang = $this->request->getPost('cab_code');
      $hari_ini = $tahun . '-' . $bulan . '-01'; // date("Y-m-d");
      $tgl_pertama = date('Y-m-01', strtotime($hari_ini));
      $tgl_terakhir = date('Y-m-t', strtotime($hari_ini));

      $tgl_awal = $tgl_pertama - 1;
      $comcode = 1;
      if ($cabang == '') {
         $cabang1 = session()->get('kode_cabang');
      } else {
         $cabang1 = $cabang;
      }
      $dbakhir = $model->_get_akhir();
      foreach ($dbakhir->getResult() as $akh) {
         $tglpos = $akh->glp_date;
      }
      if ($tgl_terakhir == $tglpos) {
         return redirect()->to(base_url('git/posting'))->with('success', 'Data Periode : ' . date('d/m/Y', strtotime($tgl_terakhir)) . ' Sudah di Posting');
      }

      //Asset Penyusutan
      $jenis = 'PST-001';
      if ($cabang !== '') {
         $moddel->_deletejurnal_postcab($tgl_terakhir, $jenis, $cabang);
         $moddel->_deletejurnal_akumcab($bulan, $tahun, $cabang);
         $dbasset = $model->_get_apassetcab($cabang);
      } else {
         $moddel->_deletejurnal_post($tgl_terakhir, $jenis);
         $moddel->_deletejurnal_akum($bulan, $tahun);
         $dbasset = $model->_get_apasset();
      }
      // $moddel->_deletejurnal_post($tgl_terakhir, $jenis);
      // $moddel->_deletejurnal_akum($bulan, $tahun);
      // $dbasset = $model->_get_apasset();
      $v_acc_cod1 = "";
      $v_acc_cod2 = "";
      $v_acc_cod3 = "";
      $x = 0;
      foreach ($dbasset->getResult()  as $ast) {
         $x = $x + 1;
         $id =  $ast->ast_code;
         $v_acc_cod1 = $ast->acc_cod1;
         $v_acc_cod2 = $ast->acc_cod2;
         $v_acc_cod3 = $ast->acc_cod3;
         $v_kode_cabang = $ast->loc_code;
         if ($cabang == '') {
            $cabang1 = $v_kode_cabang;
         } else {
            $cabang1 = $cabang;
         }
         $akumulasi  = ($ast->ast_nila) / ($ast->ast_lvyr * 12);


         $akm_code = $id . $tahun . $bulan;
         $data = array(
            'com_code' => $comcode,
            'akm_code' => $akm_code,
            'akm_date' => $tgl_terakhir,
            'ast_code' => $id,
            'akm_mont' => $bulan,
            'akm_year' => $tahun,
            'akm_amnt' => $akumulasi,
            'akm_blnk' => $akumulasi,
            'kode_cabang' => $cabang1,
         );
         $modsave->_saveakumulasi($data);

         $dbakhir = $model->_get_totakum($id);
         $totakumulasi = 0;
         foreach ($dbakhir->getResult() as $akum) {
            $totakumulasi = $akum->akm_amnt;
         }
         $data = array(
            'ast_ndes' => $totakumulasi,
         );
         $modsave->_updateasset($data, $id);

         $data = array(
            'trx_code' => $akm_code, // $this->request->getPost('trx_code'),
            'trx_cod1' => $akm_code . '-1', // $this->request->getPost('trx_code'),
            'trx_date' => $tgl_terakhir,
            'trx_urut' => $x,
            'acc_code'  => $v_acc_cod3,
            'trx_dbcr'  => 'D',
            'trx_jens'  => 'PST-001',
            'trx_amnt'  => $akumulasi,
            'dbt_amnt'  => $akumulasi,
            'crd_amnt'  => 0,
            'trx_des1'  => 'Biaya Penyusutan :' . $ast->ast_name,
            'trx_des2'  => 'Biaya Penyusutan :' . $ast->ast_name,
            'kode_cabang' => $cabang1,
            'ent_time' => $waktu,
            'usercreated' => session()->get('username'),
         );

         $modsave->_savejurnal($data);

         $data = array(
            'trx_code' => $akm_code, // $this->request->getPost('trx_code'),
            'trx_cod1' => $akm_code . '-2', // $this->request->getPost('trx_code'),
            'trx_date' => $tgl_terakhir,
            'trx_urut' => $x,
            'acc_code'  => $v_acc_cod2,
            'trx_dbcr'  => 'K',
            'trx_jens'  => 'PST-001',
            'trx_amnt'  => $akumulasi,
            'dbt_amnt'  => 0,
            'crd_amnt'  => $akumulasi,
            'trx_des1'  => 'AP :' . $ast->ast_name,
            'trx_des2'  => 'AP :' . $ast->ast_name,
            'kode_cabang' => $cabang1,
            'ent_time' => $waktu,
            'usercreated' => session()->get('username'),
         );

         $modsave->_savejurnal($data);
      }
      // $tgl_awal = $tgl_pertama - 1;
      if ($cabang != '') {
         $moddel->m_accouddbcab($bulan, $tahun, $cabang);
      } else {
         $moddel->m_accouddb($bulan, $tahun);
      }

      $comcode = 1;

      $setupcom = $model->_get_setup($comcode);
      $rgl_bulan = '';
      $rgl_tahn = '';
      $rgl_thnl = '';
      foreach ($setupcom->getResult()  as $com) {

         $rgl_bulan = $com->com_shub; //'KGN'
         $rgl_tahn = $com->com_shut;  //UJK
         $rgl_thnl = $com->com_shul;
      }


      $account = $model->get_dataaccount();
      $i = 0;


      foreach ($account->getResult()  as $row) {
         $v_acc_code = $row->acc_code;

         // Data Saldo 
         if ($cabang != '') {
            $saldoawal = $modreport->_get_saldoawalcab($v_acc_code, $tgl_pertama, $cabang);
         } else {
            $saldoawal = $modreport->_get_saldoawal($v_acc_code, $tgl_pertama);
         }

         $awl_amnt = 0;
         foreach ($saldoawal->getResult()  as $awl) {
            $awl_amnt = $awl->acc_akhc;
         }
         if ($row->acc_klas > '3') {
            if ($bulan == '01') {
               $awl_amnt = 0;
            }
         }

         if ($row->acc_code == $rgl_tahn) {
            if ($bulan == '01') {
               $awl_amnt = 0;
            }
         }
         if ($cabang == '100') {
            $labarugi = $model->_get_laabrugiamntcab($tgl_pertama, $tgl_terakhir, $cabang);
            $rgl_amnt = 0;
            $rgl_debt = 0;
            $rgl_crdt = 0;
            foreach ($labarugi->getResult()  as $laba) {
               $rgl_amnt = $laba->rgl_amnt;
               $rgl_debt = $laba->dbt_amnt;
               $rgl_crdt = $laba->crd_amnt;
            }
         } else {
            // $labarugi = $model->_get_laabrugiamntcab($tgl_pertama, $tgl_terakhir, '100');
            $rgl_amnt = 0;
            $rgl_debt = 0;
            $rgl_crdt = 0;
            // foreach ($labarugi->getResult()  as $laba) {
            //    $rgl_amnt = $laba->rgl_amnt;
            //    $rgl_debt = $laba->dbt_amnt;
            //    $rgl_crdt = $laba->crd_amnt;
            // }
         }
         if ($rgl_bulan == $v_acc_code) {
            if ($cabang == '200') {

               $labarugi1 = $model->_get_laabrugiamntcab($tgl_pertama, $tgl_terakhir, $cabang);
               $rgl_amnt = 0;
               $rgl_debt = 0;
               $rgl_crdt = 0;
               foreach ($labarugi1->getResult()  as $laba1) {

                  $rgl_amnt = $laba1->rgl_amnt;
                  $rgl_debt = 6000; //$laba1->dbt_amnt;
                  $rgl_crdt = $laba1->crd_amnt;
               }
            } else {
               // $labarugi1 = $model->_get_laabrugiamntcab($tgl_pertama, $tgl_terakhir, '200');
               $rgl_amnt = 0;
               $rgl_debt = 0;
               $rgl_crdt = 0;
               // foreach ($labarugi1->getResult()  as $laba1) {

               //    $rgl_amnt = $laba1->rgl_amnt;
               //    $rgl_debt = 6000; //$laba1->dbt_amnt;
               //    $rgl_crdt = $laba1->crd_amnt;
               // }
            }
         }
         if ($cabang == '') {
            if ($rgl_bulan == $v_acc_code) {
               $labarugi = $model->_get_laabrugiamntcab($tgl_pertama, $tgl_terakhir, '200');
               $rgl_amnt = 0;
               $rgl_debt = 0;
               $rgl_crdt = 0;
               foreach ($labarugi->getResult()  as $laba) {
                  $rgl_amnt = $laba->rgl_amnt;
                  $rgl_debt = $laba->dbt_amnt;
                  $rgl_crdt = $laba->crd_amnt;
               }
            }
            if ($row->acc_code == $rgl_tahn) {
               $labarugi = $model->_get_laabrugiamntcab($tgl_pertama, $tgl_terakhir, '100');
               $rgl_amnt = 0;
               $rgl_debt = 0;
               $rgl_crdt = 0;
               foreach ($labarugi->getResult()  as $laba) {
                  $rgl_amnt = $laba->rgl_amnt;
                  $rgl_debt = $laba->dbt_amnt;
                  $rgl_crdt = $laba->crd_amnt;
               }
            }
         }
         if ($cabang != '') {
            $dbtransaksi = $modreport->get_transaksicab($v_acc_code, $tgl_pertama, $tgl_terakhir, $cabang);
         } else {
            $dbtransaksi = $modreport->get_transaksi($v_acc_code, $tgl_pertama, $tgl_terakhir);
         }

         $dbt_amnt = 0;
         $crd_amnt = 0;

         foreach ($dbtransaksi->getResult()  as $tran) {
            $dbt_amnt = $tran->dbt_amnt;
            $crd_amnt = $tran->crd_amnt;
            $akh_amnf = 1;
         }
         if ($rgl_tahn == $v_acc_code) {
            //$awl_amnt = 0;
            // $akh_amnt = $rgl_amnt;
            $dbt_amnt = $rgl_debt;
            $crd_amnt = $rgl_crdt;
            $akh_amnf = 9999;
         }
         if ($rgl_bulan == $v_acc_code) {
            $dbt_amnt = $rgl_debt;
            $crd_amnt = $rgl_crdt;
         }
         if ($row->acc_nblc == 'D') {
            $akh_amnt = $awl_amnt + $dbt_amnt - $crd_amnt;
         } else {
            $akh_amnt = $awl_amnt - $dbt_amnt + $crd_amnt;
         }




         // if ($rgl_tahn==$v_acc_code){
         //    $akh_amnt=$rgl_amnt;
         //    $dbt_amnt =$rgl_debt;
         //    $crd_amnt =$rgl_crdt;
         //    $akh_amnt=$awl_amnt+$rgl_amnt;
         // }

         // Saldo Awal
         if ($awl_amnt > 0 or $dbt_amnt > 0 or $crd_amnt > 0 or $akh_amnt > 0) {
            $data = array(
               'acc_code'       => $v_acc_code,
               'acc_date'       => $tgl_terakhir,
               'acc_buln'       => $bulan,
               'acc_tahn'       => $tahun,
               'acc_awhc'       => $awl_amnt,
               'acc_dbhc'       => $dbt_amnt,
               'acc_crhc'       => $crd_amnt,
               'acc_akhc'       => $akh_amnt,

               'com_code'       => 1,
               'kode_cabang'  => $cabang1,
            );
            $modsave->_saveaposting($data);
         }
      }

      //  return redirect()->to(base_url('closingbulanan'));
      if ($jenis == '1') {
         $data = array(
            'glp_date' => $tgl_terakhir,
         );
         $modsave->_updateakhirmdb($data);
         session()->setFlashdata('success', 'Posting Data Berhasil');

         return redirect()->to(base_url('git/posting'))->with('success', 'Data Posting Successfully');
      } else {
         $data = array(
            'glp_date' => $tgl_terakhir,
         );
         $modsave->_updateakhirmdb($data);
         session()->setFlashdata('success', 'Posting Data Berhasil');

         return redirect()->to(base_url('git/posting'))->with('success', 'Data Reposting Successfully');
      }
   }

   public function prosestahunan()
   {
      $model = new Model_closing();
      $modsave = new Save_model();
      $modreport = new  Report_model();
      $moddel = new Delete_model();
      $bulan = '01'; // $this->request->getPost('kin_buln');
      $tahun = $this->request->getPost('kin_tahn');
      $tahun = $tahun + 1;
      $jenis = $this->request->getPost('kin_type');
      $hari_ini = $tahun . '-' . $bulan . '-01'; // date("Y-m-d");
      $tgl_pertama = date('Y-m-01', strtotime($hari_ini));
      $tgl_terakhir = date('Y-m-t', strtotime($hari_ini));
      $cabang = $this->request->getPost('cab_code');
      $tglawal1 = $tahun . '-01-01';
      $tgl_awal = date('Y-m-01', strtotime($tglawal1));
      $moddel->m_accouddb($bulan, $tahun);
      $comcode = 1;

      $setupcom = $model->_get_setup($comcode);
      $rgl_bulan = '';
      $rgl_tahn = '';
      $rgl_thnl = '';
      foreach ($setupcom->getResult()  as $com) {

         $rgl_bulan = $com->com_shub;
         $rgl_tahn = $com->com_shut;
         $rgl_thnl = $com->com_shul;
      }

      $labarugi = $model->_get_laabrugiamnt($tgl_pertama, $tgl_terakhir);
      $rgl_amnt = 0;
      $rgl_debt = 0;
      $rgl_crdt = 0;
      foreach ($labarugi->getResult()  as $laba) {
         $rgl_amnt = $laba->rgl_amnt;
         $rgl_debt = $laba->rgl_debt;
         $rgl_crdt = $laba->rgl_crdt;
      }

      $account = $model->get_dataaccount();
      $i = 0;


      foreach ($account->getResult()  as $row) {
         $v_acc_code = $row->acc_code;
         $norekening = $v_acc_code;
         // Data Saldo Awal
         $saldoawal = $modreport->_get_saldoawal($v_acc_code, $tgl_pertama);
         $awl_amnt = 0;
         foreach ($saldoawal->getResult()  as $awl) {
            $awl_amnt = $awl->acc_akhc;
         }
         if (substr($v_acc_code, 1, 1) > '3') {
            $awl_amnt = 0;
         }
         // $dbtransaksi = $modreport->get_transaksi($v_acc_code, $tgl_pertama, $tgl_terakhir);
         $dbt_amnt = 0;
         $crd_amnt = 0;

         //    foreach ($dbtransaksi->getResult()  as $tran) {
         //       $dbt_amnt = $tran->dbt_amnt;
         //       $crd_amnt = $tran->crd_amnt;
         //    }
         //    if ($row->acc_nblc == 'D') {
         //       $akh_amnt = $awl_amnt + $dbt_amnt - $crd_amnt;
         //    } else {
         //       $akh_amnt = $awl_amnt - $dbt_amnt + $crd_amnt;
         //    }


         //    if ($rgl_bulan == $v_acc_code) {
         //       $awl_amnt = 0;
         //       $akh_amnt = $rgl_amnt;
         //       $dbt_amnt = $rgl_debt;
         //       $crd_amnt = $rgl_crdt;
         //    }

         //    // if ($rgl_tahn==$v_acc_code){
         //    //    $akh_amnt=$rgl_amnt;
         //    //    $dbt_amnt =$rgl_debt;
         //    //    $crd_amnt =$rgl_crdt;
         //    //    $akh_amnt=$awl_amnt+$rgl_amnt;
         //    // }

         //    // Saldo Awal
         //    if ($awl_amnt > 0 or $dbt_amnt > 0 or $crd_amnt > 0 or $akh_amnt > 0) {
         //       $data = array(
         //          'acc_code'       => $v_acc_code,
         //          'acc_date'       => $tgl_terakhir,
         //          'acc_buln'       => $bulan,
         //          'acc_tahn'       => $tahun,
         //          'acc_awhc'       => $awl_amnt,
         //          'acc_dbhc'       => $dbt_amnt,
         //          'acc_crhc'       => $crd_amnt,
         //          'acc_akhc'       => $akh_amnt,
         //          'com_code'       => 1,
         //       );
         //       $modsave->_saveaposting($data);
         //    }
         // }

         //  return redirect()->to(base_url('closingbulanan'));

         // if ($awl_amnt > 0 or $dbt_amnt > 0 or $crd_amnt > 0 or $akh_amnt > 0) {
         $data = array(
            'acc_code'       => $v_acc_code,
            'acc_date'       => $tgl_awal,
            'acc_buln'       => $bulan,
            'acc_tahn'       => $tahun,
            'acc_awhc'       => $awl_amnt,
            'acc_dbhc'       => 0,
            'acc_crhc'       => 0,
            'acc_akhc'       => $awl_amnt,
            'com_code'       => 1,
            'kode_cabang'  => session()->get('kode_cabang'),
         );
         $modsave->_saveaposting($data);
         // }



      }
      $data = array(
         'glp_date' => $tgl_terakhir,
      );
      $modsave->_updateakhirmdb($data);
      session()->setFlashdata('success', 'Tutup Tahunan Data Berhasil');

      return redirect()->to(base_url('git/closingtahunan'))->with('success', 'Data Posting Successfully');
   }

   public function shu()
   {
      $_SESSION['com_menu'] = '04';
      $_SESSION['com_men1'] = '0404';
      $_SESSION['com_men2'] = '';
      return view('shu/perhitungan');
   }

   public function distribusishu()
   {
      $model = new Model_git();
      $modmaster = new Master_model();
      $_SESSION['com_menu'] = '04';
      $_SESSION['com_men1'] = '0404';
      $_SESSION['com_men2'] = '';
      $id = date('Y');
      // $id=$this->request->getPost('shu_tahn');
      $data['v_tahun']  = $modmaster->_get_tahun()->getResult();
      $data['v_shu'] = $model->_getshu($id)->getResult();
      return view('shu/distribusi', $data);
   }

   public function simpanshu()
   {

      $model = new Save_model();
      $mocek = new Model_git();
      $moddelete = new Delete_model();
      $tahun = $this->request->getPost('shu_tahn');
      $simpanan = 0;
      $pinjaman = 0;
      $totsimpanan = 0;
      $dtsimpanan = $mocek->get_nilsimpanan($tahun);
      // if ($dtsimpanan)
      $moddelete->_deleteshu($tahun);
      $moddelete->_deleteshudtl($tahun);


      foreach ($dtsimpanan->getResult()  as $row) {
         $simpanan = $row->tot_simp;
      }

      $dtpinjaman = $mocek->get_nilpinjaman($tahun);
      foreach ($dtpinjaman->getResult()  as $row) {
         $pinjaman = $row->tot_pinj;
      }
      $dttabungan = $mocek->get_niltabungan($tahun);
      foreach ($dttabungan->getResult()  as $row) {
         $tabungan = $row->tot_tabs;
      }
      $totsimpanan = $tabungan + $simpanan;
      $data = array(
         'shu_tahn'       => $this->request->getPost('shu_tahn'),
         'shu_ppng'       => $this->request->getPost('shu_ppng'),
         'shu_npeg'       => $this->request->getPost('shu_npeg'),
         'shu_pang'       => $this->request->getPost('shu_pang'),
         'shu_nang'       => $this->request->getPost('shu_nang'),
         'com_code'       => 1,
         'shu_tsim'       => $totsimpanan,
         'shu_tpinj'      => $pinjaman,
         'kode_cabang'  => session()->get('kode_cabang'),
      );

      $model->_saveshu($data);

      $dtanggota = $mocek->get_anggota1();
      foreach ($dtanggota->getResult()  as $row) {
         $noanggota = $row->agt_numb;
         $simpanan_agt = 0;
         $pinjaman_agt = 0;
         $totsimpanan_agt = 0;
         $shunggota =
            $dtsimpanan_agt = $mocek->get_nilsimpanan_agt($tahun, $noanggota);
         foreach ($dtsimpanan_agt->getResult()  as $row) {
            $simpanan_agt = $row->tot_simp;
         }

         $dtpinjaman_agt = $mocek->get_nilpinjaman_agt($tahun, $noanggota);
         foreach ($dtpinjaman_agt->getResult()  as $row) {
            $pinjaman_agt = $row->tot_pinj;
         }
         $dttabungan_agt = $mocek->get_niltabungan_agt($tahun, $noanggota);
         foreach ($dttabungan_agt->getResult()  as $row) {
            $tabungan_agt = $row->tot_tabs;
         }
         $shuanggota = $this->request->getPost('shu_nang');

         $totsimpanan_agt = $tabungan_agt + $simpanan_agt;
         if ($totsimpanan_agt > 0 and $totsimpanan > 0 and $shuanggota > 0) {
            $shu_simpan = ($totsimpanan_agt / $totsimpanan) * $shuanggota;
         } else {
            $shu_simpan = 0;
         }

         $shu_pinjaman = ($pinjaman_agt / $pinjaman) * $shuanggota;
         $shutototal = $shu_simpan + $shu_pinjaman;
         $data = array(
            'shu_year'       => $this->request->getPost('shu_tahn'),
            'agt_numb'       => $noanggota,
            'shu_simp'       => $shu_simpan,
            'shu_pinj'       => $shu_pinjaman,
            'shu_totl'       => $shutototal,
            'com_code'       => 1,

         );
         $model->_saveshudtl($data);
      }



      session()->setFlashdata('berhasil', 'Perhitungan SHU Berhasil');

      return redirect()->to(base_url('git/shu'))->with('success', 'Perhitungan SHU Berhasil');
   }

   public function pritdistribusishu()
   {

      $model = new Model_git();
      $modmaster = new Master_model();
      $id = $this->request->getPost('kin_tahn');
      $data['v_shu'] = $model->_getshu($id)->getResult();
      return view('shu/rptshu', $data);
   }

   public function closingyear()
   {
      $model = new Model_closing();
      $modsave = new Save_model();
      $modreport = new  Report_model();
      $moddel = new Delete_model();
      $bulan = 12;
      $tahun = $this->request->getPost('kin_tahn');
      $hari_ini = $tahun . '-' . $bulan . '-01'; // date("Y-m-d");
      $tgl_pertama = date('Y-m-01', strtotime($hari_ini));
      $tgl_terakhir = date('Y-m-t', strtotime($hari_ini));

      $moddel->m_accouddb($bulan, $tahun);
      $comcode = 1;

      $setupcom = $model->_get_setup($comcode);
      $rgl_bulan = '';
      $rgl_tahn = '';
      $rgl_thnl = '';
      foreach ($setupcom->getResult()  as $com) {

         $rgl_bulan = $com->com_shub;
         $rgl_tahn = $com->com_shut;
         $rgl_thnl = $com->com_shul;
      }

      $labarugi = $model->_get_laabrugiamnt($tgl_pertama, $tgl_terakhir);
      $rgl_amnt = 0;
      $rgl_debt = 0;
      $rgl_crdt = 0;
      foreach ($labarugi->getResult()  as $laba) {
         $rgl_amnt = $laba->rgl_amnt;
         $rgl_debt = $laba->rgl_debt;
         $rgl_crdt = $laba->rgl_crdt;
      }

      $account = $model->get_dataaccount();
      $i = 0;


      foreach ($account->getResult()  as $row) {
         $v_acc_code = $row->acc_code;
         $norekening = $v_acc_code;
         // Data Saldo Awal
         $saldoawal = $modreport->_get_saldoawal($v_acc_code, $tgl_pertama);
         $awl_amnt = 0;
         foreach ($saldoawal->getResult()  as $awl) {
            $awl_amnt = $awl->acc_akhc;
         }

         $dbtransaksi = $modreport->get_transaksi($v_acc_code, $tgl_pertama, $tgl_terakhir);
         $dbt_amnt = 0;
         $crd_amnt = 0;

         foreach ($dbtransaksi->getResult()  as $tran) {
            $dbt_amnt = $tran->dbt_amnt;
            $crd_amnt = $tran->crd_amnt;
         }
         if ($row->acc_nblc == 'D') {
            $akh_amnt = $awl_amnt + $dbt_amnt - $crd_amnt;
         } else {
            $akh_amnt = $awl_amnt - $dbt_amnt + $crd_amnt;
         }


         if ($rgl_bulan == $v_acc_code) {
            $awl_amnt = 0;
            $akh_amnt = $rgl_amnt;
            $dbt_amnt = $rgl_debt;
            $crd_amnt = $rgl_crdt;
         }

         // if ($rgl_tahn==$v_acc_code){
         //    $akh_amnt=$rgl_amnt;
         //    $dbt_amnt =$rgl_debt;
         //    $crd_amnt =$rgl_crdt;
         //    $akh_amnt=$awl_amnt+$rgl_amnt;
         // }

         // Saldo Awal
         if ($awl_amnt > 0 or $dbt_amnt > 0 or $crd_amnt > 0 or $akh_amnt > 0) {
            $data = array(
               'acc_code'       => $v_acc_code,
               'acc_date'       => $tgl_terakhir,
               'acc_buln'       => $bulan,
               'acc_tahn'       => $tahun,
               'acc_awhc'       => $awl_amnt,
               'acc_dbhc'       => $dbt_amnt,
               'acc_crhc'       => $crd_amnt,
               'acc_akhc'       => $akh_amnt,
               'com_code'       => 1,
            );
            $modsave->_saveaposting($data);
         }
      }


      return redirect()->to(base_url('git/posting'))->with('success', 'Data Clossing Successfully');
   }
   public function unposting()
   {
      $model = new Master_model();
      $_SESSION['com_men2'] = '060102';
      $data['v_cabang']  = $model->_get_cabang()->getResult();
      $data['v_tahun']  = $model->_get_tahun()->getResult();
      return view('closing/unposting', $data);
   }


   public function prosesunposting()
   {
      $model = new Delete_model();
      $bulan = $this->request->getPost('kin_buln');
      $tahun = $this->request->getPost('kin_tahn');
      $hari_ini = $tahun . '-' . $bulan . '-01'; // date("Y-m-d");
      $tgl_pertama = date('Y-m-01', strtotime($hari_ini));
      $tgl_terakhir = date('Y-m-t', strtotime($hari_ini));

      $delaccount = $model->m_accouddb($bulan, $tahun);

      return redirect()->to(base_url('git/posting'))->with('success', 'Data Clossing Successfully');
   }
   //--------------------------------------------------------------------

   public function koreksishu()
   {
      $model = new Model_git();
      $modmaster = new Master_model();
      $_SESSION['com_menu'] = '04';
      $_SESSION['com_men1'] = '0404';
      $_SESSION['com_men2'] = '';
      $id = date('Y');

      // $id=$this->request->getPost('shu_tahn');
      $data['v_tahun']  = $modmaster->_get_tahun()->getResult();
      $data['v_shu'] = $model->_getshu($id)->getResult();
      return view('shu/koreksi_shu', $data);
   }

   public function overbookshu()
   {
      $model = new Model_git();
      $modmaster = new Master_model();
      $_SESSION['com_menu'] = '04';
      $_SESSION['com_men1'] = '0404';
      $_SESSION['com_men2'] = '';
      $id = date('Y');

      // $id=$this->request->getPost('shu_tahn');
      $data['v_tahun']  = $modmaster->_get_tahun()->getResult();
      $data['v_shu'] = $model->_getshu($id)->getResult();

      return view('shu/overbookshu', $data);
   }


   public function updateshu()
   {
      $model = new Save_model();
      $agtnumb = $this->request->getPost('agt_numb');
      $tahun = $this->request->getPost('shu_tahn');
      $simpanan = str_replace(',', '', $this->request->getPost('shu_simp'));
      $pinjaman = str_replace(',', '', $this->request->getPost('shu_pinj'));
      $total = str_replace(',', '', $this->request->getPost('shu_totl'));
      $data = array(
         'shu_simp' => $simpanan,
         'shu_pinj' => $pinjaman,
         'shu_totl' => $total,
         'shu_date' => $this->request->getPost('shu_date'),
      );
      $model->_updateshu($data, $agtnumb, $tahun);
      return redirect()->to(base_url('git/koreksishu'))->with('success', 'Koreksi SHU Berhasil');
   }

   public function get_findproduct()
   {
   }

   public function A45e()
   {
      return view('galunggung');
   }
}
