<?php

namespace App\Controllers;

use App\Libraries\mykop;
use App\Models\Delete_model;
use App\Models\Master_model;
use App\Models\Model_git;
use App\Models\Report_model;
use App\Models\Save_model;
use App\Models\Dashboard_model;
use TCPDF;

$session = \Config\Services::session();
date_default_timezone_set('Asia/Jakarta');
class Report extends BaseController
{
  public function __construct()
  {
    $session = session();
  }
  public function index()
  {
    $_SESSION['com_menu'] = '';
    $_SESSION['com_men1'] = '';
    $_SESSION['com_men2'] = '';
  }
  public function simpanan()
  {
    $model = new Master_model();
    $_SESSION['com_menu'] = '08';
    $_SESSION['com_men1'] = '0803';
    $_SESSION['com_men2'] = '';
    $id = 'S';
    $data['v_tahun']  = $model->_get_tahun()->getResult();
    $data['v_product']  = $model->_get_productb($id)->getResult();
    return view('report/simpanan', $data);
  }

  public function ssb()
  {
    $_SESSION['com_menu'] = '08';
    $_SESSION['com_men1'] = '0803';
    $_SESSION['com_men2'] = '';
    $model = new Master_model();
    $id = 'S';
    $data['v_tahun']  = $model->_get_tahun()->getResult();
    $data['v_product']  = $model->_get_productb($id)->getResult();
    return view('report/ssbjatuhtempo', $data);
  }

  public function get_ssbjatuhtempo()
  {
    $model = new Report_Model();
    $_SESSION['com_menu'] = '08';
    $_SESSION['com_men1'] = '0803';
    $_SESSION['com_men2'] = '';
    $productid = $this->request->getPost('id');
    $bulan = $this->request->getPost('bulan');
    $tahun = $this->request->getPost('tahun');
    $data = $model->_get_deposito($productid, $bulan, $tahun)->getResult();
    echo json_encode($data);
  }
  public function pembiayaan()
  {
    $model = new Master_model();
    $_SESSION['com_menu'] = '08';
    $_SESSION['com_men1'] = '0804';
    $_SESSION['com_men2'] = '';
    $id1 = 'K';
    $data['v_tahun']  = $model->_get_tahun()->getResult();
    $data['v_product']  = $model->_get_productb($id1)->getResult();
    return view('report/pembiayaan', $data);
  }
  public function pengajuan()
  {
    $model = new Master_model();
    $data['v_tahun']  = $model->_get_tahun()->getResult();
    return view('report/pengajuan', $data);
  }

  public function kontrak()
  {
    return view('report/daftarkontrak');
  }

  public function penutupan()
  {
    $model = new Master_model();
    $data['v_tahun']  = $model->_get_tahun()->getResult();
    return view('report/penutupan', $data);
  }

  public function kartudebitur()
  {
    $model = new Model_git();
    $_SESSION['com_menu'] = '08';
    $_SESSION['com_men1'] = '0804';
    $_SESSION['com_men2'] = '';
    $tahun = date('Y');
    $bulan = date('m');
    $hari_ini = $tahun . '-' . $bulan . '-01'; // date("Y-m-d");
    $data['tgl1'] = $hari_ini;
    $data['tgl2'] = date("Y-m-d");
    $data['v_kontrak']  = $model->_get_gkontrak()->getResult();
    return view('report/kartudebitur', $data);
  }

  public function jurnalharian()
  {
    $model = new Master_model();
    $_SESSION['com_menu'] = '08';
    $_SESSION['com_men1'] = '0805';
    $_SESSION['com_men2'] = '';
    $tahun = date('Y');
    $bulan = date('m');
    $hari_ini = $tahun . '-' . $bulan . '-01'; // date("Y-m-d");
    $data['tgl1'] = $hari_ini;
    $data['tgl2'] = date("Y-m-d");
    $data['v_cabang']  = $model->_get_cabang()->getResult();
    return view('report/jurnalharian', $data);
  }

  public function get_jurnalharian()
  {
    $model = new Report_Model();

    $id = $this->request->getPost('id');
    $id1 = $this->request->getPost('id1');
    $cabang = $this->request->getPost('kodecabang');
    if ($cabang != '') {
      $data = $model->_get_jurnalcab($id, $id1, $cabang)->getResult();
    } else {
      $data = $model->_get_jurnal($id, $id1)->getResult();
    }

    echo json_encode($data);
  }

  public function jurnalprint()
  {
    $model = new Report_Model();
    $_SESSION['com_menu'] = '08';
    $_SESSION['com_men1'] = '0805';
    $_SESSION['com_men2'] = '';
    $id = $this->request->getPost('trx_dat1');
    $id1 = $this->request->getPost('trx_date');
    $data['tanggal1'] = $id;
    $data['tanggal2'] = $id1;
    $cabang = $this->request->getPost('cab_code');
    if ($cabang != '') {
      $data['v_jurnalumum'] = $model->_get_jurnalcab($id, $id1, $cabang)->getResult();
    } else {
      $data['v_jurnalumum'] = $model->_get_jurnal($id, $id1)->getResult();
    }
    // return view('print/rptjurnalharian', $data);

    $pdf = new mykop('P', 'mm', 'A4', true, 'UTF-8', false);

    // set document information
    $pdf->SetCreator(PDF_CREATOR);
    $pdf->SetAuthor('galunggung.biz');
    $pdf->SetTitle('Jurnal ');
    $pdf->SetSubject('Jurnal ');
    // $pdf->SetHeaderMargin(30);

    $pdf->SetKeywords('TCPDF, PDF, Jurnal ');
    $pdf->Header(true);
    $pdf->SetAutoPageBreak(true);
    // set default header data
    // $pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . ' 001', PDF_HEADER_STRING, array(0, 64, 255), array(0, 64, 128));
    // $pdf->setFooterData(array(0, 64, 0), array(0, 64, 128));

    // set header and footer fonts
    $pdf->setHeaderFont(array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
    $pdf->setFooterFont(array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

    // set default monospaced font
    $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

    // set margins
    $pdf->SetMargins(
      PDF_MARGIN_LEFT,
      PDF_MARGIN_TOP,
      PDF_MARGIN_RIGHT
    );
    $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
    $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

    // set auto page breaks
    $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

    // set image scale factor
    $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

    // set default font subsetting mode
    $pdf->setFontSubsetting(true);

    // Set font
    // dejavusans is a UTF-8 Unicode font, if you only need to
    // print standard ASCII chars, you can use core fonts like
    // helvetica or times to reduce file size.
    $pdf->SetFont('dejavusans', '', 14, '', true);

    // Add a page
    // This method has several options, check the source code documentation for more information.

    $pdf->AddPage();

    //view mengarah ke form RL.php
    $pdf->SetFont('dejavusans', '', 9, '', true);
    // $html = view('rpt/medicalrecord/odontogram.php', $data);
    $html = view('print/rptjurnalharian.php', $data);
    // view('print/rptjurnalharian', $data);


    // Print text using writeHTMLCell()
    $pdf->writeHTMLCell(0, 0, '', '', $html, 0, 1, 0, true, '', true);

    // ---------------------------------------------------------
    $this->response->setContentType('application/pdf');
    // Close and output PDF document
    // This method has several options, check the source code documentation for more information.
    $pdf->Output('odontogram.pdf', 'I');
  }

  public function get_simpanan()
  {
    $model = new Report_Model();
    $productid = $this->request->getPost('id');
    $bulan = $this->request->getPost('bulan');
    $tahun = $this->request->getPost('tahun');
    $data = $model->_get_simpanan($productid, $bulan, $tahun)->getResult();
    echo json_encode($data);
  }

  public function printsimpanan()
  {
    $model = new Report_Model();

    $productid = $this->request->getPost('kin_type');
    $bulan = $this->request->getPost('kin_buln');
    $tahun = $this->request->getPost('kin_tahn');

    $data['v_simpanan'] = $model->_get_simpanan($productid, $bulan, $tahun)->getResult();
    return view('print/rptsimpanan', $data);
  }

  public function printjurnalharian()
  {
    $model = new Report_Model();
    $productid = $this->request->getPost('id');
    $bulan = $this->request->getPost('bulan');
    $tahun = $this->request->getPost('tahun');

    $data['v_simpanan'] = $model->_get_simpanan($productid, $bulan, $tahun)->getResult();
    return view('print/rptjurnal', $data);
  }
  public function bukutabungan()
  {
    $model = new Model_git();
    $tahun = date('Y');
    $bulan = date('m');
    $hari_ini = $tahun . '-' . $bulan . '-01'; // date("Y-m-d");
    $data['tgl1'] = $hari_ini;
    $data['tgl2'] = date("Y-m-d");
    // $data['v_rekening']  = $model->_get_rektabungan()->getResult();
    return view('report/bukutabungan');
  }

  public function get_rbukutabungan()
  {
    $model = new Report_Model();
    $norekening = $this->request->getPost('norekening');
    $tanggal1 = $this->request->getPost('tanggal1');
    $tanggal2 = $this->request->getPost('tanggal2');
    $data = $model->_get_bukutabungan($norekening, $tanggal1, $tanggal2)->getResult();
    echo json_encode($data);
  }
  public function get_rbukutabungan_id()
  {
    $model = new Report_Model();
    $norekening = $this->request->getPost('norekening');
    $tanggal1 = $this->request->getPost('tanggal1');
    $tanggal2 = $this->request->getPost('tanggal2');
    $data = $model->_get_bukutabungan($norekening, $tanggal1, $tanggal2)->getResult();
    echo json_encode($data);
  }
  public function get_saldoawaltab()
  {
    $model = new Report_Model();
    $norekening = $this->request->getPost('norekening');
    $tanggal1 = $this->request->getPost('tanggal1');

    $data = $model->_get_bukutabunganawal($norekening, $tanggal1)->getResult();
    echo json_encode($data);
  }
  public function get_bukutabunganawal_id()
  {
    $model = new Report_Model();
    $norekening = $this->request->getPost('norekening');
    $tanggal1 = $this->request->getPost('tanggal1');

    $data = $model->_get_bukutabunganawal_id($norekening, $tanggal1)->getResult();
    echo json_encode($data);
  }


  public function printbukutabungan()
  {
    $model = new Report_Model();
    $mgit = new Model_git();
    $norekening = $this->request->getPost('tbg_code');
    $tanggal1 = $this->request->getPost('trx_date');
    $tanggal2 = $this->request->getPost('trx_dat1');
    $data['tglawal'] = $tanggal1;
    $data['tabungan'] = $mgit->_get_dtabunganid($norekening)->getResult();
    $data['saldoawal'] = $model->_get_bukutabunganawal_id($norekening, $tanggal1)->getResult();
    $data['v_tabungan'] = $model->_get_bukutabungan_id($norekening, $tanggal1, $tanggal2)->getResult();
    return view('print/rptbukutabungan', $data);
  }


  public function get_rangsuran()
  {
    $model = new Report_Model();
    $id = $this->request->getPost('id');
    $data = $model->_get_kartuangsuran($id)->getResult();
    echo json_encode($data);
  }

  public function printkartuangsuran()
  {
    $model = new Report_Model();
    $id = $this->request->getPost('knt_code');
    $data['v_kartu'] = $model->_get_kartuangsuran($id)->getResult();
    return view('print/rptkartuangsuran', $data);
  }

  public function cetakkartuangsuran($id)
  {
    $model = new Report_Model();

    $data['v_kartu'] = $model->_get_kartuangsuran($id)->getResult();
    return view('print/rptkartuangsuran', $data);
  }
  public function deposito()
  {
    $model = new Master_model();
    $id = 'D';
    $data['v_tahun']  = $model->_get_tahun()->getResult();
    $data['v_product']  = $model->_get_productb($id)->getResult();
    return view('report/ssbjatuhtempo', $data);
  }

  public function printssbjatuhtempo()
  {

    $model = new Report_Model();
    $productid = $this->request->getPost('kin_type');
    $bulan = $this->request->getPost('kin_buln');
    $tahun = $this->request->getPost('kin_tahn');
    $data['v_ssb'] = $model->_get_deposito($productid, $bulan, $tahun)->getResult();

    return view('print/ssbjatuhtempo', $data);
  }

  public function get_pengajuan()
  {
    $model = new Report_Model();
    $bulan = $this->request->getPost('bulan');
    $tahun = $this->request->getPost('tahun');
    $data = $model->_get_pengajuan($bulan, $tahun)->getResult();
    echo json_encode($data);
  }

  public function printpengajuan()
  {
    $model = new Report_Model();
    $bulan = $this->request->getPost('kin_buln');
    $tahun = $this->request->getPost('kin_tahn');
    $data['v_pengajuan'] = $model->_get_pengajuan($bulan, $tahun)->getResult();
    return view('print/rptpengajuan', $data);
  }


  public function get_penutupan()
  {
    $model = new Report_Model();
    $bulan = $this->request->getPost('bulan');
    $tahun = $this->request->getPost('tahun');
    $data = $model->_get_penutupan($bulan, $tahun)->getResult();
    echo json_encode($data);
  }


  public function printpenutupan()
  {
    $model = new Report_Model();
    $bulan = $this->request->getPost('kin_buln');
    $tahun = $this->request->getPost('kin_tahn');
    $data['v_penutupan'] = $model->_get_penutupan($bulan, $tahun)->getResult();
    return view('print/rptpenutupan', $data);
  }

  public function bukubesar()
  {
    $model = new Master_model();
    $_SESSION['com_menu'] = '08';
    $_SESSION['com_men1'] = '0805';
    $_SESSION['com_men2'] = '';
    $tahun = date('Y');
    $bulan = date('m');
    $hari_ini = $tahun . '-' . $bulan . '-01'; // date("Y-m-d");
    $data['tgl1'] = $hari_ini;
    $data['tgl2'] = date("Y-m-d");
    $data['v_account']  = $model->_get_account()->getResult();
    $data['v_cabang']  = $model->_get_cabang()->getResult();
    return view('report/bukubesar', $data);
  }

  public function get_bukubesar()
  {
    $model = new Report_Model();
    $norekening = $this->request->getPost('norekening');
    $tanggal1 = $this->request->getPost('tanggal1');
    $tanggal2 = $this->request->getPost('tanggal2');
    $data = $model->_get_bukubesar($norekening, $tanggal1, $tanggal2)->getResult();
    echo json_encode($data);
  }


  public function get_saldoawal()
  {
    $model = new Report_Model();
    $norekening = $this->request->getPost('norekening');
    $tanggal1 = $this->request->getPost('tanggal1');
    $cabang = $this->request->getPost('kodecabang');
    if ($cabang != '') {
      $data = $model->_get_saldoawalcab($norekening, $tanggal1, $cabang)->getResult();
    } else {
      $data = $model->_get_saldoawal($norekening, $tanggal1)->getResult();
    }

    echo json_encode($data);
  }

  public function jasadeposito()
  {
    $model = new Master_model();
    $data['v_tahun']  = $model->_get_tahun()->getResult();
    $data['v_cabang']  = $model->_get_cabang()->getResult();
    return view('report/jasadeposito', $data);
  }
  public function get_bungadeposito()
  {
    $model = new Report_Model();
    $bulan = $this->request->getPost('bulan');
    $tahun = $this->request->getPost('tahun');
    $cabang = $this->request->getPost('kodecabang');
    if ($cabang != '') {
      $data = $model->_get_bungadepositocab($bulan, $tahun, $cabang)->getResult();
    } else {
      $data = $model->_get_bungadeposito($bulan, $tahun)->getResult();
    }

    echo json_encode($data);
  }

  public function printjasadeposito()
  {

    $model = new Report_Model();
    $bulan = $this->request->getPost('kin_buln');
    $tahun = $this->request->getPost('kin_tahn');
    $cabang = $this->request->getPost('cab_code');
    if ($cabang != '') {
      $data['v_ssb'] = $model->_get_bungadepositocab($bulan, $tahun, $cabang)->getResult();
    } else {
      $data['v_ssb'] = $model->_get_bungadeposito($bulan, $tahun)->getResult();
    }

    return view('print/rptjasassb', $data);
  }

  public function printbukubesar()
  {
    $model = new Report_Model();
    $norekening = $this->request->getPost('tbg_code');
    $tanggal1 = $this->request->getPost('trx_date');
    $tanggal2 = $this->request->getPost('trx_dat1');
    $data['v_saldoawal'] = $model->_get_saldoawal($norekening, $tanggal1)->getResult();
    $data['v_bukubesar'] = $model->_get_bukubesar($norekening, $tanggal1, $tanggal2)->getResult();
    return view('print/rptbukubesar', $data);
  }
  public function neracasaldo()
  {
    $model = new Master_model();
    $_SESSION['com_menu'] = '08';
    $_SESSION['com_men1'] = '0805';
    $_SESSION['com_men2'] = '';
    $data['v_tahun']  = $model->_get_tahun()->getResult();
    $data['v_cabang']  = $model->_get_cabang()->getResult();
    return view('report/neracasaldo', $data);
  }
  public function get_neracasaldo()
  {
    $model = new Report_Model();
    $bulan = $this->request->getPost('bulan');
    $tahun = $this->request->getPost('tahun');
    $data = $model->_get_neracasaldo($bulan, $tahun)->getResult();
    echo json_encode($data);
  }

  public function printneracasaldo()
  {
    $model = new Report_Model();
    $bulan = $this->request->getPost('kin_buln');
    $tahun = $this->request->getPost('kin_tahn');
    $data['v_neracasaldo'] = $model->_get_neracasaldo($bulan, $tahun)->getResult();
    return view('print/rptneracasaldo', $data);
  }

  public function rugilaba()
  {
    $model = new Master_model();
    $_SESSION['com_menu'] = '08';
    $_SESSION['com_men1'] = '0805';
    $_SESSION['com_men2'] = '';
    $data['v_tahun']  = $model->_get_tahun()->getResult();
    $data['v_cabang']  = $model->_get_cabang()->getResult();
    return view('report/labarugi', $data);
  }
  public function get_labarugi()
  {
    $model = new Report_Model();
    $modsave = new Save_model();
    $moddel = new  Delete_model();
    $bulan = $this->request->getPost('bulan');
    $tahun = $this->request->getPost('tahun');
    $id = 1;
    $delaccount = $moddel->m_delrugulaba($id);

    $account = $model->_get_labarugi();
    $trx_amnt = 0;
    $i = 0;
    $total = 0;
    $subtotal = 0;
    $v_level = '';
    $v_umum = '';
    $total = 0;
    foreach ($account->getResult()  as $row) {
      $acc_code = $row->acc_code;
      $i = $i + 1;
      $subtotal = 0;
      $data = array(
        'acod1'       => $row->acc_code,
        'urut'        => $i,
        'aname1'      => $row->acc_name,
        'fnilai1'     => '',
        'com_code'    => 1,
        'acc_levl'    => $row->acc_levl,
      );
      $modsave->_saverugilaba($data);

      $dtaccount = $model->_get_labarugi1($acc_code);

      foreach ($dtaccount->getResult()  as $row1) {
        $v_acc_code1 = $row1->acc_code;

        $i = $i + 1;
        $nilai = $model->_get_nilai($v_acc_code1, $bulan, $tahun);
        $trx_amnt = 0;

        foreach ($nilai->getResult()  as $nil) {
          $trx_amnt = $nil->acc_akhc;
        }

        $subtotal = $subtotal + $trx_amnt;
        if ($row->acc_nblc == 'K') {
          $total = $total + $trx_amnt;
        } else {
          $total = $total - $trx_amnt;
        }

        if ($trx_amnt != 0) {
          $data = array(
            'acod1'       => $v_acc_code1,
            'urut'        => $i,
            'aname1'      => $row1->acc_name,
            'fnilai1'     =>  $trx_amnt,
            'com_code'    => 1,
            'acc_levl'    => $row1->acc_levl,
          );
          $modsave->_saverugilaba($data);
        }
      }

      // sub total
      if ($subtotal != 0) {
        $i = $i + 1;

        //  $subtotal=$subtotal+$trx_amnt;

        $data = array(
          'acod1'       => 'BRS', //$row->acc_code
          'urut'        => $i,
          'aname1'      => 'SUB TOTAL ' . $row->acc_name,
          'fnilai1'     =>  $subtotal,
          'com_code'    => 1,
          'acc_levl'    => $row->acc_levl,
        );
        $modsave->_saverugilaba($data);
      }
    }

    $i = $i + 1;

    //  $subtotal=$subtotal+$trx_amnt;
    $rugilaba = "LABA";
    if ($total < 0) {
      $rugilaba = "RUGI";
    }

    $data = array(
      'acod1'       => $row->acc_code,
      'urut'        => $i,
      'aname1'      => $rugilaba,
      'fnilai1'     =>  $total,
      'com_code'    => 1,
      'acc_levl'    => $row->acc_levl,
    );
    $modsave->_saverugilaba($data);

    $data = $model->_get_txlabarugi()->getResult();
    echo json_encode($data);
  }
  public function get_labarugi1() {}
  public function _get_pembiayaantahun()
  {
    $model = new Dashboard_model();
    $msave = new Save_model();
    $id = $this->request->getPost('id');
    $id = 2024;
    $jns = 'K';


    $data = array(
      'com_code'  => session()->get('com_code'),
      'kode_cabang'  => session()->get('kode_cabang'),
      'trx_jens' => $jns,
      'grp_mont' => 1,
      'grp_year' => $id,
      'grp_juml' => 0,
      'grp_nila' => 0,
    );
    $msave->_savegraph($data);

    $data = $model->_dbgraphtahun($id, $jns)->getResult();
    echo json_encode($data);
  }

  public function printrugilaba()
  {
    $model = new Report_Model();
    $modsave = new Save_model();
    $moddel = new  Delete_model();
    $bulan = $this->request->getPost('kin_buln');
    $tahun = $this->request->getPost('kin_tahn');
    $hari_ini = $tahun . '-' . $bulan . '-01'; // date("Y-m-d");
    $tgl_pertama = date('Y-m-01', strtotime($hari_ini));
    $tgl_terakhir = date('Y-m-t', strtotime($hari_ini));
    $id = 1;
    $delaccount = $moddel->m_delrugulaba($id);

    $account = $model->_get_labarugi();
    $trx_amnt = 0;
    $i = 0;
    $total = 0;
    $subtotal = 0;
    $v_level = '';
    $v_umum = '';
    $total = 0;
    foreach ($account->getResult()  as $row) {
      $acc_code = $row->acc_code;
      $i = $i + 1;
      $subtotal = 0;
      $data = array(
        'acod1'       => $row->acc_code,
        'urut'        => $i,
        'aname1'      => $row->acc_name,
        'fnilai1'     => '',
        'com_code'    => 1,
        'acc_levl'    => $row->acc_levl,
        'trx_date'    => $tgl_terakhir,
      );
      $modsave->_saverugilaba($data);

      $dtaccount = $model->_get_labarugi1($acc_code);

      foreach ($dtaccount->getResult()  as $row1) {
        $v_acc_code1 = $row1->acc_code;

        $i = $i + 1;
        $nilai = $model->_get_nilai($v_acc_code1, $bulan, $tahun);
        $trx_amnt = 0;

        foreach ($nilai->getResult()  as $nil) {
          $trx_amnt = $nil->acc_akhc;
        }

        $subtotal = $subtotal + $trx_amnt;
        if ($row->acc_nblc == 'K') {
          $total = $total + $trx_amnt;
        } else {
          $total = $total - $trx_amnt;
        }

        if ($trx_amnt != 0) {
          $data = array(
            'acod1'       => $v_acc_code1,
            'urut'        => $i,
            'aname1'      => $row1->acc_name,
            'fnilai1'     =>  $trx_amnt,
            'com_code'    => 1,
            'acc_levl'    => $row1->acc_levl,
            'trx_date'    => $tgl_terakhir,
          );
          $modsave->_saverugilaba($data);
        }
      }

      // sub total
      if ($subtotal != 0) {
        $i = $i + 1;

        //  $subtotal=$subtotal+$trx_amnt;

        $data = array(
          'acod1'       => 'BRS', //$row->acc_code
          'urut'        => $i,
          'aname1'      => 'SUB TOTAL ' . $row->acc_name,
          'fnilai1'     =>  $subtotal,
          'com_code'    => 1,
          'acc_levl'    => $row->acc_levl,
          'trx_date'    => $tgl_terakhir,
        );
        $modsave->_saverugilaba($data);
      }
    }

    $i = $i + 1;

    //  $subtotal=$subtotal+$trx_amnt;
    $rugilaba = "LABA";
    if ($total < 0) {
      $rugilaba = "RUGI";
    }

    $data = array(
      'acod1'       => $row->acc_code,
      'urut'        => $i,
      'aname1'      => $rugilaba,
      'fnilai1'     =>  $total,
      'com_code'    => 1,
      'acc_levl'    => $row->acc_levl,
      'trx_date'    => $tgl_terakhir,
    );
    $modsave->_saverugilaba($data);

    $data['v_rugilba'] = $model->_get_txlabarugi()->getResult();
    return view('print/rptrugilaba', $data);
  }

  public function neraca()
  {
    $model = new Master_model();
    $_SESSION['com_menu'] = '08';
    $_SESSION['com_men1'] = '0805';
    $_SESSION['com_men2'] = '';
    $data['v_tahun']  = $model->_get_tahun()->getResult();
    $data['v_cabang']  = $model->_get_cabang()->getResult();
    return view('report/neraca', $data);
  }

  public function get_neraca()
  {
    $model = new Report_Model();
    $modsave = new Save_model();
    $moddel = new  Delete_model();
    $bulan = $this->request->getPost('bulan');
    $tahun = $this->request->getPost('tahun');
    $id = 1;
    $delaccount = $moddel->m_delneraca($id);
    $acc_klas1 = '1';
    $acc_klas2 = '1';
    $account = $model->_get_neraca($acc_klas1, $acc_klas2);
    $trx_amnt = 0;
    $i = 0;
    $total = 0;
    $subtotal = 0;
    $v_level = '';
    $v_umum = '';
    $total = 0;
    $i = $i + 1;
    $subtotal = 0;
    $data = array(
      'acc_cod1'       => 1,
      'urut'        => $i,
      'acc_nam1'      => 'AKTIVA',
      'acc_nil1'     => '',
      'com_code'    => 1,
      'acc_levl'    => 1,
    );
    $modsave->_saveneraca($data);
    foreach ($account->getResult()  as $row) {
      $acc_code = $row->acc_code;
      $i = $i + 1;
      $subtotal = 0;
      $data = array(
        'acc_cod1'       => $row->acc_code,
        'urut'        => $i,
        'acc_nam1'      => $row->acc_name,
        'acc_nil1'     => '',
        'com_code'    => 1,
        'acc_levl'    => $row->acc_levl,
      );
      $modsave->_saveneraca($data);

      $dtaccount = $model->_get_neraca1($acc_code);

      foreach ($dtaccount->getResult()  as $row1) {
        $v_acc_code1 = $row1->acc_code;

        //  $i=$i+1;
        $nilai = $model->_get_nilai($v_acc_code1, $bulan, $tahun);
        $trx_amnt = 0;

        foreach ($nilai->getResult()  as $nil) {
          $trx_amnt = $nil->acc_akhc;
        }

        $subtotal = $subtotal + $trx_amnt;
        if ($row->acc_nblc == 'K') {
          $total = $total - $trx_amnt;
        } else {
          $total = $total + $trx_amnt;
        }

        if ($trx_amnt != 0) {
          $i = $i + 1;
          $data = array(
            'acc_cod1'       => $v_acc_code1,
            'urut'        => $i,
            'acc_nam1'      => $row1->acc_name,
            'acc_nil1'     => $trx_amnt,
            'com_code'    => 1,
            'acc_levl'    => $row1->acc_levl,


          );
          $modsave->_saveneraca($data);
        }
      }

      // sub total
      if ($subtotal != 0) {
        $i = $i + 1;

        //  $subtotal=$subtotal+$trx_amnt;

        $data = array(

          'acc_cod1'    => 'BRS',
          'urut'        => $i,
          'acc_nam1'    => 'SUB TOTAL ' . $row->acc_name,
          'acc_nil1'    => $subtotal,
          'com_code'    => 1,
          'acc_levl'    => $row->acc_levl,

        );
        $modsave->_saveneraca($data);
      }
    }



    //  $subtotal=$subtotal+$trx_amnt;


    $i = $i + 1;
    $baris = $i;
    $data = array(
      'acc_cod1'    => $row->acc_code,
      'urut'        => $i,
      'acc_nam1'    => 'TOTAL AKTIVA',
      'acc_nil1'    => $total,
      'com_code'    => 1,
      'acc_levl'    => $row->acc_levl,

    );
    $modsave->_saveneraca($data);

    /// Pasiva
    $acc_klas1 = '2';
    $acc_klas2 = '3';
    $account = $model->_get_neracap($acc_klas1, $acc_klas2);
    $trx_amnt = 0;
    $i = 0;
    $total = 0;
    $subtotal = 0;
    $v_level = '';
    $v_umum = '';
    $total = 0;
    $i = $i + 1;
    $id = $i;
    $data = array(
      'acc_cod2'     => 3,
      'acc_nam2'     => 'PASIVA',
      'acc_nil2'     => '',
      'acc_lev2'     => 1,
    );
    $modsave->_updateneraca($data, $id);
    foreach ($account->getResult()  as $row) {
      $acc_code = $row->acc_code;
      $i = $i + 1;
      $subtotal = 0;
      $id = $i;
      $data = array(
        'acc_cod2'     => $row->acc_code,
        'acc_nam2'     => $row->acc_name,
        'acc_nil2'     => '',
        'acc_lev2'     => $row->acc_levl,
      );
      $modsave->_updateneraca($data, $id);

      $dtaccount = $model->_get_neraca1p($acc_code);
      $trx_amnt = 0;
      foreach ($dtaccount->getResult()  as $row1) {
        $v_acc_code1 = $row1->acc_code;

        $nilai = $model->_get_nilai($v_acc_code1, $bulan, $tahun);


        $trx_amnt = 0;
        foreach ($nilai->getResult()  as $nil) {
          $trx_amnt = $nil->acc_akhc;
        }

        $subtotal = $subtotal + $trx_amnt;
        if ($row->acc_nblc == 'K') {
          $total = $total - $trx_amnt;
          //  $subtotal=$subtotal-$trx_amnt;
        } else {
          $total = $total + $trx_amnt;
          //  $subtotal=$subtotal+$trx_amnt;
        }
        if ($v_acc_code1 == '203') {
          $v_acc_code1 = $v_acc_code1 . '-1';
        }
        if ($trx_amnt != 0) {
          $i = $i + 1;
          $id = $i;
          $data = array(

            'acc_cod2'    => $v_acc_code1,
            'acc_nam2'    => $row1->acc_name,
            'acc_nil2'    => $trx_amnt,
            'acc_lev2'    => $row1->acc_levl,


          );
          $modsave->_updateneraca($data, $id);
        }
      }

      // sub total

      if ($subtotal != 0) {
        $i = $i + 1;

        //  $subtotal=$subtotal+$trx_amnt;
        $id = $i;
        $data = array(

          'acc_cod2'    => 'BRS',
          'acc_nam2'    => 'SUB TOTAL ' . $row->acc_name,
          'acc_nil2'    => $subtotal,
          'acc_lev2'    => $row->acc_levl,

        );
        $modsave->_updateneraca($data, $id);
      }
    }

    $i = $i + 1;

    //  $subtotal=$subtotal+$trx_amnt;


    $id = $baris;
    if ($total < 0) {
      $total = $total * -1;
    }
    $data = array(
      'acc_cod2'    => $row->acc_code,

      'acc_nam2'    => 'TOTAL PASIVA',
      'acc_nil2'    => $total,
      'acc_lev2'    => $row->acc_levl,

    );
    $modsave->_updateneraca($data, $id);
    /// End Pasiva

    $data = $model->_get_txneraca()->getResult();
    echo json_encode($data);
  }

  ///---------------------------------------
  public function printneraca()
  {
    $model = new Report_Model();
    $modsave = new Save_model();
    $moddel = new  Delete_model();
    $bulan = $this->request->getPost('kin_buln');
    $tahun = $this->request->getPost('kin_tahn');
    $hari_ini = $tahun . '-' . $bulan . '-01'; // date("Y-m-d");
    $tgl_pertama = date('Y-m-01', strtotime($hari_ini));
    $tgl_terakhir = date('Y-m-t', strtotime($hari_ini));

    $id = 1;
    $delaccount = $moddel->m_delneraca($id);
    $acc_klas1 = '1';
    $acc_klas2 = '1';
    $account = $model->_get_neraca($acc_klas1, $acc_klas2);
    $trx_amnt = 0;
    $i = 0;
    $total = 0;
    $subtotal = 0;
    $v_level = '';
    $v_umum = '';
    $total = 0;
    $i = $i + 1;
    $subtotal = 0;
    $data = array(
      'acc_cod1'       => 1,
      'urut'        => $i,
      'acc_nam1'      => 'AKTIVA',
      'acc_nil1'     => '',
      'com_code'    => 1,
      'acc_levl'    => 1,
      'acc_date'    => $tgl_terakhir,
    );
    $modsave->_saveneraca($data);
    foreach ($account->getResult()  as $row) {
      $acc_code = $row->acc_code;
      $i = $i + 1;
      $subtotal = 0;
      $data = array(
        'acc_cod1'       => $row->acc_code,
        'urut'        => $i,
        'acc_nam1'      => $row->acc_name,
        'acc_nil1'     => '',
        'com_code'    => 1,
        'acc_levl'    => $row->acc_levl,
        'acc_date'    => $tgl_terakhir,
      );
      $modsave->_saveneraca($data);

      $dtaccount = $model->_get_neraca1($acc_code);

      foreach ($dtaccount->getResult()  as $row1) {
        $v_acc_code1 = $row1->acc_code;

        //  $i=$i+1;
        $nilai = $model->_get_nilai($v_acc_code1, $bulan, $tahun);
        $trx_amnt = 0;

        foreach ($nilai->getResult()  as $nil) {
          $trx_amnt = $nil->acc_akhc;
        }

        $subtotal = $subtotal + $trx_amnt;
        if ($row->acc_nblc == 'K') {
          $total = $total - $trx_amnt;
        } else {
          $total = $total + $trx_amnt;
        }

        if ($trx_amnt != 0) {
          $i = $i + 1;
          $data = array(
            'acc_cod1'       => $v_acc_code1,
            'urut'        => $i,
            'acc_nam1'      => $row1->acc_name,
            'acc_nil1'     => $trx_amnt,
            'com_code'    => 1,
            'acc_levl'    => $row1->acc_levl,
            'acc_date'    => $tgl_terakhir,

          );
          $modsave->_saveneraca($data);
        }
      }

      // sub total
      if ($subtotal != 0) {
        $i = $i + 1;

        //  $subtotal=$subtotal+$trx_amnt;

        $data = array(

          'acc_cod1'    => 'BRS',
          'urut'        => $i,
          'acc_nam1'    => 'SUB TOTAL ' . $row->acc_name,
          'acc_nil1'    => $subtotal,
          'com_code'    => 1,
          'acc_levl'    => $row->acc_levl,
          'acc_date'    => $tgl_terakhir,

        );
        $modsave->_saveneraca($data);
      }
    }



    //  $subtotal=$subtotal+$trx_amnt;


    $i = $i + 1;
    $baris = $i;
    $data = array(
      'acc_cod1'    => $row->acc_code,
      'urut'        => $i,
      'acc_nam1'    => 'TOTAL AKTIVA',
      'acc_nil1'    => $total,
      'com_code'    => 1,
      'acc_levl'    => $row->acc_levl,
      'acc_date'    => $tgl_terakhir,
    );
    $modsave->_saveneraca($data);

    /// Pasiva
    $acc_klas1 = '2';
    $acc_klas2 = '3';
    $account = $model->_get_neracap($acc_klas1, $acc_klas2);
    $trx_amnt = 0;
    $i = 0;
    $total = 0;
    $subtotal = 0;
    $v_level = '';
    $v_umum = '';
    $total = 0;
    $i = $i + 1;
    $id = $i;
    $data = array(
      'acc_cod2'     => 3,
      'acc_nam2'     => 'PASIVA',
      'acc_nil2'     => '',
      'acc_lev2'     => 1,
    );
    $modsave->_updateneraca($data, $id);
    foreach ($account->getResult()  as $row) {
      $acc_code = $row->acc_code;
      $i = $i + 1;
      $subtotal = 0;
      $id = $i;
      $data = array(
        'acc_cod2'     => $row->acc_code,
        'acc_nam2'     => $row->acc_name,
        'acc_nil2'     => '',
        'acc_lev2'     => $row->acc_levl,
      );
      $modsave->_updateneraca($data, $id);

      $dtaccount = $model->_get_neraca1p($acc_code);

      foreach ($dtaccount->getResult()  as $row1) {
        $v_acc_code1 = $row1->acc_code;

        $nilai = $model->_get_nilai($v_acc_code1, $bulan, $tahun);

        $trx_amnt = 0;

        foreach ($nilai->getResult()  as $nil) {
          $trx_amnt = $nil->acc_akhc;
        }

        $subtotal = $subtotal + $trx_amnt;
        if ($row->acc_nblc == 'K') {
          $total = $total - $trx_amnt;
          //  $subtotal=$subtotal-$trx_amnt;
        } else {
          $total = $total + $trx_amnt;
          //  $subtotal=$subtotal+$trx_amnt;
        }

        if ($trx_amnt != 0) {
          $i = $i + 1;
          $id = $i;
          $data = array(

            'acc_cod2'    => $v_acc_code1,
            'acc_nam2'    => $row1->acc_name,
            'acc_nil2'    => $trx_amnt,
            'acc_lev2'    => $row1->acc_levl,


          );
          $modsave->_updateneraca($data, $id);
        }
      }

      // sub total

      if ($subtotal != 0) {
        $i = $i + 1;

        //  $subtotal=$subtotal+$trx_amnt;
        $id = $i;
        $data = array(

          'acc_cod2'    => 'BRS',
          'acc_nam2'    => 'SUB TOTAL ' . $row->acc_name,
          'acc_nil2'    => $subtotal,
          'acc_lev2'    => $row->acc_levl,

        );
        $modsave->_updateneraca($data, $id);
      }
    }

    $i = $i + 1;

    //  $subtotal=$subtotal+$trx_amnt;


    $id = $baris;
    $data = array(
      'acc_cod2'    => $row->acc_code,

      'acc_nam2'    => 'TOTAL PASIVA',
      'acc_nil2'    => $total,
      'acc_lev2'    => $row->acc_levl,

    );
    $modsave->_updateneraca($data, $id);



    //------
    $data['v_neraca'] = $model->_get_txneraca()->getResult();
    return view('print/rptneraca', $data);
  }

  public function nominatif()
  {
    $mmaster = new Master_model();
    $_SESSION['com_menu'] = '08';
    $_SESSION['com_men1'] = '0804';
    $_SESSION['com_men2'] = '080401';
    $tahun = date('Y');
    $bulan = date('m');
    $hari_ini = $tahun . '-' . $bulan . '-01'; // date("Y-m-d");
    $data['tgl1'] = $hari_ini;
    $data['tgl2'] = date("Y-m-d");
    $data['v_cabang']  = $mmaster->_get_cabang()->getResult();
    return view('report/nominatif', $data);
  }

  public function get_nominatif()
  {
    $model = new Report_Model();
    $modsave = new Save_model();

    $tanggal = $this->request->getPost('id');
    $tgl = strtotime($tanggal);
    $jmlhari = 0;
    $v_col = '';
    $id = 1;
    $model->_deletenominatif($id);
    $dttunggakan = $model->get_dbtunggakan($tanggal);
    foreach ($dttunggakan->getResult() as $row1) {
      $norekening = $row1->trx_code;
      $bclosing = $model->get_dttunggakan($norekening, $tanggal);
      $i = 0;
      foreach ($bclosing->getResult() as $row) {
        $v_trx_code = $row->trx_code;
        $v_tgk_pokk = $row->tgk_pokk;
        $v_tgk_bung = $row->tgk_bung;
        $v_trx_jtdt = $row->trx_jtdt;
        if ($v_tgk_pokk > 0) {
          $tgl1 = strtotime($v_trx_jtdt);
          $tgl2 = strtotime($tanggal);
          $jmlhari = ($tgl2 - $tgl1) / 60 / 60 / 24;
        }
        //     Kredit Lancar (L)
        // Debitur memenuhi kewajiban pembayaran setiap bulannya, secara tepat waktu dan tepat jumlah ;
        //  Kredit Dalam Perhatian Khusus (DPK)
        // Debitur tercatat mengalami penunggakan angsuran kredit mulai 31 – 90 Hari dari jadwal pembayaran seharusnya ;
        //  Kredit Kurang Lancar (KL)

        // Debitur mengalami penunggakan angsuran kredit mulai 91 – 120 Hari dari jadwal pembayaran seharusnya ;
        // Kredit Diraguakan (D)
        // Debitur tercatat mengalami penunggakan angsuran kredit mulai 121 – 180 Hari dari jadwal pembayaran seharusnya ;
        //  Kredit Macet (M)
        // Debitur tercatat mengalami penunggakan angsuran kredit selama lebih dari 180 hari dari jadwal pembayaran seharusnya.

        if ($jmlhari > 30 and $jmlhari <= 90) {
          $v_col = 'DPK';
        } elseif ($jmlhari > 90 and $jmlhari <= 120) {
          $v_col = 'KL';
        } elseif ($jmlhari > 120 and $jmlhari <= 180) {
          $v_col = 'D';
        } elseif ($jmlhari > 180) {
          $v_col = 'M';
        } else {
          $v_col = 'L';
        }

        $data = array(
          'tgk_code' => $v_trx_code,
          'tgk_pokk' => $v_tgk_pokk,
          'tgk_bung' => $v_tgk_bung,
          'tgk_dfdf' => $jmlhari,
          'tgk_hari' => $jmlhari,
          'tgk_date' => $v_trx_jtdt,
          'rgk_dcol' => $v_col,
          'com_code' => 1,
        );

        $modsave->_save_nominatif($data);
      }
    }




    $data = $model->_get_nominatif()->getResult();

    echo json_encode($data);
  }

  public function printnominatip()
  {

    $model = new Report_Model();
    $modsave = new Save_model();
    $tanggal = $this->request->getPost('trx_date');
    $tgl = strtotime($tanggal);
    $jmlhari = 0;
    $v_col = '';
    $id = 1;
    $model->_deletenominatif($id);
    $dttunggakan = $model->get_dbtunggakan($tanggal);
    foreach ($dttunggakan->getResult() as $row1) {
      $norekening = $row1->trx_code;
      $bclosing = $model->get_dttunggakan($norekening, $tanggal);
      $i = 0;
      foreach ($bclosing->getResult() as $row) {
        $v_trx_code = $row->trx_code;
        $v_tgk_pokk = $row->tgk_pokk;
        $v_tgk_bung = $row->tgk_bung;
        $v_trx_jtdt = $row->trx_jtdt;
        if ($v_tgk_pokk > 0) {
          $tgl1 = strtotime($v_trx_jtdt);
          $tgl2 = strtotime($tanggal);
          $jmlhari = ($tgl2 - $tgl1) / 60 / 60 / 24;
        }
        //     Kredit Lancar (L)
        // Debitur memenuhi kewajiban pembayaran setiap bulannya, secara tepat waktu dan tepat jumlah ;
        //  Kredit Dalam Perhatian Khusus (DPK)
        // Debitur tercatat mengalami penunggakan angsuran kredit mulai 31 – 90 Hari dari jadwal pembayaran seharusnya ;
        //  Kredit Kurang Lancar (KL)

        // Debitur mengalami penunggakan angsuran kredit mulai 91 – 120 Hari dari jadwal pembayaran seharusnya ;
        // Kredit Diraguakan (D)
        // Debitur tercatat mengalami penunggakan angsuran kredit mulai 121 – 180 Hari dari jadwal pembayaran seharusnya ;
        //  Kredit Macet (M)
        // Debitur tercatat mengalami penunggakan angsuran kredit selama lebih dari 180 hari dari jadwal pembayaran seharusnya.

        if ($jmlhari > 30 and $jmlhari <= 90) {
          $v_col = 'DPK';
        } elseif ($jmlhari > 90 and $jmlhari <= 120) {
          $v_col = 'KL';
        } elseif ($jmlhari > 120 and $jmlhari <= 180) {
          $v_col = 'D';
        } elseif ($jmlhari > 180) {
          $v_col = 'M';
        } else {
          $v_col = 'L';
        }

        $data = array(
          'tgk_code' => $v_trx_code,
          'tgk_pokk' => $v_tgk_pokk,
          'tgk_bung' => $v_tgk_bung,
          'tgk_dfdf' => $jmlhari,
          'tgk_hari' => $jmlhari,
          'tgk_date' => $v_trx_jtdt,
          'rgk_dcol' => $v_col,
          'com_code' => 1,
        );

        $modsave->_save_nominatif($data);
      }
    }

    $data['v_nominatip'] = $model->_get_nominatif()->getResult();
    return view('print/rptnominatif', $data);
  }

  public function trantabungan()
  {
    $model = new Master_model();
    $_SESSION['com_menu'] = '08';
    $_SESSION['com_men1'] = '0802';
    $_SESSION['com_men2'] = '';
    $tahun = date('Y');
    $bulan = date('m');
    $hari_ini = $tahun . '-' . $bulan . '-01'; // date("Y-m-d");
    $data['tgl1'] = $hari_ini;
    $data['tgl2'] = date("Y-m-d");
    $data['v_cabang']  = $model->_get_cabang()->getResult();
    return view('report/tabunganharian', $data);
  }

  public function tabtutup()
  {
    $model = new Master_model();
    $_SESSION['com_menu'] = '08';
    $_SESSION['com_men1'] = '0802';
    $_SESSION['com_men2'] = '';
    $tahun = date('Y');
    $bulan = date('m');
    $hari_ini = $tahun . '-' . $bulan . '-01'; // date("Y-m-d");
    $data['tgl1'] = $hari_ini;
    $data['tgl2'] = date("Y-m-d");
    $data['v_cabang']  = $model->_get_cabang()->getResult();
    return view('report/tabungantutup', $data);
  }

  public function tabbaru()
  {
    $model = new Master_model();
    $_SESSION['com_menu'] = '08';
    $_SESSION['com_men1'] = '0802';
    $_SESSION['com_men2'] = '';
    $tahun = date('Y');
    $bulan = date('m');
    $hari_ini = $tahun . '-' . $bulan . '-01'; // date("Y-m-d");
    $data['tgl1'] = $hari_ini;
    $data['tgl2'] = date("Y-m-d");
    $data['v_cabang']  = $model->_get_cabang()->getResult();
    return view('report/tabunganbaru', $data);
  }

  public function margintab()
  {
    $model = new Master_model();
    $_SESSION['com_menu'] = '08';
    $_SESSION['com_men1'] = '0802';
    $_SESSION['com_men2'] = '';
    $tahun = date('Y');
    $bulan = date('m');
    $hari_ini = $tahun . '-' . $bulan . '-01'; // date("Y-m-d");
    $data['tgl1'] = $hari_ini;
    $data['tgl2'] = date("Y-m-d");
    $data['v_cabang']  = $model->_get_cabang()->getResult();
    return view('report/tabjasa', $data);
  }

  public function mutasitab()
  {
    $model = new Master_model();
    $_SESSION['com_menu'] = '08';
    $_SESSION['com_men1'] = '0802';
    $_SESSION['com_men2'] = '';
    $tahun = date('Y');
    $bulan = date('m');
    $hari_ini = $tahun . '-' . $bulan . '-01'; // date("Y-m-d");
    $data['tgl1'] = $hari_ini;
    $data['tgl2'] = date("Y-m-d");
    $data['v_cabang']  = $model->_get_cabang()->getResult();
    return view('report/tabmutasi', $data);
  }

  public function nominatiftab()
  {
    $model = new Master_model();
    $_SESSION['com_menu'] = '08';
    $_SESSION['com_men1'] = '0802';
    $_SESSION['com_men2'] = '';
    $tahun = date('Y');
    $bulan = date('m');
    $hari_ini = $tahun . '-' . $bulan . '-01'; // date("Y-m-d");
    $data['tgl1'] = $hari_ini;
    $data['tgl2'] = date("Y-m-d");
    $data['v_cabang']  = $model->_get_cabang()->getResult();
    return view('report/nominatiftab', $data);
  }

  public function ctkbukutabungan()
  {
    $model = new Model_git();
    $_SESSION['com_menu'] = '08';
    $_SESSION['com_men1'] = '0801';
    $_SESSION['com_men2'] = '';
    $tahun = date('Y');
    $bulan = date('m');
    $hari_ini = $tahun . '-' . $bulan . '-01'; // date("Y-m-d");
    $data['tgl1'] = $hari_ini;
    $data['tgl2'] = date("Y-m-d");
    // $data['v_rekening']  = $model->_get_rektabungan()->getResult();
    return view('report/bukutabungank');
  }

  public function printbukutabungank()
  {
    $model = new Report_Model();
    $mgit = new Report_model();
    $_SESSION['com_menu'] = '08';
    $_SESSION['com_men1'] = '0801';
    $_SESSION['com_men2'] = '';
    $norekening = $this->request->getPost('tbg_code');
    $tanggal1 = $this->request->getPost('trx_date');
    $tanggal2 = $this->request->getPost('trx_dat1');
    $start = $this->request->getPost('trx_dat1');

    $data['tglawal'] = $tanggal1;
    // $data['tabungan'] = $mgit->_get_dtabunganid($norekening)->getResult();
    $data['saldoawal'] = $model->_get_bukutabunganawal_id($norekening, $tanggal1)->getResult();
    $data['v_tabungan'] = $model->_get_bukutabungan_id($norekening, $tanggal1, $tanggal2)->getResult();


    return view('print/rptbukutabungank', $data);
  }

  public function coverbuku()
  {
    $model = new Model_git();
    $_SESSION['com_menu'] = '08';
    $_SESSION['com_men1'] = '0801';
    $_SESSION['com_men2'] = '';
    // $data['v_rekening']  = $model->_get_rektabungan()->getResult();
    return view('report/tabungancover');
  }

  public function printcoverbuku()
  {
    $model = new Report_Model();
    $_SESSION['com_menu'] = '08';
    $_SESSION['com_men1'] = '0801';
    $_SESSION['com_men2'] = '';
    $norekening = $this->request->getPost('tbg_code');

    $data['v_tabungan'] = $model->_get_covertabungan($norekening)->getResult();
    return view('print/rptcovertabungan', $data);
  }

  public function nominatifssb()
  {
    $mmaster = new Master_model();
    $_SESSION['com_menu'] = '08';
    $_SESSION['com_men1'] = '0803';
    $_SESSION['com_men2'] = '';
    $tahun = date('Y');
    $bulan = date('m');
    $hari_ini = $tahun . '-' . $bulan . '-01'; // date("Y-m-d");
    $data['tgl1'] = $hari_ini;
    $data['tgl2'] = date("Y-m-d");
    $data['v_cabang']  = $mmaster->_get_cabang()->getResult();
    return view('report/ssb/ssbnominatif', $data);
  }

  public function transaksissb()
  {
    $mmaster = new Master_model();
    $_SESSION['com_menu'] = '08';
    $_SESSION['com_men1'] = '0803';
    $_SESSION['com_men2'] = '';
    $bulan = date('m');
    $tahun = date('Y');
    $tgla = date($tahun . '-' . $bulan . '-01');
    $tglb = date('Y-m-d');
    $data['tgl1'] = $tgla;
    $data['tgl2'] = $tglb;
    $data['v_cabang']  = $mmaster->_get_cabang()->getResult();
    return view('report/ssb/ssbtransaksi', $data);
  }

  public function ssbbaru()
  {
    $mmaster = new Master_model();
    $_SESSION['com_menu'] = '08';
    $_SESSION['com_men1'] = '0803';
    $_SESSION['com_men2'] = '';
    $bulan = date('m');
    $tahun = date('Y');
    $tgla = date($tahun . '-' . $bulan . '-01');
    $tglb = date('Y-m-d');
    $data['tgl1'] = $tgla;
    $data['tgl2'] = $tglb;
    $data['v_cabang']  = $mmaster->_get_cabang()->getResult();
    return view('report/ssb/ssbbaru', $data);
  }
  public function ssbtutup()
  {
    $mmaster = new Master_model();
    $_SESSION['com_menu'] = '08';
    $_SESSION['com_men1'] = '0803';
    $_SESSION['com_men2'] = '';
    $tahun = date('Y');
    $bulan = date('m');
    $hari_ini = $tahun . '-' . $bulan . '-01'; // date("Y-m-d");
    $data['tgl1'] = $hari_ini;
    $data['tgl2'] = date("Y-m-d");
    $data['v_cabang']  = $mmaster->_get_cabang()->getResult();
    return view('report/ssb/ssbtutup', $data);
  }

  public function jadwalssb()
  {
    $model = new Master_model();
    $_SESSION['com_menu'] = '08';
    $_SESSION['com_men1'] = '0803';
    $_SESSION['com_men2'] = '';
    $tahun = date('Y');
    $bulan = date('m');
    $hari_ini = $tahun . '-' . $bulan . '-01'; // date("Y-m-d");
    $data['tgl1'] = $hari_ini;
    $data['tgl2'] = date("Y-m-d");
    $data['v_tahun']  = $model->_get_tahun()->getResult();
    $data['v_cabang']  = $model->_get_cabang()->getResult();
    return view('report/ssb/ssbjadwalpajak', $data);
  }

  public function rekeningkoranssb()
  {
    $model = new Master_model();
    $_SESSION['com_menu'] = '08';
    $_SESSION['com_men1'] = '0803';
    $_SESSION['com_men2'] = '';
    $bulan = date('m');
    $tahun = date('Y');
    $tgla = date($tahun . '-' . $bulan . '-01');
    $tglb = date('Y-m-d');
    $data['tgl1'] = $tgla;
    $data['tgl2'] = $tglb;
    $data['v_rekening']  = $model->_get_rekdeposito()->getResult();
    return view('report/ssb/ssbrekkoran', $data);
  }

  public function pembiayaantransaksi()
  {
    $model = new Master_model();
    $_SESSION['com_menu'] = '08';
    $_SESSION['com_men1'] = '0804';
    $_SESSION['com_men2'] = '';
    $bulan = date('m');
    $tahun = date('Y');
    $tgla = date($tahun . '-' . $bulan . '-01');
    $tglb = date('Y-m-d');
    $data['tgl1'] = $tgla;
    $data['tgl2'] = $tglb;
    $data['v_cabang']  = $model->_get_cabang()->getResult();
    return view('report/pembiayaan/reppembiayaantrans', $data);
  }

  public function pembiayaanmutasi()
  {
    $model = new Master_model();
    $_SESSION['com_menu'] = '08';
    $_SESSION['com_men1'] = '0804';
    $_SESSION['com_men2'] = '';
    $bulan = date('m');
    $tahun = date('Y');
    $tgla = date($tahun . '-' . $bulan . '-01');
    $tglb = date('Y-m-d');
    $data['tgl1'] = $tgla;
    $data['tgl2'] = $tglb;
    $data['v_cabang']  = $model->_get_cabang()->getResult();
    return view('report/pembiayaan/reppembiayaanmutasi', $data);
  }

  public function tagihan()
  {
    $model = new Master_model();
    $_SESSION['com_menu'] = '08';
    $_SESSION['com_men1'] = '0804';
    $_SESSION['com_men2'] = '';
    $bulan = date('m');
    $tahun = date('Y');
    $tgla = date($tahun . '-' . $bulan . '-01');
    $tglb = date('Y-m-d');
    $data['tgl1'] = $tgla;
    $data['tgl2'] = $tglb;
    $data['v_cabang']  = $model->_get_cabang()->getResult();
    return view('report/pembiayaan/reptagihan', $data);
  }

  public function ppap()
  {
    $model = new Master_model();
    $_SESSION['com_menu'] = '08';
    $_SESSION['com_men1'] = '0804';
    $_SESSION['com_men2'] = '';
    $bulan = date('m');
    $tahun = date('Y');
    $tgla = date($tahun . '-' . $bulan . '-01');
    $tglb = date('Y-m-d');
    $data['tgl1'] = $tgla;
    $data['tgl2'] = $tglb;
    $data['v_cabang']  = $model->_get_cabang()->getResult();
    return view('report/pembiayaan/repppap', $data);
  }

  public function Performance()
  {
    $mmaster = new Master_model();
    $_SESSION['com_menu'] = '08';
    $_SESSION['com_men1'] = '0804';
    $_SESSION['com_men2'] = '';
    $bulan = date('m');
    $tahun = date('Y');
    $tgla = date($tahun . '-' . $bulan . '-01');
    $tglb = date('Y-m-d');
    $data['tgl1'] = $tgla;
    $data['tgl2'] = $tglb;
    $data['v_cabang']  = $mmaster->_get_cabang()->getResult();
    return view('report/pembiayaan/reperformance', $data);
  }

  public function lunas()
  {
    $model = new Master_model();
    $_SESSION['com_menu'] = '08';
    $_SESSION['com_men1'] = '0804';
    $_SESSION['com_men2'] = '';
    $bulan = date('m');
    $tahun = date('Y');
    $tgla = date($tahun . '-' . $bulan . '-01');
    $tglb = date('Y-m-d');
    $data['tgl1'] = $tgla;
    $data['tgl2'] = $tglb;
    $data['v_cabang']  = $model->_get_cabang()->getResult();
    return view('report/pembiayaan/reppembayaranlunas', $data);
  }

  public function posisikas()
  {
    $model = new Model_git();
    $mmaster = new Master_model();
    $_SESSION['com_menu'] = '08';
    $_SESSION['com_men1'] = '0801';
    $_SESSION['com_men2'] = '';
    $tahun = date('Y');
    $bulan = date('m');
    $hari_ini = $tahun . '-' . $bulan . '-01'; // date("Y-m-d");
    $data['tgl1'] = date('Y-m-01', strtotime($hari_ini));
    $data['tgl2'] = date('Y-m-d'); //date('Y-m-t', strtotime($hari_ini));
    $data['v_cabang']  = $mmaster->_get_cabang()->getResult();
    $data['v_bank']  = $model->_getbank()->getResult();
    return view('report/kas/posisikas', $data);
  }


  public function datanggota()
  {
    $_SESSION['com_menu'] = '08';
    $_SESSION['com_men1'] = '0800';
    $_SESSION['com_men2'] = '';
    $bulan = date('m');
    $tahun = date('Y');
    $tgla = date($tahun . '-' . $bulan . '-01');
    $tglb = date('Y-m-d');
    $data['tgl1'] = $tgla;
    $data['tgl2'] = $tglb;
    return view('report/dftanggota', $data);
  }

  public function tellerharian()
  {
    $model = new Master_model();
    $_SESSION['com_menu'] = '08';
    $_SESSION['com_men1'] = '0801';
    $_SESSION['com_men2'] = '';
    $id = 'T';
    $cabang = session()->get('kode_cabang');
    if ($_SESSION['usr_jabt'] == 'Administrator') {
      $data['v_bank']  = $model->_get_bankteller()->getResult();
    } else {
      $data['v_bank'] = $model->_get_banktellercabang($cabang)->getResult();
    }
    $data['v_product']  = $model->_get_product1($id)->getResult();
    $data['tgl'] = date('Y-m-d');
    $data['dbcabang'] = $cabang;
    return view('report/kasumum/repharianteller', $data);
  }

  public function aruskas()
  {
    $model = new Master_model();
    $_SESSION['com_menu'] = '08';
    $_SESSION['com_men1'] = '0805';
    $_SESSION['com_men2'] = '';
    $data['v_cabang']  = $model->_get_cabang()->getResult();
    $data['v_tahun']  = $model->_get_tahun()->getResult();

    return view('report/accounting/aruskas', $data);
  }

  public function perubahanmodal()
  {
    $model = new Master_model();
    $_SESSION['com_menu'] = '08';
    $_SESSION['com_men1'] = '0805';
    $_SESSION['com_men2'] = '';
    $data['v_cabang']  = $model->_get_cabang()->getResult();
    $data['v_tahun']  = $model->_get_tahun()->getResult();

    return view('report/accounting/perubahan', $data);
  }

  public function repsimpanan()
  {
    $model = new Report_model();
    $modelm = new Master_model();
    $tgl1 = $this->request->getPost('trx_date');
    $tgl2 = $this->request->getPost('trx_date');
    $kode = $this->request->getPost('prd_code');

    // $data['v_product']  = $modelm->_get_product1($id)->getResult();

    // $html = view('rpt/accounting/neraca.php');
    $pdf = new TCPDF('P', PDF_UNIT, 'A4', true, 'UTF-8', false);

    $pdf->SetCreator(PDF_CREATOR);
    $pdf->SetAuthor('GIT');
    $pdf->SetTitle('Simpanan');
    $pdf->SetSubject('Simpanan');

    $pdf->setPrintHeader(false);
    $pdf->setPrintFooter(false);

    $pdf->addPage();
    $image_file = 'assets/images/' . $_SESSION['com_logo'];
    /**
     * width : 50
     */


    $image_file = 'assets/images/' . $_SESSION['com_logo'];

    /**
     * width : 50
     */
    $pdf->Image($image_file, '', '', 20);

    // Set font
    $pdf->SetFont('helvetica', 'B', 11);
    $pdf->SetX(40);
    $pdf->Cell(0, 2, $_SESSION['com_name'], 0, 1, '', 0, '', 0);

    $pdf->SetX(40);
    $pdf->SetFont('helvetica', '', 8);
    $pdf->Cell(0, 2, $_SESSION['com_adrs'], 0, 1, '', 0, '', 0);

    // $pdf->SetX(40);
    // Title

    // Footer
    // Position at 15 mm from bottom


    //

    $pdf->Ln();


    $pdf->Ln();
    $pdf->SetFont('helvetica', '', 11);
    $pdf->Cell(190, 7, 'SIMPANAN', 0, 1, 'C');

    // $pdf->Ln();
    $pdf->SetFont('helvetica', '', 9);
    $pdf->Cell(190, 5, 'Tanggal : ' . date('d/m/Y', strtotime($tgl1)), 0, 1, 'L');

    $pdf->SetFont('helvetica', '', 8);
    $id = 'T';
    if ($kode == '') {
      $account = $modelm->_get_product1($id);
    } else {
      $account = $modelm->_get_product1A($id, $kode);
    }
    foreach ($account->getResult() as $row) {
      $prd_code = $row->prd_code;
      $pdf->Ln();
      $pdf->Cell(190, 4, $row->prd_name, 1, 0, 'C');

      $pdf->Ln();
      $pdf->Cell(25, 14, 'No. Rekening', 1, 0, 'C');
      $pdf->Cell(40, 14, 'Nama', 1, 0, 'C');
      $pdf->Cell(75, 7, 'Transaksi', 1, 0, 'C');
      $pdf->Cell(50, 7, 'Keterangan', 'RT', 0, 'C');
      $pdf->Ln();
      $pdf->Cell(25, 7, '', 0, 0, 'C');
      $pdf->Cell(40, 7, '', 0, 0, 'C');
      $pdf->Cell(25, 7, 'Penarikan', 1, 0, 'C');
      $pdf->Cell(25, 7, 'Setor', 1, 0, 'C');
      $pdf->Cell(25, 7, 'Administrasi', 1, 0, 'C');
      $pdf->Cell(50, 7, '', 'BR', 0, 'C');
      $pdf->Ln();

      $i = 0;
      $saldo = 0;
      $debet = 0;
      $credit = 0;
      $admin = 0;
      $dttrans = $model->_get_trantabprod($prd_code, $tgl1, $tgl2);
      foreach ($dttrans->getResult() as $row1) {

        if ($row->acc_nblc == 'K') {
          $saldo = $saldo - $row1->kin_debt + $row1->kin_crdt + $row1->kin_admn;
        } else {
          $saldo = $saldo + $row1->kin_debt - $row1->kin_crdt + $row1->kin_admn;
        }
        $debet = $debet + $row1->kin_debt;
        $credit = $credit + $row1->kin_crdt;
        $admin = $admin  + $row1->kin_admn;



        $pdf->Cell(25, 7, $row1->tbg_code, 1, 0, 'C');
        $pdf->Cell(40, 7, $row1->agt_name, 1, 0, 'L');
        $pdf->Cell(25, 7, number_format($row1->kin_debt), 1, 0, 'R');
        $pdf->Cell(25, 7, number_format($row1->kin_crdt), 1, 0, 'R');
        $pdf->Cell(25, 7, number_format($row1->kin_admn), 1, 0, 'R');
        $pdf->MultiCell(50, 7, $row1->kin_desc, 1, 'L', false);
        $pdf->Ln();
      }
      // $pdf->Ln();
      $pdf->Cell(65, 7, 'TOTAL', 1, 0, 'C');
      $pdf->Cell(25, 7, number_format($debet), 1, 0, 'R');
      $pdf->Cell(25, 7, number_format($credit), 1, 0, 'R');
      $pdf->Cell(25, 7, number_format($admin), 1, 0, 'R');
      $pdf->Cell(50, 7, '', 1, 0, 'C');
      $pdf->Ln();
    }


    // output the HTML content


    // $pdf->writeHTML($html, true, false, true, false, '');
    //line ini penting

    $this->response->setContentType('application/pdf');

    $pdf->SetY(-24);
    // Set font
    $pdf->SetFont('helvetica', 'I', 8);
    // Page number
    $pdf->Cell(0, 2, 'Page ' . $pdf->getAliasNumPage() . '/' . $pdf->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
    //Close and output PDF document
    $pdf->Output('Repsimpanan.pdf', 'I');
  }

  public function repteller()
  {
    $model = new Report_model();
    $modelm = new Master_model();
    $tgl1 = $this->request->getPost('trx_date');
    $tgl2 = $this->request->getPost('trx_date');
    $kode = $this->request->getPost('prd_code');
    $acc_cash = $this->request->getPost('bnk_code');
    // $data['v_product']  = $modelm->_get_product1($id)->getResult();

    // $html = view('rpt/accounting/neraca.php');
    $pdf = new TCPDF('P', PDF_UNIT, 'A4', true, 'UTF-8', false);

    $pdf->SetCreator(PDF_CREATOR);
    $pdf->SetAuthor('GIT');
    $pdf->SetTitle('Laporan Kas Teller');
    $pdf->SetSubject('Laporan Kas Teller');

    $pdf->setPrintHeader(false);
    $pdf->setPrintFooter(false);

    $pdf->addPage();
    $image_file = 'assets/images/' . $_SESSION['com_logo'];


    /**
     * width : 50
     */
    $pdf->Image($image_file, '', '', 20);

    // Set font
    $pdf->SetFont('helvetica', 'B', 11);
    $pdf->SetX(40);
    $pdf->Cell(0, 2, $_SESSION['com_name'], 0, 1, '', 0, '', 0);

    $pdf->SetX(40);
    $pdf->SetFont('helvetica', '', 8);
    $pdf->Cell(0, 2, $_SESSION['com_adrs'], 0, 1, '', 0, '', 0);

    // $pdf->SetX(40);
    // Title

    // Footer
    // Position at 15 mm from bottom


    //

    $pdf->Ln();


    $pdf->Ln();
    $pdf->SetFont('helvetica', '', 9);
    $pdf->Cell(190, 7, 'LAPORAN KAS HARIAN', 0, 1, 'C');
    // $pdf->Ln();
    $pdf->Cell(190, 7, 'UNIT JASA ', 0, 1, 'C');
    // $pdf->Ln();

    $pdf->Cell(190, 5, 'Tanggal : ' . date('d/m/Y', strtotime($tgl1)), 0, 1, 'C');

    $pdf->SetFont('helvetica', '', 8);


    $pdf->Ln();
    $pdf->Cell(25, 7, 'No', 1, 0, 'C');
    $pdf->Cell(105, 7, '', 1, 0, 'C');
    $pdf->Cell(30, 7, 'Debet', 1, 0, 'C');
    $pdf->Cell(30, 7, 'Kredit', 1, 0, 'C');
    $pdf->Ln();

    $i = 0;
    $saldoawal = 0;
    $debet = 0;
    $credit = 0;
    $admin = 0;
    $id = $acc_cash;
    $dttrans = $model->_get_saldoawalkas($id, $tgl1);
    $baris = 0;
    foreach ($dttrans->getResult() as $row1) {
      $baris = 0;
      $saldoawal = $row1->trx_amnt;
      $pdf->Cell(25, 7, '1', 'L', 0, 'C');
      $pdf->Cell(105, 7, $row1->trx_des1, 0, 0, 'L');
      $pdf->Cell(30, 7, number_format($row1->trx_amnt), 0, 0, 'R');
      $pdf->Cell(30, 7, '', 'R', 0, 'L');
    }
    if ($baris == 0) {
      // $saldoawal = 0;
      $pdf->Cell(25, 7, '1', 'L', 0, 'C');
      $pdf->Cell(105, 7, 'Saldo Awal ', 0, 0, 'L');
      $pdf->Cell(30, 7, number_format(0), 0, 0, 'R');
      $pdf->Cell(30, 7, '', 'R', 0, 'L');
    }
    $pdf->Ln();
    //Setoran
    $pdf->Cell(25, 7, '2', 'L', 0, 'C');
    $pdf->Cell(105, 7, 'Penerimaan', 0, 0, 'L');
    $pdf->Cell(30, 7, '', 0, 0, 'R');
    $pdf->Cell(30, 7, '', 'R', 0, 'L');
    $pdf->Ln();
    $id2 = 'D';
    $dttrans1 = $model->_gettranskas($id, $id2, $tgl1);
    $debet = 0;
    foreach ($dttrans1->getResult() as $row2) {
      $debet = $debet + $row2->dbt_amnt;

      $pdf->Cell(30, 7, '', 'L', 0, 'C');
      $pdf->Cell(100, 7, $row2->trx_des2, 0, 0, 'L');
      $pdf->Cell(30, 7, number_format($row2->dbt_amnt), 0, 0, 'R');
      $pdf->Cell(30, 7, '', 'R', 0, 'L');
      $pdf->Ln();
    }
    //Pengeluaran
    $pdf->Cell(25, 7, '3', 'L', 0, 'C');
    $pdf->Cell(105, 7, 'Pengeluaran', 0, 0, 'L');
    $pdf->Cell(30, 7, '', 0, 0, 'R');
    $pdf->Cell(30, 7, '', 'R', 0, 'L');
    $pdf->Ln();
    $id2 = 'K';
    $credit = 0;
    $dttrans1 = $model->_gettranskas($id, $id2, $tgl1);
    foreach ($dttrans1->getResult() as $row2) {
      $credit = $credit + $row2->crd_amnt;

      $pdf->Cell(30, 7, '', 'L', 0, 'C');
      $pdf->Cell(100, 7, $row2->trx_des2, 0, 0, 'L');
      $pdf->Cell(30, 7, '', 0, 0, 'R');
      $pdf->Cell(30, 7, number_format($row2->crd_amnt), 'R', 0, 'R');
      $pdf->Ln();
    }
    $debet = $debet + $saldoawal;
    $pdf->Cell(25, 7, 'TOTAL', 'LB', 0, 'C');
    $pdf->Cell(105, 7, '', 'B', 0, 'L');
    $pdf->Cell(30, 7, number_format($debet), 'B', 0, 'R');
    $pdf->Cell(30, 7, number_format($credit), 'R', 0, 'R');
    $pdf->Ln();
    $saldo =  $debet - $credit;
    $pdf->Cell(25, 7, 'SALDO AKHIR', 'LB', 0, 'C');
    $pdf->Cell(105, 7, '', 'B', 0, 'L');
    $pdf->Cell(30, 7, '', 'B', 0, 'R');
    $pdf->Cell(30, 7, number_format($saldo), 'RBT', 0, 'R');
    $pdf->Ln();
    // $pdf->Ln();
    $pdf->Cell(5, 7, '', 'L', 0, 'L');
    $pdf->Cell(25, 7, 'Jakarta Selatan ' . date('d/m/Y', strtotime($tgl1)), '0', 0, 'L');
    $pdf->Cell(100, 7, '', '0', 0, 'L');
    $pdf->Cell(30, 7, '', '0', 0, 'R');
    $pdf->Cell(30, 7, '', 'R', 0, 'R');
    $pdf->Ln();

    $pdf->Cell(60, 7, 'Dibuat Oleh ', 'L', 0, 'C');
    $pdf->Cell(60, 7, 'Diperisa Oleh', '0', 0, 'C');
    $pdf->Cell(70, 7, 'Disetujui Oleh', 'R', 0, 'C');

    $pdf->Ln();

    $pdf->Cell(60, 7, 'Teller ', 'L', 0, 'C');
    $pdf->Cell(60, 7, 'Accounting', '0', 0, 'C');
    $pdf->Cell(70, 7, '', 'R', 0, 'C');

    $pdf->Ln();
    $pdf->Cell(60, 7, ' ', 'L', 0, 'C');
    $pdf->Cell(60, 7, '', '0', 0, 'L');
    $pdf->Cell(70, 7, ' ', 'R', 0, 'R');

    $pdf->Ln();
    $pdf->Cell(60, 7, ' ', 'L', 0, 'C');
    $pdf->Cell(60, 7, '', '0', 0, 'L');
    $pdf->Cell(70, 7, ' ', 'R', 0, 'R');
    $pdf->Ln();
    $pdf->Cell(60, 7, ' ', 'L', 0, 'C');
    $pdf->Cell(60, 7, '', '0', 0, 'L');
    $pdf->Cell(70, 7, ' ', 'R', 0, 'R');
    $pdf->Ln();
    $pdf->Cell(60, 7, session()->get('usr_name'), 'L', 0, 'C');
    $pdf->Cell(60, 7, 'Poppy Patonah', '0', 0, 'C');
    $pdf->Cell(70, 7, ' ', 'R', 0, 'R');
    $pdf->Ln();
    $pdf->Cell(60, 7, ' ', 'LB', 0, 'C');
    $pdf->Cell(60, 7, '', 'B', 0, 'L');
    $pdf->Cell(70, 7, ' ', 'RB', 0, 'R');
    $pdf->Ln();
    // output the HTML content


    // $pdf->writeHTML($html, true, false, true, false, '');
    //line ini penting

    $this->response->setContentType('application/pdf');

    $pdf->SetY(-24);
    // Set font
    $pdf->SetFont('helvetica', 'I', 8);
    // Page number
    $pdf->Cell(0, 2, 'Page ' . $pdf->getAliasNumPage() . '/' . $pdf->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
    //Close and output PDF document
    $pdf->Output('Kasteller.pdf', 'I');
  }

  public function reptellerdetil()
  {
    $model = new Report_model();

    $tgl1 = $this->request->getPost('trx_date');
    $tgl2 = $this->request->getPost('trx_date');
    $kode = $this->request->getPost('prd_code');
    $acc_cash = $this->request->getPost('bnk_code');
    // $data['v_product']  = $modelm->_get_product1($id)->getResult();

    // $html = view('rpt/accounting/neraca.php');
    $pdf = new TCPDF('P', PDF_UNIT, 'A4', true, 'UTF-8', false);

    $pdf->SetCreator(PDF_CREATOR);
    $pdf->SetAuthor('GIT');
    $pdf->SetTitle('Laporan Kas Teller');
    $pdf->SetSubject('Laporan Kas Teller');

    $pdf->setPrintHeader(false);
    $pdf->setPrintFooter(false);

    $pdf->addPage();
    $image_file = 'assets/images/' . $_SESSION['com_logo'];


    /**
     * width : 50
     */
    $pdf->Image($image_file, '', '', 20);

    // Set font
    $pdf->SetFont('helvetica', 'B', 11);
    $pdf->SetX(40);
    $pdf->Cell(0, 2, $_SESSION['com_name'], 0, 1, '', 0, '', 0);

    $pdf->SetX(40);
    $pdf->SetFont('helvetica', '', 8);
    $pdf->Cell(0, 2, $_SESSION['com_adrs'], 0, 1, '', 0, '', 0);

    // $pdf->SetX(40);
    // Title

    // Footer
    // Position at 15 mm from bottom


    //

    $pdf->Ln();


    $pdf->Ln();
    $pdf->SetFont('helvetica', '', 9);
    $pdf->Cell(190, 7, 'LAPORAN KAS HARIAN', 0, 1, 'C');
    // $pdf->Ln();
    $pdf->Cell(190, 7, 'UNIT JASA ', 0, 1, 'C');
    // $pdf->Ln();

    $pdf->Cell(190, 5, 'Tanggal : ' . date('d/m/Y', strtotime($tgl1)), 0, 1, 'C');

    $pdf->SetFont('helvetica', '', 8);


    $pdf->Ln();
    $pdf->Cell(25, 7, 'No', 1, 0, 'C');
    $pdf->Cell(105, 7, '', 1, 0, 'C');
    $pdf->Cell(30, 7, 'Debet', 1, 0, 'C');
    $pdf->Cell(30, 7, 'Kredit', 1, 0, 'C');
    $pdf->Ln();

    $i = 0;
    $saldoawal = 0;
    $debet = 0;
    $credit = 0;
    $admin = 0;
    // $id = "10102";
    $id = $acc_cash;

    $dttrans1 = $model->_gettranskasdtl($id, $tgl1);
    $debet = 0;
    $credit = 0;
    foreach ($dttrans1->getResult() as $row2) {
      $i = $i + 1;
      $debet = $debet + $row2->dbt_amnt;
      $credit = $credit + $row2->crd_amnt;
      // $pdf->Cell(30, 7, date('d/m/Y', strtotime($row2->trx_date)), 'L', 0, 'C');
      $pdf->Cell(30, 7, $i, 'L', 0, 'C');
      $pdf->Cell(100, 7, $row2->trx_des1, 0, 0, 'L');
      $pdf->Cell(30, 7, number_format($row2->dbt_amnt), 0, 0, 'R');
      $pdf->Cell(30, 7, number_format($row2->crd_amnt), 'R', 0, 'R');
      $pdf->Ln();
    }


    $pdf->Cell(25, 7, 'TOTAL', 'LBT', 0, 'C');
    $pdf->Cell(105, 7, '', 'BT', 0, 'L');
    $pdf->Cell(30, 7, number_format($debet), 'BT', 0, 'R');
    $pdf->Cell(30, 7, number_format($credit), 'TR', 0, 'R');
    $pdf->Ln();
    $saldo =  $debet - $credit;
    $pdf->Cell(25, 7, 'SALDO AKHIR', 'LB', 0, 'C');
    $pdf->Cell(105, 7, '', 'B', 0, 'L');
    $pdf->Cell(30, 7, '', 'B', 0, 'R');
    $pdf->Cell(30, 7, number_format($saldo), 'RBT', 0, 'R');
    $pdf->Ln();
    // $pdf->Ln();

    // output the HTML content


    // $pdf->writeHTML($html, true, false, true, false, '');
    //line ini penting

    $this->response->setContentType('application/pdf');

    $pdf->SetY(-24);
    // Set font
    $pdf->SetFont('helvetica', 'I', 8);
    // Page number
    $pdf->Cell(0, 2, 'Page ' . $pdf->getAliasNumPage() . '/' . $pdf->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
    //Close and output PDF document
    $pdf->Output('Kastellerdetil.pdf', 'I');
  }

  public function kashariandetil()
  {
    $model = new Master_model();

    $_SESSION['com_menu'] = '08';
    $_SESSION['com_men1'] = '0801';
    $_SESSION['com_men2'] = '';
    $id = 'T';
    $cabang = session()->get('kode_cabang');
    if ($_SESSION['usr_jabt'] == 'Administrator') {
      $data['v_bank']  = $model->_get_bankteller()->getResult();
    } else {
      $data['v_bank'] = $model->_get_banktellercabang($cabang)->getResult();
    }

    $data['v_product']  = $model->_get_product1($id)->getResult();
    $data['tgl'] = date('Y-m-d');
    return view('report/kasumum/rephariantellerdetil', $data);
  }
  public function kasvaliidai()
  {
    $model = new Master_model();
    $_SESSION['com_menu'] = '08';
    $_SESSION['com_men1'] = '0801';
    $_SESSION['com_men2'] = '';
    $id = 'T';
    $data['v_product']  = $model->_get_product1($id)->getResult();
    $data['tgl'] = date('Y-m-d');
    return view('report/kasumum/rephariantellerdetil', $data);
  }
  public function seratuspinjaman()
  {
    $model = new Master_model();
    $_SESSION['com_menu'] = '08';
    $_SESSION['com_men1'] = '0804';
    $_SESSION['com_men2'] = '';
    $data['v_cabang']  = $model->_get_cabang()->getResult();
    return view('report/pembiayaan/pinjamseratus', $data);
  }


  public function rptseratuspinjaman()
  {
    $_SESSION['com_menu'] = '08';
    $_SESSION['com_men1'] = '0804';
    $_SESSION['com_men2'] = '';

    $model = new Report_model();

    $cabang = $this->request->getPost('cab_code');
    // $data['v_product']  = $modelm->_get_product1($id)->getResult();

    // $html = view('rpt/accounting/neraca.php');
    $pdf = new TCPDF('P', PDF_UNIT, 'A4', true, 'UTF-8', false);

    $pdf->SetCreator(PDF_CREATOR);
    $pdf->SetAuthor('GIT');
    $pdf->SetTitle('Laporan Seratus Pinjaman');
    $pdf->SetSubject('Laporan Seratus Pinjaman');

    $pdf->setPrintHeader(false);
    $pdf->setPrintFooter(false);

    $pdf->addPage();
    $image_file = 'assets/images/' . $_SESSION['com_logo'];


    /**
     * width : 50
     */
    $pdf->Image($image_file, '', '', 20);

    // Set font
    $pdf->SetFont('helvetica', 'B', 11);
    $pdf->SetX(40);
    $pdf->Cell(0, 2, $_SESSION['com_name'], 0, 1, '', 0, '', 0);

    $pdf->SetX(40);
    $pdf->SetFont('helvetica', '', 8);
    $pdf->Cell(0, 2, $_SESSION['com_adrs'], 0, 1, '', 0, '', 0);

    // $pdf->SetX(40);
    // Title

    // Footer
    // Position at 15 mm from bottom


    //

    $pdf->Ln();


    $pdf->Ln();
    $pdf->SetFont('helvetica', '', 9);
    $pdf->Cell(190, 7, 'LAPORAN SERATUS PINJAMAM TERBESAR ', 0, 1, 'C');
    // $pdf->Ln();
    $pdf->Cell(190, 7, 'UNIT JASA ', 0, 1, 'C');
    // $pdf->Ln();

    // $pdf->Cell(190, 5, 'Tanggal : ' . date('d/m/Y', strtotime($tgl1)), 0, 1, 'C');

    $pdf->SetFont('helvetica', '', 8);


    $pdf->Ln();
    $pdf->Cell(10, 10, 'No', 1, 0, 'C');
    $pdf->Cell(25, 10, 'No Rekening', 1, 0, 'C');
    $pdf->Cell(60, 10, 'Nama ', 1, 0, 'C');
    $pdf->Cell(50, 10, 'Produk', 1, 0, 'C');
    $pdf->Cell(20, 10, 'Jangka Waktu', 1, 0);
    $pdf->Cell(30, 10, 'Nilai', 1, 0, 'C');
    $pdf->Ln();

    $i = 0;
    $baris = 0;
    $otal = 0;
    if ($cabang != '') {
      $dttrans = $model->_get_jumkontrakcab($cabang);
    } else {
      $dttrans = $model->_get_jumkontrak();
    }


    foreach ($dttrans->getResult() as $row1) {

      $i = $i + 1;
      $baris = $baris + 1;
      $otal = $otal + $row1->pen_totl;
      $pdf->Cell(10, 7, $i, 'L', 0, 'C');
      $pdf->Cell(25, 7, $row1->knt_code, 0, 0, 'L');
      $pdf->Cell(60, 7, $row1->agt_name, 0, 0, 'L');
      $pdf->Cell(50, 7, $row1->prd_name, 0, 0, 'L');
      $pdf->Cell(20, 7, $row1->knt_tenr, 0, 0, 'C');

      $pdf->Cell(30, 7, number_format($row1->knt_totl), 'R', 0, 'R');
      $pdf->Ln();
    }


    $pdf->Cell(165, 10, 'TOTAL', '1', 0, 'C');

    $pdf->Cell(30, 10, number_format($otal), '1', 0, 'R');
    // $pdf->Ln();

    // output the HTML content


    // $pdf->writeHTML($html, true, false, true, false, '');
    //line ini penting

    $this->response->setContentType('application/pdf');

    $pdf->SetY(-24);
    // Set font
    $pdf->SetFont('helvetica', 'I', 8);
    // Page number
    $pdf->Cell(0, 2, 'Page ' . $pdf->getAliasNumPage() . '/' . $pdf->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
    //Close and output PDF document
    $pdf->Output('seratuspinjaman.pdf', 'I');
  }

  public function seratusskb()
  {
    $model = new Master_model();
    $_SESSION['com_menu'] = '08';
    $_SESSION['com_men1'] = '0803';
    $_SESSION['com_men2'] = '';
    $data['v_cabang']  = $model->_get_cabang()->getResult();
    return view('report/ssb/skbseratus', $data);
  }
  public function printseratusskb()
  {
    $model = new Report_model();
    $_SESSION['com_menu'] = '08';
    $_SESSION['com_men1'] = '0804';
    $_SESSION['com_men2'] = '';

    $cabang = $this->request->getPost('cab_code');
    // $data['v_product']  = $modelm->_get_product1($id)->getResult();

    // $html = view('rpt/accounting/neraca.php');
    $pdf = new TCPDF('P', PDF_UNIT, 'A4', true, 'UTF-8', false);

    $pdf->SetCreator(PDF_CREATOR);
    $pdf->SetAuthor('GIT');
    $pdf->SetTitle('Laporan Seratus SKB');
    $pdf->SetSubject('Laporan Seratus SKB');

    $pdf->setPrintHeader(false);
    $pdf->setPrintFooter(false);

    $pdf->addPage();
    $image_file = 'assets/images/' . $_SESSION['com_logo'];


    /**
     * width : 50
     */
    $pdf->Image($image_file, '', '', 20);

    // Set font
    $pdf->SetFont('helvetica', 'B', 11);
    $pdf->SetX(40);
    $pdf->Cell(0, 2, $_SESSION['com_name'], 0, 1, '', 0, '', 0);

    $pdf->SetX(40);
    $pdf->SetFont('helvetica', '', 8);
    $pdf->Cell(0, 2, $_SESSION['com_adrs'], 0, 1, '', 0, '', 0);

    // $pdf->SetX(40);
    // Title

    // Footer
    // Position at 15 mm from bottom


    //

    $pdf->Ln();


    $pdf->Ln();
    $pdf->SetFont('helvetica', '', 9);
    $pdf->Cell(190, 7, 'LAPORAN SERATUS SKB TERBESAR', 0, 1, 'C');
    // $pdf->Ln();
    $pdf->Cell(190, 7, 'UNIT JASA ', 0, 1, 'C');
    // $pdf->Ln();

    // $pdf->Cell(190, 5, 'Tanggal : ' . date('d/m/Y', strtotime($tgl1)), 0, 1, 'C');

    $pdf->SetFont('helvetica', '', 8);


    $pdf->Ln();
    $pdf->Cell(10, 10, 'No', 1, 0, 'C');
    $pdf->Cell(25, 10, 'No Rekening', 1, 0, 'C');
    $pdf->Cell(60, 10, 'Nama ', 1, 0, 'C');
    $pdf->Cell(50, 10, 'Produk', 1, 0, 'C');
    $pdf->Cell(20, 10, 'Jangka Waktu', 1, 0);
    $pdf->Cell(30, 10, 'Nilai', 1, 0, 'C');
    $pdf->Ln();

    $i = 0;
    if ($cabang != '') {
      $dttrans = $model->_get_jumskbcab($cabang);
    } else {
      $dttrans = $model->_get_jumskb();
    }

    $baris = 0;
    $otal = 0;
    foreach ($dttrans->getResult() as $row1) {
      $i = $i + 1;
      $baris = $baris + 1;
      $otal = $otal + $row1->pen_totl;
      $pdf->Cell(10, 7, $i, 'L', 0, 'C');
      $pdf->Cell(25, 7, $row1->pen_code, 0, 0, 'L');
      $pdf->Cell(60, 7, $row1->agt_name, 0, 0, 'L');
      $pdf->Cell(50, 7, $row1->prd_name, 0, 0, 'L');
      $pdf->Cell(20, 7, $row1->pen_tenr, 0, 0, 'C');

      $pdf->Cell(30, 7, number_format($row1->pen_totl), 'R', 0, 'R');
      $pdf->Ln();
    }

    $pdf->Cell(165, 10, 'TOTAL', '1', 0, 'C');

    $pdf->Cell(30, 10, number_format($otal), '1', 0, 'R');
    // $pdf->Ln();

    // output the HTML content


    // $pdf->writeHTML($html, true, false, true, false, '');
    //line ini penting

    $this->response->setContentType('application/pdf');

    $pdf->SetY(-24);
    // Set font
    $pdf->SetFont('helvetica', 'I', 8);
    // Page number
    $pdf->Cell(0, 2, 'Page ' . $pdf->getAliasNumPage() . '/' . $pdf->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
    //Close and output PDF document
    $pdf->Output('seratusskb.pdf', 'I');
  }

  public function dattarasset()
  {
    $model = new Master_model();
    $_SESSION['com_menu'] = '08';
    $_SESSION['com_men1'] = '0806';
    $_SESSION['com_men2'] = '';
    $data['tgl2'] = date('Y-m-d');

    return view('report/asset/daftarasset', $data);
  }

  public function printdaftarasset()
  {
    $_SESSION['com_menu'] = '08';
    $_SESSION['com_men1'] = '0804';
    $_SESSION['com_men2'] = '';
    $model = new Report_model();

    // $data['v_product']  = $modelm->_get_product1($id)->getResult();

    // $html = view('rpt/accounting/neraca.php');
    $pdf = new TCPDF('L', PDF_UNIT, 'A4', true, 'UTF-8', false);

    $pdf->SetCreator(PDF_CREATOR);
    $pdf->SetAuthor('GIT');
    $pdf->SetTitle('Laporan Daftar Inventaris');
    $pdf->SetSubject('Laporan Daftar Inventaris');

    $pdf->setPrintHeader(false);
    $pdf->setPrintFooter(false);

    $pdf->addPage();
    $image_file = 'assets/images/' . $_SESSION['com_logo'];


    /**
     * width : 50
     */
    $pdf->Image($image_file, '', '', 20);

    // Set font
    $pdf->SetFont('helvetica', 'B', 11);
    $pdf->SetX(40);
    $pdf->Cell(0, 2, $_SESSION['com_name'], 0, 1, '', 0, '', 0);

    $pdf->SetX(40);
    $pdf->SetFont('helvetica', '', 8);
    $pdf->Cell(0, 2, $_SESSION['com_adrs'], 0, 1, '', 0, '', 0);

    // $pdf->SetX(40);
    // Title

    // Footer
    // Position at 15 mm from bottom


    //

    $pdf->Ln();


    $pdf->Ln();
    $pdf->SetFont('helvetica', '', 9);
    $pdf->Cell(290, 7, 'DAFTAR INVENTARIS', 0, 1, 'C');
    // $pdf->Ln();
    // $pdf->Cell(190, 7, 'UNIT JASA ', 0, 1, 'C');
    // $pdf->Ln();

    // $pdf->Cell(190, 5, 'Tanggal : ' . date('d/m/Y', strtotime($tgl1)), 0, 1, 'C');

    $pdf->SetFont('helvetica', '', 8);


    $pdf->Ln();
    $pdf->Cell(10, 10, 'No. ', 1, 0, 'C');
    $pdf->Cell(30, 10, 'Kode ', 1, 0, 'C');
    $pdf->Cell(85, 10, 'Nama Inventaris', 1, 0, 'C');
    $pdf->Cell(14, 5, 'Umur ', 'LTR', 0, 'C');
    $pdf->Cell(17, 5, 'Tanggal', 'LTR', 0, 'C');
    $pdf->Cell(25, 5, 'Nilai', 'LTR', 0, 'C');
    $pdf->Cell(25, 5, 'Nilai', 'LTR', 0, 'C');
    $pdf->Cell(25, 5, 'Penyusutan', 'LTR', 0, 'C');
    $pdf->Cell(25, 5, 'Nilai Buku', 'LTR', 0, 'C');
    $pdf->Cell(23, 5, 'Tanggal Habis', 'LTR', 0, 'C');
    $pdf->Ln();

    $pdf->Cell(125, 5, ' ', 0, 0, 'C');
    // $pdf->Cell(65, 10, 'Nama Inventaris', 1, 0, 'C');
    $pdf->Cell(14, 5, 'Ekonomis ', 'LBR', 0, 'C');
    $pdf->Cell(17, 5, 'Perolehan', 'LBR', 0, 'C');
    $pdf->Cell(25, 5, 'Beli', 'LBR', 0, 'C');
    $pdf->Cell(25, 5, 'Penyusutan', 'LBR', 0, 'C');
    $pdf->Cell(25, 5, 'Per Bulan', 'LBR', 0, 'C');
    $pdf->Cell(25, 5, 'Nilai Buku', 'LBR', 0, 'C');
    $pdf->Cell(23, 5, 'Nilai Buku', 'LBR', 0, 'C');
    $pdf->Ln();
    $total = 0;
    $totndes = 0;
    $totakumulasi = 0;
    $totnbuku = 0;
    $dttype = $model->_get_gettypeasset();
    foreach ($dttype->getResult() as $rowtype) {
      $asttype = $rowtype->ast_type;
      $pdf->Cell(279, 7, $rowtype->ast_tnam, 1, 0, 'L');
      $pdf->Ln();

      $dttrans = $model->_get_dataasset($asttype);
      $baris = 0;
      $subtotal = 0;
      $subtotndes = 0;
      $subtotakumulasi = 0;
      $subtotnbuku = 0;
      $i = 0;

      foreach ($dttrans->getResult() as $row1) {
        $i = $i + 1;
        $baris = $baris + 1;
        $akumulasi = $row1->ast_nila / ($row1->ast_lvyr * 12);
        $nilaibuku = $row1->ast_nila - $row1->ast_ndes;
        $total = $total + $row1->ast_nila;
        $totndes = $totndes + $row1->ast_ndes;
        $totakumulasi = $totakumulasi + $akumulasi;
        $totnbuku = $totnbuku + $nilaibuku;


        $subtotal = $subtotal + $row1->ast_nila;
        $subtotndes = $subtotndes + $row1->ast_ndes;
        $subtotakumulasi = $subtotakumulasi + $akumulasi;
        $subtotnbuku = $subtotnbuku + $nilaibuku;
        $pdf->Cell(10, 7, $i, 'L', 0, 'R');
        $pdf->Cell(30, 7, $row1->ast_code, 'L', 0, 'L');
        $pdf->Cell(85, 7, $row1->ast_name, 'L', 0, 'L');
        $pdf->Cell(13, 7, $row1->ast_lvyr, 0, 0, 'C');
        $pdf->Cell(17, 7, date('d/m/Y', strtotime($row1->ast_tgbeli)), 0, 0, 'C');
        $pdf->Cell(25, 7, number_format($row1->ast_nila), 0, 0, 'R');
        $pdf->Cell(25, 7, number_format($row1->ast_ndes), 0, 0, 'R');
        $pdf->Cell(25, 7, number_format($akumulasi), 0, 0, 'R');
        $pdf->Cell(25, 7, number_format($nilaibuku), 0, 0, 'R');
        $pdf->Cell(24, 7, date('d/m/Y', strtotime($row1->ast_endt)), 'R', 0, 'C');
        $pdf->Ln();
      }

      $pdf->Cell(156, 10, 'SUB TOTAL', '1', 0, 'C');

      $pdf->Cell(25, 10, number_format($subtotal), '1', 0, 'R');
      $pdf->Cell(25, 10, number_format($subtotndes), '1', 0, 'R');
      $pdf->Cell(25, 10, number_format($subtotakumulasi), '1', 0, 'R');
      $pdf->Cell(25, 10, number_format($subtotnbuku), '1', 0, 'R');
      $pdf->Cell(23, 10, '', '1', 0, 'R');
      $pdf->Ln();
    }
    // $pdf->Ln();
    $pdf->Cell(156, 10, 'TOTAL', '1', 0, 'C');

    $pdf->Cell(25, 10, number_format($total), '1', 0, 'R');
    $pdf->Cell(25, 10, number_format($totndes), '1', 0, 'R');
    $pdf->Cell(25, 10, number_format($totakumulasi), '1', 0, 'R');
    $pdf->Cell(25, 10, number_format($totnbuku), '1', 0, 'R');
    $pdf->Cell(23, 10, '', '1', 0, 'R');
    // $pdf->Ln();

    // output the HTML content


    // $pdf->writeHTML($html, true, false, true, false, '');
    //line ini penting

    $this->response->setContentType('application/pdf');

    $pdf->SetY(-24);
    // Set font
    $pdf->SetFont('helvetica', 'I', 8);
    // Page number
    $pdf->Cell(0, 2, 'Page ' . $pdf->getAliasNumPage() . '/' . $pdf->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
    //Close and output PDF document
    $pdf->Output('daftarasset.pdf', 'I');
  }

  public function penyusutan()
  {
    $model = new Master_model();
    $_SESSION['com_menu'] = '08';
    $_SESSION['com_men1'] = '0806';
    $_SESSION['com_men2'] = '';
    $data['v_tahun']  = $model->_get_tahun()->getResult();
    return view('report/asset/akumulasi', $data);
  }

  public function printakumulasi()
  {
    $model = new Report_model();
    $_SESSION['com_menu'] = '08';
    $_SESSION['com_men1'] = '0804';
    $_SESSION['com_men2'] = '';
    $bulan = $this->request->getPost('kin_buln');
    $tahun = $this->request->getPost('kin_tahn');
    if ($bulan == 1) {
      $nbulan = 'JANUARI';
    } else  if ($bulan == 2) {
      $nbulan = 'FEBRUARI';
    } else  if ($bulan == 3) {
      $nbulan = 'MARET';
    } else  if ($bulan == 4) {
      $nbulan = 'APRIL';
    } else  if ($bulan == 5) {
      $nbulan = 'MEI';
    } else  if ($bulan == 6) {
      $nbulan = 'JUNI';
    } else  if ($bulan == 7) {
      $nbulan = 'JULI';
    } else  if ($bulan == 8) {
      $nbulan = 'AGUSTUS';
    } else  if ($bulan == 9) {
      $nbulan = 'SEPETEMBER';
    } else  if ($bulan == 10) {
      $nbulan = 'OKTOBER';
    } else  if ($bulan == 11) {
      $nbulan = 'NOVEMBER';
    } else  if ($bulan == 12) {
      $nbulan = 'DESEMBER';
    }
    // $data['v_product']  = $modelm->_get_product1($id)->getResult();

    // $html = view('rpt/accounting/neraca.php');
    $pdf = new TCPDF('L', PDF_UNIT, 'A4', true, 'UTF-8', false);

    $pdf->SetCreator(PDF_CREATOR);
    $pdf->SetAuthor('GIT');
    $pdf->SetTitle('Laporan Akumulasi Penyusutan');
    $pdf->SetSubject('Laporan Akumulasi Penyusutan');

    $pdf->setPrintHeader(false);
    $pdf->setPrintFooter(false);

    $pdf->addPage();
    $image_file = 'assets/images/' . $_SESSION['com_logo'];


    /**
     * width : 50
     */
    $pdf->Image($image_file, '', '', 20);

    // Set font
    $pdf->SetFont('helvetica', 'B', 11);
    $pdf->SetX(40);
    $pdf->Cell(0, 2, $_SESSION['com_name'], 0, 1, '', 0, '', 0);

    $pdf->SetX(40);
    $pdf->SetFont('helvetica', '', 8);
    $pdf->Cell(0, 2, $_SESSION['com_adrs'], 0, 1, '', 0, '', 0);

    // $pdf->SetX(40);
    // Title

    // Footer
    // Position at 15 mm from bottom


    //

    $pdf->Ln();


    $pdf->Ln();
    $pdf->SetFont('helvetica', '', 9);
    $pdf->Cell(190, 7, 'DAFTAR AKUMULASI PENYUSUTAN INVENTARIS', 0, 1, 'C');
    // $pdf->Ln();
    $pdf->Cell(190, 7, 'BULAN : ' . $nbulan . ' TAHUN : ' . $tahun, 0, 1, 'C');
    // $pdf->Ln();

    // $pdf->Cell(190, 5, 'Tanggal : ' . date('d/m/Y', strtotime($tgl1)), 0, 1, 'C');

    $pdf->SetFont('helvetica', '', 8);


    $pdf->Ln();
    $pdf->Cell(10, 10, 'No. ', 1, 0, 'C');
    $pdf->Cell(30, 10, 'Kode ', 1, 0, 'C');
    $pdf->Cell(120, 10, 'Nama Inventaris', 1, 0, 'C');
    $pdf->Cell(14, 5, 'Umur ', 'LTR', 0, 'C');
    $pdf->Cell(17, 5, 'Tanggal', 'LTR', 0, 'C');
    $pdf->Cell(25, 5, 'Methode', 'LTR', 0, 'C');
    $pdf->Cell(25, 5, 'Harga', 'LTR', 0, 'C');
    $pdf->Cell(24, 5, 'Nilai', 'LTR', 0, 'C');

    $pdf->Ln();

    $pdf->Cell(160, 5, ' ', 0, 0, 'C');
    // $pdf->Cell(65, 10, 'Nama Inventaris', 1, 0, 'C');
    $pdf->Cell(14, 5, 'Ekonomis ', 'LBR', 0, 'C');
    $pdf->Cell(17, 5, 'Posting', 'LBR', 0, 'C');
    $pdf->Cell(25, 5, 'Penyusutan', 'LBR', 0, 'C');
    $pdf->Cell(25, 5, 'Perolehan', 'LBR', 0, 'C');
    $pdf->Cell(24, 5, 'Penyusutan', 'LBR', 0, 'C');

    $pdf->Ln();
    $i = 0;


    $baris = 0;
    $total = 0;
    $totakumulasi = 0;
    $dttype = $model->_get_gettypeasset1();
    foreach ($dttype->getResult() as $rowtype) {
      $asttype = $rowtype->ast_type;

      $pdf->Cell(265, 7, $rowtype->ast_tnam, 1, 0, 'L');
      $pdf->Ln();
      $dttrans = $model->_get_akumdataasset($asttype, $bulan, $tahun);
      $subtotal = 0;

      $subtotakumulasi = 0;
      $i = 0;
      foreach ($dttrans->getResult() as $row1) {
        $i = $i + 1;
        $baris = $baris + 1;
        $total = $total + $row1->ast_nila;
        $totakumulasi = $totakumulasi + $row1->akm_amnt;
        $subtotal = $subtotal + $row1->ast_nila;
        $subtotakumulasi = $subtotakumulasi + $row1->akm_amnt;
        $pdf->Cell(10, 7, $i, 'L', 0, 'R');
        $pdf->Cell(30, 7, $row1->ast_code, 'L', 0, 'L');
        $pdf->Cell(120, 7, $row1->ast_name, 'L', 0, 'L');
        $pdf->Cell(14, 7, $row1->ast_lvyr, 0, 0, 'C');
        $pdf->Cell(17, 7, date('d/m/Y', strtotime($row1->akm_date)), 0, 0, 'C');
        $pdf->Cell(25, 7, $row1->ast_nmet, 0, 0, 'L');
        $pdf->Cell(25, 7, number_format($row1->ast_nila), 0, 0, 'R');
        $pdf->Cell(24, 7, number_format($row1->akm_amnt), 'R', 0, 'R');

        $pdf->Ln();
      }


      $pdf->Cell(216, 10, 'SUB TOTAL', '1', 0, 'C');

      $pdf->Cell(25, 10, number_format($subtotal), '1', 0, 'R');
      $pdf->Cell(24, 10, number_format($subtotakumulasi), '1', 0, 'R');
      $pdf->Ln();
    }

    $pdf->Cell(216, 10, 'TOTAL', '1', 0, 'C');

    $pdf->Cell(25, 10, number_format($total), '1', 0, 'R');
    $pdf->Cell(24, 10, number_format($totakumulasi), '1', 0, 'R');

    // $pdf->Ln();

    // output the HTML content


    // $pdf->writeHTML($html, true, false, true, false, '');
    //line ini penting

    $this->response->setContentType('application/pdf');

    $pdf->SetY(-24);
    // Set font
    $pdf->SetFont('helvetica', 'I', 8);
    // Page number
    $pdf->Cell(0, 2, 'Page ' . $pdf->getAliasNumPage() . '/' . $pdf->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
    //Close and output PDF document
    $pdf->Output('akumulasi.pdf', 'I');
  }

  public function rekappenyusutan()
  {
    $model = new Master_model();
    $_SESSION['com_menu'] = '08';
    $_SESSION['com_men1'] = '0806';
    $_SESSION['com_men2'] = '';
    $data['v_tahun']  = $model->_get_tahun()->getResult();
    return view('report/asset/rekapakumulasi', $data);
  }

  public function printrekapakumulasi()
  {
    $model = new Report_model();
    $_SESSION['com_menu'] = '08';
    $_SESSION['com_men1'] = '0804';
    $_SESSION['com_men2'] = '';
    $bulan = $this->request->getPost('kin_buln');
    $tahun = $this->request->getPost('kin_tahn');
    if ($bulan == 1) {
      $nbulan = 'JANUARI';
    } else  if ($bulan == 2) {
      $nbulan = 'FEBRUARI';
    } else  if ($bulan == 3) {
      $nbulan = 'MARET';
    } else  if ($bulan == 4) {
      $nbulan = 'APRIL';
    } else  if ($bulan == 5) {
      $nbulan = 'MEI';
    } else  if ($bulan == 6) {
      $nbulan = 'JUNI';
    } else  if ($bulan == 7) {
      $nbulan = 'JULI';
    } else  if ($bulan == 8) {
      $nbulan = 'AGUSTUS';
    } else  if ($bulan == 9) {
      $nbulan = 'SEPETEMBER';
    } else  if ($bulan == 10) {
      $nbulan = 'OKTOBER';
    } else  if ($bulan == 11) {
      $nbulan = 'NOVEMBER';
    } else  if ($bulan == 12) {
      $nbulan = 'DESEMBER';
    }
    // $data['v_product']  = $modelm->_get_product1($id)->getResult();

    // $html = view('rpt/accounting/neraca.php');
    $pdf = new TCPDF('P', PDF_UNIT, 'A4', true, 'UTF-8', false);

    $pdf->SetCreator(PDF_CREATOR);
    $pdf->SetAuthor('GIT');
    $pdf->SetTitle('Rekap Penyusutan');
    $pdf->SetSubject('Rekap Penyusutan');

    $pdf->setPrintHeader(false);
    $pdf->setPrintFooter(false);

    $pdf->addPage();
    $image_file = 'assets/images/' . $_SESSION['com_logo'];


    /**
     * width : 50
     */
    $pdf->Image($image_file, '', '', 20);

    // Set font
    $pdf->SetFont('helvetica', 'B', 11);
    $pdf->SetX(40);
    $pdf->Cell(0, 2, $_SESSION['com_name'], 0, 1, '', 0, '', 0);

    $pdf->SetX(40);
    $pdf->SetFont('helvetica', '', 8);
    $pdf->Cell(0, 2, $_SESSION['com_adrs'], 0, 1, '', 0, '', 0);

    // $pdf->SetX(40);
    // Title

    // Footer
    // Position at 15 mm from bottom


    //

    $pdf->Ln();


    $pdf->Ln();
    $pdf->SetFont('helvetica', '', 9);
    $pdf->Cell(190, 7, 'REKAP AKUMULASI PENYUSUTAN INVENTARIS', 0, 1, 'C');
    // $pdf->Ln();
    $pdf->Cell(190, 7, 'BULAN : ' . $nbulan . ' TAHUN : ' . $tahun, 0, 1, 'C');
    // $pdf->Ln();

    // $pdf->Cell(190, 5, 'Tanggal : ' . date('d/m/Y', strtotime($tgl1)), 0, 1, 'C');

    $pdf->SetFont('helvetica', '', 8);


    $pdf->Ln();
    $pdf->Cell(10, 10, 'No. ', 1, 0, 'C');
    $pdf->Cell(150, 10, 'Jenis Asset', 1, 0, 'C');
    $pdf->Cell(30, 5, 'Nilai', 'LTR', 0, 'C');

    $pdf->Ln();

    $pdf->Cell(160, 5, ' ', 0, 0, 'C');
    $pdf->Cell(30, 5, 'Penyusutan', 'LBR', 0, 'C');

    $pdf->Ln();
    $i = 0;

    $dttrans = $model->_get_sumakumdataasset($bulan, $tahun);
    $baris = 0;
    $totakumulasi = 0;
    foreach ($dttrans->getResult() as $row1) {
      $i = $i + 1;
      $baris = $baris + 1;

      $nilaibuku = $row1->ast_nila - $row1->ast_ndes;
      $totakumulasi = $totakumulasi + $row1->akm_amnt;

      $pdf->Cell(10, 7, $i, 'L', 0, 'R');
      $pdf->Cell(150, 7, $row1->ast_tnam, 'L', 0, 'L');
      $pdf->Cell(30, 7, number_format($row1->akm_amnt), 'R', 0, 'R');

      $pdf->Ln();
    }

    $pdf->Cell(160, 10, 'TOTAL', '1', 0, 'C');


    $pdf->Cell(30, 10, number_format($totakumulasi), '1', 0, 'R');


    // $pdf->Ln();

    // output the HTML content


    // $pdf->writeHTML($html, true, false, true, false, '');
    //line ini penting

    $this->response->setContentType('application/pdf');

    $pdf->SetY(-24);
    // Set font
    $pdf->SetFont('helvetica', 'I', 8);
    // Page number
    $pdf->Cell(0, 2, 'Page ' . $pdf->getAliasNumPage() . '/' . $pdf->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
    //Close and output PDF document
    $pdf->Output('rekapakumlasi.pdf', 'I');
  }

  public function dataagunan()
  {
    $model = new Model_git();
    $_SESSION['com_menu'] = '08';
    $_SESSION['com_men1'] = '0804';
    $_SESSION['com_men2'] = '';
    $data['v_kontrak']  = $model->_get_gkontrak()->getResult();
    return view('report/pembiayaan/daftaragunan', $data);
  }

  public function pinjamanbaru()
  {
    $model = new Model_git();
    $mmaster = new Master_model();
    $_SESSION['com_menu'] = '08';
    $_SESSION['com_men1'] = '0804';
    $_SESSION['com_men2'] = '';
    $tahun = date('Y');
    $bulan = date('m');
    $hari_ini = $tahun . '-' . $bulan . '-01'; // date("Y-m-d");
    $data['tgl1'] = $hari_ini;
    $data['tgl2'] = date("Y-m-d");
    $data['v_cabang']  = $mmaster->_get_cabang()->getResult();
    $data['v_kontrak']  = $model->_get_gkontrak()->getResult();
    return view('report/pembiayaan/pembiayaanbaru', $data);
  }

  public function reppinjamanbaru()
  {
    $model = new Report_model();
    $_SESSION['com_menu'] = '08';
    $_SESSION['com_men1'] = '0804';
    $_SESSION['com_men2'] = '';
    $kodecabang = $this->request->getPost('cab_code');
    $tgl1 = $this->request->getPost('trx_date');
    $tgl2 = $this->request->getPost('trx_dat1');

    // $data['v_product']  = $modelm->_get_product1($id)->getResult();

    // $html = view('rpt/accounting/neraca.php');
    $pdf = new TCPDF('L', PDF_UNIT, 'A4', true, 'UTF-8', false);

    $pdf->SetCreator(PDF_CREATOR);
    $pdf->SetAuthor('GIT');
    $pdf->SetTitle('Laporan Pinjaman Baru');
    $pdf->SetSubject('Laporan Pinjaman Baru');

    $pdf->setPrintHeader(false);
    $pdf->setPrintFooter(false);

    $pdf->addPage();
    $image_file = 'assets/images/' . $_SESSION['com_logo'];


    /**
     * width : 50
     */
    $pdf->Image($image_file, '', '', 20);

    // Set font
    $pdf->SetFont('helvetica', 'B', 11);
    $pdf->SetX(40);
    $pdf->Cell(0, 2, $_SESSION['com_name'], 0, 1, '', 0, '', 0);

    $pdf->SetX(40);
    $pdf->SetFont('helvetica', '', 8);
    $pdf->Cell(0, 2, $_SESSION['com_adrs'], 0, 1, '', 0, '', 0);

    // $pdf->SetX(40);
    // Title

    // Footer
    // Position at 15 mm from bottom


    //

    $pdf->Ln();


    $pdf->Ln();
    $pdf->SetFont('helvetica', '', 9);
    $pdf->Cell(280, 7, 'DAFTAR PINJAMAN BARU', 0, 1, 'C');
    // $pdf->Ln();
    //$pdf->Cell(190, 7, 'BULAN : ' . $nbulan . ' TAHUN : ' . $tahun, 0, 1, 'C');
    // $pdf->Ln();

    $pdf->Cell(280, 5, 'Dari Tanggal : ' . date('d/m/Y', strtotime($tgl1)) . ' s/d ' . date('d/m/Y', strtotime($tgl2)), 0, 1, 'C');

    $pdf->SetFont('helvetica', '', 8);


    $pdf->Ln();
    $pdf->Cell(10, 10, 'No. ', 1, 0, 'C');
    $pdf->Cell(25, 10, 'No. Rekening', 1, 0, 'C');
    $pdf->Cell(60, 10, 'Nama ', 1, 0, 'C');
    $pdf->Cell(70, 10, 'Jenis Pinjaman', 1, 0, 'C');
    $pdf->Cell(20, 10, 'Jangka Waktu', 1, 0, 'C');
    $pdf->Cell(20, 10, 'Jatuh Tempo', 1, 0, 'C');
    $pdf->Cell(40, 10, 'Jenis Angsuran', 1, 0, 'C');
    $pdf->Cell(30, 10, 'Nilai Pinjaman', 1, 0, 'C');
    $pdf->Ln();

    // $pdf->Cell(160, 5, ' ', 0, 0, 'C');
    // $pdf->Cell(30, 5, 'Penyusutan', 'LBR', 0, 'C');

    // $pdf->Ln();
    // $kodecabang = session()->get('kode_cabang');
    if ($kodecabang != '') {
      $dttrans = $model->_get_pinjamanbaru($tgl1, $tgl2, $kodecabang);
    } else {
      $dttrans = $model->_get_pinjamanbarua($tgl1, $tgl2);
    }



    $baris = 0;
    $totpinjaman = 0;

    $i = 0;
    foreach ($dttrans->getResult() as $row1) {
      $i = $i + 1;
      $baris = $baris + 1;

      if ($row1->knt_jang == '1') {
        $jenisangsuran = 'Harian';
      } else  if ($row1->knt_jang == '2') {
        $jenisangsuran = 'Mingguan';
      } else  if ($row1->knt_jang == '3') {
        $jenisangsuran = '2 Mingguan';
      } else  if ($row1->knt_jang == '4') {
        $jenisangsuran = 'Bulanan';
      } else  if ($row1->knt_jang == '5') {
        $jenisangsuran = 'Tahunan atau Akhir Periode';
      } else  if ($row1->knt_jang == '6') {
        $jenisangsuran = 'Kolektibilitas';
      } else {
        $jenisangsuran = '';
      }

      $totpinjaman = $totpinjaman + $row1->knt_totl;

      $pdf->Cell(10, 7, $i, 1, 0);
      $pdf->Cell(25, 7, $row1->knt_code, 1, 0);
      $pdf->Cell(60, 7, $row1->agt_name, 1, 0, 'L');
      $pdf->Cell(70, 7, $row1->prd_name, 1,  0, 'L');
      $pdf->Cell(20, 7, $row1->knt_tenr, 1, 0, 'C');
      $pdf->Cell(20, 7, date('d/m/Y', strtotime($row1->knt_jtdt)), 1, 0, 'C');
      $pdf->Cell(40, 7, $jenisangsuran, 1, 0, 'L');


      $pdf->Cell(30, 7, number_format($row1->knt_totl), 'R', 0, 'R');


      $pdf->Ln();
    }

    $pdf->Cell(245, 10, 'TOTAL', '1', 0, 'C');

    $pdf->Cell(30, 10, number_format($totpinjaman), '1', 0, 'R');



    // $pdf->Ln();

    // output the HTML content


    // $pdf->writeHTML($html, true, false, true, false, '');
    //line ini penting

    $this->response->setContentType('application/pdf');

    $pdf->SetY(-24);
    // Set font
    $pdf->SetFont('helvetica', 'I', 8);
    // Page number
    $pdf->Cell(0, 2, 'Page ' . $pdf->getAliasNumPage() . '/' . $pdf->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
    //Close and output PDF document
    $pdf->Output('pinjamanbaru.pdf', 'I');
  }
  public function printagunan()
  {
    $model = new Report_model();
    $_SESSION['com_menu'] = '08';
    $_SESSION['com_men1'] = '0804';
    $_SESSION['com_men2'] = '';
    $norekening = $this->request->getPost('kin_type');

    // $data['v_product']  = $modelm->_get_product1($id)->getResult();

    // $html = view('rpt/accounting/neraca.php');
    $pdf = new TCPDF('L', PDF_UNIT, 'A4', true, 'UTF-8', false);

    $pdf->SetCreator(PDF_CREATOR);
    $pdf->SetAuthor('GIT');
    $pdf->SetTitle('Laporan Daftar Agunan');
    $pdf->SetSubject('Laporan Daftar Agunan');

    $pdf->setPrintHeader(false);
    $pdf->setPrintFooter(false);

    $pdf->addPage();
    $image_file = 'assets/images/' . $_SESSION['com_logo'];


    /**
     * width : 50
     */
    $pdf->Image($image_file, '', '', 20);

    // Set font
    $pdf->SetFont('helvetica', 'B', 11);
    $pdf->SetX(40);
    $pdf->Cell(0, 2, $_SESSION['com_name'], 0, 1, '', 0, '', 0);

    $pdf->SetX(40);
    $pdf->SetFont('helvetica', '', 8);
    $pdf->Cell(0, 2, $_SESSION['com_adrs'], 0, 1, '', 0, '', 0);

    // $pdf->SetX(40);
    // Title

    // Footer
    // Position at 15 mm from bottom


    //

    $pdf->Ln();


    $pdf->Ln();
    $pdf->SetFont('helvetica', '', 9);
    $pdf->Cell(280, 7, 'DAFTAR AGUNAN', 0, 1, 'C');
    // $pdf->Ln();
    //$pdf->Cell(190, 7, 'BULAN : ' . $nbulan . ' TAHUN : ' . $tahun, 0, 1, 'C');
    // $pdf->Ln();

    // $pdf->Cell(190, 5, 'Tanggal : ' . date('d/m/Y', strtotime($tgl1)), 0, 1, 'C');

    $pdf->SetFont('helvetica', '', 8);


    $pdf->Ln();
    $pdf->Cell(10, 10, 'No. ', 1, 0, 'C');
    $pdf->Cell(30, 10, 'Jenis Jaminan', 1, 0, 'C');
    $pdf->Cell(20, 10, 'No. Agunan', 1, 0, 'C');
    $pdf->Cell(40, 10, 'Nama Pemilik', 1, 0, 'C');
    $pdf->Cell(40, 10, 'Nama Nasabah', 1, 0, 'C');
    $pdf->Cell(20, 10, 'Jatuh Tempo', 1, 0, 'C');
    $pdf->Cell(30, 10, 'Lokasi', 1, 0, 'C');
    $pdf->Cell(30, 10, 'Jenis Agunan', 1, 0, 'C');
    $pdf->Cell(30, 10, 'Nilai Pinjaman', 1, 0, 'C');
    $pdf->Cell(30, 10, 'Nilai Agunan', 1, 0, 'C');
    $pdf->Ln();

    // $pdf->Cell(160, 5, ' ', 0, 0, 'C');
    // $pdf->Cell(30, 5, 'Penyusutan', 'LBR', 0, 'C');

    // $pdf->Ln();
    $i = 0;
    if ($norekening == '') {
      $dttrans = $model->_get_daftaragunan();
    } else {
      $dttrans = $model->_get_daftaragunanrek($norekening);
    }


    $baris = 0;
    $totpinjaman = 0;
    $totagunan = 0;
    foreach ($dttrans->getResult() as $row1) {
      $i = $i + 1;
      $baris = $baris + 1;

      $totpinjaman = $totpinjaman + $row1->knt_totl;
      $totagunan = $totagunan + $row1->agn_totl;
      $pdf->Cell(10, 7, $i, 1, 0, 'C');
      $pdf->Cell(30, 7, $row1->jns_name, 1, 0, 'L');
      $pdf->Cell(20, 7, $row1->agn_numb, 1, 0, 'L');
      $pdf->Cell(40, 7, $row1->agn_name, 1, 0, 'L');
      $pdf->Cell(40, 7, $row1->agt_name, 1, 'L');
      $pdf->Cell(20, 7, date('d/m/Y', strtotime($row1->agn_jtdt)), 1, 0, 'C');
      $pdf->Cell(30, 7, $row1->agn_loks, 1, 0, 'C');
      $pdf->Cell(30, 7, $row1->agn_jens, 1, 0, 'C');
      $pdf->Cell(30, 7, number_format($row1->knt_totl), 'R', 0, 'R');
      $pdf->Cell(30, 7, number_format($row1->agn_totl), 'R', 0, 'R');

      $pdf->Ln();
    }

    $pdf->Cell(220, 10, 'TOTAL', '1', 0, 'C');

    $pdf->Cell(30, 10, number_format($totpinjaman), '1', 0, 'R');
    $pdf->Cell(30, 10, number_format($totagunan), '1', 0, 'R');


    // $pdf->Ln();

    // output the HTML content


    // $pdf->writeHTML($html, true, false, true, false, '');
    //line ini penting

    $this->response->setContentType('application/pdf');

    $pdf->SetY(-24);
    // Set font
    $pdf->SetFont('helvetica', 'I', 8);
    // Page number
    $pdf->Cell(0, 2, 'Page ' . $pdf->getAliasNumPage() . '/' . $pdf->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
    //Close and output PDF document
    $pdf->Output('datagunanpinjaman.pdf', 'I');
  }

  public function jatuhtemposkb()
  {
    $model = new Master_model();
    $_SESSION['com_menu'] = '08';
    $_SESSION['com_men1'] = '0803';
    $_SESSION['com_men2'] = '';
    $tahun = date('Y');
    $bulan = date('m');
    $hari_ini = $tahun . '-' . $bulan . '-01'; // date("Y-m-d");
    $data['tgl1'] = $hari_ini;
    $data['tgl2'] = date("Y-m-d");
    $data['v_cabang']  = $model->_get_cabang()->getResult();
    return view('report/ssb/skbjatuhtempo', $data);
  }

  public function printskbjatuhtempo()
  {
    $model = new Report_model();
    $_SESSION['com_menu'] = '08';
    $_SESSION['com_men1'] = '0804';
    $_SESSION['com_men2'] = '';
    $tanggal1 = $this->request->getPost('trx_date');
    $tanggal2 = $this->request->getPost('trx_dat1');
    $cabang = $this->request->getPost('cab_code');
    // $data['v_product']  = $modelm->_get_product1($id)->getResult();

    // $html = view('rpt/accounting/neraca.php');
    $pdf = new TCPDF('L', PDF_UNIT, 'A4', true, 'UTF-8', false);

    $pdf->SetCreator(PDF_CREATOR);
    $pdf->SetAuthor('GIT');
    $pdf->SetTitle('Rekap Penyusutan');
    $pdf->SetSubject('Rekap Penyusutan');

    $pdf->setPrintHeader(false);
    $pdf->setPrintFooter(false);

    $pdf->addPage();
    $image_file = 'assets/images/' . $_SESSION['com_logo'];


    /**
     * width : 50
     */
    $pdf->Image($image_file, '', '', 20);

    // Set font
    $pdf->SetFont('helvetica', 'B', 11);
    $pdf->SetX(40);
    $pdf->Cell(0, 2, $_SESSION['com_name'], 0, 1, '', 0, '', 0);

    $pdf->SetX(40);
    $pdf->SetFont('helvetica', '', 8);
    $pdf->Cell(0, 2, $_SESSION['com_adrs'], 0, 1, '', 0, '', 0);

    // $pdf->SetX(40);
    // Title

    // Footer
    // Position at 15 mm from bottom


    //

    $pdf->Ln();


    $pdf->Ln();
    $pdf->SetFont('helvetica', '', 9);
    $pdf->Cell(280, 7, 'DAFTAR SKB JATUH TEMPO', 0, 1, 'C');
    // $pdf->Ln();
    $pdf->Cell(290, 7, 'DARI TANGGAL JATUH TEMPO : ' . date('d/m/Y', strtotime($tanggal1)) . ' SD : ' . date('d/m/Y', strtotime($tanggal2)), 0, 1, 'C');
    // $pdf->Ln();

    // $pdf->Cell(190, 5, 'Tanggal : ' . date('d/m/Y', strtotime($tgl1)), 0, 1, 'C');

    $pdf->SetFont('helvetica', '', 8);


    $pdf->Ln();
    $pdf->Cell(8, 10, 'No. ', 1, 0, 'C');
    $pdf->Cell(25, 10, 'No Rekening', 1, 0, 'C');
    $pdf->Cell(47, 10, 'Nama Anggota', 'LTB', 0, 'C');
    $pdf->Cell(55, 10, 'Jenis Simpanan', 'LTB', 0, 'C');
    $pdf->Cell(20, 5, 'Tanggal  ', 'LTR', 0, 'C');
    $pdf->Cell(20, 5, 'Tanggal ', 'LTR', 0, 'C');
    $pdf->Cell(30, 10, 'Nilai ', 'LTB', 0, 'C');
    $pdf->Cell(20, 10, 'Jasa', 'LTB', 0, 'C');
    $pdf->Cell(20, 10, 'PPh', 'LTB', 0, 'C');
    $pdf->Cell(30, 5, 'Nilai', 'LTR', 0, 'C');

    $pdf->Ln();

    $pdf->Cell(135, 5, ' ', 0, 0, 'C');
    $pdf->Cell(20, 5, 'Penempatan', 'LBR', 0, 'C');
    $pdf->Cell(20, 5, 'Jatuh Tempo', 'LBR', 0, 'C');
    $pdf->Cell(70, 5, '', 0, 0, 'C');
    $pdf->Cell(30, 5, 'Akhir', 'LBR', 0, 'C');
    $pdf->Ln();

    if ($cabang != '') {
      $dttrans = $model->_get_ssbjatuhtempocab($tanggal1, $tanggal2, $cabang);
    } else {
      $dttrans = $model->_get_ssbjatuhtempo($tanggal1, $tanggal2);
    }

    $baris = 0;
    $total = 0;
    $totbunga = 0;
    $totpph = 0;
    $totjumlah = 0;

    $i = 0;
    foreach ($dttrans->getResult() as $row1) {
      $i = $i + 1;
      $baris = $baris + 1;


      $total = $total + $row1->pen_totl;
      $jumlah = $row1->pen_totl + $row1->pen_tmar - $row1->pen_npph;
      $totbunga = $totbunga + $row1->pen_tmar;
      $totpph = $totpph + $row1->pen_npph;
      $totjumlah = $totjumlah + $jumlah;
      $pdf->Cell(8, 7, $i, 'L', 0, 'R');
      $pdf->Cell(25, 7, $row1->pen_code, 'L', 0, 'L');
      $pdf->Cell(47, 7, $row1->agt_name, 'L', 0, 'L');
      $pdf->Cell(55, 7, $row1->prd_name, 'L', 0, 'L');
      $pdf->Cell(20, 7, date('d/m/Y', strtotime($row1->pen_date)), 'L', 0, 'C');
      $pdf->Cell(20, 7, date('d/m/Y', strtotime($row1->pen_jtdt)), 'L', 0, 'C');
      $pdf->Cell(30, 7, number_format($row1->pen_totl), 'L', 0, 'R');
      $pdf->Cell(20, 7, number_format($row1->pen_tmar), 'L', 0, 'R');
      $pdf->Cell(20, 7, number_format($row1->pen_npph), 'L', 0, 'R');
      $pdf->Cell(30, 7, number_format($jumlah), 'LR', 0, 'R');

      $pdf->Ln();
    }

    // $pdf->Ln();

    $pdf->Cell(175, 10, 'TOTAL', '1', 0, 'C');


    $pdf->Cell(30, 10, number_format($total), '1', 0, 'R');
    $pdf->Cell(20, 10, number_format($totbunga), '1', 0, 'R');
    $pdf->Cell(20, 10, number_format($totpph), '1', 0, 'R');
    $pdf->Cell(30, 10, number_format($totjumlah), '1', 0, 'R');


    // $pdf->Ln();

    // output the HTML content


    // $pdf->writeHTML($html, true, false, true, false, '');
    //line ini penting

    $this->response->setContentType('application/pdf');

    $pdf->SetY(-24);
    // Set font
    $pdf->SetFont('helvetica', 'I', 8);
    // Page number
    $pdf->Cell(0, 2, 'Page ' . $pdf->getAliasNumPage() . '/' . $pdf->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
    //Close and output PDF document
    $pdf->Output('daftarssbjatuhtempo.pdf', 'I');
  }

  public function Pembiayaantahun()
  {
    $model = new Dashboard_model();
    $modsave = new Save_model();
    $jns = 'K';
    $data = array(
      'com_code'  => session()->get('com_code'),
      'kode_cabang'  => session()->get('kode_cabang'),
      'trx_jens' => 'K',
      'grp_mont' => 1,
      'grp_year' => 2024,
      'grp_juml' => 0,
      'grp_nila' => 0,
    );
    $modsave->_savegraph($data);
    $id = 2024;
    $data = $model->_dbgraphtahun($id, $jns)->getResult();
    echo json_encode($data);
  }

  public function get_pinjamantahun()
  {
    $model = new Dashboard_model();
    $modsave = new Save_model();
    $master = new Master_model();
    $id = 2024;
    $jns = 'K';
    $dttunggakan = $master->_get_bulan();
    foreach ($dttunggakan->getResult() as $row1) {
      $blncode = ($row1->bln_code);
      $data = array(
        'com_code'  => session()->get('com_code'),
        'kode_cabang'  => session()->get('kode_cabang'),
        'trx_jens' => 'K',
        'grp_mont' => $blncode,
        'grp_year' => 2024,
        'grp_juml' => 0,
        'grp_nila' => 0,
      );
      $modsave->_savegraph($data);
    }





    $data = $model->_dbgraphtahun($id, $jns)->getResult();

    echo json_encode($data);
  }
  //---------------------------
}
