<?php

namespace App\Controllers;

use App\Models\Auto_model;
use App\Models\Master_model;
use App\Models\Model_git;
use App\Models\Save_model;
use App\Models\Delete_model;

class Simpanan extends BaseController
{
  public function __construct()
  {
    $session = session();
    date_default_timezone_set('Asia/Jakarta');
  }
  public function index()
  {
    $_SESSION['com_menu'] = '';
    $_SESSION['com_men1'] = '';
    $_SESSION['com_men2'] = '';
  }
  public function simulasi()
  {
    $model = new Master_model();
    $_SESSION['com_menu'] = '02';
    $_SESSION['com_men1'] = '0202';
    $id1 = 'D';
    $data['v_product']  = $model->_get_productb($id1)->getResult();

    //  $data['v_jangkawaktu']  = $model->_get_periode()->getResult();
    return view('simpanan/simulasi', $data);
  }


  public function penempatan()
  {
    $model = new Model_git();
    $_SESSION['com_menu'] = '04';
    $_SESSION['com_men1'] = '0402';
    $_SESSION['com_men2'] = '';
    $tanggal = date('Y-m-d');
    $cabang = session()->get('kode_cabang');
    $data['v_penempatan']  = $model->_get_penempatan($tanggal, $cabang)->getResult();

    return view('simpanan/penempatan/penempatan_list', $data);
  }

  public function adpenempatan()
  {
    $model = new Master_model();
    $model1 = new Model_git();
    $_SESSION['com_menu'] = '04';
    $_SESSION['com_men1'] = '0402';
    $_SESSION['com_men2'] = '';
    $id1 = 'D';
    $tanggal = date('Y-m-d');
    $data['hariini'] = $tanggal;
    $data['v_product']  = $model->_get_productb($id1)->getResult();
    // $data['v_anggota']  = $model->_get_langgota()->getResult();
    $data['v_kelompok']  = $model->_get_kelompok()->getResult();
    $data['v_petugas']  = $model->_get_employee()->getResult();
    $data['v_tabungan']  = $model1->_list_tabungan()->getResult();
    $data['endofdays'] = $model1->_getakhir()->getResult();
    return view('simpanan/penempatan/penempatan_add', $data);
  }

  public function edpenempatan($id)
  {
    $model = new Model_git();
    $model1 = new Master_model();
    $_SESSION['com_menu'] = '04';
    $_SESSION['com_men1'] = '0402';
    $_SESSION['com_men2'] = '';
    $id1 = 'D';
    $data['v_product']  = $model1->_get_productb($id1)->getResult();
    $data['v_data']  = $model->_get_edpenempatan($id)->getResult();
    $data['v_kelompok']  = $model1->_get_kelompok()->getResult();
    $data['v_petugas']  = $model1->_get_employee()->getResult();
    // $data['v_anggota']  = $model1->_get_langgota()->getResult();
    // $data['v_tabungan']  = $model->_list_tabungan()->getResult();
    return view('simpanan/penempatan/penempatan_edit', $data);
  }

  public function delpenempatan($id)
  {
    $model = new Model_git();
    // $id = $this->request->getPost('code');
    $model->m_deletepenempatan($id);
    return redirect()->to('simpanan/penempatan');
  }

  public function persetujuan()
  {
    $model = new Model_git();
    $data['v_pengajuan']  = $model->_get_persetujuan()->getResult();
    return view('pinjaman/persetujuan', $data);
  }

  public function penutupan()
  {
    $model = new Model_git();
    $data['v_penutupan']  = $model->_get_penutupan()->getResult();
    return view('simpanan/penutupan/penutupan_list', $data);
  }

  public function adpenutupan()
  {
    $model = new Model_git();
    $tanggal = date('Y-m-d');
    $data['hariini'] = $tanggal;
    $data['v_sertifikat']  = $model->_get_sertifikat()->getResult();
    return view('simpanan/penutupan/penutupan_add', $data);
  }



  public function edpenutupan($id)
  {
    $model = new Model_git();
    $data['v_sertifikat']  = $model->_get_sertifikat()->getResult();
    $data['v_penutupan']  = $model->_get_edpenutupan($id)->getResult();
    return view('simpanan/penutupan/penutupan_edit', $data);
  }
  public function delpenutupan()
  {
    $model = new Model_git();
    $id = $this->request->getPost('code');


    $model->m_deletepenutupan($id);



    return redirect()->to('simpanan/penutupan')->with('success', 'Menghapus Data Berhasil');
  }



  public function savepenempatan()
  {
    $model = new Save_model();
    $modecek = new Auto_model();
    $tanggal = $this->request->getPost('pen_date');
    $bulan = date('m', strtotime($tanggal));
    $tahun = date('Y', strtotime($tanggal));
    $periode = $this->request->getPost('pen_tnid');
    $tgljtx =  $this->request->getPost('pen_jtdt');
    // $tgljtp = date('Y-m-d', strtotime('+' . $periode . 'month', strtotime($tgljtx)));
    $tgljtp = substr($tgljtx, 6, 4) . '/' . substr($tgljtx, 3, 2) . '/' . substr($tgljtx, 0, 2);
    // $tgljtx = $this->request->getPost('knt_jtdt');

    // $tgljty = substr($tgljtx, 6, 4) . '/' . substr($tgljtx, 3, 2) . '/' . substr($tgljtx, 0, 2);
    $bulanjtdt = date('m', strtotime($tgljtp));
    $tahunjtdt = date('Y', strtotime($tgljtp));
    $kodecabang = session()->get('kode_cabang');
    $kodeproduct = $this->request->getPost('prd_code');
    $cek = $modecek->get_nopenempatan($kodecabang, $kodeproduct);


    $nourut = $cek['pen_srno'];

    if ($nourut == '') {
      $nourut = 1;
      $v_trx_code = $kodeproduct . '.' . $kodecabang . '.0000001';
    } else {
      $nourut = $nourut + 1;
      if ($nourut < 10) {
        $v_trx_code = $kodeproduct . '.' . $kodecabang . '.000000' . $nourut;
      } else if ($nourut >= 10 and $nourut < 100) {
        $v_trx_code = $kodeproduct . '.' . $kodecabang . '.00000' . $nourut;
      } else if ($nourut >= 100 and $nourut < 1000) {
        $v_trx_code = $kodeproduct . '.' . $kodecabang . '.0000' . $nourut;
      } else if ($nourut >= 1000 and $nourut < 10000) {
        $v_trx_code = $kodeproduct . '.' . $kodecabang . '.000' . $nourut;
      } else if ($nourut >= 10000 and $nourut < 100000) {
        $v_trx_code = $kodeproduct . '.' . $kodecabang . '.00' . $nourut;
      } else if ($nourut >= 10000 and $nourut < 100000) {
        $v_trx_code = $kodeproduct . '.' . $kodecabang . '.0' . $nourut;
      } else {
        $v_trx_code = $kodeproduct . '.' . $kodecabang . '.' . $nourut;
      }
    }

    $pen_totl = str_replace(',', '', $this->request->getPost('pen_totl'));
    $pen_marg = str_replace(',', '', $this->request->getPost('pen_marg'));
    $pen_tenr = str_replace(',', '', $this->request->getPost('pen_tenr'));

    $tmargin = ((($pen_marg / 10) * $pen_totl) / 12) * $pen_tenr;
    $tbg_cod1 = $this->request->getPost('tbg_code');
    if ($tbg_cod1 == '') {
      $tbg_cod1 = '-';
    }
    $data = array(
      'pen_code'       => $v_trx_code, //$this->request->getPost('pen_code'),
      'pen_date'       => $this->request->getPost('pen_date'),
      'agt_numb'       => $this->request->getPost('agt_numb'),
      'prd_code'       => $this->request->getPost('prd_code'),
      'pen_tnid'       => $this->request->getPost('pen_tenr'),
      'pen_tenr'       => $pen_tenr,
      'pen_totl'       => $pen_totl,
      'pen_marg'       => $pen_marg,
      'pen_tmar'       => $tmargin,
      'pen_tpen'       => $this->request->getPost('pen_tpen'),
      'pen_jtdt'       => $tgljtp,
      'pen_desc'       => $this->request->getPost('pen_desc'),
      'pen_rcod'       => $this->request->getPost('pen_rcod'),
      'pen_rdat'       => $this->request->getPost('pen_rdat'),
      'pen_jmar'       => $this->request->getPost('pen_jmar'),
      'tbg_code'       => $tbg_cod1,
      // 'pen_jstr'       => $this->request->getPost('pen_jstr'),
      // 'pen_prep'       => $this->request->getPost('pen_prep'),
      // 'pen_pren'       => $this->request->getPost('pen_pren'),
      'pen_mont'       => $bulan,
      'pen_year'       => $tahun,
      'pen_srno'       => $nourut,
      'pen_mjtp'       => $bulanjtdt,
      'pen_yjtp'       => $tahunjtdt,
      'com_code'  => session()->get('com_code'),
      'kode_cabang'  => session()->get('kode_cabang'),
      'emp_code'  => $this->request->getPost('emp_code'),
      'kel_code'  => $this->request->getPost('kel_code'),
      'col_code'  => $this->request->getPost('col_code'),
      'pen_des1'  => $this->request->getPost('pen_des1'),
      'pen_stat' => 0,

    );

    $model->_savepenempatan($data);


    return redirect()->to('simpanan/penempatan')->with('success', 'Menambah Data Berhasil');
  }


  public function updatepenempatan()
  {
    $model = new Save_model();
    $tanggal = $this->request->getPost('pen_date');
    // $tgljtp = $this->request->getPost('pen_jtdt');
    $tgljtx =  $this->request->getPost('pen_jtdt');
    // $tgljtp = date('Y-m-d', strtotime('+' . $periode . 'month', strtotime($tgljtx)));
    $tgljtp = substr($tgljtx, 6, 4) . '/' . substr($tgljtx, 3, 2) . '/' . substr($tgljtx, 0, 2);
    $bulan = date('m', strtotime($tanggal));
    $tahun = date('Y', strtotime($tanggal));
    $bulanjtdt = date('m', strtotime($tgljtp));
    $tahunjtdt = date('Y', strtotime($tgljtp));
    $id = $this->request->getPost('pen_code');
    $pen_totl = str_replace(',', '', $this->request->getPost('pen_totl'));
    $pen_marg = str_replace(',', '', $this->request->getPost('pen_marg'));
    $pen_tenr = str_replace(',', '', $this->request->getPost('pen_tenr'));
    $tmargin = ((($pen_marg / 10) * $pen_totl) / 12) * $pen_tenr;
    $tbg_cod1 = $this->request->getPost('tbg_code');
    if ($tbg_cod1 == '') {
      $tbg_cod1 = '-';
    }
    $data = array(

      // 'pen_code'       => $this->request->getPost('pen_code'),
      'pen_date'       => $this->request->getPost('pen_date'),
      'agt_numb'       => $this->request->getPost('agt_numb'),
      'prd_code'       => $this->request->getPost('prd_code'),
      'pen_tnid'       => $this->request->getPost('pen_tenr'),
      'pen_tenr'       => $pen_tenr,
      'pen_totl'       => $pen_totl,
      'pen_marg'       => $pen_marg,
      'pen_tmar'       => $tmargin,
      'pen_tpen'       => $this->request->getPost('pen_tpen'),
      'pen_jtdt'       => $tgljtp,
      'pen_desc'       => $this->request->getPost('pen_desc'),
      'pen_rcod'       => $this->request->getPost('pen_rcod'),
      'pen_rdat'       => $this->request->getPost('pen_rdat'),
      'pen_jmar'       => $this->request->getPost('pen_jmar'),
      'tbg_code'       => $this->request->getPost('tbg_code'),
      // 'pen_jstr'       => $this->request->getPost('pen_jstr'),
      // 'pen_prep'       => $this->request->getPost('pen_prep'),
      // 'pen_pren'       => $this->request->getPost('pen_pren'),
      'pen_mont'       => $bulan,
      'pen_year'       => $tahun,

      'pen_mjtp'       => $bulanjtdt,
      'pen_yjtp'       => $tahunjtdt,
      'com_code'  => session()->get('com_code'),
      'kode_cabang'  => session()->get('kode_cabang'),
      'emp_code'  => $this->request->getPost('emp_code'),
      'kel_code'  => $this->request->getPost('kel_code'),
      'col_code'  => $this->request->getPost('col_code'),
      'pen_des1'  => $this->request->getPost('pen_des1'),
    );

    $model->_updatepenempatan($data, $id);


    return redirect()->to('simpanan/penempatan')->with('success', 'Merubah Data Berhasil');
  }

  public function tabungan()
  {
    $model = new Model_git();
    $_SESSION['com_menu'] = '04';
    $_SESSION['com_men1'] = '0401';
    $_SESSION['com_men2'] = '';
    $tanggal = date('Y-m-d');
    $cabang = session()->get('kode_cabang');
    if ($_SESSION['usr_jabt'] == 'Administrator') {
      $data['v_tabungan']  = $model->_get_tabungana($tanggal)->getResult();
    } else {
      $data['v_tabungan']  = $model->_get_tabungan($tanggal, $cabang)->getResult();
    }


    return view('simpanan/tabungan/tabungan_list', $data);
  }


  public function addtabungan()
  {
    $model = new Master_model();
    $_SESSION['com_menu'] = '04';
    $_SESSION['com_men1'] = '0401';
    $_SESSION['com_men2'] = '';
    $id1 = 'S';
    $tanggal = date('Y-m-d');
    $data['hariini'] = $tanggal;
    $data['v_product']  = $model->_get_productb($id1)->getResult();
    $data['v_tujuan']  = $model->_get_tujuan()->getResult();
    $data['v_dana']  = $model->_get_dana()->getResult();
    // $data['v_anggota']  = $model->_get_langgota()->getResult();
    $data['v_kelompok']  = $model->_get_kelompok()->getResult();
    $data['v_petugas']  = $model->_get_employee()->getResult();
    return view('simpanan/tabungan/tabungan_add', $data);
  }


  public function edittabungan($id)
  {
    $model = new Master_model();
    $model1 = new Model_git();
    $id1 = 'S';
    $data['v_product']  = $model->_get_productb($id1)->getResult();
    $data['v_data']  = $model1->_get_edtabungan($id)->getResult();
    $data['v_tujuan']  = $model->_get_tujuan()->getResult();
    $data['v_dana']  = $model->_get_dana()->getResult();
    $data['v_kelompok']  = $model->_get_kelompok()->getResult();
    $data['v_petugas']  = $model->_get_employee()->getResult();
    // $data['v_anggota']  = $model->_get_langgota()->getResult();
    return view('simpanan/tabungan/tabungan_edit', $data);
  }

  public function savetabungan()
  {
    $model = new Save_model();
    $modecek = new Auto_model();
    $tanggal = $this->request->getPost('tbg_date');
    $type = $this->request->getPost('kin_type');
    $bulan = date('m', strtotime($tanggal));
    $tahun = date('Y', strtotime($tanggal));
    $kodecabang = session()->get('kode_cabang');
    $kodeproduct = $this->request->getPost('prd_code');
    $waktu = date('Y-m-d H:i:s');
    $cek = $modecek->get_notabungan($kodecabang, $kodeproduct);
    if ($bulan < 10) {
      $bulan1 = '0' . $bulan;
    } else {
      $bulan1 = $bulan;
    }


    $nourut = $cek['tbg_srno'];

    if ($nourut == '') {
      $nourut = 1;
      $v_trx_code = $kodeproduct . '.' . $kodecabang . '.0000001';
    } else {
      $nourut = $nourut + 1;
      if ($nourut < 10) {
        $v_trx_code = $kodeproduct . '.' . $kodecabang . '.000000' . $nourut;
      } else if ($nourut >= 10 and $nourut < 100) {
        $v_trx_code = $kodeproduct . '.' . $kodecabang . '.00000' . $nourut;
      } else if ($nourut >= 100 and $nourut < 1000) {
        $v_trx_code = $kodeproduct . '.' . $kodecabang . '.0000' . $nourut;
      } else if ($nourut >= 1000 and $nourut < 10000) {
        $v_trx_code = $kodeproduct . '.' . $kodecabang . '.000' . $nourut;
      } else if ($nourut >= 10000 and $nourut < 100000) {
        $v_trx_code = $kodeproduct . '.' . $kodecabang . '.00' . $nourut;
      } else if ($nourut >= 10000 and $nourut < 100000) {
        $v_trx_code = $kodeproduct . '.' . $kodecabang . '.0' . $nourut;
      } else {
        $v_trx_code = $kodeproduct . '.' . $kodecabang . '.' . $nourut;
      }
    }


    $tbg_admn = str_replace(',', '', $this->request->getPost('tbg_admn'));
    $tbg_stmn = str_replace(',', '', $this->request->getPost('tbg_stmn'));
    $tbg_smin = str_replace(',', '', $this->request->getPost('tbg_smin'));
    $tbg_marg = str_replace(',', '', $this->request->getPost('tbg_marg'));
    $tbg_bons = str_replace(',', '', $this->request->getPost('tbg_bons'));
    $tbg_smjs = str_replace(',', '', $this->request->getPost('tbg_smjs'));
    $tbg_spas = str_replace(',', '', $this->request->getPost('tbg_spas'));
    $tbg_sawl = str_replace(',', '', $this->request->getPost('tbg_sawl'));
    $tbg_pinl = str_replace(',', '', $this->request->getPost('tbg_pinl'));
    $tbg_tutp = str_replace(',', '', $this->request->getPost('tbg_tutp'));


    $data = array(
      //'id'       => $v_trx_code, //$this->request->getPost('pen_code'),
      'tbg_code'       => $v_trx_code, //$this->request->getPost('pen_code'),
      'tbg_date'       => $this->request->getPost('tbg_date'),
      'tbg_ahdt'       => $this->request->getPost('tbg_ahdt'),
      'agt_numb'       => $this->request->getPost('agt_numb'),
      'prd_code'       => $this->request->getPost('prd_code'),
      'tbg_qqqq'       => $this->request->getPost('tbg_qqqq'),
      'tbg_marg'       => $tbg_marg,
      'tbg_admn'       => $tbg_admn,
      'tbg_padm'       => $this->request->getPost('tbg_padm'),
      'tbg_smin'       => $tbg_smin,
      'tbg_stmn'       => $tbg_stmn,
      'tbg_bons'       => $tbg_bons,
      'tbg_smjs'       => $tbg_smjs,
      'tbg_spas'       => $tbg_spas,
      'tbg_sawl'       => $tbg_sawl,
      'tbg_pinl'       => $tbg_pinl,
      'tbg_tutp'       => $tbg_tutp,
      'tbg_desc'       => $this->request->getPost('tbg_desc'),
      'tbg_name'       => $this->request->getPost('agt_name'),
      'tbg_mont'       => $bulan,
      'tbg_year'       => $tahun,
      'tbg_srno'       => $nourut,
      'tbg_dana'       => $this->request->getPost('tbg_dana'),
      'tbg_dest'       => $this->request->getPost('tbg_dest'),
      'tbg_pemk'       => $this->request->getPost('tbg_pemk'),
      'com_code'  => session()->get('com_code'),
      'kode_cabang'  => session()->get('kode_cabang'),
      'emp_code'  => $this->request->getPost('emp_code'),
      'kel_code'  => $this->request->getPost('kel_code'),
      'col_code'  => $this->request->getPost('col_code'),
      'tbg_user'  => session()->get('username'),
      'tbg_devi'  => gethostbyaddr($_SERVER['REMOTE_ADDR']),
      'tbg_time'  => $waktu,
      'tbg_stat' => 0,
    );

    $model->_savetabungan($data);



    //   $data = array(
    //     'tbg_code'       => $v_trx_code,//$this->request->getPost('pen_code'),
    //     'tbg_date'       => $this->request->getPost('tbg_date'),
    //     'agt_numb'       => $this->request->getPost('agt_numb'),
    //     'prd_code'       => $this->request->getPost('prd_code'),
    //     'tbg_debt'       => 0,
    //     'tbg_crdt'       => 0,
    //     'tbg_jens'       => '00',
    //      'com_code'  => session()->get('com_code'),
    // );

    // $model->_savekartutabungan($data);


    return redirect()->to('simpanan/tabungan')->with('success', 'Menambah Data Berhasil');
  }


  public function updatetabungan()
  {
    $model = new Save_model();
    $tanggal = $this->request->getPost('tbg_date');
    $bulan = date('m', strtotime($tanggal));
    $tahun = date('Y', strtotime($tanggal));
    $id = $this->request->getPost('tbg_code');
    $tbg_admn = str_replace(',', '', $this->request->getPost('tbg_admn'));
    $tbg_stmn = str_replace(',', '', $this->request->getPost('tbg_stmn'));
    $tbg_smin = str_replace(',', '', $this->request->getPost('tbg_smin'));
    $tbg_marg = str_replace(',', '', $this->request->getPost('tbg_marg'));
    $tbg_bons = str_replace(',', '', $this->request->getPost('tbg_bons'));
    $tbg_smjs = str_replace(',', '', $this->request->getPost('tbg_smjs'));
    $tbg_spas = str_replace(',', '', $this->request->getPost('tbg_spas'));
    $tbg_sawl = str_replace(',', '', $this->request->getPost('tbg_sawl'));
    $tbg_pinl = str_replace(',', '', $this->request->getPost('tbg_pinl'));
    $tbg_tutp = str_replace(',', '', $this->request->getPost('tbg_tutp'));


    $data = array(

      'tbg_date'       => $this->request->getPost('tbg_date'),
      'tbg_ahdt'       => $this->request->getPost('tbg_ahdt'),
      'agt_numb'       => $this->request->getPost('agt_numb'),
      'prd_code'       => $this->request->getPost('prd_code'),
      'tbg_qqqq'       => $this->request->getPost('tbg_qqqq'),
      'tbg_marg'       => $tbg_marg,
      'tbg_admn'       => $tbg_admn,
      'tbg_padm'       => $this->request->getPost('tbg_padm'),
      'tbg_smin'       => $tbg_smin,
      'tbg_stmn'       => $tbg_stmn,
      'tbg_bons'       => $tbg_bons,
      'tbg_smjs'       => $tbg_smjs,
      'tbg_spas'       => $tbg_spas,
      'tbg_sawl'       => $tbg_sawl,
      'tbg_pinl'       => $tbg_pinl,
      'tbg_tutp'       => $tbg_tutp,


      'tbg_desc'       => $this->request->getPost('tbg_desc'),
      'tbg_mont'       => $bulan,
      'tbg_year'       => $tahun,

      'tbg_dana'       => $this->request->getPost('tbg_dana'),
      'tbg_dest'       => $this->request->getPost('tbg_dest'),
      'tbg_pemk'       => $this->request->getPost('tbg_pemk'),
      'com_code'  => session()->get('com_code'),
      'kode_cabang'  => session()->get('kode_cabang'),
      'emp_code'  => $this->request->getPost('emp_code'),
      'kel_code'  => $this->request->getPost('kel_code'),
      'col_code'  => $this->request->getPost('col_code'),
      'knt_name'  => $this->request->getPost('agt_name'),

    );

    $model->_updatetabungan($data, $id);


    return redirect()->to('simpanan/tabungan')->with('success', 'Merubah Data Berhasil');
  }


  public function Deletetabungan($id)
  {
    $model = new Delete_model();
    // $id = $this->request->getPost('code');

    $model->m_deletetabungan($id);

    $model->m_deletekartutabungan($id);


    return redirect()->to('simpanan/tabungan')->with('success', 'Menghapus Data Berhasil');
  }
  public function savepenutupan()
  {
    $model = new Save_model();
    $modecek = new Auto_model();
    $tanggal = $this->request->getPost('pnt_date');
    $bulan = date('m', strtotime($tanggal));
    $tahun = date('Y', strtotime($tanggal));
    $cek = $modecek->get_nopepenutupan($bulan, $tahun);
    if ($bulan < 10) {
      $bulan1 = '0' . $bulan;
    } else {
      $bulan1 = $bulan;
    }

    $nourut = $cek['pnt_srno'];

    $kodecabang = session()->get('kode_cabang');
    if ($nourut == '') {
      $nourut = 1;
      $v_trx_code = $kodecabang . '04.' . $tahun . $bulan . '00001';
    } else {
      $nourut = $nourut + 1;
      if ($nourut < 10) {
        $v_trx_code = $kodecabang . '04.' . $tahun . $bulan . '0000' . $nourut;
      } else if ($nourut >= 10 and $nourut < 100) {
        $v_trx_code = $kodecabang . '04.' . $tahun . $bulan . '000' . $nourut;
      } else if ($nourut >= 100 and $nourut < 1000) {
        $v_trx_code = $kodecabang . '04.' . $tahun . $bulan . '00' . $nourut;
      } else if ($nourut >= 1000 and $nourut < 10000) {
        $v_trx_code = $kodecabang . '04.' . $tahun . $bulan . '0' . $nourut;
      } else {
        $v_trx_code = $kodecabang . '04.' . $tahun . $bulan . $nourut;
      }
    }



    $pnt_totl = str_replace(',', '', $this->request->getPost('pnt_totl'));
    $pnt_finl = str_replace(',', '', $this->request->getPost('pnt_finl'));
    $pnt_pphf = str_replace(',', '', $this->request->getPost('pnt_pphf'));
    $pnt_tott = str_replace(',', '', $this->request->getPost('pnt_tott'));
    $pnt_ttab = str_replace(',', '', $this->request->getPost('pnt_ttab'));
    $pnt_tmar = str_replace(',', '', $this->request->getPost('pnt_tmar'));
    $data = array(
      'pnt_code'       => $v_trx_code, //$this->request->getPost('pnt_code'),
      'pnt_date'       => $this->request->getPost('pnt_date'),
      'pen_code'       => $this->request->getPost('pen_code'),
      'pen_date'       => $this->request->getPost('pnt_pdat'),
      'agt_numb'       => $this->request->getPost('agt_numb'),
      'prd_code'       => $this->request->getPost('prd_code'),
      'pnt_tnid'       => $this->request->getPost('pnt_tnid'),
      'pnt_tenr'       => $this->request->getPost('pnt_tenr'),
      'pnt_totl'       => $pnt_totl,
      'pnt_marg'       => $this->request->getPost('pnt_marg'),
      'pnt_tmar'       => $pnt_tmar,
      'pnt_type'       => $this->request->getPost('pnt_type'),
      'pnt_jtdt'       => $this->request->getPost('pnt_jtdt'),
      'pnt_desc'       => $this->request->getPost('pnt_desc'),
      'pnt_finl'       => $pnt_finl,
      'pnt_pphf'       => $pnt_pphf,
      'pnt_tott'       => $pnt_tott,
      'pnt_ttab'       => $pnt_ttab,
      'pnt_mont'       => $bulan,
      'pnt_year'       => $tahun,
      'pnt_srno'       => $nourut,
      'com_code'  => session()->get('com_code'),
      'kode_cabang'  => session()->get('kode_cabang'),
      'pnt_stat' => 0,
    );

    $model->_savepenutupan($data);
    $id = $this->request->getPost('pen_code');
    $data = array(
      'pen_stat' => 1,
    );
    $model->_updatepenempatan($data, $id);

    return redirect()->to('simpanan/penutupan')->with('success', 'Menambah Data Berhasil');
  }


  public function updatepenutupan()
  {
    $model = new Save_model();
    $tanggal = $this->request->getPost('pnt_date');
    $bulan = date('m', strtotime($tanggal));
    $tahun = date('Y', strtotime($tanggal));
    $id = $this->request->getPost('pnt_code');
    $pnt_totl = str_replace(',', '', $this->request->getPost('pnt_totl'));
    $pnt_finl = str_replace(',', '', $this->request->getPost('pnt_finl'));
    $pnt_pphf = str_replace(',', '', $this->request->getPost('pnt_pphf'));
    $pnt_tott = str_replace(',', '', $this->request->getPost('pnt_tott'));
    $pnt_ttab = str_replace(',', '', $this->request->getPost('pnt_ttab'));
    $pnt_tmar = str_replace(',', '', $this->request->getPost('pnt_tmar'));
    $data = array(
      'pnt_code'       => $this->request->getPost('pnt_code'),
      'pnt_date'       => $this->request->getPost('pnt_date'),
      'pen_code'       => $this->request->getPost('pen_code'),
      'pen_date'       => $this->request->getPost('pnt_pdat'),
      'agt_numb'       => $this->request->getPost('agt_numb'),
      'prd_code'       => $this->request->getPost('prd_code'),
      'pnt_tnid'       => $this->request->getPost('pnt_tnid'),
      'pnt_tenr'       => $this->request->getPost('pnt_tenr'),
      'pnt_totl'       => $pnt_totl,
      'pnt_marg'       => $this->request->getPost('pnt_marg'),
      'pnt_tmar'       => $pnt_tmar,
      'pnt_type'       => $this->request->getPost('pnt_type'),
      'pnt_jtdt'       => $this->request->getPost('pnt_jtdt'),
      'pnt_desc'       => $this->request->getPost('pnt_desc'),
      'pnt_finl'       => $pnt_finl,
      'pnt_pphf'       => $pnt_pphf,
      'pnt_tott'       => $pnt_tott,
      'pnt_ttab'       => $pnt_ttab,
      'pnt_mont'       => $bulan,
      'pnt_year'       => $tahun,

    );

    $model->_updatepenutupan($data, $id);


    return redirect()->to('simpanan/penutupan')->with('success', 'Menambah Data Berhasil');
  }

  public function hapustabungan()
  {
    $model = new Model_git();
    $_SESSION['com_menu'] = '04';
    $_SESSION['com_men1'] = '0401';
    $_SESSION['com_men2'] = '040102';
    $tanggal1 = '';
    $tanggal2 = '';
    $data['v_data'] = $model->_get_dtsetortabungan($tanggal1, $tanggal2)->getResult();

    return view('simpanan/tabungan/tabungan_hapus', $data);
  }

  public function hapusssb()
  {
    $model = new Model_git();
    $_SESSION['com_menu'] = '04';
    $_SESSION['com_men1'] = '0402';
    $_SESSION['com_men2'] = '040202';
    $id = '';
    $data['tgl1'] = '';
    $data['tgl2'] = '';
    $data['v_kas']  = $model->_get_edpenempatan($id)->getResult();
    return view('simpanan/penempatan/penempatan_hapus', $data);
  }

  public function blokirssb()
  {
    $_SESSION['com_menu'] = '04';
    $_SESSION['com_men1'] = '0402';
    $_SESSION['com_men2'] = '040202';
    return view('simpanan/penempatan/blokirssb');
  }

  public function blokirtabungan()
  {
    $model = new Model_git();
    $_SESSION['com_menu'] = '04';
    $_SESSION['com_men1'] = '0401';
    $_SESSION['com_men2'] = '040102';
    $data['v_rekening']  = $model->_get_rektabungan()->getResult();
    return view('simpanan/tabungan/blokirtabungan', $data);
  }

  public function prosblokirtab()
  {
    $model = new Save_model();
    $id = $this->request->getPost('tbg_code');
    $data = array(
      'tbg_stat' => $this->request->getPost('blk_code'),
      'tbg_des1' => $this->request->getPost('blk_desc'),
    );
    $model->_updatetabungan($data, $id);
    return redirect()->to(base_url('simpanan/blokirtabungan'))->with('success', 'Closing Harian Selesai');
  }

  public function prosblokirssb()
  {
    $model = new Save_model();
    $id = $this->request->getPost('tbg_code');
    $data = array(
      'pen_stat' => $this->request->getPost('blk_code'),
      'pen_des1' => $this->request->getPost('blk_desc'),
    );
    $model->_updatepenempatan($data, $id);
    return redirect()->to(base_url('simpanan/blokirssb'))->with('success', 'Closing Harian Selesai');
  }

  public function koreksimargintab()
  {
    $model = new Model_git();
    $_SESSION['com_menu'] = '04';
    $_SESSION['com_men1'] = '0401';
    $_SESSION['com_men2'] = '040102';
    if ($this->request->getPost('trx_date' != null)) {
      $id1 = $this->request->getPost('trx_date');
    } else {
      $id1 = '';
    }
    if ($this->request->getPost('trx_dat1' != null)) {
      $id2 = $this->request->getPost('trx_dat1');
    } else {
      $id2 = '';
    }
    $data['tgl1'] = $id1;
    $data['tgl2'] = $id2;
    $id3 = 'T';
    $data['v_koreksi']  = $model->_get_loadjasa($id1, $id2, $id3)->getResult();
    return view('simpanan/tabungan/koreksimargin', $data);
  }
  public function koreksidbmargintab()
  {
    $model = new Model_git();

    $id1 = $this->request->getPost('trx_date');
    $id2 = $this->request->getPost('trx_dat1');
    $data['tgl1'] = $id1;
    $data['tgl2'] = $id2;
    $id3 = 'T';
    $data['v_koreksi']  = $model->_get_loadjasa($id1, $id2, $id3)->getResult();
    return view('simpanan/tabungan/koreksimargin', $data);
  }


  public  function koreksimarginssb()
  {
    $model = new Model_git();
    $_SESSION['com_menu'] = '04';
    $_SESSION['com_men1'] = '0402';
    $_SESSION['com_men2'] = '040202';
    // if ($this->request->getPost('trx_date' != null)) {
    //   $id1 = $this->request->getPost('trx_date');
    // } else {
    //   $id1 = '';
    // }
    // if ($this->request->getPost('trx_dat1' != null)) {
    //   $id2 = $this->request->getPost('trx_dat1');
    // } else {
    //   $id2 = '';
    // }
    if ($this->request->getPost('trx_date' != null)) {
      $id1 = $this->request->getPost('jas_dat1');
    } else {
      $id1 = '';
    }
    if ($this->request->getPost('trx_dat1' != null)) {
      $id2 = $this->request->getPost('jas_dat2');
    } else {
      $id2 = '';
    }

    $data['tgl1'] = $id1;
    $data['tgl2'] = $id2;
    $id = 'D';
    $data['v_koreksi']  = $model->_get_loadjasa($id1, $id2, $id)->getResult();
    return view('simpanan/penempatan/koreksimarginssb', $data);
  }

  public  function koreksidbmarginssb()
  {

    $model = new Model_git();
    $id1 = $this->request->getPost('trx_date');
    $id2 = $this->request->getPost('trx_dat1');
    $data['tgl1'] = $id1;
    $data['tgl2'] = $id2;
    $id = 'D';

    $data['v_koreksi']  = $model->_get_loadjasa($id1, $id2, $id)->getResult();


    return view('simpanan/penempatan/koreksimarginssb', $data);
  }

  public function deletessb()
  {

    $model = new Model_git();
    $mdelete = new Delete_model();
    $msave = new Save_model();
    $kode = $_POST['code1'];
    if ($kode == '') {
      $jumlah = 0;
    } else {
      $jumlah = count($kode);
    }


    for ($x = 0; $x < $jumlah; $x++) {
      $x1 = $x + 1;
      $kode1 = $this->request->getPost('code1[' . $x . ']');

      if ($kode1 != '') {
        $cek = $this->request->getPost('cek[' . $x . ']');


        $mdelete->_deletekasssb($cek);
        $mdelete->_deletejurnal($cek);
      }
    }
    $tanggal1 = $this->request->getPost('trx_date');
    $tanggal2 = $this->request->getPost('trx_dat1');

    $data['tgl1'] = $tanggal1;
    $data['tgl2'] = $tanggal2;
    $data['v_kas'] = $model->_getdelpenempatan($tanggal1, $tanggal2)->getResult();
    // return redirect()->to('simpanan/penutupan')->with('tgl1', $tanggal1, 'tgl2');
    return view('simpanan/penempatan/penempatan_hapus', $data);
  }

  public function updatejasa()
  {
    $model = new Save_model();

    $id = $this->request->getPost('git_code');
    $id1 = $this->request->getPost('trx_date');
    $id2 = $this->request->getPost('trx_dat1');
    $jasa = str_replace(',', '', $this->request->getPost('jas_amnt'));
    $pajak = str_replace(',', '', $this->request->getPost('jas_pphf'));
    $admin = str_replace(',', '', $this->request->getPost('jas_admn'));

    $data = array(
      'jas_amnt' => $jasa,
      'jas_pphf' => $pajak,
      'jas_admn' => $admin,
    );
    $model->_updatejasa1($data, $id);


    $model = new Model_git();

    $id1 = $this->request->getPost('jas_dat1');
    $id2 = $this->request->getPost('jas_dat2');
    $data['tgl1'] = $id1;
    $data['tgl2'] = $id2;
    $id3 = 'T';
    $data['v_koreksi']  = $model->_get_loadjasa($id1, $id2, $id3)->getResult();
    return view('simpanan/tabungan/koreksimargin', $data);

    // return redirect()->to('simpanan/koreksimargintab')->with('success', 'Koreksi Data Berhasil');
  }

  public function updatejasassb()
  {
    $model = new Save_model();

    $id = $this->request->getPost('git_code');
    $id1 = $this->request->getPost('jas_dat1');
    $id2 = $this->request->getPost('jas_dat2');
    $jasa = str_replace(',', '', $this->request->getPost('jas_amnt'));
    $pajak = str_replace(',', '', $this->request->getPost('jas_pphf'));
    $angbasil = str_replace(',', '', $this->request->getPost('jas_absl'));
    $angpajak = str_replace(',', '', $this->request->getPost('jas_angp'));;
    $data = array(
      'jas_amnt' => $jasa,
      'jas_pphf' => $pajak,
      'jas_absl' => $angbasil,
      'jas_angp' => $angpajak,
      'jas_bdat' =>  $this->request->getPost('jas_bdat'),
    );
    $model->_updatejasa1($data, $id);
    $model = new Model_git();
    $id1 = $this->request->getPost('jas_dat1');
    $id2 = $this->request->getPost('jas_dat2');
    $data['tgl1'] = $id1;
    $data['tgl2'] = $id2;
    $id = 'D';

    $data['v_koreksi']  = $model->_get_loadjasa($id1, $id2, $id)->getResult();


    return view('simpanan/penempatan/koreksimarginssb', $data);

    // return redirect()->to('simpanan/koreksimarginssb')->with('success', 'Koreksi Data Berhasil');
  }

  public function dafartabungan()
  {
    $model = new Model_git();
    $_SESSION['com_menu'] = '04';
    $_SESSION['com_men1'] = '0401';
    $_SESSION['com_men2'] = '040102';
    $tanggal1 = '';
    $tanggal2 = '';
    $tanggal = date('Y-m-d');
    $cabang = session()->get('kode_cabang');
    if ($_SESSION['usr_jabt'] == 'Administrator') {
      $data['v_data']  = $model->_get_daftabungan($tanggal1, $tanggal2)->getResult();
    } else {
      $data['v_data']  = $model->_get_daftabungancab($tanggal1, $tanggal2, $cabang)->getResult();
    }
    return view('simpanan/tabungan/tabungan_daftar', $data);
  }

  public function dafarssb()
  {
    $model = new Model_git();
    $_SESSION['com_menu'] = '04';
    $_SESSION['com_men1'] = '0402';
    $_SESSION['com_men2'] = '';
    $tanggal1 = '';
    $tanggal2 = '';
    $cabang = session()->get('kode_cabang');
    if ($_SESSION['usr_jabt'] == 'Administrator') {
      $data['v_data']  = $model->_get_dafssb($tanggal1, $tanggal2)->getResult();
    } else {
      $data['v_data']  = $model->_get_dafssbcab($tanggal1, $tanggal2, $cabang)->getResult();
    }

    return view('simpanan/penempatan/penempatan_daftar', $data);
  }

  public function cancelpenempatan()
  {
    $model = new Save_model();
    $id = $this->request->getPost('code');
    $data = array(

      'pen_stat'  => 3,
      'pen_desc'  => $this->request->getPost('pen_desc'),
      'pnt_date' => date('Y-m-d'),

    );
    $model->_updatepenempatan($data, $id);
    return redirect()->to('simpanan/penempatan')->with('success', 'Pembatalan Data Berhasil');
  }

  public function bataltabungan()

  {
    $model = new Save_model();
    $id = $this->request->getPost('code');
    $data = array(

      'tbg_stat' => 3,
      'tbg_clos' => date('Y-m-d'),
      'tbg_desc' => $this->request->getPost('tbg_desc'),
    );
    $model->_updatetabungan($data, $id);
    return redirect()->to('simpanan/tabungan')->with('success', 'Pembatalan Data Berhasil');
  }
  //End
}
