<?php

namespace App\Controllers;

use App\Models\Master_model;
use App\Models\Model_git;
// use PhpOffice\PhpSpreadsheet\Reader\Xlsx;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Style\Alignment;

class Upload extends BaseController
{
  public function __construct()
  {
    $session = session();
    date_default_timezone_set('Asia/Jakarta');
  }
  public function potongan()
  {
    $_SESSION['com_menu'] = '02';
    $_SESSION['com_men1'] = '0202';
    $model = new Master_model();
    $data['unit'] = $model->_get_departemen()->getResult();
    return view('dataupload/potongan', $data);
  }

  public function pelunasan()
  {
    $_SESSION['com_menu'] = '02';
    $_SESSION['com_men1'] = '0202';
    return view('dataupload/pelunasan');
  }

  public function prosespotongan()
  {
    $model = new Model_git();
    $mmaster = new Master_model();
    $pexcel = new Spreadsheet;
    $bulan = $this->request->getPost('bln_code');
    if ($bulan == 1) {
      $nbulan = "JANUARI";
    } else if ($bulan == 2) {
      $nbulan = "FEBRUARI";
    } else if ($bulan == 3) {
      $nbulan = "MARET";
    } else if ($bulan == 4) {
      $nbulan = "APRIL";
    } else if ($bulan == 5) {
      $nbulan = "MEI";
    } else if ($bulan == 6) {
      $nbulan = "JUNI";
    } else if ($bulan == 7) {
      $nbulan = "JULI";
    } else if ($bulan == 8) {
      $nbulan = "AGUSTUS";
    } else if ($bulan == 9) {
      $nbulan = "SEPTEMBER";
    } else if ($bulan == 10) {
      $nbulan = "OKTOBER";
    } else if ($bulan == 11) {
      $nbulan = "NOVEMBER";
    } else if ($bulan == 12) {
      $nbulan = "DESEMBER";
    }
    $tahun = $this->request->getPost('thn_code');
    $depcode = $this->request->getPost('dep_code');
    $depname = "";
    $depart = $mmaster->_get_editdepartemen($depcode);
    $impananpokok = 0;
    $impananwajib = 0;
    // $column = 5;
    foreach ($depart->getResult() as $row) {
      $depname = $row->dep_name;
    }

    $pexcel->setActiveSheetIndex(0)
      ->setCellValue('A1', 'DAFTAR POTONGAN')
      ->mergeCells('A1:K1');
    // ->getStyle('A1')->getAlignment()->applyFromArray('HORIZONTAL_CENTER');

    $pexcel->setActiveSheetIndex(0)
      ->setCellValue('A2', 'UNIT : ')
      ->setCellValue('B2',  $depname)
      ->mergeCells('B2:K2');

    $pexcel->setActiveSheetIndex(0)
      ->setCellValue('A3', 'PERIODE : ')
      ->setCellValue('B3', $nbulan . ' ' . $tahun)
      ->mergeCells('B3:K3');


    $pexcel->setActiveSheetIndex(0)
      ->setCellValue('A4', 'No. ')
      ->setCellValue('B4', 'No. Pegawai')
      ->setCellValue('C4', 'Nama Pegawai ')
      ->setCellValue('D4', 'Simpanan Pokok ')
      ->setCellValue('E4', 'Simpanan Wajib')
      ->setCellValue('F4', 'Simpanan')
      ->setCellValue('G4', 'Pinjaman')
      ->setCellValue('H4', 'Toko')
      ->setCellValue('I4', 'Sukarela')
      ->setCellValue('J4', 'Lain-Lain')
      ->setCellValue('K4', 'Total Tagihan')
      ->getColumnDimension('B')->setAutoSize(true);
    $pexcel->setActiveSheetIndex(0)
      ->getColumnDimension('C')->setAutoSize(true);
    $pexcel->setActiveSheetIndex(0)
      ->getColumnDimension('D')->setAutoSize(true);
    $pexcel->setActiveSheetIndex(0)
      ->getColumnDimension('E')->setAutoSize(true);
    $pexcel->setActiveSheetIndex(0)
      ->getColumnDimension('F')->setAutoSize(true);
    $pexcel->setActiveSheetIndex(0)
      ->getColumnDimension('G')->setAutoSize(true);
    $pexcel->setActiveSheetIndex(0)
      ->getColumnDimension('H')->setAutoSize(true);
    $pexcel->setActiveSheetIndex(0)
      ->getColumnDimension('I')->setAutoSize(true);
    $pexcel->setActiveSheetIndex(0)
      ->getColumnDimension('J')->setAutoSize(true);
    $pexcel->setActiveSheetIndex(0)
      ->getColumnDimension('K')->setAutoSize(true);

    $anggota = $mmaster->_get_anggotadep($depname);
    $column = 5;
    $i = 0;
    $subtotal = 0;
    $simpokok = 0;
    $simwa = 0;
    $simpanan = 0;
    $pinjaman = 0;
    $toko = 0;
    $lain = 0;
    $sukarela = 0;
    foreach ($anggota->getResult() as $row) {
      $i = $i + 1;
      $grdcode = $row->grd_code;
      $simpokok = $row->agt_gaji;

      $dbgrade = $mmaster->_get_edit_grade($grdcode);
      foreach ($dbgrade->getResult() as $row1) {
        $simpokok = $row1->grd_smpk;
        $simwa =    $row1->grd_smwa;
        $sukarela =  $row1->grd_skrl;
      }
      $jumlah = $simpokok + $simwa + $simpanan + $pinjaman + $toko + $sukarela + $lain;

      $subtotal = $subtotal + $jumlah;
      $pexcel->setActiveSheetIndex(0)
        ->setCellValue('A' . $column, $i)
        ->setCellValue('B' . $column, $row->emp_code)
        ->setCellValue('C' . $column, $row->agt_name)
        ->setCellValue('D' . $column, $simpokok)
        ->setCellValue('E' . $column, $simwa)
        ->setCellValue('F' . $column, $simpanan)
        ->setCellValue('G' . $column, $pinjaman)
        ->setCellValue('H' . $column, $toko)
        ->setCellValue('I' . $column, $sukarela)
        ->setCellValue('J' . $column, $lain)
        ->setCellValue('K' . $column, $jumlah);
      $column++;
    }
    $pexcel->setActiveSheetIndex(0)
      ->setCellValue('J' . $column, 'TOTAL')

      ->setCellValue('k' . $column, $subtotal);
    // tulis dalam format .xlsx

    $writer = new Xlsx($pexcel);
    $fileName = 'POTONGAN' . $tahun . $bulan . $depname;

    // Redirect hasil generate xlsx ke web client
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header('Content-Disposition: attachment;filename=' . $fileName . '.xlsx');
    header('Cache-Control: max-age=0');

    $writer->save('php://output');
  }
  public function backupdatabase1()
  {

    $db = \Config\Database::connect();
    $dbname = $db->database;
    $path = WRITEPATH . 'uploads/';              // change path here
    $filename = $dbname . '_' . date('dMY_Hi') . '.sql';   // change file name here
    $prefs = ['filename' => $filename];     // I only set the file name, for complete prefs see README

    $util = (new \CodeIgniter\Database\Database())->loadUtils($db);
    $backup = $util->backup($prefs, $db);
    write_file($path . $filename . '.gz', $backup);
    return $this->response->download($path . $filename . '.gz', null);
  }

  public function backupdatabase()
  {
    try {
      // load helper
      helper('filesystem');
      // db connection config
      $config = [
        'DSN'      => '',
        'hostname' => env('database.default.hostname', 'localhost'),
        'username' => env('database.default.username', 'root'),
        'password' => env('database.default.password', ''),
        'database' => env('database.default.database', 'simpin'),
        'DBDriver' => 'MySQLi',
        'DBPrefix' => '',
        'pConnect' => false,
        'DBDebug'  => (ENVIRONMENT !== 'production'),
        'charset'  => 'utf8',
        'DBCollat' => 'utf8_general_ci',
        'swapPre'  => '',
        'encrypt'  => false,
        'compress' => false,
        'strictOn' => false,
        'failover' => [],
        'port'     => 3306,
      ];
      // connect to db with each 

      $db = db_connect($config);
      $builder = $db->query('SHOW TABLES');
      $return = '';
      // get table listing
      $tables = $builder->getResultArray();
      // dd($tables, $config);
      // iterate tables
      foreach ($tables as $table) {
        // get field count from current table
        $result = $db->query('SELECT * FROM ' . $table['Tables_in_' . $config['database']]);
        // $num_field = $result->getFieldCount();
        // create line "DROP TABLE <current_table_name>"
        $return .= "DROP TABLE IF EXISTS " . $table['Tables_in_' . $config['database']] . ";";
        // get create query from current table
        $row2 = $db->query('SHOW CREATE TABLE ' . $table['Tables_in_' . $config['database']])->getResultArray();
        // add create query to return
        $return .= "\n\n" . $row2[0]['Create Table'] . ";\n\n";
        // get result fromm current table
        $row = $result->getResultArray();
        if (sizeof($row) > 0) {
          $return .= "INSERT INTO " . $table['Tables_in_' . $config['database']] . " VALUES(";
          // dd($row[0]);
          for ($j = 0; $j < sizeof($row); $j++) {
            $idx = 0;
            foreach ($row[$j] as $r) {
              $r = addslashes($r);
              $r = mb_ereg_replace("\n", "\\n", $r);
              if (isset($r)) {
                $return .= '"' . $r . '"';
              } else {
                $return .= '""';
              }
              // add separator
              if ($idx < sizeof($row[$j]) - 1) {
                $return .= ',';
              }
              $idx++;
            }
            // add separator
            if ($j < sizeof($row) - 1) {
              $return .= '), (';
            }
          }
          // add separator
          $return .= ");\n";
          $return .= "\n\n\n";
        }
      }
      // file name
      $tgl = $this->request->getPost('bak_date');
      $path
        = $this->request->getPost('bak_path');

      $filename = date('d-m-Y-H-i-s', strtotime($tgl)) . "-db_simpin.sql";
      // write file
      // if (!write_file(ROOTPATH . "/downloads/" . $filename, $return)) {
      if (!write_file("c:/backupdb/" . $filename, $return)) {
        return redirect()->to(base_url() . '/management/backup')->with('error', 'Cannot write file!');
      } else {
        return redirect()->to(base_url() . '/management/backup')->with('success', 'Backup database berhasil! <a class="float-right" href="' . base_url() . '/public/backupdb/' . $filename . '"><i class="fas fa-download"></i> Download</a>');
      }
    } catch (\Throwable $th) {
      return redirect()->to(base_url() . '/management/backup')->with('error', $th->getMessage());
    }
  }
}
