<?php

namespace App\Models;

use CodeIgniter\Model;

class Accounting_model extends Model
{
    public function _get_saldoawal($norekening, $tanggal1)
    {
        $builder = $this->db->table('accouddb');
        $builder->select('*');
        $builder->where('accouddb.acc_code', $norekening);
        $builder->where('accouddb.acc_date<', $tanggal1);

        $builder->orderBy('accouddb.acc_date', 'desc');
        $builder->limit(1);

        return $builder->get();
    }
    public function _get_saldoawalcab($norekening, $tanggal1, $cabang)
    {
        $builder = $this->db->table('accouddb');
        $builder->select('*');
        $builder->where('accouddb.acc_code', $norekening);
        $builder->where('accouddb.acc_date<', $tanggal1);
        $builder->where('accouddb.kode_cabang', $cabang);
        $builder->orderBy('accouddb.acc_date', 'desc');
        $builder->limit(1);

        return $builder->get();
    }
    public function _get_bukubesar($norekening, $tanggal1, $tanggal2)
    {
        $builder = $this->db->table('transddb');
        $builder->select('*');
        $builder->join('tblaccount', 'transddb.acc_code=tblaccount.acc_code', 'inner');
        $builder->join('tblcoscentre', 'transddb.psb_code=tblcoscentre.cos_code', 'left');
        $builder->join('tblcompany', 'transddb.com_code=tblcompany.com_code', 'left');
        $builder->where('transddb.trx_amnt>', 0);
        $builder->where('transddb.trx_date>=', $tanggal1);
        $builder->where('transddb.trx_date<=', $tanggal2);
        $builder->where('transddb.acc_code', $norekening);
        $builder->orderBy('transddb.trx_code', 'asc');
        $builder->orderBy('transddb.trx_dbcr', 'asc');
        $builder->orderBy('transddb.acc_code', 'asc');


        return $builder->get();
    }

    public function get_transaksi($v_acc_code, $tgl_pertama, $tgl_terakhir)
    {
        $builder = $this->db->table('transddb');
        $builder->select('sum(dbt_amnt) as dbt_amnt,sum(crd_amnt) as crd_amnt');
        $builder->where('acc_code', $v_acc_code);
        $builder->where('trx_date>=', $tgl_pertama);
        $builder->where('trx_date<=', $tgl_terakhir);
        return $builder->get();
    }
    public function get_dttransaksi($v_acc_code, $tgl_pertama, $tgl_terakhir)
    {
        $builder = $this->db->table('transddb');
        $builder->select('*');
        $builder->where('acc_code', $v_acc_code);
        $builder->where('trx_date>=', $tgl_pertama);
        $builder->where('trx_date<=', $tgl_terakhir);
        return $builder->get();
    }
    public function get_dttransaksicab($v_acc_code, $tgl_pertama, $tgl_terakhir, $cabang)
    {
        $builder = $this->db->table('transddb');
        $builder->select('*');
        $builder->where('acc_code', $v_acc_code);
        $builder->where('trx_date>=', $tgl_pertama);
        $builder->where('trx_date<=', $tgl_terakhir);
        $builder->where('kode_cabang', $cabang);
        return $builder->get();
    }
    public function get_dttransaksijrnheader($tgl_pertama, $tgl_terakhir)
    {
        $builder = $this->db->table('transddb');
        $builder->select('trx_code');

        $builder->where('trx_date>=', $tgl_pertama);
        $builder->where('trx_date<=', $tgl_terakhir);
        $builder->groupBy('trx_code');
        $builder->orderBy('trx_date');
        return $builder->get();
    }

    public function get_dttransaksijrn($trx_code)
    {
        $builder = $this->db->table('transddb');
        $builder->select('*');
        $builder->join('tblaccount', 'transddb.acc_code=tblaccount.acc_code', 'inner');
        $builder->where('trx_code', $trx_code);
        // $builder->where('trx_date>=', $tgl_pertama);
        // $builder->where('trx_date<=', $tgl_terakhir);

        $builder->orderBy('trx_cod1');
        return $builder->get();
    }
    public function _get_neracasaldo()
    {
        $builder = $this->db->table('tblaccount');
        $builder->select('*');
        $builder->where('acc_dtum', 'D');
        return $builder->get();
    }
    public function _get_neracaawalcab($acc_code, $bulan, $tahun, $cabang)
    {
        $builder = $this->db->table('accouddb');
        $builder->select('*');
        $builder->where('acc_code', $acc_code);
        $builder->where('acc_buln', $bulan);
        $builder->where('acc_tahn', $tahun);
        $builder->where('kode_cabang', $cabang);
        $builder->orderBy('accouddb.acc_date', 'desc');
        $builder->limit(1);
        return $builder->get();
    }

    public function _get_neracaawal($acc_code, $bulan, $tahun)
    {
        $builder = $this->db->table('accouddb');
        $builder->select('sum(acc_akhc) as acc_akhc ');
        $builder->where('acc_code', $acc_code);
        $builder->where('acc_buln', $bulan);
        $builder->where('acc_tahn', $tahun);
        $builder->orderBy('accouddb.acc_date', 'desc');
        $builder->limit(1);
        return $builder->get();
    }

    public function _get_transaksicab($acc_code, $bulan, $tahun, $cabang)
    {
        $builder = $this->db->table('transddb');
        $builder->select('sum(dbt_amnt) as dbt_amnt,sum(crd_amnt) as crd_amnt');
        $builder->where('acc_code', $acc_code);
        $builder->where('month(trx_date)', $bulan);
        $builder->where('year(trx_date)', $tahun);
        $builder->where('kode_cabang', $cabang);

        $builder->limit(1);
        return $builder->get();
    }
    public function _get_transaksi($acc_code, $bulan, $tahun)
    {
        $builder = $this->db->table('transddb');
        $builder->select('sum(dbt_amnt) as dbt_amnt,sum(crd_amnt) as crd_amnt ');
        $builder->where('acc_code', $acc_code);
        $builder->where('month(trx_date)', $bulan);
        $builder->where('year(trx_date)', $tahun);

        $builder->limit(1);
        return $builder->get();
    }
    public function _get_neracasaldo_nil($bulan, $tahun)
    {
        $builder = $this->db->table('accouddb');
        $builder->select('*');
        $builder->join('tblaccount', 'accouddb.acc_code=tblaccount.acc_code', 'inner');
        $builder->join('tblcompany', 'accouddb.com_code=tblcompany.com_code', 'left');
        $builder->where('acc_buln', $bulan);
        $builder->where('acc_tahn', $tahun);
        $builder->orderBy('accouddb.acc_code', 'asc');
        return $builder->get();
    }

    public function _get_labarugi()
    {
        $builder = $this->db->table('tblaccount');
        $builder->select('*');

        // $builder->where('acc_levl','3');
        $builder->where('acc_klas>=', '4');
        $builder->where('acc_dtum', 'U');
        $builder->where('acc_levl', '2');
        $builder->orderBy('acc_code', 'asc');
        return $builder->get();
    }


    public function _get_labarugi1($acc_code)
    {
        $builder = $this->db->table('tblaccount');
        $builder->select('*');

        // $builder->where('acc_levl','3');
        $builder->where('acc_klas>=', '4');
        // $builder->where('acc_dtum','U');
        $builder->where('acc_levl', '3');
        $builder->where('acc_umum', $acc_code);
        $builder->orderBy('acc_code', 'asc');
        return $builder->get();
    }
    public function _get_nilai($v_acc_code1, $bulan, $tahun)
    {
        $builder = $this->db->table('v_accouddb');
        $builder->select('sum(acc_akhc) as acc_akhc');
        // $builder->join('tblaccount', 'accouddb.acc_code=tblaccount.acc_code', 'inner');
        $builder->where('acc_buln', $bulan);
        $builder->where('acc_tahn', $tahun);
        $builder->where('acc_code', $v_acc_code1);
        $builder->limit(1);
        return $builder->get();
    }

    public function _get_nilaicab($v_acc_code1, $bulan, $tahun, $cabang)
    {
        $builder = $this->db->table('v_accouddb');
        $builder->select('sum(acc_akhc) as acc_akhc');
        // $builder->join('tblaccount', 'accouddb.acc_code=tblaccount.acc_code', 'inner');
        $builder->where('acc_buln', $bulan);
        $builder->where('acc_tahn', $tahun);
        $builder->where('acc_code', $v_acc_code1);
        $builder->where('kode_cabang', $cabang);
        $builder->limit(1);
        return $builder->get();
    }
    public function _get_txlabarugi()
    {
        $builder = $this->db->table('tx_labarugi');
        $builder->select('*');
        $builder->join('tblcompany', 'tx_labarugi.com_code=tblcompany.com_code', 'inner');
        $builder->orderBy('urut', 'asc');
        return $builder->get();
    }


    public function _get_neracap($acc_klas1, $acc_klas2)
    {
        $builder = $this->db->table('tblaccount');
        $builder->select('*');

        // $builder->where('acc_levl','3');
        $builder->where('acc_klas>=', $acc_klas1);
        $builder->where('acc_klas<=', $acc_klas2);
        // $builder->where('acc_dtum', 'U');
        $builder->where('acc_levl', '2');
        $builder->orderBy('acc_code', 'asc');
        return $builder->get();
    }

    public function _get_neraca($acc_klas1, $acc_klas2, $acc_grup)
    {
        $builder = $this->db->table('tblaccount');
        $builder->select('*');
        $builder->join('tblaccklas', 'tblaccount.acc_klas=tblaccklas.acc_klas', 'inner');
        $builder->where('acc_grup', $acc_grup);
        $builder->where('tblaccount.acc_klas>=', $acc_klas1);
        $builder->where('tblaccount.acc_klas<=', $acc_klas2);
        // $builder->where('acc_dtum', 'U');
        $builder->where('acc_levl', '2');
        $builder->orderBy('acc_code', 'asc');
        return $builder->get();
    }

    public function _get_proyeksi($acc_klas1, $acc_klas2)
    {
        $builder = $this->db->table('tblaccount');
        $builder->select('*');
        $builder->join('tblaccklas', 'tblaccount.acc_klas=tblaccklas.acc_klas', 'inner');

        $builder->where('tblaccount.acc_klas>=', $acc_klas1);
        $builder->where('tblaccount.acc_klas<=', $acc_klas2);
        // $builder->where('acc_dtum', 'U');
        $builder->where('acc_levl', '2');
        $builder->orderBy('acc_code', 'asc');
        return $builder->get();
    }

    public function _get_perubahan($acc_klas1, $acc_klas2, $acc_grup)
    {
        $builder = $this->db->table('tblaccount');
        $builder->select('*');
        $builder->join('tblaccklas', 'tblaccount.acc_klas=tblaccklas.acc_klas', 'inner');
        $builder->where('acc_grup', $acc_grup);
        $builder->where('tblaccount.acc_klas>=', $acc_klas1);
        $builder->where('tblaccount.acc_klas<=', $acc_klas2);
        // $builder->where('acc_dtum', 'U');
        $builder->where('acc_levl', '2');
        $builder->orderBy('acc_code', 'asc');
        return $builder->get();
    }
    public function _get_neraca1($acc_code)
    {
        $builder = $this->db->table('tblaccount');
        $builder->select('substr(acc_code,1,5) as acc_cod1,acc_name,acc_levl,acc_nblc,acc_dtum');
        $builder->where('acc_levl', '3');
        $builder->where('acc_umum', $acc_code);
        $builder->orderBy('acc_code', 'asc');
        return $builder->get();
    }

    public function _get_neraca1p($acc_code)
    {
        $builder = $this->db->table('tblaccount');
        $builder->select('substr(acc_code,1,5) as acc_cod1,acc_name,acc_levl,acc_nblc,acc_dtum');
        $builder->where('acc_levl', '3');
        $builder->where('acc_umum', $acc_code);
        $builder->orderBy('acc_code', 'asc');
        return $builder->get();
    }

    public function _get_neraca1pa($acc_code, $acc_code2)
    {
        $builder = $this->db->table('tblaccount');
        $builder->select('substr(acc_code,1,5) as acc_cod1,acc_name,acc_levl,acc_nblc,acc_dtum');
        $builder->where('acc_levl', '3');
        $builder->where('acc_cod1>=', $acc_code);
        $builder->where('acc_cod1<=', $acc_code2);
        $builder->orderBy('acc_code', 'asc');
        return $builder->get();
    }
    public function _get_txneraca()
    {
        $builder = $this->db->table('tx_neraca');
        $builder->select('*');
        $builder->join('tblcompany', 'tx_neraca.com_code=tblcompany.com_code', 'inner');
        $builder->orderBy('urut', 'asc');
        return $builder->get();
    }

    public function _get_grpneraca($grup1, $grup2)
    {
        $builder = $this->db->table('tblaccgrup');
        $builder->select('*');
        $builder->where('acc_grup>=', $grup1);
        $builder->where('acc_grup<=', $grup2);
        $builder->orderBy('acc_grup', 'asc');
        return $builder->get();
    }
    public function _get_dtakun($acc_code1, $acc_code2)
    {
        $builder = $this->db->table('tblaccount');
        $builder->select('*');
        $builder->where('acc_dtum', 'D');
        $builder->where('acc_code>=', $acc_code1);
        $builder->where('acc_code<=', $acc_code2);
        $builder->orderBy('acc_code', 'asc');
        return $builder->get();
    }
}
