<?php

namespace App\Models;

use CodeIgniter\Model;

class AppToken extends Model
{
  protected $DBGroup          = 'default';
  protected $table            = 'app_token';
  protected $primaryKey       = 'ait_id';
  protected $useAutoIncrement = true;
  protected $insertID         = 0;
  protected $returnType       = 'array';
  protected $useSoftDeletes   = false;
  protected $protectFields    = true;
  protected $allowedFields    = [];

  // Dates
  protected $useTimestamps = false;
  protected $dateFormat    = 'datetime';
  protected $createdField  = 'created_at';
  protected $updatedField  = 'updated_at';
  protected $deletedField  = 'deleted_at';

  // Validation
  protected $validationRules      = [];
  protected $validationMessages   = [];
  protected $skipValidation       = false;
  protected $cleanValidationRules = true;

  // Callbacks
  protected $allowCallbacks = true;
  protected $beforeInsert   = [];
  protected $afterInsert    = [];
  protected $beforeUpdate   = [];
  protected $afterUpdate    = [];
  protected $beforeFind     = [];
  protected $afterFind      = [];
  protected $beforeDelete   = [];
  protected $afterDelete    = [];

  public function do_find_all()
  {
    return AppToken::asObject()
      ->where('is_deleted', '0')->findAll();
  }

  public function getDetailById($id): Object
  {
    // Construct the Query Builder query
    $builder = $this->db->table($this->table);
    $builder->select($this->table . '.*');
    $builder->where($this->table . '.' . $this->primaryKey, $id);
    $builder->where($this->table . '.is_deleted !=', '1');

    // Fetch the result data
    $query = $builder->get();
    // $qry = $this->db->getLastQuery();
    $res = $query->getResult();

    // Return the response
    return $res[0];
  }

  public function getDetailByToken($token): Object
  {
    // Construct the Query Builder query
    $builder = $this->db->table($this->table);
    $builder->select($this->table . '.*');
    $builder->where($this->table . '.token', $token);
    $builder->where($this->table . '.is_deleted !=', '1');

    // Fetch the result data
    $query = $builder->get();
    // $qry = $this->db->getLastQuery();
    $res = $query->getResult();

    // Return the response
    return $res[0];
  }

  public function do_add($data)
  {
	//print_r($data);
    $builder = $this->db->table($this->table);
	//$sql = $builder->set($data)->getCompiledInsert();
	//echo ($sql);
    $result = $builder->insert($data);
	//print_r($result);
    return $result;
  }

  public function do_update($id, $data)
  {
    $builder = $this->db->table($this->table);
    $builder->where($this->primaryKey, $id);
    $result = $builder->update($data);

    return $result;
  }

  public function do_check_token($token)
  {
    $builder = $this->db->table($this->table);
    $builder->where('token', $token);
    //$builder->where($this->table . '.is_deleted !=', '1');
    $result = $builder->countAllResults();

    return $result > 0 ? true : false;
  }

  public function do_add_log($data)
  {
    $builder = $this->db->table($this->table . '_log');
    $result = $builder->insert($data);

    return $result;
  }
}
