<?php

namespace App\Models;

use CodeIgniter\Model;

class Auto_model extends Model
{
  // start -------------------


  // Jurnal Number
  function   get_nojurnal($bulan, $tahun)
  {

    return $this->db->table('trxjourhdr')
      ->where(array('trx_buln' => $bulan, 'trx_tahn' => $tahun))
      ->orderBy('trx_srno', 'desc')
      ->limit(1)
      ->get()->getRowArray();
  }

  //Kas masuk
  function   get_nopencairan($bulan, $tahun)
  {

    return $this->db->table('trxpencairan')
      ->where(array('kot_mont' => $bulan, 'kot_year' => $tahun))
      ->orderBy('kot_srno', 'desc')
      ->limit(1)
      ->get()->getRowArray();
  }

  function   get_nosetoran($bulan, $tahun)
  {

    return $this->db->table('trxsetorhdb')
      ->where(array('kin_mont' => $bulan, 'kin_year' => $tahun))
      ->orderBy('kin_srno', 'desc')
      ->limit(1)
      ->get()->getRowArray();
  }

  function   get_nopenempatan($kodecabang, $kodeproduct)
  {

    return $this->db->table('trxpenempatan')
      ->where(array('kode_cabang' => $kodecabang, 'prd_code' => $kodeproduct))
      ->orderBy('pen_srno', 'desc')
      ->limit(1)
      ->get()->getRowArray();
  }

  function   get_nopenutupan($bulan, $tahun)
  {

    return $this->db->table('trxpenutupan')
      ->where(array('pnt_mont' => $bulan, 'pnt_year' => $tahun))
      ->orderBy('pnt_srno', 'desc')
      ->limit(1)
      ->get()->getRowArray();
  }

  function   get_nopengajuan($bulan, $tahun)
  {

    return $this->db->table('trxpengajuan')
      ->where(array('png_mont' => $bulan, 'png_year' => $tahun))
      ->orderBy('png_srno', 'desc')
      ->limit(1)
      ->get()->getRowArray();
  }
  function   get_nokontrak($kodecabang, $kodeproduct)
  {

    return $this->db->table('trxkontrak')
      ->where(array('wil_code' => $kodecabang, 'prd_code' => $kodeproduct))
      ->orderBy('knt_srno', 'desc')
      ->limit(1)
      ->get()->getRowArray();
  }

  function   get_notutupanggota($bulan, $tahun)
  {

    return $this->db->table('tblagtclose')
      ->where(array('cls_mont' => $bulan, 'cls_year' => $tahun))
      ->orderBy('cls_srno', 'desc')
      ->limit(1)
      ->get()->getRowArray();
  }
  function   get_notabungan($kodecabang, $kodeproduct)
  {

    return $this->db->table('trxtabungan')
      ->where(array('kode_cabang' => $kodecabang, 'prd_code' => $kodeproduct))
      ->orderBy('tbg_srno', 'desc')
      ->limit(1)
      ->get()->getRowArray();
  }

  function   get_nosetortabungan($bulan, $tahun)
  {

    return $this->db->table('trxkastabungan')
      ->where(array('kin_mont' => $bulan, 'kin_year' => $tahun))
      ->orderBy('kin_srno', 'desc')
      ->limit(1)
      ->get()->getRowArray();
  }
  function   get_setortabungan($norek)
  {

    return $this->db->table('trxkastabungan')
      ->where(array('tbg_code' => $norek))
      ->orderBy('tbg_code', 'desc')
      ->limit(1)
      ->get()->getRowArray();
  }
  public function get_nopembiayaan($bulan, $tahun)
  {

    return $this->db->table('trxcashcost')
      ->where(array('kin_mont' => $bulan, 'kin_year' => $tahun))
      ->orderBy('kin_srno', 'desc')
      ->limit(1)
      ->get()->getRowArray();
  }

  public function _get_angsuran($id)
  {

    return $this->db->table('krtdebit')
      ->where(array('trx_code' => $id))
      ->orderBy('trx_angk', 'asc')
      ->limit(1)
      ->get()->getRowArray();
  }

  public function get_nosetorssb($bulan, $tahun)
  {

    return $this->db->table('trxkasssb')
      ->where(array('kin_mont' => $bulan, 'kin_year' => $tahun))
      ->orderBy('kin_srno', 'desc')
      ->limit(1)
      ->get()->getRowArray();
  }

  public function get_nopepenutupan($bulan, $tahun)
  {
    return $this->db->table('trxpenutupan')
      ->where(array('pnt_mont' => $bulan, 'pnt_year' => $tahun))
      ->orderBy('pnt_srno', 'desc')
      ->limit(1)
      ->get()->getRowArray();
  }

  public function get_acckhusus($code)
  {
    return $this->db->table('tblsetkhmdb')
      ->where(array('khs_code' => $code))
      ->limit(1)
      ->get()->getRowArray();
  }
  public function get_datagl()
  {
    return $this->db->table('akhirmdb')
      ->limit(1)
      ->get()->getRowArray();
  }

  public function get_cekaccount($xcode)
  {
    return $this->db->table('tblproduct')
      ->where(array('prd_code' => 'S002'))
      ->limit(1)
      ->get()->getRowArray();
  }

  public function get_tabungancol($bulan, $tahun)
  {
    return $this->db->table('trxtabcolhdb')
      ->where(array('tcl_mont' => $bulan, 'tcl_year' => $tahun))
      ->orderBy('tcl_srno', 'desc')
      ->limit(1)
      ->get()->getRowArray();
  }
  public function get_pembiayaancol($bulan, $tahun)
  {
    return $this->db->table('trxkascoscolhdb')
      ->where(array('ccl_mont' => $bulan, 'ccl_year' => $tahun))
      ->orderBy('ccl_srno', 'desc')
      ->limit(1)
      ->get()->getRowArray();
  }
  public function get_nohpsbukupembiayaan($bulan, $tahun)
  {
    return $this->db->table('trxhpsbkpembiayaan')
      ->where(array('hps_mont' => $bulan, 'hps_year' => $tahun))
      ->orderBy('hps_srno', 'desc')
      ->limit(1)
      ->get()->getRowArray();
  }


  function   _get_tgltabungan($id, $tanggal, $bulan, $tahun)
  {

    return $this->db->table('trxkastabungan')
      ->where(array('tbg_code' => $id, 'kin_date<=' => $tanggal, 'kin_mont' => $bulan, 'kin_year' => $tahun))
      ->orderBy('kin_srno', 'desc')
      ->limit(1)
      ->get()->getRowArray();
  }
  function   _get_tgltabungan1($id, $tanggal)
  {

    return $this->db->table('trxkastabungan')
      ->where(array('tbg_code' => $id, 'kin_date<=' => $tanggal))
      ->orderBy('kin_time', 'desc')
      ->limit(1)
      ->get()->getRowArray();
  }
  public function get_noasset($bulan, $tahun)
  {
    return $this->db->table('trxasset')
      ->where(array('ast_buln' => $bulan, 'ast_tahn' => $tahun))
      ->orderBy('ast_srno', 'desc')
      ->limit(1)
      ->get()->getRowArray();
  }

  function   get_bank($id)
  {

    return $this->db->table('tblbank')
      ->where(array('bnk_code' => $id))
      ->orderBy('bnk_code', 'desc')
      ->limit(1)
      ->get()->getRowArray();
  }
  //End----------------------
}
