<?php

namespace App\Models;

use CodeIgniter\Model;

class Core_model extends Model
{
    protected $table = 'tblanggota';
    protected $primaryKey = 'agt_numb';
    protected $allowedFields = ['agt_name', 'agt_adrs'];

    public function _get_anggota($id)
    {
        $builder = $this->db->table('tblanggota');
        $builder->select('agt_numb AS noanggota,agt_name AS nama,agt_adrs AS alamat,if(sex_code=1,"L","P") as jeniskelamin,agt_tlhr AS tempatlahir,agt_dlhr AS tgllahir,agt_phon AS telepon,agt_nktp AS noktp,IF(grd_code=0,"Insiator","Anggota Biasa") AS jenisanggotaan,agt_mail AS email,kode_cabang AS kantor,IF(agt_stat!=5,"Aktif","Tidak Aktif") AS status');
        $builder->where('agt_numb', $id);
        return $builder->get();
    }


    public function _get_petugas($cond = null)
    {
        $builder = $this->db->table('tblemployee');
        $builder->select('emp_code AS kode_petugas,emp_name AS nama_petugas,
						 emp_adrs AS alamat,emp_rekg as norek,emp_phon as nohp,
						 bnk_code as kode_kas,kode_cabang as unit_kerja');
        if(!is_null($cond))
			$builder->where($cond);
        return $builder->get();
    }

    public function _get_tabungan($id)
    {
        $builder = $this->db->table('trxtabungan');
        $builder->select('trxtabungan.tbg_code as norekening,trxtabungan.agt_numb  as no_anggota,tbg_name as nama,trxtabungan.prd_code as id_product,prd_name as nama_product,prd_smin as minimum_saldo,prd_mstr as minum_setor ,sum(kin_crdt-kin_debt) AS nil_saldo,if(tbg_stat=1,"Aktif","Tidak Aktif") as status');
        $builder->join('trxkastabungan', 'trxtabungan.tbg_code=trxkastabungan.tbg_code', 'inner');
        $builder->join('tblproduct', 'trxtabungan.prd_code=tblproduct.prd_code', 'inner');
      //  $builder->join('tblanggota', 'trxtabungan.agt_numb=tblanggota.agt_numb', 'inner');
        $builder->groupBy('trxtabungan.tbg_code,trxtabungan.agt_numb,tbg_name,trxtabungan.prd_code,prd_name,prd_smin,prd_mstr,tbg_stat');
        $builder->where('trxtabungan.agt_numb', $id);

        return $builder->get();
    }
	
	public function _cek_norektabungan($id){
		$builder = $this->db->table('trxtabungan');
		$builder->where('trxtabungan.tbg_code', $id);
		return $builder->get();
	}

    public function _get_tabunganrek($id)
    {
        $builder = $this->db->table('trxtabungan');
        $builder->select('trxtabungan.tbg_code as norekening,trxtabungan.agt_numb as no_anggota,tbg_name as nama,trxtabungan.prd_code as id_product ,prd_name as nama_product,prd_smin as minimum_saldo,prd_mstr as minum_setor ,sum(kin_crdt-kin_debt) AS nil_sald,if(tbg_stat=1,"Aktif","Tidak Aktif") as status');
        $builder->join('trxkastabungan', 'trxtabungan.tbg_code=trxkastabungan.tbg_code', 'inner');
        $builder->join('tblproduct', 'trxtabungan.prd_code=tblproduct.prd_code', 'inner');
      //  $builder->join('tblanggota', 'trxtabungan.agt_numb=tblanggota.agt_numb', 'inner');
        $builder->groupBy('trxtabungan.tbg_code,trxtabungan.agt_numb,tbg_name,trxtabungan.prd_code,prd_name,prd_smin,prd_mstr,tbg_stat');
        $builder->where('trxtabungan.tbg_code', $id);
        return $builder->get();
    }
    public function _get_simpanantrans($id)
    {
        $builder = $this->db->table('trxtabungan');
        $builder->select('trxkastabungan.kin_code as nobukti,trxtabungan.tbg_code as norekening,agt_name as nama,trxtabungan.prd_code ,prd_name nama_product,prd_smin as minimum_saldo,prd_mstr as minum_setor ,kin_awal as saldo_awal,kin_totl as jumlah, kin_akhr as saldo,kin_time as waktu');
        $builder->join('trxkastabungan', 'trxtabungan.tbg_code=trxkastabungan.tbg_code', 'inner');
        $builder->join('tblproduct', 'trxtabungan.prd_code=tblproduct.prd_code', 'inner');
        $builder->join('tblanggota', 'trxtabungan.agt_numb=tblanggota.agt_numb', 'inner');

        $builder->where('trxkastabungan.kin_code', $id);
        return $builder->get();
    }
public function _get_simpanantransppob($id)
    {
        $builder = $this->db->table('trxkastabungan');
        $builder->select('trxkastabungan.kin_code as nobukti,kin_awal as saldo_awal, kin_akhr as saldo_akhir');
       // $builder->join('trxkastabungan', 'trxtabungan.tbg_code=trxkastabungan.tbg_code', 'inner');
       // $builder->join('tblproduct', 'trxtabungan.prd_code=tblproduct.prd_code', 'inner');
       // $builder->join('tblanggota', 'trxtabungan.agt_numb=tblanggota.agt_numb', 'inner');

        $builder->where('trxkastabungan.kin_code', $id);
        return $builder->get();
    }

    public function _get_transfer($id)
    {
        $builder = $this->db->table('trxtabungan');
        $builder->select('trxkastabungan.kin_code as nobukti,trxtabungan.tbg_code as norekening,trxkastabungan.kin_pstr as rektujuan,agt_name as nama,trxtabungan.prd_code ,prd_name nama_product,prd_smin as minimum_saldo,prd_mstr as minum_setor ,kin_awal as saldo_awal,kin_totl as jumlah, kin_akhr as saldo,kin_time as waktu');
        $builder->join('trxkastabungan', 'trxtabungan.tbg_code=trxkastabungan.tbg_code', 'inner');
        $builder->join('tblproduct', 'trxtabungan.prd_code=tblproduct.prd_code', 'inner');
        $builder->join('tblanggota', 'trxtabungan.agt_numb=tblanggota.agt_numb', 'inner');

        $builder->where('trxkastabungan.kin_code', $id);
        return $builder->get();
    }

    public function saldotabungan($id)
    {
        $builder = $this->db->table('trxkastabungan');
        $builder->select('sum(kin_crdt-kin_debt) as kin_awal');
        $builder->where('trxkastabungan.tbg_code', $id);
        return $builder->get();
    }
    public function _get_pinjaman($id)
    {
        $builder = $this->db->table('trxkontrak');
        $builder->select('agt_name as nama,agt_numb as no_anggota,tblproduct.prd_code as id_produk, prd_name as nama_produk, knt_code as norek, knt_jtdt as tgl_jatuh_tempo');
        $builder->join('tblproduct', 'trxkontrak.prd_code=tblproduct.prd_code', 'inner');
        $builder->join('tblanggota', 'trxkontrak.agt_numb=tblanggota.agt_numb', 'inner');
        $builder->where('trxkontrak.agt_numb', $id);
        $query = $builder->get();
        $res = $query->getResult();
        return $res;
    }
    public function _get_pinjamanrek($id)
    {
        $builder = $this->db->table('trxkontrak');
        $builder->select('trxkontrak.agt_numb as no_anggota,agt_name as nama,agt_adrs as alamat,
							tblproduct.prd_code as id_produk, 
							prd_name as nama_produk, knt_code as norek, 
							knt_dcar as tgl_pencairan,knt_jtdt as tgl_jatuh_tempo,
							knt_totl as jumlah_pinjaman, knt_marg as suku_bunga,
							trx_sald as sisa_pinjaman,
							knt_nden as denda,
							max(trx_dhar) as jumlah_hari_tunggakan,
							CASE
								WHEN max(trx_dhar) > 30 AND max(trx_dhar) <= 90 THEN "KOL-2"
								WHEN max(trx_dhar) > 90 AND max(trx_dhar) <= 120 THEN "KOL-3"
								WHEN max(trx_dhar) > 120 AND max(trx_dhar) <= 180 THEN "KOL-4"
								WHEN max(trx_dhar) > 180 THEN "KOL-5"
								ELSE "KOL-1"
							END AS kolektibilitas
							');
        $builder->join('tblproduct', 'trxkontrak.prd_code=tblproduct.prd_code', 'inner');
        $builder->join('tblanggota', 'trxkontrak.agt_numb=tblanggota.agt_numb', 'inner');
        $builder->join('v_hari_tunggakan', 'v_hari_tunggakan.trx_code=trxkontrak.knt_code', 'inner');
        $builder->join('v_saldohutpokok', 'v_saldohutpokok.trx_code=trxkontrak.knt_code', 'inner');
        $builder->where('trxkontrak.knt_code', $id);
        $query = $builder->get();
        $res = $query->getResult();
        return $res;
    }

    public function _get_pinjamandtl($norek)
    {
        $builder = $this->db->table('krtdebit');
        $builder->select('trx_angk angsuranke,trx_jtdt jatuhtempo,trx_pokk AS pokok,trx_bung AS bunga,trx_dend AS denda,(trx_pokk+trx_bung+trx_dend) as jumlah ,IF(trx_lnsh>0,"Lunas","Belum Lunas") AS status ');
        $builder->join('tblanggota', 'krtdebit.agt_numb=tblanggota.agt_numb', 'inner');

        $builder->where('krtdebit.trx_code', $norek);
        return $builder->get()->getResult();
    }
	
	public function _get_angsuran_kartu($norek,$ke){
		$builder = $this->db->table('krtdebit');
	        $builder->select('trx_angk,lns_code,trx_pokk,trx_bung');
        	$builder->where('trx_code', $norek);
	        $builder->where('trx_angk', $ke);
        	return $builder->get()->getRow();
	}

    public function _get_pinjamantrans($id)
    {
        $builder = $this->db->table('krtdebit');
        $builder->select('trx_code as no_bukti,kin_date as tanggal,agt_name as nama,prd_name as product,trx_angk angsuranke,trx_jtdt jatuhtempo,(trx_pokk+trx_bung+trx_dend) as jumlah ');
        $builder->join('trxcashcost', 'krtdebit.lns_code=trxcashcost.kin_code', 'inner');
        $builder->join('tblanggota', 'trxcashcost.agt_numb=tblanggota.agt_numb', 'inner');
        $builder->join('tblproduct', 'trxcashcost.prd_code=tblproduct.prd_code', 'left');

        $builder->where('krtdebit.lns_code', $id);
        return $builder->get();
    }
    public function _get_mutasisimpanan($id)
    {
        $builder = $this->db->table('trxkastabungan');
        $builder->select('trxkastabungan.kin_code as notransaksi,trxkastabungan.tbg_code as norekening,kin_totl as jumlah,kin_akhr as saldo, if(kin_dbcr="K","Kredit","Debit") as jenis_transaksi,agt_name as nama,
							DATE_FORMAT(kin_time,"%Y-%m-%d %H:%i:%s") as tanggal,if(kin_jens="01","Setoran-Tunai",if(kin_jens="02","Penarikan-Tunai",if(kin_jens="03","Penutupan",""))) as keterangan');        // $builder->join('tblproduct', 'trxkastabungan.kin_type=tblproduct.prd_code', 'inner');
        $builder->join('trxtabungan', 'trxkastabungan.tbg_code=trxtabungan.tbg_code', 'inner');
        $builder->join('tblanggota', 'trxtabungan.agt_numb=tblanggota.agt_numb', 'inner');
        $builder->where('trxkastabungan.tbg_code', $id);
        $builder->where('trxkastabungan.kin_totl>', 0);
        // $builder->orderBy('kin_date', 'asc');
        $builder->orderBy('trxkastabungan.kin_code', 'asc');
        return $builder->get();   
   }

    public function _get_pembiayaan($id)
    {
        $builder = $this->db->table('v_tagihanjatuhtempo');
        $builder->select('v_tagihanjatuhtempo.agt_numb as no_anggota,v_tagihanjatuhtempo.trx_code as norek,agt_name as nama,trx_angk as tagihan_ke,trx_pokk as tagihan_pokok,trx_bung as tagihan_bunga,trx_dend as denda,tgn_pokk as tunggakan_pokok,tgn_bung as tunggakan_bunga,(trx_pokk+trx_bung+tgn_pokk+tgn_bung) as total_tagihan,(trx_pokk+tgn_pokk) as total_tagihan_pokok,(trx_bung+tgn_bung) as total_tagihan_bunga');
        $builder->join('trxkontrak', 'v_tagihanjatuhtempo.trx_code=trxkontrak.knt_code', 'inner');
        $builder->join('v_tunggakan', 'v_tagihanjatuhtempo.trx_code=v_tunggakan.trx_code', 'left');
        $builder->join('tblanggota', 'v_tagihanjatuhtempo.agt_numb=tblanggota.agt_numb', 'inner');
        $builder->join('tblproduct', 'trxkontrak.prd_code=tblproduct.prd_code', 'inner');
        $builder->where('v_tagihanjatuhtempo.trx_code', $id);
        return $builder->get();
    }

public function _get_cabang($id=null)
    {
        $builder = $this->db->table('manajemen_cabang');
        $builder->select('*');
        $builder-> where('kode_cabang', $id);
        return $builder->get();  
    }
    
    public function _get_rekpinjaman($id=null)
    {
        $builder = $this->db->table('trxkontrak');
        $builder->select('*');
        $builder-> where('knt_code', $id);
        return $builder->get();  
    }

    public function _get_jenisagunan()
    {
        $builder = $this->db->table('tbljnsagunan');
        $builder->select('jns_idno,jns_name');
        $builder-> orderBy('id','asc');
        return $builder->get(); 
    }
    
    public function _get_product($id)
    {
        $builder = $this->db->table('tblproduct');
        $builder->select('prd_code,prd_name');
        $builder-> where('prd_jens',$id);
        $builder-> orderBy('prd_code','asc');
        return $builder->get(); 
    }

    public function _get_jenisangsuran()
    {
        $builder = $this->db->table('tbljnsangsuran');
        $builder->select('ang_code as idno,ang_name as nama');
        $builder-> orderBy('ang_code','asc');
        return $builder->get(); 
    }
    public function _get_jenisbunga()
    {
        $builder = $this->db->table('tbljnsmargin');
        $builder->select('mrg_code as idno,mrg_name as nama');
        $builder-> orderBy('mrg_code','asc');
        return $builder->get(); 
    }

public function _get_pinjaman1($id)
    {
        

        $builder = $this->db->table('trxkontrak');
        
        $builder->select('trxkontrak.agt_numb as no_anggota,agt_name as nama,agt_adrs as alamat,
							tblproduct.prd_code as id_produk, 
							prd_name as nama_produk, knt_code as norek,trx_sald as sisa_pinjaman
							
							
							');
        $builder->join('tblproduct', 'trxkontrak.prd_code=tblproduct.prd_code', 'inner');
        $builder->join('tblanggota', 'trxkontrak.agt_numb=tblanggota.agt_numb', 'inner');
        // $builder->join('v_hari_tunggakan', 'v_hari_tunggakan.trx_code=trxkontrak.knt_code', 'inner');
        $builder->join('v_saldohutpokok', 'v_saldohutpokok.trx_code=trxkontrak.knt_code', 'inner');
        $builder->where('trxkontrak.knt_code', $id);
        $query = $builder->get();
        $res = $query->getResult();
        return $res;
    }

 public function _get_dtkartuhutang($id)
    {
        $builder = $this->db->table('v_saldoangsuran');
        $builder->select('v_saldoangsuran.*,agt_name,trxkontrak.prd_code,trxkontrak.tbg_code');
        $builder->join('trxkontrak', 'v_saldoangsuran.trx_code=trxkontrak.knt_code', 'inner');
        $builder->join('tblanggota', 'v_saldoangsuran.agt_numb=tblanggota.agt_numb', 'inner');
        $builder->join('tblproduct', 'trxkontrak.prd_code=tblproduct.prd_code', 'inner');
        $builder->where('trx_code', $id);
        $builder->orderBy('v_saldoangsuran.trx_angk', 'asc');
        $builder->limit(1);
        return $builder->get();
    }

public function _get_dtkartuhutang_id($id)
    {
        $builder = $this->db->table('v_saldoangsuran');
        $builder->select('v_saldoangsuran.*,agt_name,trxkontrak.prd_code,tbg_code,tblproduct.acc_code,tblproduct.acc_cod1,tblproduct.acc_cod2');
        $builder->join('trxkontrak', 'v_saldoangsuran.trx_code=trxkontrak.knt_code', 'inner');
        $builder->join('tblanggota', 'v_saldoangsuran.agt_numb=tblanggota.agt_numb', 'inner');
        $builder->join('tblproduct', 'trxkontrak.prd_code=tblproduct.prd_code', 'inner');
        $builder->where('trxkontrak.id', $id);
        $builder->orderBy('v_saldoangsuran.trx_angk', 'asc');
        $builder->limit(1);
        return $builder->get();
    }

public function _get_datatabunganab($id)
    {
        $builder = $this->db->table('trxtabungan');
        $builder->select('trxtabungan.*,agt_name,prd_name,tblproduct.acc_code,tblproduct.acc_cod1,tblproduct.acc_cod2,tblproduct.acc_cod3,grd_code');
        $builder->join('tblanggota', 'trxtabungan.agt_numb=tblanggota.agt_numb', 'left');
        $builder->join('tblproduct', 'trxtabungan.prd_code=tblproduct.prd_code', 'left');

        $builder->where('tbg_code', $id);

        return $builder->get();
    }

    public function _get_saldopinjaman($id)
    {
        $builder = $this->db->table('v_saldohutpokok');
        $builder->select('trx_sald as sisa_pinjaman');
        $builder->where('trx_code', $id);
        $query = $builder->get();
        $res = $query->getResult();
        return $res;
    }

 

}
