<?php

namespace App\Models;

use CodeIgniter\Model;

class Dashboard_model extends Model
{
    public function _get_dbanggota($tahun, $bulan)
    {
        $builder = $this->db->table('tblanggota');
        $builder->select('grd_code,YEAR(agt_jdat) AS tahun,MONTH(agt_jdat) AS bulan,IF(agt_stat=0,1,0) AS calonanggota,IF(agt_stat=1,1,0) AS aktif,IF(agt_stat=5,1,0) AS tidakaktif');
        $builder->where('YEAR(agt_jdat)', $tahun);
        $builder->where('MONTH(agt_jdat)', $bulan);
        $builder->groupBy('grd_code,YEAR(agt_jdat),MONTH(agt_jdat)');

        return $builder->get();
    }

    public function _get_dbanggotayear($tahun)
    {
        $builder = $this->db->table('tblanggota');

        $builder->select('YEAR(agt_jdat) AS tahun,MONTH(agt_jdat) AS bulan,IF(agt_stat=0,1,0) AS calonanggota,IF(agt_stat=1,1,0) AS aktif,IF(agt_stat=5,1,0) AS tidakaktif');
        // $builder->where('YEAR(agt_jdat)', $tahun);
        $builder->groupBy('YEAR(agt_jdat),MONTH(agt_jdat)');

        return $builder->get();
    }

    public function _get_dbbulan()
    {
        $builder = $this->db->table('tblbulan');
        $builder->select('*');
        // $builder->where('YEAR(agt_jdat)', $tahun);
        // $builder->groupBy('YEAR(agt_jdat),MONTH(agt_jdat)');

        return $builder->get();
    }


    public function _get_productb($id)
    {
        $builder = $this->db->table('tblproduct');
        $builder->select('*');
        $builder->where('prd_jens', $id);


        return $builder->get();
    }
    public function _get_dbskb($id, $bulan, $tahun)
    {
        $builder = $this->db->table('trxpenempatan');
        $builder->select('count(pen_code) as jum_angg,sum(pen_totl) as jum_nila');
        $builder->where('prd_code', $id);
        $builder->where('pen_mont', $bulan);
        $builder->where('pen_year', $tahun);
        return $builder->get();
    }

    public function _get_dbsimpanan($id, $bulan, $tahun)
    {
        $builder = $this->db->table('trxtabungan');
        $builder->select('count(tbg_code) as jum_angg,sum(tbg_awal) as jum_nila');
        $builder->where('prd_code', $id);
        $builder->where('tbg_mont', $bulan);
        $builder->where('tbg_year', $tahun);
        return $builder->get();
    }

    public function _get_dbpinjaman($id, $bulan, $tahun)
    {
        $builder = $this->db->table('trxkontrak');
        $builder->select('count(knt_code) as jum_angg,sum(knt_totl) as jum_nila');
        $builder->where('prd_code', $id);
        $builder->where('knt_mont', $bulan);
        $builder->where('knt_year', $tahun);
        return $builder->get();
    }
    public function _get_dbpinjamantahun($bulan, $tahun)
    {
        $builder = $this->db->table('trxkontrak');
        $builder->select('count(knt_code) as jum_angg,sum(knt_totl) as jum_nila');

        $builder->where('knt_mont', $bulan);
        $builder->where('knt_year', $tahun);
        return $builder->get();
    }

    public function _get_dbssbtahun($bulan, $tahun)
    {
        $builder = $this->db->table('trxpenempatan');
        $builder->select('count(pen_code) as jum_angg,sum(pen_totl) as jum_nila');

        $builder->where('pen_mont', $bulan);
        $builder->where('pen_year', $tahun);
        return $builder->get();
    }

    public function _get_dbsimpanantahun($bulan, $tahun)
    {
        $builder = $this->db->table('trxtabungan');
        $builder->select('count(tbg_code) as jum_angg,sum(tbg_awal) as jum_nila');

        $builder->where('tbg_mont', $bulan);
        $builder->where('tbg_year', $tahun);
        return $builder->get();
    }


    public function _get_dbanggotatahun($bulan, $tahun)
    {
        $builder = $this->db->table('tblanggota');
        $builder->select('count(agt_code) as jum_angg,sum(tbg_awal) as jum_nila');

        $builder->where('tbg_mont', $bulan);
        $builder->where('tbg_year', $tahun);
        return $builder->get();
    }

    public function _get_dblabatahun($tahun, $acc_code)
    {
        $builder = $this->db->table('accouddb');
        $builder->select('acc_akhc as jum_nila');
        $builder->where('acc_tahn', $tahun);
        $builder->where('acc_code', $acc_code);

        return $builder->get();
    }
    public function _dbgraphbulan($tahun, $bulan, $jenis)
    {
        $builder = $this->db->table('trxgraph');
        $builder->select('*');
        $builder->join('tblproduct', 'trxgraph.prd_code=tblproduct.prd_code', 'inner');
        $builder->where('grp_mont', $bulan);
        $builder->where('grp_year', $tahun);
        $builder->where('trx_jens', $jenis);
        return $builder->get();
    }
    public function _dbgraphtahun($tahun, $jenis)
    {
        $builder = $this->db->table('trxgraph');
        $builder->select('*');
        $builder->join('tblbulan', 'trxgraph.grp_mont=tblbulan.bln_cod1', 'inner');
        $builder->where('grp_year', $tahun);
        $builder->where('trx_jens', $jenis);
        return $builder->get();
    }

    public function _get_dlabatahun($tahun, $bulan, $acc_code)
    {
        $builder = $this->db->table('accouddb');
        $builder->select('*');
        $builder->where('acc_tahn', $tahun);
        $builder->where('acc_buln', $bulan);
        $builder->where('acc_code', $acc_code);
        return $builder->get();
    }
}
