<?php

namespace App\Models;

use CodeIgniter\Model;

class Model_git extends Model
{
    // start -------------------

    public function _get_pendaftaran()
    {

        $builder = $this->db->table('trxregrister');
        $builder->select('*');
        $builder->join('tblpatient', 'trxregrister.pat_code = tblpatient.pat_code', 'inner');
        $builder->join('tblcustomer', 'trxregrister.cus_code = tblcustomer.cus_code', 'inner');
        $builder->join('tblpoly', 'trxregrister.polyid = tblpoly.polyid', 'inner');
        $builder->join('tbldokter', 'trxregrister.dok_code = tbldokter.dok_code', 'inner');

        return $builder->get();
    }


    public function _get_mainmenu()
    {

        $builder = $this->db->table('tblmenu');
        $builder->select('*');
        $builder->where('mnu_main', 0);
        return $builder->get();
    }


    public function _get_submenu($id)
    {

        $builder = $this->db->table('tblmenu');
        $builder->select('*');
        $builder->where('mnu_main', $id);

        return $builder->get();
    }



    public function _get_pengajuan()
    {
        $builder = $this->db->table('trxpengajuan');
        $builder->select('*');
        $builder->join('tblanggota', 'trxpengajuan.agt_numb=tblanggota.agt_numb', 'inner');
        $builder->join('tblproduct', 'trxpengajuan.prd_code=tblproduct.prd_code', 'inner');
        return $builder->get();
    }

    public function _get_edpengajuan($id)
    {

        $builder = $this->db->table('trxpengajuan');
        $builder->select('*');
        $builder->join('tblanggota', 'trxpengajuan.agt_numb=tblanggota.agt_numb', 'inner');
        $builder->join('tblproduct', 'trxpengajuan.prd_code=tblproduct.prd_code', 'inner');
        $builder->where('png_code', $id);
        return $builder->get();
    }


    public function _get_persetujuan()
    {

        $builder = $this->db->table('trxpengajuan');
        $builder->select('png_code,trxpengajuan.agt_numb,agt_name,prd_name,png_desc,png_totl');
        $builder->join('tblproduct', 'trxpengajuan.prd_code=tblproduct.prd_code', 'left');
        $builder->join('tblanggota', 'trxpengajuan.agt_numb=tblanggota.agt_numb', 'left');
        $builder->where('png_stat', 0);
        return $builder->get();
    }



    public function _get_penutupan()
    {

        $builder = $this->db->table('trxpenutupan');
        $builder->select('*');
        $builder->join('tblproduct', 'trxpenutupan.prd_code=tblproduct.prd_code', 'left');
        $builder->join('tblanggota', 'trxpenutupan.agt_numb=tblanggota.agt_numb', 'left');
        return $builder->get();
    }

    public function _get_edpenutupan($id)
    {

        $builder = $this->db->table('trxpenutupan');
        $builder->select('*');
        $builder->join('tblanggota', 'trxpenutupan.agt_numb=tblanggota.agt_numb', 'inner');
        $builder->join('tblproduct', 'trxpenutupan.prd_code=tblproduct.prd_code', 'inner');
        $builder->where('pnt_code', $id);
        return $builder->get();
    }

    public function m_deletepenutupan($id)
    {

        $query = $this->db->table('trxpenutupan')->delete(array('pnt_code' => $id));

        return $query;
    }

    public function _get_penempatan($tanggal, $cabang)
    {

        $builder = $this->db->table('trxpenempatan');
        $builder->select('*');
        $builder->join('tblanggota', 'trxpenempatan.agt_numb=tblanggota.agt_numb', 'inner');
        $builder->join('tblproduct', 'trxpenempatan.prd_code=tblproduct.prd_code', 'inner');
        $builder->where('pen_date', $tanggal);
        $builder->where('pen_stat<', 2);
        $builder->where('trxpenempatan.kode_cabang', $cabang);
        return $builder->get();
    }


    public function _get_edpenempatan($id)
    {

        $builder = $this->db->table('trxpenempatan');
        $builder->select('*');
        $builder->join('tblanggota', 'trxpenempatan.agt_numb=tblanggota.agt_numb', 'inner');
        $builder->join('tblproduct', 'trxpenempatan.prd_code=tblproduct.prd_code', 'inner');
        $builder->where('pen_code', $id);
        return $builder->get();
    }

    public function _get_margin($id, $waktu)
    {

        $builder = $this->db->table('tblmarginproduct');
        $builder->select('*');
        $builder->join('tbljangkawaktu', 'tblmarginproduct.jnk_idno=tbljangkawaktu.id');
        $builder->where('prd_code', $id);
        $builder->where('jnk_idno', $waktu);
        return $builder->get();
    }

    public function _get_product($id)
    {

        $builder = $this->db->table('tblmarginproduct');
        $builder->select('*');
        $builder->join('tbljangkawaktu', 'tblmarginproduct.jnk_idno=tbljangkawaktu.id');
        $builder->where('prd_code', $id);

        return $builder->get();
    }


    public function _get_productid($id)
    {

        $builder = $this->db->table('tblproduct');
        $builder->select('*');

        $builder->where('prd_code', $id);

        return $builder->get();
    }
    public function _get_anggota($id)
    {

        $builder = $this->db->table('tblanggota');
        $builder->select('tblanggota.agt_numb,agt_name,grd_plat,saldo,grd_smpk,grd_smwa,grd_skrl,grd_lain,agt_adrs');
        $builder->join('tblgrade', 'tblanggota.grd_code=tblgrade.grd_code', 'left');
        $builder->join('v_saldohutang', 'tblanggota.agt_numb=v_saldohutang.agt_numb', 'left');
        $builder->where('tblanggota.agt_numb', $id);
        // $builder->where('tblanggota.agt_stat', 1);
        return $builder->get();
    }


    public function _get_lpengajuan()
    {

        $builder = $this->db->table('trxpengajuan');
        $builder->select('*');
        $builder->join('tblproduct', 'trxpengajuan.prd_code=tblproduct.prd_code', 'left');
        $builder->join('tblanggota', 'trxpengajuan.agt_numb=tblanggota.agt_numb', 'left');
        $builder->where('png_stat', 1);
        $builder->where('png_kntr', 0);
        return $builder->get();
    }


    public function _get_kontrakl($tanggal, $cabang)
    {

        $builder = $this->db->table('trxkontrak');
        $builder->select('*');
        $builder->join('tblproduct', 'trxkontrak.prd_code=tblproduct.prd_code', 'left');
        $builder->join('tblanggota', 'trxkontrak.agt_numb=tblanggota.agt_numb', 'left');
        $builder->where('trxkontrak.knt_date', $tanggal);
        $builder->where('trxkontrak.kode_cabang', $cabang);
        return $builder->get();
    }

    public function _get_kontrakla($tanggal)
    {

        $builder = $this->db->table('trxkontrak');
        $builder->select('*');
        $builder->join('tblproduct', 'trxkontrak.prd_code=tblproduct.prd_code', 'left');
        $builder->join('tblanggota', 'trxkontrak.agt_numb=tblanggota.agt_numb', 'left');
        $builder->where('trxkontrak.knt_date', $tanggal);
        return $builder->get();
    }
    public function _get_kontrak()
    {
        $builder = $this->db->table('trxkontrak');
        $builder->select('*');
        $builder->join('tblproduct', 'trxkontrak.prd_code=tblproduct.prd_code', 'left');
        $builder->join('tblanggota', 'trxkontrak.agt_numb=tblanggota.agt_numb', 'left');
        return $builder->get();
    }
    public function _get_edkontrak($id)
    {

        $builder = $this->db->table('trxkontrak');
        $builder->select('*');
        $builder->join('tblproduct', 'trxkontrak.prd_code=tblproduct.prd_code', 'left');
        $builder->join('tblanggota', 'trxkontrak.agt_numb=tblanggota.agt_numb', 'left');
        $builder->join('tblbungatype', 'trxkontrak.bng_type=tblbungatype.bng_type', 'left');
        $builder->join('tblcompany', 'trxkontrak.com_code=tblcompany.com_code', 'left');
        $builder->join('tblemployee', 'trxkontrak.emp_code=tblemployee.emp_code', 'left');
        $builder->join('tblkelompok', 'trxkontrak.kel_code=tblkelompok.kel_code', 'left');


        $builder->where('knt_code', $id);
        return $builder->get();
    }

    public function _get_kartu($id)
    {

        $builder = $this->db->table('trxkontrakk');
        $builder->select('trxkontrakk.*,tblcompany.*,agt_name,trxkontrak.agt_numb,trxkontrak.knt_marg,knt_tenr,prd_name,knt_days,trxkontrak.knt_jtdt as due_date,trxkontrak.knt_totl');
        $builder->join('trxkontrak', 'trxkontrakk.knt_code=trxkontrak.knt_code', 'left');
        $builder->join('tblanggota', 'trxkontrak.agt_numb=tblanggota.agt_numb', 'left');
        $builder->join('tblcompany', 'trxkontrak.com_code=tblcompany.com_code', 'left');
        $builder->join('tblproduct', 'trxkontrak.prd_code=tblproduct.prd_code', 'left');

        $builder->where('trxkontrakk.knt_code', $id);
        return $builder->get();
    }

    public function _getbank()
    {
        $builder = $this->db->table('tblbank');
        $builder->select('*');
        $builder->orderBy('bnk_code', 'asc');
        return $builder->get();
    }
    public function _getbank_cab($id)
    {
        $builder = $this->db->table('tblbank');
        $builder->select('*');
        $builder->where('kode', $id);
        // $builder->like('bnk_name', 'teller', 'both');
        $builder->orderBy('bnk_code', 'asc');
        return $builder->get();
    }
    public function _getanggotac()
    {
        $builder = $this->db->table('trxkontrak');
        $builder->select('trxkontrak.agt_numb,agt_name');
        $builder->join('tblanggota', 'trxkontrak.agt_numb=tblanggota.agt_numb', 'inner');
        $builder->where('knt_stat', 0);
        return $builder->get();
    }


    public function _getanggotap()
    {
        $builder = $this->db->table('trxpenutupan');
        $builder->select('trxpenutupan.agt_numb,agt_name');
        $builder->join('tblanggota', 'trxpenutupan.agt_numb=tblanggota.agt_numb', 'inner');
        $builder->where('pnt_cair', 0);
        return $builder->get();
    }
    public function _get_pembiayaan($id)
    {
        $builder = $this->db->table('trxkontrak');
        $builder->select('*');
        $builder->join('tblproduct', 'trxkontrak.prd_code=tblproduct.prd_code', 'inner');
        $builder->join('tblanggota', 'trxkontrak.agt_numb=tblanggota.agt_numb', 'inner');
        $builder->where('knt_code', $id);
        $builder->where('knt_cair', 0);
        return $builder->get();
    }

    public function _get_pembiayaan_id($id)
    {
        $builder = $this->db->table('trxkontrak');
        $builder->select('*');
        $builder->join('tblproduct', 'trxkontrak.prd_code=tblproduct.prd_code', 'inner');
        $builder->join('tblanggota', 'trxkontrak.agt_numb=tblanggota.agt_numb', 'inner');
        $builder->where('trxkontrak.id', $id);
        $builder->where('knt_cair', 0);
        return $builder->get();
    }
    public function _get_cashout($tanggal, $cabang)
    {
        $builder = $this->db->table('trxpencairan');
        $builder->select('*');
        $builder->join('tblanggota', 'trxpencairan.agt_numb=tblanggota.agt_numb', 'left');
        $builder->join('tblbank', 'trxpencairan.bnk_code=tblbank.bnk_code', 'inner');
        $builder->where('kot_date', $tanggal);
        $builder->where('trxpencairan.kode_cabang', $cabang);

        return $builder->get();
    }
    public function _get_cashoutn($tanggal)
    {
        $builder = $this->db->table('trxpencairan');
        $builder->select('*');
        $builder->join('tblanggota', 'trxpencairan.agt_numb=tblanggota.agt_numb', 'left');
        $builder->join('tblbank', 'trxpencairan.bnk_code=tblbank.bnk_code', 'inner');
        $builder->where('kot_date', $tanggal);
        return $builder->get();
    }
    public function _get_edcashout($id)
    {

        $builder = $this->db->table('trxpencairan');
        $builder->select('*');
        $builder->join('trxpencairandtl', 'trxpencairan.kot_code=trxpencairandtl.kot_code', 'left');
        // $builder->join('tblanggota', 'trxpencairan.agt_numb=tblanggota.agt_numb', 'left');
        $builder->join('tblbank', 'trxpencairan.bnk_code=tblbank.bnk_code', 'left');
        $builder->join('kodetransteller', 'trxpencairandtl.kode_trans=kodetransteller.kode_trans', 'left');
        $builder->where('trxpencairan.kot_code', $id);
        return $builder->get();
    }

    public function _get_edcashoutd($id)
    {

        $builder = $this->db->table('trxpencairandtl');
        $builder->select('*');
        $builder->where('kot_code', $id);
        return $builder->get();
    }

    public function _get_cashin($tanggal)
    {

        $builder = $this->db->table('trxcashcost');
        $builder->select('*');
        $builder->join('tblanggota', 'trxcashcost.agt_numb=tblanggota.agt_numb', 'left');
        $builder->join('tblbank', 'trxcashcost.bnk_code=tblbank.bnk_code', 'left');
        $builder->where('kin_tran', 0);
        $builder->where('trxcashcost.kin_date', $tanggal);
        // $builder->where('trxcashcost.kode_cabang', $cabang);
        return $builder->get();
    }
    public function _get_cashincab($tanggal, $cabang)
    {

        $builder = $this->db->table('trxcashcost');
        $builder->select('*');
        $builder->join('tblanggota', 'trxcashcost.agt_numb=tblanggota.agt_numb', 'left');
        $builder->join('tblbank', 'trxcashcost.bnk_code=tblbank.bnk_code', 'left');
        $builder->where('kin_tran', 0);
        $builder->where('trxcashcost.kin_date', $tanggal);
        $builder->where('trxcashcost.kode_cabang', $cabang);
        return $builder->get();
    }
    public function _get_cashinumum($tanggal)
    {

        $builder = $this->db->table('trxsetorhdb');
        $builder->select('*');
        $builder->join('tblanggota', 'trxsetorhdb.agt_numb=tblanggota.agt_numb', 'left');
        $builder->join('tblbank', 'trxsetorhdb.bnk_code=tblbank.bnk_code', 'left');
        $builder->where('trxsetorhdb.kin_jens>=', '01');
        $builder->where('trxsetorhdb.kin_jens<=', '02');
        $builder->where('trxsetorhdb.kin_date', $tanggal);

        return $builder->get();
    }
    public function _get_cashinumumcab($tanggal, $cabang)
    {

        $builder = $this->db->table('trxsetorhdb');
        $builder->select('*');
        $builder->join('tblanggota', 'trxsetorhdb.agt_numb=tblanggota.agt_numb', 'left');
        $builder->join('tblbank', 'trxsetorhdb.bnk_code=tblbank.bnk_code', 'left');
        $builder->where('trxsetorhdb.kin_jens>=', '01');
        $builder->where('trxsetorhdb.kin_jens<=', '02');
        $builder->where('trxsetorhdb.kin_date', $tanggal);
        $builder->where('trxsetorhdb.kode_cabang', $cabang);
        return $builder->get();
    }
    public function _get_cashinumua($tanggal)
    {

        $builder = $this->db->table('trxsetorhdb');
        $builder->select('*');
        $builder->join('tblanggota', 'trxsetorhdb.agt_numb=tblanggota.agt_numb', 'left');
        $builder->join('tblbank', 'trxsetorhdb.bnk_code=tblbank.bnk_code', 'left');
        $builder->where('trxsetorhdb.kin_jens>=', '01');
        $builder->where('trxsetorhdb.kin_jens<=', '02');
        $builder->where('trxsetorhdb.kin_date', $tanggal);

        return $builder->get();
    }
    public function _editsetoranumum($id)
    {

        $builder = $this->db->table('trxsetorhdb');
        $builder->select('*');
        $builder->join('tblanggota', 'trxsetorhdb.agt_numb=tblanggota.agt_numb', 'left');
        $builder->join('tblbank', 'trxsetorhdb.bnk_code=tblbank.bnk_code', 'left');
        $builder->join('tblproduct', 'trxsetorhdb.kin_type=tblproduct.prd_code', 'left');
        // $builder->where('trxsetorhdb.kin_type!=', '07');
        $builder->where('kin_code', $id);
        return $builder->get();
    }

    public function _get_lkontrak()
    {
        $builder = $this->db->table('v_saldohutang1');
        $builder->select('*');
        $builder->join('trxkontrak', 'v_saldohutang1.trx_code=trxkontrak.knt_code', 'inner');
        $builder->join('tblanggota', 'trxkontrak.agt_numb=tblanggota.agt_numb', 'inner');
        $builder->join('tblproduct', 'trxkontrak.prd_code=tblproduct.prd_code', 'inner');
        $builder->where('trxkontrak.knt_stat<', '2');
        $builder->where('v_saldohutang1.saldo>', 0);
        return $builder->get();
    }

    public function _get_lkontrakfind($start, $length, $search = '')
    {

        $builder = $this->db->table('trxkontrak');
        $builder->select('trxkontrak.*,agt_name,prd_name');
        // $builder->join('trxkontrak', 'v_saldohutang1.trx_code=trxkontrak.knt_code', 'inner');
        $builder->join('tblanggota', 'trxkontrak.agt_numb=tblanggota.agt_numb', 'inner');
        $builder->join('tblproduct', 'trxkontrak.prd_code=tblproduct.prd_code', 'inner');
        $builder->where('trxkontrak.knt_stat<', '2');
        // $builder->where('v_saldohutang1.saldo>', 0);
        $recordsTotal = $builder->countAllResults(false);
        //echo $length;
        $builder->limit($length, $start);
        $builder->orderBy('knt_code', 'asc');
        if ($search != '') {
            $builder->like('agt_name', $search);
            $builder->orLike(
                'prd_name',
                $search
            );
            $builder->orLike(
                'knt_code',
                $search
            );
        }
        $recordsFiltered = $builder->countAllResults(false);
        return array('recordsTotal' => $recordsTotal, 'recordsFiltered' => $recordsFiltered, 'data' => $builder->get()->getResult());
    }
    public function _get_gkontrak()
    {

        $builder = $this->db->table('trxkontrak');
        $builder->select('*');
        $builder->join('tblanggota', 'trxkontrak.agt_numb=tblanggota.agt_numb', 'left');
        $builder->where('knt_stat<', 2);
        return $builder->get();
    }
    public function _get_gkontrakcab($cabang)
    {

        $builder = $this->db->table('trxkontrak');
        $builder->select('*');
        $builder->join('tblanggota', 'trxkontrak.agt_numb=tblanggota.agt_numb', 'left');
        $builder->where('knt_stat<', 2);
        $builder->where('trxkontrak.kode_cabang', $cabang);
        return $builder->get();
    }
    public function _get_kartuhutang($id)
    {
        $builder = $this->db->table('v_saldoangsuran');
        $builder->select('v_saldoangsuran.*,agt_name,trxkontrak.prd_code');
        $builder->join('trxkontrak', 'v_saldoangsuran.trx_code=trxkontrak.knt_code', 'inner');
        $builder->join('tblanggota', 'v_saldoangsuran.agt_numb=tblanggota.agt_numb', 'inner');
        $builder->where('trx_code', $id);
        $builder->orderBy('v_saldoangsuran.trx_angk', 'asc');

        return $builder->get();
    }
    public function _get_dtkartuhutang($id)
    {
        $builder = $this->db->table('v_saldoangsuran');
        $builder->select('v_saldoangsuran.*,agt_name,trxkontrak.prd_code,trxkontrak.tbg_code');
        $builder->join('trxkontrak', 'v_saldoangsuran.trx_code=trxkontrak.knt_code', 'inner');
        $builder->join('tblanggota', 'v_saldoangsuran.agt_numb=tblanggota.agt_numb', 'inner');
        $builder->join('tblproduct', 'trxkontrak.prd_code=tblproduct.prd_code', 'inner');
        $builder->where('trx_code', $id);
        $builder->orderBy('v_saldoangsuran.trx_angk', 'asc');
        $builder->limit(1);
        return $builder->get();
    }

    public function _get_dtkartuhutang_id($id)
    {
        $builder = $this->db->table('v_saldoangsuran');
        $builder->select('v_saldoangsuran.*,agt_name,trxkontrak.prd_code,tbg_code');
        $builder->join('trxkontrak', 'v_saldoangsuran.trx_code=trxkontrak.knt_code', 'inner');
        $builder->join('tblanggota', 'v_saldoangsuran.agt_numb=tblanggota.agt_numb', 'inner');
        $builder->join('tblproduct', 'trxkontrak.prd_code=tblproduct.prd_code', 'inner');
        $builder->where('trxkontrak.id', $id);
        $builder->orderBy('v_saldoangsuran.trx_angk', 'asc');
        $builder->limit(1);
        return $builder->get();
    }
    public function _get_kartuhutangcol($id)
    {
        $builder = $this->db->table('v_saldoangsuran');
        $builder->select('v_saldoangsuran.*,agt_name');
        $builder->join('tblanggota', 'v_saldoangsuran.agt_numb=tblanggota.agt_numb', 'inner');

        // $builder->where('col_code', $id);
        return $builder->get();
    }
    public function _get_periode1($id)
    {

        $builder = $this->db->table('tbljangkawaktu');
        $builder->select('*');
        $builder->join('tblmarginproduct', 'tbljangkawaktu.id=tblmarginproduct.jnk_idno', 'inner');
        $builder->where('prd_code', $id);

        return $builder->get();
    }


    public function m_deletepenempatan($id)
    {

        $query = $this->db->table('trxpenempatan')->delete(array('pen_code' => $id));

        return $query;
    }

    public function _get_sertifikat()
    {

        $builder = $this->db->table('trxpenempatan');
        $builder->select('*');
        $builder->where('pen_stat', 0);
        return $builder->get();
    }

    public function _get_sertifikatdtl($id)
    {

        $builder = $this->db->table('trxpenempatan');
        $builder->select('*');
        $builder->join('tblanggota', 'trxpenempatan.agt_numb=tblanggota.agt_numb', 'inner');
        $builder->join('tblproduct', 'trxpenempatan.prd_code=tblproduct.prd_code', 'inner');
        $builder->where('pen_code', $id);
        return $builder->get();
    }

    public function _get_simpanancair($id)
    {
        $builder = $this->db->table('trxpenutupan');
        $builder->select('*');
        $builder->join('tblanggota', 'trxpenutupan.agt_numb=tblanggota.agt_numb', 'inner');
        $builder->join('tblproduct', 'trxpenutupan.prd_code=tblproduct.prd_code', 'inner');
        $builder->where('pnt_cair', 0);
        return $builder->get();
    }

    public function _accbank($id)
    {
        $builder = $this->db->table('tblbank');
        $builder->select('acc_code');
        $builder->where('bnk_code', $id);
        return $builder->get();
    }

    public function _acckhusus($id)
    {
        $builder = $this->db->table('tblsetkhmdb');
        $builder->select('acc_code');
        $builder->where('khs_code', $id);
        return $builder->get();
    }


    public function _delcashout($id)
    {

        $query = $this->db->table('trxpencairan')->delete(array('kot_code' => $id));
        $query = $this->db->table('trxpencairandtl')->delete(array('kot_code' => $id));

        return $query;
    }

    public function _get_account()
    {
        $builder = $this->db->table('tblaccount');
        $builder->select('acc_code,acc_name');
        $builder->where('acc_dtum', 'D');
        return $builder->get();
    }

    public function _get_acccode($id)
    {
        $builder = $this->db->table('tblaccount');
        $builder->select('acc_code');
        $builder->where('id', $id);
        return $builder->get();
    }
    public function _get_jurnal($tanggal, $cabang)
    {
        $builder = $this->db->table('trxjourhdr');
        $builder->select('*');
        $builder->where('trx_date', $tanggal);
        $builder->where('trxjourhdr.kode_cabang', $cabang);
        return $builder->get();
    }

    public function _get_jurnalcab($tanggal, $cabang)
    {
        $builder = $this->db->table('trxjourhdr');
        $builder->select('*');
        $builder->where('trx_date', $tanggal);
        $builder->where('trxjourhdr.kode_cabang', $cabang);
        return $builder->get();
    }
    public function _get_edjurnalumum($id)
    {
        $builder = $this->db->table('trxjourhdr');
        $builder->select('*');
        $builder->join('trxjourdtl', 'trxjourhdr.trx_code=trxjourdtl.trx_code', 'inner');
        $builder->join('tblaccount', 'trxjourdtl.acc_code=tblaccount.acc_code', 'inner');
        $builder->join('tblcoscentre', 'trxjourdtl.psb_code=tblcoscentre.id', 'left');
        $builder->where('trxjourhdr.trx_code', $id);
        return $builder->get();
    }

    public function _get_costcenter()
    {
        $builder = $this->db->table('tblcoscentre');
        $builder->select('*');
        return $builder->get();
    }


    public function _get_coa()
    {
        $builder = $this->db->table('tblaccount');
        $builder->select('*');
        $builder->join('tblaccklas', 'tblaccount.acc_klas=tblaccklas.acc_klas', 'inner');
        $builder->orderBy('acc_code', 'ASC');
        return $builder->get();
    }

    public function _kontrakopen($id)
    {
        $builder = $this->db->table('v_saldohutpokok');
        $builder->select('*');
        $builder->where('trx_sald!=', 0);
        // $builder->where('trx_sald!=',0);
        return $builder->get();
    }
    public function _accproductp($id)
    {
        $builder = $this->db->table('trxkontrak');
        $builder->select('acc_code');
        $builder->join('tblproduct', 'trxkontrak.prd_code=tblproduct.prd_code', 'inner');
        $builder->where('knt_code', $id);

        return $builder->get();
    }

    public function _accproduct($id)
    {
        $builder = $this->db->table('tblproduct');
        $builder->select('acc_code');
        $builder->where('prd_code', $id);

        return $builder->get();
    }
    public function _get_coa1($id)
    {
        $builder = $this->db->table('tblaccount');
        $builder->select('*');
        $builder->where('acc_umum', $id);
        $builder->orderBy('acc_code', 'desc');
        $builder->limit('1');
        return $builder->get();
    }

    public function _get_coa2($id)
    {
        $builder = $this->db->table('tblaccount');
        $builder->select('*');
        $builder->where('acc_code', $id);
        $builder->orderBy('acc_code', 'desc');
        $builder->limit('1');
        return $builder->get();
    }



    public function _get_coaedit($id)
    {
        $builder = $this->db->table('tblaccount');
        $builder->select('*');
        $builder->where('acc_code', $id);
        $builder->limit('1');
        return $builder->get();
    }
    public function _get_jurnalulang()
    {
        $builder = $this->db->table('trxjrechdr');
        $builder->select('*');
        return $builder->get();
    }
    public function _get_edjurnalulang($id)
    {
        $builder = $this->db->table('trxjrechdr');
        $builder->select('*');
        $builder->join('trxjrecdtl', 'trxjrechdr.jrc_code=trxjrecdtl.jrc_code', 'inner');
        $builder->join('tblaccount', 'trxjrecdtl.acc_code=tblaccount.acc_code', 'inner');
        $builder->join('tblcoscentre', 'trxjrecdtl.psb_code=tblcoscentre.id', 'left');
        $builder->where('trxjrechdr.jrc_code', $id);
        return $builder->get();
    }
    public function _list_tabungan()
    {
        $builder = $this->db->table('trxtabungan');
        $builder->select('tbg_code');

        return $builder->get();
    }
    public function _get_tabungan($tanggal, $cabang)
    {
        $builder = $this->db->table('trxtabungan');
        $builder->select('*');
        $builder->join('tblanggota', 'trxtabungan.agt_numb=tblanggota.agt_numb', 'inner');
        $builder->join('tblproduct', 'trxtabungan.prd_code=tblproduct.prd_code', 'inner');
        $builder->where('tbg_date', $tanggal);
        $builder->where('trxtabungan.tbg_stat<', 2);
        $builder->where('trxtabungan.kode_cabang', $cabang);
        return $builder->get();
    }
    public function _get_tabungana($tanggal)
    {
        $builder = $this->db->table('trxtabungan');
        $builder->select('*');
        $builder->join('tblanggota', 'trxtabungan.agt_numb=tblanggota.agt_numb', 'inner');
        $builder->join('tblproduct', 'trxtabungan.prd_code=tblproduct.prd_code', 'inner');
        $builder->where('tbg_date', $tanggal);
        $builder->where('trxtabungan.tbg_stat<', 2);
        return $builder->get();
    }
    public function _get_tabungan1($cabang)
    {
        $builder = $this->db->table('trxtabungan');
        $builder->select('*');
        $builder->join('tblanggota', 'trxtabungan.agt_numb=tblanggota.agt_numb', 'inner');
        $builder->join('tblproduct', 'trxtabungan.prd_code=tblproduct.prd_code', 'inner');
        $builder->where('trxtabungan.kode_cabang', $cabang);
        $builder->where('trxtabungan.tbg_stat<', 2);
        return $builder->get();
    }
    public function _get_edtabungan($id)
    {
        $builder = $this->db->table('trxtabungan');
        $builder->select('*');
        $builder->join('tblanggota', 'trxtabungan.agt_numb=tblanggota.agt_numb', 'inner');
        $builder->join('tblproduct', 'trxtabungan.prd_code=tblproduct.prd_code', 'inner');
        $builder->join('tblkelompok', 'trxtabungan.kel_code=tblkelompok.kel_code', 'left');
        $builder->join('tblemployee', 'trxtabungan.col_code=tblemployee.emp_code', 'left');
        $builder->where('trxtabungan.id', $id);

        return $builder->get();
    }
    public function _get_dtabunganid($id)
    {
        $builder = $this->db->table('trxtabungan');
        $builder->select('*');
        $builder->join('tblanggota', 'trxtabungan.agt_numb=tblanggota.agt_numb', 'inner');
        $builder->join('tblproduct', 'trxtabungan.prd_code=tblproduct.prd_code', 'inner');
        $builder->where('trxtabungan.id', $id);

        return $builder->get();
    }
    public function _get_dtabungan($id)
    {
        $builder = $this->db->table('trxtabungan');
        $builder->select('trxtabungan.*,prd_name,tblproduct.acc_code,tblproduct.acc_cod1,tblproduct.acc_cod2,tblanggota.agt_name');
        $builder->join('tblanggota', 'trxtabungan.agt_numb=tblanggota.agt_numb', 'inner');
        $builder->join('tblproduct', 'trxtabungan.prd_code=tblproduct.prd_code', 'inner');

        $builder->where('tbg_code', $id);

        return $builder->get();
    }
    public function _get_dttabungan()
    {
        $builder = $this->db->table('trxtabungan');
        $builder->select('trxtabungan.*,prd_name,tblproduct.acc_code,tblproduct.acc_cod1,tblproduct.acc_cod2,tblanggota.agt_name');
        $builder->join('tblanggota', 'trxtabungan.agt_numb=tblanggota.agt_numb', 'inner');
        $builder->join('tblproduct', 'trxtabungan.prd_code=tblproduct.prd_code', 'inner');
        $builder->where('trxtabungan.tbg_stat<', 2);
        // $builder->where('tbg_code', $id);

        return $builder->get();
    }
    public function _get_setortabungan($tanggal, $cabang, $id)
    {

        $builder = $this->db->table('trxkastabungan');
        $builder->select('*');
        $builder->join('tblanggota', 'trxkastabungan.agt_numb=tblanggota.agt_numb', 'inner');
        $builder->join('tblbank', 'trxkastabungan.bnk_code=tblbank.bnk_code', 'left');
        $builder->join('tblproduct', 'trxkastabungan.kin_type=tblproduct.prd_code', 'left');
        $builder->where('trxkastabungan.trx_jens', $id);
        $builder->where('trxkastabungan.kin_date', $tanggal);
        $builder->where('trxkastabungan.kode_cabang', $cabang);

        return $builder->get();
    }
    public function _get_setortabungana($tanggal, $id)
    {

        $builder = $this->db->table('trxkastabungan');
        $builder->select('*');
        $builder->join('trxtabungan', 'trxkastabungan.tbg_code=trxtabungan.tbg_code', 'inner');
        $builder->join('tblanggota', 'trxkastabungan.agt_numb=tblanggota.agt_numb', 'inner');
        $builder->join('tblbank', 'trxkastabungan.bnk_code=tblbank.bnk_code', 'inner');
        $builder->join('tblproduct', 'trxkastabungan.kin_type=tblproduct.prd_code', 'inner');
        $builder->where('trxkastabungan.trx_jens', $id);
        $builder->where('trxkastabungan.kin_date', $tanggal);

        return $builder->get();
    }
    public function _get_dtsetortabungan($tgl1, $tgl2)
    {

        $builder = $this->db->table('trxkastabungan');
        $builder->select('*');
        $builder->join('tblanggota', 'trxkastabungan.agt_numb=tblanggota.agt_numb', 'left');
        // $builder->join('tblbank', 'trxkastabungan.bnk_code=tblbank.bnk_code', 'left');
        // $builder->join('tblproduct', 'trxkastabungan.kin_type=tblproduct.prd_code', 'left');
        $builder->where('trxkastabungan.kin_date>=', $tgl1);
        $builder->where('trxkastabungan.kin_date<=', $tgl2);
        $builder->orderBy('kin_code', 'asc');
        return $builder->get();
    }
    public function _get_edsetortabungan($id)
    {

        $builder = $this->db->table('trxkastabungan');
        $builder->select('*');
        $builder->join('tblanggota', 'trxkastabungan.agt_numb=tblanggota.agt_numb', 'left');
        $builder->join('tblbank', 'trxkastabungan.bnk_code=tblbank.bnk_code', 'left');
        $builder->join('tblproduct', 'trxkastabungan.kin_type=tblproduct.prd_code', 'left');
        $builder->where('kin_code', $id);

        return $builder->get();
    }




    public function _get_rektabungan()
    {
        $builder = $this->db->table('trxtabungan');
        $builder->select('*');
        $builder->join('tblanggota', 'trxtabungan.agt_numb=tblanggota.agt_numb', 'left');
        $builder->join('tblproduct', 'trxtabungan.prd_code=tblproduct.prd_code', 'left');
        $builder->where('tbg_stat<', 2);

        return $builder->get();
    }
    public function _get_datatabunganab($id)
    {
        $builder = $this->db->table('trxtabungan');
        $builder->select('trxtabungan.*,agt_name,prd_name,tblproduct.acc_code,tblproduct.acc_cod1,tblproduct.acc_cod2,tblproduct.acc_cod3');
        $builder->join('tblanggota', 'trxtabungan.agt_numb=tblanggota.agt_numb', 'left');
        $builder->join('tblproduct', 'trxtabungan.prd_code=tblproduct.prd_code', 'left');

        $builder->where('tbg_code', $id);

        return $builder->get();
    }
    public function _get_datatabungan($id)
    {
        $builder = $this->db->table('trxtabungan');
        $builder->select('*');
        $builder->join('tblanggota', 'trxtabungan.agt_numb=tblanggota.agt_numb', 'left');
        $builder->join('tblproduct', 'trxtabungan.prd_code=tblproduct.prd_code', 'inner');
        $builder->where('tbg_code', $id);

        return $builder->get();
    }
    public function _get_datatabunganlist($id)
    {
        $builder = $this->db->table('trxtabungan');
        $builder->select('trxtabungan.*,agt_name,agt_adrs,tblproduct.*');
        $builder->join('tblanggota', 'trxtabungan.agt_numb=tblanggota.agt_numb', 'inner');
        $builder->join('tblproduct', 'trxtabungan.prd_code=tblproduct.prd_code', 'inner');
        $builder->where('trxtabungan.id', $id);

        return $builder->get();
    }
    public function _get_dttabungancab($id)
    {
        $builder = $this->db->table('trxtabungan');
        $builder->select('*');
        $builder->join('tblanggota', 'trxtabungan.agt_numb=tblanggota.agt_numb', 'left');
        $builder->join('tblproduct', 'trxtabungan.prd_code=tblproduct.prd_code', 'left');
        $builder->where('trxtabungan.kode_cabang', $id);

        return $builder->get();
    }


    public function _get_datassb($id)
    {
        $builder = $this->db->table('trxpenempatan');
        $builder->select('*');
        $builder->join('tblanggota', 'trxpenempatan.agt_numb=tblanggota.agt_numb', 'left');
        $builder->join('tblproduct', 'trxpenempatan.prd_code=tblproduct.prd_code', 'left');
        $builder->where('pen_code', $id);

        return $builder->get();
    }

    public function _get_datassb_id($id)
    {
        $builder = $this->db->table('trxpenempatan');
        $builder->select('*');
        $builder->join('tblanggota', 'trxpenempatan.agt_numb=tblanggota.agt_numb', 'left');
        $builder->join('tblproduct', 'trxpenempatan.prd_code=tblproduct.prd_code', 'left');
        $builder->where('trxpenempatan.id', $id);

        return $builder->get();
    }
    public function get_nilsimpanan($tahun)
    {
        $builder = $this->db->table('trxsetorhdb');
        $builder->select('sum(kin_stot) as tot_simp');
        $builder->where('kin_year<=', $tahun);

        return $builder->get();
    }

    public function get_niltabungan($tahun)
    {
        $builder = $this->db->table('trxkastabungan');
        $builder->select('sum(kin_crdt-kin_debt) as tot_tabs');
        $builder->where('kin_year<=', $tahun);

        return $builder->get();
    }

    public function get_nilpinjaman($tahun)
    {
        $builder = $this->db->table('krtdebit');
        $builder->select('sum(trx_pokk-lns_pokk) as tot_pinj');
        $builder->where('year(trx_date)<=', $tahun);

        return $builder->get();
    }

    public function get_nilsimpanan_agt($tahun, $noanggota)
    {
        $builder = $this->db->table('trxsetorhdb');
        $builder->select('sum(kin_stot) as tot_simp');
        $builder->where('kin_year<=', $tahun);
        $builder->where('agt_numb', $noanggota);
        return $builder->get();
    }

    public function get_niltabungan_agt($tahun, $noanggota)
    {
        $builder = $this->db->table('trxkastabungan');
        $builder->select('sum(kin_crdt-kin_debt) as tot_tabs');
        $builder->where('kin_year<=', $tahun);
        $builder->where('agt_numb', $noanggota);

        return $builder->get();
    }

    public function get_nilpinjaman_agt($tahun, $noanggota)
    {
        $builder = $this->db->table('krtdebit');
        $builder->select('sum(trx_pokk-lns_pokk) as tot_pinj');
        $builder->where('year(trx_date)<=', $tahun);
        $builder->where('agt_numb', $noanggota);
        return $builder->get();
    }

    public function get_anggota1()
    {
        $builder = $this->db->table('tblanggota');
        $builder->select('agt_numb,agt_name');
        $builder->where('agt_stat<', 5);
        return $builder->get();
    }
    public function _getshu($id)
    {
        $builder = $this->db->table('trxshudtl');
        $builder->select('*');
        $builder->join('tblanggota', 'trxshudtl.agt_numb=tblanggota.agt_numb', 'inner');
        $builder->join('tblcompany', 'trxshudtl.com_code=tblcompany.com_code', 'inner');
        $builder->where('shu_year', $id);
        $builder->orderBy('trxshudtl.agt_numb', 'asc');
        return $builder->get();
    }

    public function _get_saldotabungan($id)
    {
        $builder = $this->db->table('v_saldo_tabungan');
        $builder->select('tbg_code,sum(trx_amnt) as trx_amnt');
        $builder->where('tbg_code', $id);
        $builder->groupBy('tbg_code');
        return $builder->get();
    }
    public function saldotabungan($id)
    {
        $builder = $this->db->table('trxkastabungan');
        $builder->select('sum(kin_crdt-kin_debt) as kin_awal');
        $builder->where('trxkastabungan.tbg_code', $id);
        return $builder->get();
    }
    public function _saldo_kartuhutang($id)
    {
        $builder = $this->db->table('v_saldo_hutang_anggota');
        $builder->select('*');
        $builder->join('tblanggota', 'v_saldo_hutang_anggota.agt_numb=tblanggota.agt_numb', 'inner');
        $builder->join('trxkontrak', 'v_saldo_hutang_anggota.trx_code=trxkontrak.knt_code', 'inner');
        $builder->join('tblproduct', 'trxkontrak.prd_code=tblproduct.prd_code', 'inner');
        $builder->where('trx_code', $id);
        return $builder->get();
    }

    public function _saldo_kartuhutang_id($id)
    {
        $builder = $this->db->table('v_saldo_hutang_anggota');
        $builder->select('*');
        $builder->join('tblanggota', 'v_saldo_hutang_anggota.agt_numb=tblanggota.agt_numb', 'inner');
        $builder->join('trxkontrak', 'v_saldo_hutang_anggota.trx_code=trxkontrak.knt_code', 'inner');
        $builder->join('tblproduct', 'trxkontrak.prd_code=tblproduct.prd_code', 'inner');
        $builder->where('trxkontrak.id', $id);
        return $builder->get();
    }
    public function _get_dpembiayaan($id)
    {
        $builder = $this->db->table('trxcashcost');
        $builder->select('*');
        $builder->join('tblanggota', 'trxcashcost.agt_numb=tblanggota.agt_numb', 'left');
        $builder->join('tblbank', 'trxcashcost.bnk_code=tblbank.bnk_code', 'left');
        $builder->where('trxcashcost.kin_code', $id);
        $builder->where('trxcashcost.kin_tran', 0);
        return $builder->get();
    }

    public function _get_cashssb($tanggal, $cabang)
    {
        $builder = $this->db->table('trxkasssb');
        $builder->select('*');
        $builder->join('tblanggota', 'trxkasssb.agt_numb=tblanggota.agt_numb', 'left');
        $builder->join('tblbank', 'trxkasssb.bnk_code=tblbank.bnk_code', 'left');
        $builder->where('trxkasssb.kin_date', $tanggal);
        $builder->where('trxkasssb.kode_cabang', $cabang);
        return $builder->get();
    }
    public function _get_cashssba($tanggal)
    {
        $builder = $this->db->table('trxkasssb');
        $builder->select('*');
        $builder->join('tblanggota', 'trxkasssb.agt_numb=tblanggota.agt_numb', 'left');
        $builder->join('tblbank', 'trxkasssb.bnk_code=tblbank.bnk_code', 'left');
        $builder->where('trxkasssb.kin_date', $tanggal);

        return $builder->get();
    }
    public function _get_editcashssb($id)
    {
        $builder = $this->db->table('trxkasssb');
        $builder->select('*');
        $builder->join('tblanggota', 'trxkasssb.agt_numb=tblanggota.agt_numb', 'left');
        $builder->join('tblbank', 'trxkasssb.bnk_code=tblbank.bnk_code', 'left');
        $builder->where('trxkasssb.kin_code', $id);
        return $builder->get();
    }

    public function _get_rekssb()
    {
        $builder = $this->db->table('trxpenempatan');
        $builder->select('*');
        $builder->join('tblanggota', 'trxpenempatan.agt_numb=tblanggota.agt_numb', 'left');
        $builder->join('tblproduct', 'trxpenempatan.prd_code=tblproduct.prd_code', 'left');
        $builder->where('pen_stat<', 2);
        return $builder->get();
    }

    public function _get_databasil($id)
    {
        $builder = $this->db->table('trxjasamdb');
        $builder->select('*');
        $builder->join('tblanggota', 'trxjasamdb.agt_numb=tblanggota.agt_numb', 'inner');
        $builder->join('tblproduct', 'trxjasamdb.prd_code=tblproduct.prd_code', 'inner');
        $builder->where('tbg_code', $id);
        $builder->orderBy('jas_date', 'desc');
        $builder->limit(1);
        return $builder->get();
    }

    public function _get_databasil_id($id)
    {
        $builder = $this->db->table('trxjasamdb');
        $builder->select('*');
        $builder->join('tblanggota', 'trxjasamdb.agt_numb=tblanggota.agt_numb', 'inner');
        $builder->join('tblproduct', 'trxjasamdb.prd_code=tblproduct.prd_code', 'inner');
        $builder->join('trxpenempatan', 'trxjasamdb.tbg_code=trxpenempatan.pen_code', 'inner');
        $builder->where('trxpenempatan.id', $id);
        $builder->orderBy('jas_date', 'desc');
        $builder->limit(1);
        return $builder->get();
    }
    public function _get_dtdeposito($id)
    {
        $builder = $this->db->table('trxpenempatan');
        $builder->select('*');
        $builder->join('tblanggota', 'trxpenempatan.agt_numb=tblanggota.agt_numb', 'left');
        $builder->join('tblproduct', 'trxpenempatan.prd_code=tblproduct.prd_code', 'left');
        $builder->where('pen_code', $id);
        return $builder->get();
    }

    public function _get_dtdeposito_id($id)
    {
        $builder = $this->db->table('trxpenempatan');
        $builder->select('*');
        $builder->join('tblanggota', 'trxpenempatan.agt_numb=tblanggota.agt_numb', 'left');
        $builder->join('tblproduct', 'trxpenempatan.prd_code=tblproduct.prd_code', 'left');
        $builder->where('trxpenempatan.id', $id);
        return $builder->get();
    }
    public function _get_dtpenutupan($id)
    {
        $builder = $this->db->table('trxpenempatan');
        $builder->select('*');
        $builder->where('pen_code', $id);
        // $builder = $this->db->table('trxpenutupan');
        // $builder->select('*');
        // $builder->join('tblanggota', 'trxpenutupan.agt_numb=tblanggota.agt_numb', 'inner');
        $builder->join('tblproduct', 'trxpenempatan.prd_code=tblproduct.prd_code', 'inner');
        // $builder->where('pen_code', $id);
        return $builder->get();
    }
    public function _get_dtpenutupan_id($id)
    {
        $builder = $this->db->table('trxpenempatan');
        $builder->select('*');
        $builder->where('trxpenempatan.id', $id);
        // $builder = $this->db->table('trxpenutupan');
        // $builder->select('*');
        // $builder->join('tblanggota', 'trxpenutupan.agt_numb=tblanggota.agt_numb', 'inner');
        $builder->join('tblproduct', 'trxpenempatan.prd_code=tblproduct.prd_code', 'inner');
        // $builder->where('pen_code', $id);
        return $builder->get();
    }
    public function _get_anggotaclose($id)
    {
        $builder = $this->db->table('tblanggota');
        $builder->select('*');
        $builder->join('tblagtclose', 'tblanggota.agt_numb=tblagtclose.agt_numb', 'inner');
        $builder->where('agt_numb', $id);
        return $builder->get();
    }

    public function _get_saldoawal()
    {
        $builder = $this->db->table('accouddb');
        $builder->select('*');
        $builder->join('tblaccount', 'accouddb.acc_code=tblaccount.acc_code', 'inner');
        $builder->where('acc_type', 'AWL');
        return $builder->get();
    }
    public function _get_editsaldoawal($id)
    {
        $builder = $this->db->table('accouddb');
        $builder->select('*');
        $builder->join('tblaccount', 'accouddb.acc_code=tblaccount.acc_code', 'inner');
        $builder->where('accouddb.acc_code', $id);
        return $builder->get();
    }

    public function get_tottabungan($agt_numb, $tgl)
    {
        $builder = $this->db->table('trxkastabungan');
        $builder->select('acc_prod,prd_code,sum(kin_crdt-kin_debt as trx_saldo)');
        $builder->where('agt_numb', $agt_numb);
        $builder->where('kin_date<=', $tgl);
        $builder->groupBy('acc_prod,prd_code');

        return $builder->get();
    }

    public function _get_tabunganagt($id)
    {
        $builder = $this->db->table('trxtabungan');
        $builder->select('tbg_code');
        $builder->where('agt_numb', $id);
        return $builder->get();
    }

    public function _get_hutang($id)
    {
        $builder = $this->db->table('v_saldohutang1');
        $builder->select('*');
        $builder->where('agt_numb', $id);
        return $builder->get();
    }
    public function _get_saldominimum($id)
    {
        $builder = $this->db->table('tblproduct');
        $builder->select('*');
        $builder->where('prd_code', $id);
        return $builder->get();
    }

    public function _get_agunan($id)
    {
        $builder = $this->db->table('trxpenagunan');
        $builder->select('*');
        $builder->join('tbljnsagunan', 'trxpenagunan.agn_type=tbljnsagunan.jns_idno', 'inner');
        $builder->where('knt_code', $id);
        $builder->orderBy('knt_cod1', 'asc');
        return $builder->get();
    }

    public function get_getdbakses($id)
    {
        $builder = $this->db->table('tblformakses');
        $builder->select('*');
        $builder->where('username', $id);
        return $builder->get();
    }

    public function _get_menuakses($id)
    {
        $builder = $this->db->table('tblform');
        $builder->select('*');
        $builder->where('frm_code', $id);
        return $builder->get();
    }
    public function _get_newmenuakses()
    {
        $builder = $this->db->table('tblform');
        $builder->select('*');
        // $builder->where('frm_code', $id);
        return $builder->get();
    }
    public function _getawaltabungan($tanggal)
    {
        $builder = $this->db->table('trxkastabungan');
        $builder->select('sum(kin_crdt-kin_debt) as tbg_awal');
        $builder->where('kin_date<', $tanggal);
        return $builder->get();
    }

    public function get_niltabunganawal($norekening, $tanggal)
    {
        return $this->db->table('trxkastabungan')
            ->select('sum(kin_crdt-kin_debt) as tbg_awal')
            ->where(array('tbg_code' => $norekening, 'kin_date<' => $tanggal))
            ->get()->getRowArray();
    }

    public function get_niltabunganrek($norekening, $tanggal1, $tanggal2)
    {
        return $this->db->table('trxkastabungan')
            ->select('sum(kin_crdt) as tbg_crdt,sum(kin_debt) as tbg_debt')
            ->where(array('tbg_code' => $norekening, 'kin_date>=' => $tanggal1, 'kin_year<=' => $tanggal2))
            ->get()->getRowArray();
    }
    public function get_tabungan()
    {
        $builder = $this->db->table('trxtabungan');
        $builder->select('*');
        $builder->join('tblproduct', 'trxtabungan.prd_code=tblproduct.prd_code', 'left');
        $builder->where('tbg_stat!=', '2');
        return $builder->get();
    }

    public function _get_salawalkredit($norekening, $tanggal)
    {
        return $this->db->table('krtdebit')
            ->select('sum(trx_lnsh) as tbg_bayr')
            ->where(array('trx_code' => $norekening, 'bkt_date<' => $tanggal))
            ->get()->getRowArray();
    }

    public function _get_niltransbiaya1($norekening, $tanggal1, $tanggal2)
    {
        return $this->db->table('trxcashcost')
            ->select('sum(trx_amnh) as knt_debt,sum(trx_lnsh) as knt_krdt')
            ->where(array('trx_code' => $norekening, 'bkt_date>=' => $tanggal1, 'bkt_date<=' => $tanggal2))
            ->get()->getRowArray();
    }
    public function _get_niltransbiaya($norekening, $tanggal1, $tanggal2)
    {
        return $this->db->table('krtdebit')
            ->select('sum(trx_amnh) as knt_debt,sum(trx_lnsh) as knt_krdt')
            ->where(array('trx_code' => $norekening, 'bkt_date>=' => $tanggal1, 'bkt_date<=' => $tanggal2))
            ->get()->getRowArray();
    }
    public function _get_tabcolectif($tanggal, $cabang)
    {
        $builder = $this->db->table('trxtabcolhdb');
        $builder->select('*');
        $builder->orderby('tcl_code', 'desc');
        $builder->where('tcl_date', $tanggal);
        $builder->where('trxtabcolhdb.kode_cabang', $cabang);
        return $builder->get();
    }

    public function _get_tabcolectifa($tanggal)
    {
        $builder = $this->db->table('trxtabcolhdb');
        $builder->select('*');
        $builder->orderby('tcl_code', 'desc');
        $builder->where('tcl_date', $tanggal);

        return $builder->get();
    }
    public function _get_edtabcolectif($id)
    {
        $builder = $this->db->table('trxtabcolhdb');
        $builder->select('trxtabcolhdb.*,trxtabcolddb.tbg_code,tcl_amnt,trxtabcolddb.acc_code as acc_cod1,tblbank.*,trxtabcolddb.tcl_cod1,trxtabungan.agt_numb');
        $builder->join('trxtabcolddb', 'trxtabcolhdb.tcl_code=trxtabcolddb.tcl_code', 'inner');
        $builder->join('tblbank', 'trxtabcolhdb.bnk_code=tblbank.bnk_code', 'left');
        $builder->join('trxtabungan', 'trxtabcolddb.tbg_code=trxtabungan.tbg_code', 'left');
        // $builder->join('tblanggota', 'trxtabungan.agt_numb=tblanggota.agt_numb', 'left');
        $builder->where('trxtabcolhdb.tcl_code', $id);
        $builder->orderby('trxtabcolhdb.tcl_code', 'desc');
        return $builder->get();
    }

    public function get_accpembiayaan($id)
    {
        $builder = $this->db->table('trxkontrak');
        $builder->select('*');
        $builder->join('tblproduct', 'trxkontrak.prd_code=tblproduct.prd_code', 'inner');
        $builder->where('trxkontrak.knt_code', $id);

        return $builder->get();
    }

    public function _rptkasumum($tanggal1, $tanggal2, $jeniskas)
    {
        $builder = $this->db->table('trxpencairan');
        $builder->select('trxpencairandtl.*,trxpencairan.kot_date');
        $builder->join('trxpencairandtl', 'trxpencairan.kot_code=trxpencairandtl.kot_code', 'left');
        $builder->join('tblbank', 'trxpencairan.bnk_code=tblbank.bnk_code', 'left');
        $builder->join('tblcompany', 'trxpencairan.com_code=tblcompany.com_code', 'left');
        // $builder->join('kodetransteller', 'trxpencairandtl.kode_trans=kodetransteller.kode_trans', 'left');
        $builder->where('trxpencairan.kot_date>=', $tanggal1);
        $builder->where('trxpencairan.kot_date<=', $tanggal2);
        $builder->where('trxpencairan.bnk_code', $jeniskas);
        // $builder->where('trxpencairan.kot_type<=', $jenistrans);
        $builder->orderBy('trxpencairan.kot_date', 'asc');
        $builder->orderBy('trxpencairan.kot_type', 'asc');
        return $builder->get();
    }
    public function _rptkasumumcab($tanggal1, $tanggal2, $jeniskas, $cabang)
    {
        $builder = $this->db->table('trxpencairan');
        $builder->select('trxpencairandtl.*,trxpencairan.kot_date');
        $builder->join('trxpencairandtl', 'trxpencairan.kot_code=trxpencairandtl.kot_code', 'left');
        $builder->join('tblbank', 'trxpencairan.bnk_code=tblbank.bnk_code', 'left');
        $builder->join('tblcompany', 'trxpencairan.com_code=tblcompany.com_code', 'left');
        $builder->join('kodetransteller', 'trxpencairandtl.kode_trans=kodetransteller.kode_trans', 'left');
        $builder->where('trxpencairan.kot_date>=', $tanggal1);
        $builder->where('trxpencairan.kot_date<=', $tanggal2);
        $builder->where('trxpencairan.bnk_code', $jeniskas);
        $builder->where('trxpencairan.kode_cabang', $cabang);
        $builder->orderBy('trxpencairan.kot_date', 'asc');
        $builder->orderBy('trxpencairan.kot_type', 'asc');
        return $builder->get();
    }
    public function _get_awalkas($tanggal1, $jeniskas)
    {
        $builder = $this->db->table('accouddb');
        $builder->select('*');
        $builder->join('tblbank', 'accouddb.acc_code=tblbank.acc_code', 'inner');
        $builder->where('tblbank.bnk_code', $jeniskas);
        $builder->where('accouddb.acc_date<=', $tanggal1);
        $builder->orderBy('accouddb.acc_date', 'desc');
        $builder->limit(1);
        return $builder->get();
    }
    public function _get_awalkascab($tanggal1, $jeniskas, $cabang)
    {
        $builder = $this->db->table('accouddb');
        $builder->select('*');
        $builder->join('tblbank', 'accouddb.acc_code=tblbank.acc_code', 'inner');
        $builder->where('tblbank.bnk_code', $jeniskas);
        $builder->where('accouddb.acc_date<=', $tanggal1);
        $builder->where('accouddb.kode_cabang', $cabang);
        $builder->orderBy('accouddb.acc_date', 'desc');
        $builder->limit(1);
        return $builder->get();
    }
    public function _delkasumum($tanggal1, $tanggal2)
    {
        $builder = $this->db->table('trxpencairan');
        $builder->where('trxpencairan.kot_date>=', $tanggal1);
        $builder->where('trxpencairan.kot_date<=', $tanggal2);
        $builder->orderBy('trxpencairan.kot_date', 'asc');

        return $builder->get();
    }

    public function _get_loaddtssb($tanggal1, $tanggal2)
    {
        $builder = $this->db->table('trxkasssb');
        $builder->select('*');
        $builder->join('tblanggota', 'trxkasssb.agt_numb=tblanggota.agt_numb', 'left');
        $builder->where('trxkasssb.kin_date>=', $tanggal1);
        $builder->where('trxkasssb.kin_date<=', $tanggal2);
        $builder->orderBy('trxkasssb.kin_date', 'asc');
        return $builder->get();
    }

    public function _getdelpenempatan($tanggal1, $tanggal2)
    {
        $builder = $this->db->table('trxkasssb');
        $builder->select('*');
        $builder->join('tblanggota', 'trxkasssb.agt_numb=tblanggota.agt_numb', 'left');
        $builder->where('trxkasssb.kin_date>=', $tanggal1);
        $builder->where('trxkasssb.kin_date<=', $tanggal2);
        $builder->orderBy('trxkasssb.kin_date', 'asc');
        return $builder->get();
    }

    public function _get_loaddpembiyaan($tanggal1, $tanggal2)
    {
        $builder = $this->db->table('trxcashcost');
        $builder->select('*');
        $builder->join('tblanggota', 'trxcashcost.agt_numb=tblanggota.agt_numb', 'left');
        $builder->where('trxcashcost.kin_date>=', $tanggal1);
        $builder->where('trxcashcost.kin_date<=', $tanggal2);
        $builder->orderBy('trxcashcost.kin_date', 'asc');
        return $builder->get();
    }

    public function _get_loadjasa($tanggal1, $tanggal2, $id)
    {
        $builder = $this->db->table('trxjasamdb');
        $builder->select('*');
        $builder->join('tblanggota', 'trxjasamdb.agt_numb=tblanggota.agt_numb', 'inner');
        $builder->where('trxjasamdb.jas_date>=', $tanggal1);
        $builder->where('trxjasamdb.jas_date<=', $tanggal2);
        $builder->where('trxjasamdb.jas_jens', $id);
        $builder->orderBy('trxjasamdb.tbg_code', 'asc');
        return $builder->get();
    }

    public function _get_agtrektabungan($id)
    {
        $builder = $this->db->table('trxtabungan');
        $builder->select('*');
        $builder->where('agt_numb', $id);

        return $builder->get();
    }

    public function _get_getrektabungan($id)
    {
        $builder = $this->db->table('trxtabungan');
        $builder->select('*');


        return $builder->get();
    }
    public function _get_totalhutang($id)
    {
        $builder = $this->db->table('krtdebit');
        $builder->select('SUM( trx_pokk-lns_pokk) AS saldohutang,SUM(trx_bung-lns_bung) AS sisabunga,SUM(trx_dend) AS denda');
        $builder->where('trx_code', $id);
        $builder->groupBy('trx_code');

        return $builder->get();
    }

    public function _get_dttkreapp($tanggal1, $tanggal2)
    {
        $builder = $this->db->table('trxkreapp');
        $builder->select('*');
        $builder->where('kap_date>=', $tanggal1);
        $builder->where('kap_date<=', $tanggal2);
        return $builder->get();
    }

    public function _get_kolektor($id)
    {
        $builder = $this->db->table('tblemployee');
        $builder->select('*');
        $builder->join('tblkelompok', 'tblemployee.emp_code=tblkelompok.emp_code', 'inner');
        $builder->where('kel_code', $id);
        return $builder->get();
    }

    public function _get_emptabungan($id)
    {

        $builder = $this->db->table('trxtabungan');
        $builder->select('*');
        $builder->join('tblanggota', 'trxtabungan.agt_numb=tblanggota.agt_numb', 'left');
        $builder->join('tblproduct', 'trxtabungan.prd_code=tblproduct.prd_code', 'left');
        $builder->where('trxtabungan.tbg_stat<=', 1);
        $builder->where('trxtabungan.col_code>=', $id);

        return $builder->get();
    }

    function   _get_tgltabungan($id, $tanggal, $bulan, $tahun)
    {

        return $this->db->table('trxkastabungan')
            ->where(array('tbg_code' => $id, 'kin_date<' => $tanggal, 'kin_mont' => $bulan, 'kin_year' => $tahun))
            ->orderBy('kin_date', 'asc')
            ->limit(1)
            ->get()->getRowArray();
    }

    public function _get_tgltabungan1($id, $tanggal, $bulan, $tahun)
    {
        $builder = $this->db->table('trxkastabungan');
        $builder->select('kin_code');
        $builder->where('tbg_code', $id);
        $builder->where('kin_date<', $tanggal);
        $builder->where('kin_mont', $bulan);
        $builder->where('kin_year', $tahun);
        $builder->orderBy('kin_date', 'asc');
        $builder->limit(1);
        return $builder->get();
    }

    public function _fin_product($id)
    {
        $builder = $this->db->table('tblproduct');
        $builder->select('*');
        $builder->where('prd_code', $id);
        return $builder->get();
    }
    public function get_dtakuncabang($id)
    {
        $builder = $this->db->table('manajemen_cabang');
        $builder->select('*');
        $builder->where('kode_cabang', $id);
        return $builder->get();
    }

    public function _get_cekgroupuser($id)
    {
        $builder = $this->db->table('manajemen_group');
        $builder->select('*');
        $builder->where('grp_code', $id);
        return $builder->get();
    }
    public function _getcoscolectif($tanggal)
    {
        $builder = $this->db->table('trxkascoscolhdb');
        $builder->select('*');
        $builder->where('ccl_date', $tanggal);
        return $builder->get();
    }

    public function _getcoscolectifcab($tanggal, $cabang)
    {
        $builder = $this->db->table('trxkascoscolhdb');
        $builder->select('*');
        $builder->where('ccl_date', $tanggal);
        $builder->where('kode_cabang', $cabang);
        return $builder->get();
    }


    public function _editgetcoscolectif($id)
    {
        $builder = $this->db->table('trxkascoscolhdb');
        $builder->select('*');
        $builder->join('trxkascoscolddb', 'trxkascoscolhdb.ccl_code=trxkascoscolddb.ccl_code', 'left');
        $builder->join('tblanggota', 'trxkascoscolddb.agt_numb=tblanggota.agt_numb', 'left');
        $builder->where('trxkascoscolhdb.ccl_code', $id);
        return $builder->get();
    }

    public function _getcoscolectifdtl($id)
    {
        $builder = $this->db->table('trxkascoscolhdb');
        $builder->select('*');
        $builder->where('ccl_code', $id);
        return $builder->get();
    }

    public function _get_daftabungan($tanggal1, $tanggal2)
    {
        $builder = $this->db->table('trxtabungan');
        $builder->select('trxtabungan.*,agt_name,prd_name,tblproduct.acc_code,tblproduct.acc_cod1,tblproduct.acc_cod2,tblproduct.acc_cod3');
        $builder->join('tblanggota', 'trxtabungan.agt_numb=tblanggota.agt_numb', 'left');
        $builder->join('tblproduct', 'trxtabungan.prd_code=tblproduct.prd_code', 'left');

        return $builder->get();
    }

    public function _get_daftabungancab($tanggal1, $tanggal2, $cabang)
    {
        $builder = $this->db->table('trxtabungan');
        $builder->select('trxtabungan.*,agt_name,prd_name,tblproduct.acc_code,tblproduct.acc_cod1,tblproduct.acc_cod2,tblproduct.acc_cod3');
        $builder->join('tblanggota', 'trxtabungan.agt_numb=tblanggota.agt_numb', 'left');
        $builder->join('tblproduct', 'trxtabungan.prd_code=tblproduct.prd_code', 'left');
        $builder->where('trxtabungan.kode_cabang', $cabang);
        return $builder->get();
    }

    public function _get_dafssb($tangal1, $tanggal2)
    {
        $builder = $this->db->table('trxpenempatan');
        $builder->select('*');
        $builder->join('tblanggota', 'trxpenempatan.agt_numb=tblanggota.agt_numb', 'left');
        $builder->join('tblproduct', 'trxpenempatan.prd_code=tblproduct.prd_code', 'left');


        return $builder->get();
    }

    public function _get_dafssbcaab($tangal1, $tanggal2, $cabang)
    {
        $builder = $this->db->table('trxpenempatan');
        $builder->select('*');
        $builder->join('tblanggota', 'trxpenempatan.agt_numb=tblanggota.agt_numb', 'left');
        $builder->join('tblproduct', 'trxpenempatan.prd_code=tblproduct.prd_code', 'left');
        $builder->where('trxpenempatan.kode_cabang', $cabang);

        return $builder->get();
    }

    public function _get_dftpembiayaan($tangal1, $tanggal2)
    {
        $builder = $this->db->table('trxkontrak');
        $builder->select('*');
        $builder->join('tblproduct', 'trxkontrak.prd_code=tblproduct.prd_code', 'left');
        $builder->join('tblanggota', 'trxkontrak.agt_numb=tblanggota.agt_numb', 'left');
        // $builder->where('trxkontrak.knt_date', $tanggal);
        // $builder->where('trxkontrak.kode_cabang', $cabang);
        return $builder->get();
    }
    public function _get_dftpembiayaancab($tangal1, $tanggal2, $cabang)
    {
        $builder = $this->db->table('trxkontrak');
        $builder->select('*');
        $builder->join('tblproduct', 'trxkontrak.prd_code=tblproduct.prd_code', 'left');
        $builder->join('tblanggota', 'trxkontrak.agt_numb=tblanggota.agt_numb', 'left');
        // $builder->where('trxkontrak.knt_date', $tanggal);
        $builder->where('trxkontrak.kode_cabang', $cabang);
        return $builder->get();
    }

    public function _getakhir()
    {
        $builder = $this->db->table('akhirmdb');
        $builder->select('*');

        return $builder->get();
    }

    public function _getkodepos($id)
    {
        $builder = $this->db->table('tblkodepos');
        $builder->select('*');
        $builder->where('tblkodepos.kot_code', $id);
        return $builder->get();
    }

    public function _get_acchutang($id)
    {
        $builder = $this->db->table('trxkontrak');
        $builder->select('tblproduct.prd_name,tblproduct.acc_code,trxkontrak.prd_code,trxkontrak.tbg_code');
        $builder->join('tblproduct', 'trxkontrak.prd_code=tblproduct.prd_code', 'left');
        $builder->where('trxkontrak.knt_code', $id);
        $builder->limit(1);
        return $builder->get();
    }


    public function _get_norekeingauto($id)
    {
        $builder = $this->db->table('trxkontrak');
        $builder->select('tbg_code');
        $builder->where('trxkontrak.knt_code', $id);
        $builder->limit(1);
        return $builder->get();
    }

    public function _get_finfanggotasma()
    {
        $builder = $this->db->table('tblsama');
        $builder->select('*');
        $builder->orderBy('id', 'asc');
        return $builder->get();
    }

    public function _get_finfanggotasma1($id)
    {
        $builder = $this->db->table('trxtabungan');
        $builder->select('*');
        $builder->where('trxtabungan.tbg_name', $id);

        return $builder->get();
    }

    public function _get_finfanggota($id, $id2)
    {
        $builder = $this->db->table('tblanggota');
        $builder->select('*');
        $builder->where('tblanggota.agt_name', $id);
        $builder->where('tblanggota.agt_adrs', $id2);

        return $builder->get();
    }
    public function _get_findsimpanan()
    {
        $builder = $this->db->table('trxtabungan');
        $builder->select('*');
        return $builder->get();
    }

    public function _get_tabunganfind($start, $length, $search = '')
    {

        $builder = $this->db->table('trxtabungan');
        $builder->select('trxtabungan.*,agt_name,prd_name');
        $builder->join('tblanggota', 'trxtabungan.agt_numb=tblanggota.agt_numb', 'inner');
        $builder->join('tblproduct', 'trxtabungan.prd_code=tblproduct.prd_code', 'inner');
        $builder->where('trxtabungan.tbg_stat<', '2');

        $recordsTotal = $builder->countAllResults(false);
        //echo $length;
        $builder->limit($length, $start);
        $builder->orderBy('tbg_code', 'asc');
        if ($search != '') {
            $builder->like('agt_name', $search);
            $builder->orLike(
                'prd_name',
                $search
            );
            $builder->orLike(
                'tbg_code',
                $search
            );
        }
        $recordsFiltered = $builder->countAllResults(false);
        return array('recordsTotal' => $recordsTotal, 'recordsFiltered' => $recordsFiltered, 'data' => $builder->get()->getResult());
    }


    public function _get_skbfind($start, $length, $search = '')
    {

        $builder = $this->db->table('trxpenempatan');
        $builder->select('*');
        // $builder->join('trxkontrak', 'v_saldohutang1.trx_code=trxkontrak.knt_code', 'inner');
        $builder->join('tblanggota', 'trxpenempatan.agt_numb=tblanggota.agt_numb', 'inner');
        $builder->join('tblproduct', 'trxpenempatan.prd_code=tblproduct.prd_code', 'inner');
        $builder->where('trxpenempatan.pen_stat<', 2);
        // $builder->where('v_saldohutang1.saldo>', 0);
        $recordsTotal = $builder->countAllResults(false);
        //echo $length;
        $builder->limit($length, $start);
        $builder->orderBy('pen_code', 'asc');
        if ($search != '') {
            $builder->like('agt_name', $search);
            $builder->orLike(
                'prd_name',
                $search
            );
            $builder->orLike(
                'pen_code',
                $search
            );
        }
        $recordsFiltered = $builder->countAllResults(false);
        return array('recordsTotal' => $recordsTotal, 'recordsFiltered' => $recordsFiltered, 'data' => $builder->get()->getResult());
    }

public function _get_dttotangsuran($id, $id1)
    {
        $builder = $this->db->table('trxcashcost');
        $builder->select('sum(kin_angs) as kin_angs,sum(kin_pokk) as kin_pokk,sum(kin_bung) as kin_bung');
        $builder->where('trxcashcost.knt_code', $id);
        $builder->where('trxcashcost.kin_angk', $id1);

        return $builder->get();
    }
    //End----------------------
}
