<?php

session_start();

$tanggal = $v_simpanan[0]->trx_date;
$bulan = date('M', strtotime($tanggal));
$tahun = date('Y', strtotime($tanggal));
$bulan = date('M');
function penyebut($nilai)
{
    $nilai = abs($nilai);
    $huruf = array("", "Satu", "Dua", "Tiga", "Empat", "Lima", "Enam", "Tujuh", "Delapan", "Sembilan", "Sepuluh", "Sebelas");
    $temp = "";
    if ($nilai < 12) {
        $temp = " " . $huruf[$nilai];
    } else if ($nilai < 20) {
        $temp = penyebut($nilai - 10) . " Belas";
    } else if ($nilai < 100) {
        $temp = penyebut($nilai / 10) . " Puluh" . penyebut($nilai % 10);
    } else if ($nilai < 200) {
        $temp = " Seratus" . penyebut($nilai - 100);
    } else if ($nilai < 1000) {
        $temp = penyebut($nilai / 100) . " Ratus" . penyebut($nilai % 100);
    } else if ($nilai < 2000) {
        $temp = " Seribu" . penyebut($nilai - 1000);
    } else if ($nilai < 1000000) {
        $temp = penyebut($nilai / 1000) . " Ribu" . penyebut($nilai % 1000);
    } else if ($nilai < 1000000000) {
        $temp = penyebut($nilai / 1000000) . " Juta" . penyebut($nilai % 1000000);
    } else if ($nilai < 1000000000000) {
        $temp = penyebut($nilai / 1000000000) . " Miliar" . penyebut(fmod($nilai, 1000000000));
    } else if ($nilai < 1000000000000000) {
        $temp = penyebut($nilai / 1000000000000) . " Triliun" . penyebut(fmod($nilai, 1000000000000));
    }
    return $temp;
}

function terbilang($nilai)
{
    if ($nilai < 0) {
        $hasil = "Minus " . trim(penyebut($nilai));
    } else {
        $hasil = trim(penyebut($nilai)) . " Rupiah";
    }
    return $hasil;
}
?>
<!-- <!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml"> -->

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />
    <link rel="icon" href="../assets/images/print.png" type="../assets/images/png">
    <title>Transaksi Tabungan</title>
</head>
<style type="text/css">
    /* Kode CSS Untuk PAGE ini dibuat oleh http://jsfiddle.net/2wk6Q/1/ */
    body {
        width: 100%;
        height: 100%;
        margin: 0;
        padding: 0;
        background-color: #ffffff;
        font: 12pt "Tahoma";
    }

    * {
        box-sizing: border-box;
        -moz-box-sizing: border-box;
    }

    hr {
        height: 3px;
        background-color: black;
        color: black;
    }

    .page {
        width: 210mm;
        min-height: 297mm;
        padding: 10mm;
        margin: 10mm auto;
        border: 1px #D3D3D3 solid;
        border-radius: 5px;
        background: white;
    }

    .subpage {
        padding: 0;
        border: none;
        height: 277mm;
    }

    table {
        border-collapse: collapse;
    }

    table,
    th,
    td {
        border: 1px black solid;
    }

    th,
    td {
        padding: 6px;
    }

    strong {
        font-size: 10pt;
    }

    @page {
        size: A4;
        margin: 10;

    }

    @media print {

        html,
        body {
            width: 210mm;
            height: 297mm;
        }

        hr {
            height: 3px;
            background-color: black;
            color: black;
        }

        .page {
            margin: 0;
            border: initial;
            border-radius: initial;
            width: initial;
            min-height: initial;
            box-shadow: initial;
            background: initial;
            page-break-after: always;
        }
    }
</style>

<body>
    <div class="book">
        <div class="page">
            <div class="subpage">
                <div style="display: flex;">
                    <div style="display: flex; flex: 60%;">
                        <img src="<?php echo base_url('assets/images/' . $v_tabungan[0]->com_logo) ?>" style="width: 90px; height: 75px; padding: 6px;">
                        <div style="margin-top: -10px; padding: 0 10px;">
                            <h4><?php echo $v_tabungan[0]->com_name ?> </h4>
                            <p style="margin-top: -20px;"><?php echo $v_tabungan[0]->com_tags   ?> </p>

                            <p style="margin-top: -15px; font-size: 8pt;"><?php echo $v_tabungan[0]->com_adrs  ?> </p>
                        </div>
                    </div>
                    <div style="flex: 30%; margin-top: -10px;">
                        <p style="font-size: 7pt;">
                            <!-- JL. KALASAN II No. 9<br>
                            KOMPLEK NEW PHARMINDO<br>
                            BANDUNG 40534<br> -->

                        </p>
                    </div>
                </div>
                <p style="font-size: 12pt;text-align: center;">TRANSAKSI TABUNGAN </p>
                <p style="font-size: 10pt;text-align: center;">TANGGAL : <?php echo date('d/m/Y', strtotime($tgl1)) . ' S/D ' . date('d/m/Y', strtotime($tgl2)) ?> </p>

                <div style="margin-top: -10px;">
                    <hr>
                    <hr style="margin-top: -7px;">
                </div>

                <p style="font-size: 7pt;">
                <div style="display: flex; width: 100%;">

                    < </div>
                        <div style="margin-top: 10px;">
                            <table class="table-ivc" id="IvcTable" style="width: 100%;">
                                <thead style="font-size: 8pt;">
                                    <tr>
                                    <tr>

                                        <th width="1%" style="text-align:center ;">No. </th>
                                        <th width="10%" style="text-align:center ;">Tanggal </th>
                                        <td width="11%" style="text-align:center ;">No. Rekening</td>
                                        <td width="7%" style="text-align:center ;">Kode </td>
                                        <td width="10%" style="text-align:center ;">Jenis </td>
                                        <td width="19" style="text-align:center ;">Reff</td>
                                        <td width="10%" style="text-align:center ;">User</td>
                                        <td width="10%" style="text-align:center ;" hidden>User App</td>
                                        <td width="10%" style="text-align:center ;">Setoran</td>
                                        <td width="10%" style="text-align:center ;">Penarikan</td>
                                        <td width="10%" style="text-align:center ;">Saldo</td>

                                <tbody id="tbody1" style="font-size: 8pt;">
                                    <?php $i = 0;
                                    $saldo = 0;
                                    $totsaldo = 0; ?>

                                    <?php foreach ($v_tabungan as $row) : $i = $i + 1;
                                        if ($row->kin_dbcr == 'K') {
                                            $v_penarikan = 0;
                                            $v_setor = $row->kin_totl;
                                        } else {
                                            $v_penarikan = $row->kin_totl;
                                            $v_setor = 0;
                                        }
                                        $saldo = $v_setor - $v_penarikan; // $saldo +
                                        $totsaldo = $totsaldo + $saldo;
                                        if ($row->kin_jens == 1) {
                                            $jenis = "Setoran";
                                        } else if ($row->kin_jens == 2) {
                                            $jenis = "Penarikan";
                                        } else if ($row->kin_jens == 3) {
                                            $jenis = "Penutupan";
                                        } else if ($row->kin_jens == 4) {
                                            $jenis = "Transfer";
                                        } else {
                                            $jenis = "";
                                        }
                                    ?>


                                        <tr>
                                            <td><?= $i; ?></td>
                                            <td><?= date('d/m/Y', strtotime($row->kin_date)); ?></td>
                                            <td><?= $row->tbg_code; ?></td>
                                            <td style="text-align:center ;"><?= $row->kin_jens; ?></td>
                                            <td><?= $jenis; ?></td>
                                            <td><?= $row->kin_code; ?></td>
                                            <td><?= $row->kin_user; ?></td>
                                            <td hidden><?= $row->kin_apus; ?></td>
                                            <td style="text-align:right ;"><?= number_format($v_setor); ?></td>
                                            <td style="text-align:right ;"><?= number_format($v_penarikan); ?></td>
                                            <td style="text-align:right ;"><?= number_format($saldo); ?></td>



                                        </tr>






                                    <?php endforeach; ?>
                                    <tr>

                                        <td colspan="6" style="text-align: right;">
                                            <strong>TOTAL SALDO TABUNGAN</strong>
                                        </td>

                                        <td style="text-align:right ;" colspan="4"><?= number_format($totsaldo); ?></td>


                                    </tr>



                                </tbody>
                            </table>
                        </div>

                </div>

                <!-- <div class="page">
                <div class="subpage"></div>
            </div> -->

            </div>
</body>

</html>
<script type="text/javascript">
    window.print();
</script>